package o;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedStateListDrawable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.autofill.AutofillManager;
import android.widget.CompoundButton;
import com.google.android.gms.common.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class YN extends C2974y7 {
    public static final int[] J = {R.attr.state_indeterminate};
    public static final int[] K = {R.attr.state_error};
    public static final int[][] L = {new int[]{android.R.attr.state_enabled, R.attr.state_error}, new int[]{android.R.attr.state_enabled, android.R.attr.state_checked}, new int[]{android.R.attr.state_enabled, -16842912}, new int[]{-16842910, android.R.attr.state_checked}, new int[]{-16842910, -16842912}};
    public static final int M = Resources.getSystem().getIdentifier("btn_check_material_anim", "drawable", "android");
    public ColorStateList A;
    public PorterDuff.Mode B;
    public int C;
    public int[] D;
    public boolean E;
    public CharSequence F;
    public CompoundButton.OnCheckedChangeListener G;
    public final G6 H;
    public final WN I;
    public final LinkedHashSet p;
    public final LinkedHashSet q;
    public ColorStateList r;
    public boolean s;
    public boolean t;
    public boolean u;
    public CharSequence v;
    public Drawable w;
    public Drawable x;
    public boolean y;
    public ColorStateList z;

    public YN(Context context, AttributeSet attributeSet) throws Resources.NotFoundException {
        super(AbstractC2378rs0.n0(context, attributeSet, R.attr.checkboxStyle, R.style.Widget_MaterialComponents_CompoundButton_CheckBox), attributeSet, R.attr.checkboxStyle);
        this.p = new LinkedHashSet();
        this.q = new LinkedHashSet();
        Context context2 = getContext();
        G6 g6 = new G6(context2, 0);
        Resources resources = context2.getResources();
        Resources.Theme theme = context2.getTheme();
        ThreadLocal threadLocal = AbstractC3060z20.a;
        Drawable drawable = resources.getDrawable(R.drawable.mtrl_checkbox_button_checked_unchecked, theme);
        g6.l = drawable;
        drawable.setCallback(g6.q);
        new F6(g6.l.getConstantState());
        this.H = g6;
        this.I = new WN(this);
        Context context3 = getContext();
        this.w = getButtonDrawable();
        this.z = getSuperButtonTintList();
        setSupportButtonTintList(null);
        YT.l(context3, attributeSet, R.attr.checkboxStyle, R.style.Widget_MaterialComponents_CompoundButton_CheckBox);
        int[] iArr = XZ.n;
        YT.n(context3, attributeSet, iArr, R.attr.checkboxStyle, R.style.Widget_MaterialComponents_CompoundButton_CheckBox, new int[0]);
        TypedArray typedArrayObtainStyledAttributes = context3.obtainStyledAttributes(attributeSet, iArr, R.attr.checkboxStyle, R.style.Widget_MaterialComponents_CompoundButton_CheckBox);
        C70 c70 = new C70(context3, typedArrayObtainStyledAttributes);
        this.x = c70.m(2);
        if (this.w != null && C80.U(context3, R.attr.isMaterial3Theme, false)) {
            int resourceId = typedArrayObtainStyledAttributes.getResourceId(0, 0);
            int resourceId2 = typedArrayObtainStyledAttributes.getResourceId(1, 0);
            if (resourceId == M && resourceId2 == 0) {
                super.setButtonDrawable((Drawable) null);
                this.w = C80.x(context3, R.drawable.mtrl_checkbox_button);
                this.y = true;
                if (this.x == null) {
                    this.x = C80.x(context3, R.drawable.mtrl_checkbox_button_icon);
                }
            }
        }
        this.A = AbstractC2461sm0.r(context3, c70, 3);
        this.B = Co0.J(typedArrayObtainStyledAttributes.getInt(4, -1), PorterDuff.Mode.SRC_IN);
        this.s = typedArrayObtainStyledAttributes.getBoolean(10, false);
        this.t = typedArrayObtainStyledAttributes.getBoolean(6, true);
        this.u = typedArrayObtainStyledAttributes.getBoolean(9, false);
        this.v = typedArrayObtainStyledAttributes.getText(8);
        if (typedArrayObtainStyledAttributes.hasValue(7)) {
            setCheckedState(typedArrayObtainStyledAttributes.getInt(7, 0));
        }
        c70.t();
        a();
    }

    private String getButtonStateDescription() {
        int i = this.C;
        return i == 1 ? getResources().getString(R.string.mtrl_checkbox_state_description_checked) : i == 0 ? getResources().getString(R.string.mtrl_checkbox_state_description_unchecked) : getResources().getString(R.string.mtrl_checkbox_state_description_indeterminate);
    }

    private ColorStateList getMaterialThemeColorsTintList() {
        if (this.r == null) {
            int iS = AbstractC1692kh0.s(this, R.attr.colorControlActivated);
            int iS2 = AbstractC1692kh0.s(this, R.attr.colorError);
            int iS3 = AbstractC1692kh0.s(this, R.attr.colorSurface);
            int iS4 = AbstractC1692kh0.s(this, R.attr.colorOnSurface);
            this.r = new ColorStateList(L, new int[]{AbstractC1692kh0.D(1.0f, iS3, iS2), AbstractC1692kh0.D(1.0f, iS3, iS), AbstractC1692kh0.D(0.54f, iS3, iS4), AbstractC1692kh0.D(0.38f, iS3, iS4), AbstractC1692kh0.D(0.38f, iS3, iS4)});
        }
        return this.r;
    }

    private ColorStateList getSuperButtonTintList() {
        ColorStateList colorStateList = this.z;
        return colorStateList != null ? colorStateList : super.getButtonTintList() != null ? super.getButtonTintList() : getSupportButtonTintList();
    }

    public final void a() {
        ColorStateList colorStateList;
        ColorStateList colorStateList2;
        X0 x0;
        Drawable drawableMutate = this.w;
        ColorStateList colorStateList3 = this.z;
        PorterDuff.Mode buttonTintMode = getButtonTintMode();
        if (drawableMutate == null) {
            drawableMutate = null;
        } else if (colorStateList3 != null) {
            drawableMutate = drawableMutate.mutate();
            if (buttonTintMode != null) {
                drawableMutate.setTintMode(buttonTintMode);
            }
        }
        this.w = drawableMutate;
        Drawable drawableMutate2 = this.x;
        ColorStateList colorStateList4 = this.A;
        PorterDuff.Mode mode = this.B;
        if (drawableMutate2 == null) {
            drawableMutate2 = null;
        } else if (colorStateList4 != null) {
            drawableMutate2 = drawableMutate2.mutate();
            if (mode != null) {
                drawableMutate2.setTintMode(mode);
            }
        }
        this.x = drawableMutate2;
        if (this.y) {
            G6 g6 = this.H;
            if (g6 != null) {
                E6 e6 = g6.m;
                Drawable drawable = g6.l;
                WN wn = this.I;
                if (drawable != null) {
                    AnimatedVectorDrawable animatedVectorDrawable = (AnimatedVectorDrawable) drawable;
                    if (wn.a == null) {
                        wn.a = new C1643k6(wn);
                    }
                    animatedVectorDrawable.unregisterAnimationCallback(wn.a);
                }
                ArrayList arrayList = g6.p;
                if (arrayList != null && wn != null) {
                    arrayList.remove(wn);
                    if (g6.p.size() == 0 && (x0 = g6.f133o) != null) {
                        e6.b.removeListener(x0);
                        g6.f133o = null;
                    }
                }
                Drawable drawable2 = g6.l;
                if (drawable2 != null) {
                    AnimatedVectorDrawable animatedVectorDrawable2 = (AnimatedVectorDrawable) drawable2;
                    if (wn.a == null) {
                        wn.a = new C1643k6(wn);
                    }
                    animatedVectorDrawable2.registerAnimationCallback(wn.a);
                } else if (wn != null) {
                    if (g6.p == null) {
                        g6.p = new ArrayList();
                    }
                    if (!g6.p.contains(wn)) {
                        g6.p.add(wn);
                        if (g6.f133o == null) {
                            g6.f133o = new X0(1, g6);
                        }
                        e6.b.addListener(g6.f133o);
                    }
                }
            }
            Drawable drawable3 = this.w;
            if ((drawable3 instanceof AnimatedStateListDrawable) && g6 != null) {
                ((AnimatedStateListDrawable) drawable3).addTransition(R.id.checked, R.id.unchecked, g6, false);
                ((AnimatedStateListDrawable) this.w).addTransition(R.id.indeterminate, R.id.unchecked, g6, false);
            }
        }
        Drawable drawable4 = this.w;
        if (drawable4 != null && (colorStateList2 = this.z) != null) {
            drawable4.setTintList(colorStateList2);
        }
        Drawable drawable5 = this.x;
        if (drawable5 != null && (colorStateList = this.A) != null) {
            drawable5.setTintList(colorStateList);
        }
        Drawable drawable6 = this.w;
        Drawable drawable7 = this.x;
        if (drawable6 == null) {
            drawable6 = drawable7;
        } else if (drawable7 != null) {
            int intrinsicWidth = drawable7.getIntrinsicWidth();
            if (intrinsicWidth == -1) {
                intrinsicWidth = drawable6.getIntrinsicWidth();
            }
            int intrinsicHeight = drawable7.getIntrinsicHeight();
            if (intrinsicHeight == -1) {
                intrinsicHeight = drawable6.getIntrinsicHeight();
            }
            if (intrinsicWidth > drawable6.getIntrinsicWidth() || intrinsicHeight > drawable6.getIntrinsicHeight()) {
                float f = intrinsicWidth / intrinsicHeight;
                if (f >= drawable6.getIntrinsicWidth() / drawable6.getIntrinsicHeight()) {
                    int intrinsicWidth2 = drawable6.getIntrinsicWidth();
                    intrinsicHeight = (int) (intrinsicWidth2 / f);
                    intrinsicWidth = intrinsicWidth2;
                } else {
                    intrinsicHeight = drawable6.getIntrinsicHeight();
                    intrinsicWidth = (int) (f * intrinsicHeight);
                }
            }
            LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{drawable6, drawable7});
            layerDrawable.setLayerSize(1, intrinsicWidth, intrinsicHeight);
            layerDrawable.setLayerGravity(1, 17);
            drawable6 = layerDrawable;
        }
        super.setButtonDrawable(drawable6);
        refreshDrawableState();
    }

    @Override // android.widget.CompoundButton
    public Drawable getButtonDrawable() {
        return this.w;
    }

    public Drawable getButtonIconDrawable() {
        return this.x;
    }

    public ColorStateList getButtonIconTintList() {
        return this.A;
    }

    public PorterDuff.Mode getButtonIconTintMode() {
        return this.B;
    }

    @Override // android.widget.CompoundButton
    public ColorStateList getButtonTintList() {
        return this.z;
    }

    public int getCheckedState() {
        return this.C;
    }

    public CharSequence getErrorAccessibilityLabel() {
        return this.v;
    }

    @Override // android.widget.CompoundButton, android.widget.Checkable
    public final boolean isChecked() {
        return this.C == 1;
    }

    @Override // android.widget.TextView, android.view.View
    public final void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.s && this.z == null && this.A == null) {
            setUseMaterialThemeColors(true);
        }
    }

    @Override // android.widget.CompoundButton, android.widget.TextView, android.view.View
    public final int[] onCreateDrawableState(int i) {
        int[] iArrCopyOf;
        int[] iArrOnCreateDrawableState = super.onCreateDrawableState(i + 2);
        if (getCheckedState() == 2) {
            View.mergeDrawableStates(iArrOnCreateDrawableState, J);
        }
        if (this.u) {
            View.mergeDrawableStates(iArrOnCreateDrawableState, K);
        }
        int i2 = 0;
        while (true) {
            if (i2 >= iArrOnCreateDrawableState.length) {
                iArrCopyOf = Arrays.copyOf(iArrOnCreateDrawableState, iArrOnCreateDrawableState.length + 1);
                iArrCopyOf[iArrOnCreateDrawableState.length] = 16842912;
                break;
            }
            int i3 = iArrOnCreateDrawableState[i2];
            if (i3 == 16842912) {
                iArrCopyOf = iArrOnCreateDrawableState;
                break;
            }
            if (i3 == 0) {
                iArrCopyOf = (int[]) iArrOnCreateDrawableState.clone();
                iArrCopyOf[i2] = 16842912;
                break;
            }
            i2++;
        }
        this.D = iArrCopyOf;
        return iArrOnCreateDrawableState;
    }

    @Override // android.widget.CompoundButton, android.widget.TextView, android.view.View
    public final void onDraw(Canvas canvas) {
        Drawable buttonDrawable;
        if (!this.t || !TextUtils.isEmpty(getText()) || (buttonDrawable = getButtonDrawable()) == null) {
            super.onDraw(canvas);
            return;
        }
        int width = ((getWidth() - buttonDrawable.getIntrinsicWidth()) / 2) * (Co0.H(this) ? -1 : 1);
        int iSave = canvas.save();
        canvas.translate(width, 0.0f);
        super.onDraw(canvas);
        canvas.restoreToCount(iSave);
        if (getBackground() != null) {
            Rect bounds = buttonDrawable.getBounds();
            getBackground().setHotspotBounds(bounds.left + width, bounds.top, bounds.right + width, bounds.bottom);
        }
    }

    @Override // android.view.View
    public final void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        if (accessibilityNodeInfo != null && this.u) {
            accessibilityNodeInfo.setText(((Object) accessibilityNodeInfo.getText()) + ", " + ((Object) this.v));
        }
    }

    @Override // android.widget.CompoundButton, android.widget.TextView, android.view.View
    public final void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof XN)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        XN xn = (XN) parcelable;
        super.onRestoreInstanceState(xn.getSuperState());
        setCheckedState(xn.l);
    }

    @Override // android.widget.CompoundButton, android.widget.TextView, android.view.View
    public final Parcelable onSaveInstanceState() {
        XN xn = new XN(super.onSaveInstanceState());
        xn.l = getCheckedState();
        return xn;
    }

    @Override // o.C2974y7, android.widget.CompoundButton
    public void setButtonDrawable(int i) {
        setButtonDrawable(C80.x(getContext(), i));
    }

    public void setButtonIconDrawable(Drawable drawable) {
        this.x = drawable;
        a();
    }

    public void setButtonIconDrawableResource(int i) {
        setButtonIconDrawable(C80.x(getContext(), i));
    }

    public void setButtonIconTintList(ColorStateList colorStateList) {
        if (this.A == colorStateList) {
            return;
        }
        this.A = colorStateList;
        a();
    }

    public void setButtonIconTintMode(PorterDuff.Mode mode) {
        if (this.B == mode) {
            return;
        }
        this.B = mode;
        a();
    }

    @Override // android.widget.CompoundButton
    public void setButtonTintList(ColorStateList colorStateList) {
        if (this.z == colorStateList) {
            return;
        }
        this.z = colorStateList;
        a();
    }

    @Override // android.widget.CompoundButton
    public void setButtonTintMode(PorterDuff.Mode mode) {
        setSupportButtonTintMode(mode);
        a();
    }

    public void setCenterIfNoTextEnabled(boolean z) {
        this.t = z;
    }

    @Override // android.widget.CompoundButton, android.widget.Checkable
    public void setChecked(boolean z) {
        setCheckedState(z ? 1 : 0);
    }

    public void setCheckedState(int i) {
        AutofillManager autofillManager;
        CompoundButton.OnCheckedChangeListener onCheckedChangeListener;
        if (this.C != i) {
            this.C = i;
            super.setChecked(i == 1);
            refreshDrawableState();
            int i2 = Build.VERSION.SDK_INT;
            if (i2 >= 30 && this.F == null) {
                super.setStateDescription(getButtonStateDescription());
            }
            if (this.E) {
                return;
            }
            this.E = true;
            LinkedHashSet linkedHashSet = this.q;
            if (linkedHashSet != null) {
                Iterator it = linkedHashSet.iterator();
                if (it.hasNext()) {
                    it.next().getClass();
                    throw new ClassCastException();
                }
            }
            if (this.C != 2 && (onCheckedChangeListener = this.G) != null) {
                onCheckedChangeListener.onCheckedChanged(this, isChecked());
            }
            if (i2 >= 26 && (autofillManager = (AutofillManager) getContext().getSystemService(AutofillManager.class)) != null) {
                autofillManager.notifyValueChanged(this);
            }
            this.E = false;
        }
    }

    @Override // android.widget.TextView, android.view.View
    public void setEnabled(boolean z) {
        super.setEnabled(z);
    }

    public void setErrorAccessibilityLabel(CharSequence charSequence) {
        this.v = charSequence;
    }

    public void setErrorAccessibilityLabelResource(int i) {
        setErrorAccessibilityLabel(i != 0 ? getResources().getText(i) : null);
    }

    public void setErrorShown(boolean z) {
        if (this.u == z) {
            return;
        }
        this.u = z;
        refreshDrawableState();
        Iterator it = this.p.iterator();
        if (it.hasNext()) {
            it.next().getClass();
            throw new ClassCastException();
        }
    }

    @Override // android.widget.CompoundButton
    public void setOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        this.G = onCheckedChangeListener;
    }

    @Override // android.widget.CompoundButton, android.view.View
    public void setStateDescription(CharSequence charSequence) {
        this.F = charSequence;
        if (charSequence != null) {
            super.setStateDescription(charSequence);
        } else {
            if (Build.VERSION.SDK_INT < 30 || charSequence != null) {
                return;
            }
            super.setStateDescription(getButtonStateDescription());
        }
    }

    public void setUseMaterialThemeColors(boolean z) {
        this.s = z;
        if (z) {
            setButtonTintList(getMaterialThemeColorsTintList());
        } else {
            setButtonTintList(null);
        }
    }

    @Override // android.widget.CompoundButton, android.widget.Checkable
    public final void toggle() {
        setChecked(!isChecked());
    }

    @Override // o.C2974y7, android.widget.CompoundButton
    public void setButtonDrawable(Drawable drawable) {
        this.w = drawable;
        this.y = false;
        a();
    }
}
