package o;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.Log;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class SS implements Handler.Callback, ServiceConnection {
    public final Context a;
    public final Handler b;
    public final HashMap c = new HashMap();
    public HashSet d = new HashSet();

    public SS(Context context) {
        this.a = context;
        HandlerThread handlerThread = new HandlerThread("NotificationManagerCompat");
        handlerThread.start();
        this.b = new Handler(handlerThread.getLooper(), this);
    }

    public final void a(RS rs) {
        boolean z;
        ArrayDeque arrayDeque = rs.d;
        ComponentName componentName = rs.a;
        if (Log.isLoggable("NotifManCompat", 3)) {
            Objects.toString(componentName);
            arrayDeque.size();
        }
        if (arrayDeque.isEmpty()) {
            return;
        }
        if (rs.b) {
            z = true;
        } else {
            Intent component = new Intent("android.support.BIND_NOTIFICATION_SIDE_CHANNEL").setComponent(componentName);
            Context context = this.a;
            boolean zBindService = context.bindService(component, this, 33);
            rs.b = zBindService;
            if (zBindService) {
                rs.e = 0;
            } else {
                Objects.toString(componentName);
                context.unbindService(this);
            }
            z = rs.b;
        }
        if (!z || rs.c == null) {
            b(rs);
            return;
        }
        while (true) {
            PS ps = (PS) arrayDeque.peek();
            if (ps == null) {
                break;
            }
            try {
                if (Log.isLoggable("NotifManCompat", 3)) {
                    ps.toString();
                }
                ((C0989dG) rs.c).B(ps.a, ps.b);
                arrayDeque.remove();
            } catch (DeadObjectException unused) {
                if (Log.isLoggable("NotifManCompat", 3)) {
                    Objects.toString(componentName);
                }
            } catch (RemoteException unused2) {
                Objects.toString(componentName);
            }
        }
        if (arrayDeque.isEmpty()) {
            return;
        }
        b(rs);
    }

    public final void b(RS rs) {
        ComponentName componentName = rs.a;
        ArrayDeque arrayDeque = rs.d;
        Handler handler = this.b;
        if (handler.hasMessages(3, componentName)) {
            return;
        }
        int i = rs.e + 1;
        rs.e = i;
        if (i <= 6) {
            Log.isLoggable("NotifManCompat", 3);
            handler.sendMessageDelayed(handler.obtainMessage(3, componentName), (1 << r4) * 1000);
        } else {
            arrayDeque.size();
            Objects.toString(componentName);
            arrayDeque.clear();
        }
    }

    @Override // android.os.Handler.Callback
    public final boolean handleMessage(Message message) {
        HashSet hashSet;
        int i = message.what;
        InterfaceC1084eG interfaceC1084eG = null;
        if (i == 0) {
            PS ps = (PS) message.obj;
            String string = Settings.Secure.getString(this.a.getContentResolver(), "enabled_notification_listeners");
            synchronized (TS.c) {
                if (string != null) {
                    try {
                        if (!string.equals(TS.d)) {
                            String[] strArrSplit = string.split(":", -1);
                            HashSet hashSet2 = new HashSet(strArrSplit.length);
                            for (String str : strArrSplit) {
                                ComponentName componentNameUnflattenFromString = ComponentName.unflattenFromString(str);
                                if (componentNameUnflattenFromString != null) {
                                    hashSet2.add(componentNameUnflattenFromString.getPackageName());
                                }
                            }
                            TS.e = hashSet2;
                            TS.d = string;
                        }
                    } catch (Throwable th) {
                        throw th;
                    }
                }
                hashSet = TS.e;
            }
            if (!hashSet.equals(this.d)) {
                this.d = hashSet;
                List<ResolveInfo> listQueryIntentServices = this.a.getPackageManager().queryIntentServices(new Intent().setAction("android.support.BIND_NOTIFICATION_SIDE_CHANNEL"), 0);
                HashSet hashSet3 = new HashSet();
                for (ResolveInfo resolveInfo : listQueryIntentServices) {
                    if (hashSet.contains(resolveInfo.serviceInfo.packageName)) {
                        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                        ComponentName componentName = new ComponentName(serviceInfo.packageName, serviceInfo.name);
                        if (resolveInfo.serviceInfo.permission != null) {
                            componentName.toString();
                        } else {
                            hashSet3.add(componentName);
                        }
                    }
                }
                Iterator it = hashSet3.iterator();
                while (it.hasNext()) {
                    ComponentName componentName2 = (ComponentName) it.next();
                    if (!this.c.containsKey(componentName2)) {
                        if (Log.isLoggable("NotifManCompat", 3)) {
                            Objects.toString(componentName2);
                        }
                        this.c.put(componentName2, new RS(componentName2));
                    }
                }
                Iterator it2 = this.c.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry = (Map.Entry) it2.next();
                    if (!hashSet3.contains(entry.getKey())) {
                        if (Log.isLoggable("NotifManCompat", 3)) {
                            Objects.toString(entry.getKey());
                        }
                        RS rs = (RS) entry.getValue();
                        if (rs.b) {
                            this.a.unbindService(this);
                            rs.b = false;
                        }
                        rs.c = null;
                        it2.remove();
                    }
                }
            }
            for (RS rs2 : this.c.values()) {
                rs2.d.add(ps);
                a(rs2);
            }
        } else if (i == 1) {
            QS qs = (QS) message.obj;
            ComponentName componentName3 = qs.a;
            IBinder iBinder = qs.b;
            RS rs3 = (RS) this.c.get(componentName3);
            if (rs3 != null) {
                int i2 = NS.d;
                if (iBinder != null) {
                    IInterface iInterfaceQueryLocalInterface = iBinder.queryLocalInterface(InterfaceC1084eG.a);
                    if (iInterfaceQueryLocalInterface == null || !(iInterfaceQueryLocalInterface instanceof InterfaceC1084eG)) {
                        C0989dG c0989dG = new C0989dG();
                        c0989dG.d = iBinder;
                        interfaceC1084eG = c0989dG;
                    } else {
                        interfaceC1084eG = (InterfaceC1084eG) iInterfaceQueryLocalInterface;
                    }
                }
                rs3.c = interfaceC1084eG;
                rs3.e = 0;
                a(rs3);
                return true;
            }
        } else if (i == 2) {
            RS rs4 = (RS) this.c.get((ComponentName) message.obj);
            if (rs4 != null) {
                if (rs4.b) {
                    this.a.unbindService(this);
                    rs4.b = false;
                }
                rs4.c = null;
                return true;
            }
        } else {
            if (i != 3) {
                return false;
            }
            RS rs5 = (RS) this.c.get((ComponentName) message.obj);
            if (rs5 != null) {
                a(rs5);
                return true;
            }
        }
        return true;
    }

    @Override // android.content.ServiceConnection
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable("NotifManCompat", 3)) {
            Objects.toString(componentName);
        }
        this.b.obtainMessage(1, new QS(componentName, iBinder)).sendToTarget();
    }

    @Override // android.content.ServiceConnection
    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable("NotifManCompat", 3)) {
            Objects.toString(componentName);
        }
        this.b.obtainMessage(2, componentName).sendToTarget();
    }
}
