package o;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.os.SystemClock;
import android.util.Base64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class L30 implements InterfaceC0463Rw, InterfaceC0918cc0, InterfaceC1025di {
    public static final C0618Xv q = new C0618Xv("proto");
    public final K40 l;
    public final C2616uQ m;
    public final C2616uQ n;

    /* renamed from: o, reason: collision with root package name */
    public final C0364Ob f204o;
    public final CZ p;

    public L30(C2616uQ c2616uQ, C2616uQ c2616uQ2, C0364Ob c0364Ob, K40 k40, CZ cz) {
        this.l = k40;
        this.m = c2616uQ;
        this.n = c2616uQ2;
        this.f204o = c0364Ob;
        this.p = cz;
    }

    public static Long c(SQLiteDatabase sQLiteDatabase, C2156pc c2156pc) {
        StringBuilder sb = new StringBuilder("backend_name = ? and priority = ?");
        ArrayList arrayList = new ArrayList(Arrays.asList(c2156pc.a, String.valueOf(JY.a(c2156pc.c))));
        byte[] bArr = c2156pc.b;
        if (bArr != null) {
            sb.append(" and extras = ?");
            arrayList.add(Base64.encodeToString(bArr, 0));
        } else {
            sb.append(" and extras is null");
        }
        Cursor cursorQuery = sQLiteDatabase.query("transport_contexts", new String[]{"_id"}, sb.toString(), (String[]) arrayList.toArray(new String[0]), null, null, null);
        try {
            return !cursorQuery.moveToNext() ? null : Long.valueOf(cursorQuery.getLong(0));
        } finally {
            cursorQuery.close();
        }
    }

    public static String l(Iterable iterable) {
        StringBuilder sb = new StringBuilder("(");
        Iterator it = iterable.iterator();
        while (it.hasNext()) {
            sb.append(((C0917cc) it.next()).a);
            if (it.hasNext()) {
                sb.append(',');
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public static Object m(Cursor cursor, J30 j30) {
        try {
            return j30.apply(cursor);
        } finally {
            cursor.close();
        }
    }

    public final SQLiteDatabase b() {
        K40 k40 = this.l;
        Objects.requireNonNull(k40);
        C2616uQ c2616uQ = this.n;
        long jU = c2616uQ.u();
        while (true) {
            try {
                return k40.getWritableDatabase();
            } catch (SQLiteDatabaseLockedException e) {
                if (c2616uQ.u() >= this.f204o.c + jU) {
                    throw new C0727ac0("Timed out while trying to open db.", e);
                }
                SystemClock.sleep(50L);
            }
        }
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable
    public final void close() {
        this.l.close();
    }

    public final Object d(J30 j30) {
        SQLiteDatabase sQLiteDatabaseB = b();
        sQLiteDatabaseB.beginTransaction();
        try {
            Object objApply = j30.apply(sQLiteDatabaseB);
            sQLiteDatabaseB.setTransactionSuccessful();
            return objApply;
        } finally {
            sQLiteDatabaseB.endTransaction();
        }
    }

    public final ArrayList f(SQLiteDatabase sQLiteDatabase, C2156pc c2156pc, int i) {
        ArrayList arrayList = new ArrayList();
        Long lC = c(sQLiteDatabase, c2156pc);
        if (lC == null) {
            return arrayList;
        }
        m(sQLiteDatabase.query("events", new String[]{"_id", "transport_name", "timestamp_ms", "uptime_ms", "payload_encoding", "payload", "code", "inline", "product_id", "pseudonymous_id", "experiment_ids_clear_blob", "experiment_ids_encrypted_blob"}, "context_id = ?", new String[]{lC.toString()}, null, null, null, String.valueOf(i)), new C3034yo(this, arrayList, c2156pc, 4));
        return arrayList;
    }

    public final void g(long j, GM gm, String str) {
        d(new C0480Sn(j, str, gm));
    }

    public final Object j(InterfaceC0823bc0 interfaceC0823bc0) {
        SQLiteDatabase sQLiteDatabaseB = b();
        C2616uQ c2616uQ = this.n;
        long jU = c2616uQ.u();
        while (true) {
            try {
                sQLiteDatabaseB.beginTransaction();
                try {
                    Object objD = interfaceC0823bc0.d();
                    sQLiteDatabaseB.setTransactionSuccessful();
                    return objD;
                } finally {
                    sQLiteDatabaseB.endTransaction();
                }
            } catch (SQLiteDatabaseLockedException e) {
                if (c2616uQ.u() >= this.f204o.c + jU) {
                    throw new C0727ac0("Timed out while trying to acquire the lock.", e);
                }
                SystemClock.sleep(50L);
            }
        }
    }
}
