package o;

import android.app.BroadcastOptions;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final /* synthetic */ class Ir0 implements InterfaceC0761at0 {
    public final Kr0 l;

    public /* synthetic */ Ir0(Kr0 kr0) {
        this.l = kr0;
    }

    public boolean a() {
        Nq0 nq0 = this.l.f;
        Kr0.l(nq0);
        return Log.isLoggable(nq0.C(), 3);
    }

    @Override // o.InterfaceC0761at0
    public void b(int i, Throwable th, byte[] bArr) {
        int i2;
        Nq0 nq0;
        Nq0 nq02;
        Kr0 kr0 = this.l;
        Nq0 nq03 = kr0.f;
        if (i != 200 && i != 204) {
            i2 = 304;
            if (i != 304) {
                i2 = i;
            }
            Kr0.l(nq03);
            nq03.i.d("Network Request for Deferred Deep Link failed. response, exception", Integer.valueOf(i2), th);
        }
        i2 = i;
        if (th == null) {
            C1617jr0 c1617jr0 = kr0.e;
            Kr0.j(c1617jr0);
            c1617jr0.t.b(true);
            if (bArr == null || bArr.length == 0) {
                Kr0.l(nq03);
                nq03.m.b("Deferred Deep Link response empty.");
                return;
            }
            try {
                JSONObject jSONObject = new JSONObject(new String(bArr));
                String strOptString = jSONObject.optString("deeplink", "");
                if (TextUtils.isEmpty(strOptString)) {
                    Kr0.l(nq03);
                    nq03.m.b("Deferred Deep Link is empty.");
                    return;
                }
                String strOptString2 = jSONObject.optString("gclid", "");
                String strOptString3 = jSONObject.optString("gbraid", "");
                String strOptString4 = jSONObject.optString("gad_source", "");
                double dOptDouble = jSONObject.optDouble("timestamp", 0.0d);
                Bundle bundle = new Bundle();
                C2574tv0 c2574tv0 = kr0.i;
                Kr0.j(c2574tv0);
                Kr0 kr02 = (Kr0) c2574tv0.a;
                if (TextUtils.isEmpty(strOptString)) {
                    nq02 = nq03;
                } else {
                    Context context = kr02.a;
                    nq02 = nq03;
                    try {
                        List<ResolveInfo> listQueryIntentActivities = context.getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse(strOptString)), 0);
                        if (listQueryIntentActivities != null && !listQueryIntentActivities.isEmpty()) {
                            if (!TextUtils.isEmpty(strOptString3)) {
                                bundle.putString("gbraid", strOptString3);
                            }
                            if (!TextUtils.isEmpty(strOptString4)) {
                                bundle.putString("gad_source", strOptString4);
                            }
                            bundle.putString("gclid", strOptString2);
                            bundle.putString("_cis", "ddp");
                            kr0.m.z("auto", "_cmp", bundle);
                            if (TextUtils.isEmpty(strOptString)) {
                                return;
                            }
                            try {
                                SharedPreferences.Editor editorEdit = context.getSharedPreferences("google.analytics.deferred.deeplink.prefs", 0).edit();
                                editorEdit.putString("deeplink", strOptString);
                                editorEdit.putLong("timestamp", Double.doubleToRawLongBits(dOptDouble));
                                if (editorEdit.commit()) {
                                    Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                                    Context context2 = kr02.a;
                                    if (Build.VERSION.SDK_INT < 34) {
                                        context2.sendBroadcast(intent);
                                        return;
                                    } else {
                                        context2.sendBroadcast(intent, null, BroadcastOptions.makeBasic().setShareIdentityEnabled(true).toBundle());
                                        return;
                                    }
                                }
                                return;
                            } catch (RuntimeException e) {
                                Nq0 nq04 = ((Kr0) c2574tv0.a).f;
                                Kr0.l(nq04);
                                nq04.f.c(e, "Failed to persist Deferred Deep Link. exception");
                                return;
                            }
                        }
                    } catch (JSONException e2) {
                        e = e2;
                        nq0 = nq02;
                        Kr0.l(nq0);
                        nq0.f.c(e, "Failed to parse the Deferred Deep Link response. exception");
                        return;
                    }
                }
                Kr0.l(nq02);
                nq0 = nq02;
                try {
                    nq0.i.e("Deferred Deep Link validation failed. gclid, gbraid, deep link", strOptString2, strOptString3, strOptString);
                    return;
                } catch (JSONException e3) {
                    e = e3;
                    Kr0.l(nq0);
                    nq0.f.c(e, "Failed to parse the Deferred Deep Link response. exception");
                    return;
                }
            } catch (JSONException e4) {
                e = e4;
                nq0 = nq03;
            }
        }
        Kr0.l(nq03);
        nq03.i.d("Network Request for Deferred Deep Link failed. response, exception", Integer.valueOf(i2), th);
    }

    public void c(String str, Bundle bundle) {
        String string;
        Kr0 kr0 = this.l;
        Fr0 fr0 = kr0.g;
        C1617jr0 c1617jr0 = kr0.e;
        Kr0.l(fr0);
        fr0.r();
        if (kr0.a()) {
            return;
        }
        if (bundle.isEmpty()) {
            string = null;
        } else {
            if (true == str.isEmpty()) {
                str = "auto";
            }
            Uri.Builder builder = new Uri.Builder();
            builder.path(str);
            for (String str2 : bundle.keySet()) {
                builder.appendQueryParameter(str2, bundle.getString(str2));
            }
            string = builder.build().toString();
        }
        if (TextUtils.isEmpty(string)) {
            return;
        }
        Kr0.j(c1617jr0);
        c1617jr0.w.h(string);
        c1617jr0.x.b(kr0.k.currentTimeMillis());
    }

    public boolean d() {
        if (!e()) {
            return false;
        }
        Kr0 kr0 = this.l;
        long jCurrentTimeMillis = kr0.k.currentTimeMillis();
        C1617jr0 c1617jr0 = kr0.e;
        Kr0.j(c1617jr0);
        return jCurrentTimeMillis - c1617jr0.x.a() > kr0.d.z(null, AbstractC1900mq0.j0);
    }

    public boolean e() {
        C1617jr0 c1617jr0 = this.l.e;
        Kr0.j(c1617jr0);
        return c1617jr0.x.a() > 0;
    }

    public Ir0(C2758vs0 c2758vs0, Kr0 kr0) {
        this.l = kr0;
    }
}
