package o;

import android.R;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.InputFilter;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.textclassifier.TextClassifier;
import android.widget.TextView;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class E8 extends TextView {
    public final C2689v7 l;
    public final A8 m;
    public final DH n;

    /* renamed from: o, reason: collision with root package name */
    public Y7 f99o;
    public boolean p;
    public OD q;
    public Future r;

    public E8(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.textViewStyle);
    }

    private Y7 getEmojiTextViewHelper() {
        if (this.f99o == null) {
            this.f99o = new Y7(this);
        }
        return this.f99o;
    }

    @Override // android.widget.TextView, android.view.View
    public final void drawableStateChanged() {
        super.drawableStateChanged();
        C2689v7 c2689v7 = this.l;
        if (c2689v7 != null) {
            c2689v7.i();
        }
        A8 a8 = this.m;
        if (a8 != null) {
            a8.b();
        }
    }

    @Override // android.widget.TextView
    public int getAutoSizeMaxTextSize() {
        if (AbstractC2457sk0.c) {
            return super.getAutoSizeMaxTextSize();
        }
        A8 a8 = this.m;
        if (a8 != null) {
            return Math.round(a8.i.e);
        }
        return -1;
    }

    @Override // android.widget.TextView
    public int getAutoSizeMinTextSize() {
        if (AbstractC2457sk0.c) {
            return super.getAutoSizeMinTextSize();
        }
        A8 a8 = this.m;
        if (a8 != null) {
            return Math.round(a8.i.d);
        }
        return -1;
    }

    @Override // android.widget.TextView
    public int getAutoSizeStepGranularity() {
        if (AbstractC2457sk0.c) {
            return super.getAutoSizeStepGranularity();
        }
        A8 a8 = this.m;
        if (a8 != null) {
            return Math.round(a8.i.c);
        }
        return -1;
    }

    @Override // android.widget.TextView
    public int[] getAutoSizeTextAvailableSizes() {
        if (AbstractC2457sk0.c) {
            return super.getAutoSizeTextAvailableSizes();
        }
        A8 a8 = this.m;
        return a8 != null ? a8.i.f : new int[0];
    }

    @Override // android.widget.TextView
    public int getAutoSizeTextType() {
        if (AbstractC2457sk0.c) {
            return super.getAutoSizeTextType() == 1 ? 1 : 0;
        }
        A8 a8 = this.m;
        if (a8 != null) {
            return a8.i.a;
        }
        return 0;
    }

    @Override // android.widget.TextView
    public ActionMode.Callback getCustomSelectionActionModeCallback() {
        return F3.V(super.getCustomSelectionActionModeCallback());
    }

    @Override // android.widget.TextView
    public int getFirstBaselineToTopHeight() {
        return getPaddingTop() - getPaint().getFontMetricsInt().top;
    }

    @Override // android.widget.TextView
    public int getLastBaselineToBottomHeight() {
        return getPaddingBottom() + getPaint().getFontMetricsInt().bottom;
    }

    public B8 getSuperCaller() {
        if (this.q == null) {
            int i = Build.VERSION.SDK_INT;
            if (i >= 34) {
                this.q = new D8(this);
            } else if (i >= 28) {
                this.q = new C8(this);
            } else if (i >= 26) {
                this.q = new OD(9, this);
            }
        }
        return this.q;
    }

    public ColorStateList getSupportBackgroundTintList() {
        C2689v7 c2689v7 = this.l;
        if (c2689v7 != null) {
            return c2689v7.j();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        C2689v7 c2689v7 = this.l;
        if (c2689v7 != null) {
            return c2689v7.k();
        }
        return null;
    }

    public ColorStateList getSupportCompoundDrawablesTintList() {
        return this.m.d();
    }

    public PorterDuff.Mode getSupportCompoundDrawablesTintMode() {
        return this.m.e();
    }

    @Override // android.widget.TextView
    public CharSequence getText() {
        Future future = this.r;
        if (future != null) {
            try {
                this.r = null;
                if (future.get() != null) {
                    throw new ClassCastException();
                }
                if (Build.VERSION.SDK_INT >= 29) {
                    throw null;
                }
                F3.C(this);
                throw null;
            } catch (InterruptedException | ExecutionException unused) {
            }
        }
        return super.getText();
    }

    @Override // android.widget.TextView
    public TextClassifier getTextClassifier() {
        DH dh;
        if (Build.VERSION.SDK_INT >= 28 || (dh = this.n) == null) {
            return super.getTextClassifier();
        }
        TextClassifier textClassifier = (TextClassifier) dh.m;
        return textClassifier == null ? AbstractC2596u8.a((TextView) dh.l) : textClassifier;
    }

    public C0911cY getTextMetricsParamsCompat() {
        return F3.C(this);
    }

    @Override // android.widget.TextView, android.view.View
    public final InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection inputConnectionOnCreateInputConnection = super.onCreateInputConnection(editorInfo);
        this.m.getClass();
        if (Build.VERSION.SDK_INT < 30 && inputConnectionOnCreateInputConnection != null) {
            AbstractC0752ap.c0(editorInfo, getText());
        }
        AbstractC1155f00.B(inputConnectionOnCreateInputConnection, editorInfo, this);
        return inputConnectionOnCreateInputConnection;
    }

    @Override // android.view.View
    public final void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        int i = Build.VERSION.SDK_INT;
        if (i < 30 || i >= 33 || !onCheckIsTextEditor()) {
            return;
        }
        ((InputMethodManager) getContext().getSystemService("input_method")).isActive(this);
    }

    @Override // android.widget.TextView, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        A8 a8 = this.m;
        if (a8 == null || AbstractC2457sk0.c) {
            return;
        }
        a8.i.a();
    }

    @Override // android.widget.TextView, android.view.View
    public void onMeasure(int i, int i2) {
        Future future = this.r;
        if (future != null) {
            try {
                this.r = null;
                if (future.get() != null) {
                    throw new ClassCastException();
                }
                if (Build.VERSION.SDK_INT >= 29) {
                    throw null;
                }
                F3.C(this);
                throw null;
            } catch (InterruptedException | ExecutionException unused) {
            }
        }
        super.onMeasure(i, i2);
    }

    @Override // android.widget.TextView
    public final void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        super.onTextChanged(charSequence, i, i2, i3);
        A8 a8 = this.m;
        if (a8 != null) {
            J8 j8 = a8.i;
            if (AbstractC2457sk0.c || !j8.e()) {
                return;
            }
            j8.a();
        }
    }

    @Override // android.widget.TextView
    public void setAllCaps(boolean z) {
        super.setAllCaps(z);
        getEmojiTextViewHelper().b(z);
    }

    @Override // android.widget.TextView
    public final void setAutoSizeTextTypeUniformWithConfiguration(int i, int i2, int i3, int i4) {
        if (AbstractC2457sk0.c) {
            super.setAutoSizeTextTypeUniformWithConfiguration(i, i2, i3, i4);
            return;
        }
        A8 a8 = this.m;
        if (a8 != null) {
            a8.h(i, i2, i3, i4);
        }
    }

    @Override // android.widget.TextView
    public final void setAutoSizeTextTypeUniformWithPresetSizes(int[] iArr, int i) {
        if (AbstractC2457sk0.c) {
            super.setAutoSizeTextTypeUniformWithPresetSizes(iArr, i);
            return;
        }
        A8 a8 = this.m;
        if (a8 != null) {
            a8.i(iArr, i);
        }
    }

    @Override // android.widget.TextView
    public void setAutoSizeTextTypeWithDefaults(int i) {
        if (AbstractC2457sk0.c) {
            super.setAutoSizeTextTypeWithDefaults(i);
            return;
        }
        A8 a8 = this.m;
        if (a8 != null) {
            a8.j(i);
        }
    }

    @Override // android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        C2689v7 c2689v7 = this.l;
        if (c2689v7 != null) {
            c2689v7.o();
        }
    }

    @Override // android.view.View
    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        C2689v7 c2689v7 = this.l;
        if (c2689v7 != null) {
            c2689v7.p(i);
        }
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawables(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawables(drawable, drawable2, drawable3, drawable4);
        A8 a8 = this.m;
        if (a8 != null) {
            a8.b();
        }
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesRelative(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesRelative(drawable, drawable2, drawable3, drawable4);
        A8 a8 = this.m;
        if (a8 != null) {
            a8.b();
        }
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        A8 a8 = this.m;
        if (a8 != null) {
            a8.b();
        }
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        A8 a8 = this.m;
        if (a8 != null) {
            a8.b();
        }
    }

    @Override // android.widget.TextView
    public void setCustomSelectionActionModeCallback(ActionMode.Callback callback) {
        super.setCustomSelectionActionModeCallback(F3.W(callback, this));
    }

    public void setEmojiCompatEnabled(boolean z) {
        getEmojiTextViewHelper().c(z);
    }

    @Override // android.widget.TextView
    public void setFilters(InputFilter[] inputFilterArr) {
        super.setFilters(((IJ) getEmojiTextViewHelper().b.m).p(inputFilterArr));
    }

    @Override // android.widget.TextView
    public void setFirstBaselineToTopHeight(int i) {
        if (Build.VERSION.SDK_INT >= 28) {
            getSuperCaller().n(i);
        } else {
            F3.O(this, i);
        }
    }

    @Override // android.widget.TextView
    public void setLastBaselineToBottomHeight(int i) {
        if (Build.VERSION.SDK_INT >= 28) {
            getSuperCaller().e(i);
        } else {
            F3.R(this, i);
        }
    }

    @Override // android.widget.TextView
    public void setLineHeight(int i) {
        F3.S(this, i);
    }

    public void setPrecomputedText(AbstractC1007dY abstractC1007dY) {
        if (Build.VERSION.SDK_INT >= 29) {
            throw null;
        }
        F3.C(this);
        throw null;
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        C2689v7 c2689v7 = this.l;
        if (c2689v7 != null) {
            c2689v7.r(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        C2689v7 c2689v7 = this.l;
        if (c2689v7 != null) {
            c2689v7.s(mode);
        }
    }

    public void setSupportCompoundDrawablesTintList(ColorStateList colorStateList) {
        A8 a8 = this.m;
        a8.k(colorStateList);
        a8.b();
    }

    public void setSupportCompoundDrawablesTintMode(PorterDuff.Mode mode) {
        A8 a8 = this.m;
        a8.l(mode);
        a8.b();
    }

    @Override // android.widget.TextView
    public void setTextAppearance(Context context, int i) {
        super.setTextAppearance(context, i);
        A8 a8 = this.m;
        if (a8 != null) {
            a8.g(context, i);
        }
    }

    @Override // android.widget.TextView
    public void setTextClassifier(TextClassifier textClassifier) {
        DH dh;
        if (Build.VERSION.SDK_INT >= 28 || (dh = this.n) == null) {
            super.setTextClassifier(textClassifier);
        } else {
            dh.m = textClassifier;
        }
    }

    public void setTextFuture(Future<AbstractC1007dY> future) {
        this.r = future;
        if (future != null) {
            requestLayout();
        }
    }

    public void setTextMetricsParamsCompat(C0911cY c0911cY) {
        TextDirectionHeuristic textDirectionHeuristic;
        TextDirectionHeuristic textDirectionHeuristic2 = c0911cY.b;
        TextDirectionHeuristic textDirectionHeuristic3 = TextDirectionHeuristics.FIRSTSTRONG_RTL;
        int i = 1;
        if (textDirectionHeuristic2 != textDirectionHeuristic3 && textDirectionHeuristic2 != (textDirectionHeuristic = TextDirectionHeuristics.FIRSTSTRONG_LTR)) {
            if (textDirectionHeuristic2 == TextDirectionHeuristics.ANYRTL_LTR) {
                i = 2;
            } else if (textDirectionHeuristic2 == TextDirectionHeuristics.LTR) {
                i = 3;
            } else if (textDirectionHeuristic2 == TextDirectionHeuristics.RTL) {
                i = 4;
            } else if (textDirectionHeuristic2 == TextDirectionHeuristics.LOCALE) {
                i = 5;
            } else if (textDirectionHeuristic2 == textDirectionHeuristic) {
                i = 6;
            } else if (textDirectionHeuristic2 == textDirectionHeuristic3) {
                i = 7;
            }
        }
        setTextDirection(i);
        getPaint().set(c0911cY.a);
        setBreakStrategy(c0911cY.c);
        setHyphenationFrequency(c0911cY.d);
    }

    @Override // android.widget.TextView
    public final void setTextSize(int i, float f) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean z = AbstractC2457sk0.c;
        if (z) {
            super.setTextSize(i, f);
            return;
        }
        A8 a8 = this.m;
        if (a8 != null) {
            J8 j8 = a8.i;
            if (z || j8.e()) {
                return;
            }
            j8.f(i, f);
        }
    }

    @Override // android.widget.TextView
    public final void setTypeface(Typeface typeface, int i) {
        Typeface typefaceCreate;
        if (this.p) {
            return;
        }
        if (typeface == null || i <= 0) {
            typefaceCreate = null;
        } else {
            Context context = getContext();
            AbstractC2461sm0 abstractC2461sm0 = AbstractC1977nh0.a;
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null");
            }
            typefaceCreate = Typeface.create(typeface, i);
        }
        this.p = true;
        if (typefaceCreate != null) {
            typeface = typefaceCreate;
        }
        try {
            super.setTypeface(typeface, i);
        } finally {
            this.p = false;
        }
    }

    /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
    public E8(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        Gf0.a(context);
        this.p = false;
        this.q = null;
        AbstractC1498if0.a(this, getContext());
        C2689v7 c2689v7 = new C2689v7(this);
        this.l = c2689v7;
        c2689v7.m(attributeSet, i);
        A8 a8 = new A8(this);
        this.m = a8;
        a8.f(attributeSet, i);
        a8.b();
        DH dh = new DH();
        dh.l = this;
        this.n = dh;
        getEmojiTextViewHelper().a(attributeSet, i);
    }

    @Override // android.widget.TextView
    public final void setLineHeight(int i, float f) {
        int i2 = Build.VERSION.SDK_INT;
        if (i2 >= 34) {
            getSuperCaller().q(i, f);
        } else if (i2 >= 34) {
            AbstractC2106p0.k(this, i, f);
        } else {
            F3.S(this, Math.round(TypedValue.applyDimension(i, f, getResources().getDisplayMetrics())));
        }
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesRelativeWithIntrinsicBounds(int i, int i2, int i3, int i4) {
        Context context = getContext();
        setCompoundDrawablesRelativeWithIntrinsicBounds(i != 0 ? C80.x(context, i) : null, i2 != 0 ? C80.x(context, i2) : null, i3 != 0 ? C80.x(context, i3) : null, i4 != 0 ? C80.x(context, i4) : null);
        A8 a8 = this.m;
        if (a8 != null) {
            a8.b();
        }
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesWithIntrinsicBounds(int i, int i2, int i3, int i4) {
        Context context = getContext();
        setCompoundDrawablesWithIntrinsicBounds(i != 0 ? C80.x(context, i) : null, i2 != 0 ? C80.x(context, i2) : null, i3 != 0 ? C80.x(context, i3) : null, i4 != 0 ? C80.x(context, i4) : null);
        A8 a8 = this.m;
        if (a8 != null) {
            a8.b();
        }
    }
}
