package o;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.xo0, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public final class C2940xo0 extends Iu0 {
    public static final String[] f = {"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;", "current_session_count", "ALTER TABLE events ADD COLUMN current_session_count INTEGER;"};
    public static final String[] g = {"associated_row_id", "ALTER TABLE upload_queue ADD COLUMN associated_row_id INTEGER;", "last_upload_timestamp", "ALTER TABLE upload_queue ADD COLUMN last_upload_timestamp INTEGER;"};
    public static final String[] h = {"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    public static final String[] i = {"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;", "dynamite_version", "ALTER TABLE apps ADD COLUMN dynamite_version INTEGER;", "safelisted_events", "ALTER TABLE apps ADD COLUMN safelisted_events TEXT;", "ga_app_id", "ALTER TABLE apps ADD COLUMN ga_app_id TEXT;", "config_last_modified_time", "ALTER TABLE apps ADD COLUMN config_last_modified_time TEXT;", "e_tag", "ALTER TABLE apps ADD COLUMN e_tag TEXT;", "session_stitching_token", "ALTER TABLE apps ADD COLUMN session_stitching_token TEXT;", "sgtm_upload_enabled", "ALTER TABLE apps ADD COLUMN sgtm_upload_enabled INTEGER;", "target_os_version", "ALTER TABLE apps ADD COLUMN target_os_version INTEGER;", "session_stitching_token_hash", "ALTER TABLE apps ADD COLUMN session_stitching_token_hash INTEGER;", "ad_services_version", "ALTER TABLE apps ADD COLUMN ad_services_version INTEGER;", "unmatched_first_open_without_ad_id", "ALTER TABLE apps ADD COLUMN unmatched_first_open_without_ad_id INTEGER;", "npa_metadata_value", "ALTER TABLE apps ADD COLUMN npa_metadata_value INTEGER;", "attribution_eligibility_status", "ALTER TABLE apps ADD COLUMN attribution_eligibility_status INTEGER;", "sgtm_preview_key", "ALTER TABLE apps ADD COLUMN sgtm_preview_key TEXT;", "dma_consent_state", "ALTER TABLE apps ADD COLUMN dma_consent_state INTEGER;", "daily_realtime_dcu_count", "ALTER TABLE apps ADD COLUMN daily_realtime_dcu_count INTEGER;", "bundle_delivery_index", "ALTER TABLE apps ADD COLUMN bundle_delivery_index INTEGER;", "serialized_npa_metadata", "ALTER TABLE apps ADD COLUMN serialized_npa_metadata TEXT;", "unmatched_pfo", "ALTER TABLE apps ADD COLUMN unmatched_pfo INTEGER;", "unmatched_uwa", "ALTER TABLE apps ADD COLUMN unmatched_uwa INTEGER;", "ad_campaign_info", "ALTER TABLE apps ADD COLUMN ad_campaign_info BLOB;", "daily_registered_triggers_count", "ALTER TABLE apps ADD COLUMN daily_registered_triggers_count INTEGER;", "client_upload_eligibility", "ALTER TABLE apps ADD COLUMN client_upload_eligibility INTEGER;", "gmp_version_for_remote_config", "ALTER TABLE apps ADD COLUMN gmp_version_for_remote_config INTEGER;"};
    public static final String[] j = {"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    public static final String[] k = {"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    public static final String[] l = {"session_scoped", "ALTER TABLE event_filters ADD COLUMN session_scoped BOOLEAN;"};
    public static final String[] m = {"session_scoped", "ALTER TABLE property_filters ADD COLUMN session_scoped BOOLEAN;"};
    public static final String[] n = {"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};

    /* renamed from: o, reason: collision with root package name */
    public static final String[] f794o = {"consent_source", "ALTER TABLE consent_settings ADD COLUMN consent_source INTEGER;", "dma_consent_settings", "ALTER TABLE consent_settings ADD COLUMN dma_consent_settings TEXT;", "storage_consent_at_bundling", "ALTER TABLE consent_settings ADD COLUMN storage_consent_at_bundling TEXT;"};
    public static final String[] p = {"idempotent", "CREATE INDEX IF NOT EXISTS trigger_uris_index ON trigger_uris (app_id);"};
    public final C2750vo0 d;
    public final C0189Hh e;

    public C2940xo0(C1051dv0 c1051dv0) {
        super(c1051dv0);
        this.e = new C0189Hh(((Kr0) this.a).k);
        ((Kr0) this.a).getClass();
        this.d = new C2750vo0(this, ((Kr0) this.a).a);
    }

    public static final String V(List list) {
        return list.isEmpty() ? "" : AbstractC2462sn.j(" AND (upload_type IN (", TextUtils.join(", ", list), "))");
    }

    public static final void b0(ContentValues contentValues, Object obj) {
        Preconditions.checkNotEmpty("value");
        Preconditions.checkNotNull(obj);
        if (obj instanceof String) {
            contentValues.put("value", (String) obj);
        } else if (obj instanceof Long) {
            contentValues.put("value", (Long) obj);
        } else {
            if (!(obj instanceof Double)) {
                throw new IllegalArgumentException("Invalid value type");
            }
            contentValues.put("value", (Double) obj);
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:20:0x0039  */
    /* JADX WARN: Removed duplicated region for block: B:23:0x003f  */
    /* JADX WARN: Type inference failed for: r1v0 */
    /* JADX WARN: Type inference failed for: r1v1, types: [android.database.Cursor] */
    /* JADX WARN: Type inference failed for: r1v3 */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final java.lang.String A() throws java.lang.Throwable {
        /*
            r6 = this;
            android.database.sqlite.SQLiteDatabase r0 = r6.h0()
            r1 = 0
            java.lang.String r2 = "select app_id from queue order by has_realtime desc, rowid asc limit 1;"
            android.database.Cursor r0 = r0.rawQuery(r2, r1)     // Catch: java.lang.Throwable -> L22 android.database.sqlite.SQLiteException -> L24
            boolean r2 = r0.moveToFirst()     // Catch: java.lang.Throwable -> L1a android.database.sqlite.SQLiteException -> L1c
            if (r2 == 0) goto L37
            r2 = 0
            java.lang.String r1 = r0.getString(r2)     // Catch: java.lang.Throwable -> L1a android.database.sqlite.SQLiteException -> L1c
            r0.close()
            return r1
        L1a:
            r1 = move-exception
            goto L1e
        L1c:
            r2 = move-exception
            goto L27
        L1e:
            r5 = r1
            r1 = r0
            r0 = r5
            goto L3d
        L22:
            r0 = move-exception
            goto L3d
        L24:
            r0 = move-exception
            r2 = r0
            r0 = r1
        L27:
            java.lang.Object r3 = r6.a     // Catch: java.lang.Throwable -> L1a
            o.Kr0 r3 = (o.Kr0) r3     // Catch: java.lang.Throwable -> L1a
            o.Nq0 r3 = r3.f     // Catch: java.lang.Throwable -> L1a
            o.Kr0.l(r3)     // Catch: java.lang.Throwable -> L1a
            o.nl r3 = r3.f     // Catch: java.lang.Throwable -> L1a
            java.lang.String r4 = "Database error getting next bundle app id"
            r3.c(r2, r4)     // Catch: java.lang.Throwable -> L1a
        L37:
            if (r0 == 0) goto L3c
            r0.close()
        L3c:
            return r1
        L3d:
            if (r1 == 0) goto L42
            r1.close()
        L42:
            throw r0
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.A():java.lang.String");
    }

    public final void B(long j2) {
        r();
        t();
        try {
            if (h0().delete("queue", "rowid=?", new String[]{String.valueOf(j2)}) == 1) {
            } else {
                throw new SQLiteException("Deleted fewer rows from queue than expected");
            }
        } catch (SQLiteException e) {
            Nq0 nq0 = ((Kr0) this.a).f;
            Kr0.l(nq0);
            nq0.f.c(e, "Failed to delete a bundle in a queue table");
            throw e;
        }
    }

    public final void C() {
        int iDelete;
        r();
        t();
        if (Z()) {
            C1051dv0 c1051dv0 = this.b;
            long jA = c1051dv0.i.e.a();
            Kr0 kr0 = (Kr0) this.a;
            long jElapsedRealtime = kr0.k.elapsedRealtime();
            if (Math.abs(jElapsedRealtime - jA) > ((Long) AbstractC1900mq0.M.a(null)).longValue()) {
                c1051dv0.i.e.b(jElapsedRealtime);
                r();
                t();
                if (!Z() || (iDelete = h0().delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", new String[]{String.valueOf(kr0.k.currentTimeMillis()), String.valueOf(((Long) AbstractC1900mq0.R.a(null)).longValue())})) <= 0) {
                    return;
                }
                Nq0 nq0 = kr0.f;
                Kr0.l(nq0);
                nq0.n.c(Integer.valueOf(iDelete), "Deleted stale rows. rowsDeleted");
            }
        }
    }

    public final void D(List list) throws SQLException {
        Kr0 kr0 = (Kr0) this.a;
        r();
        t();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero(list.size());
        if (Z()) {
            String strJoin = TextUtils.join(",", list);
            StringBuilder sb = new StringBuilder(String.valueOf(strJoin).length() + 2);
            sb.append("(");
            sb.append(strJoin);
            sb.append(")");
            String string = sb.toString();
            StringBuilder sb2 = new StringBuilder(string.length() + 80);
            sb2.append("SELECT COUNT(1) FROM queue WHERE rowid IN ");
            sb2.append(string);
            sb2.append(" AND retry_count =  2147483647 LIMIT 1");
            if (c0(sb2.toString(), null) > 0) {
                Nq0 nq0 = kr0.f;
                Kr0.l(nq0);
                nq0.i.b("The number of upload retries exceeds the limit. Will remain unchanged.");
            }
            try {
                SQLiteDatabase sQLiteDatabaseH0 = h0();
                StringBuilder sb3 = new StringBuilder(string.length() + 127);
                sb3.append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ");
                sb3.append(string);
                sb3.append(" AND (retry_count IS NULL OR retry_count < 2147483647)");
                sQLiteDatabaseH0.execSQL(sb3.toString());
            } catch (SQLiteException e) {
                Nq0 nq02 = kr0.f;
                Kr0.l(nq02);
                nq02.f.c(e, "Error incrementing retry count. error");
            }
        }
    }

    public final void E(Long l2) {
        Kr0 kr0 = (Kr0) this.a;
        r();
        t();
        Preconditions.checkNotNull(l2);
        if (Z()) {
            StringBuilder sb = new StringBuilder(l2.toString().length() + 86);
            sb.append("SELECT COUNT(1) FROM upload_queue WHERE rowid = ");
            sb.append(l2);
            sb.append(" AND retry_count =  2147483647 LIMIT 1");
            if (c0(sb.toString(), null) > 0) {
                Nq0 nq0 = kr0.f;
                Kr0.l(nq0);
                nq0.i.b("The number of upload retries exceeds the limit. Will remain unchanged.");
            }
            try {
                SQLiteDatabase sQLiteDatabaseH0 = h0();
                long jCurrentTimeMillis = kr0.k.currentTimeMillis();
                StringBuilder sb2 = new StringBuilder(String.valueOf(jCurrentTimeMillis).length() + 60);
                sb2.append(" SET retry_count = retry_count + 1, last_upload_timestamp = ");
                sb2.append(jCurrentTimeMillis);
                String string = sb2.toString();
                StringBuilder sb3 = new StringBuilder(string.length() + 34 + l2.toString().length() + 29);
                sb3.append("UPDATE upload_queue");
                sb3.append(string);
                sb3.append(" WHERE rowid = ");
                sb3.append(l2);
                sb3.append(" AND retry_count < 2147483647");
                sQLiteDatabaseH0.execSQL(sb3.toString());
            } catch (SQLiteException e) {
                Nq0 nq02 = kr0.f;
                Kr0.l(nq02);
                nq02.f.c(e, "Error incrementing retry count. error");
            }
        }
    }

    public final Object F(Cursor cursor, int i2) {
        Kr0 kr0 = (Kr0) this.a;
        int type = cursor.getType(i2);
        if (type == 0) {
            Nq0 nq0 = kr0.f;
            Kr0.l(nq0);
            nq0.f.b("Loaded invalid null value from database");
            return null;
        }
        if (type == 1) {
            return Long.valueOf(cursor.getLong(i2));
        }
        if (type == 2) {
            return Double.valueOf(cursor.getDouble(i2));
        }
        if (type == 3) {
            return cursor.getString(i2);
        }
        if (type != 4) {
            Nq0 nq02 = kr0.f;
            Kr0.l(nq02);
            nq02.f.c(Integer.valueOf(type), "Loaded invalid unknown value type, ignoring it");
            return null;
        }
        Nq0 nq03 = kr0.f;
        Kr0.l(nq03);
        nq03.f.b("Loaded invalid blob type value, ignoring it");
        return null;
    }

    /* JADX WARN: Removed duplicated region for block: B:17:0x0093 A[Catch: all -> 0x006d, SQLiteException -> 0x00a4, TryCatch #0 {SQLiteException -> 0x00a4, blocks: (B:15:0x0072, B:17:0x0093, B:20:0x00a6), top: B:30:0x0072 }] */
    /* JADX WARN: Removed duplicated region for block: B:20:0x00a6 A[Catch: all -> 0x006d, SQLiteException -> 0x00a4, TRY_LEAVE, TryCatch #0 {SQLiteException -> 0x00a4, blocks: (B:15:0x0072, B:17:0x0093, B:20:0x00a6), top: B:30:0x0072 }] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final long G(java.lang.String r14) {
        /*
            r13 = this;
            java.lang.Object r0 = r13.a
            o.Kr0 r0 = (o.Kr0) r0
            java.lang.String r1 = "select first_open_count from app2 where app_id=?"
            com.google.android.gms.common.internal.Preconditions.checkNotEmpty(r14)
            java.lang.String r2 = "first_open_count"
            com.google.android.gms.common.internal.Preconditions.checkNotEmpty(r2)
            r13.r()
            r13.t()
            android.database.sqlite.SQLiteDatabase r3 = r13.h0()
            r3.beginTransaction()
            r4 = 0
            java.lang.StringBuilder r6 = new java.lang.StringBuilder     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r7 = 48
            r6.<init>(r7)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r6.append(r1)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            java.lang.String r1 = r6.toString()     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            java.lang.String[] r6 = new java.lang.String[]{r14}     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r7 = -1
            long r9 = r13.d0(r1, r6, r7)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            int r1 = (r9 > r7 ? 1 : (r9 == r7 ? 0 : -1))
            java.lang.String r6 = "app2"
            java.lang.String r11 = "app_id"
            if (r1 != 0) goto L72
            android.content.ContentValues r1 = new android.content.ContentValues     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r1.<init>()     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r1.put(r11, r14)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r9 = 0
            java.lang.Integer r9 = java.lang.Integer.valueOf(r9)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r1.put(r2, r9)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            java.lang.String r10 = "previous_install_count"
            r1.put(r10, r9)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r9 = 0
            r10 = 5
            long r9 = r3.insertWithOnConflict(r6, r9, r1, r10)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            int r1 = (r9 > r7 ? 1 : (r9 == r7 ? 0 : -1))
            if (r1 != 0) goto L71
            o.Nq0 r1 = r0.f     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            o.Kr0.l(r1)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            o.nl r1 = r1.f     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            java.lang.String r6 = "Failed to insert column (got -1). appId"
            o.Lq0 r9 = o.Nq0.A(r14)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            r1.d(r6, r9, r2)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> L6f
            goto Lbd
        L6d:
            r14 = move-exception
            goto Lc1
        L6f:
            r1 = move-exception
            goto Lac
        L71:
            r9 = r4
        L72:
            android.content.ContentValues r1 = new android.content.ContentValues     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            r1.<init>()     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            r1.put(r11, r14)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            r11 = 1
            long r11 = r11 + r9
            java.lang.Long r11 = java.lang.Long.valueOf(r11)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            r1.put(r2, r11)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            java.lang.String r11 = "app_id = ?"
            java.lang.String[] r12 = new java.lang.String[]{r14}     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            int r1 = r3.update(r6, r1, r11, r12)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            long r11 = (long) r1     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            int r1 = (r11 > r4 ? 1 : (r11 == r4 ? 0 : -1))
            if (r1 != 0) goto La6
            o.Nq0 r1 = r0.f     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            o.Kr0.l(r1)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            o.nl r1 = r1.f     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            java.lang.String r4 = "Failed to update column (got 0). appId"
            o.Lq0 r5 = o.Nq0.A(r14)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            r1.d(r4, r5, r2)     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            goto Lbd
        La4:
            r1 = move-exception
            goto Lab
        La6:
            r3.setTransactionSuccessful()     // Catch: java.lang.Throwable -> L6d android.database.sqlite.SQLiteException -> La4
            r7 = r9
            goto Lbd
        Lab:
            r4 = r9
        Lac:
            o.Nq0 r0 = r0.f     // Catch: java.lang.Throwable -> L6d
            o.Kr0.l(r0)     // Catch: java.lang.Throwable -> L6d
            o.nl r0 = r0.f     // Catch: java.lang.Throwable -> L6d
            java.lang.String r6 = "Error inserting column. appId"
            o.Lq0 r14 = o.Nq0.A(r14)     // Catch: java.lang.Throwable -> L6d
            r0.e(r6, r14, r2, r1)     // Catch: java.lang.Throwable -> L6d
            r7 = r4
        Lbd:
            r3.endTransaction()
            return r7
        Lc1:
            r3.endTransaction()
            throw r14
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.G(java.lang.String):long");
    }

    public final boolean H(String str, String str2) {
        return c0("select count(1) from raw_events where app_id = ? and name = ?", new String[]{str, str2}) > 0;
    }

    public final long I(String str) {
        Preconditions.checkNotEmpty(str);
        return d0("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{str}, 0L);
    }

    public final void J(String str, Long l2, long j2, C2756vr0 c2756vr0) {
        r();
        t();
        Preconditions.checkNotNull(c2756vr0);
        Preconditions.checkNotEmpty(str);
        Preconditions.checkNotNull(l2);
        Kr0 kr0 = (Kr0) this.a;
        byte[] bArrA = c2756vr0.a();
        Nq0 nq0 = kr0.f;
        Nq0 nq02 = kr0.f;
        Kr0.l(nq0);
        nq0.n.d("Saving complex main event, appId, data size", kr0.j.a(str), Integer.valueOf(bArrA.length));
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", str);
        contentValues.put("event_id", l2);
        contentValues.put("children_to_process", Long.valueOf(j2));
        contentValues.put("main_event", bArrA);
        try {
            if (h0().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1) {
                Kr0.l(nq02);
                nq02.f.c(Nq0.A(str), "Failed to insert complex main event (got -1). appId");
            }
        } catch (SQLiteException e) {
            Kr0.l(nq02);
            nq02.f.d("Error storing complex main event. appId", Nq0.A(str), e);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:122:0x0117 A[SYNTHETIC] */
    /* JADX WARN: Removed duplicated region for block: B:50:0x00f5  */
    /* JADX WARN: Removed duplicated region for block: B:63:0x013c  */
    /* JADX WARN: Removed duplicated region for block: B:81:0x01c7  */
    /* JADX WARN: Removed duplicated region for block: B:84:0x01d8  */
    /* JADX WARN: Removed duplicated region for block: B:86:0x01de  */
    /* JADX WARN: Removed duplicated region for block: B:96:0x029b A[Catch: SQLiteException -> 0x02b7, TRY_LEAVE, TryCatch #1 {SQLiteException -> 0x02b7, blocks: (B:94:0x0280, B:96:0x029b), top: B:109:0x0280 }] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void K(java.lang.String r26, java.lang.Long r27, java.lang.String r28, android.os.Bundle r29) {
        /*
            Method dump skipped, instructions count: 724
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.K(java.lang.String, java.lang.Long, java.lang.String, android.os.Bundle):void");
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:24:0x005e  */
    /* JADX WARN: Removed duplicated region for block: B:26:0x0061 A[RETURN] */
    /* JADX WARN: Removed duplicated region for block: B:28:0x0064  */
    /* JADX WARN: Type inference failed for: r3v1, types: [android.database.sqlite.SQLiteDatabase] */
    /* JADX WARN: Type inference failed for: r5v1, types: [java.lang.String[]] */
    /* JADX WARN: Type inference failed for: r5v4 */
    /* JADX WARN: Type inference failed for: r5v5 */
    /* JADX WARN: Type inference failed for: r5v6 */
    /* JADX WARN: Type inference failed for: r5v8, types: [android.database.Cursor] */
    /* JADX WARN: Type inference failed for: r5v9, types: [android.database.Cursor] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final o.C2284qs0 L(java.lang.String r5) {
        /*
            r4 = this;
            java.lang.Object r0 = r4.a
            o.Kr0 r0 = (o.Kr0) r0
            com.google.android.gms.common.internal.Preconditions.checkNotNull(r5)
            r4.r()
            r4.t()
            java.lang.String[] r5 = new java.lang.String[]{r5}
            java.lang.String r1 = "select consent_state, consent_source from consent_settings where app_id=? limit 1;"
            r2 = 0
            android.database.sqlite.SQLiteDatabase r3 = r4.h0()     // Catch: java.lang.Throwable -> L47 android.database.sqlite.SQLiteException -> L4a
            android.database.Cursor r5 = r3.rawQuery(r1, r5)     // Catch: java.lang.Throwable -> L47 android.database.sqlite.SQLiteException -> L4a
            boolean r1 = r5.moveToFirst()     // Catch: java.lang.Throwable -> L32 android.database.sqlite.SQLiteException -> L34
            if (r1 != 0) goto L36
            o.Nq0 r1 = r0.f     // Catch: java.lang.Throwable -> L32 android.database.sqlite.SQLiteException -> L34
            o.Kr0.l(r1)     // Catch: java.lang.Throwable -> L32 android.database.sqlite.SQLiteException -> L34
            o.nl r1 = r1.n     // Catch: java.lang.Throwable -> L32 android.database.sqlite.SQLiteException -> L34
            java.lang.String r3 = "No data found"
            r1.b(r3)     // Catch: java.lang.Throwable -> L32 android.database.sqlite.SQLiteException -> L34
        L2e:
            r5.close()
            goto L5c
        L32:
            r0 = move-exception
            goto L45
        L34:
            r1 = move-exception
            goto L4d
        L36:
            r1 = 0
            java.lang.String r1 = r5.getString(r1)     // Catch: java.lang.Throwable -> L32 android.database.sqlite.SQLiteException -> L34
            r3 = 1
            int r3 = r5.getInt(r3)     // Catch: java.lang.Throwable -> L32 android.database.sqlite.SQLiteException -> L34
            o.qs0 r2 = o.C2284qs0.c(r3, r1)     // Catch: java.lang.Throwable -> L32 android.database.sqlite.SQLiteException -> L34
            goto L2e
        L45:
            r2 = r5
            goto L62
        L47:
            r5 = move-exception
            r0 = r5
            goto L62
        L4a:
            r5 = move-exception
            r1 = r5
            r5 = r2
        L4d:
            o.Nq0 r0 = r0.f     // Catch: java.lang.Throwable -> L32
            o.Kr0.l(r0)     // Catch: java.lang.Throwable -> L32
            o.nl r0 = r0.f     // Catch: java.lang.Throwable -> L32
            java.lang.String r3 = "Error querying database."
            r0.c(r1, r3)     // Catch: java.lang.Throwable -> L32
            if (r5 == 0) goto L5c
            goto L2e
        L5c:
            if (r2 != 0) goto L61
            o.qs0 r5 = o.C2284qs0.c
            return r5
        L61:
            return r2
        L62:
            if (r2 == 0) goto L67
            r2.close()
        L67:
            throw r0
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.L(java.lang.String):o.qs0");
    }

    public final void M(String str, C2762vu0 c2762vu0) {
        r();
        t();
        Preconditions.checkNotNull(c2762vu0);
        Preconditions.checkNotEmpty(str);
        Kr0 kr0 = (Kr0) this.a;
        Clock clock = kr0.k;
        Nq0 nq0 = kr0.f;
        long jCurrentTimeMillis = clock.currentTimeMillis();
        C1805lq0 c1805lq0 = AbstractC1900mq0.v0;
        long jLongValue = jCurrentTimeMillis - ((Long) c1805lq0.a(null)).longValue();
        long j2 = c2762vu0.m;
        if (j2 < jLongValue || j2 > ((Long) c1805lq0.a(null)).longValue() + jCurrentTimeMillis) {
            Kr0.l(nq0);
            nq0.i.e("Storing trigger URI outside of the max retention time span. appId, now, timestamp", Nq0.A(str), Long.valueOf(jCurrentTimeMillis), Long.valueOf(j2));
        }
        Kr0.l(nq0);
        nq0.n.b("Saving trigger URI");
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", str);
        contentValues.put("trigger_uri", c2762vu0.l);
        contentValues.put("source", Integer.valueOf(c2762vu0.n));
        contentValues.put("timestamp_millis", Long.valueOf(j2));
        try {
            if (h0().insert("trigger_uris", null, contentValues) == -1) {
                Kr0.l(nq0);
                nq0.f.c(Nq0.A(str), "Failed to insert trigger URI (got -1). appId");
            }
        } catch (SQLiteException e) {
            Kr0.l(nq0);
            nq0.f.d("Error storing trigger URI. appId", Nq0.A(str), e);
        }
    }

    public final void N(String str, C2284qs0 c2284qs0) {
        Preconditions.checkNotNull(str);
        Preconditions.checkNotNull(c2284qs0);
        r();
        t();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", str);
        contentValues.put("consent_state", c2284qs0.g());
        contentValues.put("consent_source", Integer.valueOf(c2284qs0.b));
        P(contentValues);
    }

    public final String O(String str, String[] strArr) {
        Cursor cursorRawQuery = null;
        try {
            try {
                cursorRawQuery = h0().rawQuery(str, strArr);
                if (!cursorRawQuery.moveToFirst()) {
                    cursorRawQuery.close();
                    return "";
                }
                String string = cursorRawQuery.getString(0);
                cursorRawQuery.close();
                return string;
            } catch (SQLiteException e) {
                Nq0 nq0 = ((Kr0) this.a).f;
                Kr0.l(nq0);
                nq0.f.d("Database error", str, e);
                throw e;
            }
        } catch (Throwable th) {
            if (cursorRawQuery != null) {
                cursorRawQuery.close();
            }
            throw th;
        }
    }

    public final void P(ContentValues contentValues) {
        Kr0 kr0 = (Kr0) this.a;
        try {
            SQLiteDatabase sQLiteDatabaseH0 = h0();
            if (contentValues.getAsString("app_id") == null) {
                Nq0 nq0 = kr0.f;
                Kr0.l(nq0);
                nq0.h.c(Nq0.A("app_id"), "Value of the primary key is not set.");
                return;
            }
            new StringBuilder(10).append("app_id = ?");
            if (sQLiteDatabaseH0.update("consent_settings", contentValues, r6.toString(), new String[]{r5}) == 0 && sQLiteDatabaseH0.insertWithOnConflict("consent_settings", null, contentValues, 5) == -1) {
                Nq0 nq02 = kr0.f;
                Kr0.l(nq02);
                nq02.f.d("Failed to insert/update table (got -1). key", Nq0.A("consent_settings"), Nq0.A("app_id"));
            }
        } catch (SQLiteException e) {
            Nq0 nq03 = kr0.f;
            Kr0.l(nq03);
            nq03.f.e("Error storing into table. key", Nq0.A("consent_settings"), Nq0.A("app_id"), e);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:51:0x0127  */
    /* JADX WARN: Removed duplicated region for block: B:54:0x012d  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final o.Jo0 Q(java.lang.String r31, java.lang.String r32, java.lang.String r33) {
        /*
            Method dump skipped, instructions count: 305
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.Q(java.lang.String, java.lang.String, java.lang.String):o.Jo0");
    }

    public final void R(String str, Jo0 jo0) {
        Kr0 kr0 = (Kr0) this.a;
        Preconditions.checkNotNull(jo0);
        r();
        t();
        ContentValues contentValues = new ContentValues();
        String str2 = jo0.a;
        contentValues.put("app_id", str2);
        contentValues.put("name", jo0.b);
        contentValues.put("lifetime_count", Long.valueOf(jo0.c));
        contentValues.put("current_bundle_count", Long.valueOf(jo0.d));
        contentValues.put("last_fire_timestamp", Long.valueOf(jo0.f));
        contentValues.put("last_bundled_timestamp", Long.valueOf(jo0.g));
        contentValues.put("last_bundled_day", jo0.h);
        contentValues.put("last_sampled_complex_event_id", jo0.i);
        contentValues.put("last_sampling_rate", jo0.j);
        contentValues.put("current_session_count", Long.valueOf(jo0.e));
        Boolean bool = jo0.k;
        contentValues.put("last_exempt_from_sampling", (bool == null || !bool.booleanValue()) ? null : 1L);
        try {
            if (h0().insertWithOnConflict(str, null, contentValues, 5) == -1) {
                Nq0 nq0 = kr0.f;
                Kr0.l(nq0);
                nq0.f.c(Nq0.A(str2), "Failed to insert/update event aggregates (got -1). appId");
            }
        } catch (SQLiteException e) {
            Nq0 nq02 = kr0.f;
            Kr0.l(nq02);
            nq02.f.d("Error storing event aggregates. appId", Nq0.A(jo0.a), e);
        }
    }

    public final void S(String str, String str2) {
        Preconditions.checkNotEmpty(str2);
        r();
        t();
        try {
            h0().delete(str, "app_id=?", new String[]{str2});
        } catch (SQLiteException e) {
            Nq0 nq0 = ((Kr0) this.a).f;
            Kr0.l(nq0);
            nq0.f.d("Error deleting snapshot. appId", Nq0.A(str2), e);
        }
    }

    public final C1529iv0 T(String str, long j2, byte[] bArr, String str2, String str3, int i2, int i3, long j3, long j4, long j5) {
        EnumC1335gt0 enumC1335gt0;
        Kr0 kr0 = (Kr0) this.a;
        if (TextUtils.isEmpty(str2)) {
            Nq0 nq0 = kr0.f;
            Kr0.l(nq0);
            nq0.m.b("Upload uri is null or empty. Destination is unknown. Dropping batch. ");
            return null;
        }
        try {
            Gr0 gr0 = (Gr0) C1720kv0.a0(Jr0.w(), bArr);
            EnumC1335gt0[] enumC1335gt0ArrValues = EnumC1335gt0.values();
            int length = enumC1335gt0ArrValues.length;
            int i4 = 0;
            while (true) {
                if (i4 >= length) {
                    enumC1335gt0 = EnumC1335gt0.r;
                    break;
                }
                enumC1335gt0 = enumC1335gt0ArrValues[i4];
                if (enumC1335gt0.l == i2) {
                    break;
                }
                i4++;
            }
            if (enumC1335gt0 != EnumC1335gt0.n && enumC1335gt0 != EnumC1335gt0.q && i3 > 0) {
                ArrayList arrayList = new ArrayList();
                Iterator it = Collections.unmodifiableList(((Jr0) gr0.m).p()).iterator();
                while (it.hasNext()) {
                    Lr0 lr0 = (Lr0) ((Nr0) it.next()).i();
                    lr0.b();
                    ((Nr0) lr0.m).T0(i3);
                    arrayList.add((Nr0) lr0.e());
                }
                gr0.b();
                ((Jr0) gr0.m).B();
                gr0.b();
                ((Jr0) gr0.m).A(arrayList);
            }
            HashMap map = new HashMap();
            if (str3 != null) {
                String[] strArrSplit = str3.split("\r\n");
                int length2 = strArrSplit.length;
                int i5 = 0;
                while (true) {
                    if (i5 >= length2) {
                        break;
                    }
                    String str4 = strArrSplit[i5];
                    if (str4.isEmpty()) {
                        break;
                    }
                    String[] strArrSplit2 = str4.split("=", 2);
                    if (strArrSplit2.length != 2) {
                        Nq0 nq02 = kr0.f;
                        Kr0.l(nq02);
                        nq02.f.c(str4, "Invalid upload header: ");
                        break;
                    }
                    map.put(strArrSplit2[0], strArrSplit2[1]);
                    i5++;
                }
            }
            return new C1529iv0(j2, (Jr0) gr0.e(), str2, map, enumC1335gt0, j3, j4, j5, i3);
        } catch (IOException e) {
            Nq0 nq03 = kr0.f;
            Kr0.l(nq03);
            nq03.f.d("Failed to queued MeasurementBatch from upload_queue. appId", str, e);
            return null;
        }
    }

    public final String U() {
        long jCurrentTimeMillis = ((Kr0) this.a).k.currentTimeMillis();
        Locale locale = Locale.US;
        Long l2 = (Long) AbstractC1900mq0.S.a(null);
        l2.getClass();
        String str = "(upload_type = 1 AND ABS(creation_timestamp - " + jCurrentTimeMillis + ") > " + l2 + ")";
        String str2 = "(upload_type != 1 AND ABS(creation_timestamp - " + jCurrentTimeMillis + ") > " + ((Long) AbstractC1900mq0.R.a(null)).longValue() + ")";
        StringBuilder sb = new StringBuilder(str.length() + 5 + str2.length() + 1);
        sb.append("(");
        sb.append(str);
        sb.append(" OR ");
        sb.append(str2);
        sb.append(")");
        return sb.toString();
    }

    public final void W(String str, C2284qs0 c2284qs0) {
        Preconditions.checkNotNull(str);
        Preconditions.checkNotNull(c2284qs0);
        r();
        t();
        N(str, L(str));
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", str);
        contentValues.put("storage_consent_at_bundling", c2284qs0.g());
        P(contentValues);
    }

    public final C2284qs0 X(String str) {
        Preconditions.checkNotNull(str);
        r();
        t();
        return C2284qs0.c(100, O("select storage_consent_at_bundling from consent_settings where app_id=? limit 1;", new String[]{str}));
    }

    public final Jo0 Y(String str, C2756vr0 c2756vr0, String str2) {
        Jo0 jo0Q = Q("events", str, c2756vr0.s());
        if (jo0Q != null) {
            long j2 = jo0Q.e + 1;
            long j3 = jo0Q.d + 1;
            return new Jo0(jo0Q.a, jo0Q.b, jo0Q.c + 1, j3, j2, jo0Q.f, jo0Q.g, jo0Q.h, jo0Q.i, jo0Q.j, jo0Q.k);
        }
        Kr0 kr0 = (Kr0) this.a;
        Nq0 nq0 = kr0.f;
        Kr0.l(nq0);
        nq0.i.d("Event aggregate wasn't created during raw event logging. appId, event", Nq0.A(str), kr0.j.a(str2));
        return new Jo0(str, c2756vr0.s(), 1L, 1L, 1L, c2756vr0.u(), 0L, null, null, null, null);
    }

    public final boolean Z() {
        return ((Kr0) this.a).a.getDatabasePath("google_app_measurement.db").exists();
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:106:0x024e  */
    /* JADX WARN: Removed duplicated region for block: B:128:? A[RETURN, SYNTHETIC] */
    /* JADX WARN: Removed duplicated region for block: B:47:0x00fb A[Catch: all -> 0x007d, SQLiteException -> 0x007f, TryCatch #6 {SQLiteException -> 0x007f, blocks: (B:19:0x0075, B:45:0x00d3, B:47:0x00fb, B:48:0x010d, B:49:0x0111, B:50:0x0121, B:52:0x0127, B:53:0x0137, B:56:0x014d, B:68:0x0174, B:71:0x017c, B:77:0x019b, B:61:0x0163, B:75:0x018d, B:76:0x0196, B:98:0x0227), top: B:121:0x0075 }] */
    /* JADX WARN: Removed duplicated region for block: B:48:0x010d A[Catch: all -> 0x007d, SQLiteException -> 0x007f, TRY_LEAVE, TryCatch #6 {SQLiteException -> 0x007f, blocks: (B:19:0x0075, B:45:0x00d3, B:47:0x00fb, B:48:0x010d, B:49:0x0111, B:50:0x0121, B:52:0x0127, B:53:0x0137, B:56:0x014d, B:68:0x0174, B:71:0x017c, B:77:0x019b, B:61:0x0163, B:75:0x018d, B:76:0x0196, B:98:0x0227), top: B:121:0x0075 }] */
    /* JADX WARN: Type inference failed for: r9v2, types: [boolean] */
    /* JADX WARN: Type inference failed for: r9v20 */
    /* JADX WARN: Type inference failed for: r9v21 */
    /* JADX WARN: Type inference failed for: r9v3 */
    /* JADX WARN: Type inference failed for: r9v5 */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void a0(java.lang.String r21, long r22, long r24, o.C2922xf0 r26) throws java.lang.Throwable {
        /*
            Method dump skipped, instructions count: 600
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.a0(java.lang.String, long, long, o.xf0):void");
    }

    public final long c0(String str, String[] strArr) {
        Cursor cursor = null;
        try {
            try {
                Cursor cursorRawQuery = h0().rawQuery(str, strArr);
                if (!cursorRawQuery.moveToFirst()) {
                    throw new SQLiteException("Database returned empty set");
                }
                long j2 = cursorRawQuery.getLong(0);
                cursorRawQuery.close();
                return j2;
            } catch (SQLiteException e) {
                Nq0 nq0 = ((Kr0) this.a).f;
                Kr0.l(nq0);
                nq0.f.d("Database error", str, e);
                throw e;
            }
        } catch (Throwable th) {
            if (0 != 0) {
                cursor.close();
            }
            throw th;
        }
    }

    public final long d0(String str, String[] strArr, long j2) {
        Cursor cursorRawQuery = null;
        try {
            try {
                cursorRawQuery = h0().rawQuery(str, strArr);
                if (cursorRawQuery.moveToFirst()) {
                    j2 = cursorRawQuery.getLong(0);
                }
                cursorRawQuery.close();
                return j2;
            } catch (SQLiteException e) {
                Nq0 nq0 = ((Kr0) this.a).f;
                Kr0.l(nq0);
                nq0.f.d("Database error", str, e);
                throw e;
            }
        } catch (Throwable th) {
            if (cursorRawQuery != null) {
                cursorRawQuery.close();
            }
            throw th;
        }
    }

    public final void e0() {
        t();
        h0().beginTransaction();
    }

    public final void f0() {
        t();
        h0().setTransactionSuccessful();
    }

    public final void g0() {
        t();
        h0().endTransaction();
    }

    public final SQLiteDatabase h0() {
        r();
        try {
            return this.d.getWritableDatabase();
        } catch (SQLiteException e) {
            Nq0 nq0 = ((Kr0) this.a).f;
            Kr0.l(nq0);
            nq0.i.c(e, "Error opening database");
            throw e;
        }
    }

    public final void i0(String str) {
        Jo0 jo0Q;
        S("events_snapshot", str);
        Cursor cursorQuery = null;
        try {
            try {
                cursorQuery = h0().query("events", (String[]) Collections.singletonList("name").toArray(new String[0]), "app_id=?", new String[]{str}, null, null, null);
                if (cursorQuery.moveToFirst()) {
                    do {
                        String string = cursorQuery.getString(0);
                        if (string != null && (jo0Q = Q("events", str, string)) != null) {
                            R("events_snapshot", jo0Q);
                        }
                    } while (cursorQuery.moveToNext());
                }
            } catch (SQLiteException e) {
                Nq0 nq0 = ((Kr0) this.a).f;
                Kr0.l(nq0);
                nq0.f.d("Error creating snapshot. appId", Nq0.A(str), e);
            }
            if (cursorQuery != null) {
                cursorQuery.close();
            }
        } finally {
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:39:0x00b7  */
    /* JADX WARN: Removed duplicated region for block: B:50:0x00cb  */
    /* JADX WARN: Removed duplicated region for block: B:55:0x00d7  */
    /* JADX WARN: Removed duplicated region for block: B:7:0x0054  */
    /* JADX WARN: Removed duplicated region for block: B:9:0x005b  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void j0(java.lang.String r20) throws java.lang.Throwable {
        /*
            Method dump skipped, instructions count: 226
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.j0(java.lang.String):void");
    }

    public final void k0(String str, String str2) {
        Preconditions.checkNotEmpty(str);
        Preconditions.checkNotEmpty(str2);
        r();
        t();
        try {
            h0().delete("user_attributes", "app_id=? and name=?", new String[]{str, str2});
        } catch (SQLiteException e) {
            Kr0 kr0 = (Kr0) this.a;
            Nq0 nq0 = kr0.f;
            Kr0.l(nq0);
            nq0.f.e("Error deleting user property. appId", Nq0.A(str), kr0.j.c(str2), e);
        }
    }

    public final boolean l0(C2195pv0 c2195pv0) {
        Kr0 kr0 = (Kr0) this.a;
        Preconditions.checkNotNull(c2195pv0);
        r();
        t();
        String str = c2195pv0.a;
        String str2 = c2195pv0.b;
        String str3 = c2195pv0.c;
        if (m0(str, str3) == null) {
            if (C2574tv0.p0(str3)) {
                if (c0("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{str}) >= Math.max(Math.min(kr0.d.A(str, AbstractC1900mq0.V), 100), 25)) {
                    return false;
                }
            } else if (!"_npa".equals(str3)) {
                long jC0 = c0("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{str, str2});
                kr0.getClass();
                if (jC0 >= 25) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", str);
        contentValues.put("origin", str2);
        contentValues.put("name", str3);
        contentValues.put("set_timestamp", Long.valueOf(c2195pv0.d));
        b0(contentValues, c2195pv0.e);
        try {
            if (h0().insertWithOnConflict("user_attributes", null, contentValues, 5) != -1) {
                return true;
            }
            Nq0 nq0 = kr0.f;
            Kr0.l(nq0);
            nq0.f.c(Nq0.A(str), "Failed to insert/update user property (got -1). appId");
            return true;
        } catch (SQLiteException e) {
            Nq0 nq02 = kr0.f;
            Kr0.l(nq02);
            nq02.f.d("Error storing user property. appId", Nq0.A(str), e);
            return true;
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:31:0x0097  */
    /* JADX WARN: Removed duplicated region for block: B:34:0x009d  */
    /* JADX WARN: Removed duplicated region for block: B:43:? A[SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final o.C2195pv0 m0(java.lang.String r12, java.lang.String r13) {
        /*
            r11 = this;
            java.lang.Object r0 = r11.a
            r1 = r0
            o.Kr0 r1 = (o.Kr0) r1
            com.google.android.gms.common.internal.Preconditions.checkNotEmpty(r12)
            com.google.android.gms.common.internal.Preconditions.checkNotEmpty(r13)
            r11.r()
            r11.t()
            r2 = 0
            android.database.sqlite.SQLiteDatabase r3 = r11.h0()     // Catch: java.lang.Throwable -> L77 android.database.sqlite.SQLiteException -> L7a
            java.lang.String r4 = "user_attributes"
            java.lang.String r0 = "set_timestamp"
            java.lang.String r5 = "value"
            java.lang.String r6 = "origin"
            java.lang.String[] r5 = new java.lang.String[]{r0, r5, r6}     // Catch: java.lang.Throwable -> L77 android.database.sqlite.SQLiteException -> L7a
            java.lang.String r6 = "app_id=? and name=?"
            java.lang.String[] r7 = new java.lang.String[]{r12, r13}     // Catch: java.lang.Throwable -> L77 android.database.sqlite.SQLiteException -> L7a
            r9 = 0
            r10 = 0
            r8 = 0
            android.database.Cursor r3 = r3.query(r4, r5, r6, r7, r8, r9, r10)     // Catch: java.lang.Throwable -> L77 android.database.sqlite.SQLiteException -> L7a
            boolean r0 = r3.moveToFirst()     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L71
            if (r0 != 0) goto L37
            goto L95
        L37:
            r0 = 0
            long r8 = r3.getLong(r0)     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L71
            r0 = 1
            java.lang.Object r10 = r11.F(r3, r0)     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L71
            if (r10 != 0) goto L44
            goto L95
        L44:
            r0 = 2
            java.lang.String r6 = r3.getString(r0)     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L71
            o.pv0 r4 = new o.pv0     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L71
            r5 = r12
            r7 = r13
            r4.<init>(r5, r6, r7, r8, r10)     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L6a
            boolean r12 = r3.moveToNext()     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L6a
            if (r12 == 0) goto L6d
            o.Nq0 r12 = r1.f     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L6a
            o.Kr0.l(r12)     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L6a
            o.nl r12 = r12.f     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L6a
            java.lang.String r13 = "Got multiple records for user property, expected one. appId"
            o.Lq0 r0 = o.Nq0.A(r5)     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L6a
            r12.c(r0, r13)     // Catch: java.lang.Throwable -> L67 android.database.sqlite.SQLiteException -> L6a
            goto L6d
        L67:
            r0 = move-exception
            r12 = r0
            goto L75
        L6a:
            r0 = move-exception
        L6b:
            r12 = r0
            goto L7f
        L6d:
            r3.close()
            return r4
        L71:
            r0 = move-exception
            r5 = r12
            r7 = r13
            goto L6b
        L75:
            r2 = r3
            goto L9b
        L77:
            r0 = move-exception
            r12 = r0
            goto L9b
        L7a:
            r0 = move-exception
            r5 = r12
            r7 = r13
            r12 = r0
            r3 = r2
        L7f:
            o.Nq0 r13 = r1.f     // Catch: java.lang.Throwable -> L67
            o.Kr0.l(r13)     // Catch: java.lang.Throwable -> L67
            o.nl r13 = r13.f     // Catch: java.lang.Throwable -> L67
            java.lang.String r0 = "Error querying user property. appId"
            o.Lq0 r4 = o.Nq0.A(r5)     // Catch: java.lang.Throwable -> L67
            o.Eq0 r1 = r1.j     // Catch: java.lang.Throwable -> L67
            java.lang.String r1 = r1.c(r7)     // Catch: java.lang.Throwable -> L67
            r13.e(r0, r4, r1, r12)     // Catch: java.lang.Throwable -> L67
        L95:
            if (r3 == 0) goto L9a
            r3.close()
        L9a:
            return r2
        L9b:
            if (r2 == 0) goto La0
            r2.close()
        La0:
            throw r12
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.m0(java.lang.String, java.lang.String):o.pv0");
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:30:0x009e  */
    /* JADX WARN: Type inference failed for: r0v1, types: [java.util.ArrayList] */
    /* JADX WARN: Type inference failed for: r0v4, types: [java.util.List] */
    /* JADX WARN: Type inference failed for: r0v6, types: [java.util.List] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final java.util.List n0(java.lang.String r13) {
        /*
            r12 = this;
            java.lang.Object r0 = r12.a
            r1 = r0
            o.Kr0 r1 = (o.Kr0) r1
            com.google.android.gms.common.internal.Preconditions.checkNotEmpty(r13)
            r12.r()
            r12.t()
            java.util.ArrayList r0 = new java.util.ArrayList
            r0.<init>()
            java.lang.String r10 = "1000"
            r11 = 0
            android.database.sqlite.SQLiteDatabase r2 = r12.h0()     // Catch: java.lang.Throwable -> L70 android.database.sqlite.SQLiteException -> L87
            java.lang.String r3 = "user_attributes"
            java.lang.String r4 = "name"
            java.lang.String r5 = "origin"
            java.lang.String r6 = "set_timestamp"
            java.lang.String r7 = "value"
            java.lang.String[] r4 = new java.lang.String[]{r4, r5, r6, r7}     // Catch: java.lang.Throwable -> L70 android.database.sqlite.SQLiteException -> L87
            java.lang.String r5 = "app_id=?"
            java.lang.String[] r6 = new java.lang.String[]{r13}     // Catch: java.lang.Throwable -> L70 android.database.sqlite.SQLiteException -> L87
            java.lang.String r9 = "rowid"
            r1.getClass()     // Catch: java.lang.Throwable -> L70 android.database.sqlite.SQLiteException -> L87
            r7 = 0
            r8 = 0
            android.database.Cursor r11 = r2.query(r3, r4, r5, r6, r7, r8, r9, r10)     // Catch: java.lang.Throwable -> L70 android.database.sqlite.SQLiteException -> L87
            boolean r2 = r11.moveToFirst()     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            if (r2 == 0) goto L9c
        L3f:
            r2 = 0
            java.lang.String r6 = r11.getString(r2)     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            r2 = 1
            java.lang.String r2 = r11.getString(r2)     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            if (r2 != 0) goto L4d
            java.lang.String r2 = ""
        L4d:
            r5 = r2
            goto L52
        L4f:
            r0 = move-exception
            r4 = r13
            goto L8a
        L52:
            r2 = 2
            long r7 = r11.getLong(r2)     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            r2 = 3
            java.lang.Object r9 = r12.F(r11, r2)     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            if (r9 != 0) goto L73
            o.Nq0 r2 = r1.f     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            o.Kr0.l(r2)     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            o.nl r2 = r2.f     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            java.lang.String r3 = "Read invalid user property value, ignoring it. appId"
            o.Lq0 r4 = o.Nq0.A(r13)     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            r2.c(r4, r3)     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            r4 = r13
            goto L7c
        L70:
            r0 = move-exception
            r13 = r0
            goto La2
        L73:
            o.pv0 r3 = new o.pv0     // Catch: android.database.sqlite.SQLiteException -> L4f java.lang.Throwable -> L70
            r4 = r13
            r3.<init>(r4, r5, r6, r7, r9)     // Catch: java.lang.Throwable -> L70 android.database.sqlite.SQLiteException -> L85
            r0.add(r3)     // Catch: java.lang.Throwable -> L70 android.database.sqlite.SQLiteException -> L85
        L7c:
            boolean r13 = r11.moveToNext()     // Catch: java.lang.Throwable -> L70 android.database.sqlite.SQLiteException -> L85
            if (r13 != 0) goto L83
            goto L9c
        L83:
            r13 = r4
            goto L3f
        L85:
            r0 = move-exception
            goto L8a
        L87:
            r0 = move-exception
            r4 = r13
            r13 = r0
        L8a:
            o.Nq0 r13 = r1.f     // Catch: java.lang.Throwable -> L70
            o.Kr0.l(r13)     // Catch: java.lang.Throwable -> L70
            o.nl r13 = r13.f     // Catch: java.lang.Throwable -> L70
            java.lang.String r1 = "Error querying user properties. appId"
            o.Lq0 r2 = o.Nq0.A(r4)     // Catch: java.lang.Throwable -> L70
            r13.d(r1, r2, r0)     // Catch: java.lang.Throwable -> L70
            java.util.List r0 = java.util.Collections.EMPTY_LIST     // Catch: java.lang.Throwable -> L70
        L9c:
            if (r11 == 0) goto La1
            r11.close()
        La1:
            return r0
        La2:
            if (r11 == 0) goto La7
            r11.close()
        La7:
            throw r13
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.n0(java.lang.String):java.util.List");
    }

    /* JADX WARN: Code restructure failed: missing block: B:21:0x00b1, code lost:
    
        o.Kr0.l(r13);
        r13.f.c(1000, "Read more than the max allowed user properties, ignoring excess");
     */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:49:0x012e  */
    /* JADX WARN: Removed duplicated region for block: B:53:0x0135  */
    /* JADX WARN: Type inference failed for: r3v0, types: [java.util.ArrayList] */
    /* JADX WARN: Type inference failed for: r3v1, types: [java.util.List] */
    /* JADX WARN: Type inference failed for: r3v3, types: [java.util.List] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final java.util.List o0(java.lang.String r23, java.lang.String r24, java.lang.String r25) throws java.lang.Throwable {
        /*
            Method dump skipped, instructions count: 313
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.o0(java.lang.String, java.lang.String, java.lang.String):java.util.List");
    }

    public final boolean p0(Xn0 xn0) {
        Kr0 kr0 = (Kr0) this.a;
        Preconditions.checkNotNull(xn0);
        r();
        t();
        String str = xn0.l;
        Preconditions.checkNotNull(str);
        if (m0(str, xn0.n.m) == null) {
            long jC0 = c0("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{str});
            kr0.getClass();
            if (jC0 >= 1000) {
                return false;
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", str);
        contentValues.put("origin", xn0.m);
        contentValues.put("name", xn0.n.m);
        b0(contentValues, Preconditions.checkNotNull(xn0.n.b()));
        contentValues.put("active", Boolean.valueOf(xn0.p));
        contentValues.put("trigger_event_name", xn0.q);
        contentValues.put("trigger_timeout", Long.valueOf(xn0.s));
        No0 no0 = xn0.r;
        C2574tv0 c2574tv0 = kr0.i;
        Nq0 nq0 = kr0.f;
        Kr0.j(c2574tv0);
        contentValues.put("timed_out_event", C2574tv0.V(no0));
        contentValues.put("creation_timestamp", Long.valueOf(xn0.f413o));
        Kr0.j(c2574tv0);
        contentValues.put("triggered_event", C2574tv0.V(xn0.t));
        contentValues.put("triggered_timestamp", Long.valueOf(xn0.n.n));
        contentValues.put("time_to_live", Long.valueOf(xn0.u));
        contentValues.put("expired_event", C2574tv0.V(xn0.v));
        try {
            if (h0().insertWithOnConflict("conditional_properties", null, contentValues, 5) != -1) {
                return true;
            }
            Kr0.l(nq0);
            nq0.f.c(Nq0.A(str), "Failed to insert/update conditional user property (got -1)");
            return true;
        } catch (SQLiteException e) {
            Kr0.l(nq0);
            nq0.f.d("Error storing conditional user property", Nq0.A(str), e);
            return true;
        }
    }

    /* JADX WARN: Not initialized variable reg: 10, insn: 0x00f6: MOVE (r9 I:??[OBJECT, ARRAY]) = (r10 I:??[OBJECT, ARRAY]) (LINE:247), block:B:29:0x00f6 */
    /* JADX WARN: Removed duplicated region for block: B:36:0x0116  */
    /* JADX WARN: Removed duplicated region for block: B:39:0x011c  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final o.Xn0 q0(java.lang.String r27, java.lang.String r28) throws java.lang.Throwable {
        /*
            Method dump skipped, instructions count: 288
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.q0(java.lang.String, java.lang.String):o.Xn0");
    }

    public final void r0(String str, String str2) {
        Preconditions.checkNotEmpty(str);
        Preconditions.checkNotEmpty(str2);
        r();
        t();
        try {
            h0().delete("conditional_properties", "app_id=? and name=?", new String[]{str, str2});
        } catch (SQLiteException e) {
            Kr0 kr0 = (Kr0) this.a;
            Nq0 nq0 = kr0.f;
            Kr0.l(nq0);
            nq0.f.e("Error deleting conditional property", Nq0.A(str), kr0.j.c(str2), e);
        }
    }

    public final List s0(String str, String str2, String str3) {
        Preconditions.checkNotEmpty(str);
        r();
        t();
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(str);
        StringBuilder sb = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty(str2)) {
            arrayList.add(str2);
            sb.append(" and origin=?");
        }
        if (!TextUtils.isEmpty(str3)) {
            arrayList.add(String.valueOf(str3).concat("*"));
            sb.append(" and name glob ?");
        }
        return t0(sb.toString(), (String[]) arrayList.toArray(new String[arrayList.size()]));
    }

    /* JADX WARN: Code restructure failed: missing block: B:7:0x0056, code lost:
    
        r3 = r2.f;
        o.Kr0.l(r3);
        r3.f.c(1000, "Read more than the max allowed conditional properties, ignoring extra");
     */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r0v1, types: [java.util.ArrayList] */
    /* JADX WARN: Type inference failed for: r0v3, types: [java.util.List] */
    /* JADX WARN: Type inference failed for: r0v5, types: [java.util.List] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final java.util.List t0(java.lang.String r29, java.lang.String[] r30) {
        /*
            Method dump skipped, instructions count: 278
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.t0(java.lang.String, java.lang.String[]):java.util.List");
    }

    /* JADX WARN: Removed duplicated region for block: B:123:0x03ea  */
    /* JADX WARN: Removed duplicated region for block: B:126:0x03f0  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final o.Xq0 u0(java.lang.String r53) {
        /*
            Method dump skipped, instructions count: 1012
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.u0(java.lang.String):o.Xq0");
    }

    public final void v0(Xq0 xq0, boolean z) {
        Kr0 kr0 = (Kr0) this.a;
        Preconditions.checkNotNull(xq0);
        r();
        t();
        String strD = xq0.D();
        Kr0 kr02 = xq0.a;
        Preconditions.checkNotNull(strD);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", strD);
        EnumC2094os0 enumC2094os0 = EnumC2094os0.n;
        C1051dv0 c1051dv0 = this.b;
        if (z) {
            contentValues.put("app_instance_id", (String) null);
        } else if (c1051dv0.a(strD).i(enumC2094os0)) {
            contentValues.put("app_instance_id", xq0.E());
        }
        contentValues.put("gmp_app_id", xq0.G());
        if (c1051dv0.a(strD).i(EnumC2094os0.m)) {
            Fr0 fr0 = kr02.g;
            Kr0.l(fr0);
            fr0.r();
            contentValues.put("resettable_device_id_hash", xq0.e);
        }
        Fr0 fr02 = kr02.g;
        Kr0.l(fr02);
        fr02.r();
        contentValues.put("last_bundle_index", Long.valueOf(xq0.g));
        Fr0 fr03 = kr02.g;
        Kr0.l(fr03);
        fr03.r();
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(xq0.h));
        Fr0 fr04 = kr02.g;
        Kr0.l(fr04);
        fr04.r();
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(xq0.i));
        contentValues.put("app_version", xq0.N());
        Fr0 fr05 = kr02.g;
        Kr0.l(fr05);
        fr05.r();
        contentValues.put("app_store", xq0.l);
        Fr0 fr06 = kr02.g;
        Kr0.l(fr06);
        fr06.r();
        contentValues.put("gmp_version", Long.valueOf(xq0.m));
        Fr0 fr07 = kr02.g;
        Kr0.l(fr07);
        fr07.r();
        contentValues.put("dev_cert_hash", Long.valueOf(xq0.n));
        Fr0 fr08 = kr02.g;
        Kr0.l(fr08);
        fr08.r();
        contentValues.put("measurement_enabled", Boolean.valueOf(xq0.f415o));
        Fr0 fr09 = kr02.g;
        Fr0 fr010 = kr02.g;
        Kr0.l(fr09);
        fr09.r();
        contentValues.put("day", Long.valueOf(xq0.J));
        Kr0.l(fr010);
        fr010.r();
        contentValues.put("daily_public_events_count", Long.valueOf(xq0.K));
        Kr0.l(fr010);
        fr010.r();
        contentValues.put("daily_events_count", Long.valueOf(xq0.L));
        Kr0.l(fr010);
        fr010.r();
        contentValues.put("daily_conversions_count", Long.valueOf(xq0.M));
        Fr0 fr011 = kr02.g;
        Kr0.l(fr011);
        fr011.r();
        contentValues.put("config_fetched_time", Long.valueOf(xq0.R));
        Fr0 fr012 = kr02.g;
        Kr0.l(fr012);
        fr012.r();
        contentValues.put("failed_config_fetch_time", Long.valueOf(xq0.S));
        contentValues.put("app_version_int", Long.valueOf(xq0.P()));
        contentValues.put("firebase_instance_id", xq0.J());
        Kr0.l(fr010);
        fr010.r();
        contentValues.put("daily_error_events_count", Long.valueOf(xq0.N));
        Kr0.l(fr010);
        fr010.r();
        contentValues.put("daily_realtime_events_count", Long.valueOf(xq0.O));
        Kr0.l(fr010);
        fr010.r();
        contentValues.put("health_monitor_sample", xq0.P);
        contentValues.put("android_id", (Long) 0L);
        Fr0 fr013 = kr02.g;
        Kr0.l(fr013);
        fr013.r();
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(xq0.p));
        contentValues.put("dynamite_version", Long.valueOf(xq0.b()));
        if (c1051dv0.a(strD).i(enumC2094os0)) {
            Fr0 fr014 = kr02.g;
            Kr0.l(fr014);
            fr014.r();
            contentValues.put("session_stitching_token", xq0.t);
        }
        contentValues.put("sgtm_upload_enabled", Boolean.valueOf(xq0.y()));
        Fr0 fr015 = kr02.g;
        Kr0.l(fr015);
        fr015.r();
        contentValues.put("target_os_version", Long.valueOf(xq0.v));
        Fr0 fr016 = kr02.g;
        Kr0.l(fr016);
        fr016.r();
        contentValues.put("session_stitching_token_hash", Long.valueOf(xq0.w));
        Xv0.a();
        C1421ho0 c1421ho0 = kr0.d;
        Nq0 nq0 = kr0.f;
        if (c1421ho0.C(strD, AbstractC1900mq0.P0)) {
            Fr0 fr017 = kr02.g;
            Kr0.l(fr017);
            fr017.r();
            contentValues.put("ad_services_version", Integer.valueOf(xq0.x));
            Fr0 fr018 = kr02.g;
            Kr0.l(fr018);
            fr018.r();
            contentValues.put("attribution_eligibility_status", Long.valueOf(xq0.B));
        }
        Fr0 fr019 = kr02.g;
        Kr0.l(fr019);
        fr019.r();
        contentValues.put("unmatched_first_open_without_ad_id", Boolean.valueOf(xq0.y));
        contentValues.put("npa_metadata_value", xq0.w());
        Fr0 fr020 = kr02.g;
        Kr0.l(fr020);
        fr020.r();
        contentValues.put("bundle_delivery_index", Long.valueOf(xq0.F));
        contentValues.put("sgtm_preview_key", xq0.C());
        Kr0.l(fr010);
        fr010.r();
        contentValues.put("dma_consent_state", Integer.valueOf(xq0.D));
        Kr0.l(fr010);
        fr010.r();
        contentValues.put("daily_realtime_dcu_count", Integer.valueOf(xq0.E));
        contentValues.put("serialized_npa_metadata", xq0.s());
        contentValues.put("client_upload_eligibility", Integer.valueOf(xq0.t()));
        Fr0 fr021 = kr02.g;
        Kr0.l(fr021);
        fr021.r();
        ArrayList arrayList = xq0.s;
        if (arrayList != null) {
            if (arrayList.isEmpty()) {
                Kr0.l(nq0);
                nq0.i.c(strD, "Safelisted events should not be an empty list. appId");
            } else {
                contentValues.put("safelisted_events", TextUtils.join(",", arrayList));
            }
        }
        if (kr0.d.C(null, AbstractC1900mq0.K0) && !contentValues.containsKey("safelisted_events")) {
            contentValues.put("safelisted_events", (String) null);
        }
        Fr0 fr022 = kr02.g;
        Kr0.l(fr022);
        fr022.r();
        contentValues.put("unmatched_pfo", xq0.z);
        Fr0 fr023 = kr02.g;
        Kr0.l(fr023);
        fr023.r();
        contentValues.put("unmatched_uwa", xq0.A);
        Fr0 fr024 = kr02.g;
        Kr0.l(fr024);
        fr024.r();
        contentValues.put("ad_campaign_info", xq0.H);
        try {
            SQLiteDatabase sQLiteDatabaseH0 = h0();
            if (sQLiteDatabaseH0.update("apps", contentValues, "app_id = ?", new String[]{strD}) == 0 && sQLiteDatabaseH0.insertWithOnConflict("apps", null, contentValues, 5) == -1) {
                Kr0.l(nq0);
                nq0.f.c(Nq0.A(strD), "Failed to insert/update app (got -1). appId");
            }
        } catch (SQLiteException e) {
            Kr0.l(nq0);
            nq0.f.d("Error storing app. appId", Nq0.A(strD), e);
        }
    }

    public final long w(String str, Jr0 jr0, String str2, Map map, EnumC1335gt0 enumC1335gt0, Long l2) {
        int iDelete;
        Kr0 kr0 = (Kr0) this.a;
        r();
        t();
        Preconditions.checkNotNull(jr0);
        Preconditions.checkNotEmpty(str);
        r();
        t();
        if (Z()) {
            C1051dv0 c1051dv0 = this.b;
            long jA = c1051dv0.i.f.a();
            Clock clock = kr0.k;
            Nq0 nq0 = kr0.f;
            long jElapsedRealtime = clock.elapsedRealtime();
            if (Math.abs(jElapsedRealtime - jA) > ((Long) AbstractC1900mq0.M.a(null)).longValue()) {
                c1051dv0.i.f.b(jElapsedRealtime);
                r();
                t();
                if (Z() && (iDelete = h0().delete("upload_queue", U(), new String[0])) > 0) {
                    Kr0.l(nq0);
                    nq0.n.c(Integer.valueOf(iDelete), "Deleted stale MeasurementBatch rows from upload_queue. rowsDeleted");
                }
                Preconditions.checkNotEmpty(str);
                r();
                t();
                try {
                    int iA = kr0.d.A(str, AbstractC1900mq0.A);
                    if (iA > 0) {
                        h0().delete("upload_queue", "rowid in (SELECT rowid FROM upload_queue WHERE app_id=? ORDER BY rowid DESC LIMIT -1 OFFSET ?)", new String[]{str, String.valueOf(iA)});
                    }
                } catch (SQLiteException e) {
                    Kr0.l(nq0);
                    nq0.f.d("Error deleting over the limit queued batches. appId", Nq0.A(str), e);
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            String str3 = (String) entry.getKey();
            String str4 = (String) entry.getValue();
            StringBuilder sb = new StringBuilder(String.valueOf(str3).length() + 1 + String.valueOf(str4).length());
            sb.append(str3);
            sb.append("=");
            sb.append(str4);
            arrayList.add(sb.toString());
        }
        byte[] bArrA = jr0.a();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", str);
        contentValues.put("measurement_batch", bArrA);
        contentValues.put("upload_uri", str2);
        StringBuilder sb2 = new StringBuilder();
        Iterator it = arrayList.iterator();
        if (it.hasNext()) {
            while (true) {
                sb2.append((CharSequence) it.next());
                if (!it.hasNext()) {
                    break;
                }
                sb2.append((CharSequence) "\r\n");
            }
        }
        contentValues.put("upload_headers", sb2.toString());
        contentValues.put("upload_type", Integer.valueOf(enumC1335gt0.l));
        Clock clock2 = kr0.k;
        Nq0 nq02 = kr0.f;
        contentValues.put("creation_timestamp", Long.valueOf(clock2.currentTimeMillis()));
        contentValues.put("retry_count", (Integer) 0);
        if (l2 != null) {
            contentValues.put("associated_row_id", l2);
        }
        try {
            long jInsert = h0().insert("upload_queue", null, contentValues);
            if (jInsert != -1) {
                return jInsert;
            }
            Kr0.l(nq02);
            nq02.f.c(str, "Failed to insert MeasurementBatch (got -1) to upload_queue. appId");
            return -1L;
        } catch (SQLiteException e2) {
            Kr0.l(nq02);
            nq02.f.d("Error storing MeasurementBatch to upload_queue. appId", str, e2);
            return -1L;
        }
    }

    public final C2370ro0 w0(long j2, String str, boolean z, boolean z2, boolean z3, boolean z4) {
        return x0(j2, str, 1L, false, false, z, false, z2, z3, z4);
    }

    /* JADX WARN: Removed duplicated region for block: B:27:0x00de  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final java.util.List x(java.lang.String r19, o.Du0 r20, int r21) {
        /*
            r18 = this;
            com.google.android.gms.common.internal.Preconditions.checkNotEmpty(r19)
            r18.r()
            r18.t()
            java.lang.String r0 = " AND NOT "
            java.lang.String r1 = "app_id=?"
            r2 = 0
            android.database.sqlite.SQLiteDatabase r3 = r18.h0()     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            java.lang.String r4 = "upload_queue"
            java.lang.String r5 = "rowId"
            java.lang.String r6 = "app_id"
            java.lang.String r7 = "measurement_batch"
            java.lang.String r8 = "upload_uri"
            java.lang.String r9 = "upload_headers"
            java.lang.String r10 = "upload_type"
            java.lang.String r11 = "retry_count"
            java.lang.String r12 = "creation_timestamp"
            java.lang.String r13 = "associated_row_id"
            java.lang.String r14 = "last_upload_timestamp"
            java.lang.String[] r5 = new java.lang.String[]{r5, r6, r7, r8, r9, r10, r11, r12, r13, r14}     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r6 = r20
            java.util.List r6 = r6.l     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            java.lang.String r6 = V(r6)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            java.lang.String r7 = r18.U()     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            int r8 = r6.length()     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            int r8 = r8 + 17
            int r9 = r7.length()     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            int r8 = r8 + r9
            java.lang.StringBuilder r9 = new java.lang.StringBuilder     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r9.<init>(r8)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r9.append(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r9.append(r6)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r9.append(r0)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r9.append(r7)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            java.lang.String r6 = r9.toString()     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            java.lang.String[] r7 = new java.lang.String[]{r19}     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            java.lang.String r10 = "creation_timestamp ASC"
            if (r21 <= 0) goto L66
            java.lang.String r0 = java.lang.String.valueOf(r21)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r11 = r0
            goto L67
        L66:
            r11 = r2
        L67:
            r8 = 0
            r9 = 0
            android.database.Cursor r2 = r3.query(r4, r5, r6, r7, r8, r9, r10, r11)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            java.util.ArrayList r0 = new java.util.ArrayList     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r0.<init>()     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
        L72:
            boolean r1 = r2.moveToNext()     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            if (r1 == 0) goto Lb9
            r1 = 0
            long r5 = r2.getLong(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r1 = 2
            byte[] r7 = r2.getBlob(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r1 = 3
            java.lang.String r8 = r2.getString(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r1 = 4
            java.lang.String r9 = r2.getString(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r1 = 5
            int r10 = r2.getInt(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r1 = 6
            int r11 = r2.getInt(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r1 = 7
            long r12 = r2.getLong(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r1 = 8
            long r14 = r2.getLong(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r1 = 9
            long r16 = r2.getLong(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            r3 = r18
            r4 = r19
            o.iv0 r1 = r3.T(r4, r5, r7, r8, r9, r10, r11, r12, r14, r16)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            if (r1 == 0) goto L72
            r0.add(r1)     // Catch: java.lang.Throwable -> Lb5 android.database.sqlite.SQLiteException -> Lb7
            goto L72
        Lb5:
            r0 = move-exception
            goto Lbc
        Lb7:
            r0 = move-exception
            goto Lbf
        Lb9:
            r3 = r18
            goto Ld5
        Lbc:
            r3 = r18
            goto Ldc
        Lbf:
            r3 = r18
            java.lang.Object r1 = r3.a     // Catch: java.lang.Throwable -> Ldb
            o.Kr0 r1 = (o.Kr0) r1     // Catch: java.lang.Throwable -> Ldb
            o.Nq0 r1 = r1.f     // Catch: java.lang.Throwable -> Ldb
            o.Kr0.l(r1)     // Catch: java.lang.Throwable -> Ldb
            o.nl r1 = r1.f     // Catch: java.lang.Throwable -> Ldb
            java.lang.String r4 = "Error to querying MeasurementBatch from upload_queue. appId"
            r5 = r19
            r1.d(r4, r5, r0)     // Catch: java.lang.Throwable -> Ldb
            java.util.List r0 = java.util.Collections.EMPTY_LIST     // Catch: java.lang.Throwable -> Ldb
        Ld5:
            if (r2 == 0) goto Lda
            r2.close()
        Lda:
            return r0
        Ldb:
            r0 = move-exception
        Ldc:
            if (r2 == 0) goto Le1
            r2.close()
        Le1:
            throw r0
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.x(java.lang.String, o.Du0, int):java.util.List");
    }

    public final C2370ro0 x0(long j2, String str, long j3, boolean z, boolean z2, boolean z3, boolean z4, boolean z5, boolean z6, boolean z7) {
        Kr0 kr0 = (Kr0) this.a;
        Preconditions.checkNotEmpty(str);
        r();
        t();
        String[] strArr = {str};
        C2370ro0 c2370ro0 = new C2370ro0();
        Cursor cursorQuery = null;
        try {
            try {
                SQLiteDatabase sQLiteDatabaseH0 = h0();
                cursorQuery = sQLiteDatabaseH0.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count", "daily_realtime_dcu_count", "daily_registered_triggers_count"}, "app_id=?", new String[]{str}, null, null, null);
                if (cursorQuery.moveToFirst()) {
                    if (cursorQuery.getLong(0) == j2) {
                        c2370ro0.b = cursorQuery.getLong(1);
                        c2370ro0.a = cursorQuery.getLong(2);
                        c2370ro0.c = cursorQuery.getLong(3);
                        c2370ro0.d = cursorQuery.getLong(4);
                        c2370ro0.e = cursorQuery.getLong(5);
                        c2370ro0.f = cursorQuery.getLong(6);
                        c2370ro0.g = cursorQuery.getLong(7);
                    }
                    if (z) {
                        c2370ro0.b += j3;
                    }
                    if (z2) {
                        c2370ro0.a += j3;
                    }
                    if (z3) {
                        c2370ro0.c += j3;
                    }
                    if (z4) {
                        c2370ro0.d += j3;
                    }
                    if (z5) {
                        c2370ro0.e += j3;
                    }
                    if (z6) {
                        c2370ro0.f += j3;
                    }
                    if (z7) {
                        c2370ro0.g += j3;
                    }
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("day", Long.valueOf(j2));
                    contentValues.put("daily_public_events_count", Long.valueOf(c2370ro0.a));
                    contentValues.put("daily_events_count", Long.valueOf(c2370ro0.b));
                    contentValues.put("daily_conversions_count", Long.valueOf(c2370ro0.c));
                    contentValues.put("daily_error_events_count", Long.valueOf(c2370ro0.d));
                    contentValues.put("daily_realtime_events_count", Long.valueOf(c2370ro0.e));
                    contentValues.put("daily_realtime_dcu_count", Long.valueOf(c2370ro0.f));
                    contentValues.put("daily_registered_triggers_count", Long.valueOf(c2370ro0.g));
                    sQLiteDatabaseH0.update("apps", contentValues, "app_id=?", strArr);
                } else {
                    Nq0 nq0 = kr0.f;
                    Kr0.l(nq0);
                    nq0.i.c(Nq0.A(str), "Not updating daily counts, app is not known. appId");
                }
            } catch (SQLiteException e) {
                Nq0 nq02 = kr0.f;
                Kr0.l(nq02);
                nq02.f.d("Error updating daily counts. appId", Nq0.A(str), e);
            }
            if (cursorQuery != null) {
                cursorQuery.close();
            }
            return c2370ro0;
        } catch (Throwable th) {
            if (0 != 0) {
                cursorQuery.close();
            }
            throw th;
        }
    }

    public final boolean y(String str) {
        EnumC1335gt0[] enumC1335gt0Arr = {EnumC1335gt0.n};
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(Integer.valueOf(enumC1335gt0Arr[0].l));
        String strV = V(arrayList);
        String strU = U();
        StringBuilder sb = new StringBuilder(strV.length() + 61 + strU.length());
        sb.append("SELECT COUNT(1) > 0 FROM upload_queue WHERE app_id=?");
        sb.append(strV);
        sb.append(" AND NOT ");
        sb.append(strU);
        return c0(sb.toString(), new String[]{str}) != 0;
    }

    /* JADX WARN: Not initialized variable reg: 3, insn: 0x006c: MOVE (r2 I:??[OBJECT, ARRAY]) = (r3 I:??[OBJECT, ARRAY]) (LINE:109), block:B:19:0x006c */
    /* JADX WARN: Removed duplicated region for block: B:26:0x0085  */
    /* JADX WARN: Removed duplicated region for block: B:29:0x008b  */
    /* JADX WARN: Removed duplicated region for block: B:35:? A[SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final o.C70 y0(java.lang.String r12) {
        /*
            r11 = this;
            java.lang.Object r0 = r11.a
            r1 = r0
            o.Kr0 r1 = (o.Kr0) r1
            com.google.android.gms.common.internal.Preconditions.checkNotEmpty(r12)
            r11.r()
            r11.t()
            r2 = 0
            android.database.sqlite.SQLiteDatabase r3 = r11.h0()     // Catch: java.lang.Throwable -> L6e android.database.sqlite.SQLiteException -> L71
            java.lang.String r4 = "apps"
            java.lang.String r0 = "remote_config"
            java.lang.String r5 = "config_last_modified_time"
            java.lang.String r6 = "e_tag"
            java.lang.String[] r5 = new java.lang.String[]{r0, r5, r6}     // Catch: java.lang.Throwable -> L6e android.database.sqlite.SQLiteException -> L71
            java.lang.String r6 = "app_id=?"
            java.lang.String[] r7 = new java.lang.String[]{r12}     // Catch: java.lang.Throwable -> L6e android.database.sqlite.SQLiteException -> L71
            r9 = 0
            r10 = 0
            r8 = 0
            android.database.Cursor r3 = r3.query(r4, r5, r6, r7, r8, r9, r10)     // Catch: java.lang.Throwable -> L6e android.database.sqlite.SQLiteException -> L71
            boolean r0 = r3.moveToFirst()     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            if (r0 != 0) goto L33
            goto L83
        L33:
            r0 = 0
            byte[] r0 = r3.getBlob(r0)     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            r4 = 1
            java.lang.String r4 = r3.getString(r4)     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            r5 = 2
            java.lang.String r5 = r3.getString(r5)     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            boolean r6 = r3.moveToNext()     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            if (r6 == 0) goto L5e
            o.Nq0 r6 = r1.f     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            o.Kr0.l(r6)     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            o.nl r6 = r6.f     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            java.lang.String r7 = "Got multiple records for app config, expected one. appId"
            o.Lq0 r8 = o.Nq0.A(r12)     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            r6.c(r8, r7)     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            goto L5e
        L59:
            r0 = move-exception
            r12 = r0
            goto L6c
        L5c:
            r0 = move-exception
            goto L73
        L5e:
            if (r0 != 0) goto L61
            goto L83
        L61:
            o.C70 r6 = new o.C70     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            r7 = 10
            r6.<init>(r0, r4, r5, r7)     // Catch: java.lang.Throwable -> L59 android.database.sqlite.SQLiteException -> L5c
            r3.close()
            return r6
        L6c:
            r2 = r3
            goto L89
        L6e:
            r0 = move-exception
            r12 = r0
            goto L89
        L71:
            r0 = move-exception
            r3 = r2
        L73:
            o.Nq0 r1 = r1.f     // Catch: java.lang.Throwable -> L59
            o.Kr0.l(r1)     // Catch: java.lang.Throwable -> L59
            o.nl r1 = r1.f     // Catch: java.lang.Throwable -> L59
            java.lang.String r4 = "Error querying remote config. appId"
            o.Lq0 r12 = o.Nq0.A(r12)     // Catch: java.lang.Throwable -> L59
            r1.d(r4, r12, r0)     // Catch: java.lang.Throwable -> L59
        L83:
            if (r3 == 0) goto L88
            r3.close()
        L88:
            return r2
        L89:
            if (r2 == 0) goto L8e
            r2.close()
        L8e:
            throw r12
        */
        throw new UnsupportedOperationException("Method not decompiled: o.C2940xo0.y0(java.lang.String):o.C70");
    }

    public final void z(Long l2) {
        Kr0 kr0 = (Kr0) this.a;
        r();
        t();
        Preconditions.checkNotNull(l2);
        try {
            if (h0().delete("upload_queue", "rowid=?", new String[]{l2.toString()}) != 1) {
                Nq0 nq0 = kr0.f;
                Kr0.l(nq0);
                nq0.i.b("Deleted fewer rows from upload_queue than expected");
            }
        } catch (SQLiteException e) {
            Nq0 nq02 = kr0.f;
            Kr0.l(nq02);
            nq02.f.c(e, "Failed to delete a MeasurementBatch in a upload_queue table");
            throw e;
        }
    }

    public final void z0(Nr0 nr0, boolean z) {
        r();
        t();
        Preconditions.checkNotNull(nr0);
        Preconditions.checkNotEmpty(nr0.p());
        Preconditions.checkState(nr0.b2());
        C();
        Kr0 kr0 = (Kr0) this.a;
        Clock clock = kr0.k;
        Nq0 nq0 = kr0.f;
        long jCurrentTimeMillis = clock.currentTimeMillis();
        long jC2 = nr0.c2();
        C1805lq0 c1805lq0 = AbstractC1900mq0.R;
        if (jC2 < jCurrentTimeMillis - ((Long) c1805lq0.a(null)).longValue() || nr0.c2() > ((Long) c1805lq0.a(null)).longValue() + jCurrentTimeMillis) {
            Kr0.l(nq0);
            nq0.i.e("Storing bundle outside of the max uploading time span. appId, now, timestamp", Nq0.A(nr0.p()), Long.valueOf(jCurrentTimeMillis), Long.valueOf(nr0.c2()));
        }
        byte[] bArrA = nr0.a();
        try {
            C1720kv0 c1720kv0 = this.b.g;
            C1051dv0.T(c1720kv0);
            byte[] bArrZ = c1720kv0.Z(bArrA);
            Kr0.l(nq0);
            nq0.n.c(Integer.valueOf(bArrZ.length), "Saving bundle, size");
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_id", nr0.p());
            contentValues.put("bundle_end_timestamp", Long.valueOf(nr0.c2()));
            contentValues.put("data", bArrZ);
            contentValues.put("has_realtime", Integer.valueOf(z ? 1 : 0));
            if (nr0.p0()) {
                contentValues.put("retry_count", Integer.valueOf(nr0.q0()));
            }
            try {
                if (h0().insert("queue", null, contentValues) == -1) {
                    Kr0.l(nq0);
                    nq0.f.c(Nq0.A(nr0.p()), "Failed to insert bundle (got -1). appId");
                }
            } catch (SQLiteException e) {
                Kr0.l(nq0);
                nq0.f.d("Error storing bundle. appId", Nq0.A(nr0.p()), e);
            }
        } catch (IOException e2) {
            Kr0.l(nq0);
            nq0.f.d("Data loss. Failed to serialize bundle. appId", Nq0.A(nr0.p()), e2);
        }
    }

    @Override // o.Iu0
    public final void v() {
    }
}
