package o;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.vJ, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public class C2704vJ extends AbstractC1628jy {
    @Override // o.AbstractC1628jy
    public final R80 a(SV sv) {
        File file = sv.toFile();
        Logger logger = AbstractC2714vT.a;
        return new L9(1, new FileOutputStream(file, true), new Cf0());
    }

    @Override // o.AbstractC1628jy
    public void b(SV sv, SV sv2) throws IOException {
        if (sv.toFile().renameTo(sv2.toFile())) {
            return;
        }
        throw new IOException("failed to move " + sv + " to " + sv2);
    }

    @Override // o.AbstractC1628jy
    public final void c(SV sv) throws IOException {
        if (sv.toFile().mkdir()) {
            return;
        }
        C3135zr c3135zrH = h(sv);
        if (c3135zrH == null || !c3135zrH.c) {
            throw new IOException("failed to create directory: " + sv);
        }
    }

    @Override // o.AbstractC1628jy
    public final void d(SV sv) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException("interrupted");
        }
        File file = sv.toFile();
        if (file.delete() || !file.exists()) {
            return;
        }
        throw new IOException("failed to delete " + sv);
    }

    @Override // o.AbstractC1628jy
    public final List f(SV sv) throws IOException {
        File file = sv.toFile();
        String[] list = file.list();
        if (list == null) {
            if (file.exists()) {
                throw new IOException("failed to list " + sv);
            }
            throw new FileNotFoundException("no such file: " + sv);
        }
        ArrayList arrayList = new ArrayList();
        for (String str : list) {
            arrayList.add(sv.d(str));
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    @Override // o.AbstractC1628jy
    public C3135zr h(SV sv) {
        File file = sv.toFile();
        boolean zIsFile = file.isFile();
        boolean zIsDirectory = file.isDirectory();
        long jLastModified = file.lastModified();
        long length = file.length();
        if (!zIsFile && !zIsDirectory && jLastModified == 0 && length == 0 && !file.exists()) {
            return null;
        }
        return new C3135zr(zIsFile, zIsDirectory, null, Long.valueOf(length), null, Long.valueOf(jLastModified), null);
    }

    @Override // o.AbstractC1628jy
    public final C2609uJ i(SV sv) {
        return new C2609uJ(new RandomAccessFile(sv.toFile(), "r"));
    }

    @Override // o.AbstractC1628jy
    public final R80 j(SV sv) {
        File file = sv.toFile();
        Logger logger = AbstractC2714vT.a;
        return new L9(1, new FileOutputStream(file, false), new Cf0());
    }

    @Override // o.AbstractC1628jy
    public final T90 k(SV sv) {
        File file = sv.toFile();
        Logger logger = AbstractC2714vT.a;
        return new M9(1, new FileInputStream(file), Cf0.d);
    }

    public String toString() {
        return "JvmSystemFileSystem";
    }
}
