package o;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.R;
import com.google.android.material.internal.CheckableImageButton;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.WeakHashMap;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.bO, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public final class C0806bO<S> extends androidx.fragment.app.g {
    public CharSequence A;
    public int B;
    public CharSequence C;
    public TextView D;
    public CheckableImageButton E;
    public C1092eO F;
    public boolean G;
    public CharSequence H;
    public CharSequence I;
    public final LinkedHashSet l;
    public final LinkedHashSet m;
    public int n;

    /* renamed from: o, reason: collision with root package name */
    public RW f456o;
    public C0576Wf p;
    public VN q;
    public int r;
    public CharSequence s;
    public boolean t;
    public int u;
    public int v;
    public CharSequence w;
    public int x;
    public CharSequence y;
    public int z;

    public C0806bO() {
        new LinkedHashSet();
        new LinkedHashSet();
        this.l = new LinkedHashSet();
        this.m = new LinkedHashSet();
    }

    public static int h(Context context) throws Resources.NotFoundException {
        Resources resources = context.getResources();
        int dimensionPixelOffset = resources.getDimensionPixelOffset(R.dimen.mtrl_calendar_content_padding);
        Calendar calendarB = AbstractC1789li0.b();
        calendarB.set(5, 1);
        Calendar calendarA = AbstractC1789li0.a(calendarB);
        calendarA.get(2);
        calendarA.get(1);
        int maximum = calendarA.getMaximum(7);
        calendarA.getActualMaximum(5);
        calendarA.getTimeInMillis();
        int dimensionPixelSize = resources.getDimensionPixelSize(R.dimen.mtrl_calendar_day_width) * maximum;
        return ((maximum - 1) * resources.getDimensionPixelOffset(R.dimen.mtrl_calendar_month_horizontal_padding)) + dimensionPixelSize + (dimensionPixelOffset * 2);
    }

    public static boolean i(Context context, int i) throws Resources.NotFoundException {
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(C80.V(context, R.attr.materialCalendarStyle, VN.class.getCanonicalName()).data, new int[]{i});
        boolean z = typedArrayObtainStyledAttributes.getBoolean(0, false);
        typedArrayObtainStyledAttributes.recycle();
        return z;
    }

    public final void g() {
        if (getArguments().getParcelable("DATE_SELECTOR_KEY") != null) {
            throw new ClassCastException();
        }
    }

    @Override // androidx.fragment.app.g, android.content.DialogInterface.OnCancelListener
    public final void onCancel(DialogInterface dialogInterface) {
        Iterator it = this.l.iterator();
        while (it.hasNext()) {
            ((DialogInterface.OnCancelListener) it.next()).onCancel(dialogInterface);
        }
    }

    @Override // androidx.fragment.app.g, androidx.fragment.app.l
    public final void onCreate(Bundle bundle) throws Resources.NotFoundException {
        super.onCreate(bundle);
        if (bundle == null) {
            bundle = getArguments();
        }
        this.n = bundle.getInt("OVERRIDE_THEME_RES_ID");
        if (bundle.getParcelable("DATE_SELECTOR_KEY") != null) {
            throw new ClassCastException();
        }
        this.p = (C0576Wf) bundle.getParcelable("CALENDAR_CONSTRAINTS_KEY");
        if (bundle.getParcelable("DAY_VIEW_DECORATOR_KEY") != null) {
            throw new ClassCastException();
        }
        this.r = bundle.getInt("TITLE_TEXT_RES_ID_KEY");
        this.s = bundle.getCharSequence("TITLE_TEXT_KEY");
        this.u = bundle.getInt("INPUT_MODE_KEY");
        this.v = bundle.getInt("POSITIVE_BUTTON_TEXT_RES_ID_KEY");
        this.w = bundle.getCharSequence("POSITIVE_BUTTON_TEXT_KEY");
        this.x = bundle.getInt("POSITIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY");
        this.y = bundle.getCharSequence("POSITIVE_BUTTON_CONTENT_DESCRIPTION_KEY");
        this.z = bundle.getInt("NEGATIVE_BUTTON_TEXT_RES_ID_KEY");
        this.A = bundle.getCharSequence("NEGATIVE_BUTTON_TEXT_KEY");
        this.B = bundle.getInt("NEGATIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY");
        this.C = bundle.getCharSequence("NEGATIVE_BUTTON_CONTENT_DESCRIPTION_KEY");
        CharSequence text = this.s;
        if (text == null) {
            text = requireContext().getResources().getText(this.r);
        }
        this.H = text;
        if (text != null) {
            CharSequence[] charSequenceArrSplit = TextUtils.split(String.valueOf(text), "\n");
            if (charSequenceArrSplit.length > 1) {
                text = charSequenceArrSplit[0];
            }
        } else {
            text = null;
        }
        this.I = text;
    }

    @Override // androidx.fragment.app.g
    public final Dialog onCreateDialog(Bundle bundle) {
        Context contextRequireContext = requireContext();
        requireContext();
        int i = this.n;
        if (i == 0) {
            g();
            throw null;
        }
        Dialog dialog = new Dialog(contextRequireContext, i);
        Context context = dialog.getContext();
        this.t = i(context, android.R.attr.windowFullscreen);
        this.F = new C1092eO(context, null, R.attr.materialCalendarStyle, R.style.Widget_MaterialComponents_MaterialCalendar);
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(null, XZ.l, R.attr.materialCalendarStyle, R.style.Widget_MaterialComponents_MaterialCalendar);
        int color = typedArrayObtainStyledAttributes.getColor(1, 0);
        typedArrayObtainStyledAttributes.recycle();
        this.F.h(context);
        this.F.j(ColorStateList.valueOf(color));
        C1092eO c1092eO = this.F;
        View decorView = dialog.getWindow().getDecorView();
        WeakHashMap weakHashMap = Oj0.a;
        c1092eO.i(Gj0.e(decorView));
        return dialog;
    }

    @Override // androidx.fragment.app.l
    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View viewInflate = layoutInflater.inflate(this.t ? R.layout.mtrl_picker_fullscreen : R.layout.mtrl_picker_dialog, viewGroup);
        Context context = viewInflate.getContext();
        if (this.t) {
            viewInflate.findViewById(R.id.mtrl_calendar_frame).setLayoutParams(new LinearLayout.LayoutParams(h(context), -2));
        } else {
            viewInflate.findViewById(R.id.mtrl_calendar_main_pane).setLayoutParams(new LinearLayout.LayoutParams(h(context), -1));
        }
        TextView textView = (TextView) viewInflate.findViewById(R.id.mtrl_picker_header_selection_text);
        WeakHashMap weakHashMap = Oj0.a;
        textView.setAccessibilityLiveRegion(1);
        this.E = (CheckableImageButton) viewInflate.findViewById(R.id.mtrl_picker_header_toggle);
        this.D = (TextView) viewInflate.findViewById(R.id.mtrl_picker_title_text);
        this.E.setTag("TOGGLE_BUTTON_TAG");
        CheckableImageButton checkableImageButton = this.E;
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{android.R.attr.state_checked}, C80.x(context, R.drawable.material_ic_calendar_black_24dp));
        stateListDrawable.addState(new int[0], C80.x(context, R.drawable.material_ic_edit_black_24dp));
        checkableImageButton.setImageDrawable(stateListDrawable);
        this.E.setChecked(this.u != 0);
        Oj0.m(this.E, null);
        CheckableImageButton checkableImageButton2 = this.E;
        this.E.setContentDescription(this.u == 1 ? checkableImageButton2.getContext().getString(R.string.mtrl_picker_toggle_to_calendar_input_mode) : checkableImageButton2.getContext().getString(R.string.mtrl_picker_toggle_to_text_input_mode));
        this.E.setOnClickListener(new ViewOnClickListenerC0604Xh(3, this));
        g();
        throw null;
    }

    @Override // androidx.fragment.app.g, android.content.DialogInterface.OnDismissListener
    public final void onDismiss(DialogInterface dialogInterface) {
        Iterator it = this.m.iterator();
        while (it.hasNext()) {
            ((DialogInterface.OnDismissListener) it.next()).onDismiss(dialogInterface);
        }
        ViewGroup viewGroup = (ViewGroup) getView();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        super.onDismiss(dialogInterface);
    }

    @Override // androidx.fragment.app.g, androidx.fragment.app.l
    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt("OVERRIDE_THEME_RES_ID", this.n);
        bundle.putParcelable("DATE_SELECTOR_KEY", null);
        C0576Wf c0576Wf = this.p;
        C0550Vf c0550Vf = new C0550Vf();
        int i = C0550Vf.b;
        int i2 = C0550Vf.b;
        long j = c0576Wf.l.q;
        long j2 = c0576Wf.m.q;
        c0550Vf.a = Long.valueOf(c0576Wf.f398o.q);
        int i3 = c0576Wf.p;
        C0119Ep c0119Ep = c0576Wf.n;
        VN vn = this.q;
        TP tp = vn == null ? null : vn.f374o;
        if (tp != null) {
            c0550Vf.a = Long.valueOf(tp.q);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("DEEP_COPY_VALIDATOR_KEY", c0119Ep);
        TP tpB = TP.b(j);
        TP tpB2 = TP.b(j2);
        C0119Ep c0119Ep2 = (C0119Ep) bundle2.getParcelable("DEEP_COPY_VALIDATOR_KEY");
        Long l = c0550Vf.a;
        bundle.putParcelable("CALENDAR_CONSTRAINTS_KEY", new C0576Wf(tpB, tpB2, c0119Ep2, l == null ? null : TP.b(l.longValue()), i3));
        bundle.putParcelable("DAY_VIEW_DECORATOR_KEY", null);
        bundle.putInt("TITLE_TEXT_RES_ID_KEY", this.r);
        bundle.putCharSequence("TITLE_TEXT_KEY", this.s);
        bundle.putInt("INPUT_MODE_KEY", this.u);
        bundle.putInt("POSITIVE_BUTTON_TEXT_RES_ID_KEY", this.v);
        bundle.putCharSequence("POSITIVE_BUTTON_TEXT_KEY", this.w);
        bundle.putInt("POSITIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY", this.x);
        bundle.putCharSequence("POSITIVE_BUTTON_CONTENT_DESCRIPTION_KEY", this.y);
        bundle.putInt("NEGATIVE_BUTTON_TEXT_RES_ID_KEY", this.z);
        bundle.putCharSequence("NEGATIVE_BUTTON_TEXT_KEY", this.A);
        bundle.putInt("NEGATIVE_BUTTON_CONTENT_DESCRIPTION_RES_ID_KEY", this.B);
        bundle.putCharSequence("NEGATIVE_BUTTON_CONTENT_DESCRIPTION_KEY", this.C);
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r4v20, types: [o.Nl0] */
    /* JADX WARN: Type inference failed for: r4v24, types: [o.Nl0] */
    /* JADX WARN: Type inference failed for: r7v11, types: [o.Nl0] */
    /* JADX WARN: Type inference failed for: r7v16, types: [o.Nl0] */
    @Override // androidx.fragment.app.g, androidx.fragment.app.l
    public final void onStart() throws Resources.NotFoundException {
        Ll0 ml0;
        Ll0 ml02;
        super.onStart();
        Window window = requireDialog().getWindow();
        if (this.t) {
            window.setLayout(-1, -1);
            window.setBackgroundDrawable(this.F);
            if (!this.G) {
                View viewFindViewById = requireView().findViewById(R.id.fullscreen_header);
                ColorStateList colorStateListA = Co0.A(viewFindViewById.getBackground());
                Integer numValueOf = colorStateListA != null ? Integer.valueOf(colorStateListA.getDefaultColor()) : null;
                int i = Build.VERSION.SDK_INT;
                boolean z = false;
                boolean z2 = numValueOf == null || numValueOf.intValue() == 0;
                int iR = AbstractC1692kh0.r(window.getContext(), android.R.attr.colorBackground, -16777216);
                if (z2) {
                    numValueOf = Integer.valueOf(iR);
                }
                F3.N(window, false);
                window.getContext();
                int iD = i < 27 ? AbstractC0501Ti.d(AbstractC1692kh0.r(window.getContext(), android.R.attr.navigationBarColor, -16777216), 128) : 0;
                window.setStatusBarColor(0);
                window.setNavigationBarColor(iD);
                boolean z3 = AbstractC1692kh0.A(0) || AbstractC1692kh0.A(numValueOf.intValue());
                WT wt = new WT(window.getDecorView());
                int i2 = Build.VERSION.SDK_INT;
                if (i2 >= 35) {
                    ?? ol0 = new Ol0(window.getInsetsController(), wt);
                    ol0.n = window;
                    ml0 = ol0;
                } else if (i2 >= 30) {
                    ?? nl0 = new Nl0(window.getInsetsController(), wt);
                    nl0.n = window;
                    ml0 = nl0;
                } else {
                    ml0 = i2 >= 26 ? new Ml0(window, wt) : new Ll0(window, wt);
                }
                ml0.H(z3);
                boolean zA = AbstractC1692kh0.A(iR);
                if (AbstractC1692kh0.A(iD) || (iD == 0 && zA)) {
                    z = true;
                }
                WT wt2 = new WT(window.getDecorView());
                int i3 = Build.VERSION.SDK_INT;
                if (i3 >= 35) {
                    ?? ol02 = new Ol0(window.getInsetsController(), wt2);
                    ol02.n = window;
                    ml02 = ol02;
                } else if (i3 >= 30) {
                    ?? nl02 = new Nl0(window.getInsetsController(), wt2);
                    nl02.n = window;
                    ml02 = nl02;
                } else {
                    ml02 = i3 >= 26 ? new Ml0(window, wt2) : new Ll0(window, wt2);
                }
                ml02.G(z);
                C0710aO c0710aO = new C0710aO(viewFindViewById, viewFindViewById.getLayoutParams().height, viewFindViewById.getPaddingTop());
                WeakHashMap weakHashMap = Oj0.a;
                Gj0.l(viewFindViewById, c0710aO);
                this.G = true;
            }
        } else {
            window.setLayout(-2, -2);
            int dimensionPixelOffset = getResources().getDimensionPixelOffset(R.dimen.mtrl_calendar_dialog_background_inset);
            Rect rect = new Rect(dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset);
            window.setBackgroundDrawable(new InsetDrawable((Drawable) this.F, dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset, dimensionPixelOffset));
            window.getDecorView().setOnTouchListener(new JH(requireDialog(), rect));
        }
        requireContext();
        int i4 = this.n;
        if (i4 == 0) {
            g();
            throw null;
        }
        g();
        C0576Wf c0576Wf = this.p;
        VN vn = new VN();
        Bundle bundle = new Bundle();
        bundle.putInt("THEME_RES_ID_KEY", i4);
        bundle.putParcelable("GRID_SELECTOR_KEY", null);
        bundle.putParcelable("CALENDAR_CONSTRAINTS_KEY", c0576Wf);
        bundle.putParcelable("DAY_VIEW_DECORATOR_KEY", null);
        bundle.putParcelable("CURRENT_MONTH_KEY", c0576Wf.f398o);
        vn.setArguments(bundle);
        this.q = vn;
        RW rw = vn;
        if (this.u == 1) {
            g();
            C0576Wf c0576Wf2 = this.p;
            RW c1188fO = new C1188fO();
            Bundle bundle2 = new Bundle();
            bundle2.putInt("THEME_RES_ID_KEY", i4);
            bundle2.putParcelable("DATE_SELECTOR_KEY", null);
            bundle2.putParcelable("CALENDAR_CONSTRAINTS_KEY", c0576Wf2);
            c1188fO.setArguments(bundle2);
            rw = c1188fO;
        }
        this.f456o = rw;
        this.D.setText((this.u == 1 && getResources().getConfiguration().orientation == 2) ? this.I : this.H);
        g();
        getContext();
        throw null;
    }

    @Override // androidx.fragment.app.g, androidx.fragment.app.l
    public final void onStop() {
        this.f456o.l.clear();
        super.onStop();
    }
}
