package o;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.ax, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public final class C0768ax extends AbstractC0671Zw implements InterfaceC0405Pq {
    public final Executor m;

    public C0768ax(Executor executor) {
        this.m = executor;
        if (executor instanceof ScheduledThreadPoolExecutor) {
            ((ScheduledThreadPoolExecutor) executor).setRemoveOnCancelPolicy(true);
        }
    }

    @Override // o.InterfaceC0405Pq
    public final void G(long j, C2448sg c2448sg) {
        Executor executor = this.m;
        ScheduledFuture<?> scheduledFutureSchedule = null;
        ScheduledExecutorService scheduledExecutorService = executor instanceof ScheduledExecutorService ? (ScheduledExecutorService) executor : null;
        if (scheduledExecutorService != null) {
            RunnableC0890cD runnableC0890cD = new RunnableC0890cD(12, this, c2448sg);
            InterfaceC2747vn interfaceC2747vn = c2448sg.p;
            try {
                scheduledFutureSchedule = scheduledExecutorService.schedule(runnableC0890cD, j, TimeUnit.MILLISECONDS);
            } catch (RejectedExecutionException e) {
                CancellationException cancellationException = new CancellationException("The task was rejected");
                cancellationException.initCause(e);
                AbstractC0752ap.s(interfaceC2747vn, cancellationException);
            }
        }
        if (scheduledFutureSchedule != null) {
            c2448sg.x(new C1499ig(0, scheduledFutureSchedule));
        } else {
            RunnableC0534Up.s.G(j, c2448sg);
        }
    }

    @Override // o.AbstractC2842wn
    public final void T(InterfaceC2747vn interfaceC2747vn, Runnable runnable) {
        try {
            this.m.execute(runnable);
        } catch (RejectedExecutionException e) {
            CancellationException cancellationException = new CancellationException("The task was rejected");
            cancellationException.initCause(e);
            AbstractC0752ap.s(interfaceC2747vn, cancellationException);
            C2468sq c2468sq = AbstractC1903ms.a;
            ExecutorC1232fq.m.T(interfaceC2747vn, runnable);
        }
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable
    public final void close() {
        Executor executor = this.m;
        ExecutorService executorService = executor instanceof ExecutorService ? (ExecutorService) executor : null;
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public final boolean equals(Object obj) {
        return (obj instanceof C0768ax) && ((C0768ax) obj).m == this.m;
    }

    public final int hashCode() {
        return System.identityHashCode(this.m);
    }

    @Override // o.AbstractC2842wn
    public final String toString() {
        return this.m.toString();
    }

    @Override // o.InterfaceC0405Pq
    public final InterfaceC2567ts u(long j, Ef0 ef0, InterfaceC2747vn interfaceC2747vn) {
        Executor executor = this.m;
        ScheduledFuture<?> scheduledFutureSchedule = null;
        ScheduledExecutorService scheduledExecutorService = executor instanceof ScheduledExecutorService ? (ScheduledExecutorService) executor : null;
        if (scheduledExecutorService != null) {
            try {
                scheduledFutureSchedule = scheduledExecutorService.schedule(ef0, j, TimeUnit.MILLISECONDS);
            } catch (RejectedExecutionException e) {
                CancellationException cancellationException = new CancellationException("The task was rejected");
                cancellationException.initCause(e);
                AbstractC0752ap.s(interfaceC2747vn, cancellationException);
            }
        }
        return scheduledFutureSchedule != null ? new C2472ss(scheduledFutureSchedule) : RunnableC0534Up.s.u(j, ef0, interfaceC2747vn);
    }
}
