package o;

import android.R;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.google.android.material.chip.Chip;
import java.lang.ref.WeakReference;
import java.util.Arrays;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.Oh, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public final class C0370Oh extends C1092eO implements Drawable.Callback, Cd0 {
    public static final int[] Q0 = {R.attr.state_enabled};
    public static final ShapeDrawable R0 = new ShapeDrawable(new OvalShape());
    public int A0;
    public int B0;
    public boolean C0;
    public int D0;
    public int E0;
    public ColorFilter F0;
    public PorterDuffColorFilter G0;
    public ColorStateList H0;
    public ColorStateList I;
    public PorterDuff.Mode I0;
    public ColorStateList J;
    public int[] J0;
    public float K;
    public ColorStateList K0;
    public float L;
    public WeakReference L0;
    public ColorStateList M;
    public TextUtils.TruncateAt M0;
    public float N;
    public boolean N0;
    public ColorStateList O;
    public int O0;
    public CharSequence P;
    public boolean P0;
    public boolean Q;
    public Drawable R;
    public ColorStateList S;
    public float T;
    public boolean U;
    public boolean V;
    public Drawable W;
    public RippleDrawable X;
    public ColorStateList Y;
    public float Z;
    public SpannableStringBuilder a0;
    public boolean b0;
    public boolean c0;
    public Drawable d0;
    public ColorStateList e0;
    public C0999dQ f0;
    public C0999dQ g0;
    public float h0;
    public float i0;
    public float j0;
    public float k0;
    public float l0;
    public float m0;
    public float n0;
    public float o0;
    public final Context p0;
    public final Paint q0;
    public final Paint.FontMetrics r0;
    public final RectF s0;
    public final PointF t0;
    public final Path u0;
    public final Dd0 v0;
    public int w0;
    public int x0;
    public int y0;
    public int z0;

    public C0370Oh(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action);
        this.L = -1.0f;
        this.q0 = new Paint(1);
        this.r0 = new Paint.FontMetrics();
        this.s0 = new RectF();
        this.t0 = new PointF();
        this.u0 = new Path();
        this.E0 = 255;
        this.I0 = PorterDuff.Mode.SRC_IN;
        this.L0 = new WeakReference(null);
        h(context);
        this.p0 = context;
        Dd0 dd0 = new Dd0(this);
        this.v0 = dd0;
        this.P = "";
        dd0.a.density = context.getResources().getDisplayMetrics().density;
        int[] iArr = Q0;
        setState(iArr);
        if (!Arrays.equals(this.J0, iArr)) {
            this.J0 = iArr;
            if (T()) {
                v(getState(), iArr);
            }
        }
        this.N0 = true;
        R0.setTint(-1);
    }

    public static void U(Drawable drawable) {
        if (drawable != null) {
            drawable.setCallback(null);
        }
    }

    public static boolean s(ColorStateList colorStateList) {
        return colorStateList != null && colorStateList.isStateful();
    }

    public static boolean t(Drawable drawable) {
        return drawable != null && drawable.isStateful();
    }

    public final void A(float f) {
        if (this.L != f) {
            this.L = f;
            M70 m70E = this.l.a.e();
            m70E.e = new C1915n(f);
            m70E.f = new C1915n(f);
            m70E.g = new C1915n(f);
            m70E.h = new C1915n(f);
            setShapeAppearanceModel(m70E.a());
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    public final void B(Drawable drawable) {
        Drawable drawable2;
        Drawable drawable3 = this.R;
        if (drawable3 != 0) {
            boolean z = drawable3 instanceof Rm0;
            drawable2 = drawable3;
            if (z) {
                drawable2 = null;
            }
        } else {
            drawable2 = null;
        }
        if (drawable2 != drawable) {
            float fP = p();
            this.R = drawable != null ? drawable.mutate() : null;
            float fP2 = p();
            U(drawable2);
            if (S()) {
                n(this.R);
            }
            invalidateSelf();
            if (fP != fP2) {
                u();
            }
        }
    }

    public final void C(float f) {
        if (this.T != f) {
            float fP = p();
            this.T = f;
            float fP2 = p();
            invalidateSelf();
            if (fP != fP2) {
                u();
            }
        }
    }

    public final void D(ColorStateList colorStateList) {
        this.U = true;
        if (this.S != colorStateList) {
            this.S = colorStateList;
            if (S()) {
                this.R.setTintList(colorStateList);
            }
            onStateChange(getState());
        }
    }

    public final void E(boolean z) {
        if (this.Q != z) {
            boolean zS = S();
            this.Q = z;
            boolean zS2 = S();
            if (zS != zS2) {
                if (zS2) {
                    n(this.R);
                } else {
                    U(this.R);
                }
                invalidateSelf();
                u();
            }
        }
    }

    public final void F(ColorStateList colorStateList) {
        if (this.M != colorStateList) {
            this.M = colorStateList;
            if (this.P0) {
                C0997dO c0997dO = this.l;
                if (c0997dO.d != colorStateList) {
                    c0997dO.d = colorStateList;
                    onStateChange(getState());
                }
            }
            onStateChange(getState());
        }
    }

    public final void G(float f) {
        if (this.N != f) {
            this.N = f;
            this.q0.setStrokeWidth(f);
            if (this.P0) {
                this.l.j = f;
                invalidateSelf();
            }
            invalidateSelf();
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    public final void H(Drawable drawable) {
        Drawable drawable2;
        Drawable drawable3 = this.W;
        if (drawable3 != 0) {
            boolean z = drawable3 instanceof Rm0;
            drawable2 = drawable3;
            if (z) {
                drawable2 = null;
            }
        } else {
            drawable2 = null;
        }
        if (drawable2 != drawable) {
            float fQ = q();
            this.W = drawable != null ? drawable.mutate() : null;
            this.X = new RippleDrawable(AbstractC1904ms0.u(this.O), this.W, R0);
            float fQ2 = q();
            U(drawable2);
            if (T()) {
                n(this.W);
            }
            invalidateSelf();
            if (fQ != fQ2) {
                u();
            }
        }
    }

    public final void I(float f) {
        if (this.n0 != f) {
            this.n0 = f;
            invalidateSelf();
            if (T()) {
                u();
            }
        }
    }

    public final void J(float f) {
        if (this.Z != f) {
            this.Z = f;
            invalidateSelf();
            if (T()) {
                u();
            }
        }
    }

    public final void K(float f) {
        if (this.m0 != f) {
            this.m0 = f;
            invalidateSelf();
            if (T()) {
                u();
            }
        }
    }

    public final void L(ColorStateList colorStateList) {
        if (this.Y != colorStateList) {
            this.Y = colorStateList;
            if (T()) {
                this.W.setTintList(colorStateList);
            }
            onStateChange(getState());
        }
    }

    public final void M(boolean z) {
        if (this.V != z) {
            boolean zT = T();
            this.V = z;
            boolean zT2 = T();
            if (zT != zT2) {
                if (zT2) {
                    n(this.W);
                } else {
                    U(this.W);
                }
                invalidateSelf();
                u();
            }
        }
    }

    public final void N(float f) {
        if (this.j0 != f) {
            float fP = p();
            this.j0 = f;
            float fP2 = p();
            invalidateSelf();
            if (fP != fP2) {
                u();
            }
        }
    }

    public final void O(float f) {
        if (this.i0 != f) {
            float fP = p();
            this.i0 = f;
            float fP2 = p();
            invalidateSelf();
            if (fP != fP2) {
                u();
            }
        }
    }

    public final void P(ColorStateList colorStateList) {
        if (this.O != colorStateList) {
            this.O = colorStateList;
            this.K0 = null;
            onStateChange(getState());
        }
    }

    public final void Q(C1016dd0 c1016dd0) {
        Dd0 dd0 = this.v0;
        C0267Kh c0267Kh = dd0.b;
        TextPaint textPaint = dd0.a;
        if (dd0.f != c1016dd0) {
            dd0.f = c1016dd0;
            if (c1016dd0 != null) {
                Context context = this.p0;
                c1016dd0.f(context, textPaint, c0267Kh);
                Cd0 cd0 = (Cd0) dd0.e.get();
                if (cd0 != null) {
                    textPaint.drawableState = cd0.getState();
                }
                c1016dd0.e(context, textPaint, c0267Kh);
                dd0.d = true;
            }
            Cd0 cd02 = (Cd0) dd0.e.get();
            if (cd02 != null) {
                C0370Oh c0370Oh = (C0370Oh) cd02;
                c0370Oh.u();
                c0370Oh.invalidateSelf();
                c0370Oh.onStateChange(cd02.getState());
            }
        }
    }

    public final boolean R() {
        return this.c0 && this.d0 != null && this.C0;
    }

    public final boolean S() {
        return this.Q && this.R != null;
    }

    public final boolean T() {
        return this.V && this.W != null;
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final void draw(Canvas canvas) {
        int i;
        Canvas canvas2;
        int iSaveLayerAlpha;
        int i2;
        Rect bounds = getBounds();
        if (bounds.isEmpty() || (i = this.E0) == 0) {
            return;
        }
        if (i < 255) {
            canvas2 = canvas;
            iSaveLayerAlpha = canvas2.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, i);
        } else {
            canvas2 = canvas;
            iSaveLayerAlpha = 0;
        }
        boolean z = this.P0;
        Paint paint = this.q0;
        RectF rectF = this.s0;
        if (!z) {
            paint.setColor(this.w0);
            paint.setStyle(Paint.Style.FILL);
            rectF.set(bounds);
            canvas2.drawRoundRect(rectF, r(), r(), paint);
        }
        if (!this.P0) {
            paint.setColor(this.x0);
            paint.setStyle(Paint.Style.FILL);
            ColorFilter colorFilter = this.F0;
            if (colorFilter == null) {
                colorFilter = this.G0;
            }
            paint.setColorFilter(colorFilter);
            rectF.set(bounds);
            canvas2.drawRoundRect(rectF, r(), r(), paint);
        }
        if (this.P0) {
            super.draw(canvas);
        }
        if (this.N > 0.0f && !this.P0) {
            paint.setColor(this.z0);
            paint.setStyle(Paint.Style.STROKE);
            if (!this.P0) {
                ColorFilter colorFilter2 = this.F0;
                if (colorFilter2 == null) {
                    colorFilter2 = this.G0;
                }
                paint.setColorFilter(colorFilter2);
            }
            float f = bounds.left;
            float f2 = this.N / 2.0f;
            rectF.set(f + f2, bounds.top + f2, bounds.right - f2, bounds.bottom - f2);
            float f3 = this.L - (this.N / 2.0f);
            canvas2.drawRoundRect(rectF, f3, f3, paint);
        }
        paint.setColor(this.A0);
        paint.setStyle(Paint.Style.FILL);
        rectF.set(bounds);
        if (this.P0) {
            RectF rectF2 = new RectF(bounds);
            C0997dO c0997dO = this.l;
            N70 n70 = c0997dO.a;
            float f4 = c0997dO.i;
            C0247Jn c0247Jn = this.B;
            P70 p70 = this.C;
            Path path = this.u0;
            p70.a(n70, f4, rectF2, c0247Jn, path);
            d(canvas2, paint, path, this.l.a, f());
        } else {
            canvas2.drawRoundRect(rectF, r(), r(), paint);
        }
        if (S()) {
            o(bounds, rectF);
            float f5 = rectF.left;
            float f6 = rectF.top;
            canvas2.translate(f5, f6);
            this.R.setBounds(0, 0, (int) rectF.width(), (int) rectF.height());
            this.R.draw(canvas2);
            canvas2.translate(-f5, -f6);
        }
        if (R()) {
            o(bounds, rectF);
            float f7 = rectF.left;
            float f8 = rectF.top;
            canvas2.translate(f7, f8);
            this.d0.setBounds(0, 0, (int) rectF.width(), (int) rectF.height());
            this.d0.draw(canvas2);
            canvas2.translate(-f7, -f8);
        }
        if (this.N0 && this.P != null) {
            PointF pointF = this.t0;
            pointF.set(0.0f, 0.0f);
            Paint.Align align = Paint.Align.LEFT;
            CharSequence charSequence = this.P;
            Dd0 dd0 = this.v0;
            if (charSequence != null) {
                float fP = p() + this.h0 + this.k0;
                if (getLayoutDirection() == 0) {
                    pointF.x = bounds.left + fP;
                } else {
                    pointF.x = bounds.right - fP;
                    align = Paint.Align.RIGHT;
                }
                float fCenterY = bounds.centerY();
                TextPaint textPaint = dd0.a;
                Paint.FontMetrics fontMetrics = this.r0;
                textPaint.getFontMetrics(fontMetrics);
                pointF.y = fCenterY - ((fontMetrics.descent + fontMetrics.ascent) / 2.0f);
            }
            rectF.setEmpty();
            if (this.P != null) {
                float fP2 = p() + this.h0 + this.k0;
                float fQ = q() + this.o0 + this.l0;
                if (getLayoutDirection() == 0) {
                    rectF.left = bounds.left + fP2;
                    rectF.right = bounds.right - fQ;
                } else {
                    rectF.left = bounds.left + fQ;
                    rectF.right = bounds.right - fP2;
                }
                rectF.top = bounds.top;
                rectF.bottom = bounds.bottom;
            }
            C1016dd0 c1016dd0 = dd0.f;
            TextPaint textPaint2 = dd0.a;
            if (c1016dd0 != null) {
                textPaint2.drawableState = getState();
                dd0.f.e(this.p0, textPaint2, dd0.b);
            }
            textPaint2.setTextAlign(align);
            boolean z2 = Math.round(dd0.a(this.P.toString())) > Math.round(rectF.width());
            if (z2) {
                int iSave = canvas2.save();
                canvas2.clipRect(rectF);
                i2 = iSave;
            } else {
                i2 = 0;
            }
            CharSequence charSequenceEllipsize = this.P;
            if (z2 && this.M0 != null) {
                charSequenceEllipsize = TextUtils.ellipsize(charSequenceEllipsize, textPaint2, rectF.width(), this.M0);
            }
            canvas.drawText(charSequenceEllipsize, 0, charSequenceEllipsize.length(), pointF.x, pointF.y, textPaint2);
            canvas2 = canvas;
            if (z2) {
                canvas2.restoreToCount(i2);
            }
        }
        if (T()) {
            rectF.setEmpty();
            if (T()) {
                float f9 = this.o0 + this.n0;
                if (getLayoutDirection() == 0) {
                    float f10 = bounds.right - f9;
                    rectF.right = f10;
                    rectF.left = f10 - this.Z;
                } else {
                    float f11 = bounds.left + f9;
                    rectF.left = f11;
                    rectF.right = f11 + this.Z;
                }
                float fExactCenterY = bounds.exactCenterY();
                float f12 = this.Z;
                float f13 = fExactCenterY - (f12 / 2.0f);
                rectF.top = f13;
                rectF.bottom = f13 + f12;
            }
            float f14 = rectF.left;
            float f15 = rectF.top;
            canvas2.translate(f14, f15);
            this.W.setBounds(0, 0, (int) rectF.width(), (int) rectF.height());
            this.X.setBounds(this.W.getBounds());
            this.X.jumpToCurrentState();
            this.X.draw(canvas2);
            canvas2.translate(-f14, -f15);
        }
        if (this.E0 < 255) {
            canvas2.restoreToCount(iSaveLayerAlpha);
        }
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final int getAlpha() {
        return this.E0;
    }

    @Override // android.graphics.drawable.Drawable
    public final ColorFilter getColorFilter() {
        return this.F0;
    }

    @Override // android.graphics.drawable.Drawable
    public final int getIntrinsicHeight() {
        return (int) this.K;
    }

    @Override // android.graphics.drawable.Drawable
    public final int getIntrinsicWidth() {
        return Math.min(Math.round(q() + this.v0.a(this.P.toString()) + p() + this.h0 + this.k0 + this.l0 + this.o0), this.O0);
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final int getOpacity() {
        return -3;
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final void getOutline(Outline outline) {
        Outline outline2;
        if (this.P0) {
            super.getOutline(outline);
            return;
        }
        Rect bounds = getBounds();
        if (bounds.isEmpty()) {
            outline2 = outline;
            outline2.setRoundRect(0, 0, getIntrinsicWidth(), (int) this.K, this.L);
        } else {
            outline.setRoundRect(bounds, this.L);
            outline2 = outline;
        }
        outline2.setAlpha(this.E0 / 255.0f);
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public final void invalidateDrawable(Drawable drawable) {
        Drawable.Callback callback = getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final boolean isStateful() {
        ColorStateList colorStateList;
        if (s(this.I) || s(this.J) || s(this.M)) {
            return true;
        }
        C1016dd0 c1016dd0 = this.v0.f;
        if (c1016dd0 == null || (colorStateList = c1016dd0.j) == null || !colorStateList.isStateful()) {
            return (this.c0 && this.d0 != null && this.b0) || t(this.R) || t(this.d0) || s(this.H0);
        }
        return true;
    }

    public final void n(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        drawable.setCallback(this);
        drawable.setLayoutDirection(getLayoutDirection());
        drawable.setLevel(getLevel());
        drawable.setVisible(isVisible(), false);
        if (drawable == this.W) {
            if (drawable.isStateful()) {
                drawable.setState(this.J0);
            }
            drawable.setTintList(this.Y);
            return;
        }
        Drawable drawable2 = this.R;
        if (drawable == drawable2 && this.U) {
            drawable2.setTintList(this.S);
        }
        if (drawable.isStateful()) {
            drawable.setState(getState());
        }
    }

    public final void o(Rect rect, RectF rectF) {
        rectF.setEmpty();
        if (S() || R()) {
            float f = this.h0 + this.i0;
            Drawable drawable = this.C0 ? this.d0 : this.R;
            float intrinsicWidth = this.T;
            if (intrinsicWidth <= 0.0f && drawable != null) {
                intrinsicWidth = drawable.getIntrinsicWidth();
            }
            if (getLayoutDirection() == 0) {
                float f2 = rect.left + f;
                rectF.left = f2;
                rectF.right = f2 + intrinsicWidth;
            } else {
                float f3 = rect.right - f;
                rectF.right = f3;
                rectF.left = f3 - intrinsicWidth;
            }
            Drawable drawable2 = this.C0 ? this.d0 : this.R;
            float fCeil = this.T;
            if (fCeil <= 0.0f && drawable2 != null) {
                fCeil = (float) Math.ceil(TypedValue.applyDimension(1, 24, this.p0.getResources().getDisplayMetrics()));
                if (drawable2.getIntrinsicHeight() <= fCeil) {
                    fCeil = drawable2.getIntrinsicHeight();
                }
            }
            float fExactCenterY = rect.exactCenterY() - (fCeil / 2.0f);
            rectF.top = fExactCenterY;
            rectF.bottom = fExactCenterY + fCeil;
        }
    }

    @Override // android.graphics.drawable.Drawable
    public final boolean onLayoutDirectionChanged(int i) {
        boolean zOnLayoutDirectionChanged = super.onLayoutDirectionChanged(i);
        if (S()) {
            zOnLayoutDirectionChanged |= this.R.setLayoutDirection(i);
        }
        if (R()) {
            zOnLayoutDirectionChanged |= this.d0.setLayoutDirection(i);
        }
        if (T()) {
            zOnLayoutDirectionChanged |= this.W.setLayoutDirection(i);
        }
        if (!zOnLayoutDirectionChanged) {
            return true;
        }
        invalidateSelf();
        return true;
    }

    @Override // android.graphics.drawable.Drawable
    public final boolean onLevelChange(int i) {
        boolean zOnLevelChange = super.onLevelChange(i);
        if (S()) {
            zOnLevelChange |= this.R.setLevel(i);
        }
        if (R()) {
            zOnLevelChange |= this.d0.setLevel(i);
        }
        if (T()) {
            zOnLevelChange |= this.W.setLevel(i);
        }
        if (zOnLevelChange) {
            invalidateSelf();
        }
        return zOnLevelChange;
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final boolean onStateChange(int[] iArr) {
        if (this.P0) {
            super.onStateChange(iArr);
        }
        return v(iArr, this.J0);
    }

    public final float p() {
        if (!S() && !R()) {
            return 0.0f;
        }
        float f = this.i0;
        Drawable drawable = this.C0 ? this.d0 : this.R;
        float intrinsicWidth = this.T;
        if (intrinsicWidth <= 0.0f && drawable != null) {
            intrinsicWidth = drawable.getIntrinsicWidth();
        }
        return intrinsicWidth + f + this.j0;
    }

    public final float q() {
        if (T()) {
            return this.m0 + this.Z + this.n0;
        }
        return 0.0f;
    }

    public final float r() {
        return this.P0 ? this.l.a.e.a(f()) : this.L;
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public final void scheduleDrawable(Drawable drawable, Runnable runnable, long j) {
        Drawable.Callback callback = getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, runnable, j);
        }
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final void setAlpha(int i) {
        if (this.E0 != i) {
            this.E0 = i;
            invalidateSelf();
        }
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final void setColorFilter(ColorFilter colorFilter) {
        if (this.F0 != colorFilter) {
            this.F0 = colorFilter;
            invalidateSelf();
        }
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final void setTintList(ColorStateList colorStateList) {
        if (this.H0 != colorStateList) {
            this.H0 = colorStateList;
            onStateChange(getState());
        }
    }

    @Override // o.C1092eO, android.graphics.drawable.Drawable
    public final void setTintMode(PorterDuff.Mode mode) {
        if (this.I0 != mode) {
            this.I0 = mode;
            ColorStateList colorStateList = this.H0;
            this.G0 = (colorStateList == null || mode == null) ? null : new PorterDuffColorFilter(colorStateList.getColorForState(getState(), 0), mode);
            invalidateSelf();
        }
    }

    @Override // android.graphics.drawable.Drawable
    public final boolean setVisible(boolean z, boolean z2) {
        boolean visible = super.setVisible(z, z2);
        if (S()) {
            visible |= this.R.setVisible(z, z2);
        }
        if (R()) {
            visible |= this.d0.setVisible(z, z2);
        }
        if (T()) {
            visible |= this.W.setVisible(z, z2);
        }
        if (visible) {
            invalidateSelf();
        }
        return visible;
    }

    public final void u() {
        InterfaceC0344Nh interfaceC0344Nh = (InterfaceC0344Nh) this.L0.get();
        if (interfaceC0344Nh != null) {
            Chip chip = (Chip) interfaceC0344Nh;
            chip.b(chip.A);
            chip.requestLayout();
            chip.invalidateOutline();
        }
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public final void unscheduleDrawable(Drawable drawable, Runnable runnable) {
        Drawable.Callback callback = getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, runnable);
        }
    }

    public final boolean v(int[] iArr, int[] iArr2) {
        boolean z;
        boolean z2;
        ColorStateList colorStateList;
        boolean zOnStateChange = super.onStateChange(iArr);
        ColorStateList colorStateList2 = this.I;
        int iB = b(colorStateList2 != null ? colorStateList2.getColorForState(iArr, this.w0) : 0);
        boolean state = true;
        if (this.w0 != iB) {
            this.w0 = iB;
            zOnStateChange = true;
        }
        ColorStateList colorStateList3 = this.J;
        int iB2 = b(colorStateList3 != null ? colorStateList3.getColorForState(iArr, this.x0) : 0);
        if (this.x0 != iB2) {
            this.x0 = iB2;
            zOnStateChange = true;
        }
        int iB3 = AbstractC0501Ti.b(iB2, iB);
        if ((this.y0 != iB3) | (this.l.c == null)) {
            this.y0 = iB3;
            j(ColorStateList.valueOf(iB3));
            zOnStateChange = true;
        }
        ColorStateList colorStateList4 = this.M;
        int colorForState = colorStateList4 != null ? colorStateList4.getColorForState(iArr, this.z0) : 0;
        if (this.z0 != colorForState) {
            this.z0 = colorForState;
            zOnStateChange = true;
        }
        int colorForState2 = (this.K0 == null || !AbstractC1904ms0.x(iArr)) ? 0 : this.K0.getColorForState(iArr, this.A0);
        if (this.A0 != colorForState2) {
            this.A0 = colorForState2;
        }
        C1016dd0 c1016dd0 = this.v0.f;
        int colorForState3 = (c1016dd0 == null || (colorStateList = c1016dd0.j) == null) ? 0 : colorStateList.getColorForState(iArr, this.B0);
        if (this.B0 != colorForState3) {
            this.B0 = colorForState3;
            zOnStateChange = true;
        }
        int[] state2 = getState();
        if (state2 == null) {
            z = false;
        } else {
            int length = state2.length;
            int i = 0;
            while (true) {
                if (i >= length) {
                    break;
                }
                if (state2[i] != 16842912) {
                    i++;
                } else if (this.b0) {
                    z = true;
                }
            }
            z = false;
        }
        if (this.C0 == z || this.d0 == null) {
            z2 = false;
        } else {
            float fP = p();
            this.C0 = z;
            if (fP != p()) {
                zOnStateChange = true;
                z2 = true;
            } else {
                z2 = false;
                zOnStateChange = true;
            }
        }
        ColorStateList colorStateList5 = this.H0;
        int colorForState4 = colorStateList5 != null ? colorStateList5.getColorForState(iArr, this.D0) : 0;
        if (this.D0 != colorForState4) {
            this.D0 = colorForState4;
            ColorStateList colorStateList6 = this.H0;
            PorterDuff.Mode mode = this.I0;
            this.G0 = (colorStateList6 == null || mode == null) ? null : new PorterDuffColorFilter(colorStateList6.getColorForState(getState(), 0), mode);
        } else {
            state = zOnStateChange;
        }
        if (t(this.R)) {
            state |= this.R.setState(iArr);
        }
        if (t(this.d0)) {
            state |= this.d0.setState(iArr);
        }
        if (t(this.W)) {
            int[] iArr3 = new int[iArr.length + iArr2.length];
            System.arraycopy(iArr, 0, iArr3, 0, iArr.length);
            System.arraycopy(iArr2, 0, iArr3, iArr.length, iArr2.length);
            state |= this.W.setState(iArr3);
        }
        if (t(this.X)) {
            state |= this.X.setState(iArr2);
        }
        if (state) {
            invalidateSelf();
        }
        if (z2) {
            u();
        }
        return state;
    }

    public final void w(boolean z) {
        if (this.b0 != z) {
            this.b0 = z;
            float fP = p();
            if (!z && this.C0) {
                this.C0 = false;
            }
            float fP2 = p();
            invalidateSelf();
            if (fP != fP2) {
                u();
            }
        }
    }

    public final void x(Drawable drawable) {
        if (this.d0 != drawable) {
            float fP = p();
            this.d0 = drawable;
            float fP2 = p();
            U(this.d0);
            n(this.d0);
            invalidateSelf();
            if (fP != fP2) {
                u();
            }
        }
    }

    public final void y(ColorStateList colorStateList) {
        Drawable drawable;
        if (this.e0 != colorStateList) {
            this.e0 = colorStateList;
            if (this.c0 && (drawable = this.d0) != null && this.b0) {
                drawable.setTintList(colorStateList);
            }
            onStateChange(getState());
        }
    }

    public final void z(boolean z) {
        if (this.c0 != z) {
            boolean zR = R();
            this.c0 = z;
            boolean zR2 = R();
            if (zR != zR2) {
                if (zR2) {
                    n(this.d0);
                } else {
                    U(this.d0);
                }
                invalidateSelf();
                u();
            }
        }
    }
}
