package o;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.Spinner;
import com.google.android.gms.common.R;
import com.google.android.material.textfield.TextInputLayout;
import java.util.WeakHashMap;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.Jt, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public final class C0253Jt extends AbstractC1052dw {
    public final int e;
    public final int f;
    public final TimeInterpolator g;
    public AutoCompleteTextView h;
    public final ViewOnClickListenerC0604Xh i;
    public final ViewOnFocusChangeListenerC0417Qc j;
    public final G1 k;
    public boolean l;
    public boolean m;
    public boolean n;

    /* renamed from: o, reason: collision with root package name */
    public long f181o;
    public AccessibilityManager p;
    public ValueAnimator q;
    public ValueAnimator r;

    public C0253Jt(C0957cw c0957cw) {
        super(c0957cw);
        this.i = new ViewOnClickListenerC0604Xh(1, this);
        this.j = new ViewOnFocusChangeListenerC0417Qc(2, this);
        this.k = new G1(7, this);
        this.f181o = Long.MAX_VALUE;
        this.f = AbstractC0752ap.a0(c0957cw.getContext(), R.attr.motionDurationShort3, 67);
        this.e = AbstractC0752ap.a0(c0957cw.getContext(), R.attr.motionDurationShort3, 50);
        this.g = AbstractC0752ap.b0(c0957cw.getContext(), R.attr.motionEasingLinearInterpolator, T6.a);
    }

    @Override // o.AbstractC1052dw
    public final void a() {
        if (this.p.isTouchExplorationEnabled() && this.h.getInputType() != 0 && !this.d.hasFocus()) {
            this.h.dismissDropDown();
        }
        this.h.post(new RunnableC2108p1(11, this));
    }

    @Override // o.AbstractC1052dw
    public final int c() {
        return R.string.exposed_dropdown_menu_content_description;
    }

    @Override // o.AbstractC1052dw
    public final int d() {
        return R.drawable.mtrl_dropdown_arrow;
    }

    @Override // o.AbstractC1052dw
    public final View.OnFocusChangeListener e() {
        return this.j;
    }

    @Override // o.AbstractC1052dw
    public final View.OnClickListener f() {
        return this.i;
    }

    @Override // o.AbstractC1052dw
    public final G1 h() {
        return this.k;
    }

    @Override // o.AbstractC1052dw
    public final boolean i(int i) {
        return i != 0;
    }

    @Override // o.AbstractC1052dw
    public final boolean k() {
        return this.n;
    }

    @Override // o.AbstractC1052dw
    public final void l(EditText editText) {
        if (!(editText instanceof AutoCompleteTextView)) {
            throw new RuntimeException("EditText needs to be an AutoCompleteTextView if an Exposed Dropdown Menu is being used.");
        }
        AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView) editText;
        this.h = autoCompleteTextView;
        autoCompleteTextView.setOnTouchListener(new View.OnTouchListener() { // from class: o.Ht
            @Override // android.view.View.OnTouchListener
            public final boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 1) {
                    long jCurrentTimeMillis = System.currentTimeMillis();
                    C0253Jt c0253Jt = this.l;
                    long j = jCurrentTimeMillis - c0253Jt.f181o;
                    if (j < 0 || j > 300) {
                        c0253Jt.m = false;
                    }
                    c0253Jt.t();
                    c0253Jt.m = true;
                    c0253Jt.f181o = System.currentTimeMillis();
                }
                return false;
            }
        });
        this.h.setOnDismissListener(new AutoCompleteTextView.OnDismissListener() { // from class: o.It
            @Override // android.widget.AutoCompleteTextView.OnDismissListener
            public final void onDismiss() {
                C0253Jt c0253Jt = this.a;
                c0253Jt.m = true;
                c0253Jt.f181o = System.currentTimeMillis();
                c0253Jt.s(false);
            }
        });
        this.h.setThreshold(0);
        TextInputLayout textInputLayout = this.a;
        textInputLayout.setErrorIconDrawable((Drawable) null);
        if (editText.getInputType() == 0 && this.p.isTouchExplorationEnabled()) {
            WeakHashMap weakHashMap = Oj0.a;
            this.d.setImportantForAccessibility(2);
        }
        textInputLayout.setEndIconVisible(true);
    }

    @Override // o.AbstractC1052dw
    public final void m(H0 h0) {
        if (this.h.getInputType() == 0) {
            h0.i(Spinner.class.getName());
        }
        if (Build.VERSION.SDK_INT >= 26 ? h0.a.isShowingHintText() : h0.e(4)) {
            h0.l(null);
        }
    }

    @Override // o.AbstractC1052dw
    public final void n(AccessibilityEvent accessibilityEvent) {
        if (this.p.isEnabled() && this.h.getInputType() == 0) {
            boolean z = (accessibilityEvent.getEventType() == 32768 || accessibilityEvent.getEventType() == 8) && this.n && !this.h.isPopupShowing();
            if (accessibilityEvent.getEventType() == 1 || z) {
                t();
                this.m = true;
                this.f181o = System.currentTimeMillis();
            }
        }
    }

    @Override // o.AbstractC1052dw
    public final void q() {
        ValueAnimator valueAnimatorOfFloat = ValueAnimator.ofFloat(0.0f, 1.0f);
        TimeInterpolator timeInterpolator = this.g;
        valueAnimatorOfFloat.setInterpolator(timeInterpolator);
        valueAnimatorOfFloat.setDuration(this.f);
        valueAnimatorOfFloat.addUpdateListener(new C0175Gt(this));
        this.r = valueAnimatorOfFloat;
        ValueAnimator valueAnimatorOfFloat2 = ValueAnimator.ofFloat(1.0f, 0.0f);
        valueAnimatorOfFloat2.setInterpolator(timeInterpolator);
        valueAnimatorOfFloat2.setDuration(this.e);
        valueAnimatorOfFloat2.addUpdateListener(new C0175Gt(this));
        this.q = valueAnimatorOfFloat2;
        valueAnimatorOfFloat2.addListener(new X0(2, this));
        this.p = (AccessibilityManager) this.c.getSystemService("accessibility");
    }

    @Override // o.AbstractC1052dw
    public final void r() {
        AutoCompleteTextView autoCompleteTextView = this.h;
        if (autoCompleteTextView != null) {
            autoCompleteTextView.setOnTouchListener(null);
            this.h.setOnDismissListener(null);
        }
    }

    public final void s(boolean z) {
        if (this.n != z) {
            this.n = z;
            this.r.cancel();
            this.q.start();
        }
    }

    public final void t() {
        if (this.h == null) {
            return;
        }
        long jCurrentTimeMillis = System.currentTimeMillis() - this.f181o;
        if (jCurrentTimeMillis < 0 || jCurrentTimeMillis > 300) {
            this.m = false;
        }
        if (this.m) {
            this.m = false;
            return;
        }
        s(!this.n);
        if (!this.n) {
            this.h.dismissDropDown();
        } else {
            this.h.requestFocus();
            this.h.showDropDown();
        }
    }
}
