package o;

import android.content.ContentProviderClient;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.os.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.xA, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public abstract class AbstractC2885xA {
    public static final C1283gN a = new C1283gN(2);
    public static final C0347Nk b = new C0347Nk(6);

    public static C1254g2 a(Context context, List list) {
        String str;
        Typeface typefaceC;
        AbstractC2798wI.f("FontProvider.getFontFamilyResult");
        try {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < list.size(); i++) {
                C2980yA c2980yA = (C2980yA) list.get(i);
                if (Build.VERSION.SDK_INT < 31 || (typefaceC = AbstractC1977nh0.c((str = c2980yA.e))) == null || AbstractC1977nh0.d(typefaceC) == null) {
                    ProviderInfo providerInfoB = b(context.getPackageManager(), c2980yA, context.getResources());
                    if (providerInfoB == null) {
                        return new C1254g2(2);
                    }
                    arrayList.add(c(context, c2980yA, providerInfoB.authority));
                } else {
                    arrayList.add(new QA[]{new QA(str, c2980yA.f)});
                }
            }
            return new C1254g2(arrayList);
        } finally {
            Trace.endSection();
        }
    }

    public static ProviderInfo b(PackageManager packageManager, C2980yA c2980yA, Resources resources) {
        C0347Nk c0347Nk = b;
        C1283gN c1283gN = a;
        AbstractC2798wI.f("FontProvider.getProvider");
        try {
            List listU = c2980yA.d;
            String str = c2980yA.a;
            String str2 = c2980yA.b;
            if (listU == null) {
                listU = AbstractC2798wI.u(resources, 0);
            }
            C2790wA c2790wA = new C2790wA();
            c2790wA.a = str;
            c2790wA.b = str2;
            c2790wA.c = listU;
            ProviderInfo providerInfo = (ProviderInfo) c1283gN.h(c2790wA);
            if (providerInfo != null) {
                return providerInfo;
            }
            ProviderInfo providerInfoResolveContentProvider = packageManager.resolveContentProvider(str, 0);
            if (providerInfoResolveContentProvider == null) {
                throw new PackageManager.NameNotFoundException("No package found for authority: " + str);
            }
            if (!providerInfoResolveContentProvider.packageName.equals(str2)) {
                throw new PackageManager.NameNotFoundException("Found content provider " + str + ", but package was not " + str2);
            }
            Signature[] signatureArr = packageManager.getPackageInfo(providerInfoResolveContentProvider.packageName, 64).signatures;
            ArrayList arrayList = new ArrayList();
            for (Signature signature : signatureArr) {
                arrayList.add(signature.toByteArray());
            }
            Collections.sort(arrayList, c0347Nk);
            for (int i = 0; i < listU.size(); i++) {
                ArrayList arrayList2 = new ArrayList((Collection) listU.get(i));
                Collections.sort(arrayList2, c0347Nk);
                if (arrayList.size() == arrayList2.size()) {
                    for (int i2 = 0; i2 < arrayList.size(); i2++) {
                        if (!Arrays.equals((byte[]) arrayList.get(i2), (byte[]) arrayList2.get(i2))) {
                            break;
                        }
                    }
                    c1283gN.l(c2790wA, providerInfoResolveContentProvider);
                    return providerInfoResolveContentProvider;
                }
            }
            Trace.endSection();
            return null;
        } finally {
            Trace.endSection();
        }
    }

    public static QA[] c(Context context, C2980yA c2980yA, String str) {
        ContentProviderClient contentProviderClient;
        ContentProviderClient contentProviderClient2;
        ContentProviderClient contentProviderClient3;
        Uri uriWithAppendedId;
        AbstractC2798wI.f("FontProvider.query");
        try {
            ArrayList arrayList = new ArrayList();
            Uri uriBuild = new Uri.Builder().scheme("content").authority(str).build();
            Uri uriBuild2 = new Uri.Builder().scheme("content").authority(str).appendPath("file").build();
            ContentProviderClient contentProviderClientAcquireUnstableContentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uriBuild);
            Cursor cursorQuery = null;
            try {
                String[] strArr = {"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"};
                AbstractC2798wI.f("ContentQueryWrapper.query");
                try {
                    try {
                        String[] strArr2 = {c2980yA.c};
                        if (contentProviderClientAcquireUnstableContentProviderClient != null) {
                            try {
                                cursorQuery = contentProviderClientAcquireUnstableContentProviderClient.query(uriBuild, strArr, "query = ?", strArr2, null, null);
                            } catch (RemoteException unused) {
                            }
                        }
                        if (cursorQuery == null || cursorQuery.getCount() <= 0) {
                            contentProviderClient2 = contentProviderClientAcquireUnstableContentProviderClient;
                        } else {
                            int columnIndex = cursorQuery.getColumnIndex("result_code");
                            ArrayList arrayList2 = new ArrayList();
                            int columnIndex2 = cursorQuery.getColumnIndex("_id");
                            int columnIndex3 = cursorQuery.getColumnIndex("file_id");
                            int columnIndex4 = cursorQuery.getColumnIndex("font_ttc_index");
                            int columnIndex5 = cursorQuery.getColumnIndex("font_weight");
                            int columnIndex6 = cursorQuery.getColumnIndex("font_italic");
                            while (cursorQuery.moveToNext()) {
                                int i = columnIndex != -1 ? cursorQuery.getInt(columnIndex) : 0;
                                int i2 = columnIndex4 != -1 ? cursorQuery.getInt(columnIndex4) : 0;
                                if (columnIndex3 == -1) {
                                    contentProviderClient3 = contentProviderClientAcquireUnstableContentProviderClient;
                                    uriWithAppendedId = ContentUris.withAppendedId(uriBuild, cursorQuery.getLong(columnIndex2));
                                } else {
                                    contentProviderClient3 = contentProviderClientAcquireUnstableContentProviderClient;
                                    uriWithAppendedId = ContentUris.withAppendedId(uriBuild2, cursorQuery.getLong(columnIndex3));
                                }
                                arrayList2.add(new QA(uriWithAppendedId, i2, columnIndex5 != -1 ? cursorQuery.getInt(columnIndex5) : 400, columnIndex6 != -1 && cursorQuery.getInt(columnIndex6) == 1, i));
                                contentProviderClientAcquireUnstableContentProviderClient = contentProviderClient3;
                            }
                            contentProviderClient2 = contentProviderClientAcquireUnstableContentProviderClient;
                            arrayList = arrayList2;
                        }
                        if (cursorQuery != null) {
                            cursorQuery.close();
                        }
                        if (contentProviderClient2 != null) {
                            contentProviderClient2.close();
                        }
                        return (QA[]) arrayList.toArray(new QA[0]);
                    } catch (Throwable th) {
                        th = th;
                        contentProviderClient = context;
                        if (cursorQuery != null) {
                            cursorQuery.close();
                        }
                        if (contentProviderClient != null) {
                            contentProviderClient.close();
                        }
                        throw th;
                    }
                } finally {
                }
            } catch (Throwable th2) {
                th = th2;
                contentProviderClient = contentProviderClientAcquireUnstableContentProviderClient;
            }
        } finally {
            Trace.endSection();
        }
    }
}
