package o;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.sL, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public abstract class AbstractC2421sL extends ViewGroup {
    public boolean l;
    public int m;
    public int n;

    /* renamed from: o, reason: collision with root package name */
    public int f714o;
    public int p;
    public int q;
    public float r;
    public boolean s;
    public int[] t;
    public int[] u;
    public Drawable v;
    public int w;
    public int x;
    public int y;
    public int z;

    public AbstractC2421sL(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, 0);
        this.l = true;
        this.m = -1;
        this.n = 0;
        this.p = 8388659;
        int[] iArr = YZ.n;
        C70 c70R = C70.r(context, attributeSet, iArr, 0);
        Oj0.l(this, context, iArr, attributeSet, (TypedArray) c70R.n, 0);
        TypedArray typedArray = (TypedArray) c70R.n;
        int i2 = typedArray.getInt(1, -1);
        if (i2 >= 0) {
            setOrientation(i2);
        }
        int i3 = typedArray.getInt(0, -1);
        if (i3 >= 0) {
            setGravity(i3);
        }
        boolean z = typedArray.getBoolean(2, true);
        if (!z) {
            setBaselineAligned(z);
        }
        this.r = typedArray.getFloat(4, -1.0f);
        this.m = typedArray.getInt(3, -1);
        this.s = typedArray.getBoolean(7, false);
        setDividerDrawable(c70R.m(5));
        this.y = typedArray.getInt(8, 0);
        this.z = typedArray.getDimensionPixelSize(6, 0);
        c70R.t();
    }

    @Override // android.view.ViewGroup
    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C2326rL;
    }

    public final void d(Canvas canvas, int i) {
        this.v.setBounds(getPaddingLeft() + this.z, i, (getWidth() - getPaddingRight()) - this.z, this.x + i);
        this.v.draw(canvas);
    }

    public final void e(Canvas canvas, int i) {
        this.v.setBounds(i, getPaddingTop() + this.z, this.w + i, (getHeight() - getPaddingBottom()) - this.z);
        this.v.draw(canvas);
    }

    @Override // android.view.ViewGroup
    /* renamed from: f, reason: merged with bridge method [inline-methods] */
    public C2326rL generateDefaultLayoutParams() {
        int i = this.f714o;
        if (i == 0) {
            return new C2326rL(-2, -2);
        }
        if (i == 1) {
            return new C2326rL(-1, -2);
        }
        return null;
    }

    @Override // android.view.ViewGroup
    /* renamed from: g, reason: merged with bridge method [inline-methods] */
    public C2326rL generateLayoutParams(AttributeSet attributeSet) {
        return new C2326rL(getContext(), attributeSet);
    }

    @Override // android.view.View
    public int getBaseline() {
        int i;
        if (this.m < 0) {
            return super.getBaseline();
        }
        int childCount = getChildCount();
        int i2 = this.m;
        if (childCount <= i2) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        View childAt = getChildAt(i2);
        int baseline = childAt.getBaseline();
        if (baseline == -1) {
            if (this.m == 0) {
                return -1;
            }
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
        }
        int bottom = this.n;
        if (this.f714o == 1 && (i = this.p & 112) != 48) {
            if (i == 16) {
                bottom += ((((getBottom() - getTop()) - getPaddingTop()) - getPaddingBottom()) - this.q) / 2;
            } else if (i == 80) {
                bottom = ((getBottom() - getTop()) - getPaddingBottom()) - this.q;
            }
        }
        return bottom + ((LinearLayout.LayoutParams) ((C2326rL) childAt.getLayoutParams())).topMargin + baseline;
    }

    public int getBaselineAlignedChildIndex() {
        return this.m;
    }

    public Drawable getDividerDrawable() {
        return this.v;
    }

    public int getDividerPadding() {
        return this.z;
    }

    public int getDividerWidth() {
        return this.w;
    }

    public int getGravity() {
        return this.p;
    }

    public int getOrientation() {
        return this.f714o;
    }

    public int getShowDividers() {
        return this.y;
    }

    public int getVirtualChildCount() {
        return getChildCount();
    }

    public float getWeightSum() {
        return this.r;
    }

    @Override // android.view.ViewGroup
    /* renamed from: h, reason: merged with bridge method [inline-methods] */
    public C2326rL generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C2326rL ? new C2326rL((C2326rL) layoutParams) : layoutParams instanceof ViewGroup.MarginLayoutParams ? new C2326rL((ViewGroup.MarginLayoutParams) layoutParams) : new C2326rL(layoutParams);
    }

    public final boolean i(int i) {
        if (i == 0) {
            return (this.y & 1) != 0;
        }
        if (i == getChildCount()) {
            return (this.y & 4) != 0;
        }
        if ((this.y & 2) != 0) {
            for (int i2 = i - 1; i2 >= 0; i2--) {
                if (getChildAt(i2).getVisibility() != 8) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override // android.view.View
    public final void onDraw(Canvas canvas) {
        int right;
        int left;
        int i;
        if (this.v == null) {
            return;
        }
        int i2 = 0;
        if (this.f714o == 1) {
            int virtualChildCount = getVirtualChildCount();
            while (i2 < virtualChildCount) {
                View childAt = getChildAt(i2);
                if (childAt != null && childAt.getVisibility() != 8 && i(i2)) {
                    d(canvas, (childAt.getTop() - ((LinearLayout.LayoutParams) ((C2326rL) childAt.getLayoutParams())).topMargin) - this.x);
                }
                i2++;
            }
            if (i(virtualChildCount)) {
                View childAt2 = getChildAt(virtualChildCount - 1);
                d(canvas, childAt2 == null ? (getHeight() - getPaddingBottom()) - this.x : childAt2.getBottom() + ((LinearLayout.LayoutParams) ((C2326rL) childAt2.getLayoutParams())).bottomMargin);
                return;
            }
            return;
        }
        int virtualChildCount2 = getVirtualChildCount();
        boolean z = AbstractC2457sk0.a;
        boolean z2 = getLayoutDirection() == 1;
        while (i2 < virtualChildCount2) {
            View childAt3 = getChildAt(i2);
            if (childAt3 != null && childAt3.getVisibility() != 8 && i(i2)) {
                C2326rL c2326rL = (C2326rL) childAt3.getLayoutParams();
                e(canvas, z2 ? childAt3.getRight() + ((LinearLayout.LayoutParams) c2326rL).rightMargin : (childAt3.getLeft() - ((LinearLayout.LayoutParams) c2326rL).leftMargin) - this.w);
            }
            i2++;
        }
        if (i(virtualChildCount2)) {
            View childAt4 = getChildAt(virtualChildCount2 - 1);
            if (childAt4 != null) {
                C2326rL c2326rL2 = (C2326rL) childAt4.getLayoutParams();
                if (z2) {
                    left = childAt4.getLeft() - ((LinearLayout.LayoutParams) c2326rL2).leftMargin;
                    i = this.w;
                    right = left - i;
                } else {
                    right = childAt4.getRight() + ((LinearLayout.LayoutParams) c2326rL2).rightMargin;
                }
            } else if (z2) {
                right = getPaddingLeft();
            } else {
                left = getWidth() - getPaddingRight();
                i = this.w;
                right = left - i;
            }
            e(canvas, right);
        }
    }

    @Override // android.view.View
    public final void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName("androidx.appcompat.widget.LinearLayoutCompat");
    }

    @Override // android.view.View
    public final void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName("androidx.appcompat.widget.LinearLayoutCompat");
    }

    /* JADX WARN: Removed duplicated region for block: B:29:0x009d  */
    /* JADX WARN: Removed duplicated region for block: B:62:0x015a  */
    /* JADX WARN: Removed duplicated region for block: B:65:0x0163  */
    /* JADX WARN: Removed duplicated region for block: B:77:0x0191  */
    /* JADX WARN: Removed duplicated region for block: B:80:0x01a4  */
    /* JADX WARN: Removed duplicated region for block: B:81:0x01a9  */
    @Override // android.view.ViewGroup, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public void onLayout(boolean r23, int r24, int r25, int r26, int r27) {
        /*
            Method dump skipped, instructions count: 461
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.AbstractC2421sL.onLayout(boolean, int, int, int, int):void");
    }

    /* JADX WARN: Removed duplicated region for block: B:228:0x04e3  */
    /* JADX WARN: Removed duplicated region for block: B:231:0x04f8  */
    /* JADX WARN: Removed duplicated region for block: B:237:0x0526  */
    /* JADX WARN: Removed duplicated region for block: B:243:0x0536  */
    /* JADX WARN: Removed duplicated region for block: B:246:0x053d  */
    /* JADX WARN: Removed duplicated region for block: B:250:0x0547  */
    /* JADX WARN: Removed duplicated region for block: B:366:0x079c  */
    /* JADX WARN: Removed duplicated region for block: B:64:0x013f  */
    /* JADX WARN: Removed duplicated region for block: B:68:0x0148  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public void onMeasure(int r39, int r40) {
        /*
            Method dump skipped, instructions count: 2150
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: o.AbstractC2421sL.onMeasure(int, int):void");
    }

    public void setBaselineAligned(boolean z) {
        this.l = z;
    }

    public void setBaselineAlignedChildIndex(int i) {
        if (i >= 0 && i < getChildCount()) {
            this.m = i;
            return;
        }
        throw new IllegalArgumentException("base aligned child index out of range (0, " + getChildCount() + ")");
    }

    public void setDividerDrawable(Drawable drawable) {
        if (drawable == this.v) {
            return;
        }
        this.v = drawable;
        if (drawable != null) {
            this.w = drawable.getIntrinsicWidth();
            this.x = drawable.getIntrinsicHeight();
        } else {
            this.w = 0;
            this.x = 0;
        }
        setWillNotDraw(drawable == null);
        requestLayout();
    }

    public void setDividerPadding(int i) {
        this.z = i;
    }

    public void setGravity(int i) {
        if (this.p != i) {
            if ((8388615 & i) == 0) {
                i |= 8388611;
            }
            if ((i & 112) == 0) {
                i |= 48;
            }
            this.p = i;
            requestLayout();
        }
    }

    public void setHorizontalGravity(int i) {
        int i2 = i & 8388615;
        int i3 = this.p;
        if ((8388615 & i3) != i2) {
            this.p = i2 | ((-8388616) & i3);
            requestLayout();
        }
    }

    public void setMeasureWithLargestChildEnabled(boolean z) {
        this.s = z;
    }

    public void setOrientation(int i) {
        if (this.f714o != i) {
            this.f714o = i;
            requestLayout();
        }
    }

    public void setShowDividers(int i) {
        if (i != this.y) {
            requestLayout();
        }
        this.y = i;
    }

    public void setVerticalGravity(int i) {
        int i2 = i & 112;
        int i3 = this.p;
        if ((i3 & 112) != i2) {
            this.p = i2 | (i3 & (-113));
            requestLayout();
        }
    }

    public void setWeightSum(float f) {
        this.r = Math.max(0.0f, f);
    }

    @Override // android.view.ViewGroup
    public final boolean shouldDelayChildPressedState() {
        return false;
    }
}
