package o;

import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* renamed from: o.h0, reason: case insensitive filesystem */
/* loaded from: classes.dex */
public abstract class AbstractC1346h0 implements YL {

    /* renamed from: o, reason: collision with root package name */
    public static final boolean f549o = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
    public static final Logger p = Logger.getLogger(AbstractC1346h0.class.getName());
    public static final AbstractC0249Jp q;
    public static final Object r;
    public volatile Object l;
    public volatile C0963d0 m;
    public volatile C1250g0 n;

    static {
        AbstractC0249Jp c1154f0;
        try {
            c1154f0 = new C1058e0(AtomicReferenceFieldUpdater.newUpdater(C1250g0.class, Thread.class, "a"), AtomicReferenceFieldUpdater.newUpdater(C1250g0.class, C1250g0.class, "b"), AtomicReferenceFieldUpdater.newUpdater(AbstractC1346h0.class, C1250g0.class, "n"), AtomicReferenceFieldUpdater.newUpdater(AbstractC1346h0.class, C0963d0.class, "m"), AtomicReferenceFieldUpdater.newUpdater(AbstractC1346h0.class, Object.class, "l"));
            th = null;
        } catch (Throwable th) {
            th = th;
            c1154f0 = new C1154f0();
        }
        q = c1154f0;
        if (th != null) {
            p.log(Level.SEVERE, "SafeAtomicHelper is broken!", th);
        }
        r = new Object();
    }

    public static void d(AbstractC1346h0 abstractC1346h0) {
        C1250g0 c1250g0;
        C0963d0 c0963d0;
        C0963d0 c0963d02;
        C0963d0 c0963d03;
        do {
            c1250g0 = abstractC1346h0.n;
        } while (!q.u(abstractC1346h0, c1250g0, C1250g0.c));
        while (true) {
            c0963d0 = null;
            if (c1250g0 == null) {
                break;
            }
            Thread thread = c1250g0.a;
            if (thread != null) {
                c1250g0.a = null;
                LockSupport.unpark(thread);
            }
            c1250g0 = c1250g0.b;
        }
        abstractC1346h0.c();
        do {
            c0963d02 = abstractC1346h0.m;
        } while (!q.s(abstractC1346h0, c0963d02, C0963d0.d));
        while (true) {
            c0963d03 = c0963d0;
            c0963d0 = c0963d02;
            if (c0963d0 == null) {
                break;
            }
            c0963d02 = c0963d0.c;
            c0963d0.c = c0963d03;
        }
        while (c0963d03 != null) {
            C0963d0 c0963d04 = c0963d03.c;
            e(c0963d03.a, c0963d03.b);
            c0963d03 = c0963d04;
        }
    }

    public static void e(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        } catch (RuntimeException e) {
            p.log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, (Throwable) e);
        }
    }

    public static Object f(Object obj) throws ExecutionException {
        if (obj instanceof C0772b0) {
            Throwable th = ((C0772b0) obj).b;
            CancellationException cancellationException = new CancellationException("Task was cancelled.");
            cancellationException.initCause(th);
            throw cancellationException;
        }
        if (obj instanceof C0867c0) {
            throw new ExecutionException(((C0867c0) obj).a);
        }
        if (obj == r) {
            return null;
        }
        return obj;
    }

    public static Object g(AbstractC1346h0 abstractC1346h0) {
        Object obj;
        boolean z = false;
        while (true) {
            try {
                obj = abstractC1346h0.get();
                break;
            } catch (InterruptedException unused) {
                z = true;
            } catch (Throwable th) {
                if (z) {
                    Thread.currentThread().interrupt();
                }
                throw th;
            }
        }
        if (z) {
            Thread.currentThread().interrupt();
        }
        return obj;
    }

    @Override // o.YL
    public final void a(Runnable runnable, Executor executor) {
        executor.getClass();
        C0963d0 c0963d0 = this.m;
        C0963d0 c0963d02 = C0963d0.d;
        if (c0963d0 != c0963d02) {
            C0963d0 c0963d03 = new C0963d0(runnable, executor);
            do {
                c0963d03.c = c0963d0;
                if (q.s(this, c0963d0, c0963d03)) {
                    return;
                } else {
                    c0963d0 = this.m;
                }
            } while (c0963d0 != c0963d02);
        }
        e(runnable, executor);
    }

    public final void b(StringBuilder sb) {
        try {
            Object objG = g(this);
            sb.append("SUCCESS, result=[");
            sb.append(objG == this ? "this future" : String.valueOf(objG));
            sb.append("]");
        } catch (CancellationException unused) {
            sb.append("CANCELLED");
        } catch (RuntimeException e) {
            sb.append("UNKNOWN, cause=[");
            sb.append(e.getClass());
            sb.append(" thrown from get()]");
        } catch (ExecutionException e2) {
            sb.append("FAILURE, cause=[");
            sb.append(e2.getCause());
            sb.append("]");
        }
    }

    @Override // java.util.concurrent.Future
    public final boolean cancel(boolean z) {
        Object obj = this.l;
        if (obj == null) {
            if (q.t(this, obj, f549o ? new C0772b0(new CancellationException("Future.cancel() was called."), z) : z ? C0772b0.c : C0772b0.d)) {
                d(this);
                return true;
            }
        }
        return false;
    }

    @Override // java.util.concurrent.Future
    public final Object get(long j, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        C1250g0 c1250g0 = C1250g0.c;
        long nanos = timeUnit.toNanos(j);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object obj = this.l;
        if (obj != null) {
            return f(obj);
        }
        long jNanoTime = nanos > 0 ? System.nanoTime() + nanos : 0L;
        if (nanos >= 1000) {
            C1250g0 c1250g02 = this.n;
            if (c1250g02 != c1250g0) {
                C1250g0 c1250g03 = new C1250g0();
                do {
                    AbstractC0249Jp abstractC0249Jp = q;
                    abstractC0249Jp.a0(c1250g03, c1250g02);
                    if (abstractC0249Jp.u(this, c1250g02, c1250g03)) {
                        do {
                            LockSupport.parkNanos(this, nanos);
                            if (Thread.interrupted()) {
                                i(c1250g03);
                                throw new InterruptedException();
                            }
                            Object obj2 = this.l;
                            if (obj2 != null) {
                                return f(obj2);
                            }
                            nanos = jNanoTime - System.nanoTime();
                        } while (nanos >= 1000);
                        i(c1250g03);
                    } else {
                        c1250g02 = this.n;
                    }
                } while (c1250g02 != c1250g0);
            }
            return f(this.l);
        }
        while (nanos > 0) {
            Object obj3 = this.l;
            if (obj3 != null) {
                return f(obj3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            nanos = jNanoTime - System.nanoTime();
        }
        String string = toString();
        String string2 = timeUnit.toString();
        Locale locale = Locale.ROOT;
        String lowerCase = string2.toLowerCase(locale);
        String strI = "Waited " + j + " " + timeUnit.toString().toLowerCase(locale);
        if (nanos + 1000 < 0) {
            String strI2 = AbstractC2462sn.i(strI, " (plus ");
            long j2 = -nanos;
            long jConvert = timeUnit.convert(j2, TimeUnit.NANOSECONDS);
            long nanos2 = j2 - timeUnit.toNanos(jConvert);
            boolean z = jConvert == 0 || nanos2 > 1000;
            if (jConvert > 0) {
                String strI3 = strI2 + jConvert + " " + lowerCase;
                if (z) {
                    strI3 = AbstractC2462sn.i(strI3, ",");
                }
                strI2 = AbstractC2462sn.i(strI3, " ");
            }
            if (z) {
                strI2 = strI2 + nanos2 + " nanoseconds ";
            }
            strI = AbstractC2462sn.i(strI2, "delay)");
        }
        if (isDone()) {
            throw new TimeoutException(AbstractC2462sn.i(strI, " but future completed as timeout expired"));
        }
        throw new TimeoutException(strI + " for " + string);
    }

    /* JADX WARN: Multi-variable type inference failed */
    public String h() {
        if (!(this instanceof ScheduledFuture)) {
            return null;
        }
        return "remaining delay=[" + ((ScheduledFuture) this).getDelay(TimeUnit.MILLISECONDS) + " ms]";
    }

    public final void i(C1250g0 c1250g0) {
        c1250g0.a = null;
        while (true) {
            C1250g0 c1250g02 = this.n;
            if (c1250g02 == C1250g0.c) {
                return;
            }
            C1250g0 c1250g03 = null;
            while (c1250g02 != null) {
                C1250g0 c1250g04 = c1250g02.b;
                if (c1250g02.a != null) {
                    c1250g03 = c1250g02;
                } else if (c1250g03 != null) {
                    c1250g03.b = c1250g04;
                    if (c1250g03.a == null) {
                        break;
                    }
                } else if (!q.u(this, c1250g02, c1250g04)) {
                    break;
                }
                c1250g02 = c1250g04;
            }
            return;
        }
    }

    @Override // java.util.concurrent.Future
    public final boolean isCancelled() {
        return this.l instanceof C0772b0;
    }

    @Override // java.util.concurrent.Future
    public final boolean isDone() {
        return this.l != null;
    }

    public boolean j(Object obj) {
        if (obj == null) {
            obj = r;
        }
        if (!q.t(this, null, obj)) {
            return false;
        }
        d(this);
        return true;
    }

    public boolean k(Throwable th) {
        th.getClass();
        if (!q.t(this, null, new C0867c0(th))) {
            return false;
        }
        d(this);
        return true;
    }

    public final String toString() {
        String strH;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[status=");
        if (this.l instanceof C0772b0) {
            sb.append("CANCELLED");
        } else if (isDone()) {
            b(sb);
        } else {
            try {
                strH = h();
            } catch (RuntimeException e) {
                strH = "Exception thrown from implementation: " + e.getClass();
            }
            if (strH != null && !strH.isEmpty()) {
                sb.append("PENDING, info=[");
                sb.append(strH);
                sb.append("]");
            } else if (isDone()) {
                b(sb);
            } else {
                sb.append("PENDING");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public void c() {
    }

    @Override // java.util.concurrent.Future
    public final Object get() throws InterruptedException {
        Object obj;
        C1250g0 c1250g0 = C1250g0.c;
        if (!Thread.interrupted()) {
            Object obj2 = this.l;
            if (obj2 != null) {
                return f(obj2);
            }
            C1250g0 c1250g02 = this.n;
            if (c1250g02 != c1250g0) {
                C1250g0 c1250g03 = new C1250g0();
                do {
                    AbstractC0249Jp abstractC0249Jp = q;
                    abstractC0249Jp.a0(c1250g03, c1250g02);
                    if (abstractC0249Jp.u(this, c1250g02, c1250g03)) {
                        do {
                            LockSupport.park(this);
                            if (!Thread.interrupted()) {
                                obj = this.l;
                            } else {
                                i(c1250g03);
                                throw new InterruptedException();
                            }
                        } while (obj == null);
                        return f(obj);
                    }
                    c1250g02 = this.n;
                } while (c1250g02 != c1250g0);
            }
            return f(this.l);
        }
        throw new InterruptedException();
    }
}
