package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import java.util.Map;
import o.C0247Jn;
import o.C1839m9;
import o.C2487t1;
import o.X10;
import org.json.JSONException;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class RemoteMessage extends AbstractSafeParcelable {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new C2487t1(19);
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final int PRIORITY_UNKNOWN = 0;
    Bundle bundle;
    private Map<String, String> data;
    private X10 notification;

    public RemoteMessage(Bundle bundle) {
        this.bundle = bundle;
    }

    private int getMessagePriority(String str) {
        if ("high".equals(str)) {
            return 1;
        }
        return "normal".equals(str) ? 2 : 0;
    }

    public String getCollapseKey() {
        return this.bundle.getString("collapse_key");
    }

    public Map<String, String> getData() {
        if (this.data == null) {
            Bundle bundle = this.bundle;
            C1839m9 c1839m9 = new C1839m9(0);
            for (String str : bundle.keySet()) {
                Object obj = bundle.get(str);
                if (obj instanceof String) {
                    String str2 = (String) obj;
                    if (!str.startsWith("google.") && !str.startsWith("gcm.") && !str.equals("from") && !str.equals("message_type") && !str.equals("collapse_key")) {
                        c1839m9.put(str, str2);
                    }
                }
            }
            this.data = c1839m9;
        }
        return this.data;
    }

    public String getFrom() {
        return this.bundle.getString("from");
    }

    public String getMessageId() {
        String string = this.bundle.getString("google.message_id");
        return string == null ? this.bundle.getString("message_id") : string;
    }

    public String getMessageType() {
        return this.bundle.getString("message_type");
    }

    public X10 getNotification() throws JSONException, NumberFormatException {
        if (this.notification == null && C0247Jn.s(this.bundle)) {
            C0247Jn c0247Jn = new C0247Jn(this.bundle);
            X10 x10 = new X10();
            c0247Jn.q("gcm.n.title");
            c0247Jn.o("gcm.n.title");
            Object[] objArrN = c0247Jn.n("gcm.n.title");
            if (objArrN != null) {
                String[] strArr = new String[objArrN.length];
                for (int i = 0; i < objArrN.length; i++) {
                    strArr[i] = String.valueOf(objArrN[i]);
                }
            }
            c0247Jn.q("gcm.n.body");
            c0247Jn.o("gcm.n.body");
            Object[] objArrN2 = c0247Jn.n("gcm.n.body");
            if (objArrN2 != null) {
                String[] strArr2 = new String[objArrN2.length];
                for (int i2 = 0; i2 < objArrN2.length; i2++) {
                    strArr2[i2] = String.valueOf(objArrN2[i2]);
                }
            }
            c0247Jn.q("gcm.n.icon");
            if (TextUtils.isEmpty(c0247Jn.q("gcm.n.sound2"))) {
                c0247Jn.q("gcm.n.sound");
            }
            c0247Jn.q("gcm.n.tag");
            c0247Jn.q("gcm.n.color");
            c0247Jn.q("gcm.n.click_action");
            c0247Jn.q("gcm.n.android_channel_id");
            String strQ = c0247Jn.q("gcm.n.link_android");
            if (TextUtils.isEmpty(strQ)) {
                strQ = c0247Jn.q("gcm.n.link");
            }
            if (!TextUtils.isEmpty(strQ)) {
                Uri.parse(strQ);
            }
            c0247Jn.q("gcm.n.image");
            c0247Jn.q("gcm.n.ticker");
            c0247Jn.k("gcm.n.notification_priority");
            c0247Jn.k("gcm.n.visibility");
            c0247Jn.k("gcm.n.notification_count");
            c0247Jn.d("gcm.n.sticky");
            c0247Jn.d("gcm.n.local_only");
            c0247Jn.d("gcm.n.default_sound");
            c0247Jn.d("gcm.n.default_vibrate_timings");
            c0247Jn.d("gcm.n.default_light_settings");
            String strQ2 = c0247Jn.q("gcm.n.event_time");
            if (!TextUtils.isEmpty(strQ2)) {
                try {
                    Long.parseLong(strQ2);
                } catch (NumberFormatException unused) {
                    C0247Jn.y("gcm.n.event_time");
                }
            }
            c0247Jn.m();
            c0247Jn.r();
            this.notification = x10;
        }
        return this.notification;
    }

    public int getOriginalPriority() {
        String string = this.bundle.getString("google.original_priority");
        if (string == null) {
            string = this.bundle.getString("google.priority");
        }
        return getMessagePriority(string);
    }

    public int getPriority() {
        String string = this.bundle.getString("google.delivered_priority");
        if (string == null) {
            if ("1".equals(this.bundle.getString("google.priority_reduced"))) {
                return 2;
            }
            string = this.bundle.getString("google.priority");
        }
        return getMessagePriority(string);
    }

    public byte[] getRawData() {
        return this.bundle.getByteArray("rawData");
    }

    public String getSenderId() {
        return this.bundle.getString("google.c.sender.id");
    }

    public long getSentTime() {
        Object obj = this.bundle.get("google.sent_time");
        if (obj instanceof Long) {
            return ((Long) obj).longValue();
        }
        if (!(obj instanceof String)) {
            return 0L;
        }
        try {
            return Long.parseLong((String) obj);
        } catch (NumberFormatException unused) {
            return 0L;
        }
    }

    @Deprecated
    public String getTo() {
        return this.bundle.getString("google.to");
    }

    public int getTtl() {
        Object obj = this.bundle.get("google.ttl");
        if (obj instanceof Integer) {
            return ((Integer) obj).intValue();
        }
        if (!(obj instanceof String)) {
            return 0;
        }
        try {
            return Integer.parseInt((String) obj);
        } catch (NumberFormatException unused) {
            return 0;
        }
    }

    public void populateSendMessageIntent(Intent intent) {
        intent.putExtras(this.bundle);
    }

    public Intent toIntent() {
        Intent intent = new Intent();
        intent.putExtras(this.bundle);
        return intent;
    }

    @Override // android.os.Parcelable
    public void writeToParcel(Parcel parcel, int i) {
        int iBeginObjectHeader = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeBundle(parcel, 2, this.bundle, false);
        SafeParcelWriter.finishObjectHeader(parcel, iBeginObjectHeader);
    }
}
