package com.google.firebase.messaging;

import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Binder;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.firebase.messaging.FirebaseMessaging;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import o.A2;
import o.AbstractC0752ap;
import o.AbstractC1692kh0;
import o.As0;
import o.B30;
import o.C0076Cy;
import o.C0308Lx;
import o.C0346Nj;
import o.C0361Ny;
import o.C0398Pj;
import o.C0949cs;
import o.C1022dg0;
import o.C1839m9;
import o.C2805wP;
import o.C3031ym0;
import o.C3034yo;
import o.DZ;
import o.Ew0;
import o.ExecutorC0614Xr;
import o.Hw0;
import o.InterfaceC0258Jy;
import o.InterfaceC2250qb0;
import o.ME;
import o.Pc0;
import o.Sa0;
import o.U7;
import o.WT;
import o.Zb0;
import o.jw0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class FirebaseMessaging {
    public static WT l;
    public static ScheduledThreadPoolExecutor n;
    public final C0076Cy a;
    public final Context b;
    public final U7 c;
    public final C3031ym0 d;
    public final C0949cs e;
    public final ScheduledThreadPoolExecutor f;
    public final ThreadPoolExecutor g;
    public final Hw0 h;
    public final C2805wP i;
    public boolean j;
    public static final long k = TimeUnit.HOURS.toSeconds(8);
    public static DZ m = new C0398Pj(5);

    public FirebaseMessaging(C0076Cy c0076Cy, DZ dz, DZ dz2, InterfaceC0258Jy interfaceC0258Jy, DZ dz3, InterfaceC2250qb0 interfaceC2250qb0) {
        c0076Cy.a();
        Context context = c0076Cy.a;
        final C2805wP c2805wP = new C2805wP();
        final int i = 0;
        c2805wP.b = 0;
        c2805wP.c = context;
        final U7 u7 = new U7(c0076Cy, c2805wP, dz, dz2, interfaceC0258Jy);
        ExecutorService executorServiceNewSingleThreadExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("Firebase-Messaging-Task"));
        final int i2 = 1;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("Firebase-Messaging-Init"));
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new NamedThreadFactory("Firebase-Messaging-File-Io"));
        this.j = false;
        m = dz3;
        this.a = c0076Cy;
        this.e = new C0949cs(this, interfaceC2250qb0);
        c0076Cy.a();
        final Context context2 = c0076Cy.a;
        this.b = context2;
        C0308Lx c0308Lx = new C0308Lx();
        this.i = c2805wP;
        this.c = u7;
        this.d = new C3031ym0(executorServiceNewSingleThreadExecutor);
        this.f = scheduledThreadPoolExecutor;
        this.g = threadPoolExecutor;
        c0076Cy.a();
        if (context instanceof Application) {
            ((Application) context).registerActivityLifecycleCallbacks(c0308Lx);
        } else {
            Objects.toString(context);
        }
        scheduledThreadPoolExecutor.execute(new Runnable(this) { // from class: o.My
            public final /* synthetic */ FirebaseMessaging m;

            {
                this.m = this;
            }

            @Override // java.lang.Runnable
            public final void run() {
                Hw0 hw0I;
                int i3;
                switch (i) {
                    case 0:
                        FirebaseMessaging firebaseMessaging = this.m;
                        if (firebaseMessaging.e.e() && firebaseMessaging.h(firebaseMessaging.d())) {
                            synchronized (firebaseMessaging) {
                                if (!firebaseMessaging.j) {
                                    firebaseMessaging.g(0L);
                                }
                            }
                            return;
                        }
                        return;
                    default:
                        FirebaseMessaging firebaseMessaging2 = this.m;
                        final Context context3 = firebaseMessaging2.b;
                        AbstractC1692kh0.z(context3);
                        U7 u72 = firebaseMessaging2.c;
                        final boolean zF = firebaseMessaging2.f();
                        if (PlatformVersion.isAtLeastQ()) {
                            SharedPreferences sharedPreferencesZ = AbstractC2461sm0.z(context3);
                            if (!sharedPreferencesZ.contains("proxy_retention") || sharedPreferencesZ.getBoolean("proxy_retention", false) != zF) {
                                B30 b30 = (B30) u72.f352o;
                                if (b30.c.u() >= 241100000) {
                                    Bundle bundle = new Bundle();
                                    bundle.putBoolean("proxy_retention", zF);
                                    Ew0 ew0L = Ew0.l(b30.b);
                                    synchronized (ew0L) {
                                        i3 = ew0L.a;
                                        ew0L.a = i3 + 1;
                                    }
                                    hw0I = ew0L.m(new jw0(i3, 4, bundle, 0));
                                } else {
                                    hw0I = AbstractC0752ap.I(new IOException("SERVICE_NOT_AVAILABLE"));
                                }
                                hw0I.c(new V8(1), new ST() { // from class: o.FZ
                                    @Override // o.ST
                                    public final void e(Object obj) {
                                        SharedPreferences.Editor editorEdit = AbstractC2461sm0.z(context3).edit();
                                        editorEdit.putBoolean("proxy_retention", zF);
                                        editorEdit.apply();
                                    }
                                });
                            }
                        }
                        if (firebaseMessaging2.f()) {
                            firebaseMessaging2.e();
                            return;
                        }
                        return;
                }
            }
        });
        final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor2 = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("Firebase-Messaging-Topics-Io"));
        int i3 = C1022dg0.j;
        Hw0 hw0R = AbstractC0752ap.r(scheduledThreadPoolExecutor2, new Callable() { // from class: o.cg0
            @Override // java.util.concurrent.Callable
            public final Object call() {
                C0831bg0 c0831bg0;
                Context context3 = context2;
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor3 = scheduledThreadPoolExecutor2;
                FirebaseMessaging firebaseMessaging = this;
                C2805wP c2805wP2 = c2805wP;
                U7 u72 = u7;
                synchronized (C0831bg0.class) {
                    try {
                        WeakReference weakReference = C0831bg0.b;
                        c0831bg0 = weakReference != null ? (C0831bg0) weakReference.get() : null;
                        if (c0831bg0 == null) {
                            SharedPreferences sharedPreferences = context3.getSharedPreferences("com.google.android.gms.appid", 0);
                            C0831bg0 c0831bg02 = new C0831bg0();
                            synchronized (c0831bg02) {
                                c0831bg02.a = Q1.k(sharedPreferences, scheduledThreadPoolExecutor3);
                            }
                            C0831bg0.b = new WeakReference(c0831bg02);
                            c0831bg0 = c0831bg02;
                        }
                    } catch (Throwable th) {
                        throw th;
                    }
                }
                return new C1022dg0(firebaseMessaging, c2805wP2, c0831bg0, u72, context3, scheduledThreadPoolExecutor3);
            }
        });
        this.h = hw0R;
        hw0R.c(scheduledThreadPoolExecutor, new C0361Ny(this, i));
        scheduledThreadPoolExecutor.execute(new Runnable(this) { // from class: o.My
            public final /* synthetic */ FirebaseMessaging m;

            {
                this.m = this;
            }

            @Override // java.lang.Runnable
            public final void run() {
                Hw0 hw0I;
                int i32;
                switch (i2) {
                    case 0:
                        FirebaseMessaging firebaseMessaging = this.m;
                        if (firebaseMessaging.e.e() && firebaseMessaging.h(firebaseMessaging.d())) {
                            synchronized (firebaseMessaging) {
                                if (!firebaseMessaging.j) {
                                    firebaseMessaging.g(0L);
                                }
                            }
                            return;
                        }
                        return;
                    default:
                        FirebaseMessaging firebaseMessaging2 = this.m;
                        final Context context3 = firebaseMessaging2.b;
                        AbstractC1692kh0.z(context3);
                        U7 u72 = firebaseMessaging2.c;
                        final boolean zF = firebaseMessaging2.f();
                        if (PlatformVersion.isAtLeastQ()) {
                            SharedPreferences sharedPreferencesZ = AbstractC2461sm0.z(context3);
                            if (!sharedPreferencesZ.contains("proxy_retention") || sharedPreferencesZ.getBoolean("proxy_retention", false) != zF) {
                                B30 b30 = (B30) u72.f352o;
                                if (b30.c.u() >= 241100000) {
                                    Bundle bundle = new Bundle();
                                    bundle.putBoolean("proxy_retention", zF);
                                    Ew0 ew0L = Ew0.l(b30.b);
                                    synchronized (ew0L) {
                                        i32 = ew0L.a;
                                        ew0L.a = i32 + 1;
                                    }
                                    hw0I = ew0L.m(new jw0(i32, 4, bundle, 0));
                                } else {
                                    hw0I = AbstractC0752ap.I(new IOException("SERVICE_NOT_AVAILABLE"));
                                }
                                hw0I.c(new V8(1), new ST() { // from class: o.FZ
                                    @Override // o.ST
                                    public final void e(Object obj) {
                                        SharedPreferences.Editor editorEdit = AbstractC2461sm0.z(context3).edit();
                                        editorEdit.putBoolean("proxy_retention", zF);
                                        editorEdit.apply();
                                    }
                                });
                            }
                        }
                        if (firebaseMessaging2.f()) {
                            firebaseMessaging2.e();
                            return;
                        }
                        return;
                }
            }
        });
    }

    public static void b(Runnable runnable, long j) {
        synchronized (FirebaseMessaging.class) {
            try {
                if (n == null) {
                    n = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("TAG"));
                }
                n.schedule(runnable, j, TimeUnit.SECONDS);
            } catch (Throwable th) {
                throw th;
            }
        }
    }

    public static synchronized WT c(Context context) {
        try {
            if (l == null) {
                l = new WT(context);
            }
        } catch (Throwable th) {
            throw th;
        }
        return l;
    }

    public static synchronized FirebaseMessaging getInstance(C0076Cy c0076Cy) {
        FirebaseMessaging firebaseMessaging;
        firebaseMessaging = (FirebaseMessaging) c0076Cy.b(FirebaseMessaging.class);
        Preconditions.checkNotNull(firebaseMessaging, "Firebase Messaging component is not present");
        return firebaseMessaging;
    }

    public final String a() {
        Pc0 pc0D;
        Sa0 sa0D = d();
        if (!h(sa0D)) {
            return sa0D.a;
        }
        String strC = C2805wP.c(this.a);
        C3031ym0 c3031ym0 = this.d;
        synchronized (c3031ym0) {
            pc0D = (Pc0) ((C1839m9) c3031ym0.n).get(strC);
            if (pc0D != null) {
                Log.isLoggable("FirebaseMessaging", 3);
            } else {
                Log.isLoggable("FirebaseMessaging", 3);
                U7 u7 = this.c;
                pc0D = u7.o(u7.x(C2805wP.c((C0076Cy) u7.m), "*", new Bundle())).i(this.g, new C3034yo(this, strC, sa0D, 2)).d((Executor) c3031ym0.m, new C0346Nj(c3031ym0, strC));
                ((C1839m9) c3031ym0.n).put(strC, pc0D);
            }
        }
        try {
            return (String) AbstractC0752ap.p(pc0D);
        } catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    public final Sa0 d() {
        Sa0 sa0A;
        WT wtC = c(this.b);
        C0076Cy c0076Cy = this.a;
        c0076Cy.a();
        String strD = "[DEFAULT]".equals(c0076Cy.b) ? "" : c0076Cy.d();
        String strC = C2805wP.c(this.a);
        synchronized (wtC) {
            sa0A = Sa0.a(((SharedPreferences) wtC.m).getString(strD + "|T|" + strC + "|*", null));
        }
        return sa0A;
    }

    public final void e() {
        Hw0 hw0I;
        int i;
        B30 b30 = (B30) this.c.f352o;
        if (b30.c.u() >= 241100000) {
            Ew0 ew0L = Ew0.l(b30.b);
            Bundle bundle = Bundle.EMPTY;
            synchronized (ew0L) {
                i = ew0L.a;
                ew0L.a = i + 1;
            }
            hw0I = ew0L.m(new jw0(i, 5, bundle, 1)).k(ExecutorC0614Xr.f416o, ME.M);
        } else {
            hw0I = AbstractC0752ap.I(new IOException("SERVICE_NOT_AVAILABLE"));
        }
        hw0I.c(this.f, new C0361Ny(this, 1));
    }

    public final boolean f() {
        Context context = this.b;
        AbstractC1692kh0.z(context);
        if (!PlatformVersion.isAtLeastQ()) {
            Log.isLoggable("FirebaseMessaging", 3);
            return false;
        }
        if (Binder.getCallingUid() != context.getApplicationInfo().uid) {
            context.getPackageName();
            return false;
        }
        if ("com.google.android.gms".equals(((NotificationManager) context.getSystemService(NotificationManager.class)).getNotificationDelegate())) {
            Log.isLoggable("FirebaseMessaging", 3);
            if (this.a.b(A2.class) != null) {
                return true;
            }
            if (As0.u() && m != null) {
                return true;
            }
        }
        return false;
    }

    public final synchronized void g(long j) {
        b(new Zb0(this, Math.min(Math.max(30L, 2 * j), k)), j);
        this.j = true;
    }

    public final boolean h(Sa0 sa0) {
        if (sa0 != null) {
            return System.currentTimeMillis() > sa0.c + Sa0.d || !this.i.b().equals(sa0.b);
        }
        return true;
    }
}
