package com.google.android.material.timepicker;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.google.android.gms.common.R;
import java.util.ArrayList;
import java.util.WeakHashMap;
import o.AbstractC0752ap;
import o.InterfaceC1788li;
import o.Oj0;
import o.T6;
import o.XZ;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
class ClockHandView extends View {
    public final ValueAnimator l;
    public boolean m;
    public final ArrayList n;

    /* renamed from: o, reason: collision with root package name */
    public final int f31o;
    public final float p;
    public final Paint q;
    public final RectF r;
    public final int s;
    public float t;
    public boolean u;
    public double v;
    public int w;
    public int x;

    public ClockHandView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, R.attr.materialClockStyle);
        this.l = new ValueAnimator();
        this.n = new ArrayList();
        Paint paint = new Paint();
        this.q = paint;
        this.r = new RectF();
        this.x = 1;
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, XZ.e, R.attr.materialClockStyle, R.style.Widget_MaterialComponents_TimePicker_Clock);
        AbstractC0752ap.a0(context, R.attr.motionDurationLong2, 200);
        AbstractC0752ap.b0(context, R.attr.motionEasingEmphasizedInterpolator, T6.b);
        this.w = typedArrayObtainStyledAttributes.getDimensionPixelSize(1, 0);
        this.f31o = typedArrayObtainStyledAttributes.getDimensionPixelSize(2, 0);
        this.s = getResources().getDimensionPixelSize(R.dimen.material_clock_hand_stroke_width);
        this.p = r4.getDimensionPixelSize(R.dimen.material_clock_hand_center_dot_radius);
        int color = typedArrayObtainStyledAttributes.getColor(0, 0);
        paint.setAntiAlias(true);
        paint.setColor(color);
        b(0.0f);
        ViewConfiguration.get(context).getScaledTouchSlop();
        WeakHashMap weakHashMap = Oj0.a;
        setImportantForAccessibility(2);
        typedArrayObtainStyledAttributes.recycle();
    }

    public final int a(int i) {
        return i == 2 ? Math.round(this.w * 0.66f) : this.w;
    }

    public final void b(float f) {
        ValueAnimator valueAnimator = this.l;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        float f2 = f % 360.0f;
        this.t = f2;
        this.v = Math.toRadians(f2 - 90.0f);
        int height = getHeight() / 2;
        int width = getWidth() / 2;
        float fA = a(this.x);
        float fCos = (((float) Math.cos(this.v)) * fA) + width;
        float fSin = (fA * ((float) Math.sin(this.v))) + height;
        float f3 = this.f31o;
        this.r.set(fCos - f3, fSin - f3, fCos + f3, fSin + f3);
        ArrayList arrayList = this.n;
        int size = arrayList.size();
        int i = 0;
        while (i < size) {
            Object obj = arrayList.get(i);
            i++;
            ClockFaceView clockFaceView = (ClockFaceView) ((InterfaceC1788li) obj);
            if (Math.abs(clockFaceView.R - f2) > 0.001f) {
                clockFaceView.R = f2;
                clockFaceView.n();
            }
        }
        invalidate();
    }

    @Override // android.view.View
    public final void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int height = getHeight() / 2;
        int width = getWidth() / 2;
        float f = width;
        float fA = a(this.x);
        float fCos = (((float) Math.cos(this.v)) * fA) + f;
        float f2 = height;
        float fSin = (fA * ((float) Math.sin(this.v))) + f2;
        Paint paint = this.q;
        paint.setStrokeWidth(0.0f);
        canvas.drawCircle(fCos, fSin, this.f31o, paint);
        double dSin = Math.sin(this.v);
        paint.setStrokeWidth(this.s);
        canvas.drawLine(f, f2, width + ((int) (Math.cos(this.v) * d)), height + ((int) (d * dSin)), paint);
        canvas.drawCircle(f, f2, this.p, paint);
    }

    @Override // android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        if (this.l.isRunning()) {
            return;
        }
        b(this.t);
    }

    @Override // android.view.View
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        boolean z;
        boolean z2;
        int actionMasked = motionEvent.getActionMasked();
        float x = motionEvent.getX();
        float y = motionEvent.getY();
        boolean z3 = false;
        if (actionMasked == 0) {
            this.u = false;
            z = true;
            z2 = false;
        } else if (actionMasked == 1 || actionMasked == 2) {
            z2 = this.u;
            if (this.m) {
                this.x = ((float) Math.hypot((double) (x - ((float) (getWidth() / 2))), (double) (y - ((float) (getHeight() / 2))))) <= ((float) a(2)) + TypedValue.applyDimension(1, (float) 12, getContext().getResources().getDisplayMetrics()) ? 2 : 1;
            }
            z = false;
        } else {
            z2 = false;
            z = false;
        }
        boolean z4 = this.u;
        int degrees = (int) Math.toDegrees(Math.atan2(y - (getHeight() / 2), x - (getWidth() / 2)));
        int i = degrees + 90;
        if (i < 0) {
            i = degrees + 450;
        }
        float f = i;
        boolean z5 = this.t != f;
        if (z && z5) {
            z3 = true;
        } else if (z5 || z2) {
            b(f);
            z3 = true;
        }
        this.u = z4 | z3;
        return true;
    }
}
