package com.google.android.material.timepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import com.google.android.gms.common.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import o.AbstractC2461sm0;
import o.C0297Ll;
import o.C0322Ml;
import o.C0426Ql;
import o.Co0;
import o.InterfaceC1788li;
import o.Oj0;
import o.XZ;
import o.ZZ;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
class ClockFaceView extends ZZ implements InterfaceC1788li {
    public final ClockHandView E;
    public final Rect F;
    public final RectF G;
    public final Rect H;
    public final SparseArray I;
    public final c J;
    public final int[] K;
    public final float[] L;
    public final int M;
    public final int N;
    public final int O;
    public final int P;
    public final String[] Q;
    public float R;
    public final ColorStateList S;

    public ClockFaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.F = new Rect();
        this.G = new RectF();
        this.H = new Rect();
        SparseArray sparseArray = new SparseArray();
        this.I = sparseArray;
        this.L = new float[]{0.0f, 0.9f, 1.0f};
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, XZ.d, R.attr.materialClockStyle, R.style.Widget_MaterialComponents_TimePicker_Clock);
        Resources resources = getResources();
        ColorStateList colorStateListQ = AbstractC2461sm0.q(context, typedArrayObtainStyledAttributes, 1);
        this.S = colorStateListQ;
        LayoutInflater.from(context).inflate(R.layout.material_clockface_view, (ViewGroup) this, true);
        ClockHandView clockHandView = (ClockHandView) findViewById(R.id.material_clock_hand);
        this.E = clockHandView;
        this.M = resources.getDimensionPixelSize(R.dimen.material_clock_hand_padding);
        int colorForState = colorStateListQ.getColorForState(new int[]{android.R.attr.state_selected}, colorStateListQ.getDefaultColor());
        this.K = new int[]{colorForState, colorForState, colorStateListQ.getDefaultColor()};
        clockHandView.n.add(this);
        int defaultColor = Co0.z(context, R.color.material_timepicker_clockface).getDefaultColor();
        ColorStateList colorStateListQ2 = AbstractC2461sm0.q(context, typedArrayObtainStyledAttributes, 0);
        setBackgroundColor(colorStateListQ2 != null ? colorStateListQ2.getDefaultColor() : defaultColor);
        getViewTreeObserver().addOnPreDrawListener(new b(this));
        setFocusable(true);
        typedArrayObtainStyledAttributes.recycle();
        this.J = new c(this);
        String[] strArr = new String[12];
        Arrays.fill(strArr, "");
        this.Q = strArr;
        LayoutInflater layoutInflaterFrom = LayoutInflater.from(getContext());
        int size = sparseArray.size();
        boolean z = false;
        for (int i = 0; i < Math.max(this.Q.length, size); i++) {
            TextView textView = (TextView) sparseArray.get(i);
            if (i >= this.Q.length) {
                removeView(textView);
                sparseArray.remove(i);
            } else {
                if (textView == null) {
                    textView = (TextView) layoutInflaterFrom.inflate(R.layout.material_clockface_textview, (ViewGroup) this, false);
                    sparseArray.put(i, textView);
                    addView(textView);
                }
                textView.setText(this.Q[i]);
                textView.setTag(R.id.material_value_index, Integer.valueOf(i));
                int i2 = (i / 12) + 1;
                textView.setTag(R.id.material_clock_level, Integer.valueOf(i2));
                z = i2 > 1 ? true : z;
                Oj0.m(textView, this.J);
                textView.setTextColor(this.S);
            }
        }
        ClockHandView clockHandView2 = this.E;
        if (clockHandView2.m && !z) {
            clockHandView2.x = 1;
        }
        clockHandView2.m = z;
        clockHandView2.invalidate();
        this.N = resources.getDimensionPixelSize(R.dimen.material_time_picker_minimum_screen_height);
        this.O = resources.getDimensionPixelSize(R.dimen.material_time_picker_minimum_screen_width);
        this.P = resources.getDimensionPixelSize(R.dimen.material_clock_size);
    }

    @Override // o.ZZ
    public final void m() {
        C0426Ql c0426Ql = new C0426Ql();
        c0426Ql.b(this);
        HashMap map = new HashMap();
        for (int i = 0; i < getChildCount(); i++) {
            View childAt = getChildAt(i);
            if (childAt.getId() != R.id.circle_center && !"skip".equals(childAt.getTag())) {
                int i2 = (Integer) childAt.getTag(R.id.material_clock_level);
                if (i2 == null) {
                    i2 = 1;
                }
                if (!map.containsKey(i2)) {
                    map.put(i2, new ArrayList());
                }
                ((List) map.get(i2)).add(childAt);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            List list = (List) entry.getValue();
            int iRound = ((Integer) entry.getKey()).intValue() == 2 ? Math.round(this.C * 0.66f) : this.C;
            Iterator it = list.iterator();
            float size = 0.0f;
            while (it.hasNext()) {
                int id = ((View) it.next()).getId();
                Integer numValueOf = Integer.valueOf(id);
                HashMap map2 = c0426Ql.c;
                if (!map2.containsKey(numValueOf)) {
                    map2.put(Integer.valueOf(id), new C0297Ll());
                }
                C0322Ml c0322Ml = ((C0297Ll) map2.get(Integer.valueOf(id))).d;
                c0322Ml.z = R.id.circle_center;
                c0322Ml.A = iRound;
                c0322Ml.B = size;
                size += 360.0f / list.size();
            }
        }
        c0426Ql.a(this);
        setConstraintSet(null);
        requestLayout();
        int i3 = 0;
        while (true) {
            SparseArray sparseArray = this.I;
            if (i3 >= sparseArray.size()) {
                return;
            }
            ((TextView) sparseArray.get(i3)).setVisibility(0);
            i3++;
        }
    }

    public final void n() {
        SparseArray sparseArray;
        Rect rect;
        RectF rectF;
        RectF rectF2 = this.E.r;
        float f = Float.MAX_VALUE;
        TextView textView = null;
        int i = 0;
        while (true) {
            sparseArray = this.I;
            int size = sparseArray.size();
            rect = this.F;
            rectF = this.G;
            if (i >= size) {
                break;
            }
            TextView textView2 = (TextView) sparseArray.get(i);
            if (textView2 != null) {
                textView2.getHitRect(rect);
                rectF.set(rect);
                rectF.union(rectF2);
                float fHeight = rectF.height() * rectF.width();
                if (fHeight < f) {
                    textView = textView2;
                    f = fHeight;
                }
            }
            i++;
        }
        for (int i2 = 0; i2 < sparseArray.size(); i2++) {
            TextView textView3 = (TextView) sparseArray.get(i2);
            if (textView3 != null) {
                textView3.setSelected(textView3 == textView);
                textView3.getHitRect(rect);
                rectF.set(rect);
                textView3.getLineBounds(0, this.H);
                rectF.inset(r8.left, r8.top);
                textView3.getPaint().setShader(!RectF.intersects(rectF2, rectF) ? null : new RadialGradient(rectF2.centerX() - rectF.left, rectF2.centerY() - rectF.top, 0.5f * rectF2.width(), this.K, this.L, Shader.TileMode.CLAMP));
                textView3.invalidate();
            }
        }
    }

    @Override // android.view.View
    public final void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(1, this.Q.length, false, 1));
    }

    @Override // androidx.constraintlayout.widget.ConstraintLayout, android.view.ViewGroup, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        n();
    }

    @Override // androidx.constraintlayout.widget.ConstraintLayout, android.view.View
    public final void onMeasure(int i, int i2) throws Resources.NotFoundException, NumberFormatException {
        DisplayMetrics displayMetrics = getResources().getDisplayMetrics();
        int iMax = (int) (this.P / Math.max(Math.max(this.N / displayMetrics.heightPixels, this.O / displayMetrics.widthPixels), 1.0f));
        int iMakeMeasureSpec = View.MeasureSpec.makeMeasureSpec(iMax, 1073741824);
        setMeasuredDimension(iMax, iMax);
        super.onMeasure(iMakeMeasureSpec, iMakeMeasureSpec);
    }
}
