package com.google.android.material.textfield;

import android.R;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.ViewTreeObserver;
import android.view.animation.LinearInterpolator;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.material.internal.CheckableImageButton;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.WeakHashMap;
import o.AbstractC0121Er;
import o.AbstractC0501Ti;
import o.AbstractC0752ap;
import o.AbstractC1692kh0;
import o.AbstractC2378rs0;
import o.AbstractC2461sm0;
import o.AbstractC2841wm0;
import o.AbstractC2949xt;
import o.Ad0;
import o.Ae0;
import o.Be0;
import o.C0023Ax;
import o.C0211Id;
import o.C0253Jt;
import o.C0377Oo;
import o.C0387Oy;
import o.C0403Po;
import o.C0669Zu;
import o.C0766aw;
import o.C0957cw;
import o.C0997dO;
import o.C1016dd0;
import o.C1085eH;
import o.C1092eO;
import o.C1181fH;
import o.C1915n;
import o.C2065oe;
import o.C2160pe;
import o.C2164pg;
import o.C2342ra0;
import o.C2492t30;
import o.C3022yi;
import o.C70;
import o.C80;
import o.Ce0;
import o.Co0;
import o.De0;
import o.E8;
import o.IJ;
import o.Ig0;
import o.Ij0;
import o.InterfaceC2273qn;
import o.KN;
import o.M70;
import o.N70;
import o.OD;
import o.Oj0;
import o.RunnableC2017o3;
import o.RunnableC2108p1;
import o.T6;
import o.V7;
import o.XZ;
import o.YT;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class TextInputLayout extends LinearLayout implements ViewTreeObserver.OnGlobalLayoutListener {
    public static final int[][] N0 = {new int[]{R.attr.state_pressed}, new int[0]};
    public int A;
    public int A0;
    public int B;
    public int B0;
    public CharSequence C;
    public int C0;
    public boolean D;
    public int D0;
    public E8 E;
    public int E0;
    public ColorStateList F;
    public boolean F0;
    public int G;
    public final C3022yi G0;
    public C0023Ax H;
    public boolean H0;
    public C0023Ax I;
    public boolean I0;
    public ColorStateList J;
    public ValueAnimator J0;
    public ColorStateList K;
    public boolean K0;
    public ColorStateList L;
    public boolean L0;
    public ColorStateList M;
    public boolean M0;
    public boolean N;
    public CharSequence O;
    public boolean P;
    public C1092eO Q;
    public C1092eO R;
    public StateListDrawable S;
    public boolean T;
    public C1092eO U;
    public C1092eO V;
    public N70 W;
    public boolean a0;
    public final int b0;
    public int c0;
    public int d0;
    public int e0;
    public int f0;
    public int g0;
    public int h0;
    public int i0;
    public final Rect j0;
    public final Rect k0;
    public final FrameLayout l;
    public final RectF l0;
    public final C2342ra0 m;
    public Typeface m0;
    public final C0957cw n;
    public ColorDrawable n0;

    /* renamed from: o, reason: collision with root package name */
    public EditText f30o;
    public int o0;
    public CharSequence p;
    public final LinkedHashSet p0;
    public int q;
    public ColorDrawable q0;
    public int r;
    public int r0;
    public int s;
    public Drawable s0;
    public int t;
    public ColorStateList t0;
    public final C1181fH u;
    public ColorStateList u0;
    public boolean v;
    public int v0;
    public int w;
    public int w0;
    public boolean x;
    public int x0;
    public Ce0 y;
    public ColorStateList y0;
    public E8 z;
    public int z0;

    public TextInputLayout(Context context, AttributeSet attributeSet) throws Resources.NotFoundException {
        super(AbstractC2378rs0.n0(context, attributeSet, com.google.android.gms.common.R.attr.textInputStyle, com.google.android.gms.common.R.style.Widget_Design_TextInputLayout), attributeSet, com.google.android.gms.common.R.attr.textInputStyle);
        this.q = -1;
        this.r = -1;
        this.s = -1;
        this.t = -1;
        this.u = new C1181fH(this);
        this.y = new C0387Oy(18);
        this.j0 = new Rect();
        this.k0 = new Rect();
        this.l0 = new RectF();
        this.p0 = new LinkedHashSet();
        C3022yi c3022yi = new C3022yi(this);
        this.G0 = c3022yi;
        this.M0 = false;
        Context context2 = getContext();
        setOrientation(1);
        setWillNotDraw(false);
        setAddStatesFromChildren(true);
        FrameLayout frameLayout = new FrameLayout(context2);
        this.l = frameLayout;
        frameLayout.setAddStatesFromChildren(true);
        LinearInterpolator linearInterpolator = T6.a;
        c3022yi.Q = linearInterpolator;
        c3022yi.h(false);
        c3022yi.P = linearInterpolator;
        c3022yi.h(false);
        if (c3022yi.g != 8388659) {
            c3022yi.g = 8388659;
            c3022yi.h(false);
        }
        YT.l(context2, attributeSet, com.google.android.gms.common.R.attr.textInputStyle, com.google.android.gms.common.R.style.Widget_Design_TextInputLayout);
        int[] iArr = XZ.A;
        YT.n(context2, attributeSet, iArr, com.google.android.gms.common.R.attr.textInputStyle, com.google.android.gms.common.R.style.Widget_Design_TextInputLayout, 22, 20, 40, 45, 49);
        TypedArray typedArrayObtainStyledAttributes = context2.obtainStyledAttributes(attributeSet, iArr, com.google.android.gms.common.R.attr.textInputStyle, com.google.android.gms.common.R.style.Widget_Design_TextInputLayout);
        C70 c70 = new C70(context2, typedArrayObtainStyledAttributes);
        C2342ra0 c2342ra0 = new C2342ra0(this, c70);
        this.m = c2342ra0;
        this.N = typedArrayObtainStyledAttributes.getBoolean(48, true);
        setHint(typedArrayObtainStyledAttributes.getText(4));
        this.I0 = typedArrayObtainStyledAttributes.getBoolean(47, true);
        this.H0 = typedArrayObtainStyledAttributes.getBoolean(42, true);
        if (typedArrayObtainStyledAttributes.hasValue(6)) {
            setMinEms(typedArrayObtainStyledAttributes.getInt(6, -1));
        } else if (typedArrayObtainStyledAttributes.hasValue(3)) {
            setMinWidth(typedArrayObtainStyledAttributes.getDimensionPixelSize(3, -1));
        }
        if (typedArrayObtainStyledAttributes.hasValue(5)) {
            setMaxEms(typedArrayObtainStyledAttributes.getInt(5, -1));
        } else if (typedArrayObtainStyledAttributes.hasValue(2)) {
            setMaxWidth(typedArrayObtainStyledAttributes.getDimensionPixelSize(2, -1));
        }
        this.W = N70.b(context2, attributeSet, com.google.android.gms.common.R.attr.textInputStyle, com.google.android.gms.common.R.style.Widget_Design_TextInputLayout).a();
        this.b0 = context2.getResources().getDimensionPixelOffset(com.google.android.gms.common.R.dimen.mtrl_textinput_box_label_cutout_padding);
        this.d0 = typedArrayObtainStyledAttributes.getDimensionPixelOffset(9, 0);
        this.f0 = typedArrayObtainStyledAttributes.getDimensionPixelSize(16, context2.getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.mtrl_textinput_box_stroke_width_default));
        this.g0 = typedArrayObtainStyledAttributes.getDimensionPixelSize(17, context2.getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.mtrl_textinput_box_stroke_width_focused));
        this.e0 = this.f0;
        float dimension = typedArrayObtainStyledAttributes.getDimension(13, -1.0f);
        float dimension2 = typedArrayObtainStyledAttributes.getDimension(12, -1.0f);
        float dimension3 = typedArrayObtainStyledAttributes.getDimension(10, -1.0f);
        float dimension4 = typedArrayObtainStyledAttributes.getDimension(11, -1.0f);
        M70 m70E = this.W.e();
        if (dimension >= 0.0f) {
            m70E.e = new C1915n(dimension);
        }
        if (dimension2 >= 0.0f) {
            m70E.f = new C1915n(dimension2);
        }
        if (dimension3 >= 0.0f) {
            m70E.g = new C1915n(dimension3);
        }
        if (dimension4 >= 0.0f) {
            m70E.h = new C1915n(dimension4);
        }
        this.W = m70E.a();
        ColorStateList colorStateListR = AbstractC2461sm0.r(context2, c70, 7);
        if (colorStateListR != null) {
            int defaultColor = colorStateListR.getDefaultColor();
            this.z0 = defaultColor;
            this.i0 = defaultColor;
            if (colorStateListR.isStateful()) {
                this.A0 = colorStateListR.getColorForState(new int[]{-16842910}, -1);
                this.B0 = colorStateListR.getColorForState(new int[]{R.attr.state_focused, R.attr.state_enabled}, -1);
                this.C0 = colorStateListR.getColorForState(new int[]{R.attr.state_hovered, R.attr.state_enabled}, -1);
            } else {
                this.B0 = this.z0;
                ColorStateList colorStateListZ = Co0.z(context2, com.google.android.gms.common.R.color.mtrl_filled_background_color);
                this.A0 = colorStateListZ.getColorForState(new int[]{-16842910}, -1);
                this.C0 = colorStateListZ.getColorForState(new int[]{R.attr.state_hovered}, -1);
            }
        } else {
            this.i0 = 0;
            this.z0 = 0;
            this.A0 = 0;
            this.B0 = 0;
            this.C0 = 0;
        }
        if (typedArrayObtainStyledAttributes.hasValue(1)) {
            ColorStateList colorStateListL = c70.l(1);
            this.u0 = colorStateListL;
            this.t0 = colorStateListL;
        }
        ColorStateList colorStateListR2 = AbstractC2461sm0.r(context2, c70, 14);
        this.x0 = typedArrayObtainStyledAttributes.getColor(14, 0);
        this.v0 = context2.getColor(com.google.android.gms.common.R.color.mtrl_textinput_default_box_stroke_color);
        this.D0 = context2.getColor(com.google.android.gms.common.R.color.mtrl_textinput_disabled_color);
        this.w0 = context2.getColor(com.google.android.gms.common.R.color.mtrl_textinput_hovered_box_stroke_color);
        if (colorStateListR2 != null) {
            setBoxStrokeColorStateList(colorStateListR2);
        }
        if (typedArrayObtainStyledAttributes.hasValue(15)) {
            setBoxStrokeErrorColor(AbstractC2461sm0.r(context2, c70, 15));
        }
        if (typedArrayObtainStyledAttributes.getResourceId(49, -1) != -1) {
            setHintTextAppearance(typedArrayObtainStyledAttributes.getResourceId(49, 0));
        }
        this.L = c70.l(24);
        this.M = c70.l(25);
        int resourceId = typedArrayObtainStyledAttributes.getResourceId(40, 0);
        CharSequence text = typedArrayObtainStyledAttributes.getText(35);
        int i = typedArrayObtainStyledAttributes.getInt(34, 1);
        boolean z = typedArrayObtainStyledAttributes.getBoolean(36, false);
        int resourceId2 = typedArrayObtainStyledAttributes.getResourceId(45, 0);
        boolean z2 = typedArrayObtainStyledAttributes.getBoolean(44, false);
        CharSequence text2 = typedArrayObtainStyledAttributes.getText(43);
        int resourceId3 = typedArrayObtainStyledAttributes.getResourceId(57, 0);
        CharSequence text3 = typedArrayObtainStyledAttributes.getText(56);
        boolean z3 = typedArrayObtainStyledAttributes.getBoolean(18, false);
        setCounterMaxLength(typedArrayObtainStyledAttributes.getInt(19, -1));
        this.B = typedArrayObtainStyledAttributes.getResourceId(22, 0);
        this.A = typedArrayObtainStyledAttributes.getResourceId(20, 0);
        setBoxBackgroundMode(typedArrayObtainStyledAttributes.getInt(8, 0));
        setErrorContentDescription(text);
        setErrorAccessibilityLiveRegion(i);
        setCounterOverflowTextAppearance(this.A);
        setHelperTextTextAppearance(resourceId2);
        setErrorTextAppearance(resourceId);
        setCounterTextAppearance(this.B);
        setPlaceholderText(text3);
        setPlaceholderTextAppearance(resourceId3);
        if (typedArrayObtainStyledAttributes.hasValue(41)) {
            setErrorTextColor(c70.l(41));
        }
        if (typedArrayObtainStyledAttributes.hasValue(46)) {
            setHelperTextColor(c70.l(46));
        }
        if (typedArrayObtainStyledAttributes.hasValue(50)) {
            setHintTextColor(c70.l(50));
        }
        if (typedArrayObtainStyledAttributes.hasValue(23)) {
            setCounterTextColor(c70.l(23));
        }
        if (typedArrayObtainStyledAttributes.hasValue(21)) {
            setCounterOverflowTextColor(c70.l(21));
        }
        if (typedArrayObtainStyledAttributes.hasValue(58)) {
            setPlaceholderTextColor(c70.l(58));
        }
        C0957cw c0957cw = new C0957cw(this, c70);
        this.n = c0957cw;
        boolean z4 = typedArrayObtainStyledAttributes.getBoolean(0, true);
        c70.t();
        setImportantForAccessibility(2);
        int i2 = Build.VERSION.SDK_INT;
        if (i2 >= 26 && i2 >= 26) {
            Ij0.b(this, 1);
        }
        frameLayout.addView(c2342ra0);
        frameLayout.addView(c0957cw);
        addView(frameLayout);
        setEnabled(z4);
        setHelperTextEnabled(z2);
        setErrorEnabled(z);
        setCounterEnabled(z3);
        setHelperText(text2);
    }

    private Drawable getEditTextBoxBackground() {
        EditText editText = this.f30o;
        if (!(editText instanceof AutoCompleteTextView) || editText.getInputType() != 0) {
            return this.Q;
        }
        int iS = AbstractC1692kh0.s(this.f30o, com.google.android.gms.common.R.attr.colorControlHighlight);
        int i = this.c0;
        int[][] iArr = N0;
        if (i != 2) {
            if (i != 1) {
                return null;
            }
            C1092eO c1092eO = this.Q;
            int i2 = this.i0;
            return new RippleDrawable(new ColorStateList(iArr, new int[]{AbstractC1692kh0.D(0.1f, iS, i2), i2}), c1092eO, c1092eO);
        }
        Context context = getContext();
        C1092eO c1092eO2 = this.Q;
        TypedValue typedValueV = C80.V(context, com.google.android.gms.common.R.attr.colorSurface, "TextInputLayout");
        int i3 = typedValueV.resourceId;
        int color = i3 != 0 ? context.getColor(i3) : typedValueV.data;
        C1092eO c1092eO3 = new C1092eO(c1092eO2.l.a);
        int iD = AbstractC1692kh0.D(0.1f, iS, color);
        c1092eO3.j(new ColorStateList(iArr, new int[]{iD, 0}));
        c1092eO3.setTint(color);
        ColorStateList colorStateList = new ColorStateList(iArr, new int[]{iD, color});
        C1092eO c1092eO4 = new C1092eO(c1092eO2.l.a);
        c1092eO4.setTint(-1);
        return new LayerDrawable(new Drawable[]{new RippleDrawable(colorStateList, c1092eO3, c1092eO4), c1092eO2});
    }

    private Drawable getOrCreateFilledDropDownMenuBackground() {
        if (this.S == null) {
            StateListDrawable stateListDrawable = new StateListDrawable();
            this.S = stateListDrawable;
            stateListDrawable.addState(new int[]{R.attr.state_above_anchor}, getOrCreateOutlinedDropDownMenuBackground());
            this.S.addState(new int[0], f(false));
        }
        return this.S;
    }

    private Drawable getOrCreateOutlinedDropDownMenuBackground() {
        if (this.R == null) {
            this.R = f(true);
        }
        return this.R;
    }

    public static void k(ViewGroup viewGroup, boolean z) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = viewGroup.getChildAt(i);
            childAt.setEnabled(z);
            if (childAt instanceof ViewGroup) {
                k((ViewGroup) childAt, z);
            }
        }
    }

    private void setEditText(EditText editText) throws Resources.NotFoundException {
        if (this.f30o != null) {
            throw new IllegalArgumentException("We already have an EditText, can only have one");
        }
        getEndIconMode();
        this.f30o = editText;
        int i = this.q;
        if (i != -1) {
            setMinEms(i);
        } else {
            setMinWidth(this.s);
        }
        int i2 = this.r;
        if (i2 != -1) {
            setMaxEms(i2);
        } else {
            setMaxWidth(this.t);
        }
        this.T = false;
        i();
        setTextInputAccessibilityDelegate(new Be0(this));
        Typeface typeface = this.f30o.getTypeface();
        C3022yi c3022yi = this.G0;
        c3022yi.m(typeface);
        float textSize = this.f30o.getTextSize();
        if (c3022yi.h != textSize) {
            c3022yi.h = textSize;
            c3022yi.h(false);
        }
        int i3 = Build.VERSION.SDK_INT;
        float letterSpacing = this.f30o.getLetterSpacing();
        if (c3022yi.W != letterSpacing) {
            c3022yi.W = letterSpacing;
            c3022yi.h(false);
        }
        int gravity = this.f30o.getGravity();
        int i4 = (gravity & (-113)) | 48;
        if (c3022yi.g != i4) {
            c3022yi.g = i4;
            c3022yi.h(false);
        }
        if (c3022yi.f != gravity) {
            c3022yi.f = gravity;
            c3022yi.h(false);
        }
        WeakHashMap weakHashMap = Oj0.a;
        this.E0 = editText.getMinimumHeight();
        this.f30o.addTextChangedListener(new Ae0(this, editText));
        if (this.t0 == null) {
            this.t0 = this.f30o.getHintTextColors();
        }
        if (this.N) {
            if (TextUtils.isEmpty(this.O)) {
                CharSequence hint = this.f30o.getHint();
                this.p = hint;
                setHint(hint);
                this.f30o.setHint((CharSequence) null);
            }
            this.P = true;
        }
        if (i3 >= 29) {
            p();
        }
        if (this.z != null) {
            n(this.f30o.getText());
        }
        r();
        this.u.b();
        this.m.bringToFront();
        C0957cw c0957cw = this.n;
        c0957cw.bringToFront();
        Iterator it = this.p0.iterator();
        while (it.hasNext()) {
            ((C0766aw) it.next()).a(this);
        }
        c0957cw.m();
        if (!isEnabled()) {
            editText.setEnabled(false);
        }
        u(false, true);
    }

    private void setHintInternal(CharSequence charSequence) {
        if (TextUtils.equals(charSequence, this.O)) {
            return;
        }
        this.O = charSequence;
        C3022yi c3022yi = this.G0;
        if (charSequence == null || !TextUtils.equals(c3022yi.A, charSequence)) {
            c3022yi.A = charSequence;
            c3022yi.B = null;
            Bitmap bitmap = c3022yi.E;
            if (bitmap != null) {
                bitmap.recycle();
                c3022yi.E = null;
            }
            c3022yi.h(false);
        }
        if (this.F0) {
            return;
        }
        j();
    }

    private void setPlaceholderTextEnabled(boolean z) {
        if (this.D == z) {
            return;
        }
        if (z) {
            E8 e8 = this.E;
            if (e8 != null) {
                this.l.addView(e8);
                this.E.setVisibility(0);
            }
        } else {
            E8 e82 = this.E;
            if (e82 != null) {
                e82.setVisibility(8);
            }
            this.E = null;
        }
        this.D = z;
    }

    public final void a(float f) {
        C3022yi c3022yi = this.G0;
        if (c3022yi.b == f) {
            return;
        }
        int i = 2;
        if (this.J0 == null) {
            ValueAnimator valueAnimator = new ValueAnimator();
            this.J0 = valueAnimator;
            valueAnimator.setInterpolator(AbstractC0752ap.b0(getContext(), com.google.android.gms.common.R.attr.motionEasingEmphasizedInterpolator, T6.b));
            this.J0.setDuration(AbstractC0752ap.a0(getContext(), com.google.android.gms.common.R.attr.motionDurationMedium4, 167));
            this.J0.addUpdateListener(new C2065oe(i, this));
        }
        this.J0.setFloatValues(c3022yi.b, f);
        this.J0.start();
    }

    @Override // android.view.ViewGroup
    public final void addView(View view, int i, ViewGroup.LayoutParams layoutParams) throws Resources.NotFoundException {
        if (!(view instanceof EditText)) {
            super.addView(view, i, layoutParams);
            return;
        }
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(layoutParams);
        layoutParams2.gravity = (layoutParams2.gravity & (-113)) | 16;
        FrameLayout frameLayout = this.l;
        frameLayout.addView(view, layoutParams2);
        frameLayout.setLayoutParams(layoutParams);
        t();
        setEditText((EditText) view);
    }

    public final void b() {
        int i;
        int i2;
        C1092eO c1092eO = this.Q;
        if (c1092eO == null) {
            return;
        }
        N70 n70 = c1092eO.l.a;
        N70 n702 = this.W;
        if (n70 != n702) {
            c1092eO.setShapeAppearanceModel(n702);
        }
        if (this.c0 == 2 && (i = this.e0) > -1 && (i2 = this.h0) != 0) {
            C1092eO c1092eO2 = this.Q;
            c1092eO2.l.j = i;
            c1092eO2.invalidateSelf();
            ColorStateList colorStateListValueOf = ColorStateList.valueOf(i2);
            C0997dO c0997dO = c1092eO2.l;
            if (c0997dO.d != colorStateListValueOf) {
                c0997dO.d = colorStateListValueOf;
                c1092eO2.onStateChange(c1092eO2.getState());
            }
        }
        int iB = this.i0;
        if (this.c0 == 1) {
            iB = AbstractC0501Ti.b(this.i0, AbstractC1692kh0.r(getContext(), com.google.android.gms.common.R.attr.colorSurface, 0));
        }
        this.i0 = iB;
        this.Q.j(ColorStateList.valueOf(iB));
        C1092eO c1092eO3 = this.U;
        if (c1092eO3 != null && this.V != null) {
            if (this.e0 > -1 && this.h0 != 0) {
                c1092eO3.j(this.f30o.isFocused() ? ColorStateList.valueOf(this.v0) : ColorStateList.valueOf(this.h0));
                this.V.j(ColorStateList.valueOf(this.h0));
            }
            invalidate();
        }
        s();
    }

    public final int c() {
        float fD;
        if (!this.N) {
            return 0;
        }
        int i = this.c0;
        C3022yi c3022yi = this.G0;
        if (i == 0) {
            fD = c3022yi.d();
        } else {
            if (i != 2) {
                return 0;
            }
            fD = c3022yi.d() / 2.0f;
        }
        return (int) fD;
    }

    public final C0023Ax d() {
        C0023Ax c0023Ax = new C0023Ax();
        c0023Ax.n = AbstractC0752ap.a0(getContext(), com.google.android.gms.common.R.attr.motionDurationShort2, 87);
        c0023Ax.f808o = AbstractC0752ap.b0(getContext(), com.google.android.gms.common.R.attr.motionEasingLinearInterpolator, T6.a);
        return c0023Ax;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void dispatchProvideAutofillStructure(ViewStructure viewStructure, int i) {
        EditText editText = this.f30o;
        if (editText == null) {
            super.dispatchProvideAutofillStructure(viewStructure, i);
            return;
        }
        if (this.p != null) {
            boolean z = this.P;
            this.P = false;
            CharSequence hint = editText.getHint();
            this.f30o.setHint(this.p);
            try {
                super.dispatchProvideAutofillStructure(viewStructure, i);
                return;
            } finally {
                this.f30o.setHint(hint);
                this.P = z;
            }
        }
        viewStructure.setAutofillId(getAutofillId());
        onProvideAutofillStructure(viewStructure, i);
        onProvideAutofillVirtualStructure(viewStructure, i);
        FrameLayout frameLayout = this.l;
        viewStructure.setChildCount(frameLayout.getChildCount());
        for (int i2 = 0; i2 < frameLayout.getChildCount(); i2++) {
            View childAt = frameLayout.getChildAt(i2);
            ViewStructure viewStructureNewChild = viewStructure.newChild(i2);
            childAt.dispatchProvideAutofillStructure(viewStructureNewChild, i);
            if (childAt == this.f30o) {
                viewStructureNewChild.setHint(getHint());
            }
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void dispatchRestoreInstanceState(SparseArray sparseArray) {
        this.L0 = true;
        super.dispatchRestoreInstanceState(sparseArray);
        this.L0 = false;
    }

    @Override // android.view.View
    public final void draw(Canvas canvas) {
        C1092eO c1092eO;
        Canvas canvas2 = canvas;
        super.draw(canvas);
        boolean z = this.N;
        C3022yi c3022yi = this.G0;
        if (z) {
            TextPaint textPaint = c3022yi.N;
            RectF rectF = c3022yi.e;
            int iSave = canvas2.save();
            if (c3022yi.B != null && rectF.width() > 0.0f && rectF.height() > 0.0f) {
                textPaint.setTextSize(c3022yi.G);
                float f = c3022yi.p;
                float f2 = c3022yi.q;
                float f3 = c3022yi.F;
                if (f3 != 1.0f) {
                    canvas2.scale(f3, f3, f, f2);
                }
                if (c3022yi.d0 <= 1 || c3022yi.C) {
                    canvas2.translate(f, f2);
                    c3022yi.Y.draw(canvas2);
                } else {
                    float lineStart = c3022yi.p - c3022yi.Y.getLineStart(0);
                    int alpha = textPaint.getAlpha();
                    canvas2.translate(lineStart, f2);
                    float f4 = alpha;
                    textPaint.setAlpha((int) (c3022yi.b0 * f4));
                    int i = Build.VERSION.SDK_INT;
                    if (i >= 31) {
                        float f5 = c3022yi.H;
                        float f6 = c3022yi.I;
                        float f7 = c3022yi.J;
                        int i2 = c3022yi.K;
                        textPaint.setShadowLayer(f5, f6, f7, AbstractC0501Ti.d(i2, (textPaint.getAlpha() * Color.alpha(i2)) / 255));
                    }
                    c3022yi.Y.draw(canvas2);
                    textPaint.setAlpha((int) (c3022yi.a0 * f4));
                    if (i >= 31) {
                        float f8 = c3022yi.H;
                        float f9 = c3022yi.I;
                        float f10 = c3022yi.J;
                        int i3 = c3022yi.K;
                        textPaint.setShadowLayer(f8, f9, f10, AbstractC0501Ti.d(i3, (Color.alpha(i3) * textPaint.getAlpha()) / 255));
                    }
                    int lineBaseline = c3022yi.Y.getLineBaseline(0);
                    CharSequence charSequence = c3022yi.c0;
                    float f11 = lineBaseline;
                    canvas2.drawText(charSequence, 0, charSequence.length(), 0.0f, f11, textPaint);
                    if (i >= 31) {
                        textPaint.setShadowLayer(c3022yi.H, c3022yi.I, c3022yi.J, c3022yi.K);
                    }
                    String strTrim = c3022yi.c0.toString().trim();
                    if (strTrim.endsWith("…")) {
                        strTrim = strTrim.substring(0, strTrim.length() - 1);
                    }
                    String str = strTrim;
                    textPaint.setAlpha(alpha);
                    canvas2 = canvas;
                    canvas2.drawText(str, 0, Math.min(c3022yi.Y.getLineEnd(0), str.length()), 0.0f, f11, (Paint) textPaint);
                }
                canvas2.restoreToCount(iSave);
            }
        }
        if (this.V == null || (c1092eO = this.U) == null) {
            return;
        }
        c1092eO.draw(canvas2);
        if (this.f30o.isFocused()) {
            Rect bounds = this.V.getBounds();
            Rect bounds2 = this.U.getBounds();
            float f12 = c3022yi.b;
            int iCenterX = bounds2.centerX();
            bounds.left = T6.c(f12, iCenterX, bounds2.left);
            bounds.right = T6.c(f12, iCenterX, bounds2.right);
            this.V.draw(canvas2);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:16:0x002f  */
    @Override // android.view.ViewGroup, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void drawableStateChanged() throws android.content.res.Resources.NotFoundException {
        /*
            r4 = this;
            boolean r0 = r4.K0
            if (r0 == 0) goto L5
            return
        L5:
            r0 = 1
            r4.K0 = r0
            super.drawableStateChanged()
            int[] r1 = r4.getDrawableState()
            r2 = 0
            o.yi r3 = r4.G0
            if (r3 == 0) goto L2f
            r3.L = r1
            android.content.res.ColorStateList r1 = r3.k
            if (r1 == 0) goto L20
            boolean r1 = r1.isStateful()
            if (r1 != 0) goto L2a
        L20:
            android.content.res.ColorStateList r1 = r3.j
            if (r1 == 0) goto L2f
            boolean r1 = r1.isStateful()
            if (r1 == 0) goto L2f
        L2a:
            r3.h(r2)
            r1 = r0
            goto L30
        L2f:
            r1 = r2
        L30:
            android.widget.EditText r3 = r4.f30o
            if (r3 == 0) goto L47
            java.util.WeakHashMap r3 = o.Oj0.a
            boolean r3 = r4.isLaidOut()
            if (r3 == 0) goto L43
            boolean r3 = r4.isEnabled()
            if (r3 == 0) goto L43
            goto L44
        L43:
            r0 = r2
        L44:
            r4.u(r0, r2)
        L47:
            r4.r()
            r4.x()
            if (r1 == 0) goto L52
            r4.invalidate()
        L52:
            r4.K0 = r2
            return
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.textfield.TextInputLayout.drawableStateChanged():void");
    }

    public final boolean e() {
        return this.N && !TextUtils.isEmpty(this.O) && (this.Q instanceof C0403Po);
    }

    public final C1092eO f(boolean z) throws Resources.NotFoundException {
        float dimensionPixelOffset = getResources().getDimensionPixelOffset(com.google.android.gms.common.R.dimen.mtrl_shape_corner_size_small_component);
        float f = z ? dimensionPixelOffset : 0.0f;
        EditText editText = this.f30o;
        float popupElevation = editText instanceof KN ? ((KN) editText).getPopupElevation() : getResources().getDimensionPixelOffset(com.google.android.gms.common.R.dimen.m3_comp_outlined_autocomplete_menu_container_elevation);
        int dimensionPixelOffset2 = getResources().getDimensionPixelOffset(com.google.android.gms.common.R.dimen.mtrl_exposed_dropdown_menu_popup_vertical_padding);
        C2492t30 c2492t30 = new C2492t30();
        C2492t30 c2492t302 = new C2492t30();
        C2492t30 c2492t303 = new C2492t30();
        C2492t30 c2492t304 = new C2492t30();
        int i = 0;
        C0669Zu c0669Zu = new C0669Zu(i);
        C0669Zu c0669Zu2 = new C0669Zu(i);
        C0669Zu c0669Zu3 = new C0669Zu(i);
        C0669Zu c0669Zu4 = new C0669Zu(i);
        C1915n c1915n = new C1915n(f);
        C1915n c1915n2 = new C1915n(f);
        C1915n c1915n3 = new C1915n(dimensionPixelOffset);
        C1915n c1915n4 = new C1915n(dimensionPixelOffset);
        N70 n70 = new N70();
        n70.a = c2492t30;
        n70.b = c2492t302;
        n70.c = c2492t303;
        n70.d = c2492t304;
        n70.e = c1915n;
        n70.f = c1915n2;
        n70.g = c1915n4;
        n70.h = c1915n3;
        n70.i = c0669Zu;
        n70.j = c0669Zu2;
        n70.k = c0669Zu3;
        n70.l = c0669Zu4;
        EditText editText2 = this.f30o;
        ColorStateList dropDownBackgroundTintList = editText2 instanceof KN ? ((KN) editText2).getDropDownBackgroundTintList() : null;
        Context context = getContext();
        if (dropDownBackgroundTintList == null) {
            Paint paint = C1092eO.H;
            TypedValue typedValueV = C80.V(context, com.google.android.gms.common.R.attr.colorSurface, C1092eO.class.getSimpleName());
            int i2 = typedValueV.resourceId;
            dropDownBackgroundTintList = ColorStateList.valueOf(i2 != 0 ? context.getColor(i2) : typedValueV.data);
        }
        C1092eO c1092eO = new C1092eO();
        c1092eO.h(context);
        c1092eO.j(dropDownBackgroundTintList);
        c1092eO.i(popupElevation);
        c1092eO.setShapeAppearanceModel(n70);
        C0997dO c0997dO = c1092eO.l;
        if (c0997dO.g == null) {
            c0997dO.g = new Rect();
        }
        c1092eO.l.g.set(0, dimensionPixelOffset2, 0, dimensionPixelOffset2);
        c1092eO.invalidateSelf();
        return c1092eO;
    }

    public final int g(int i, boolean z) {
        return ((z || getPrefixText() == null) ? (!z || getSuffixText() == null) ? this.f30o.getCompoundPaddingLeft() : this.n.c() : this.m.a()) + i;
    }

    @Override // android.widget.LinearLayout, android.view.View
    public int getBaseline() {
        EditText editText = this.f30o;
        if (editText == null) {
            return super.getBaseline();
        }
        return c() + getPaddingTop() + editText.getBaseline();
    }

    public C1092eO getBoxBackground() {
        int i = this.c0;
        if (i == 1 || i == 2) {
            return this.Q;
        }
        throw new IllegalStateException();
    }

    public int getBoxBackgroundColor() {
        return this.i0;
    }

    public int getBoxBackgroundMode() {
        return this.c0;
    }

    public int getBoxCollapsedPaddingTop() {
        return this.d0;
    }

    public float getBoxCornerRadiusBottomEnd() {
        boolean zH = Co0.H(this);
        RectF rectF = this.l0;
        return zH ? this.W.h.a(rectF) : this.W.g.a(rectF);
    }

    public float getBoxCornerRadiusBottomStart() {
        boolean zH = Co0.H(this);
        RectF rectF = this.l0;
        return zH ? this.W.g.a(rectF) : this.W.h.a(rectF);
    }

    public float getBoxCornerRadiusTopEnd() {
        boolean zH = Co0.H(this);
        RectF rectF = this.l0;
        return zH ? this.W.e.a(rectF) : this.W.f.a(rectF);
    }

    public float getBoxCornerRadiusTopStart() {
        boolean zH = Co0.H(this);
        RectF rectF = this.l0;
        return zH ? this.W.f.a(rectF) : this.W.e.a(rectF);
    }

    public int getBoxStrokeColor() {
        return this.x0;
    }

    public ColorStateList getBoxStrokeErrorColor() {
        return this.y0;
    }

    public int getBoxStrokeWidth() {
        return this.f0;
    }

    public int getBoxStrokeWidthFocused() {
        return this.g0;
    }

    public int getCounterMaxLength() {
        return this.w;
    }

    public CharSequence getCounterOverflowDescription() {
        E8 e8;
        if (this.v && this.x && (e8 = this.z) != null) {
            return e8.getContentDescription();
        }
        return null;
    }

    public ColorStateList getCounterOverflowTextColor() {
        return this.K;
    }

    public ColorStateList getCounterTextColor() {
        return this.J;
    }

    public ColorStateList getCursorColor() {
        return this.L;
    }

    public ColorStateList getCursorErrorColor() {
        return this.M;
    }

    public ColorStateList getDefaultHintTextColor() {
        return this.t0;
    }

    public EditText getEditText() {
        return this.f30o;
    }

    public CharSequence getEndIconContentDescription() {
        return this.n.r.getContentDescription();
    }

    public Drawable getEndIconDrawable() {
        return this.n.r.getDrawable();
    }

    public int getEndIconMinSize() {
        return this.n.x;
    }

    public int getEndIconMode() {
        return this.n.t;
    }

    public ImageView.ScaleType getEndIconScaleType() {
        return this.n.y;
    }

    public CheckableImageButton getEndIconView() {
        return this.n.r;
    }

    public CharSequence getError() {
        C1181fH c1181fH = this.u;
        if (c1181fH.q) {
            return c1181fH.p;
        }
        return null;
    }

    public int getErrorAccessibilityLiveRegion() {
        return this.u.t;
    }

    public CharSequence getErrorContentDescription() {
        return this.u.s;
    }

    public int getErrorCurrentTextColors() {
        E8 e8 = this.u.r;
        if (e8 != null) {
            return e8.getCurrentTextColor();
        }
        return -1;
    }

    public Drawable getErrorIconDrawable() {
        return this.n.n.getDrawable();
    }

    public CharSequence getHelperText() {
        C1181fH c1181fH = this.u;
        if (c1181fH.x) {
            return c1181fH.w;
        }
        return null;
    }

    public int getHelperTextCurrentTextColor() {
        E8 e8 = this.u.y;
        if (e8 != null) {
            return e8.getCurrentTextColor();
        }
        return -1;
    }

    public CharSequence getHint() {
        if (this.N) {
            return this.O;
        }
        return null;
    }

    public final float getHintCollapsedTextHeight() {
        return this.G0.d();
    }

    public final int getHintCurrentCollapsedTextColor() {
        C3022yi c3022yi = this.G0;
        return c3022yi.e(c3022yi.k);
    }

    public ColorStateList getHintTextColor() {
        return this.u0;
    }

    public Ce0 getLengthCounter() {
        return this.y;
    }

    public int getMaxEms() {
        return this.r;
    }

    public int getMaxWidth() {
        return this.t;
    }

    public int getMinEms() {
        return this.q;
    }

    public int getMinWidth() {
        return this.s;
    }

    @Deprecated
    public CharSequence getPasswordVisibilityToggleContentDescription() {
        return this.n.r.getContentDescription();
    }

    @Deprecated
    public Drawable getPasswordVisibilityToggleDrawable() {
        return this.n.r.getDrawable();
    }

    public CharSequence getPlaceholderText() {
        if (this.D) {
            return this.C;
        }
        return null;
    }

    public int getPlaceholderTextAppearance() {
        return this.G;
    }

    public ColorStateList getPlaceholderTextColor() {
        return this.F;
    }

    public CharSequence getPrefixText() {
        return this.m.n;
    }

    public ColorStateList getPrefixTextColor() {
        return this.m.m.getTextColors();
    }

    public TextView getPrefixTextView() {
        return this.m.m;
    }

    public N70 getShapeAppearanceModel() {
        return this.W;
    }

    public CharSequence getStartIconContentDescription() {
        return this.m.f702o.getContentDescription();
    }

    public Drawable getStartIconDrawable() {
        return this.m.f702o.getDrawable();
    }

    public int getStartIconMinSize() {
        return this.m.r;
    }

    public ImageView.ScaleType getStartIconScaleType() {
        return this.m.s;
    }

    public CharSequence getSuffixText() {
        return this.n.A;
    }

    public ColorStateList getSuffixTextColor() {
        return this.n.B.getTextColors();
    }

    public TextView getSuffixTextView() {
        return this.n.B;
    }

    public Typeface getTypeface() {
        return this.m0;
    }

    public final int h(int i, boolean z) {
        return i - ((z || getSuffixText() == null) ? (!z || getPrefixText() == null) ? this.f30o.getCompoundPaddingRight() : this.m.a() : this.n.c());
    }

    public final void i() throws Resources.NotFoundException {
        int i = this.c0;
        if (i == 0) {
            this.Q = null;
            this.U = null;
            this.V = null;
        } else if (i == 1) {
            this.Q = new C1092eO(this.W);
            this.U = new C1092eO();
            this.V = new C1092eO();
        } else {
            if (i != 2) {
                throw new IllegalArgumentException(this.c0 + " is illegal; only @BoxBackgroundMode constants are supported.");
            }
            if (!this.N || (this.Q instanceof C0403Po)) {
                this.Q = new C1092eO(this.W);
            } else {
                N70 n70 = this.W;
                int i2 = C0403Po.J;
                if (n70 == null) {
                    n70 = new N70();
                }
                C0377Oo c0377Oo = new C0377Oo(n70, new RectF());
                C0403Po c0403Po = new C0403Po(c0377Oo);
                c0403Po.I = c0377Oo;
                this.Q = c0403Po;
            }
            this.U = null;
            this.V = null;
        }
        s();
        x();
        if (this.c0 == 1) {
            if (getContext().getResources().getConfiguration().fontScale >= 2.0f) {
                this.d0 = getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.material_font_2_0_box_collapsed_padding_top);
            } else if (AbstractC2461sm0.B(getContext())) {
                this.d0 = getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.material_font_1_3_box_collapsed_padding_top);
            }
        }
        if (this.f30o != null && this.c0 == 1) {
            if (getContext().getResources().getConfiguration().fontScale >= 2.0f) {
                EditText editText = this.f30o;
                WeakHashMap weakHashMap = Oj0.a;
                editText.setPaddingRelative(editText.getPaddingStart(), getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.material_filled_edittext_font_2_0_padding_top), this.f30o.getPaddingEnd(), getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.material_filled_edittext_font_2_0_padding_bottom));
            } else if (AbstractC2461sm0.B(getContext())) {
                EditText editText2 = this.f30o;
                WeakHashMap weakHashMap2 = Oj0.a;
                editText2.setPaddingRelative(editText2.getPaddingStart(), getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.material_filled_edittext_font_1_3_padding_top), this.f30o.getPaddingEnd(), getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.material_filled_edittext_font_1_3_padding_bottom));
            }
        }
        if (this.c0 != 0) {
            t();
        }
        EditText editText3 = this.f30o;
        if (editText3 instanceof AutoCompleteTextView) {
            AutoCompleteTextView autoCompleteTextView = (AutoCompleteTextView) editText3;
            if (autoCompleteTextView.getDropDownBackground() == null) {
                int i3 = this.c0;
                if (i3 == 2) {
                    autoCompleteTextView.setDropDownBackgroundDrawable(getOrCreateOutlinedDropDownMenuBackground());
                } else if (i3 == 1) {
                    autoCompleteTextView.setDropDownBackgroundDrawable(getOrCreateFilledDropDownMenuBackground());
                }
            }
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:44:0x008d  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void j() {
        /*
            Method dump skipped, instructions count: 241
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.textfield.TextInputLayout.j():void");
    }

    public final void l(E8 e8, int i) {
        try {
            e8.setTextAppearance(i);
            if (e8.getTextColors().getDefaultColor() != -65281) {
                return;
            }
        } catch (Exception unused) {
        }
        e8.setTextAppearance(com.google.android.gms.common.R.style.TextAppearance_AppCompat_Caption);
        e8.setTextColor(getContext().getColor(com.google.android.gms.common.R.color.design_error));
    }

    public final boolean m() {
        C1181fH c1181fH = this.u;
        return (c1181fH.f525o != 1 || c1181fH.r == null || TextUtils.isEmpty(c1181fH.p)) ? false : true;
    }

    public final void n(Editable editable) throws Resources.NotFoundException {
        ((C0387Oy) this.y).getClass();
        int length = editable != null ? editable.length() : 0;
        boolean z = this.x;
        int i = this.w;
        if (i == -1) {
            this.z.setText(String.valueOf(length));
            this.z.setContentDescription(null);
            this.x = false;
        } else {
            this.x = length > i;
            Context context = getContext();
            this.z.setContentDescription(context.getString(this.x ? com.google.android.gms.common.R.string.character_counter_overflowed_content_description : com.google.android.gms.common.R.string.character_counter_content_description, Integer.valueOf(length), Integer.valueOf(this.w)));
            if (z != this.x) {
                o();
            }
            C0211Id c0211IdC = C0211Id.c();
            E8 e8 = this.z;
            String string = getContext().getString(com.google.android.gms.common.R.string.character_counter_pattern, Integer.valueOf(length), Integer.valueOf(this.w));
            c0211IdC.getClass();
            C2160pe c2160pe = Ad0.a;
            e8.setText(string != null ? c0211IdC.d(string).toString() : null);
        }
        if (this.f30o == null || z == this.x) {
            return;
        }
        u(false, false);
        x();
        r();
    }

    public final void o() {
        ColorStateList colorStateList;
        ColorStateList colorStateList2;
        E8 e8 = this.z;
        if (e8 != null) {
            l(e8, this.x ? this.A : this.B);
            if (!this.x && (colorStateList2 = this.J) != null) {
                this.z.setTextColor(colorStateList2);
            }
            if (!this.x || (colorStateList = this.K) == null) {
                return;
            }
            this.z.setTextColor(colorStateList);
        }
    }

    @Override // android.view.View
    public final void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.G0.g(configuration);
    }

    @Override // android.view.ViewTreeObserver.OnGlobalLayoutListener
    public final void onGlobalLayout() {
        int iMax;
        C0957cw c0957cw = this.n;
        c0957cw.getViewTreeObserver().removeOnGlobalLayoutListener(this);
        boolean z = false;
        this.M0 = false;
        if (this.f30o != null && this.f30o.getMeasuredHeight() < (iMax = Math.max(c0957cw.getMeasuredHeight(), this.m.getMeasuredHeight()))) {
            this.f30o.setMinimumHeight(iMax);
            z = true;
        }
        boolean zQ = q();
        if (z || zQ) {
            this.f30o.post(new RunnableC2108p1(21, this));
        }
    }

    @Override // android.widget.LinearLayout, android.view.ViewGroup, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        EditText editText = this.f30o;
        if (editText != null) {
            ThreadLocal threadLocal = AbstractC0121Er.a;
            int width = editText.getWidth();
            int height = editText.getHeight();
            Rect rect = this.j0;
            rect.set(0, 0, width, height);
            ThreadLocal threadLocal2 = AbstractC0121Er.a;
            Matrix matrix = (Matrix) threadLocal2.get();
            if (matrix == null) {
                matrix = new Matrix();
                threadLocal2.set(matrix);
            } else {
                matrix.reset();
            }
            AbstractC0121Er.a(this, editText, matrix);
            ThreadLocal threadLocal3 = AbstractC0121Er.b;
            RectF rectF = (RectF) threadLocal3.get();
            if (rectF == null) {
                rectF = new RectF();
                threadLocal3.set(rectF);
            }
            rectF.set(rect);
            matrix.mapRect(rectF);
            rect.set((int) (rectF.left + 0.5f), (int) (rectF.top + 0.5f), (int) (rectF.right + 0.5f), (int) (rectF.bottom + 0.5f));
            C1092eO c1092eO = this.U;
            if (c1092eO != null) {
                int i5 = rect.bottom;
                c1092eO.setBounds(rect.left, i5 - this.f0, rect.right, i5);
            }
            C1092eO c1092eO2 = this.V;
            if (c1092eO2 != null) {
                int i6 = rect.bottom;
                c1092eO2.setBounds(rect.left, i6 - this.g0, rect.right, i6);
            }
            if (this.N) {
                float textSize = this.f30o.getTextSize();
                C3022yi c3022yi = this.G0;
                if (c3022yi.h != textSize) {
                    c3022yi.h = textSize;
                    c3022yi.h(false);
                }
                int gravity = this.f30o.getGravity();
                int i7 = (gravity & (-113)) | 48;
                if (c3022yi.g != i7) {
                    c3022yi.g = i7;
                    c3022yi.h(false);
                }
                if (c3022yi.f != gravity) {
                    c3022yi.f = gravity;
                    c3022yi.h(false);
                }
                if (this.f30o == null) {
                    throw new IllegalStateException();
                }
                boolean zH = Co0.H(this);
                int i8 = rect.bottom;
                Rect rect2 = this.k0;
                rect2.bottom = i8;
                int i9 = this.c0;
                if (i9 == 1) {
                    rect2.left = g(rect.left, zH);
                    rect2.top = rect.top + this.d0;
                    rect2.right = h(rect.right, zH);
                } else if (i9 != 2) {
                    rect2.left = g(rect.left, zH);
                    rect2.top = getPaddingTop();
                    rect2.right = h(rect.right, zH);
                } else {
                    rect2.left = this.f30o.getPaddingLeft() + rect.left;
                    rect2.top = rect.top - c();
                    rect2.right = rect.right - this.f30o.getPaddingRight();
                }
                int i10 = rect2.left;
                int i11 = rect2.top;
                int i12 = rect2.right;
                int i13 = rect2.bottom;
                Rect rect3 = c3022yi.d;
                if (rect3.left != i10 || rect3.top != i11 || rect3.right != i12 || rect3.bottom != i13) {
                    rect3.set(i10, i11, i12, i13);
                    c3022yi.M = true;
                }
                if (this.f30o == null) {
                    throw new IllegalStateException();
                }
                TextPaint textPaint = c3022yi.O;
                textPaint.setTextSize(c3022yi.h);
                textPaint.setTypeface(c3022yi.u);
                textPaint.setLetterSpacing(c3022yi.W);
                float f = -textPaint.ascent();
                rect2.left = this.f30o.getCompoundPaddingLeft() + rect.left;
                rect2.top = (this.c0 != 1 || this.f30o.getMinLines() > 1) ? rect.top + this.f30o.getCompoundPaddingTop() : (int) (rect.centerY() - (f / 2.0f));
                rect2.right = rect.right - this.f30o.getCompoundPaddingRight();
                int compoundPaddingBottom = (this.c0 != 1 || this.f30o.getMinLines() > 1) ? rect.bottom - this.f30o.getCompoundPaddingBottom() : (int) (rect2.top + f);
                rect2.bottom = compoundPaddingBottom;
                int i14 = rect2.left;
                int i15 = rect2.top;
                int i16 = rect2.right;
                Rect rect4 = c3022yi.c;
                if (rect4.left != i14 || rect4.top != i15 || rect4.right != i16 || rect4.bottom != compoundPaddingBottom) {
                    rect4.set(i14, i15, i16, compoundPaddingBottom);
                    c3022yi.M = true;
                }
                c3022yi.h(false);
                if (!e() || this.F0) {
                    return;
                }
                j();
            }
        }
    }

    @Override // android.widget.LinearLayout, android.view.View
    public final void onMeasure(int i, int i2) {
        EditText editText;
        super.onMeasure(i, i2);
        boolean z = this.M0;
        C0957cw c0957cw = this.n;
        if (!z) {
            c0957cw.getViewTreeObserver().addOnGlobalLayoutListener(this);
            this.M0 = true;
        }
        if (this.E != null && (editText = this.f30o) != null) {
            this.E.setGravity(editText.getGravity());
            this.E.setPadding(this.f30o.getCompoundPaddingLeft(), this.f30o.getCompoundPaddingTop(), this.f30o.getCompoundPaddingRight(), this.f30o.getCompoundPaddingBottom());
        }
        c0957cw.m();
    }

    @Override // android.view.View
    public final void onRestoreInstanceState(Parcelable parcelable) throws Resources.NotFoundException {
        if (!(parcelable instanceof De0)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        De0 de0 = (De0) parcelable;
        super.onRestoreInstanceState(de0.l);
        setError(de0.n);
        if (de0.f80o) {
            post(new RunnableC2017o3(18, this));
        }
        requestLayout();
    }

    @Override // android.widget.LinearLayout, android.view.View
    public final void onRtlPropertiesChanged(int i) {
        super.onRtlPropertiesChanged(i);
        boolean z = i == 1;
        if (z != this.a0) {
            InterfaceC2273qn interfaceC2273qn = this.W.e;
            RectF rectF = this.l0;
            float fA = interfaceC2273qn.a(rectF);
            float fA2 = this.W.f.a(rectF);
            float fA3 = this.W.h.a(rectF);
            float fA4 = this.W.g.a(rectF);
            N70 n70 = this.W;
            AbstractC0752ap abstractC0752ap = n70.a;
            AbstractC0752ap abstractC0752ap2 = n70.b;
            AbstractC0752ap abstractC0752ap3 = n70.d;
            AbstractC0752ap abstractC0752ap4 = n70.c;
            C0669Zu c0669Zu = new C0669Zu(0);
            C0669Zu c0669Zu2 = new C0669Zu(0);
            C0669Zu c0669Zu3 = new C0669Zu(0);
            C0669Zu c0669Zu4 = new C0669Zu(0);
            C1915n c1915n = new C1915n(fA2);
            C1915n c1915n2 = new C1915n(fA);
            C1915n c1915n3 = new C1915n(fA4);
            C1915n c1915n4 = new C1915n(fA3);
            N70 n702 = new N70();
            n702.a = abstractC0752ap2;
            n702.b = abstractC0752ap;
            n702.c = abstractC0752ap3;
            n702.d = abstractC0752ap4;
            n702.e = c1915n;
            n702.f = c1915n2;
            n702.g = c1915n4;
            n702.h = c1915n3;
            n702.i = c0669Zu;
            n702.j = c0669Zu2;
            n702.k = c0669Zu3;
            n702.l = c0669Zu4;
            this.a0 = z;
            setShapeAppearanceModel(n702);
        }
    }

    @Override // android.view.View
    public final Parcelable onSaveInstanceState() {
        De0 de0 = new De0(super.onSaveInstanceState());
        if (m()) {
            de0.n = getError();
        }
        C0957cw c0957cw = this.n;
        de0.f80o = c0957cw.t != 0 && c0957cw.r.f28o;
        return de0;
    }

    /* JADX WARN: Removed duplicated region for block: B:7:0x0013  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void p() throws android.content.res.Resources.NotFoundException {
        /*
            r4 = this;
            android.content.res.ColorStateList r0 = r4.L
            if (r0 == 0) goto L5
            goto L26
        L5:
            android.content.Context r0 = r4.getContext()
            r1 = 2130903289(0x7f0300f9, float:1.7413392E38)
            android.util.TypedValue r1 = o.C80.T(r0, r1)
            r2 = 0
            if (r1 != 0) goto L15
        L13:
            r0 = r2
            goto L26
        L15:
            int r3 = r1.resourceId
            if (r3 == 0) goto L1e
            android.content.res.ColorStateList r0 = o.Co0.z(r0, r3)
            goto L26
        L1e:
            int r0 = r1.data
            if (r0 == 0) goto L13
            android.content.res.ColorStateList r0 = android.content.res.ColorStateList.valueOf(r0)
        L26:
            android.widget.EditText r1 = r4.f30o
            if (r1 == 0) goto L51
            android.graphics.drawable.Drawable r1 = o.KH.g(r1)
            if (r1 != 0) goto L31
            goto L51
        L31:
            android.widget.EditText r1 = r4.f30o
            android.graphics.drawable.Drawable r1 = o.KH.g(r1)
            android.graphics.drawable.Drawable r1 = r1.mutate()
            boolean r2 = r4.m()
            if (r2 != 0) goto L49
            o.E8 r2 = r4.z
            if (r2 == 0) goto L4e
            boolean r2 = r4.x
            if (r2 == 0) goto L4e
        L49:
            android.content.res.ColorStateList r2 = r4.M
            if (r2 == 0) goto L4e
            r0 = r2
        L4e:
            r1.setTintList(r0)
        L51:
            return
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.textfield.TextInputLayout.p():void");
    }

    /* JADX WARN: Removed duplicated region for block: B:21:0x005f  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean q() {
        /*
            Method dump skipped, instructions count: 304
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.textfield.TextInputLayout.q():boolean");
    }

    public final void r() {
        Drawable background;
        E8 e8;
        EditText editText = this.f30o;
        if (editText == null || this.c0 != 0 || (background = editText.getBackground()) == null) {
            return;
        }
        int[] iArr = AbstractC2949xt.a;
        Drawable drawableMutate = background.mutate();
        if (m()) {
            drawableMutate.setColorFilter(V7.c(getErrorCurrentTextColors(), PorterDuff.Mode.SRC_IN));
        } else if (this.x && (e8 = this.z) != null) {
            drawableMutate.setColorFilter(V7.c(e8.getCurrentTextColor(), PorterDuff.Mode.SRC_IN));
        } else {
            drawableMutate.clearColorFilter();
            this.f30o.refreshDrawableState();
        }
    }

    public final void s() {
        EditText editText = this.f30o;
        if (editText == null || this.Q == null) {
            return;
        }
        if ((this.T || editText.getBackground() == null) && this.c0 != 0) {
            Drawable editTextBoxBackground = getEditTextBoxBackground();
            EditText editText2 = this.f30o;
            WeakHashMap weakHashMap = Oj0.a;
            editText2.setBackground(editTextBoxBackground);
            this.T = true;
        }
    }

    public void setBoxBackgroundColor(int i) {
        if (this.i0 != i) {
            this.i0 = i;
            this.z0 = i;
            this.B0 = i;
            this.C0 = i;
            b();
        }
    }

    public void setBoxBackgroundColorResource(int i) {
        setBoxBackgroundColor(getContext().getColor(i));
    }

    public void setBoxBackgroundColorStateList(ColorStateList colorStateList) {
        int defaultColor = colorStateList.getDefaultColor();
        this.z0 = defaultColor;
        this.i0 = defaultColor;
        this.A0 = colorStateList.getColorForState(new int[]{-16842910}, -1);
        this.B0 = colorStateList.getColorForState(new int[]{R.attr.state_focused, R.attr.state_enabled}, -1);
        this.C0 = colorStateList.getColorForState(new int[]{R.attr.state_hovered, R.attr.state_enabled}, -1);
        b();
    }

    public void setBoxBackgroundMode(int i) throws Resources.NotFoundException {
        if (i == this.c0) {
            return;
        }
        this.c0 = i;
        if (this.f30o != null) {
            i();
        }
    }

    public void setBoxCollapsedPaddingTop(int i) {
        this.d0 = i;
    }

    public void setBoxCornerFamily(int i) {
        M70 m70E = this.W.e();
        InterfaceC2273qn interfaceC2273qn = this.W.e;
        m70E.a = AbstractC2841wm0.o(i);
        m70E.e = interfaceC2273qn;
        InterfaceC2273qn interfaceC2273qn2 = this.W.f;
        m70E.b = AbstractC2841wm0.o(i);
        m70E.f = interfaceC2273qn2;
        InterfaceC2273qn interfaceC2273qn3 = this.W.h;
        m70E.d = AbstractC2841wm0.o(i);
        m70E.h = interfaceC2273qn3;
        InterfaceC2273qn interfaceC2273qn4 = this.W.g;
        m70E.c = AbstractC2841wm0.o(i);
        m70E.g = interfaceC2273qn4;
        this.W = m70E.a();
        b();
    }

    public void setBoxStrokeColor(int i) throws Resources.NotFoundException {
        if (this.x0 != i) {
            this.x0 = i;
            x();
        }
    }

    public void setBoxStrokeColorStateList(ColorStateList colorStateList) throws Resources.NotFoundException {
        if (colorStateList.isStateful()) {
            this.v0 = colorStateList.getDefaultColor();
            this.D0 = colorStateList.getColorForState(new int[]{-16842910}, -1);
            this.w0 = colorStateList.getColorForState(new int[]{R.attr.state_hovered, R.attr.state_enabled}, -1);
            this.x0 = colorStateList.getColorForState(new int[]{R.attr.state_focused, R.attr.state_enabled}, -1);
        } else if (this.x0 != colorStateList.getDefaultColor()) {
            this.x0 = colorStateList.getDefaultColor();
        }
        x();
    }

    public void setBoxStrokeErrorColor(ColorStateList colorStateList) throws Resources.NotFoundException {
        if (this.y0 != colorStateList) {
            this.y0 = colorStateList;
            x();
        }
    }

    public void setBoxStrokeWidth(int i) throws Resources.NotFoundException {
        this.f0 = i;
        x();
    }

    public void setBoxStrokeWidthFocused(int i) throws Resources.NotFoundException {
        this.g0 = i;
        x();
    }

    public void setBoxStrokeWidthFocusedResource(int i) throws Resources.NotFoundException {
        setBoxStrokeWidthFocused(getResources().getDimensionPixelSize(i));
    }

    public void setBoxStrokeWidthResource(int i) throws Resources.NotFoundException {
        setBoxStrokeWidth(getResources().getDimensionPixelSize(i));
    }

    public void setCounterEnabled(boolean z) throws Resources.NotFoundException {
        if (this.v != z) {
            C1181fH c1181fH = this.u;
            if (z) {
                E8 e8 = new E8(getContext(), null);
                this.z = e8;
                e8.setId(com.google.android.gms.common.R.id.textinput_counter);
                Typeface typeface = this.m0;
                if (typeface != null) {
                    this.z.setTypeface(typeface);
                }
                this.z.setMaxLines(1);
                c1181fH.a(this.z, 2);
                ((ViewGroup.MarginLayoutParams) this.z.getLayoutParams()).setMarginStart(getResources().getDimensionPixelOffset(com.google.android.gms.common.R.dimen.mtrl_textinput_counter_margin_start));
                o();
                if (this.z != null) {
                    EditText editText = this.f30o;
                    n(editText != null ? editText.getText() : null);
                }
            } else {
                c1181fH.g(this.z, 2);
                this.z = null;
            }
            this.v = z;
        }
    }

    public void setCounterMaxLength(int i) throws Resources.NotFoundException {
        if (this.w != i) {
            if (i > 0) {
                this.w = i;
            } else {
                this.w = -1;
            }
            if (!this.v || this.z == null) {
                return;
            }
            EditText editText = this.f30o;
            n(editText == null ? null : editText.getText());
        }
    }

    public void setCounterOverflowTextAppearance(int i) {
        if (this.A != i) {
            this.A = i;
            o();
        }
    }

    public void setCounterOverflowTextColor(ColorStateList colorStateList) {
        if (this.K != colorStateList) {
            this.K = colorStateList;
            o();
        }
    }

    public void setCounterTextAppearance(int i) {
        if (this.B != i) {
            this.B = i;
            o();
        }
    }

    public void setCounterTextColor(ColorStateList colorStateList) {
        if (this.J != colorStateList) {
            this.J = colorStateList;
            o();
        }
    }

    public void setCursorColor(ColorStateList colorStateList) throws Resources.NotFoundException {
        if (this.L != colorStateList) {
            this.L = colorStateList;
            p();
        }
    }

    public void setCursorErrorColor(ColorStateList colorStateList) throws Resources.NotFoundException {
        if (this.M != colorStateList) {
            this.M = colorStateList;
            if (m() || (this.z != null && this.x)) {
                p();
            }
        }
    }

    public void setDefaultHintTextColor(ColorStateList colorStateList) {
        this.t0 = colorStateList;
        this.u0 = colorStateList;
        if (this.f30o != null) {
            u(false, false);
        }
    }

    @Override // android.view.View
    public void setEnabled(boolean z) {
        k(this, z);
        super.setEnabled(z);
    }

    public void setEndIconActivated(boolean z) {
        this.n.r.setActivated(z);
    }

    public void setEndIconCheckable(boolean z) {
        this.n.r.setCheckable(z);
    }

    public void setEndIconContentDescription(int i) {
        C0957cw c0957cw = this.n;
        CharSequence text = i != 0 ? c0957cw.getResources().getText(i) : null;
        CheckableImageButton checkableImageButton = c0957cw.r;
        if (checkableImageButton.getContentDescription() != text) {
            checkableImageButton.setContentDescription(text);
        }
    }

    public void setEndIconDrawable(int i) {
        C0957cw c0957cw = this.n;
        Drawable drawableX = i != 0 ? C80.x(c0957cw.getContext(), i) : null;
        TextInputLayout textInputLayout = c0957cw.l;
        CheckableImageButton checkableImageButton = c0957cw.r;
        checkableImageButton.setImageDrawable(drawableX);
        if (drawableX != null) {
            IJ.b(textInputLayout, checkableImageButton, c0957cw.v, c0957cw.w);
            IJ.C(textInputLayout, checkableImageButton, c0957cw.v);
        }
    }

    public void setEndIconMinSize(int i) {
        C0957cw c0957cw = this.n;
        if (i < 0) {
            c0957cw.getClass();
            throw new IllegalArgumentException("endIconSize cannot be less than 0");
        }
        if (i != c0957cw.x) {
            c0957cw.x = i;
            CheckableImageButton checkableImageButton = c0957cw.r;
            checkableImageButton.setMinimumWidth(i);
            checkableImageButton.setMinimumHeight(i);
            CheckableImageButton checkableImageButton2 = c0957cw.n;
            checkableImageButton2.setMinimumWidth(i);
            checkableImageButton2.setMinimumHeight(i);
        }
    }

    public void setEndIconMode(int i) {
        this.n.g(i);
    }

    public void setEndIconOnClickListener(View.OnClickListener onClickListener) {
        C0957cw c0957cw = this.n;
        CheckableImageButton checkableImageButton = c0957cw.r;
        View.OnLongClickListener onLongClickListener = c0957cw.z;
        checkableImageButton.setOnClickListener(onClickListener);
        IJ.F(checkableImageButton, onLongClickListener);
    }

    public void setEndIconOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        C0957cw c0957cw = this.n;
        c0957cw.z = onLongClickListener;
        CheckableImageButton checkableImageButton = c0957cw.r;
        checkableImageButton.setOnLongClickListener(onLongClickListener);
        IJ.F(checkableImageButton, onLongClickListener);
    }

    public void setEndIconScaleType(ImageView.ScaleType scaleType) {
        C0957cw c0957cw = this.n;
        c0957cw.y = scaleType;
        c0957cw.r.setScaleType(scaleType);
        c0957cw.n.setScaleType(scaleType);
    }

    public void setEndIconTintList(ColorStateList colorStateList) {
        C0957cw c0957cw = this.n;
        if (c0957cw.v != colorStateList) {
            c0957cw.v = colorStateList;
            IJ.b(c0957cw.l, c0957cw.r, colorStateList, c0957cw.w);
        }
    }

    public void setEndIconTintMode(PorterDuff.Mode mode) {
        C0957cw c0957cw = this.n;
        if (c0957cw.w != mode) {
            c0957cw.w = mode;
            IJ.b(c0957cw.l, c0957cw.r, c0957cw.v, mode);
        }
    }

    public void setEndIconVisible(boolean z) {
        this.n.h(z);
    }

    public void setError(CharSequence charSequence) throws Resources.NotFoundException {
        C1181fH c1181fH = this.u;
        if (!c1181fH.q) {
            if (TextUtils.isEmpty(charSequence)) {
                return;
            } else {
                setErrorEnabled(true);
            }
        }
        if (TextUtils.isEmpty(charSequence)) {
            c1181fH.f();
            return;
        }
        c1181fH.c();
        c1181fH.p = charSequence;
        c1181fH.r.setText(charSequence);
        int i = c1181fH.n;
        if (i != 1) {
            c1181fH.f525o = 1;
        }
        c1181fH.i(i, c1181fH.h(c1181fH.r, charSequence), c1181fH.f525o);
    }

    public void setErrorAccessibilityLiveRegion(int i) {
        C1181fH c1181fH = this.u;
        c1181fH.t = i;
        E8 e8 = c1181fH.r;
        if (e8 != null) {
            WeakHashMap weakHashMap = Oj0.a;
            e8.setAccessibilityLiveRegion(i);
        }
    }

    public void setErrorContentDescription(CharSequence charSequence) {
        C1181fH c1181fH = this.u;
        c1181fH.s = charSequence;
        E8 e8 = c1181fH.r;
        if (e8 != null) {
            e8.setContentDescription(charSequence);
        }
    }

    public void setErrorEnabled(boolean z) throws Resources.NotFoundException {
        C1181fH c1181fH = this.u;
        TextInputLayout textInputLayout = c1181fH.h;
        if (c1181fH.q == z) {
            return;
        }
        c1181fH.c();
        if (z) {
            E8 e8 = new E8(c1181fH.g, null);
            c1181fH.r = e8;
            e8.setId(com.google.android.gms.common.R.id.textinput_error);
            c1181fH.r.setTextAlignment(5);
            Typeface typeface = c1181fH.B;
            if (typeface != null) {
                c1181fH.r.setTypeface(typeface);
            }
            int i = c1181fH.u;
            c1181fH.u = i;
            E8 e82 = c1181fH.r;
            if (e82 != null) {
                c1181fH.h.l(e82, i);
            }
            ColorStateList colorStateList = c1181fH.v;
            c1181fH.v = colorStateList;
            E8 e83 = c1181fH.r;
            if (e83 != null && colorStateList != null) {
                e83.setTextColor(colorStateList);
            }
            CharSequence charSequence = c1181fH.s;
            c1181fH.s = charSequence;
            E8 e84 = c1181fH.r;
            if (e84 != null) {
                e84.setContentDescription(charSequence);
            }
            int i2 = c1181fH.t;
            c1181fH.t = i2;
            E8 e85 = c1181fH.r;
            if (e85 != null) {
                WeakHashMap weakHashMap = Oj0.a;
                e85.setAccessibilityLiveRegion(i2);
            }
            c1181fH.r.setVisibility(4);
            c1181fH.a(c1181fH.r, 0);
        } else {
            c1181fH.f();
            c1181fH.g(c1181fH.r, 0);
            c1181fH.r = null;
            textInputLayout.r();
            textInputLayout.x();
        }
        c1181fH.q = z;
    }

    public void setErrorIconDrawable(int i) {
        C0957cw c0957cw = this.n;
        c0957cw.i(i != 0 ? C80.x(c0957cw.getContext(), i) : null);
        IJ.C(c0957cw.l, c0957cw.n, c0957cw.f482o);
    }

    public void setErrorIconOnClickListener(View.OnClickListener onClickListener) {
        C0957cw c0957cw = this.n;
        CheckableImageButton checkableImageButton = c0957cw.n;
        View.OnLongClickListener onLongClickListener = c0957cw.q;
        checkableImageButton.setOnClickListener(onClickListener);
        IJ.F(checkableImageButton, onLongClickListener);
    }

    public void setErrorIconOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        C0957cw c0957cw = this.n;
        c0957cw.q = onLongClickListener;
        CheckableImageButton checkableImageButton = c0957cw.n;
        checkableImageButton.setOnLongClickListener(onLongClickListener);
        IJ.F(checkableImageButton, onLongClickListener);
    }

    public void setErrorIconTintList(ColorStateList colorStateList) {
        C0957cw c0957cw = this.n;
        if (c0957cw.f482o != colorStateList) {
            c0957cw.f482o = colorStateList;
            IJ.b(c0957cw.l, c0957cw.n, colorStateList, c0957cw.p);
        }
    }

    public void setErrorIconTintMode(PorterDuff.Mode mode) {
        C0957cw c0957cw = this.n;
        if (c0957cw.p != mode) {
            c0957cw.p = mode;
            IJ.b(c0957cw.l, c0957cw.n, c0957cw.f482o, mode);
        }
    }

    public void setErrorTextAppearance(int i) {
        C1181fH c1181fH = this.u;
        c1181fH.u = i;
        E8 e8 = c1181fH.r;
        if (e8 != null) {
            c1181fH.h.l(e8, i);
        }
    }

    public void setErrorTextColor(ColorStateList colorStateList) {
        C1181fH c1181fH = this.u;
        c1181fH.v = colorStateList;
        E8 e8 = c1181fH.r;
        if (e8 == null || colorStateList == null) {
            return;
        }
        e8.setTextColor(colorStateList);
    }

    public void setExpandedHintEnabled(boolean z) {
        if (this.H0 != z) {
            this.H0 = z;
            u(false, false);
        }
    }

    public void setHelperText(CharSequence charSequence) throws Resources.NotFoundException {
        boolean zIsEmpty = TextUtils.isEmpty(charSequence);
        C1181fH c1181fH = this.u;
        if (zIsEmpty) {
            if (c1181fH.x) {
                setHelperTextEnabled(false);
                return;
            }
            return;
        }
        if (!c1181fH.x) {
            setHelperTextEnabled(true);
        }
        c1181fH.c();
        c1181fH.w = charSequence;
        c1181fH.y.setText(charSequence);
        int i = c1181fH.n;
        if (i != 2) {
            c1181fH.f525o = 2;
        }
        c1181fH.i(i, c1181fH.h(c1181fH.y, charSequence), c1181fH.f525o);
    }

    public void setHelperTextColor(ColorStateList colorStateList) {
        C1181fH c1181fH = this.u;
        c1181fH.A = colorStateList;
        E8 e8 = c1181fH.y;
        if (e8 == null || colorStateList == null) {
            return;
        }
        e8.setTextColor(colorStateList);
    }

    public void setHelperTextEnabled(boolean z) throws Resources.NotFoundException {
        C1181fH c1181fH = this.u;
        TextInputLayout textInputLayout = c1181fH.h;
        if (c1181fH.x == z) {
            return;
        }
        c1181fH.c();
        if (z) {
            E8 e8 = new E8(c1181fH.g, null);
            c1181fH.y = e8;
            e8.setId(com.google.android.gms.common.R.id.textinput_helper_text);
            c1181fH.y.setTextAlignment(5);
            Typeface typeface = c1181fH.B;
            if (typeface != null) {
                c1181fH.y.setTypeface(typeface);
            }
            c1181fH.y.setVisibility(4);
            c1181fH.y.setAccessibilityLiveRegion(1);
            int i = c1181fH.z;
            c1181fH.z = i;
            E8 e82 = c1181fH.y;
            if (e82 != null) {
                e82.setTextAppearance(i);
            }
            ColorStateList colorStateList = c1181fH.A;
            c1181fH.A = colorStateList;
            E8 e83 = c1181fH.y;
            if (e83 != null && colorStateList != null) {
                e83.setTextColor(colorStateList);
            }
            c1181fH.a(c1181fH.y, 1);
            c1181fH.y.setAccessibilityDelegate(new C1085eH(c1181fH));
        } else {
            c1181fH.c();
            int i2 = c1181fH.n;
            if (i2 == 2) {
                c1181fH.f525o = 0;
            }
            c1181fH.i(i2, c1181fH.h(c1181fH.y, ""), c1181fH.f525o);
            c1181fH.g(c1181fH.y, 1);
            c1181fH.y = null;
            textInputLayout.r();
            textInputLayout.x();
        }
        c1181fH.x = z;
    }

    public void setHelperTextTextAppearance(int i) {
        C1181fH c1181fH = this.u;
        c1181fH.z = i;
        E8 e8 = c1181fH.y;
        if (e8 != null) {
            e8.setTextAppearance(i);
        }
    }

    public void setHint(CharSequence charSequence) {
        if (this.N) {
            setHintInternal(charSequence);
            sendAccessibilityEvent(2048);
        }
    }

    public void setHintAnimationEnabled(boolean z) {
        this.I0 = z;
    }

    public void setHintEnabled(boolean z) {
        if (z != this.N) {
            this.N = z;
            if (z) {
                CharSequence hint = this.f30o.getHint();
                if (!TextUtils.isEmpty(hint)) {
                    if (TextUtils.isEmpty(this.O)) {
                        setHint(hint);
                    }
                    this.f30o.setHint((CharSequence) null);
                }
                this.P = true;
            } else {
                this.P = false;
                if (!TextUtils.isEmpty(this.O) && TextUtils.isEmpty(this.f30o.getHint())) {
                    this.f30o.setHint(this.O);
                }
                setHintInternal(null);
            }
            if (this.f30o != null) {
                t();
            }
        }
    }

    public void setHintTextAppearance(int i) {
        C3022yi c3022yi = this.G0;
        TextInputLayout textInputLayout = c3022yi.a;
        C1016dd0 c1016dd0 = new C1016dd0(textInputLayout.getContext(), i);
        ColorStateList colorStateList = c1016dd0.j;
        if (colorStateList != null) {
            c3022yi.k = colorStateList;
        }
        float f = c1016dd0.k;
        if (f != 0.0f) {
            c3022yi.i = f;
        }
        ColorStateList colorStateList2 = c1016dd0.a;
        if (colorStateList2 != null) {
            c3022yi.U = colorStateList2;
        }
        c3022yi.S = c1016dd0.e;
        c3022yi.T = c1016dd0.f;
        c3022yi.R = c1016dd0.g;
        c3022yi.V = c1016dd0.i;
        C2164pg c2164pg = c3022yi.y;
        if (c2164pg != null) {
            c2164pg.z = true;
        }
        OD od = new OD(23, c3022yi);
        c1016dd0.a();
        c3022yi.y = new C2164pg(od, c1016dd0.n);
        c1016dd0.c(textInputLayout.getContext(), c3022yi.y);
        c3022yi.h(false);
        this.u0 = c3022yi.k;
        if (this.f30o != null) {
            u(false, false);
            t();
        }
    }

    public void setHintTextColor(ColorStateList colorStateList) {
        if (this.u0 != colorStateList) {
            if (this.t0 == null) {
                C3022yi c3022yi = this.G0;
                if (c3022yi.k != colorStateList) {
                    c3022yi.k = colorStateList;
                    c3022yi.h(false);
                }
            }
            this.u0 = colorStateList;
            if (this.f30o != null) {
                u(false, false);
            }
        }
    }

    public void setLengthCounter(Ce0 ce0) {
        this.y = ce0;
    }

    public void setMaxEms(int i) {
        this.r = i;
        EditText editText = this.f30o;
        if (editText == null || i == -1) {
            return;
        }
        editText.setMaxEms(i);
    }

    public void setMaxWidth(int i) {
        this.t = i;
        EditText editText = this.f30o;
        if (editText == null || i == -1) {
            return;
        }
        editText.setMaxWidth(i);
    }

    public void setMaxWidthResource(int i) {
        setMaxWidth(getContext().getResources().getDimensionPixelSize(i));
    }

    public void setMinEms(int i) {
        this.q = i;
        EditText editText = this.f30o;
        if (editText == null || i == -1) {
            return;
        }
        editText.setMinEms(i);
    }

    public void setMinWidth(int i) {
        this.s = i;
        EditText editText = this.f30o;
        if (editText == null || i == -1) {
            return;
        }
        editText.setMinWidth(i);
    }

    public void setMinWidthResource(int i) {
        setMinWidth(getContext().getResources().getDimensionPixelSize(i));
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(int i) {
        C0957cw c0957cw = this.n;
        c0957cw.r.setContentDescription(i != 0 ? c0957cw.getResources().getText(i) : null);
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(int i) {
        C0957cw c0957cw = this.n;
        c0957cw.r.setImageDrawable(i != 0 ? C80.x(c0957cw.getContext(), i) : null);
    }

    @Deprecated
    public void setPasswordVisibilityToggleEnabled(boolean z) {
        C0957cw c0957cw = this.n;
        if (z && c0957cw.t != 1) {
            c0957cw.g(1);
        } else if (z) {
            c0957cw.getClass();
        } else {
            c0957cw.g(0);
        }
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintList(ColorStateList colorStateList) {
        C0957cw c0957cw = this.n;
        c0957cw.v = colorStateList;
        IJ.b(c0957cw.l, c0957cw.r, colorStateList, c0957cw.w);
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintMode(PorterDuff.Mode mode) {
        C0957cw c0957cw = this.n;
        c0957cw.w = mode;
        IJ.b(c0957cw.l, c0957cw.r, c0957cw.v, mode);
    }

    public void setPlaceholderText(CharSequence charSequence) {
        if (this.E == null) {
            E8 e8 = new E8(getContext(), null);
            this.E = e8;
            e8.setId(com.google.android.gms.common.R.id.textinput_placeholder);
            this.E.setImportantForAccessibility(2);
            C0023Ax c0023AxD = d();
            this.H = c0023AxD;
            c0023AxD.m = 67L;
            this.I = d();
            setPlaceholderTextAppearance(this.G);
            setPlaceholderTextColor(this.F);
        }
        if (TextUtils.isEmpty(charSequence)) {
            setPlaceholderTextEnabled(false);
        } else {
            if (!this.D) {
                setPlaceholderTextEnabled(true);
            }
            this.C = charSequence;
        }
        EditText editText = this.f30o;
        v(editText != null ? editText.getText() : null);
    }

    public void setPlaceholderTextAppearance(int i) {
        this.G = i;
        E8 e8 = this.E;
        if (e8 != null) {
            e8.setTextAppearance(i);
        }
    }

    public void setPlaceholderTextColor(ColorStateList colorStateList) {
        if (this.F != colorStateList) {
            this.F = colorStateList;
            E8 e8 = this.E;
            if (e8 == null || colorStateList == null) {
                return;
            }
            e8.setTextColor(colorStateList);
        }
    }

    public void setPrefixText(CharSequence charSequence) {
        C2342ra0 c2342ra0 = this.m;
        c2342ra0.getClass();
        c2342ra0.n = TextUtils.isEmpty(charSequence) ? null : charSequence;
        c2342ra0.m.setText(charSequence);
        c2342ra0.e();
    }

    public void setPrefixTextAppearance(int i) {
        this.m.m.setTextAppearance(i);
    }

    public void setPrefixTextColor(ColorStateList colorStateList) {
        this.m.m.setTextColor(colorStateList);
    }

    public void setShapeAppearanceModel(N70 n70) {
        C1092eO c1092eO = this.Q;
        if (c1092eO == null || c1092eO.l.a == n70) {
            return;
        }
        this.W = n70;
        b();
    }

    public void setStartIconCheckable(boolean z) {
        this.m.f702o.setCheckable(z);
    }

    public void setStartIconContentDescription(int i) {
        setStartIconContentDescription(i != 0 ? getResources().getText(i) : null);
    }

    public void setStartIconDrawable(int i) {
        setStartIconDrawable(i != 0 ? C80.x(getContext(), i) : null);
    }

    public void setStartIconMinSize(int i) {
        C2342ra0 c2342ra0 = this.m;
        if (i < 0) {
            c2342ra0.getClass();
            throw new IllegalArgumentException("startIconSize cannot be less than 0");
        }
        if (i != c2342ra0.r) {
            c2342ra0.r = i;
            CheckableImageButton checkableImageButton = c2342ra0.f702o;
            checkableImageButton.setMinimumWidth(i);
            checkableImageButton.setMinimumHeight(i);
        }
    }

    public void setStartIconOnClickListener(View.OnClickListener onClickListener) {
        C2342ra0 c2342ra0 = this.m;
        CheckableImageButton checkableImageButton = c2342ra0.f702o;
        View.OnLongClickListener onLongClickListener = c2342ra0.t;
        checkableImageButton.setOnClickListener(onClickListener);
        IJ.F(checkableImageButton, onLongClickListener);
    }

    public void setStartIconOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        C2342ra0 c2342ra0 = this.m;
        c2342ra0.t = onLongClickListener;
        CheckableImageButton checkableImageButton = c2342ra0.f702o;
        checkableImageButton.setOnLongClickListener(onLongClickListener);
        IJ.F(checkableImageButton, onLongClickListener);
    }

    public void setStartIconScaleType(ImageView.ScaleType scaleType) {
        C2342ra0 c2342ra0 = this.m;
        c2342ra0.s = scaleType;
        c2342ra0.f702o.setScaleType(scaleType);
    }

    public void setStartIconTintList(ColorStateList colorStateList) {
        C2342ra0 c2342ra0 = this.m;
        if (c2342ra0.p != colorStateList) {
            c2342ra0.p = colorStateList;
            IJ.b(c2342ra0.l, c2342ra0.f702o, colorStateList, c2342ra0.q);
        }
    }

    public void setStartIconTintMode(PorterDuff.Mode mode) {
        C2342ra0 c2342ra0 = this.m;
        if (c2342ra0.q != mode) {
            c2342ra0.q = mode;
            IJ.b(c2342ra0.l, c2342ra0.f702o, c2342ra0.p, mode);
        }
    }

    public void setStartIconVisible(boolean z) {
        this.m.c(z);
    }

    public void setSuffixText(CharSequence charSequence) {
        C0957cw c0957cw = this.n;
        c0957cw.getClass();
        c0957cw.A = TextUtils.isEmpty(charSequence) ? null : charSequence;
        c0957cw.B.setText(charSequence);
        c0957cw.n();
    }

    public void setSuffixTextAppearance(int i) {
        this.n.B.setTextAppearance(i);
    }

    public void setSuffixTextColor(ColorStateList colorStateList) {
        this.n.B.setTextColor(colorStateList);
    }

    public void setTextInputAccessibilityDelegate(Be0 be0) {
        EditText editText = this.f30o;
        if (editText != null) {
            Oj0.m(editText, be0);
        }
    }

    public void setTypeface(Typeface typeface) {
        if (typeface != this.m0) {
            this.m0 = typeface;
            this.G0.m(typeface);
            C1181fH c1181fH = this.u;
            if (typeface != c1181fH.B) {
                c1181fH.B = typeface;
                E8 e8 = c1181fH.r;
                if (e8 != null) {
                    e8.setTypeface(typeface);
                }
                E8 e82 = c1181fH.y;
                if (e82 != null) {
                    e82.setTypeface(typeface);
                }
            }
            E8 e83 = this.z;
            if (e83 != null) {
                e83.setTypeface(typeface);
            }
        }
    }

    public final void t() {
        if (this.c0 != 1) {
            FrameLayout frameLayout = this.l;
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) frameLayout.getLayoutParams();
            int iC = c();
            if (iC != layoutParams.topMargin) {
                layoutParams.topMargin = iC;
                frameLayout.requestLayout();
            }
        }
    }

    public final void u(boolean z, boolean z2) {
        ColorStateList colorStateList;
        E8 e8;
        boolean zIsEnabled = isEnabled();
        EditText editText = this.f30o;
        boolean z3 = (editText == null || TextUtils.isEmpty(editText.getText())) ? false : true;
        EditText editText2 = this.f30o;
        boolean z4 = editText2 != null && editText2.hasFocus();
        ColorStateList colorStateList2 = this.t0;
        C3022yi c3022yi = this.G0;
        if (colorStateList2 != null) {
            c3022yi.i(colorStateList2);
        }
        if (!zIsEnabled) {
            ColorStateList colorStateList3 = this.t0;
            c3022yi.i(ColorStateList.valueOf(colorStateList3 != null ? colorStateList3.getColorForState(new int[]{-16842910}, this.D0) : this.D0));
        } else if (m()) {
            E8 e82 = this.u.r;
            c3022yi.i(e82 != null ? e82.getTextColors() : null);
        } else if (this.x && (e8 = this.z) != null) {
            c3022yi.i(e8.getTextColors());
        } else if (z4 && (colorStateList = this.u0) != null && c3022yi.k != colorStateList) {
            c3022yi.k = colorStateList;
            c3022yi.h(false);
        }
        C0957cw c0957cw = this.n;
        C2342ra0 c2342ra0 = this.m;
        if (z3 || !this.H0 || (isEnabled() && z4)) {
            if (z2 || this.F0) {
                ValueAnimator valueAnimator = this.J0;
                if (valueAnimator != null && valueAnimator.isRunning()) {
                    this.J0.cancel();
                }
                if (z && this.I0) {
                    a(1.0f);
                } else {
                    c3022yi.k(1.0f);
                }
                this.F0 = false;
                if (e()) {
                    j();
                }
                EditText editText3 = this.f30o;
                v(editText3 != null ? editText3.getText() : null);
                c2342ra0.u = false;
                c2342ra0.e();
                c0957cw.C = false;
                c0957cw.n();
                return;
            }
            return;
        }
        if (z2 || !this.F0) {
            ValueAnimator valueAnimator2 = this.J0;
            if (valueAnimator2 != null && valueAnimator2.isRunning()) {
                this.J0.cancel();
            }
            if (z && this.I0) {
                a(0.0f);
            } else {
                c3022yi.k(0.0f);
            }
            if (e() && !((C0403Po) this.Q).I.q.isEmpty() && e()) {
                ((C0403Po) this.Q).n(0.0f, 0.0f, 0.0f, 0.0f);
            }
            this.F0 = true;
            E8 e83 = this.E;
            if (e83 != null && this.D) {
                e83.setText((CharSequence) null);
                Ig0.a(this.l, this.I);
                this.E.setVisibility(4);
            }
            c2342ra0.u = true;
            c2342ra0.e();
            c0957cw.C = true;
            c0957cw.n();
        }
    }

    public final void v(Editable editable) {
        ((C0387Oy) this.y).getClass();
        int length = editable != null ? editable.length() : 0;
        FrameLayout frameLayout = this.l;
        if (length != 0 || this.F0) {
            E8 e8 = this.E;
            if (e8 == null || !this.D) {
                return;
            }
            e8.setText((CharSequence) null);
            Ig0.a(frameLayout, this.I);
            this.E.setVisibility(4);
            return;
        }
        if (this.E == null || !this.D || TextUtils.isEmpty(this.C)) {
            return;
        }
        this.E.setText(this.C);
        Ig0.a(frameLayout, this.H);
        this.E.setVisibility(0);
        this.E.bringToFront();
        announceForAccessibility(this.C);
    }

    public final void w(boolean z, boolean z2) {
        int defaultColor = this.y0.getDefaultColor();
        int colorForState = this.y0.getColorForState(new int[]{R.attr.state_hovered, R.attr.state_enabled}, defaultColor);
        int colorForState2 = this.y0.getColorForState(new int[]{R.attr.state_activated, R.attr.state_enabled}, defaultColor);
        if (z) {
            this.h0 = colorForState2;
        } else if (z2) {
            this.h0 = colorForState;
        } else {
            this.h0 = defaultColor;
        }
    }

    public final void x() throws Resources.NotFoundException {
        E8 e8;
        EditText editText;
        EditText editText2;
        if (this.Q == null || this.c0 == 0) {
            return;
        }
        boolean z = false;
        boolean z2 = isFocused() || ((editText2 = this.f30o) != null && editText2.hasFocus());
        if (isHovered() || ((editText = this.f30o) != null && editText.isHovered())) {
            z = true;
        }
        if (!isEnabled()) {
            this.h0 = this.D0;
        } else if (m()) {
            if (this.y0 != null) {
                w(z2, z);
            } else {
                this.h0 = getErrorCurrentTextColors();
            }
        } else if (!this.x || (e8 = this.z) == null) {
            if (z2) {
                this.h0 = this.x0;
            } else if (z) {
                this.h0 = this.w0;
            } else {
                this.h0 = this.v0;
            }
        } else if (this.y0 != null) {
            w(z2, z);
        } else {
            this.h0 = e8.getCurrentTextColor();
        }
        if (Build.VERSION.SDK_INT >= 29) {
            p();
        }
        C0957cw c0957cw = this.n;
        TextInputLayout textInputLayout = c0957cw.l;
        CheckableImageButton checkableImageButton = c0957cw.r;
        TextInputLayout textInputLayout2 = c0957cw.l;
        c0957cw.l();
        IJ.C(textInputLayout2, c0957cw.n, c0957cw.f482o);
        IJ.C(textInputLayout2, checkableImageButton, c0957cw.v);
        if (c0957cw.b() instanceof C0253Jt) {
            if (!textInputLayout.m() || checkableImageButton.getDrawable() == null) {
                IJ.b(textInputLayout, checkableImageButton, c0957cw.v, c0957cw.w);
            } else {
                Drawable drawableMutate = checkableImageButton.getDrawable().mutate();
                drawableMutate.setTint(textInputLayout.getErrorCurrentTextColors());
                checkableImageButton.setImageDrawable(drawableMutate);
            }
        }
        C2342ra0 c2342ra0 = this.m;
        IJ.C(c2342ra0.l, c2342ra0.f702o, c2342ra0.p);
        if (this.c0 == 2) {
            int i = this.e0;
            if (z2 && isEnabled()) {
                this.e0 = this.g0;
            } else {
                this.e0 = this.f0;
            }
            if (this.e0 != i && e() && !this.F0) {
                if (e()) {
                    ((C0403Po) this.Q).n(0.0f, 0.0f, 0.0f, 0.0f);
                }
                j();
            }
        }
        if (this.c0 == 1) {
            if (!isEnabled()) {
                this.i0 = this.A0;
            } else if (z && !z2) {
                this.i0 = this.C0;
            } else if (z2) {
                this.i0 = this.B0;
            } else {
                this.i0 = this.z0;
            }
        }
        b();
    }

    public void setStartIconContentDescription(CharSequence charSequence) {
        CheckableImageButton checkableImageButton = this.m.f702o;
        if (checkableImageButton.getContentDescription() != charSequence) {
            checkableImageButton.setContentDescription(charSequence);
        }
    }

    public void setStartIconDrawable(Drawable drawable) {
        this.m.b(drawable);
    }

    public void setHint(int i) {
        setHint(i != 0 ? getResources().getText(i) : null);
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(CharSequence charSequence) {
        this.n.r.setContentDescription(charSequence);
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(Drawable drawable) {
        this.n.r.setImageDrawable(drawable);
    }

    public void setErrorIconDrawable(Drawable drawable) {
        this.n.i(drawable);
    }

    public void setEndIconContentDescription(CharSequence charSequence) {
        CheckableImageButton checkableImageButton = this.n.r;
        if (checkableImageButton.getContentDescription() != charSequence) {
            checkableImageButton.setContentDescription(charSequence);
        }
    }

    public void setEndIconDrawable(Drawable drawable) {
        C0957cw c0957cw = this.n;
        TextInputLayout textInputLayout = c0957cw.l;
        CheckableImageButton checkableImageButton = c0957cw.r;
        checkableImageButton.setImageDrawable(drawable);
        if (drawable != null) {
            IJ.b(textInputLayout, checkableImageButton, c0957cw.v, c0957cw.w);
            IJ.C(textInputLayout, checkableImageButton, c0957cw.v);
        }
    }
}
