package com.google.android.material.sidesheet;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.AbsSavedState;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.PathInterpolator;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.gms.common.R;
import com.google.android.material.sidesheet.SideSheetBehavior;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.WeakHashMap;
import o.AbstractC0126Ew;
import o.AbstractC0375Om;
import o.AbstractC0752ap;
import o.AbstractC2378rs0;
import o.AbstractC2461sm0;
import o.C0;
import o.C0453Rm;
import o.C1092eO;
import o.C1915n;
import o.C2255qe;
import o.C2444se;
import o.F80;
import o.GK;
import o.Gj0;
import o.M70;
import o.N70;
import o.Oj0;
import o.S0;
import o.Sj0;
import o.XZ;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class SideSheetBehavior<V extends View> extends AbstractC0375Om {
    public AbstractC2378rs0 a;
    public final C1092eO b;
    public final ColorStateList c;
    public final N70 d;
    public final C2444se e;
    public final float f;
    public final boolean g;
    public int h;
    public Sj0 i;
    public boolean j;
    public final float k;
    public int l;
    public int m;
    public int n;

    /* renamed from: o, reason: collision with root package name */
    public int f29o;
    public WeakReference p;
    public WeakReference q;
    public final int r;
    public VelocityTracker s;
    public int t;
    public final LinkedHashSet u;
    public final C2255qe v;

    public SideSheetBehavior() {
        this.e = new C2444se(this);
        this.g = true;
        this.h = 5;
        this.k = 0.1f;
        this.r = -1;
        this.u = new LinkedHashSet();
        this.v = new C2255qe(this, 1);
    }

    @Override // o.AbstractC0375Om
    public final void c(C0453Rm c0453Rm) {
        this.p = null;
        this.i = null;
    }

    @Override // o.AbstractC0375Om
    public final void e() {
        this.p = null;
        this.i = null;
    }

    @Override // o.AbstractC0375Om
    public final boolean f(CoordinatorLayout coordinatorLayout, View view, MotionEvent motionEvent) {
        Sj0 sj0;
        VelocityTracker velocityTracker;
        if ((!view.isShown() && Oj0.e(view) == null) || !this.g) {
            this.j = true;
            return false;
        }
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0 && (velocityTracker = this.s) != null) {
            velocityTracker.recycle();
            this.s = null;
        }
        if (this.s == null) {
            this.s = VelocityTracker.obtain();
        }
        this.s.addMovement(motionEvent);
        if (actionMasked == 0) {
            this.t = (int) motionEvent.getX();
        } else if ((actionMasked == 1 || actionMasked == 3) && this.j) {
            this.j = false;
            return false;
        }
        return (this.j || (sj0 = this.i) == null || !sj0.o(motionEvent)) ? false : true;
    }

    @Override // o.AbstractC0375Om
    public final boolean g(CoordinatorLayout coordinatorLayout, View view, int i) throws Resources.NotFoundException {
        View view2;
        View view3;
        int i2;
        View viewFindViewById;
        WeakHashMap weakHashMap = Oj0.a;
        int i3 = 1;
        if (coordinatorLayout.getFitsSystemWindows() && !view.getFitsSystemWindows()) {
            view.setFitsSystemWindows(true);
        }
        WeakReference weakReference = this.p;
        C1092eO c1092eO = this.b;
        int iS = 0;
        if (weakReference == null) {
            this.p = new WeakReference(view);
            Context context = view.getContext();
            AbstractC0752ap.b0(context, R.attr.motionEasingStandardDecelerateInterpolator, new PathInterpolator(0.0f, 0.0f, 0.0f, 1.0f));
            AbstractC0752ap.a0(context, R.attr.motionDurationMedium2, 300);
            AbstractC0752ap.a0(context, R.attr.motionDurationShort3, 150);
            AbstractC0752ap.a0(context, R.attr.motionDurationShort2, 100);
            Resources resources = view.getResources();
            resources.getDimension(R.dimen.m3_back_progress_side_container_max_scale_x_distance_shrink);
            resources.getDimension(R.dimen.m3_back_progress_side_container_max_scale_x_distance_grow);
            resources.getDimension(R.dimen.m3_back_progress_side_container_max_scale_y_distance);
            if (c1092eO != null) {
                view.setBackground(c1092eO);
                float fE = this.f;
                if (fE == -1.0f) {
                    fE = Gj0.e(view);
                }
                c1092eO.i(fE);
            } else {
                ColorStateList colorStateList = this.c;
                if (colorStateList != null) {
                    Gj0.i(view, colorStateList);
                }
            }
            int i4 = this.h == 5 ? 4 : 0;
            if (view.getVisibility() != i4) {
                view.setVisibility(i4);
            }
            u();
            if (view.getImportantForAccessibility() == 0) {
                view.setImportantForAccessibility(1);
            }
            if (Oj0.e(view) == null) {
                Oj0.n(view, view.getResources().getString(R.string.side_sheet_accessibility_pane_title));
            }
        }
        int i5 = Gravity.getAbsoluteGravity(((C0453Rm) view.getLayoutParams()).c, i) == 3 ? 1 : 0;
        AbstractC2378rs0 abstractC2378rs0 = this.a;
        if (abstractC2378rs0 == null || abstractC2378rs0.W() != i5) {
            C0453Rm c0453Rm = null;
            N70 n70 = this.d;
            if (i5 == 0) {
                this.a = new GK(this, i3);
                if (n70 != null) {
                    WeakReference weakReference2 = this.p;
                    if (weakReference2 != null && (view3 = (View) weakReference2.get()) != null && (view3.getLayoutParams() instanceof C0453Rm)) {
                        c0453Rm = (C0453Rm) view3.getLayoutParams();
                    }
                    if (c0453Rm == null || ((ViewGroup.MarginLayoutParams) c0453Rm).rightMargin <= 0) {
                        M70 m70E = n70.e();
                        m70E.f = new C1915n(0.0f);
                        m70E.g = new C1915n(0.0f);
                        N70 n70A = m70E.a();
                        if (c1092eO != null) {
                            c1092eO.setShapeAppearanceModel(n70A);
                        }
                    }
                }
            } else {
                if (i5 != 1) {
                    throw new IllegalArgumentException(AbstractC0126Ew.k(i5, "Invalid sheet edge position value: ", ". Must be 0 or 1."));
                }
                this.a = new GK(this, iS);
                if (n70 != null) {
                    WeakReference weakReference3 = this.p;
                    if (weakReference3 != null && (view2 = (View) weakReference3.get()) != null && (view2.getLayoutParams() instanceof C0453Rm)) {
                        c0453Rm = (C0453Rm) view2.getLayoutParams();
                    }
                    if (c0453Rm == null || ((ViewGroup.MarginLayoutParams) c0453Rm).leftMargin <= 0) {
                        M70 m70E2 = n70.e();
                        m70E2.e = new C1915n(0.0f);
                        m70E2.h = new C1915n(0.0f);
                        N70 n70A2 = m70E2.a();
                        if (c1092eO != null) {
                            c1092eO.setShapeAppearanceModel(n70A2);
                        }
                    }
                }
            }
        }
        if (this.i == null) {
            this.i = new Sj0(coordinatorLayout.getContext(), coordinatorLayout, this.v);
        }
        int iS2 = this.a.S(view);
        coordinatorLayout.p(view, i);
        this.m = coordinatorLayout.getWidth();
        this.n = this.a.T(coordinatorLayout);
        this.l = view.getWidth();
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        this.f29o = marginLayoutParams != null ? this.a.D(marginLayoutParams) : 0;
        int i6 = this.h;
        if (i6 == 1 || i6 == 2) {
            iS = iS2 - this.a.S(view);
        } else if (i6 != 3) {
            if (i6 != 5) {
                throw new IllegalStateException("Unexpected value: " + this.h);
            }
            iS = this.a.N();
        }
        view.offsetLeftAndRight(iS);
        if (this.q == null && (i2 = this.r) != -1 && (viewFindViewById = coordinatorLayout.findViewById(i2)) != null) {
            this.q = new WeakReference(viewFindViewById);
        }
        Iterator it = this.u.iterator();
        while (it.hasNext()) {
            if (it.next() != null) {
                throw new ClassCastException();
            }
        }
        return true;
    }

    @Override // o.AbstractC0375Om
    public final boolean h(CoordinatorLayout coordinatorLayout, View view, int i, int i2, int i3) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        view.measure(ViewGroup.getChildMeasureSpec(i, coordinatorLayout.getPaddingRight() + coordinatorLayout.getPaddingLeft() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + i2, marginLayoutParams.width), ViewGroup.getChildMeasureSpec(i3, coordinatorLayout.getPaddingBottom() + coordinatorLayout.getPaddingTop() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin, marginLayoutParams.height));
        return true;
    }

    @Override // o.AbstractC0375Om
    public final void m(View view, Parcelable parcelable) {
        int i = ((F80) parcelable).n;
        if (i == 1 || i == 2) {
            i = 5;
        }
        this.h = i;
    }

    @Override // o.AbstractC0375Om
    public final Parcelable n(View view) {
        AbsSavedState absSavedState = View.BaseSavedState.EMPTY_STATE;
        return new F80(this);
    }

    @Override // o.AbstractC0375Om
    public final boolean q(View view, MotionEvent motionEvent) {
        VelocityTracker velocityTracker;
        if (!view.isShown()) {
            return false;
        }
        int actionMasked = motionEvent.getActionMasked();
        if (this.h == 1 && actionMasked == 0) {
            return true;
        }
        if (s()) {
            this.i.i(motionEvent);
        }
        if (actionMasked == 0 && (velocityTracker = this.s) != null) {
            velocityTracker.recycle();
            this.s = null;
        }
        if (this.s == null) {
            this.s = VelocityTracker.obtain();
        }
        this.s.addMovement(motionEvent);
        if (s() && actionMasked == 2 && !this.j && s()) {
            float fAbs = Math.abs(this.t - motionEvent.getX());
            Sj0 sj0 = this.i;
            if (fAbs > sj0.b) {
                sj0.b(view, motionEvent.getPointerId(motionEvent.getActionIndex()));
            }
        }
        return !this.j;
    }

    public final void r(int i) {
        View view;
        if (this.h == i) {
            return;
        }
        this.h = i;
        WeakReference weakReference = this.p;
        if (weakReference == null || (view = (View) weakReference.get()) == null) {
            return;
        }
        int i2 = this.h == 5 ? 4 : 0;
        if (view.getVisibility() != i2) {
            view.setVisibility(i2);
        }
        Iterator it = this.u.iterator();
        if (it.hasNext()) {
            it.next().getClass();
            throw new ClassCastException();
        }
        u();
    }

    public final boolean s() {
        if (this.i != null) {
            return this.g || this.h == 1;
        }
        return false;
    }

    /* JADX WARN: Code restructure failed: missing block: B:14:0x002d, code lost:
    
        if (r1.n(r0, r3.getTop()) != false) goto L24;
     */
    /* JADX WARN: Code restructure failed: missing block: B:23:0x004b, code lost:
    
        if (r3 != false) goto L24;
     */
    /* JADX WARN: Code restructure failed: missing block: B:24:0x004d, code lost:
    
        r(2);
        r2.e.a(r4);
     */
    /* JADX WARN: Code restructure failed: missing block: B:25:0x0056, code lost:
    
        return;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void t(android.view.View r3, int r4, boolean r5) {
        /*
            r2 = this;
            r0 = 3
            if (r4 == r0) goto L19
            r0 = 5
            if (r4 != r0) goto Ld
            o.rs0 r0 = r2.a
            int r0 = r0.N()
            goto L1f
        Ld:
            java.lang.IllegalArgumentException r3 = new java.lang.IllegalArgumentException
            java.lang.String r5 = "Invalid state to get outer edge offset: "
            java.lang.String r4 = o.AbstractC0126Ew.j(r4, r5)
            r3.<init>(r4)
            throw r3
        L19:
            o.rs0 r0 = r2.a
            int r0 = r0.M()
        L1f:
            o.Sj0 r1 = r2.i
            if (r1 == 0) goto L57
            if (r5 == 0) goto L30
            int r3 = r3.getTop()
            boolean r3 = r1.n(r0, r3)
            if (r3 == 0) goto L57
            goto L4d
        L30:
            int r5 = r3.getTop()
            r1.r = r3
            r3 = -1
            r1.c = r3
            r3 = 0
            boolean r3 = r1.h(r0, r5, r3, r3)
            if (r3 != 0) goto L4b
            int r5 = r1.a
            if (r5 != 0) goto L4b
            android.view.View r5 = r1.r
            if (r5 == 0) goto L4b
            r5 = 0
            r1.r = r5
        L4b:
            if (r3 == 0) goto L57
        L4d:
            r3 = 2
            r2.r(r3)
            o.se r3 = r2.e
            r3.a(r4)
            return
        L57:
            r2.r(r4)
            return
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.sidesheet.SideSheetBehavior.t(android.view.View, int, boolean):void");
    }

    public final void u() {
        View view;
        WeakReference weakReference = this.p;
        if (weakReference == null || (view = (View) weakReference.get()) == null) {
            return;
        }
        Oj0.j(view, 262144);
        Oj0.h(view, 0);
        Oj0.j(view, 1048576);
        Oj0.h(view, 0);
        final int i = 5;
        if (this.h != 5) {
            Oj0.k(view, C0.l, new S0() { // from class: o.E80
                @Override // o.S0
                public final boolean a(View view2) {
                    int i2 = i;
                    if (i2 != 1) {
                        int i3 = 2;
                        if (i2 != 2) {
                            SideSheetBehavior sideSheetBehavior = this.l;
                            WeakReference weakReference2 = sideSheetBehavior.p;
                            if (weakReference2 == null || weakReference2.get() == null) {
                                sideSheetBehavior.r(i2);
                                return true;
                            }
                            View view3 = (View) sideSheetBehavior.p.get();
                            RunnableC2120p7 runnableC2120p7 = new RunnableC2120p7(i2, i3, sideSheetBehavior);
                            ViewParent parent = view3.getParent();
                            if (parent != null && parent.isLayoutRequested()) {
                                WeakHashMap weakHashMap = Oj0.a;
                                if (view3.isAttachedToWindow()) {
                                    view3.post(runnableC2120p7);
                                    return true;
                                }
                            }
                            runnableC2120p7.run();
                            return true;
                        }
                    }
                    throw new IllegalArgumentException(AbstractC2462sn.n(new StringBuilder("STATE_"), i2 == 1 ? "DRAGGING" : "SETTLING", " should not be set externally."));
                }
            });
        }
        final int i2 = 3;
        if (this.h != 3) {
            Oj0.k(view, C0.j, new S0() { // from class: o.E80
                @Override // o.S0
                public final boolean a(View view2) {
                    int i22 = i2;
                    if (i22 != 1) {
                        int i3 = 2;
                        if (i22 != 2) {
                            SideSheetBehavior sideSheetBehavior = this.l;
                            WeakReference weakReference2 = sideSheetBehavior.p;
                            if (weakReference2 == null || weakReference2.get() == null) {
                                sideSheetBehavior.r(i22);
                                return true;
                            }
                            View view3 = (View) sideSheetBehavior.p.get();
                            RunnableC2120p7 runnableC2120p7 = new RunnableC2120p7(i22, i3, sideSheetBehavior);
                            ViewParent parent = view3.getParent();
                            if (parent != null && parent.isLayoutRequested()) {
                                WeakHashMap weakHashMap = Oj0.a;
                                if (view3.isAttachedToWindow()) {
                                    view3.post(runnableC2120p7);
                                    return true;
                                }
                            }
                            runnableC2120p7.run();
                            return true;
                        }
                    }
                    throw new IllegalArgumentException(AbstractC2462sn.n(new StringBuilder("STATE_"), i22 == 1 ? "DRAGGING" : "SETTLING", " should not be set externally."));
                }
            });
        }
    }

    public SideSheetBehavior(Context context, AttributeSet attributeSet) {
        this.e = new C2444se(this);
        this.g = true;
        this.h = 5;
        this.k = 0.1f;
        this.r = -1;
        this.u = new LinkedHashSet();
        this.v = new C2255qe(this, 1);
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, XZ.w);
        if (typedArrayObtainStyledAttributes.hasValue(3)) {
            this.c = AbstractC2461sm0.q(context, typedArrayObtainStyledAttributes, 3);
        }
        if (typedArrayObtainStyledAttributes.hasValue(6)) {
            this.d = N70.b(context, attributeSet, 0, R.style.Widget_Material3_SideSheet).a();
        }
        if (typedArrayObtainStyledAttributes.hasValue(5)) {
            int resourceId = typedArrayObtainStyledAttributes.getResourceId(5, -1);
            this.r = resourceId;
            WeakReference weakReference = this.q;
            if (weakReference != null) {
                weakReference.clear();
            }
            this.q = null;
            WeakReference weakReference2 = this.p;
            if (weakReference2 != null) {
                View view = (View) weakReference2.get();
                if (resourceId != -1) {
                    WeakHashMap weakHashMap = Oj0.a;
                    if (view.isLaidOut()) {
                        view.requestLayout();
                    }
                }
            }
        }
        N70 n70 = this.d;
        if (n70 != null) {
            C1092eO c1092eO = new C1092eO(n70);
            this.b = c1092eO;
            c1092eO.h(context);
            ColorStateList colorStateList = this.c;
            if (colorStateList != null) {
                this.b.j(colorStateList);
            } else {
                TypedValue typedValue = new TypedValue();
                context.getTheme().resolveAttribute(android.R.attr.colorBackground, typedValue, true);
                this.b.setTint(typedValue.data);
            }
        }
        this.f = typedArrayObtainStyledAttributes.getDimension(2, -1.0f);
        this.g = typedArrayObtainStyledAttributes.getBoolean(4, true);
        typedArrayObtainStyledAttributes.recycle();
        ViewConfiguration.get(context).getScaledMaximumFlingVelocity();
    }
}
