package com.google.android.material.internal;

import android.R;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.util.WeakHashMap;
import o.AbstractC0249Jp;
import o.AbstractC3060z20;
import o.C2326rL;
import o.C2545th;
import o.InterfaceC1381hP;
import o.LO;
import o.Oj0;
import o.VA;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class NavigationMenuItemView extends VA implements InterfaceC1381hP {
    public static final int[] R = {R.attr.state_checked};
    public int G;
    public boolean H;
    public boolean I;
    public final boolean J;
    public final CheckedTextView K;
    public FrameLayout L;
    public LO M;
    public ColorStateList N;
    public boolean O;
    public Drawable P;
    public final C2545th Q;

    public NavigationMenuItemView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.J = true;
        C2545th c2545th = new C2545th(3, this);
        this.Q = c2545th;
        setOrientation(0);
        LayoutInflater.from(context).inflate(com.google.android.gms.common.R.layout.design_navigation_menu_item, (ViewGroup) this, true);
        setIconSize(context.getResources().getDimensionPixelSize(com.google.android.gms.common.R.dimen.design_navigation_icon_size));
        CheckedTextView checkedTextView = (CheckedTextView) findViewById(com.google.android.gms.common.R.id.design_menu_item_text);
        this.K = checkedTextView;
        checkedTextView.setDuplicateParentStateEnabled(true);
        Oj0.m(checkedTextView, c2545th);
    }

    private void setActionView(View view) {
        if (view != null) {
            if (this.L == null) {
                this.L = (FrameLayout) ((ViewStub) findViewById(com.google.android.gms.common.R.id.design_menu_item_action_area_stub)).inflate();
            }
            if (view.getParent() != null) {
                ((ViewGroup) view.getParent()).removeView(view);
            }
            this.L.removeAllViews();
            this.L.addView(view);
        }
    }

    @Override // o.InterfaceC1381hP
    public final void a(LO lo) throws Resources.NotFoundException {
        StateListDrawable stateListDrawable;
        this.M = lo;
        int i = lo.a;
        if (i > 0) {
            setId(i);
        }
        setVisibility(lo.isVisible() ? 0 : 8);
        if (getBackground() == null) {
            TypedValue typedValue = new TypedValue();
            if (getContext().getTheme().resolveAttribute(com.google.android.gms.common.R.attr.colorControlHighlight, typedValue, true)) {
                stateListDrawable = new StateListDrawable();
                stateListDrawable.addState(R, new ColorDrawable(typedValue.data));
                stateListDrawable.addState(ViewGroup.EMPTY_STATE_SET, new ColorDrawable(0));
            } else {
                stateListDrawable = null;
            }
            WeakHashMap weakHashMap = Oj0.a;
            setBackground(stateListDrawable);
        }
        setCheckable(lo.isCheckable());
        setChecked(lo.isChecked());
        setEnabled(lo.isEnabled());
        setTitle(lo.e);
        setIcon(lo.getIcon());
        setActionView(lo.getActionView());
        setContentDescription(lo.q);
        AbstractC0249Jp.e0(this, lo.r);
        LO lo2 = this.M;
        CharSequence charSequence = lo2.e;
        CheckedTextView checkedTextView = this.K;
        if (charSequence == null && lo2.getIcon() == null && this.M.getActionView() != null) {
            checkedTextView.setVisibility(8);
            FrameLayout frameLayout = this.L;
            if (frameLayout != null) {
                C2326rL c2326rL = (C2326rL) frameLayout.getLayoutParams();
                ((LinearLayout.LayoutParams) c2326rL).width = -1;
                this.L.setLayoutParams(c2326rL);
                return;
            }
            return;
        }
        checkedTextView.setVisibility(0);
        FrameLayout frameLayout2 = this.L;
        if (frameLayout2 != null) {
            C2326rL c2326rL2 = (C2326rL) frameLayout2.getLayoutParams();
            ((LinearLayout.LayoutParams) c2326rL2).width = -2;
            this.L.setLayoutParams(c2326rL2);
        }
    }

    @Override // o.InterfaceC1381hP
    public LO getItemData() {
        return this.M;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final int[] onCreateDrawableState(int i) {
        int[] iArrOnCreateDrawableState = super.onCreateDrawableState(i + 1);
        LO lo = this.M;
        if (lo != null && lo.isCheckable() && this.M.isChecked()) {
            View.mergeDrawableStates(iArrOnCreateDrawableState, R);
        }
        return iArrOnCreateDrawableState;
    }

    public void setCheckable(boolean z) {
        refreshDrawableState();
        if (this.I != z) {
            this.I = z;
            this.Q.h(this.K, 2048);
        }
    }

    public void setChecked(boolean z) {
        refreshDrawableState();
        CheckedTextView checkedTextView = this.K;
        checkedTextView.setChecked(z);
        checkedTextView.setTypeface(checkedTextView.getTypeface(), (z && this.J) ? 1 : 0);
    }

    public void setHorizontalPadding(int i) {
        setPadding(i, getPaddingTop(), i, getPaddingBottom());
    }

    public void setIcon(Drawable drawable) throws Resources.NotFoundException {
        if (drawable != null) {
            if (this.O) {
                Drawable.ConstantState constantState = drawable.getConstantState();
                if (constantState != null) {
                    drawable = constantState.newDrawable();
                }
                drawable = drawable.mutate();
                drawable.setTintList(this.N);
            }
            int i = this.G;
            drawable.setBounds(0, 0, i, i);
        } else if (this.H) {
            if (this.P == null) {
                Resources resources = getResources();
                Resources.Theme theme = getContext().getTheme();
                ThreadLocal threadLocal = AbstractC3060z20.a;
                Drawable drawable2 = resources.getDrawable(com.google.android.gms.common.R.drawable.navigation_empty_icon, theme);
                this.P = drawable2;
                if (drawable2 != null) {
                    int i2 = this.G;
                    drawable2.setBounds(0, 0, i2, i2);
                }
            }
            drawable = this.P;
        }
        this.K.setCompoundDrawablesRelative(drawable, null, null, null);
    }

    public void setIconPadding(int i) {
        this.K.setCompoundDrawablePadding(i);
    }

    public void setIconSize(int i) {
        this.G = i;
    }

    public void setIconTintList(ColorStateList colorStateList) throws Resources.NotFoundException {
        this.N = colorStateList;
        this.O = colorStateList != null;
        LO lo = this.M;
        if (lo != null) {
            setIcon(lo.getIcon());
        }
    }

    public void setMaxLines(int i) {
        this.K.setMaxLines(i);
    }

    public void setNeedsEmptyIcon(boolean z) {
        this.H = z;
    }

    public void setTextAppearance(int i) {
        this.K.setTextAppearance(i);
    }

    public void setTextColor(ColorStateList colorStateList) {
        this.K.setTextColor(colorStateList);
    }

    public void setTitle(CharSequence charSequence) {
        this.K.setText(charSequence);
    }
}
