package com.google.android.material.internal;

import android.R;
import android.content.Context;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import o.C2545th;
import o.C2640uh;
import o.Oj0;
import o.Z7;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class CheckableImageButton extends Z7 implements Checkable {
    public static final int[] r = {R.attr.state_checked};

    /* renamed from: o, reason: collision with root package name */
    public boolean f28o;
    public boolean p;
    public boolean q;

    public CheckableImageButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, com.google.android.gms.common.R.attr.imageButtonStyle);
        this.p = true;
        this.q = true;
        Oj0.m(this, new C2545th(0, this));
    }

    @Override // android.widget.Checkable
    public final boolean isChecked() {
        return this.f28o;
    }

    @Override // android.widget.ImageView, android.view.View
    public final int[] onCreateDrawableState(int i) {
        return this.f28o ? View.mergeDrawableStates(super.onCreateDrawableState(i + 1), r) : super.onCreateDrawableState(i);
    }

    @Override // android.view.View
    public final void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof C2640uh)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        C2640uh c2640uh = (C2640uh) parcelable;
        super.onRestoreInstanceState(c2640uh.l);
        setChecked(c2640uh.n);
    }

    @Override // android.view.View
    public final Parcelable onSaveInstanceState() {
        C2640uh c2640uh = new C2640uh(super.onSaveInstanceState());
        c2640uh.n = this.f28o;
        return c2640uh;
    }

    public void setCheckable(boolean z) {
        if (this.p != z) {
            this.p = z;
            sendAccessibilityEvent(0);
        }
    }

    @Override // android.widget.Checkable
    public void setChecked(boolean z) {
        if (!this.p || this.f28o == z) {
            return;
        }
        this.f28o = z;
        refreshDrawableState();
        sendAccessibilityEvent(2048);
    }

    public void setPressable(boolean z) {
        this.q = z;
    }

    @Override // android.view.View
    public void setPressed(boolean z) {
        if (this.q) {
            super.setPressed(z);
        }
    }

    @Override // android.widget.Checkable
    public final void toggle() {
        setChecked(!this.f28o);
    }
}
