package com.google.android.material.chip;

import android.R;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.google.android.gms.common.api.Api;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.WeakHashMap;
import o.AbstractC1904ms0;
import o.AbstractC2378rs0;
import o.AbstractC2461sm0;
import o.AbstractC2841wm0;
import o.Ad0;
import o.C0211Id;
import o.C0267Kh;
import o.C0293Lh;
import o.C0318Mh;
import o.C0370Oh;
import o.C0999dQ;
import o.C1016dd0;
import o.C2160pe;
import o.C2974y7;
import o.C80;
import o.Co0;
import o.Dd0;
import o.Gj0;
import o.InterfaceC0344Nh;
import o.InterfaceC0693a80;
import o.N70;
import o.Oj0;
import o.Rm0;
import o.XZ;
import o.YT;
import o.ZN;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class Chip extends C2974y7 implements InterfaceC0344Nh, InterfaceC0693a80, Checkable {
    public static final Rect H = new Rect();
    public static final int[] I = {R.attr.state_selected};
    public static final int[] J = {R.attr.state_checkable};
    public int A;
    public CharSequence B;
    public final C0318Mh C;
    public boolean D;
    public final Rect E;
    public final RectF F;
    public final C0267Kh G;
    public C0370Oh p;
    public InsetDrawable q;
    public RippleDrawable r;
    public View.OnClickListener s;
    public CompoundButton.OnCheckedChangeListener t;
    public boolean u;
    public boolean v;
    public boolean w;
    public boolean x;
    public boolean y;
    public int z;

    public Chip(Context context, AttributeSet attributeSet) {
        int resourceId;
        int resourceId2;
        int resourceId3;
        super(AbstractC2378rs0.n0(context, attributeSet, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action), attributeSet, com.google.android.gms.common.R.attr.chipStyle);
        this.E = new Rect();
        this.F = new RectF();
        this.G = new C0267Kh(0, this);
        Context context2 = getContext();
        if (attributeSet != null) {
            attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "background");
            if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "drawableLeft") != null) {
                throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
            }
            if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "drawableStart") != null) {
                throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
            }
            if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "drawableEnd") != null) {
                throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
            }
            if (attributeSet.getAttributeValue("http://schemas.android.com/apk/res/android", "drawableRight") != null) {
                throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
            }
            if (!attributeSet.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "singleLine", true) || attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/android", "lines", 1) != 1 || attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/android", "minLines", 1) != 1 || attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/android", "maxLines", 1) != 1) {
                throw new UnsupportedOperationException("Chip does not support multi-line text");
            }
            attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/android", "gravity", 8388627);
        }
        C0370Oh c0370Oh = new C0370Oh(context2, attributeSet);
        Context context3 = c0370Oh.p0;
        int[] iArr = XZ.c;
        TypedArray typedArrayI = YT.I(context3, attributeSet, iArr, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action, new int[0]);
        c0370Oh.P0 = typedArrayI.hasValue(37);
        Context context4 = c0370Oh.p0;
        ColorStateList colorStateListQ = AbstractC2461sm0.q(context4, typedArrayI, 24);
        if (c0370Oh.I != colorStateListQ) {
            c0370Oh.I = colorStateListQ;
            c0370Oh.onStateChange(c0370Oh.getState());
        }
        ColorStateList colorStateListQ2 = AbstractC2461sm0.q(context4, typedArrayI, 11);
        if (c0370Oh.J != colorStateListQ2) {
            c0370Oh.J = colorStateListQ2;
            c0370Oh.onStateChange(c0370Oh.getState());
        }
        float dimension = typedArrayI.getDimension(19, 0.0f);
        if (c0370Oh.K != dimension) {
            c0370Oh.K = dimension;
            c0370Oh.invalidateSelf();
            c0370Oh.u();
        }
        if (typedArrayI.hasValue(12)) {
            c0370Oh.A(typedArrayI.getDimension(12, 0.0f));
        }
        c0370Oh.F(AbstractC2461sm0.q(context4, typedArrayI, 22));
        c0370Oh.G(typedArrayI.getDimension(23, 0.0f));
        c0370Oh.P(AbstractC2461sm0.q(context4, typedArrayI, 36));
        String text = typedArrayI.getText(5);
        text = text == null ? "" : text;
        if (!TextUtils.equals(c0370Oh.P, text)) {
            c0370Oh.P = text;
            c0370Oh.v0.d = true;
            c0370Oh.invalidateSelf();
            c0370Oh.u();
        }
        C1016dd0 c1016dd0 = (!typedArrayI.hasValue(0) || (resourceId3 = typedArrayI.getResourceId(0, 0)) == 0) ? null : new C1016dd0(context4, resourceId3);
        c1016dd0.k = typedArrayI.getDimension(1, c1016dd0.k);
        c0370Oh.Q(c1016dd0);
        int i = typedArrayI.getInt(3, 0);
        if (i == 1) {
            c0370Oh.M0 = TextUtils.TruncateAt.START;
        } else if (i == 2) {
            c0370Oh.M0 = TextUtils.TruncateAt.MIDDLE;
        } else if (i == 3) {
            c0370Oh.M0 = TextUtils.TruncateAt.END;
        }
        c0370Oh.E(typedArrayI.getBoolean(18, false));
        if (attributeSet != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "chipIconEnabled") != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "chipIconVisible") == null) {
            c0370Oh.E(typedArrayI.getBoolean(15, false));
        }
        c0370Oh.B(AbstractC2461sm0.t(context4, typedArrayI, 14));
        if (typedArrayI.hasValue(17)) {
            c0370Oh.D(AbstractC2461sm0.q(context4, typedArrayI, 17));
        }
        c0370Oh.C(typedArrayI.getDimension(16, -1.0f));
        c0370Oh.M(typedArrayI.getBoolean(31, false));
        if (attributeSet != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "closeIconEnabled") != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "closeIconVisible") == null) {
            c0370Oh.M(typedArrayI.getBoolean(26, false));
        }
        c0370Oh.H(AbstractC2461sm0.t(context4, typedArrayI, 25));
        c0370Oh.L(AbstractC2461sm0.q(context4, typedArrayI, 30));
        c0370Oh.J(typedArrayI.getDimension(28, 0.0f));
        c0370Oh.w(typedArrayI.getBoolean(6, false));
        c0370Oh.z(typedArrayI.getBoolean(10, false));
        if (attributeSet != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "checkedIconEnabled") != null && attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", "checkedIconVisible") == null) {
            c0370Oh.z(typedArrayI.getBoolean(8, false));
        }
        c0370Oh.x(AbstractC2461sm0.t(context4, typedArrayI, 7));
        if (typedArrayI.hasValue(9)) {
            c0370Oh.y(AbstractC2461sm0.q(context4, typedArrayI, 9));
        }
        c0370Oh.f0 = (!typedArrayI.hasValue(39) || (resourceId2 = typedArrayI.getResourceId(39, 0)) == 0) ? null : C0999dQ.a(context4, resourceId2);
        c0370Oh.g0 = (!typedArrayI.hasValue(33) || (resourceId = typedArrayI.getResourceId(33, 0)) == 0) ? null : C0999dQ.a(context4, resourceId);
        float dimension2 = typedArrayI.getDimension(21, 0.0f);
        if (c0370Oh.h0 != dimension2) {
            c0370Oh.h0 = dimension2;
            c0370Oh.invalidateSelf();
            c0370Oh.u();
        }
        c0370Oh.O(typedArrayI.getDimension(35, 0.0f));
        c0370Oh.N(typedArrayI.getDimension(34, 0.0f));
        float dimension3 = typedArrayI.getDimension(41, 0.0f);
        if (c0370Oh.k0 != dimension3) {
            c0370Oh.k0 = dimension3;
            c0370Oh.invalidateSelf();
            c0370Oh.u();
        }
        float dimension4 = typedArrayI.getDimension(40, 0.0f);
        if (c0370Oh.l0 != dimension4) {
            c0370Oh.l0 = dimension4;
            c0370Oh.invalidateSelf();
            c0370Oh.u();
        }
        c0370Oh.K(typedArrayI.getDimension(29, 0.0f));
        c0370Oh.I(typedArrayI.getDimension(27, 0.0f));
        float dimension5 = typedArrayI.getDimension(13, 0.0f);
        if (c0370Oh.o0 != dimension5) {
            c0370Oh.o0 = dimension5;
            c0370Oh.invalidateSelf();
            c0370Oh.u();
        }
        c0370Oh.O0 = typedArrayI.getDimensionPixelSize(4, Api.BaseClientBuilder.API_PRIORITY_OTHER);
        typedArrayI.recycle();
        YT.l(context2, attributeSet, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action);
        YT.n(context2, attributeSet, iArr, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action, new int[0]);
        TypedArray typedArrayObtainStyledAttributes = context2.obtainStyledAttributes(attributeSet, iArr, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action);
        this.y = typedArrayObtainStyledAttributes.getBoolean(32, false);
        this.A = (int) Math.ceil(typedArrayObtainStyledAttributes.getDimension(20, (float) Math.ceil(TypedValue.applyDimension(1, 48, getContext().getResources().getDisplayMetrics()))));
        typedArrayObtainStyledAttributes.recycle();
        setChipDrawable(c0370Oh);
        c0370Oh.i(Gj0.e(this));
        YT.l(context2, attributeSet, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action);
        YT.n(context2, attributeSet, iArr, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action, new int[0]);
        TypedArray typedArrayObtainStyledAttributes2 = context2.obtainStyledAttributes(attributeSet, iArr, com.google.android.gms.common.R.attr.chipStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Chip_Action);
        boolean zHasValue = typedArrayObtainStyledAttributes2.hasValue(37);
        typedArrayObtainStyledAttributes2.recycle();
        this.C = new C0318Mh(this, this);
        d();
        if (!zHasValue) {
            setOutlineProvider(new C0293Lh(this));
        }
        setChecked(this.u);
        setText(c0370Oh.P);
        setEllipsize(c0370Oh.M0);
        g();
        if (!this.p.N0) {
            setLines(1);
            setHorizontallyScrolling(true);
        }
        setGravity(8388627);
        f();
        if (this.y) {
            setMinHeight(this.A);
        }
        this.z = getLayoutDirection();
        super.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() { // from class: o.Jh
            @Override // android.widget.CompoundButton.OnCheckedChangeListener
            public final void onCheckedChanged(CompoundButton compoundButton, boolean z) {
                CompoundButton.OnCheckedChangeListener onCheckedChangeListener = this.a.t;
                if (onCheckedChangeListener != null) {
                    onCheckedChangeListener.onCheckedChanged(compoundButton, z);
                }
            }
        });
    }

    private RectF getCloseIconTouchBounds() {
        RectF rectF = this.F;
        rectF.setEmpty();
        if (c() && this.s != null) {
            C0370Oh c0370Oh = this.p;
            Rect bounds = c0370Oh.getBounds();
            rectF.setEmpty();
            if (c0370Oh.T()) {
                float f = c0370Oh.o0 + c0370Oh.n0 + c0370Oh.Z + c0370Oh.m0 + c0370Oh.l0;
                if (c0370Oh.getLayoutDirection() == 0) {
                    float f2 = bounds.right;
                    rectF.right = f2;
                    rectF.left = f2 - f;
                } else {
                    float f3 = bounds.left;
                    rectF.left = f3;
                    rectF.right = f3 + f;
                }
                rectF.top = bounds.top;
                rectF.bottom = bounds.bottom;
            }
        }
        return rectF;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public Rect getCloseIconTouchBoundsInt() {
        RectF closeIconTouchBounds = getCloseIconTouchBounds();
        int i = (int) closeIconTouchBounds.left;
        int i2 = (int) closeIconTouchBounds.top;
        int i3 = (int) closeIconTouchBounds.right;
        int i4 = (int) closeIconTouchBounds.bottom;
        Rect rect = this.E;
        rect.set(i, i2, i3, i4);
        return rect;
    }

    private C1016dd0 getTextAppearance() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.v0.f;
        }
        return null;
    }

    private void setCloseIconHovered(boolean z) {
        if (this.w != z) {
            this.w = z;
            refreshDrawableState();
        }
    }

    private void setCloseIconPressed(boolean z) {
        if (this.v != z) {
            this.v = z;
            refreshDrawableState();
        }
    }

    public final void b(int i) {
        this.A = i;
        if (!this.y) {
            InsetDrawable insetDrawable = this.q;
            if (insetDrawable == null) {
                e();
                return;
            } else {
                if (insetDrawable != null) {
                    this.q = null;
                    setMinWidth(0);
                    setMinHeight((int) getChipMinHeight());
                    e();
                    return;
                }
                return;
            }
        }
        int iMax = Math.max(0, i - ((int) this.p.K));
        int iMax2 = Math.max(0, i - this.p.getIntrinsicWidth());
        if (iMax2 <= 0 && iMax <= 0) {
            InsetDrawable insetDrawable2 = this.q;
            if (insetDrawable2 == null) {
                e();
                return;
            } else {
                if (insetDrawable2 != null) {
                    this.q = null;
                    setMinWidth(0);
                    setMinHeight((int) getChipMinHeight());
                    e();
                    return;
                }
                return;
            }
        }
        int i2 = iMax2 > 0 ? iMax2 / 2 : 0;
        int i3 = iMax > 0 ? iMax / 2 : 0;
        if (this.q != null) {
            Rect rect = new Rect();
            this.q.getPadding(rect);
            if (rect.top == i3 && rect.bottom == i3 && rect.left == i2 && rect.right == i2) {
                e();
                return;
            }
        }
        if (getMinHeight() != i) {
            setMinHeight(i);
        }
        if (getMinWidth() != i) {
            setMinWidth(i);
        }
        this.q = new InsetDrawable((Drawable) this.p, i2, i3, i2, i3);
        e();
    }

    public final boolean c() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null) {
            return false;
        }
        Object obj = c0370Oh.W;
        if (obj == null) {
            obj = null;
        } else if (obj instanceof Rm0) {
            obj = null;
        }
        return obj != null;
    }

    public final void d() {
        C0370Oh c0370Oh;
        if (!c() || (c0370Oh = this.p) == null || !c0370Oh.V || this.s == null) {
            Oj0.m(this, null);
            this.D = false;
        } else {
            Oj0.m(this, this.C);
            this.D = true;
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:34:0x006b  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean dispatchHoverEvent(android.view.MotionEvent r9) {
        /*
            r8 = this;
            boolean r0 = r8.D
            if (r0 != 0) goto L9
            boolean r9 = super.dispatchHoverEvent(r9)
            return r9
        L9:
            o.Mh r0 = r8.C
            android.view.accessibility.AccessibilityManager r1 = r0.h
            boolean r2 = r1.isEnabled()
            r3 = 0
            r4 = 1
            if (r2 == 0) goto L6b
            boolean r1 = r1.isTouchExplorationEnabled()
            if (r1 != 0) goto L1c
            goto L6b
        L1c:
            int r1 = r9.getAction()
            r2 = 7
            r5 = 256(0x100, float:3.59E-43)
            r6 = 128(0x80, float:1.8E-43)
            if (r1 == r2) goto L42
            r2 = 9
            if (r1 == r2) goto L42
            r2 = 10
            if (r1 == r2) goto L30
            goto L6b
        L30:
            int r1 = r0.m
            r2 = -2147483648(0xffffffff80000000, float:-0.0)
            if (r1 == r2) goto L6b
            if (r1 != r2) goto L39
            goto L71
        L39:
            r0.m = r2
            r0.q(r2, r6)
            r0.q(r1, r5)
            return r4
        L42:
            float r1 = r9.getX()
            float r9 = r9.getY()
            com.google.android.material.chip.Chip r2 = r0.n
            boolean r7 = r2.c()
            if (r7 == 0) goto L5d
            android.graphics.RectF r2 = r2.getCloseIconTouchBounds()
            boolean r9 = r2.contains(r1, r9)
            if (r9 == 0) goto L5d
            r3 = r4
        L5d:
            int r9 = r0.m
            if (r9 != r3) goto L62
            goto L71
        L62:
            r0.m = r3
            r0.q(r3, r6)
            r0.q(r9, r5)
            return r4
        L6b:
            boolean r9 = super.dispatchHoverEvent(r9)
            if (r9 == 0) goto L72
        L71:
            return r4
        L72:
            return r3
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.chip.Chip.dispatchHoverEvent(android.view.MotionEvent):boolean");
    }

    /* JADX WARN: Removed duplicated region for block: B:31:0x0058  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean dispatchKeyEvent(android.view.KeyEvent r10) {
        /*
            r9 = this;
            boolean r0 = r9.D
            if (r0 != 0) goto L9
            boolean r10 = super.dispatchKeyEvent(r10)
            return r10
        L9:
            o.Mh r0 = r9.C
            r0.getClass()
            int r1 = r10.getAction()
            r2 = 0
            r3 = -2147483648(0xffffffff80000000, float:-0.0)
            r4 = 1
            if (r1 == r4) goto L9d
            int r1 = r10.getKeyCode()
            r5 = 61
            r6 = 0
            if (r1 == r5) goto L87
            r5 = 66
            if (r1 == r5) goto L58
            switch(r1) {
                case 19: goto L2a;
                case 20: goto L2a;
                case 21: goto L2a;
                case 22: goto L2a;
                case 23: goto L58;
                default: goto L28;
            }
        L28:
            goto L9d
        L2a:
            boolean r7 = r10.hasNoModifiers()
            if (r7 == 0) goto L9d
            r7 = 19
            if (r1 == r7) goto L42
            r7 = 21
            if (r1 == r7) goto L3f
            r7 = 22
            if (r1 == r7) goto L44
            r5 = 130(0x82, float:1.82E-43)
            goto L44
        L3f:
            r5 = 17
            goto L44
        L42:
            r5 = 33
        L44:
            int r1 = r10.getRepeatCount()
            int r1 = r1 + r4
            r7 = r2
        L4a:
            if (r2 >= r1) goto L56
            boolean r8 = r0.m(r5, r6)
            if (r8 == 0) goto L56
            int r2 = r2 + 1
            r7 = r4
            goto L4a
        L56:
            r2 = r7
            goto L9d
        L58:
            boolean r1 = r10.hasNoModifiers()
            if (r1 == 0) goto L9d
            int r1 = r10.getRepeatCount()
            if (r1 != 0) goto L9d
            int r1 = r0.l
            if (r1 == r3) goto L85
            com.google.android.material.chip.Chip r5 = r0.n
            if (r1 != 0) goto L70
            r5.performClick()
            goto L85
        L70:
            if (r1 != r4) goto L85
            r5.playSoundEffect(r2)
            android.view.View$OnClickListener r1 = r5.s
            if (r1 == 0) goto L7c
            r1.onClick(r5)
        L7c:
            boolean r1 = r5.D
            if (r1 == 0) goto L85
            o.Mh r1 = r5.C
            r1.q(r4, r4)
        L85:
            r2 = r4
            goto L9d
        L87:
            boolean r1 = r10.hasNoModifiers()
            if (r1 == 0) goto L93
            r1 = 2
            boolean r2 = r0.m(r1, r6)
            goto L9d
        L93:
            boolean r1 = r10.hasModifiers(r4)
            if (r1 == 0) goto L9d
            boolean r2 = r0.m(r4, r6)
        L9d:
            if (r2 == 0) goto La4
            int r0 = r0.l
            if (r0 == r3) goto La4
            return r4
        La4:
            boolean r10 = super.dispatchKeyEvent(r10)
            return r10
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.chip.Chip.dispatchKeyEvent(android.view.KeyEvent):boolean");
    }

    /* JADX WARN: Type inference failed for: r2v0, types: [boolean, int] */
    @Override // o.C2974y7, android.widget.CompoundButton, android.widget.TextView, android.view.View
    public final void drawableStateChanged() {
        int i;
        super.drawableStateChanged();
        C0370Oh c0370Oh = this.p;
        boolean zV = false;
        if (c0370Oh != null && C0370Oh.t(c0370Oh.W)) {
            C0370Oh c0370Oh2 = this.p;
            ?? IsEnabled = isEnabled();
            int i2 = IsEnabled;
            if (this.x) {
                i2 = IsEnabled + 1;
            }
            int i3 = i2;
            if (this.w) {
                i3 = i2 + 1;
            }
            int i4 = i3;
            if (this.v) {
                i4 = i3 + 1;
            }
            int i5 = i4;
            if (isChecked()) {
                i5 = i4 + 1;
            }
            int[] iArr = new int[i5];
            if (isEnabled()) {
                iArr[0] = 16842910;
                i = 1;
            } else {
                i = 0;
            }
            if (this.x) {
                iArr[i] = 16842908;
                i++;
            }
            if (this.w) {
                iArr[i] = 16843623;
                i++;
            }
            if (this.v) {
                iArr[i] = 16842919;
                i++;
            }
            if (isChecked()) {
                iArr[i] = 16842913;
            }
            if (!Arrays.equals(c0370Oh2.J0, iArr)) {
                c0370Oh2.J0 = iArr;
                if (c0370Oh2.T()) {
                    zV = c0370Oh2.v(c0370Oh2.getState(), iArr);
                }
            }
        }
        if (zV) {
            invalidate();
        }
    }

    public final void e() {
        this.r = new RippleDrawable(AbstractC1904ms0.u(this.p.O), getBackgroundDrawable(), null);
        this.p.getClass();
        RippleDrawable rippleDrawable = this.r;
        WeakHashMap weakHashMap = Oj0.a;
        setBackground(rippleDrawable);
        f();
    }

    public final void f() {
        C0370Oh c0370Oh;
        if (TextUtils.isEmpty(getText()) || (c0370Oh = this.p) == null) {
            return;
        }
        int iQ = (int) (c0370Oh.q() + c0370Oh.o0 + c0370Oh.l0);
        C0370Oh c0370Oh2 = this.p;
        int iP = (int) (c0370Oh2.p() + c0370Oh2.h0 + c0370Oh2.k0);
        if (this.q != null) {
            Rect rect = new Rect();
            this.q.getPadding(rect);
            iP += rect.left;
            iQ += rect.right;
        }
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        WeakHashMap weakHashMap = Oj0.a;
        setPaddingRelative(iP, paddingTop, iQ, paddingBottom);
    }

    public final void g() {
        TextPaint paint = getPaint();
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            paint.drawableState = c0370Oh.getState();
        }
        C1016dd0 textAppearance = getTextAppearance();
        if (textAppearance != null) {
            textAppearance.e(getContext(), paint, this.G);
        }
    }

    @Override // android.widget.CheckBox, android.widget.CompoundButton, android.widget.Button, android.widget.TextView, android.view.View
    public CharSequence getAccessibilityClassName() {
        if (!TextUtils.isEmpty(this.B)) {
            return this.B;
        }
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || !c0370Oh.b0) {
            return isClickable() ? "android.widget.Button" : "android.view.View";
        }
        getParent();
        return "android.widget.Button";
    }

    public Drawable getBackgroundDrawable() {
        InsetDrawable insetDrawable = this.q;
        return insetDrawable == null ? this.p : insetDrawable;
    }

    public Drawable getCheckedIcon() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.d0;
        }
        return null;
    }

    public ColorStateList getCheckedIconTint() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.e0;
        }
        return null;
    }

    public ColorStateList getChipBackgroundColor() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.J;
        }
        return null;
    }

    public float getChipCornerRadius() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return Math.max(0.0f, c0370Oh.r());
        }
        return 0.0f;
    }

    public Drawable getChipDrawable() {
        return this.p;
    }

    public float getChipEndPadding() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.o0;
        }
        return 0.0f;
    }

    /* JADX WARN: Multi-variable type inference failed */
    public Drawable getChipIcon() {
        Drawable drawable;
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || (drawable = c0370Oh.R) == 0) {
            return null;
        }
        if (!(drawable instanceof Rm0)) {
            return drawable;
        }
        return null;
    }

    public float getChipIconSize() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.T;
        }
        return 0.0f;
    }

    public ColorStateList getChipIconTint() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.S;
        }
        return null;
    }

    public float getChipMinHeight() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.K;
        }
        return 0.0f;
    }

    public float getChipStartPadding() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.h0;
        }
        return 0.0f;
    }

    public ColorStateList getChipStrokeColor() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.M;
        }
        return null;
    }

    public float getChipStrokeWidth() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.N;
        }
        return 0.0f;
    }

    @Deprecated
    public CharSequence getChipText() {
        return getText();
    }

    /* JADX WARN: Multi-variable type inference failed */
    public Drawable getCloseIcon() {
        Drawable drawable;
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || (drawable = c0370Oh.W) == 0) {
            return null;
        }
        if (!(drawable instanceof Rm0)) {
            return drawable;
        }
        return null;
    }

    public CharSequence getCloseIconContentDescription() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.a0;
        }
        return null;
    }

    public float getCloseIconEndPadding() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.n0;
        }
        return 0.0f;
    }

    public float getCloseIconSize() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.Z;
        }
        return 0.0f;
    }

    public float getCloseIconStartPadding() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.m0;
        }
        return 0.0f;
    }

    public ColorStateList getCloseIconTint() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.Y;
        }
        return null;
    }

    @Override // android.widget.TextView
    public TextUtils.TruncateAt getEllipsize() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.M0;
        }
        return null;
    }

    @Override // android.widget.TextView, android.view.View
    public final void getFocusedRect(Rect rect) {
        if (this.D) {
            C0318Mh c0318Mh = this.C;
            if (c0318Mh.l == 1 || c0318Mh.k == 1) {
                rect.set(getCloseIconTouchBoundsInt());
                return;
            }
        }
        super.getFocusedRect(rect);
    }

    public C0999dQ getHideMotionSpec() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.g0;
        }
        return null;
    }

    public float getIconEndPadding() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.j0;
        }
        return 0.0f;
    }

    public float getIconStartPadding() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.i0;
        }
        return 0.0f;
    }

    public ColorStateList getRippleColor() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.O;
        }
        return null;
    }

    public N70 getShapeAppearanceModel() {
        return this.p.l.a;
    }

    public C0999dQ getShowMotionSpec() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.f0;
        }
        return null;
    }

    public float getTextEndPadding() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.l0;
        }
        return 0.0f;
    }

    public float getTextStartPadding() {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            return c0370Oh.k0;
        }
        return 0.0f;
    }

    @Override // android.widget.TextView, android.view.View
    public final void onAttachedToWindow() {
        super.onAttachedToWindow();
        AbstractC2841wm0.D(this, this.p);
    }

    @Override // android.widget.CompoundButton, android.widget.TextView, android.view.View
    public final int[] onCreateDrawableState(int i) {
        int[] iArrOnCreateDrawableState = super.onCreateDrawableState(i + 2);
        if (isChecked()) {
            View.mergeDrawableStates(iArrOnCreateDrawableState, I);
        }
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null && c0370Oh.b0) {
            View.mergeDrawableStates(iArrOnCreateDrawableState, J);
        }
        return iArrOnCreateDrawableState;
    }

    @Override // android.widget.TextView, android.view.View
    public final void onFocusChanged(boolean z, int i, Rect rect) {
        super.onFocusChanged(z, i, rect);
        if (this.D) {
            C0318Mh c0318Mh = this.C;
            int i2 = c0318Mh.l;
            if (i2 != Integer.MIN_VALUE) {
                c0318Mh.j(i2);
            }
            if (z) {
                c0318Mh.m(i, rect);
            }
        }
    }

    @Override // android.view.View
    public final boolean onHoverEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 7) {
            setCloseIconHovered(getCloseIconTouchBounds().contains(motionEvent.getX(), motionEvent.getY()));
        } else if (actionMasked == 10) {
            setCloseIconHovered(false);
        }
        return super.onHoverEvent(motionEvent);
    }

    @Override // android.view.View
    public final void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(getAccessibilityClassName());
        C0370Oh c0370Oh = this.p;
        accessibilityNodeInfo.setCheckable(c0370Oh != null && c0370Oh.b0);
        accessibilityNodeInfo.setClickable(isClickable());
        getParent();
    }

    @Override // android.widget.Button, android.widget.TextView, android.view.View
    public final PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int i) {
        return (getCloseIconTouchBounds().contains(motionEvent.getX(), motionEvent.getY()) && isEnabled()) ? PointerIcon.getSystemIcon(getContext(), 1002) : super.onResolvePointerIcon(motionEvent, i);
    }

    @Override // android.widget.TextView, android.view.View
    public final void onRtlPropertiesChanged(int i) {
        super.onRtlPropertiesChanged(i);
        if (this.z != i) {
            this.z = i;
            f();
        }
    }

    /* JADX WARN: Code restructure failed: missing block: B:8:0x001e, code lost:
    
        if (r0 != 3) goto L28;
     */
    @Override // android.widget.TextView, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean onTouchEvent(android.view.MotionEvent r6) {
        /*
            r5 = this;
            int r0 = r6.getActionMasked()
            android.graphics.RectF r1 = r5.getCloseIconTouchBounds()
            float r2 = r6.getX()
            float r3 = r6.getY()
            boolean r1 = r1.contains(r2, r3)
            r2 = 1
            r3 = 0
            if (r0 == 0) goto L4a
            if (r0 == r2) goto L2c
            r4 = 2
            if (r0 == r4) goto L21
            r1 = 3
            if (r0 == r1) goto L45
            goto L50
        L21:
            boolean r0 = r5.v
            if (r0 == 0) goto L50
            if (r1 != 0) goto L2a
            r5.setCloseIconPressed(r3)
        L2a:
            r0 = r2
            goto L51
        L2c:
            boolean r0 = r5.v
            if (r0 == 0) goto L45
            r5.playSoundEffect(r3)
            android.view.View$OnClickListener r0 = r5.s
            if (r0 == 0) goto L3a
            r0.onClick(r5)
        L3a:
            boolean r0 = r5.D
            if (r0 == 0) goto L43
            o.Mh r0 = r5.C
            r0.q(r2, r2)
        L43:
            r0 = r2
            goto L46
        L45:
            r0 = r3
        L46:
            r5.setCloseIconPressed(r3)
            goto L51
        L4a:
            if (r1 == 0) goto L50
            r5.setCloseIconPressed(r2)
            goto L2a
        L50:
            r0 = r3
        L51:
            if (r0 != 0) goto L5b
            boolean r6 = super.onTouchEvent(r6)
            if (r6 == 0) goto L5a
            goto L5b
        L5a:
            return r3
        L5b:
            return r2
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.chip.Chip.onTouchEvent(android.view.MotionEvent):boolean");
    }

    public void setAccessibilityClassName(CharSequence charSequence) {
        this.B = charSequence;
    }

    @Override // android.view.View
    public void setBackground(Drawable drawable) {
        if (drawable == getBackgroundDrawable() || drawable == this.r) {
            super.setBackground(drawable);
        }
    }

    @Override // o.C2974y7, android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        if (drawable == getBackgroundDrawable() || drawable == this.r) {
            super.setBackgroundDrawable(drawable);
        }
    }

    public void setCheckable(boolean z) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.w(z);
        }
    }

    public void setCheckableResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.w(c0370Oh.p0.getResources().getBoolean(i));
        }
    }

    @Override // android.widget.CompoundButton, android.widget.Checkable
    public void setChecked(boolean z) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null) {
            this.u = z;
        } else if (c0370Oh.b0) {
            super.setChecked(z);
        }
    }

    public void setCheckedIcon(Drawable drawable) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.x(drawable);
        }
    }

    @Deprecated
    public void setCheckedIconEnabled(boolean z) {
        setCheckedIconVisible(z);
    }

    @Deprecated
    public void setCheckedIconEnabledResource(int i) {
        setCheckedIconVisible(i);
    }

    public void setCheckedIconResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.x(C80.x(c0370Oh.p0, i));
        }
    }

    public void setCheckedIconTint(ColorStateList colorStateList) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.y(colorStateList);
        }
    }

    public void setCheckedIconTintResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.y(Co0.z(c0370Oh.p0, i));
        }
    }

    public void setCheckedIconVisible(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.z(c0370Oh.p0.getResources().getBoolean(i));
        }
    }

    public void setChipBackgroundColor(ColorStateList colorStateList) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || c0370Oh.J == colorStateList) {
            return;
        }
        c0370Oh.J = colorStateList;
        c0370Oh.onStateChange(c0370Oh.getState());
    }

    public void setChipBackgroundColorResource(int i) {
        ColorStateList colorStateListZ;
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || c0370Oh.J == (colorStateListZ = Co0.z(c0370Oh.p0, i))) {
            return;
        }
        c0370Oh.J = colorStateListZ;
        c0370Oh.onStateChange(c0370Oh.getState());
    }

    @Deprecated
    public void setChipCornerRadius(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.A(f);
        }
    }

    @Deprecated
    public void setChipCornerRadiusResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.A(c0370Oh.p0.getResources().getDimension(i));
        }
    }

    public void setChipDrawable(C0370Oh c0370Oh) {
        C0370Oh c0370Oh2 = this.p;
        if (c0370Oh2 != c0370Oh) {
            if (c0370Oh2 != null) {
                c0370Oh2.L0 = new WeakReference(null);
            }
            this.p = c0370Oh;
            c0370Oh.N0 = false;
            c0370Oh.L0 = new WeakReference(this);
            b(this.A);
        }
    }

    public void setChipEndPadding(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || c0370Oh.o0 == f) {
            return;
        }
        c0370Oh.o0 = f;
        c0370Oh.invalidateSelf();
        c0370Oh.u();
    }

    public void setChipEndPaddingResource(int i) throws Resources.NotFoundException {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            float dimension = c0370Oh.p0.getResources().getDimension(i);
            if (c0370Oh.o0 != dimension) {
                c0370Oh.o0 = dimension;
                c0370Oh.invalidateSelf();
                c0370Oh.u();
            }
        }
    }

    public void setChipIcon(Drawable drawable) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.B(drawable);
        }
    }

    @Deprecated
    public void setChipIconEnabled(boolean z) {
        setChipIconVisible(z);
    }

    @Deprecated
    public void setChipIconEnabledResource(int i) {
        setChipIconVisible(i);
    }

    public void setChipIconResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.B(C80.x(c0370Oh.p0, i));
        }
    }

    public void setChipIconSize(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.C(f);
        }
    }

    public void setChipIconSizeResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.C(c0370Oh.p0.getResources().getDimension(i));
        }
    }

    public void setChipIconTint(ColorStateList colorStateList) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.D(colorStateList);
        }
    }

    public void setChipIconTintResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.D(Co0.z(c0370Oh.p0, i));
        }
    }

    public void setChipIconVisible(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.E(c0370Oh.p0.getResources().getBoolean(i));
        }
    }

    public void setChipMinHeight(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || c0370Oh.K == f) {
            return;
        }
        c0370Oh.K = f;
        c0370Oh.invalidateSelf();
        c0370Oh.u();
    }

    public void setChipMinHeightResource(int i) throws Resources.NotFoundException {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            float dimension = c0370Oh.p0.getResources().getDimension(i);
            if (c0370Oh.K != dimension) {
                c0370Oh.K = dimension;
                c0370Oh.invalidateSelf();
                c0370Oh.u();
            }
        }
    }

    public void setChipStartPadding(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || c0370Oh.h0 == f) {
            return;
        }
        c0370Oh.h0 = f;
        c0370Oh.invalidateSelf();
        c0370Oh.u();
    }

    public void setChipStartPaddingResource(int i) throws Resources.NotFoundException {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            float dimension = c0370Oh.p0.getResources().getDimension(i);
            if (c0370Oh.h0 != dimension) {
                c0370Oh.h0 = dimension;
                c0370Oh.invalidateSelf();
                c0370Oh.u();
            }
        }
    }

    public void setChipStrokeColor(ColorStateList colorStateList) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.F(colorStateList);
        }
    }

    public void setChipStrokeColorResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.F(Co0.z(c0370Oh.p0, i));
        }
    }

    public void setChipStrokeWidth(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.G(f);
        }
    }

    public void setChipStrokeWidthResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.G(c0370Oh.p0.getResources().getDimension(i));
        }
    }

    @Deprecated
    public void setChipText(CharSequence charSequence) {
        setText(charSequence);
    }

    @Deprecated
    public void setChipTextResource(int i) {
        setText(getResources().getString(i));
    }

    public void setCloseIcon(Drawable drawable) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.H(drawable);
        }
        d();
    }

    public void setCloseIconContentDescription(CharSequence charSequence) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || c0370Oh.a0 == charSequence) {
            return;
        }
        C0211Id c0211IdC = C0211Id.c();
        c0211IdC.getClass();
        C2160pe c2160pe = Ad0.a;
        c0370Oh.a0 = c0211IdC.d(charSequence);
        c0370Oh.invalidateSelf();
    }

    @Deprecated
    public void setCloseIconEnabled(boolean z) {
        setCloseIconVisible(z);
    }

    @Deprecated
    public void setCloseIconEnabledResource(int i) {
        setCloseIconVisible(i);
    }

    public void setCloseIconEndPadding(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.I(f);
        }
    }

    public void setCloseIconEndPaddingResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.I(c0370Oh.p0.getResources().getDimension(i));
        }
    }

    public void setCloseIconResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.H(C80.x(c0370Oh.p0, i));
        }
        d();
    }

    public void setCloseIconSize(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.J(f);
        }
    }

    public void setCloseIconSizeResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.J(c0370Oh.p0.getResources().getDimension(i));
        }
    }

    public void setCloseIconStartPadding(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.K(f);
        }
    }

    public void setCloseIconStartPaddingResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.K(c0370Oh.p0.getResources().getDimension(i));
        }
    }

    public void setCloseIconTint(ColorStateList colorStateList) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.L(colorStateList);
        }
    }

    public void setCloseIconTintResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.L(Co0.z(c0370Oh.p0, i));
        }
    }

    public void setCloseIconVisible(int i) {
        setCloseIconVisible(getResources().getBoolean(i));
    }

    @Override // o.C2974y7, android.widget.TextView
    public final void setCompoundDrawables(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        if (drawable != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (drawable3 != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawables(drawable, drawable2, drawable3, drawable4);
    }

    @Override // o.C2974y7, android.widget.TextView
    public final void setCompoundDrawablesRelative(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        if (drawable != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (drawable3 != null) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelative(drawable, drawable2, drawable3, drawable4);
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesRelativeWithIntrinsicBounds(int i, int i2, int i3, int i4) {
        if (i != 0) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (i3 != 0) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(i, i2, i3, i4);
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesWithIntrinsicBounds(int i, int i2, int i3, int i4) {
        if (i != 0) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (i3 != 0) {
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        super.setCompoundDrawablesWithIntrinsicBounds(i, i2, i3, i4);
    }

    @Override // android.view.View
    public void setElevation(float f) {
        super.setElevation(f);
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.i(f);
        }
    }

    @Override // android.widget.TextView
    public void setEllipsize(TextUtils.TruncateAt truncateAt) {
        if (this.p == null) {
            return;
        }
        if (truncateAt == TextUtils.TruncateAt.MARQUEE) {
            throw new UnsupportedOperationException("Text within a chip are not allowed to scroll.");
        }
        super.setEllipsize(truncateAt);
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.M0 = truncateAt;
        }
    }

    public void setEnsureMinTouchTargetSize(boolean z) {
        this.y = z;
        b(this.A);
    }

    @Override // android.widget.TextView
    public void setGravity(int i) {
        if (i != 8388627) {
            return;
        }
        super.setGravity(i);
    }

    public void setHideMotionSpec(C0999dQ c0999dQ) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.g0 = c0999dQ;
        }
    }

    public void setHideMotionSpecResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.g0 = C0999dQ.a(c0370Oh.p0, i);
        }
    }

    public void setIconEndPadding(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.N(f);
        }
    }

    public void setIconEndPaddingResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.N(c0370Oh.p0.getResources().getDimension(i));
        }
    }

    public void setIconStartPadding(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.O(f);
        }
    }

    public void setIconStartPaddingResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.O(c0370Oh.p0.getResources().getDimension(i));
        }
    }

    @Override // android.view.View
    public void setLayoutDirection(int i) {
        if (this.p == null) {
            return;
        }
        super.setLayoutDirection(i);
    }

    @Override // android.widget.TextView
    public void setLines(int i) {
        if (i > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setLines(i);
    }

    @Override // android.widget.TextView
    public void setMaxLines(int i) {
        if (i > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setMaxLines(i);
    }

    @Override // android.widget.TextView
    public void setMaxWidth(int i) {
        super.setMaxWidth(i);
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.O0 = i;
        }
    }

    @Override // android.widget.TextView
    public void setMinLines(int i) {
        if (i > 1) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setMinLines(i);
    }

    @Override // android.widget.CompoundButton
    public void setOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        this.t = onCheckedChangeListener;
    }

    public void setOnCloseIconClickListener(View.OnClickListener onClickListener) {
        this.s = onClickListener;
        d();
    }

    public void setRippleColor(ColorStateList colorStateList) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.P(colorStateList);
        }
        this.p.getClass();
        e();
    }

    public void setRippleColorResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.P(Co0.z(c0370Oh.p0, i));
            this.p.getClass();
            e();
        }
    }

    @Override // o.InterfaceC0693a80
    public void setShapeAppearanceModel(N70 n70) {
        this.p.setShapeAppearanceModel(n70);
    }

    public void setShowMotionSpec(C0999dQ c0999dQ) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.f0 = c0999dQ;
        }
    }

    public void setShowMotionSpecResource(int i) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.f0 = C0999dQ.a(c0370Oh.p0, i);
        }
    }

    @Override // android.widget.TextView
    public void setSingleLine(boolean z) {
        if (!z) {
            throw new UnsupportedOperationException("Chip does not support multi-line text");
        }
        super.setSingleLine(z);
    }

    @Override // android.widget.TextView
    public final void setText(CharSequence charSequence, TextView.BufferType bufferType) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null) {
            return;
        }
        if (charSequence == null) {
            charSequence = "";
        }
        super.setText(c0370Oh.N0 ? null : charSequence, bufferType);
        C0370Oh c0370Oh2 = this.p;
        if (c0370Oh2 == null || TextUtils.equals(c0370Oh2.P, charSequence)) {
            return;
        }
        c0370Oh2.P = charSequence;
        c0370Oh2.v0.d = true;
        c0370Oh2.invalidateSelf();
        c0370Oh2.u();
    }

    public void setTextAppearance(C1016dd0 c1016dd0) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.Q(c1016dd0);
        }
        g();
    }

    public void setTextAppearanceResource(int i) {
        setTextAppearance(getContext(), i);
    }

    public void setTextEndPadding(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || c0370Oh.l0 == f) {
            return;
        }
        c0370Oh.l0 = f;
        c0370Oh.invalidateSelf();
        c0370Oh.u();
    }

    public void setTextEndPaddingResource(int i) throws Resources.NotFoundException {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            float dimension = c0370Oh.p0.getResources().getDimension(i);
            if (c0370Oh.l0 != dimension) {
                c0370Oh.l0 = dimension;
                c0370Oh.invalidateSelf();
                c0370Oh.u();
            }
        }
    }

    @Override // android.widget.TextView
    public final void setTextSize(int i, float f) {
        super.setTextSize(i, f);
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            float fApplyDimension = TypedValue.applyDimension(i, f, getResources().getDisplayMetrics());
            Dd0 dd0 = c0370Oh.v0;
            C1016dd0 c1016dd0 = dd0.f;
            if (c1016dd0 != null) {
                c1016dd0.k = fApplyDimension;
                dd0.a.setTextSize(fApplyDimension);
                c0370Oh.u();
                c0370Oh.invalidateSelf();
            }
        }
        g();
    }

    public void setTextStartPadding(float f) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh == null || c0370Oh.k0 == f) {
            return;
        }
        c0370Oh.k0 = f;
        c0370Oh.invalidateSelf();
        c0370Oh.u();
    }

    public void setTextStartPaddingResource(int i) throws Resources.NotFoundException {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            float dimension = c0370Oh.p0.getResources().getDimension(i);
            if (c0370Oh.k0 != dimension) {
                c0370Oh.k0 = dimension;
                c0370Oh.invalidateSelf();
                c0370Oh.u();
            }
        }
    }

    public void setCloseIconVisible(boolean z) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.M(z);
        }
        d();
    }

    public void setCheckedIconVisible(boolean z) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.z(z);
        }
    }

    public void setChipIconVisible(boolean z) {
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.E(z);
        }
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        if (drawable != null) {
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        if (drawable3 == null) {
            super.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
            return;
        }
        throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
    }

    @Override // android.widget.TextView
    public final void setCompoundDrawablesWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        if (drawable != null) {
            throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
        }
        if (drawable3 == null) {
            super.setCompoundDrawablesWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
            return;
        }
        throw new UnsupportedOperationException("Please set right drawable using R.attr#closeIcon.");
    }

    @Override // android.widget.TextView
    public final void setTextAppearance(Context context, int i) {
        super.setTextAppearance(context, i);
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.Q(new C1016dd0(c0370Oh.p0, i));
        }
        g();
    }

    @Override // android.widget.TextView
    public void setTextAppearance(int i) {
        super.setTextAppearance(i);
        C0370Oh c0370Oh = this.p;
        if (c0370Oh != null) {
            c0370Oh.Q(new C1016dd0(c0370Oh.p0, i));
        }
        g();
    }

    @Override // android.view.View
    public void setBackgroundColor(int i) {
    }

    @Override // o.C2974y7, android.view.View
    public void setBackgroundResource(int i) {
    }

    @Override // android.view.View
    public void setBackgroundTintList(ColorStateList colorStateList) {
    }

    @Override // android.view.View
    public void setBackgroundTintMode(PorterDuff.Mode mode) {
    }

    public void setInternalOnCheckedChangeListener(ZN zn) {
    }
}
