package com.google.android.material.carousel;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.gms.common.R;
import o.AbstractC0126Ew;
import o.AbstractC1157f10;
import o.C0188Hg;
import o.C0214Ig;
import o.C0240Jg;
import o.C1248fz;
import o.C1253g10;
import o.C1729l10;
import o.C2204q10;
import o.InterfaceC2109p10;
import o.XZ;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class CarouselLayoutManager extends AbstractC1157f10 implements InterfaceC2109p10 {
    public final C1248fz p;
    public C0240Jg q;
    public final View.OnLayoutChangeListener r;

    public CarouselLayoutManager() {
        C1248fz c1248fz = new C1248fz();
        new C0214Ig();
        this.r = new View.OnLayoutChangeListener() { // from class: o.Gg
            @Override // android.view.View.OnLayoutChangeListener
            public final void onLayoutChange(View view, int i, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
                if (i == i5 && i2 == i6 && i3 == i7 && i4 == i8) {
                    return;
                }
                view.post(new RunnableC2108p1(4, this.a));
            }
        };
        this.p = c1248fz;
        l0();
        C0(0);
    }

    public final boolean A0() {
        return this.q.a == 0;
    }

    public final boolean B0() {
        return A0() && C() == 1;
    }

    public final void C0(int i) {
        C0240Jg c0240Jg;
        if (i != 0 && i != 1) {
            throw new IllegalArgumentException(AbstractC0126Ew.j(i, "invalid orientation:"));
        }
        c(null);
        C0240Jg c0240Jg2 = this.q;
        if (c0240Jg2 == null || i != c0240Jg2.a) {
            if (i == 0) {
                c0240Jg = new C0240Jg(this, 1);
            } else {
                if (i != 1) {
                    throw new IllegalArgumentException("invalid orientation");
                }
                c0240Jg = new C0240Jg(this, 0);
            }
            this.q = c0240Jg;
            l0();
        }
    }

    @Override // o.AbstractC1157f10
    public final boolean L() {
        return true;
    }

    @Override // o.AbstractC1157f10
    public final void Q(RecyclerView recyclerView) throws Resources.NotFoundException {
        Context context = recyclerView.getContext();
        C1248fz c1248fz = this.p;
        float dimension = c1248fz.a;
        if (dimension <= 0.0f) {
            dimension = context.getResources().getDimension(R.dimen.m3_carousel_small_item_size_min);
        }
        c1248fz.a = dimension;
        float dimension2 = c1248fz.b;
        if (dimension2 <= 0.0f) {
            dimension2 = context.getResources().getDimension(R.dimen.m3_carousel_small_item_size_max);
        }
        c1248fz.b = dimension2;
        l0();
        recyclerView.addOnLayoutChangeListener(this.r);
    }

    @Override // o.AbstractC1157f10
    public final void R(RecyclerView recyclerView) {
        recyclerView.removeOnLayoutChangeListener(this.r);
    }

    /* JADX WARN: Removed duplicated region for block: B:17:0x0025  */
    /* JADX WARN: Removed duplicated region for block: B:19:0x0029  */
    /* JADX WARN: Removed duplicated region for block: B:23:0x0033  */
    @Override // o.AbstractC1157f10
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final android.view.View S(android.view.View r4, int r5, o.C1729l10 r6, o.C2204q10 r7) {
        /*
            r3 = this;
            int r6 = r3.v()
            if (r6 != 0) goto L8
            goto L83
        L8:
            o.Jg r6 = r3.q
            int r6 = r6.a
            r7 = -2147483648(0xffffffff80000000, float:-0.0)
            r0 = -1
            r1 = 1
            if (r5 == r1) goto L33
            r2 = 2
            if (r5 == r2) goto L29
            r2 = 17
            if (r5 == r2) goto L38
            r2 = 33
            if (r5 == r2) goto L35
            r2 = 66
            if (r5 == r2) goto L2b
            r2 = 130(0x82, float:1.82E-43)
            if (r5 == r2) goto L27
        L25:
            r5 = r7
            goto L41
        L27:
            if (r6 != r1) goto L25
        L29:
            r5 = r1
            goto L41
        L2b:
            if (r6 != 0) goto L25
            boolean r5 = r3.B0()
            if (r5 == 0) goto L29
        L33:
            r5 = r0
            goto L41
        L35:
            if (r6 != r1) goto L25
            goto L33
        L38:
            if (r6 != 0) goto L25
            boolean r5 = r3.B0()
            if (r5 == 0) goto L33
            goto L29
        L41:
            if (r5 != r7) goto L44
            goto L83
        L44:
            r6 = 0
            if (r5 != r0) goto L78
            int r4 = o.AbstractC1157f10.H(r4)
            if (r4 != 0) goto L4e
            goto L83
        L4e:
            android.view.View r4 = r3.u(r6)
            int r4 = o.AbstractC1157f10.H(r4)
            int r4 = r4 - r1
            if (r4 < 0) goto L67
            int r5 = r3.B()
            if (r4 < r5) goto L60
            goto L67
        L60:
            o.Jg r4 = r3.q
            r4.a()
            r4 = 0
            throw r4
        L67:
            boolean r4 = r3.B0()
            if (r4 == 0) goto L73
            int r4 = r3.v()
            int r6 = r4 + (-1)
        L73:
            android.view.View r4 = r3.u(r6)
            return r4
        L78:
            int r4 = o.AbstractC1157f10.H(r4)
            int r5 = r3.B()
            int r5 = r5 - r1
            if (r4 != r5) goto L85
        L83:
            r4 = 0
            return r4
        L85:
            int r4 = r3.v()
            int r4 = r4 - r1
            android.view.View r4 = r3.u(r4)
            int r4 = o.AbstractC1157f10.H(r4)
            int r4 = r4 + r1
            if (r4 < 0) goto La3
            int r5 = r3.B()
            if (r4 < r5) goto L9c
            goto La3
        L9c:
            o.Jg r4 = r3.q
            r4.a()
            r4 = 0
            throw r4
        La3:
            boolean r4 = r3.B0()
            if (r4 == 0) goto Laa
            goto Lb0
        Laa:
            int r4 = r3.v()
            int r6 = r4 + (-1)
        Lb0:
            android.view.View r4 = r3.u(r6)
            return r4
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.material.carousel.CarouselLayoutManager.S(android.view.View, int, o.l10, o.q10):android.view.View");
    }

    @Override // o.AbstractC1157f10
    public final void T(AccessibilityEvent accessibilityEvent) {
        super.T(accessibilityEvent);
        if (v() > 0) {
            accessibilityEvent.setFromIndex(AbstractC1157f10.H(u(0)));
            accessibilityEvent.setToIndex(AbstractC1157f10.H(u(v() - 1)));
        }
    }

    @Override // o.AbstractC1157f10
    public final void W(int i, int i2) {
        B();
    }

    @Override // o.AbstractC1157f10
    public final void Z(int i, int i2) {
        B();
    }

    @Override // o.InterfaceC2109p10
    public final PointF a(int i) {
        return null;
    }

    @Override // o.AbstractC1157f10
    public final void b0(C1729l10 c1729l10, C2204q10 c2204q10) {
        if (c2204q10.b() > 0) {
            if ((A0() ? this.n : this.f519o) > 0.0f) {
                B0();
                View view = c1729l10.i(0, Long.MAX_VALUE).a;
                throw new IllegalStateException("All children of a RecyclerView using CarouselLayoutManager must use MaskableFrameLayout as their root ViewGroup.");
            }
        }
        g0(c1729l10);
    }

    @Override // o.AbstractC1157f10
    public final void c0(C2204q10 c2204q10) {
        if (v() == 0) {
            return;
        }
        AbstractC1157f10.H(u(0));
    }

    @Override // o.AbstractC1157f10
    public final boolean d() {
        return A0();
    }

    @Override // o.AbstractC1157f10
    public final boolean e() {
        return !A0();
    }

    @Override // o.AbstractC1157f10
    public final int j(C2204q10 c2204q10) {
        v();
        return 0;
    }

    @Override // o.AbstractC1157f10
    public final int k(C2204q10 c2204q10) {
        return 0;
    }

    @Override // o.AbstractC1157f10
    public final boolean k0(RecyclerView recyclerView, View view, Rect rect, boolean z, boolean z2) {
        return false;
    }

    @Override // o.AbstractC1157f10
    public final int l(C2204q10 c2204q10) {
        return 0;
    }

    @Override // o.AbstractC1157f10
    public final int m(C2204q10 c2204q10) {
        v();
        return 0;
    }

    @Override // o.AbstractC1157f10
    public final int m0(int i, C1729l10 c1729l10, C2204q10 c2204q10) {
        if (!A0() || v() == 0 || i == 0) {
            return 0;
        }
        View view = c1729l10.i(0, Long.MAX_VALUE).a;
        throw new IllegalStateException("All children of a RecyclerView using CarouselLayoutManager must use MaskableFrameLayout as their root ViewGroup.");
    }

    @Override // o.AbstractC1157f10
    public final int n(C2204q10 c2204q10) {
        return 0;
    }

    @Override // o.AbstractC1157f10
    public final int o(C2204q10 c2204q10) {
        return 0;
    }

    @Override // o.AbstractC1157f10
    public final int o0(int i, C1729l10 c1729l10, C2204q10 c2204q10) {
        if (!e() || v() == 0 || i == 0) {
            return 0;
        }
        View view = c1729l10.i(0, Long.MAX_VALUE).a;
        throw new IllegalStateException("All children of a RecyclerView using CarouselLayoutManager must use MaskableFrameLayout as their root ViewGroup.");
    }

    @Override // o.AbstractC1157f10
    public final C1253g10 r() {
        return new C1253g10(-2, -2);
    }

    @Override // o.AbstractC1157f10
    public final void x0(RecyclerView recyclerView, int i) {
        C0188Hg c0188Hg = new C0188Hg(this, recyclerView.getContext());
        c0188Hg.a = i;
        y0(c0188Hg);
    }

    @Override // o.AbstractC1157f10
    public final void y(View view, Rect rect) {
        super.y(view, rect);
        rect.centerY();
        if (A0()) {
            rect.centerX();
        }
        throw null;
    }

    public CarouselLayoutManager(Context context, AttributeSet attributeSet, int i, int i2) {
        new C0214Ig();
        this.r = new View.OnLayoutChangeListener() { // from class: o.Gg
            @Override // android.view.View.OnLayoutChangeListener
            public final void onLayoutChange(View view, int i3, int i22, int i32, int i4, int i5, int i6, int i7, int i8) {
                if (i3 == i5 && i22 == i6 && i32 == i7 && i4 == i8) {
                    return;
                }
                view.post(new RunnableC2108p1(4, this.a));
            }
        };
        this.p = new C1248fz();
        l0();
        if (attributeSet != null) {
            TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, XZ.b);
            typedArrayObtainStyledAttributes.getInt(0, 0);
            l0();
            C0(typedArrayObtainStyledAttributes.getInt(0, 0));
            typedArrayObtainStyledAttributes.recycle();
        }
    }

    @Override // o.AbstractC1157f10
    public final void n0(int i) {
    }
}
