package com.google.android.material.button;

import android.R;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Parcelable;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.Checkable;
import android.widget.CompoundButton;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.WeakHashMap;
import o.AbstractC1904ms0;
import o.AbstractC2378rs0;
import o.AbstractC2461sm0;
import o.AbstractC2841wm0;
import o.C0247Jn;
import o.C1915n;
import o.C2784w7;
import o.C80;
import o.Co0;
import o.InterfaceC0693a80;
import o.LN;
import o.M70;
import o.MN;
import o.N70;
import o.NN;
import o.Oj0;
import o.XZ;
import o.YT;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class MaterialButton extends C2784w7 implements Checkable, InterfaceC0693a80 {
    public static final int[] C = {R.attr.state_checkable};
    public static final int[] D = {R.attr.state_checked};
    public boolean A;
    public int B;

    /* renamed from: o, reason: collision with root package name */
    public final NN f26o;
    public final LinkedHashSet p;
    public LN q;
    public PorterDuff.Mode r;
    public ColorStateList s;
    public Drawable t;
    public String u;
    public int v;
    public int w;
    public int x;
    public int y;
    public boolean z;

    public MaterialButton(Context context, AttributeSet attributeSet) {
        super(AbstractC2378rs0.n0(context, attributeSet, com.google.android.gms.common.R.attr.materialButtonStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Button), attributeSet, com.google.android.gms.common.R.attr.materialButtonStyle);
        this.p = new LinkedHashSet();
        this.z = false;
        this.A = false;
        Context context2 = getContext();
        TypedArray typedArrayI = YT.I(context2, attributeSet, XZ.j, com.google.android.gms.common.R.attr.materialButtonStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Button, new int[0]);
        this.y = typedArrayI.getDimensionPixelSize(12, 0);
        int i = typedArrayI.getInt(15, -1);
        PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
        this.r = Co0.J(i, mode);
        this.s = AbstractC2461sm0.q(getContext(), typedArrayI, 14);
        this.t = AbstractC2461sm0.t(getContext(), typedArrayI, 10);
        this.B = typedArrayI.getInteger(11, 1);
        this.v = typedArrayI.getDimensionPixelSize(13, 0);
        NN nn = new NN(this, N70.b(context2, attributeSet, com.google.android.gms.common.R.attr.materialButtonStyle, com.google.android.gms.common.R.style.Widget_MaterialComponents_Button).a());
        this.f26o = nn;
        nn.c = typedArrayI.getDimensionPixelOffset(1, 0);
        nn.d = typedArrayI.getDimensionPixelOffset(2, 0);
        nn.e = typedArrayI.getDimensionPixelOffset(3, 0);
        nn.f = typedArrayI.getDimensionPixelOffset(4, 0);
        if (typedArrayI.hasValue(8)) {
            int dimensionPixelSize = typedArrayI.getDimensionPixelSize(8, -1);
            nn.g = dimensionPixelSize;
            float f = dimensionPixelSize;
            M70 m70E = nn.b.e();
            m70E.e = new C1915n(f);
            m70E.f = new C1915n(f);
            m70E.g = new C1915n(f);
            m70E.h = new C1915n(f);
            nn.c(m70E.a());
            nn.p = true;
        }
        nn.h = typedArrayI.getDimensionPixelSize(20, 0);
        nn.i = Co0.J(typedArrayI.getInt(7, -1), mode);
        nn.j = AbstractC2461sm0.q(getContext(), typedArrayI, 6);
        nn.k = AbstractC2461sm0.q(getContext(), typedArrayI, 19);
        nn.l = AbstractC2461sm0.q(getContext(), typedArrayI, 16);
        nn.q = typedArrayI.getBoolean(5, false);
        nn.t = typedArrayI.getDimensionPixelSize(9, 0);
        nn.r = typedArrayI.getBoolean(21, true);
        WeakHashMap weakHashMap = Oj0.a;
        int paddingStart = getPaddingStart();
        int paddingTop = getPaddingTop();
        int paddingEnd = getPaddingEnd();
        int paddingBottom = getPaddingBottom();
        if (typedArrayI.hasValue(0)) {
            nn.f256o = true;
            setSupportBackgroundTintList(nn.j);
            setSupportBackgroundTintMode(nn.i);
        } else {
            nn.e();
        }
        setPaddingRelative(paddingStart + nn.c, paddingTop + nn.e, paddingEnd + nn.d, paddingBottom + nn.f);
        typedArrayI.recycle();
        setCompoundDrawablePadding(this.y);
        c(this.t != null);
    }

    private Layout.Alignment getActualTextAlignment() {
        int textAlignment = getTextAlignment();
        return textAlignment != 1 ? (textAlignment == 6 || textAlignment == 3) ? Layout.Alignment.ALIGN_OPPOSITE : textAlignment != 4 ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_CENTER : getGravityTextAlignment();
    }

    private Layout.Alignment getGravityTextAlignment() {
        int gravity = getGravity() & 8388615;
        return gravity != 1 ? (gravity == 5 || gravity == 8388613) ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_CENTER;
    }

    private int getTextHeight() {
        if (getLineCount() > 1) {
            return getLayout().getHeight();
        }
        TextPaint paint = getPaint();
        String string = getText().toString();
        if (getTransformationMethod() != null) {
            string = getTransformationMethod().getTransformation(string, this).toString();
        }
        Rect rect = new Rect();
        paint.getTextBounds(string, 0, string.length(), rect);
        return Math.min(rect.height(), getLayout().getHeight());
    }

    private int getTextLayoutWidth() {
        int lineCount = getLineCount();
        float fMax = 0.0f;
        for (int i = 0; i < lineCount; i++) {
            fMax = Math.max(fMax, getLayout().getLineWidth(i));
        }
        return (int) Math.ceil(fMax);
    }

    public final boolean a() {
        NN nn = this.f26o;
        return (nn == null || nn.f256o) ? false : true;
    }

    public final void b() {
        int i = this.B;
        if (i == 1 || i == 2) {
            setCompoundDrawablesRelative(this.t, null, null, null);
            return;
        }
        if (i == 3 || i == 4) {
            setCompoundDrawablesRelative(null, null, this.t, null);
        } else if (i == 16 || i == 32) {
            setCompoundDrawablesRelative(null, this.t, null, null);
        }
    }

    public final void c(boolean z) {
        Drawable drawable = this.t;
        if (drawable != null) {
            Drawable drawableMutate = drawable.mutate();
            this.t = drawableMutate;
            drawableMutate.setTintList(this.s);
            PorterDuff.Mode mode = this.r;
            if (mode != null) {
                this.t.setTintMode(mode);
            }
            int intrinsicWidth = this.v;
            if (intrinsicWidth == 0) {
                intrinsicWidth = this.t.getIntrinsicWidth();
            }
            int intrinsicHeight = this.v;
            if (intrinsicHeight == 0) {
                intrinsicHeight = this.t.getIntrinsicHeight();
            }
            Drawable drawable2 = this.t;
            int i = this.w;
            int i2 = this.x;
            drawable2.setBounds(i, i2, intrinsicWidth + i, intrinsicHeight + i2);
            this.t.setVisible(true, z);
        }
        if (z) {
            b();
            return;
        }
        Drawable[] compoundDrawablesRelative = getCompoundDrawablesRelative();
        Drawable drawable3 = compoundDrawablesRelative[0];
        Drawable drawable4 = compoundDrawablesRelative[1];
        Drawable drawable5 = compoundDrawablesRelative[2];
        int i3 = this.B;
        if (((i3 == 1 || i3 == 2) && drawable3 != this.t) || (((i3 == 3 || i3 == 4) && drawable5 != this.t) || ((i3 == 16 || i3 == 32) && drawable4 != this.t))) {
            b();
        }
    }

    public final void d(int i, int i2) {
        if (this.t == null || getLayout() == null) {
            return;
        }
        int i3 = this.B;
        if (i3 != 1 && i3 != 2 && i3 != 3 && i3 != 4) {
            if (i3 == 16 || i3 == 32) {
                this.w = 0;
                if (i3 == 16) {
                    this.x = 0;
                    c(false);
                    return;
                }
                int intrinsicHeight = this.v;
                if (intrinsicHeight == 0) {
                    intrinsicHeight = this.t.getIntrinsicHeight();
                }
                int iMax = Math.max(0, (((((i2 - getTextHeight()) - getPaddingTop()) - intrinsicHeight) - this.y) - getPaddingBottom()) / 2);
                if (this.x != iMax) {
                    this.x = iMax;
                    c(false);
                    return;
                }
                return;
            }
            return;
        }
        this.x = 0;
        Layout.Alignment actualTextAlignment = getActualTextAlignment();
        int i4 = this.B;
        if (i4 == 1 || i4 == 3 || ((i4 == 2 && actualTextAlignment == Layout.Alignment.ALIGN_NORMAL) || (i4 == 4 && actualTextAlignment == Layout.Alignment.ALIGN_OPPOSITE))) {
            this.w = 0;
            c(false);
            return;
        }
        int intrinsicWidth = this.v;
        if (intrinsicWidth == 0) {
            intrinsicWidth = this.t.getIntrinsicWidth();
        }
        int textLayoutWidth = i - getTextLayoutWidth();
        WeakHashMap weakHashMap = Oj0.a;
        int paddingEnd = (((textLayoutWidth - getPaddingEnd()) - intrinsicWidth) - this.y) - getPaddingStart();
        if (actualTextAlignment == Layout.Alignment.ALIGN_CENTER) {
            paddingEnd /= 2;
        }
        if ((getLayoutDirection() == 1) != (this.B == 4)) {
            paddingEnd = -paddingEnd;
        }
        if (this.w != paddingEnd) {
            this.w = paddingEnd;
            c(false);
        }
    }

    public String getA11yClassName() {
        if (!TextUtils.isEmpty(this.u)) {
            return this.u;
        }
        NN nn = this.f26o;
        return ((nn == null || !nn.q) ? Button.class : CompoundButton.class).getName();
    }

    @Override // android.view.View
    public ColorStateList getBackgroundTintList() {
        return getSupportBackgroundTintList();
    }

    @Override // android.view.View
    public PorterDuff.Mode getBackgroundTintMode() {
        return getSupportBackgroundTintMode();
    }

    public int getCornerRadius() {
        if (a()) {
            return this.f26o.g;
        }
        return 0;
    }

    public Drawable getIcon() {
        return this.t;
    }

    public int getIconGravity() {
        return this.B;
    }

    public int getIconPadding() {
        return this.y;
    }

    public int getIconSize() {
        return this.v;
    }

    public ColorStateList getIconTint() {
        return this.s;
    }

    public PorterDuff.Mode getIconTintMode() {
        return this.r;
    }

    public int getInsetBottom() {
        return this.f26o.f;
    }

    public int getInsetTop() {
        return this.f26o.e;
    }

    public ColorStateList getRippleColor() {
        if (a()) {
            return this.f26o.l;
        }
        return null;
    }

    public N70 getShapeAppearanceModel() {
        if (a()) {
            return this.f26o.b;
        }
        throw new IllegalStateException("Attempted to get ShapeAppearanceModel from a MaterialButton which has an overwritten background.");
    }

    public ColorStateList getStrokeColor() {
        if (a()) {
            return this.f26o.k;
        }
        return null;
    }

    public int getStrokeWidth() {
        if (a()) {
            return this.f26o.h;
        }
        return 0;
    }

    @Override // o.C2784w7
    public ColorStateList getSupportBackgroundTintList() {
        return a() ? this.f26o.j : super.getSupportBackgroundTintList();
    }

    @Override // o.C2784w7
    public PorterDuff.Mode getSupportBackgroundTintMode() {
        return a() ? this.f26o.i : super.getSupportBackgroundTintMode();
    }

    @Override // android.widget.Checkable
    public final boolean isChecked() {
        return this.z;
    }

    @Override // android.widget.TextView, android.view.View
    public final void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (a()) {
            AbstractC2841wm0.D(this, this.f26o.b(false));
        }
    }

    @Override // android.widget.TextView, android.view.View
    public final int[] onCreateDrawableState(int i) {
        int[] iArrOnCreateDrawableState = super.onCreateDrawableState(i + 2);
        NN nn = this.f26o;
        if (nn != null && nn.q) {
            View.mergeDrawableStates(iArrOnCreateDrawableState, C);
        }
        if (this.z) {
            View.mergeDrawableStates(iArrOnCreateDrawableState, D);
        }
        return iArrOnCreateDrawableState;
    }

    @Override // o.C2784w7, android.view.View
    public final void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(getA11yClassName());
        accessibilityEvent.setChecked(this.z);
    }

    @Override // o.C2784w7, android.view.View
    public final void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(getA11yClassName());
        NN nn = this.f26o;
        accessibilityNodeInfo.setCheckable(nn != null && nn.q);
        accessibilityNodeInfo.setChecked(this.z);
        accessibilityNodeInfo.setClickable(isClickable());
    }

    @Override // o.C2784w7, android.widget.TextView, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        d(getMeasuredWidth(), getMeasuredHeight());
    }

    @Override // android.widget.TextView, android.view.View
    public final void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof MN)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        MN mn = (MN) parcelable;
        super.onRestoreInstanceState(mn.l);
        setChecked(mn.n);
    }

    @Override // android.widget.TextView, android.view.View
    public final Parcelable onSaveInstanceState() {
        MN mn = new MN(super.onSaveInstanceState());
        mn.n = this.z;
        return mn;
    }

    @Override // o.C2784w7, android.widget.TextView
    public final void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        super.onTextChanged(charSequence, i, i2, i3);
        d(getMeasuredWidth(), getMeasuredHeight());
    }

    @Override // android.view.View
    public final boolean performClick() {
        if (this.f26o.r) {
            toggle();
        }
        return super.performClick();
    }

    @Override // android.view.View
    public final void refreshDrawableState() {
        super.refreshDrawableState();
        if (this.t != null) {
            if (this.t.setState(getDrawableState())) {
                invalidate();
            }
        }
    }

    public void setA11yClassName(String str) {
        this.u = str;
    }

    @Override // android.view.View
    public void setBackground(Drawable drawable) {
        setBackgroundDrawable(drawable);
    }

    @Override // android.view.View
    public void setBackgroundColor(int i) {
        if (!a()) {
            super.setBackgroundColor(i);
            return;
        }
        NN nn = this.f26o;
        if (nn.b(false) != null) {
            nn.b(false).setTint(i);
        }
    }

    @Override // o.C2784w7, android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        if (!a()) {
            super.setBackgroundDrawable(drawable);
            return;
        }
        if (drawable == getBackground()) {
            getBackground().setState(drawable.getState());
            return;
        }
        NN nn = this.f26o;
        nn.f256o = true;
        MaterialButton materialButton = nn.a;
        materialButton.setSupportBackgroundTintList(nn.j);
        materialButton.setSupportBackgroundTintMode(nn.i);
        super.setBackgroundDrawable(drawable);
    }

    @Override // o.C2784w7, android.view.View
    public void setBackgroundResource(int i) {
        setBackgroundDrawable(i != 0 ? C80.x(getContext(), i) : null);
    }

    @Override // android.view.View
    public void setBackgroundTintList(ColorStateList colorStateList) {
        setSupportBackgroundTintList(colorStateList);
    }

    @Override // android.view.View
    public void setBackgroundTintMode(PorterDuff.Mode mode) {
        setSupportBackgroundTintMode(mode);
    }

    public void setCheckable(boolean z) {
        if (a()) {
            this.f26o.q = z;
        }
    }

    @Override // android.widget.Checkable
    public void setChecked(boolean z) {
        NN nn = this.f26o;
        if (nn == null || !nn.q || !isEnabled() || this.z == z) {
            return;
        }
        this.z = z;
        refreshDrawableState();
        if (getParent() instanceof MaterialButtonToggleGroup) {
            MaterialButtonToggleGroup materialButtonToggleGroup = (MaterialButtonToggleGroup) getParent();
            boolean z2 = this.z;
            if (!materialButtonToggleGroup.q) {
                materialButtonToggleGroup.b(getId(), z2);
            }
        }
        if (this.A) {
            return;
        }
        this.A = true;
        Iterator it = this.p.iterator();
        if (it.hasNext()) {
            it.next().getClass();
            throw new ClassCastException();
        }
        this.A = false;
    }

    public void setCornerRadius(int i) {
        if (a()) {
            NN nn = this.f26o;
            if (nn.p && nn.g == i) {
                return;
            }
            nn.g = i;
            nn.p = true;
            float f = i;
            M70 m70E = nn.b.e();
            m70E.e = new C1915n(f);
            m70E.f = new C1915n(f);
            m70E.g = new C1915n(f);
            m70E.h = new C1915n(f);
            nn.c(m70E.a());
        }
    }

    public void setCornerRadiusResource(int i) {
        if (a()) {
            setCornerRadius(getResources().getDimensionPixelSize(i));
        }
    }

    @Override // android.view.View
    public void setElevation(float f) {
        super.setElevation(f);
        if (a()) {
            this.f26o.b(false).i(f);
        }
    }

    public void setIcon(Drawable drawable) {
        if (this.t != drawable) {
            this.t = drawable;
            c(true);
            d(getMeasuredWidth(), getMeasuredHeight());
        }
    }

    public void setIconGravity(int i) {
        if (this.B != i) {
            this.B = i;
            d(getMeasuredWidth(), getMeasuredHeight());
        }
    }

    public void setIconPadding(int i) {
        if (this.y != i) {
            this.y = i;
            setCompoundDrawablePadding(i);
        }
    }

    public void setIconResource(int i) {
        setIcon(i != 0 ? C80.x(getContext(), i) : null);
    }

    public void setIconSize(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("iconSize cannot be less than 0");
        }
        if (this.v != i) {
            this.v = i;
            c(true);
        }
    }

    public void setIconTint(ColorStateList colorStateList) {
        if (this.s != colorStateList) {
            this.s = colorStateList;
            c(false);
        }
    }

    public void setIconTintMode(PorterDuff.Mode mode) {
        if (this.r != mode) {
            this.r = mode;
            c(false);
        }
    }

    public void setIconTintResource(int i) {
        setIconTint(Co0.z(getContext(), i));
    }

    public void setInsetBottom(int i) {
        NN nn = this.f26o;
        nn.d(nn.e, i);
    }

    public void setInsetTop(int i) {
        NN nn = this.f26o;
        nn.d(i, nn.f);
    }

    public void setInternalBackground(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
    }

    public void setOnPressedChangeListenerInternal(LN ln) {
        this.q = ln;
    }

    @Override // android.view.View
    public void setPressed(boolean z) {
        LN ln = this.q;
        if (ln != null) {
            ((MaterialButtonToggleGroup) ((C0247Jn) ln).m).invalidate();
        }
        super.setPressed(z);
    }

    public void setRippleColor(ColorStateList colorStateList) {
        if (a()) {
            NN nn = this.f26o;
            MaterialButton materialButton = nn.a;
            if (nn.l != colorStateList) {
                nn.l = colorStateList;
                if (materialButton.getBackground() instanceof RippleDrawable) {
                    ((RippleDrawable) materialButton.getBackground()).setColor(AbstractC1904ms0.u(colorStateList));
                }
            }
        }
    }

    public void setRippleColorResource(int i) {
        if (a()) {
            setRippleColor(Co0.z(getContext(), i));
        }
    }

    @Override // o.InterfaceC0693a80
    public void setShapeAppearanceModel(N70 n70) {
        if (!a()) {
            throw new IllegalStateException("Attempted to set ShapeAppearanceModel on a MaterialButton which has an overwritten background.");
        }
        this.f26o.c(n70);
    }

    public void setShouldDrawSurfaceColorStroke(boolean z) {
        if (a()) {
            NN nn = this.f26o;
            nn.n = z;
            nn.f();
        }
    }

    public void setStrokeColor(ColorStateList colorStateList) {
        if (a()) {
            NN nn = this.f26o;
            if (nn.k != colorStateList) {
                nn.k = colorStateList;
                nn.f();
            }
        }
    }

    public void setStrokeColorResource(int i) {
        if (a()) {
            setStrokeColor(Co0.z(getContext(), i));
        }
    }

    public void setStrokeWidth(int i) {
        if (a()) {
            NN nn = this.f26o;
            if (nn.h != i) {
                nn.h = i;
                nn.f();
            }
        }
    }

    public void setStrokeWidthResource(int i) {
        if (a()) {
            setStrokeWidth(getResources().getDimensionPixelSize(i));
        }
    }

    @Override // o.C2784w7
    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        if (!a()) {
            super.setSupportBackgroundTintList(colorStateList);
            return;
        }
        NN nn = this.f26o;
        if (nn.j != colorStateList) {
            nn.j = colorStateList;
            if (nn.b(false) != null) {
                nn.b(false).setTintList(nn.j);
            }
        }
    }

    @Override // o.C2784w7
    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        if (!a()) {
            super.setSupportBackgroundTintMode(mode);
            return;
        }
        NN nn = this.f26o;
        if (nn.i != mode) {
            nn.i = mode;
            if (nn.b(false) == null || nn.i == null) {
                return;
            }
            nn.b(false).setTintMode(nn.i);
        }
    }

    @Override // android.view.View
    public void setTextAlignment(int i) {
        super.setTextAlignment(i);
        d(getMeasuredWidth(), getMeasuredHeight());
    }

    public void setToggleCheckedStateOnClick(boolean z) {
        this.f26o.r = z;
    }

    @Override // android.widget.Checkable
    public final void toggle() {
        setChecked(!this.z);
    }
}
