package com.google.android.material.appbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.Menu;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.Toolbar;
import com.google.android.gms.common.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;
import o.AbstractC2378rs0;
import o.AbstractC2841wm0;
import o.C1092eO;
import o.C1746lA;
import o.C80;
import o.CO;
import o.Co0;
import o.Gj0;
import o.Oj0;
import o.XZ;
import o.YT;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class MaterialToolbar extends Toolbar {
    public static final ImageView.ScaleType[] n0 = {ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    public Integer i0;
    public boolean j0;
    public boolean k0;
    public ImageView.ScaleType l0;
    public Boolean m0;

    public MaterialToolbar(Context context, AttributeSet attributeSet) {
        super(AbstractC2378rs0.n0(context, attributeSet, R.attr.toolbarStyle, R.style.Widget_MaterialComponents_Toolbar), attributeSet, 0);
        Context context2 = getContext();
        TypedArray typedArrayI = YT.I(context2, attributeSet, XZ.s, R.attr.toolbarStyle, R.style.Widget_MaterialComponents_Toolbar, new int[0]);
        if (typedArrayI.hasValue(2)) {
            setNavigationIconTint(typedArrayI.getColor(2, -1));
        }
        this.j0 = typedArrayI.getBoolean(4, false);
        this.k0 = typedArrayI.getBoolean(3, false);
        int i = typedArrayI.getInt(1, -1);
        if (i >= 0) {
            ImageView.ScaleType[] scaleTypeArr = n0;
            if (i < scaleTypeArr.length) {
                this.l0 = scaleTypeArr[i];
            }
        }
        if (typedArrayI.hasValue(0)) {
            this.m0 = Boolean.valueOf(typedArrayI.getBoolean(0, false));
        }
        typedArrayI.recycle();
        Drawable background = getBackground();
        ColorStateList colorStateListValueOf = background == null ? ColorStateList.valueOf(0) : Co0.A(background);
        if (colorStateListValueOf != null) {
            C1092eO c1092eO = new C1092eO();
            c1092eO.j(colorStateListValueOf);
            c1092eO.h(context2);
            WeakHashMap weakHashMap = Oj0.a;
            c1092eO.i(Gj0.e(this));
            setBackground(c1092eO);
        }
    }

    public ImageView.ScaleType getLogoScaleType() {
        return this.l0;
    }

    public Integer getNavigationIconTint() {
        return this.i0;
    }

    @Override // androidx.appcompat.widget.Toolbar
    public final void m(int i) {
        Menu menu = getMenu();
        boolean z = menu instanceof CO;
        if (z) {
            ((CO) menu).w();
        }
        super.m(i);
        if (z) {
            ((CO) menu).v();
        }
    }

    @Override // androidx.appcompat.widget.Toolbar, android.view.ViewGroup, android.view.View
    public final void onAttachedToWindow() {
        super.onAttachedToWindow();
        Drawable background = getBackground();
        if (background instanceof C1092eO) {
            AbstractC2841wm0.D(this, (C1092eO) background);
        }
    }

    @Override // androidx.appcompat.widget.Toolbar, android.view.ViewGroup, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        ImageView imageView;
        Drawable drawable;
        super.onLayout(z, i, i2, i3, i4);
        C1746lA c1746lA = C80.g;
        int i5 = 0;
        ImageView imageView2 = null;
        if (this.j0 || this.k0) {
            ArrayList arrayListB = C80.B(this, getTitle());
            TextView textView = arrayListB.isEmpty() ? null : (TextView) Collections.min(arrayListB, c1746lA);
            ArrayList arrayListB2 = C80.B(this, getSubtitle());
            TextView textView2 = arrayListB2.isEmpty() ? null : (TextView) Collections.max(arrayListB2, c1746lA);
            if (textView != null || textView2 != null) {
                int measuredWidth = getMeasuredWidth();
                int i6 = measuredWidth / 2;
                int paddingLeft = getPaddingLeft();
                int paddingRight = measuredWidth - getPaddingRight();
                for (int i7 = 0; i7 < getChildCount(); i7++) {
                    View childAt = getChildAt(i7);
                    if (childAt.getVisibility() != 8 && childAt != textView && childAt != textView2) {
                        if (childAt.getRight() < i6 && childAt.getRight() > paddingLeft) {
                            paddingLeft = childAt.getRight();
                        }
                        if (childAt.getLeft() > i6 && childAt.getLeft() < paddingRight) {
                            paddingRight = childAt.getLeft();
                        }
                    }
                }
                Pair pair = new Pair(Integer.valueOf(paddingLeft), Integer.valueOf(paddingRight));
                if (this.j0 && textView != null) {
                    x(textView, pair);
                }
                if (this.k0 && textView2 != null) {
                    x(textView2, pair);
                }
            }
        }
        Drawable logo = getLogo();
        if (logo != null) {
            while (true) {
                if (i5 >= getChildCount()) {
                    break;
                }
                View childAt2 = getChildAt(i5);
                if ((childAt2 instanceof ImageView) && (drawable = (imageView = (ImageView) childAt2).getDrawable()) != null && drawable.getConstantState() != null && drawable.getConstantState().equals(logo.getConstantState())) {
                    imageView2 = imageView;
                    break;
                }
                i5++;
            }
        }
        if (imageView2 != null) {
            Boolean bool = this.m0;
            if (bool != null) {
                imageView2.setAdjustViewBounds(bool.booleanValue());
            }
            ImageView.ScaleType scaleType = this.l0;
            if (scaleType != null) {
                imageView2.setScaleType(scaleType);
            }
        }
    }

    @Override // android.view.View
    public void setElevation(float f) {
        super.setElevation(f);
        Drawable background = getBackground();
        if (background instanceof C1092eO) {
            ((C1092eO) background).i(f);
        }
    }

    public void setLogoAdjustViewBounds(boolean z) {
        Boolean bool = this.m0;
        if (bool == null || bool.booleanValue() != z) {
            this.m0 = Boolean.valueOf(z);
            requestLayout();
        }
    }

    public void setLogoScaleType(ImageView.ScaleType scaleType) {
        if (this.l0 != scaleType) {
            this.l0 = scaleType;
            requestLayout();
        }
    }

    @Override // androidx.appcompat.widget.Toolbar
    public void setNavigationIcon(Drawable drawable) {
        if (drawable != null && this.i0 != null) {
            drawable = drawable.mutate();
            drawable.setTint(this.i0.intValue());
        }
        super.setNavigationIcon(drawable);
    }

    public void setNavigationIconTint(int i) {
        this.i0 = Integer.valueOf(i);
        Drawable navigationIcon = getNavigationIcon();
        if (navigationIcon != null) {
            setNavigationIcon(navigationIcon);
        }
    }

    public void setSubtitleCentered(boolean z) {
        if (this.k0 != z) {
            this.k0 = z;
            requestLayout();
        }
    }

    public void setTitleCentered(boolean z) {
        if (this.j0 != z) {
            this.j0 = z;
            requestLayout();
        }
    }

    public final void x(TextView textView, Pair pair) {
        int measuredWidth = getMeasuredWidth();
        int measuredWidth2 = textView.getMeasuredWidth();
        int i = (measuredWidth / 2) - (measuredWidth2 / 2);
        int i2 = measuredWidth2 + i;
        int iMax = Math.max(Math.max(((Integer) pair.first).intValue() - i, 0), Math.max(i2 - ((Integer) pair.second).intValue(), 0));
        if (iMax > 0) {
            i += iMax;
            i2 -= iMax;
            textView.measure(View.MeasureSpec.makeMeasureSpec(i2 - i, 1073741824), textView.getMeasuredHeightAndState());
        }
        textView.layout(i, textView.getTop(), i2, textView.getBottom());
    }
}
