package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import o.AbstractBinderC1898mp0;
import o.Ap0;
import o.Au0;
import o.BinderC1385hT;
import o.C0308Lx;
import o.C0952ct0;
import o.C1390hY;
import o.C1431ht0;
import o.C1839m9;
import o.C1984nl;
import o.C2191pt0;
import o.C2574tv0;
import o.C2616uQ;
import o.C2752vp0;
import o.C2944xq0;
import o.C70;
import o.Cp0;
import o.Cs0;
import o.Dp0;
import o.EnumC1143et0;
import o.Ep0;
import o.Fr0;
import o.Gu0;
import o.Gv0;
import o.Hr0;
import o.Hs0;
import o.InterfaceC1180fG;
import o.InterfaceC2183pp0;
import o.InterfaceC2372rp0;
import o.InterfaceC2568ts0;
import o.Is0;
import o.Js0;
import o.Kr0;
import o.Lo0;
import o.No0;
import o.Nq0;
import o.RunnableC0266Kg;
import o.RunnableC3138zs0;
import o.Sq0;
import o.Xs0;
import o.Zq0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class AppMeasurementDynamiteService extends AbstractBinderC1898mp0 {
    public Kr0 d;
    public final C1839m9 e;

    public AppMeasurementDynamiteService() {
        super("com.google.android.gms.measurement.api.internal.IAppMeasurementDynamiteService");
        this.d = null;
        this.e = new C1839m9(0);
    }

    public final void C() {
        if (this.d == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public final void D(String str, InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        C2574tv0 c2574tv0 = this.d.i;
        Kr0.j(c2574tv0);
        c2574tv0.Z(str, interfaceC2183pp0);
    }

    @Override // o.InterfaceC1993np0
    public void beginAdUnitExposure(String str, long j) {
        C();
        C2752vp0 c2752vp0 = this.d.n;
        Kr0.i(c2752vp0);
        c2752vp0.t(str, j);
    }

    @Override // o.InterfaceC1993np0
    public void clearConditionalUserProperty(String str, String str2, Bundle bundle) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.G(str, str2, bundle);
    }

    @Override // o.InterfaceC1993np0
    public void clearMeasurementEnabled(long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.t();
        Fr0 fr0 = ((Kr0) xs0.a).g;
        Kr0.l(fr0);
        fr0.B(new Js0(1, xs0, (Object) null));
    }

    @Override // o.InterfaceC1993np0
    public void endAdUnitExposure(String str, long j) {
        C();
        C2752vp0 c2752vp0 = this.d.n;
        Kr0.i(c2752vp0);
        c2752vp0.u(str, j);
    }

    @Override // o.InterfaceC1993np0
    public void generateEventId(InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        C2574tv0 c2574tv0 = this.d.i;
        Kr0.j(c2574tv0);
        long jN0 = c2574tv0.n0();
        C();
        C2574tv0 c2574tv02 = this.d.i;
        Kr0.j(c2574tv02);
        c2574tv02.a0(interfaceC2183pp0, jN0);
    }

    @Override // o.InterfaceC1993np0
    public void getAppInstanceId(InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Fr0 fr0 = this.d.g;
        Kr0.l(fr0);
        fr0.B(new Hr0(this, interfaceC2183pp0, 0));
    }

    @Override // o.InterfaceC1993np0
    public void getCachedAppInstanceId(InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        D((String) xs0.g.get(), interfaceC2183pp0);
    }

    @Override // o.InterfaceC1993np0
    public void getConditionalUserProperties(String str, String str2, InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Fr0 fr0 = this.d.g;
        Kr0.l(fr0);
        fr0.B(new RunnableC0266Kg(this, interfaceC2183pp0, str, str2, 6));
    }

    @Override // o.InterfaceC1993np0
    public void getCurrentScreenClass(InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        C2191pt0 c2191pt0 = ((Kr0) xs0.a).l;
        Kr0.k(c2191pt0);
        C1431ht0 c1431ht0 = c2191pt0.c;
        D(c1431ht0 != null ? c1431ht0.b : null, interfaceC2183pp0);
    }

    @Override // o.InterfaceC1993np0
    public void getCurrentScreenName(InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        C2191pt0 c2191pt0 = ((Kr0) xs0.a).l;
        Kr0.k(c2191pt0);
        C1431ht0 c1431ht0 = c2191pt0.c;
        D(c1431ht0 != null ? c1431ht0.a : null, interfaceC2183pp0);
    }

    @Override // o.InterfaceC1993np0
    public void getGmpAppId(InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        D(xs0.H(), interfaceC2183pp0);
    }

    @Override // o.InterfaceC1993np0
    public void getMaxUserProperties(String str, InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        Preconditions.checkNotEmpty(str);
        ((Kr0) xs0.a).getClass();
        C();
        C2574tv0 c2574tv0 = this.d.i;
        Kr0.j(c2574tv0);
        c2574tv0.b0(interfaceC2183pp0, 25);
    }

    @Override // o.InterfaceC1993np0
    public void getSessionId(InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        Fr0 fr0 = ((Kr0) xs0.a).g;
        Kr0.l(fr0);
        fr0.B(new Js0(xs0, interfaceC2183pp0));
    }

    @Override // o.InterfaceC1993np0
    public void getTestFlag(InterfaceC2183pp0 interfaceC2183pp0, int i) {
        C();
        if (i == 0) {
            C2574tv0 c2574tv0 = this.d.i;
            Kr0.j(c2574tv0);
            Xs0 xs0 = this.d.m;
            Kr0.k(xs0);
            AtomicReference atomicReference = new AtomicReference();
            Fr0 fr0 = ((Kr0) xs0.a).g;
            Kr0.l(fr0);
            c2574tv0.Z((String) fr0.C(atomicReference, 15000L, "String test flag value", new Hs0(xs0, atomicReference, 1)), interfaceC2183pp0);
            return;
        }
        if (i == 1) {
            C2574tv0 c2574tv02 = this.d.i;
            Kr0.j(c2574tv02);
            Xs0 xs02 = this.d.m;
            Kr0.k(xs02);
            AtomicReference atomicReference2 = new AtomicReference();
            Fr0 fr02 = ((Kr0) xs02.a).g;
            Kr0.l(fr02);
            c2574tv02.a0(interfaceC2183pp0, ((Long) fr02.C(atomicReference2, 15000L, "long test flag value", new Hs0(xs02, atomicReference2, 2))).longValue());
            return;
        }
        if (i == 2) {
            C2574tv0 c2574tv03 = this.d.i;
            Kr0.j(c2574tv03);
            Xs0 xs03 = this.d.m;
            Kr0.k(xs03);
            AtomicReference atomicReference3 = new AtomicReference();
            Fr0 fr03 = ((Kr0) xs03.a).g;
            Kr0.l(fr03);
            double dDoubleValue = ((Double) fr03.C(atomicReference3, 15000L, "double test flag value", new Hs0(xs03, atomicReference3, 4))).doubleValue();
            Bundle bundle = new Bundle();
            bundle.putDouble("r", dDoubleValue);
            try {
                interfaceC2183pp0.k(bundle);
                return;
            } catch (RemoteException e) {
                Nq0 nq0 = ((Kr0) c2574tv03.a).f;
                Kr0.l(nq0);
                nq0.i.c(e, "Error returning double value to wrapper");
                return;
            }
        }
        if (i == 3) {
            C2574tv0 c2574tv04 = this.d.i;
            Kr0.j(c2574tv04);
            Xs0 xs04 = this.d.m;
            Kr0.k(xs04);
            AtomicReference atomicReference4 = new AtomicReference();
            Fr0 fr04 = ((Kr0) xs04.a).g;
            Kr0.l(fr04);
            c2574tv04.b0(interfaceC2183pp0, ((Integer) fr04.C(atomicReference4, 15000L, "int test flag value", new Hs0(xs04, atomicReference4, 3))).intValue());
            return;
        }
        if (i != 4) {
            return;
        }
        C2574tv0 c2574tv05 = this.d.i;
        Kr0.j(c2574tv05);
        Xs0 xs05 = this.d.m;
        Kr0.k(xs05);
        AtomicReference atomicReference5 = new AtomicReference();
        Fr0 fr05 = ((Kr0) xs05.a).g;
        Kr0.l(fr05);
        c2574tv05.d0(interfaceC2183pp0, ((Boolean) fr05.C(atomicReference5, 15000L, "boolean test flag value", new Hs0(xs05, atomicReference5, 0))).booleanValue());
    }

    @Override // o.InterfaceC1993np0
    public void getUserProperties(String str, String str2, boolean z, InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Fr0 fr0 = this.d.g;
        Kr0.l(fr0);
        fr0.B(new Zq0(this, interfaceC2183pp0, str, str2, z));
    }

    @Override // o.InterfaceC1993np0
    public void initForTests(Map map) {
        C();
    }

    @Override // o.InterfaceC1993np0
    public void initialize(InterfaceC1180fG interfaceC1180fG, Dp0 dp0, long j) {
        Kr0 kr0 = this.d;
        if (kr0 == null) {
            this.d = Kr0.r((Context) Preconditions.checkNotNull((Context) BinderC1385hT.C(interfaceC1180fG)), dp0, Long.valueOf(j));
            return;
        }
        Nq0 nq0 = kr0.f;
        Kr0.l(nq0);
        nq0.i.b("Attempting to initialize multiple times");
    }

    @Override // o.InterfaceC1993np0
    public void isDataCollectionEnabled(InterfaceC2183pp0 interfaceC2183pp0) {
        C();
        Fr0 fr0 = this.d.g;
        Kr0.l(fr0);
        fr0.B(new Hr0(this, interfaceC2183pp0, 1));
    }

    @Override // o.InterfaceC1993np0
    public void logEvent(String str, String str2, Bundle bundle, boolean z, boolean z2, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.x(str, str2, bundle, z, z2, j);
    }

    @Override // o.InterfaceC1993np0
    public void logEventAndBundle(String str, String str2, Bundle bundle, InterfaceC2183pp0 interfaceC2183pp0, long j) {
        C();
        Preconditions.checkNotEmpty(str2);
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", "app");
        No0 no0 = new No0(str2, new Lo0(bundle), "app", j);
        Fr0 fr0 = this.d.g;
        Kr0.l(fr0);
        fr0.B(new RunnableC0266Kg(this, interfaceC2183pp0, no0, str, 3));
    }

    @Override // o.InterfaceC1993np0
    public void logHealthData(int i, String str, InterfaceC1180fG interfaceC1180fG, InterfaceC1180fG interfaceC1180fG2, InterfaceC1180fG interfaceC1180fG3) {
        C();
        Object objC = interfaceC1180fG == null ? null : BinderC1385hT.C(interfaceC1180fG);
        Object objC2 = interfaceC1180fG2 == null ? null : BinderC1385hT.C(interfaceC1180fG2);
        Object objC3 = interfaceC1180fG3 != null ? BinderC1385hT.C(interfaceC1180fG3) : null;
        Nq0 nq0 = this.d.f;
        Kr0.l(nq0);
        nq0.B(i, true, false, str, objC, objC2, objC3);
    }

    @Override // o.InterfaceC1993np0
    public void onActivityCreated(InterfaceC1180fG interfaceC1180fG, Bundle bundle, long j) {
        C();
        onActivityCreatedByScionActivityInfo(Ep0.b((Activity) Preconditions.checkNotNull((Activity) BinderC1385hT.C(interfaceC1180fG))), bundle, j);
    }

    @Override // o.InterfaceC1993np0
    public void onActivityCreatedByScionActivityInfo(Ep0 ep0, Bundle bundle, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        C0308Lx c0308Lx = xs0.c;
        if (c0308Lx != null) {
            Xs0 xs02 = this.d.m;
            Kr0.k(xs02);
            xs02.L();
            c0308Lx.j(ep0, bundle);
        }
    }

    @Override // o.InterfaceC1993np0
    public void onActivityDestroyed(InterfaceC1180fG interfaceC1180fG, long j) {
        C();
        onActivityDestroyedByScionActivityInfo(Ep0.b((Activity) Preconditions.checkNotNull((Activity) BinderC1385hT.C(interfaceC1180fG))), j);
    }

    @Override // o.InterfaceC1993np0
    public void onActivityDestroyedByScionActivityInfo(Ep0 ep0, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        C0308Lx c0308Lx = xs0.c;
        if (c0308Lx != null) {
            Xs0 xs02 = this.d.m;
            Kr0.k(xs02);
            xs02.L();
            c0308Lx.k(ep0);
        }
    }

    @Override // o.InterfaceC1993np0
    public void onActivityPaused(InterfaceC1180fG interfaceC1180fG, long j) {
        C();
        onActivityPausedByScionActivityInfo(Ep0.b((Activity) Preconditions.checkNotNull((Activity) BinderC1385hT.C(interfaceC1180fG))), j);
    }

    @Override // o.InterfaceC1993np0
    public void onActivityPausedByScionActivityInfo(Ep0 ep0, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        C0308Lx c0308Lx = xs0.c;
        if (c0308Lx != null) {
            Xs0 xs02 = this.d.m;
            Kr0.k(xs02);
            xs02.L();
            c0308Lx.l(ep0);
        }
    }

    @Override // o.InterfaceC1993np0
    public void onActivityResumed(InterfaceC1180fG interfaceC1180fG, long j) {
        C();
        onActivityResumedByScionActivityInfo(Ep0.b((Activity) Preconditions.checkNotNull((Activity) BinderC1385hT.C(interfaceC1180fG))), j);
    }

    @Override // o.InterfaceC1993np0
    public void onActivityResumedByScionActivityInfo(Ep0 ep0, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        C0308Lx c0308Lx = xs0.c;
        if (c0308Lx != null) {
            Xs0 xs02 = this.d.m;
            Kr0.k(xs02);
            xs02.L();
            c0308Lx.m(ep0);
        }
    }

    @Override // o.InterfaceC1993np0
    public void onActivitySaveInstanceState(InterfaceC1180fG interfaceC1180fG, InterfaceC2183pp0 interfaceC2183pp0, long j) {
        C();
        onActivitySaveInstanceStateByScionActivityInfo(Ep0.b((Activity) Preconditions.checkNotNull((Activity) BinderC1385hT.C(interfaceC1180fG))), interfaceC2183pp0, j);
    }

    @Override // o.InterfaceC1993np0
    public void onActivitySaveInstanceStateByScionActivityInfo(Ep0 ep0, InterfaceC2183pp0 interfaceC2183pp0, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        C0308Lx c0308Lx = xs0.c;
        Bundle bundle = new Bundle();
        if (c0308Lx != null) {
            Xs0 xs02 = this.d.m;
            Kr0.k(xs02);
            xs02.L();
            c0308Lx.n(ep0, bundle);
        }
        try {
            interfaceC2183pp0.k(bundle);
        } catch (RemoteException e) {
            Nq0 nq0 = this.d.f;
            Kr0.l(nq0);
            nq0.i.c(e, "Error returning bundle value to wrapper");
        }
    }

    @Override // o.InterfaceC1993np0
    public void onActivityStarted(InterfaceC1180fG interfaceC1180fG, long j) {
        C();
        onActivityStartedByScionActivityInfo(Ep0.b((Activity) Preconditions.checkNotNull((Activity) BinderC1385hT.C(interfaceC1180fG))), j);
    }

    @Override // o.InterfaceC1993np0
    public void onActivityStartedByScionActivityInfo(Ep0 ep0, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        if (xs0.c != null) {
            Xs0 xs02 = this.d.m;
            Kr0.k(xs02);
            xs02.L();
        }
    }

    @Override // o.InterfaceC1993np0
    public void onActivityStopped(InterfaceC1180fG interfaceC1180fG, long j) {
        C();
        onActivityStoppedByScionActivityInfo(Ep0.b((Activity) Preconditions.checkNotNull((Activity) BinderC1385hT.C(interfaceC1180fG))), j);
    }

    @Override // o.InterfaceC1993np0
    public void onActivityStoppedByScionActivityInfo(Ep0 ep0, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        if (xs0.c != null) {
            Xs0 xs02 = this.d.m;
            Kr0.k(xs02);
            xs02.L();
        }
    }

    @Override // o.InterfaceC1993np0
    public void performAction(Bundle bundle, InterfaceC2183pp0 interfaceC2183pp0, long j) {
        C();
        interfaceC2183pp0.k(null);
    }

    @Override // o.InterfaceC1993np0
    public void registerOnMeasurementEventListener(Ap0 ap0) {
        Object gv0;
        C();
        C1839m9 c1839m9 = this.e;
        synchronized (c1839m9) {
            try {
                gv0 = (InterfaceC2568ts0) c1839m9.get(Integer.valueOf(ap0.a()));
                if (gv0 == null) {
                    gv0 = new Gv0(this, ap0);
                    c1839m9.put(Integer.valueOf(ap0.a()), gv0);
                }
            } catch (Throwable th) {
                throw th;
            }
        }
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.t();
        Preconditions.checkNotNull(gv0);
        if (xs0.e.add(gv0)) {
            return;
        }
        Nq0 nq0 = ((Kr0) xs0.a).f;
        Kr0.l(nq0);
        nq0.i.b("OnEventListener already registered");
    }

    @Override // o.InterfaceC1993np0
    public void resetAnalyticsData(long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.g.set(null);
        Fr0 fr0 = ((Kr0) xs0.a).g;
        Kr0.l(fr0);
        fr0.B(new Cs0(xs0, j, 1));
    }

    @Override // o.InterfaceC1993np0
    public void retrieveAndUploadBatches(InterfaceC2372rp0 interfaceC2372rp0) throws MalformedURLException {
        EnumC1143et0 enumC1143et0;
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.t();
        Kr0 kr0 = (Kr0) xs0.a;
        Fr0 fr0 = kr0.g;
        Kr0.l(fr0);
        if (fr0.y()) {
            Nq0 nq0 = kr0.f;
            Kr0.l(nq0);
            nq0.f.b("Cannot retrieve and upload batches from analytics worker thread");
            return;
        }
        Fr0 fr02 = kr0.g;
        Kr0.l(fr02);
        if (Thread.currentThread() == fr02.d) {
            Nq0 nq02 = kr0.f;
            Kr0.l(nq02);
            nq02.f.b("Cannot retrieve and upload batches from analytics network thread");
            return;
        }
        if (C2616uQ.x()) {
            Nq0 nq03 = kr0.f;
            Kr0.l(nq03);
            nq03.f.b("Cannot retrieve and upload batches from main thread");
            return;
        }
        Nq0 nq04 = kr0.f;
        Kr0.l(nq04);
        nq04.n.b("[sgtm] Started client-side batch upload work.");
        boolean z = false;
        int size = 0;
        int i = 0;
        while (!z) {
            Nq0 nq05 = kr0.f;
            Kr0.l(nq05);
            nq05.n.b("[sgtm] Getting upload batches from service (FE)");
            AtomicReference atomicReference = new AtomicReference();
            Fr0 fr03 = kr0.g;
            Kr0.l(fr03);
            fr03.C(atomicReference, 10000L, "[sgtm] Getting upload batches", new Hs0(xs0, atomicReference, 6, false));
            Gu0 gu0 = (Gu0) atomicReference.get();
            if (gu0 == null) {
                break;
            }
            List list = gu0.l;
            if (list.isEmpty()) {
                break;
            }
            Nq0 nq06 = kr0.f;
            Kr0.l(nq06);
            nq06.n.c(Integer.valueOf(list.size()), "[sgtm] Retrieved upload batches. count");
            size += list.size();
            Iterator it = list.iterator();
            while (true) {
                if (!it.hasNext()) {
                    z = false;
                    break;
                }
                Au0 au0 = (Au0) it.next();
                try {
                    URL url = new URI(au0.n).toURL();
                    AtomicReference atomicReference2 = new AtomicReference();
                    C2944xq0 c2944xq0Q = ((Kr0) xs0.a).q();
                    c2944xq0Q.t();
                    Preconditions.checkNotNull(c2944xq0Q.g);
                    String str = c2944xq0Q.g;
                    Kr0 kr02 = (Kr0) xs0.a;
                    Nq0 nq07 = kr02.f;
                    Kr0.l(nq07);
                    C1984nl c1984nl = nq07.n;
                    Long lValueOf = Long.valueOf(au0.l);
                    c1984nl.e("[sgtm] Uploading data from app. row_id, url, uncompressed size", lValueOf, au0.n, Integer.valueOf(au0.m.length));
                    if (!TextUtils.isEmpty(au0.r)) {
                        Nq0 nq08 = kr02.f;
                        Kr0.l(nq08);
                        nq08.n.d("[sgtm] Uploading data from app. row_id", lValueOf, au0.r);
                    }
                    HashMap map = new HashMap();
                    Bundle bundle = au0.f49o;
                    for (String str2 : bundle.keySet()) {
                        String string = bundle.getString(str2);
                        if (!TextUtils.isEmpty(string)) {
                            map.put(str2, string);
                        }
                    }
                    C0952ct0 c0952ct0 = kr02.f198o;
                    Kr0.l(c0952ct0);
                    byte[] bArr = au0.m;
                    C70 c70 = new C70(xs0, atomicReference2, au0, 11);
                    c0952ct0.u();
                    Preconditions.checkNotNull(url);
                    Preconditions.checkNotNull(bArr);
                    Preconditions.checkNotNull(c70);
                    Fr0 fr04 = ((Kr0) c0952ct0.a).g;
                    Kr0.l(fr04);
                    fr04.E(new Sq0(c0952ct0, str, url, bArr, map, c70));
                    try {
                        C2574tv0 c2574tv0 = kr02.i;
                        Kr0.j(c2574tv0);
                        Kr0 kr03 = (Kr0) c2574tv0.a;
                        long jCurrentTimeMillis = kr03.k.currentTimeMillis() + 60000;
                        synchronized (atomicReference2) {
                            for (long jCurrentTimeMillis2 = 60000; atomicReference2.get() == null && jCurrentTimeMillis2 > 0; jCurrentTimeMillis2 = jCurrentTimeMillis - kr03.k.currentTimeMillis()) {
                                try {
                                    atomicReference2.wait(jCurrentTimeMillis2);
                                } catch (Throwable th) {
                                    throw th;
                                }
                            }
                        }
                    } catch (InterruptedException unused) {
                        Nq0 nq09 = ((Kr0) xs0.a).f;
                        Kr0.l(nq09);
                        nq09.i.b("[sgtm] Interrupted waiting for uploading batch");
                    }
                    enumC1143et0 = atomicReference2.get() == null ? EnumC1143et0.m : (EnumC1143et0) atomicReference2.get();
                } catch (MalformedURLException | URISyntaxException e) {
                    Nq0 nq010 = ((Kr0) xs0.a).f;
                    Kr0.l(nq010);
                    nq010.f.e("[sgtm] Bad upload url for row_id", au0.n, Long.valueOf(au0.l), e);
                    enumC1143et0 = EnumC1143et0.f515o;
                }
                if (enumC1143et0 != EnumC1143et0.n) {
                    if (enumC1143et0 == EnumC1143et0.p) {
                        z = true;
                        break;
                    }
                } else {
                    i++;
                }
            }
        }
        Nq0 nq011 = kr0.f;
        Kr0.l(nq011);
        nq011.n.d("[sgtm] Completed client-side batch upload work. total, success", Integer.valueOf(size), Integer.valueOf(i));
        try {
            interfaceC2372rp0.zze();
        } catch (RemoteException e2) {
            Nq0 nq012 = ((Kr0) Preconditions.checkNotNull(this.d)).f;
            Kr0.l(nq012);
            nq012.i.c(e2, "Failed to call IDynamiteUploadBatchesCallback");
        }
    }

    @Override // o.InterfaceC1993np0
    public void setConditionalUserProperty(Bundle bundle, long j) {
        C();
        if (bundle == null) {
            Nq0 nq0 = this.d.f;
            Kr0.l(nq0);
            nq0.f.b("Conditional user property must not be null");
        } else {
            Xs0 xs0 = this.d.m;
            Kr0.k(xs0);
            xs0.F(bundle, j);
        }
    }

    @Override // o.InterfaceC1993np0
    public void setConsentThirdParty(Bundle bundle, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.M(bundle, -20, j);
    }

    @Override // o.InterfaceC1993np0
    public void setCurrentScreen(InterfaceC1180fG interfaceC1180fG, String str, String str2, long j) {
        C();
        setCurrentScreenByScionActivityInfo(Ep0.b((Activity) Preconditions.checkNotNull((Activity) BinderC1385hT.C(interfaceC1180fG))), str, str2, j);
    }

    /* JADX WARN: Code restructure failed: missing block: B:27:0x0088, code lost:
    
        if (r3 <= 500) goto L31;
     */
    /* JADX WARN: Code restructure failed: missing block: B:35:0x00b1, code lost:
    
        if (r3 <= 500) goto L39;
     */
    @Override // o.InterfaceC1993np0
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public void setCurrentScreenByScionActivityInfo(o.Ep0 r6, java.lang.String r7, java.lang.String r8, long r9) {
        /*
            Method dump skipped, instructions count: 243
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: com.google.android.gms.measurement.internal.AppMeasurementDynamiteService.setCurrentScreenByScionActivityInfo(o.Ep0, java.lang.String, java.lang.String, long):void");
    }

    @Override // o.InterfaceC1993np0
    public void setDataCollectionEnabled(boolean z) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.t();
        Fr0 fr0 = ((Kr0) xs0.a).g;
        Kr0.l(fr0);
        fr0.B(new RunnableC3138zs0(xs0, z));
    }

    @Override // o.InterfaceC1993np0
    public void setDefaultEventParameters(Bundle bundle) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        Fr0 fr0 = ((Kr0) xs0.a).g;
        Kr0.l(fr0);
        fr0.B(new Is0(xs0, bundle2, 2));
    }

    @Override // o.InterfaceC1993np0
    public void setEventInterceptor(Ap0 ap0) {
        C();
        C1390hY c1390hY = new C1390hY(this, ap0);
        Fr0 fr0 = this.d.g;
        Kr0.l(fr0);
        if (!fr0.y()) {
            Fr0 fr02 = this.d.g;
            Kr0.l(fr02);
            fr02.B(new Js0(3, this, c1390hY));
            return;
        }
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.r();
        xs0.t();
        C1390hY c1390hY2 = xs0.d;
        if (c1390hY != c1390hY2) {
            Preconditions.checkState(c1390hY2 == null, "EventInterceptor already set.");
        }
        xs0.d = c1390hY;
    }

    @Override // o.InterfaceC1993np0
    public void setInstanceIdProvider(Cp0 cp0) {
        C();
    }

    @Override // o.InterfaceC1993np0
    public void setMeasurementEnabled(boolean z, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        Boolean boolValueOf = Boolean.valueOf(z);
        xs0.t();
        Fr0 fr0 = ((Kr0) xs0.a).g;
        Kr0.l(fr0);
        fr0.B(new Js0(1, xs0, boolValueOf));
    }

    @Override // o.InterfaceC1993np0
    public void setMinimumSessionDuration(long j) {
        C();
    }

    @Override // o.InterfaceC1993np0
    public void setSessionTimeoutDuration(long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        Fr0 fr0 = ((Kr0) xs0.a).g;
        Kr0.l(fr0);
        fr0.B(new Cs0(xs0, j, 0));
    }

    @Override // o.InterfaceC1993np0
    public void setSgtmDebugInfo(Intent intent) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        Kr0 kr0 = (Kr0) xs0.a;
        Uri data = intent.getData();
        if (data == null) {
            Nq0 nq0 = kr0.f;
            Kr0.l(nq0);
            nq0.l.b("Activity intent has no data. Preview Mode was not enabled.");
            return;
        }
        String queryParameter = data.getQueryParameter("sgtm_debug_enable");
        if (queryParameter == null || !queryParameter.equals("1")) {
            Nq0 nq02 = kr0.f;
            Kr0.l(nq02);
            nq02.l.b("[sgtm] Preview Mode was not enabled.");
            kr0.d.c = null;
            return;
        }
        String queryParameter2 = data.getQueryParameter("sgtm_preview_key");
        if (TextUtils.isEmpty(queryParameter2)) {
            return;
        }
        Nq0 nq03 = kr0.f;
        Kr0.l(nq03);
        nq03.l.c(queryParameter2, "[sgtm] Preview Mode was enabled. Using the sgtmPreviewKey: ");
        kr0.d.c = queryParameter2;
    }

    @Override // o.InterfaceC1993np0
    public void setUserId(String str, long j) {
        C();
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        Kr0 kr0 = (Kr0) xs0.a;
        if (str != null && TextUtils.isEmpty(str)) {
            Nq0 nq0 = kr0.f;
            Kr0.l(nq0);
            nq0.i.b("User ID must be non-empty or null");
        } else {
            Fr0 fr0 = kr0.g;
            Kr0.l(fr0);
            fr0.B(new Js0(5, xs0, str));
            xs0.C(null, "_id", str, true, j);
        }
    }

    @Override // o.InterfaceC1993np0
    public void setUserProperty(String str, String str2, InterfaceC1180fG interfaceC1180fG, boolean z, long j) throws SecurityException {
        C();
        Object objC = BinderC1385hT.C(interfaceC1180fG);
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.C(str, str2, objC, z, j);
    }

    @Override // o.InterfaceC1993np0
    public void unregisterOnMeasurementEventListener(Ap0 ap0) {
        Object gv0;
        C();
        C1839m9 c1839m9 = this.e;
        synchronized (c1839m9) {
            gv0 = (InterfaceC2568ts0) c1839m9.remove(Integer.valueOf(ap0.a()));
        }
        if (gv0 == null) {
            gv0 = new Gv0(this, ap0);
        }
        Xs0 xs0 = this.d.m;
        Kr0.k(xs0);
        xs0.t();
        Preconditions.checkNotNull(gv0);
        if (xs0.e.remove(gv0)) {
            return;
        }
        Nq0 nq0 = ((Kr0) xs0.a).f;
        Kr0.l(nq0);
        nq0.i.b("OnEventListener had not been registered");
    }

    @Override // o.InterfaceC1993np0
    public void setConsent(Bundle bundle, long j) {
    }
}
