package com.google.android.gms.measurement;

import android.app.Service;
import android.app.job.JobParameters;
import android.content.Intent;
import android.os.IBinder;
import android.os.PowerManager;
import android.util.SparseArray;
import androidx.legacy.content.WakefulBroadcastReceiver;
import o.BinderC1237fs0;
import o.C1051dv0;
import o.C1696kj0;
import o.Js0;
import o.Kr0;
import o.Nq0;
import o.RunnableC0857bt0;
import o.Zt0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class AppMeasurementService extends Service implements Zt0 {
    public C1696kj0 l;

    @Override // o.Zt0
    public final boolean a(int i) {
        return stopSelfResult(i);
    }

    @Override // o.Zt0
    public final void b(Intent intent) {
        SparseArray sparseArray = WakefulBroadcastReceiver.a;
        int intExtra = intent.getIntExtra("androidx.contentpager.content.wakelockid", 0);
        if (intExtra == 0) {
            return;
        }
        SparseArray sparseArray2 = WakefulBroadcastReceiver.a;
        synchronized (sparseArray2) {
            try {
                PowerManager.WakeLock wakeLock = (PowerManager.WakeLock) sparseArray2.get(intExtra);
                if (wakeLock != null) {
                    wakeLock.release();
                    sparseArray2.remove(intExtra);
                }
            } catch (Throwable th) {
                throw th;
            }
        }
    }

    @Override // o.Zt0
    public final void c(JobParameters jobParameters) {
        throw new UnsupportedOperationException();
    }

    public final C1696kj0 d() {
        if (this.l == null) {
            this.l = new C1696kj0(this);
        }
        return this.l;
    }

    @Override // android.app.Service
    public final IBinder onBind(Intent intent) {
        C1696kj0 c1696kj0D = d();
        c1696kj0D.getClass();
        if (intent == null) {
            return null;
        }
        String action = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(action)) {
            return new BinderC1237fs0(C1051dv0.C((Service) c1696kj0D.m));
        }
        "onBind received unknown action: ".concat(String.valueOf(action));
        return null;
    }

    @Override // android.app.Service
    public final void onCreate() {
        super.onCreate();
        ((Service) d().m).getClass().getSimpleName().concat(" is starting up.");
    }

    @Override // android.app.Service
    public final void onDestroy() {
        ((Service) d().m).getClass().getSimpleName().concat(" is shutting down.");
        super.onDestroy();
    }

    @Override // android.app.Service
    public final void onRebind(Intent intent) {
        d();
        if (intent == null) {
            return;
        }
        "onRebind called. action: ".concat(String.valueOf(intent.getAction()));
    }

    @Override // android.app.Service
    public final int onStartCommand(Intent intent, int i, int i2) {
        C1696kj0 c1696kj0D = d();
        if (intent == null) {
            c1696kj0D.getClass();
            return 2;
        }
        Service service = (Service) c1696kj0D.m;
        Nq0 nq0 = Kr0.r(service, null, null).f;
        Kr0.l(nq0);
        String action = intent.getAction();
        nq0.n.d("Local AppMeasurementService called. startId, action", Integer.valueOf(i2), action);
        if (!"com.google.android.gms.measurement.UPLOAD".equals(action)) {
            return 2;
        }
        RunnableC0857bt0 runnableC0857bt0 = new RunnableC0857bt0(c1696kj0D, i2, nq0, intent);
        C1051dv0 c1051dv0C = C1051dv0.C(service);
        c1051dv0C.c().B(new Js0(c1696kj0D, c1051dv0C, runnableC0857bt0));
        return 2;
    }

    @Override // android.app.Service
    public final boolean onUnbind(Intent intent) {
        d();
        if (intent == null) {
            return true;
        }
        "onUnbind called for intent. action: ".concat(String.valueOf(intent.getAction()));
        return true;
    }
}
