package com.google.android.gms.measurement;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.util.SparseArray;
import androidx.legacy.content.WakefulBroadcastReceiver;
import o.C1696kj0;
import o.Kr0;
import o.Nq0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class AppMeasurementReceiver extends WakefulBroadcastReceiver {
    public C1696kj0 c;

    @Override // android.content.BroadcastReceiver
    public final void onReceive(Context context, Intent intent) {
        if (this.c == null) {
            this.c = new C1696kj0(this);
        }
        C1696kj0 c1696kj0 = this.c;
        c1696kj0.getClass();
        Nq0 nq0 = Kr0.r(context, null, null).f;
        Kr0.l(nq0);
        if (intent == null) {
            nq0.i.b("Receiver called with null intent");
            return;
        }
        String action = intent.getAction();
        nq0.n.c(action, "Local receiver got");
        if (!"com.google.android.gms.measurement.UPLOAD".equals(action)) {
            if ("com.android.vending.INSTALL_REFERRER".equals(action)) {
                nq0.i.b("Install Referrer Broadcasts are deprecated");
                return;
            }
            return;
        }
        Intent className = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
        className.setAction("com.google.android.gms.measurement.UPLOAD");
        nq0.n.b("Starting wakeful intent.");
        ((AppMeasurementReceiver) c1696kj0.m).getClass();
        SparseArray sparseArray = WakefulBroadcastReceiver.a;
        synchronized (sparseArray) {
            try {
                int i = WakefulBroadcastReceiver.b;
                int i2 = i + 1;
                WakefulBroadcastReceiver.b = i2;
                if (i2 <= 0) {
                    WakefulBroadcastReceiver.b = 1;
                }
                className.putExtra("androidx.contentpager.content.wakelockid", i);
                ComponentName componentNameStartService = context.startService(className);
                if (componentNameStartService == null) {
                    return;
                }
                PowerManager.WakeLock wakeLockNewWakeLock = ((PowerManager) context.getSystemService("power")).newWakeLock(1, "androidx.core:wake:" + componentNameStartService.flattenToShortString());
                wakeLockNewWakeLock.setReferenceCounted(false);
                wakeLockNewWakeLock.acquire(60000L);
                sparseArray.put(i, wakeLockNewWakeLock);
            } catch (Throwable th) {
                throw th;
            }
        }
    }
}
