package com.google.android.gms.measurement;

import android.app.Service;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Intent;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Objects;
import o.C1051dv0;
import o.C1696kj0;
import o.C2616uQ;
import o.Fp0;
import o.Js0;
import o.Nq0;
import o.RunnableC0245Jl;
import o.Wp0;
import o.Zt0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class AppMeasurementJobService extends JobService implements Zt0 {
    public C1696kj0 l;

    @Override // o.Zt0
    public final boolean a(int i) {
        throw new UnsupportedOperationException();
    }

    @Override // o.Zt0
    public final void c(JobParameters jobParameters) {
        jobFinished(jobParameters, false);
    }

    public final C1696kj0 d() {
        if (this.l == null) {
            this.l = new C1696kj0(this);
        }
        return this.l;
    }

    @Override // android.app.Service
    public final void onCreate() {
        super.onCreate();
        ((Service) d().m).getClass().getSimpleName().concat(" is starting up.");
    }

    @Override // android.app.Service
    public final void onDestroy() {
        ((Service) d().m).getClass().getSimpleName().concat(" is shutting down.");
        super.onDestroy();
    }

    @Override // android.app.Service
    public final void onRebind(Intent intent) {
        d();
        if (intent == null) {
            return;
        }
        "onRebind called. action: ".concat(String.valueOf(intent.getAction()));
    }

    @Override // android.app.job.JobService
    public final boolean onStartJob(JobParameters jobParameters) {
        C1696kj0 c1696kj0D = d();
        Service service = (Service) c1696kj0D.m;
        String string = jobParameters.getExtras().getString("action");
        "onStartJob received action: ".concat(String.valueOf(string));
        if (Objects.equals(string, "com.google.android.gms.measurement.UPLOAD")) {
            String str = (String) Preconditions.checkNotNull(string);
            C1051dv0 c1051dv0C = C1051dv0.C(service);
            Nq0 nq0B = c1051dv0C.b();
            C2616uQ c2616uQ = c1051dv0C.l.c;
            nq0B.n.c(str, "Local AppMeasurementJobService called. action");
            c1051dv0C.c().B(new Js0(c1696kj0D, c1051dv0C, new RunnableC0245Jl(c1696kj0D, nq0B, jobParameters, 13)));
        }
        if (!Objects.equals(string, "com.google.android.gms.measurement.SCION_UPLOAD")) {
            return true;
        }
        Wp0 wp0C = Wp0.c(service, null);
        Js0 js0 = new Js0(12, c1696kj0D, jobParameters, false);
        wp0C.getClass();
        wp0C.a(new Fp0(wp0C, js0, 2));
        return true;
    }

    @Override // android.app.job.JobService
    public final boolean onStopJob(JobParameters jobParameters) {
        return false;
    }

    @Override // android.app.Service
    public final boolean onUnbind(Intent intent) {
        d();
        if (intent == null) {
            return true;
        }
        "onUnbind called for intent. action: ".concat(String.valueOf(intent.getAction()));
        return true;
    }

    @Override // o.Zt0
    public final void b(Intent intent) {
    }
}
