package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Binder;
import android.os.StrictMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import o.C1696kj0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class a {
    public static final ConcurrentHashMap i = new ConcurrentHashMap();
    public static final String[] j = {"key", "value"};
    public final ContentResolver a;
    public final Uri b;
    public final Runnable c;
    public volatile Map g;
    public ContentObserver d = null;
    public volatile boolean e = true;
    public final Object f = new Object();
    public final ArrayList h = new ArrayList();

    public a(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        contentResolver.getClass();
        uri.getClass();
        this.a = contentResolver;
        this.b = uri;
        this.c = runnable;
    }

    public static a a(final ContentResolver contentResolver, final Uri uri, final Runnable runnable) {
        a aVar = (a) i.computeIfAbsent(uri, new Function() { // from class: o.us0
            @Override // java.util.function.Function
            public final /* synthetic */ Object apply(Object obj) {
                return new com.google.android.gms.internal.measurement.a(contentResolver, uri, runnable);
            }
        });
        try {
            if (!aVar.e) {
                return aVar;
            }
            synchronized (aVar) {
                try {
                    if (aVar.e) {
                        zzjo zzjoVar = new zzjo(aVar);
                        aVar.a.registerContentObserver(aVar.b, false, zzjoVar);
                        aVar.d = zzjoVar;
                        aVar.e = false;
                    }
                } finally {
                }
            }
            return aVar;
        } catch (SecurityException unused) {
            return null;
        }
    }

    public static void c() {
        Iterator it = i.values().iterator();
        while (it.hasNext()) {
            a aVar = (a) it.next();
            synchronized (aVar) {
                try {
                    if (aVar.e) {
                        aVar.e = false;
                    } else {
                        ContentObserver contentObserver = aVar.d;
                        if (contentObserver != null) {
                            aVar.a.unregisterContentObserver(contentObserver);
                            aVar.d = null;
                        }
                    }
                } catch (Throwable th) {
                    throw th;
                }
            }
            it.remove();
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r0v4, types: [java.util.Map] */
    /* JADX WARN: Type inference failed for: r0v6, types: [android.os.StrictMode$ThreadPolicy] */
    public final Map b() {
        Map map;
        Map map2;
        Object objK;
        Map map3 = this.g;
        Map map4 = map3;
        if (map3 == null) {
            synchronized (this.f) {
                StrictMode.ThreadPolicy threadPolicyAllowThreadDiskReads = this.g;
                map2 = threadPolicyAllowThreadDiskReads;
                if (threadPolicyAllowThreadDiskReads == 0) {
                    try {
                        threadPolicyAllowThreadDiskReads = StrictMode.allowThreadDiskReads();
                        try {
                            C1696kj0 c1696kj0 = new C1696kj0(12, this);
                            try {
                                objK = c1696kj0.k();
                            } catch (SecurityException unused) {
                                long jClearCallingIdentity = Binder.clearCallingIdentity();
                                try {
                                    objK = c1696kj0.k();
                                } finally {
                                    Binder.restoreCallingIdentity(jClearCallingIdentity);
                                }
                            }
                            map = (Map) objK;
                        } catch (SQLiteException | IllegalStateException | SecurityException unused2) {
                            map = Collections.EMPTY_MAP;
                        }
                        this.g = map;
                        map2 = map;
                    } finally {
                        StrictMode.setThreadPolicy(threadPolicyAllowThreadDiskReads);
                    }
                }
            }
            map4 = map2;
        }
        return map4 != null ? map4 : Collections.EMPTY_MAP;
    }
}
