package com.google.android.gms.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import o.C1696kj0;
import o.C2003nu0;
import o.C2160pe;
import o.Fw0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class HttpUtils {
    private static final Pattern zza = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern zzb = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern zzc = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    private HttpUtils() {
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r0v0, types: [java.util.Map] */
    /* JADX WARN: Type inference failed for: r0v1, types: [java.util.Map<java.lang.String, java.lang.String>] */
    /* JADX WARN: Type inference failed for: r0v2, types: [java.util.HashMap] */
    public static Map<String, String> parse(URI uri, String str) {
        ?? map = Collections.EMPTY_MAP;
        String rawQuery = uri.getRawQuery();
        if (rawQuery != null && rawQuery.length() > 0) {
            map = new HashMap();
            C2160pe c2160pe = new C2160pe(false, (Object) new C1696kj0(19, new C2003nu0('=')));
            C2160pe c2160pe2 = new C2160pe(true, (Object) new C1696kj0(19, new C2003nu0('&')));
            Fw0 fw0 = new Fw0(c2160pe2, rawQuery, (C2003nu0) ((C1696kj0) c2160pe2.m).m);
            while (fw0.hasNext()) {
                String str2 = (String) fw0.next();
                str2.getClass();
                Fw0 fw02 = new Fw0(c2160pe, str2, (C2003nu0) ((C1696kj0) c2160pe.m).m);
                ArrayList arrayList = new ArrayList();
                while (fw02.hasNext()) {
                    arrayList.add((String) fw02.next());
                }
                List listUnmodifiableList = Collections.unmodifiableList(arrayList);
                if (listUnmodifiableList.isEmpty() || listUnmodifiableList.size() > 2) {
                    throw new IllegalArgumentException("bad parameter");
                }
                map.put(zza((String) listUnmodifiableList.get(0), str), listUnmodifiableList.size() == 2 ? zza((String) listUnmodifiableList.get(1), str) : null);
            }
        }
        return map;
    }

    private static String zza(String str, String str2) {
        if (str2 == null) {
            str2 = "ISO-8859-1";
        }
        try {
            return URLDecoder.decode(str, str2);
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}
