package com.google.android.gms.common.images;

import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.Objects;
import java.lang.ref.WeakReference;
import o.C2748vn0;
import o.C2843wn0;
import o.C3033yn0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class zae extends zag {
    private final WeakReference zac;

    public zae(ImageView imageView, int i) {
        super(Uri.EMPTY, i);
        Asserts.checkNotNull(imageView);
        this.zac = new WeakReference(imageView);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof zae)) {
            return false;
        }
        ImageView imageView = (ImageView) this.zac.get();
        ImageView imageView2 = (ImageView) ((zae) obj).zac.get();
        return (imageView2 == null || imageView == null || !Objects.equal(imageView2, imageView)) ? false : true;
    }

    public final int hashCode() {
        return 0;
    }

    @Override // com.google.android.gms.common.images.zag
    public final void zaa(Drawable drawable, boolean z, boolean z2, boolean z3) {
        ImageView imageView = (ImageView) this.zac.get();
        if (imageView != null) {
            boolean z4 = (z2 || z) ? false : true;
            if (z4) {
                Drawable drawable2 = imageView.getDrawable();
                if (drawable2 == null) {
                    drawable2 = null;
                } else if (drawable2 instanceof C3033yn0) {
                    drawable2 = ((C3033yn0) drawable2).v;
                }
                C3033yn0 c3033yn0 = new C3033yn0(null);
                if (drawable2 == null) {
                    drawable2 = C2748vn0.a;
                }
                c3033yn0.u = drawable2;
                drawable2.setCallback(c3033yn0);
                C2843wn0 c2843wn0 = c3033yn0.t;
                c2843wn0.b = drawable2.getChangingConfigurations() | c2843wn0.b;
                if (drawable == null) {
                    drawable = C2748vn0.a;
                }
                c3033yn0.v = drawable;
                drawable.setCallback(c3033yn0);
                C2843wn0 c2843wn02 = c3033yn0.t;
                c2843wn02.b = drawable.getChangingConfigurations() | c2843wn02.b;
                drawable = c3033yn0;
            }
            imageView.setImageDrawable(drawable);
            if (drawable == null || !z4) {
                return;
            }
            C3033yn0 c3033yn02 = (C3033yn0) drawable;
            c3033yn02.n = c3033yn02.f812o;
            c3033yn02.q = 0;
            c3033yn02.p = 250;
            c3033yn02.l = 1;
            c3033yn02.invalidateSelf();
        }
    }

    public zae(ImageView imageView, Uri uri) {
        super(uri, 0);
        Asserts.checkNotNull(imageView);
        this.zac = new WeakReference(imageView);
    }
}
