package com.google.android.gms.common.api;

import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.internal.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import o.AbstractC2462sn;
import o.C1460i9;
import o.C1554j9;
import o.C1839m9;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class AvailabilityException extends Exception {
    private final C1839m9 zaa;

    public AvailabilityException(C1839m9 c1839m9) {
        this.zaa = c1839m9;
    }

    public ConnectionResult getConnectionResult(GoogleApi<? extends Api.ApiOptions> googleApi) {
        C1839m9 c1839m9 = this.zaa;
        ApiKey<O> apiKey = googleApi.getApiKey();
        Object obj = c1839m9.get(apiKey);
        Preconditions.checkArgument(obj != null, AbstractC2462sn.j("The given API (", apiKey.zaa(), ") was not part of the availability request."));
        return (ConnectionResult) Preconditions.checkNotNull((ConnectionResult) this.zaa.get(apiKey));
    }

    @Override // java.lang.Throwable
    public String getMessage() {
        ArrayList arrayList = new ArrayList();
        Iterator it = ((C1554j9) this.zaa.keySet()).iterator();
        boolean z = true;
        while (true) {
            C1460i9 c1460i9 = (C1460i9) it;
            if (!c1460i9.hasNext()) {
                break;
            }
            ApiKey apiKey = (ApiKey) c1460i9.next();
            ConnectionResult connectionResult = (ConnectionResult) Preconditions.checkNotNull((ConnectionResult) this.zaa.get(apiKey));
            z &= !connectionResult.isSuccess();
            arrayList.add(apiKey.zaa() + ": " + String.valueOf(connectionResult));
        }
        StringBuilder sb = new StringBuilder();
        if (z) {
            sb.append("None of the queried APIs are available. ");
        } else {
            sb.append("Some of the queried APIs are unavailable. ");
        }
        sb.append(TextUtils.join("; ", arrayList));
        return sb.toString();
    }

    public ConnectionResult getConnectionResult(HasApiKey<? extends Api.ApiOptions> hasApiKey) {
        C1839m9 c1839m9 = this.zaa;
        ApiKey<O> apiKey = hasApiKey.getApiKey();
        Object obj = c1839m9.get(apiKey);
        Preconditions.checkArgument(obj != null, AbstractC2462sn.j("The given API (", apiKey.zaa(), ") was not part of the availability request."));
        return (ConnectionResult) Preconditions.checkNotNull((ConnectionResult) this.zaa.get(apiKey));
    }
}
