package com.google.android.gms.auth.api.signin;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.Scopes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import o.C2487t1;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
@Deprecated
/* loaded from: classes.dex */
public class GoogleSignInAccount extends AbstractSafeParcelable implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new C2487t1(23);
    public static final Clock y = DefaultClock.getInstance();
    public final int l;
    public final String m;
    public final String n;

    /* renamed from: o, reason: collision with root package name */
    public final String f24o;
    public final String p;
    public final Uri q;
    public String r;
    public final long s;
    public final String t;
    public final List u;
    public final String v;
    public final String w;
    public final HashSet x = new HashSet();

    public GoogleSignInAccount(int i, String str, String str2, String str3, String str4, Uri uri, String str5, long j, String str6, ArrayList arrayList, String str7, String str8) {
        this.l = i;
        this.m = str;
        this.n = str2;
        this.f24o = str3;
        this.p = str4;
        this.q = uri;
        this.r = str5;
        this.s = j;
        this.t = str6;
        this.u = arrayList;
        this.v = str7;
        this.w = str8;
    }

    public static GoogleSignInAccount c(String str) throws JSONException, NumberFormatException {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(str);
        String strOptString = jSONObject.optString("photoUrl");
        Uri uri = !TextUtils.isEmpty(strOptString) ? Uri.parse(strOptString) : null;
        long j = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet hashSet = new HashSet();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int length = jSONArray.length();
        for (int i = 0; i < length; i++) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        GoogleSignInAccount googleSignInAccount = new GoogleSignInAccount(3, jSONObject.optString("id"), jSONObject.has("tokenId") ? jSONObject.optString("tokenId") : null, jSONObject.has(Scopes.EMAIL) ? jSONObject.optString(Scopes.EMAIL) : null, jSONObject.has("displayName") ? jSONObject.optString("displayName") : null, uri, null, j, Preconditions.checkNotEmpty(jSONObject.getString("obfuscatedIdentifier")), new ArrayList((Collection) Preconditions.checkNotNull(hashSet)), jSONObject.has("givenName") ? jSONObject.optString("givenName") : null, jSONObject.has("familyName") ? jSONObject.optString("familyName") : null);
        googleSignInAccount.r = jSONObject.has("serverAuthCode") ? jSONObject.optString("serverAuthCode") : null;
        return googleSignInAccount;
    }

    public final HashSet b() {
        HashSet hashSet = new HashSet(this.u);
        hashSet.addAll(this.x);
        return hashSet;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount) obj;
        return googleSignInAccount.t.equals(this.t) && googleSignInAccount.b().equals(b());
    }

    public final int hashCode() {
        return ((this.t.hashCode() + 527) * 31) + b().hashCode();
    }

    @Override // android.os.Parcelable
    public final void writeToParcel(Parcel parcel, int i) {
        int iBeginObjectHeader = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeInt(parcel, 1, this.l);
        SafeParcelWriter.writeString(parcel, 2, this.m, false);
        SafeParcelWriter.writeString(parcel, 3, this.n, false);
        SafeParcelWriter.writeString(parcel, 4, this.f24o, false);
        SafeParcelWriter.writeString(parcel, 5, this.p, false);
        SafeParcelWriter.writeParcelable(parcel, 6, this.q, i, false);
        SafeParcelWriter.writeString(parcel, 7, this.r, false);
        SafeParcelWriter.writeLong(parcel, 8, this.s);
        SafeParcelWriter.writeString(parcel, 9, this.t, false);
        SafeParcelWriter.writeTypedList(parcel, 10, this.u, false);
        SafeParcelWriter.writeString(parcel, 11, this.v, false);
        SafeParcelWriter.writeString(parcel, 12, this.w, false);
        SafeParcelWriter.finishObjectHeader(parcel, iBeginObjectHeader);
    }
}
