package androidx.recyclerview.widget;

import android.R;
import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import com.google.android.gms.common.api.Api;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.WeakHashMap;
import o.AbstractC0775b10;
import o.AbstractC0870c10;
import o.AbstractC1157f10;
import o.AbstractC1349h10;
import o.AbstractC1445i10;
import o.AbstractC1456i7;
import o.AbstractC1500ig0;
import o.AbstractC2298r10;
import o.AbstractC2488t10;
import o.C0189Hh;
import o.C0205Hx;
import o.C0679a10;
import o.C1253g10;
import o.C1390hY;
import o.C1539j10;
import o.C1634k10;
import o.C1729l10;
import o.C1899mq;
import o.C1919n10;
import o.C2204q10;
import o.C2616uQ;
import o.C2642ui;
import o.C2678v10;
import o.C2896xL;
import o.C3126zm0;
import o.Gj0;
import o.I80;
import o.Ij0;
import o.InterfaceC1824m10;
import o.KZ;
import o.Oj0;
import o.P1;
import o.Q1;
import o.QR;
import o.Rj0;
import o.RunnableC2017o3;
import o.RunnableC2393s10;
import o.RunnableC2983yD;
import o.UM;
import o.V00;
import o.VZ;
import o.W00;
import o.X00;
import o.Xj0;
import o.Z00;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class RecyclerView extends ViewGroup {
    public static final int[] D0 = {R.attr.nestedScrollingEnabled};
    public static final Class[] E0;
    public static final V00 F0;
    public boolean A;
    public final ArrayList A0;
    public boolean B;
    public final RunnableC2017o3 B0;
    public boolean C;
    public final W00 C0;
    public int D;
    public boolean E;
    public boolean F;
    public boolean G;
    public int H;
    public final AccessibilityManager I;
    public boolean J;
    public boolean K;
    public int L;
    public int M;
    public C0679a10 N;
    public EdgeEffect O;
    public EdgeEffect P;
    public EdgeEffect Q;
    public EdgeEffect R;
    public AbstractC0775b10 S;
    public int T;
    public int U;
    public VelocityTracker V;
    public int W;
    public int a0;
    public int b0;
    public int c0;
    public int d0;
    public AbstractC1349h10 e0;
    public final int f0;
    public final int g0;
    public final float h0;
    public final float i0;
    public boolean j0;
    public final RunnableC2393s10 k0;
    public final C2616uQ l;
    public RunnableC2983yD l0;
    public final C1729l10 m;
    public final C2642ui m0;
    public C1919n10 n;
    public final C2204q10 n0;

    /* renamed from: o, reason: collision with root package name */
    public final Q1 f19o;
    public AbstractC1445i10 o0;
    public final C3126zm0 p;
    public ArrayList p0;
    public final C1390hY q;
    public boolean q0;
    public boolean r;
    public boolean r0;
    public final Rect s;
    public final W00 s0;
    public final Rect t;
    public boolean t0;
    public final RectF u;
    public C2678v10 u0;
    public X00 v;
    public final int[] v0;
    public AbstractC1157f10 w;
    public QR w0;
    public final ArrayList x;
    public final int[] x0;
    public final ArrayList y;
    public final int[] y0;
    public C0205Hx z;
    public final int[] z0;

    static {
        Class cls = Integer.TYPE;
        E0 = new Class[]{Context.class, AttributeSet.class, cls, cls};
        F0 = new V00(0);
    }

    public RecyclerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, com.google.android.gms.common.R.attr.recyclerViewStyle);
    }

    public static RecyclerView D(View view) {
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        if (view instanceof RecyclerView) {
            return (RecyclerView) view;
        }
        ViewGroup viewGroup = (ViewGroup) view;
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; i++) {
            RecyclerView recyclerViewD = D(viewGroup.getChildAt(i));
            if (recyclerViewD != null) {
                return recyclerViewD;
            }
        }
        return null;
    }

    public static AbstractC2488t10 I(View view) {
        if (view == null) {
            return null;
        }
        return ((C1253g10) view.getLayoutParams()).a;
    }

    private QR getScrollingChildHelper() {
        if (this.w0 == null) {
            this.w0 = new QR(this);
        }
        return this.w0;
    }

    public static void j(AbstractC2488t10 abstractC2488t10) {
        WeakReference weakReference = abstractC2488t10.b;
        if (weakReference != null) {
            View view = (View) weakReference.get();
            while (view != null) {
                if (view == abstractC2488t10.a) {
                    return;
                }
                Object parent = view.getParent();
                view = parent instanceof View ? (View) parent : null;
            }
            abstractC2488t10.b = null;
        }
    }

    public final View A(View view) {
        ViewParent parent = view.getParent();
        while (parent != null && parent != this && (parent instanceof View)) {
            view = parent;
            parent = view.getParent();
        }
        if (parent == this) {
            return view;
        }
        return null;
    }

    /* JADX WARN: Removed duplicated region for block: B:23:0x005e A[SYNTHETIC] */
    /* JADX WARN: Removed duplicated region for block: B:27:0x0061 A[SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean B(android.view.MotionEvent r12) {
        /*
            r11 = this;
            int r0 = r12.getAction()
            java.util.ArrayList r1 = r11.y
            int r2 = r1.size()
            r3 = 0
            r4 = r3
        Lc:
            if (r4 >= r2) goto L64
            java.lang.Object r5 = r1.get(r4)
            o.Hx r5 = (o.C0205Hx) r5
            int r6 = r5.v
            r7 = 1
            r8 = 2
            if (r6 != r7) goto L59
            float r6 = r12.getX()
            float r9 = r12.getY()
            boolean r6 = r5.d(r6, r9)
            float r9 = r12.getX()
            float r10 = r12.getY()
            boolean r9 = r5.c(r9, r10)
            int r10 = r12.getAction()
            if (r10 != 0) goto L61
            if (r6 != 0) goto L3c
            if (r9 == 0) goto L61
        L3c:
            if (r9 == 0) goto L49
            r5.w = r7
            float r6 = r12.getX()
            int r6 = (int) r6
            float r6 = (float) r6
            r5.p = r6
            goto L55
        L49:
            if (r6 == 0) goto L55
            r5.w = r8
            float r6 = r12.getY()
            int r6 = (int) r6
            float r6 = (float) r6
            r5.m = r6
        L55:
            r5.f(r8)
            goto L5b
        L59:
            if (r6 != r8) goto L61
        L5b:
            r6 = 3
            if (r0 == r6) goto L61
            r11.z = r5
            return r7
        L61:
            int r4 = r4 + 1
            goto Lc
        L64:
            return r3
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.recyclerview.widget.RecyclerView.B(android.view.MotionEvent):boolean");
    }

    public final void C(int[] iArr) {
        int iZ = this.p.z();
        if (iZ == 0) {
            iArr[0] = -1;
            iArr[1] = -1;
            return;
        }
        int i = Api.BaseClientBuilder.API_PRIORITY_OTHER;
        int i2 = Integer.MIN_VALUE;
        for (int i3 = 0; i3 < iZ; i3++) {
            AbstractC2488t10 abstractC2488t10I = I(this.p.y(i3));
            if (!abstractC2488t10I.o()) {
                int iB = abstractC2488t10I.b();
                if (iB < i) {
                    i = iB;
                }
                if (iB > i2) {
                    i2 = iB;
                }
            }
        }
        iArr[0] = i;
        iArr[1] = i2;
    }

    public final AbstractC2488t10 E(int i) {
        AbstractC2488t10 abstractC2488t10 = null;
        if (this.J) {
            return null;
        }
        int iF = this.p.F();
        for (int i2 = 0; i2 < iF; i2++) {
            AbstractC2488t10 abstractC2488t10I = I(this.p.E(i2));
            if (abstractC2488t10I != null && !abstractC2488t10I.h() && F(abstractC2488t10I) == i) {
                if (!((ArrayList) this.p.f831o).contains(abstractC2488t10I.a)) {
                    return abstractC2488t10I;
                }
                abstractC2488t10 = abstractC2488t10I;
            }
        }
        return abstractC2488t10;
    }

    public final int F(AbstractC2488t10 abstractC2488t10) {
        if ((abstractC2488t10.j & 524) == 0 && abstractC2488t10.e()) {
            int i = abstractC2488t10.c;
            ArrayList arrayList = (ArrayList) this.f19o.m;
            int size = arrayList.size();
            for (int i2 = 0; i2 < size; i2++) {
                P1 p1 = (P1) arrayList.get(i2);
                int i3 = p1.a;
                if (i3 != 1) {
                    if (i3 == 2) {
                        int i4 = p1.b;
                        if (i4 <= i) {
                            int i5 = p1.c;
                            if (i4 + i5 <= i) {
                                i -= i5;
                            }
                        } else {
                            continue;
                        }
                    } else if (i3 == 8) {
                        int i6 = p1.b;
                        if (i6 == i) {
                            i = p1.c;
                        } else {
                            if (i6 < i) {
                                i--;
                            }
                            if (p1.c <= i) {
                                i++;
                            }
                        }
                    }
                } else if (p1.b <= i) {
                    i += p1.c;
                }
            }
            return i;
        }
        return -1;
    }

    public final long G(AbstractC2488t10 abstractC2488t10) {
        return this.v.b ? abstractC2488t10.e : abstractC2488t10.c;
    }

    public final AbstractC2488t10 H(View view) {
        ViewParent parent = view.getParent();
        if (parent == null || parent == this) {
            return I(view);
        }
        throw new IllegalArgumentException("View " + view + " is not a direct child of " + this);
    }

    public final Rect J(View view) {
        C1253g10 c1253g10 = (C1253g10) view.getLayoutParams();
        boolean z = c1253g10.c;
        Rect rect = c1253g10.b;
        if (!z || (this.n0.g && (c1253g10.a.k() || c1253g10.a.f()))) {
            return rect;
        }
        rect.set(0, 0, 0, 0);
        ArrayList arrayList = this.x;
        int size = arrayList.size();
        for (int i = 0; i < size; i++) {
            Rect rect2 = this.s;
            rect2.set(0, 0, 0, 0);
            ((AbstractC0870c10) arrayList.get(i)).getClass();
            ((C1253g10) view.getLayoutParams()).a.getClass();
            rect2.set(0, 0, 0, 0);
            rect.left += rect2.left;
            rect.top += rect2.top;
            rect.right += rect2.right;
            rect.bottom += rect2.bottom;
        }
        c1253g10.c = false;
        return rect;
    }

    public final boolean K() {
        return !this.C || this.J || this.f19o.s();
    }

    public final boolean L() {
        return this.L > 0;
    }

    public final void M(int i) {
        if (this.w == null) {
            return;
        }
        setScrollState(2);
        this.w.n0(i);
        awakenScrollBars();
    }

    public final void N() {
        int iF = this.p.F();
        for (int i = 0; i < iF; i++) {
            ((C1253g10) this.p.E(i).getLayoutParams()).c = true;
        }
        ArrayList arrayList = this.m.c;
        int size = arrayList.size();
        for (int i2 = 0; i2 < size; i2++) {
            C1253g10 c1253g10 = (C1253g10) ((AbstractC2488t10) arrayList.get(i2)).a.getLayoutParams();
            if (c1253g10 != null) {
                c1253g10.c = true;
            }
        }
    }

    public final void O(int i, boolean z, int i2) {
        int i3 = i + i2;
        int iF = this.p.F();
        for (int i4 = 0; i4 < iF; i4++) {
            AbstractC2488t10 abstractC2488t10I = I(this.p.E(i4));
            if (abstractC2488t10I != null && !abstractC2488t10I.o()) {
                int i5 = abstractC2488t10I.c;
                C2204q10 c2204q10 = this.n0;
                if (i5 >= i3) {
                    abstractC2488t10I.l(-i2, z);
                    c2204q10.f = true;
                } else if (i5 >= i) {
                    abstractC2488t10I.a(8);
                    abstractC2488t10I.l(-i2, z);
                    abstractC2488t10I.c = i - 1;
                    c2204q10.f = true;
                }
            }
        }
        C1729l10 c1729l10 = this.m;
        ArrayList arrayList = c1729l10.c;
        for (int size = arrayList.size() - 1; size >= 0; size--) {
            AbstractC2488t10 abstractC2488t10 = (AbstractC2488t10) arrayList.get(size);
            if (abstractC2488t10 != null) {
                int i6 = abstractC2488t10.c;
                if (i6 >= i3) {
                    abstractC2488t10.l(-i2, z);
                } else if (i6 >= i) {
                    abstractC2488t10.a(8);
                    c1729l10.e(size);
                }
            }
        }
        requestLayout();
    }

    public final void P() {
        this.L++;
    }

    public final void Q(boolean z) {
        int i;
        AccessibilityManager accessibilityManager;
        int i2 = this.L - 1;
        this.L = i2;
        if (i2 < 1) {
            this.L = 0;
            if (z) {
                int i3 = this.H;
                this.H = 0;
                if (i3 != 0 && (accessibilityManager = this.I) != null && accessibilityManager.isEnabled()) {
                    AccessibilityEvent accessibilityEventObtain = AccessibilityEvent.obtain();
                    accessibilityEventObtain.setEventType(2048);
                    accessibilityEventObtain.setContentChangeTypes(i3);
                    sendAccessibilityEventUnchecked(accessibilityEventObtain);
                }
                ArrayList arrayList = this.A0;
                for (int size = arrayList.size() - 1; size >= 0; size--) {
                    AbstractC2488t10 abstractC2488t10 = (AbstractC2488t10) arrayList.get(size);
                    if (abstractC2488t10.a.getParent() == this && !abstractC2488t10.o() && (i = abstractC2488t10.q) != -1) {
                        View view = abstractC2488t10.a;
                        WeakHashMap weakHashMap = Oj0.a;
                        view.setImportantForAccessibility(i);
                        abstractC2488t10.q = -1;
                    }
                }
                arrayList.clear();
            }
        }
    }

    public final void R(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.U) {
            int i = actionIndex == 0 ? 1 : 0;
            this.U = motionEvent.getPointerId(i);
            int x = (int) (motionEvent.getX(i) + 0.5f);
            this.b0 = x;
            this.W = x;
            int y = (int) (motionEvent.getY(i) + 0.5f);
            this.c0 = y;
            this.a0 = y;
        }
    }

    public final void S() {
        if (this.t0 || !this.A) {
            return;
        }
        WeakHashMap weakHashMap = Oj0.a;
        postOnAnimation(this.B0);
        this.t0 = true;
    }

    public final void T(AbstractC2488t10 abstractC2488t10, KZ kz) {
        abstractC2488t10.j &= -8193;
        boolean z = this.n0.h;
        C1390hY c1390hY = this.q;
        if (z && abstractC2488t10.k() && !abstractC2488t10.h() && !abstractC2488t10.o()) {
            ((UM) c1390hY.n).e(G(abstractC2488t10), abstractC2488t10);
        }
        I80 i80 = (I80) c1390hY.m;
        Xj0 xj0A = (Xj0) i80.get(abstractC2488t10);
        if (xj0A == null) {
            xj0A = Xj0.a();
            i80.put(abstractC2488t10, xj0A);
        }
        xj0A.b = kz;
        xj0A.a |= 4;
    }

    public final void U(View view, View view2) {
        View view3 = view2 != null ? view2 : view;
        int width = view3.getWidth();
        int height = view3.getHeight();
        Rect rect = this.s;
        rect.set(0, 0, width, height);
        ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
        if (layoutParams instanceof C1253g10) {
            C1253g10 c1253g10 = (C1253g10) layoutParams;
            if (!c1253g10.c) {
                Rect rect2 = c1253g10.b;
                rect.left -= rect2.left;
                rect.right += rect2.right;
                rect.top -= rect2.top;
                rect.bottom += rect2.bottom;
            }
        }
        if (view2 != null) {
            offsetDescendantRectToMyCoords(view2, rect);
            offsetRectIntoDescendantCoords(view, rect);
        }
        this.w.k0(this, view, this.s, !this.C, view2 == null);
    }

    public final void V() {
        VelocityTracker velocityTracker = this.V;
        if (velocityTracker != null) {
            velocityTracker.clear();
        }
        boolean zIsFinished = false;
        c0(0);
        EdgeEffect edgeEffect = this.O;
        if (edgeEffect != null) {
            edgeEffect.onRelease();
            zIsFinished = this.O.isFinished();
        }
        EdgeEffect edgeEffect2 = this.P;
        if (edgeEffect2 != null) {
            edgeEffect2.onRelease();
            zIsFinished |= this.P.isFinished();
        }
        EdgeEffect edgeEffect3 = this.Q;
        if (edgeEffect3 != null) {
            edgeEffect3.onRelease();
            zIsFinished |= this.Q.isFinished();
        }
        EdgeEffect edgeEffect4 = this.R;
        if (edgeEffect4 != null) {
            edgeEffect4.onRelease();
            zIsFinished |= this.R.isFinished();
        }
        if (zIsFinished) {
            WeakHashMap weakHashMap = Oj0.a;
            postInvalidateOnAnimation();
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:31:0x00c8  */
    /* JADX WARN: Removed duplicated region for block: B:33:0x00e0  */
    /* JADX WARN: Removed duplicated region for block: B:37:0x00fd  */
    /* JADX WARN: Removed duplicated region for block: B:41:0x0105  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean W(int r18, int r19, android.view.MotionEvent r20) {
        /*
            Method dump skipped, instructions count: 297
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.recyclerview.widget.RecyclerView.W(int, int, android.view.MotionEvent):boolean");
    }

    public final void X(int i, int i2, int[] iArr) {
        AbstractC2488t10 abstractC2488t10;
        a0();
        P();
        int i3 = AbstractC1500ig0.a;
        Trace.beginSection("RV Scroll");
        C2204q10 c2204q10 = this.n0;
        z(c2204q10);
        C1729l10 c1729l10 = this.m;
        int iM0 = i != 0 ? this.w.m0(i, c1729l10, c2204q10) : 0;
        int iO0 = i2 != 0 ? this.w.o0(i2, c1729l10, c2204q10) : 0;
        Trace.endSection();
        C3126zm0 c3126zm0 = this.p;
        int iZ = c3126zm0.z();
        for (int i4 = 0; i4 < iZ; i4++) {
            View viewY = c3126zm0.y(i4);
            AbstractC2488t10 abstractC2488t10H = H(viewY);
            if (abstractC2488t10H != null && (abstractC2488t10 = abstractC2488t10H.i) != null) {
                View view = abstractC2488t10.a;
                int left = viewY.getLeft();
                int top = viewY.getTop();
                if (left != view.getLeft() || top != view.getTop()) {
                    view.layout(left, top, view.getWidth() + left, view.getHeight() + top);
                }
            }
        }
        Q(true);
        b0(false);
        if (iArr != null) {
            iArr[0] = iM0;
            iArr[1] = iO0;
        }
    }

    public final void Y(int i) {
        C2896xL c2896xL;
        if (this.F) {
            return;
        }
        setScrollState(0);
        RunnableC2393s10 runnableC2393s10 = this.k0;
        runnableC2393s10.r.removeCallbacks(runnableC2393s10);
        runnableC2393s10.n.abortAnimation();
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null && (c2896xL = abstractC1157f10.e) != null) {
            c2896xL.i();
        }
        AbstractC1157f10 abstractC1157f102 = this.w;
        if (abstractC1157f102 == null) {
            return;
        }
        abstractC1157f102.n0(i);
        awakenScrollBars();
    }

    public final void Z(int i, boolean z, int i2) {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 == null || this.F) {
            return;
        }
        if (!abstractC1157f10.d()) {
            i = 0;
        }
        if (!this.w.e()) {
            i2 = 0;
        }
        if (i == 0 && i2 == 0) {
            return;
        }
        if (z) {
            int i3 = i != 0 ? 1 : 0;
            if (i2 != 0) {
                i3 |= 2;
            }
            getScrollingChildHelper().g(i3, 1);
        }
        this.k0.b(i, i2, Integer.MIN_VALUE, null);
    }

    public final void a0() {
        int i = this.D + 1;
        this.D = i;
        if (i != 1 || this.F) {
            return;
        }
        this.E = false;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void addFocusables(ArrayList arrayList, int i, int i2) {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null) {
            abstractC1157f10.getClass();
        }
        super.addFocusables(arrayList, i, i2);
    }

    public final void b0(boolean z) {
        if (this.D < 1) {
            this.D = 1;
        }
        if (!z && !this.F) {
            this.E = false;
        }
        if (this.D == 1) {
            if (z && this.E && !this.F && this.w != null && this.v != null) {
                o();
            }
            if (!this.F) {
                this.E = false;
            }
        }
        this.D--;
    }

    public final void c0(int i) {
        getScrollingChildHelper().h(i);
    }

    @Override // android.view.ViewGroup
    public final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof C1253g10) && this.w.f((C1253g10) layoutParams);
    }

    @Override // android.view.View
    public final int computeHorizontalScrollExtent() {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null && abstractC1157f10.d()) {
            return this.w.j(this.n0);
        }
        return 0;
    }

    @Override // android.view.View
    public final int computeHorizontalScrollOffset() {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null && abstractC1157f10.d()) {
            return this.w.k(this.n0);
        }
        return 0;
    }

    @Override // android.view.View
    public final int computeHorizontalScrollRange() {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null && abstractC1157f10.d()) {
            return this.w.l(this.n0);
        }
        return 0;
    }

    @Override // android.view.View
    public final int computeVerticalScrollExtent() {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null && abstractC1157f10.e()) {
            return this.w.m(this.n0);
        }
        return 0;
    }

    @Override // android.view.View
    public final int computeVerticalScrollOffset() {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null && abstractC1157f10.e()) {
            return this.w.n(this.n0);
        }
        return 0;
    }

    @Override // android.view.View
    public final int computeVerticalScrollRange() {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null && abstractC1157f10.e()) {
            return this.w.o(this.n0);
        }
        return 0;
    }

    @Override // android.view.View
    public final boolean dispatchNestedFling(float f, float f2, boolean z) {
        return getScrollingChildHelper().a(f, f2, z);
    }

    @Override // android.view.View
    public final boolean dispatchNestedPreFling(float f, float f2) {
        return getScrollingChildHelper().b(f, f2);
    }

    @Override // android.view.View
    public final boolean dispatchNestedPreScroll(int i, int i2, int[] iArr, int[] iArr2) {
        return getScrollingChildHelper().c(i, i2, 0, iArr, iArr2);
    }

    @Override // android.view.View
    public final boolean dispatchNestedScroll(int i, int i2, int i3, int i4, int[] iArr) {
        return getScrollingChildHelper().d(i, i2, i3, i4, iArr, 0, null);
    }

    @Override // android.view.View
    public final boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void dispatchRestoreInstanceState(SparseArray sparseArray) {
        dispatchThawSelfOnly(sparseArray);
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void dispatchSaveInstanceState(SparseArray sparseArray) {
        dispatchFreezeSelfOnly(sparseArray);
    }

    @Override // android.view.View
    public final void draw(Canvas canvas) {
        boolean z;
        super.draw(canvas);
        ArrayList arrayList = this.x;
        int size = arrayList.size();
        boolean z2 = false;
        for (int i = 0; i < size; i++) {
            ((AbstractC0870c10) arrayList.get(i)).b(canvas, this);
        }
        EdgeEffect edgeEffect = this.O;
        if (edgeEffect == null || edgeEffect.isFinished()) {
            z = false;
        } else {
            int iSave = canvas.save();
            int paddingBottom = this.r ? getPaddingBottom() : 0;
            canvas.rotate(270.0f);
            canvas.translate((-getHeight()) + paddingBottom, 0.0f);
            EdgeEffect edgeEffect2 = this.O;
            z = edgeEffect2 != null && edgeEffect2.draw(canvas);
            canvas.restoreToCount(iSave);
        }
        EdgeEffect edgeEffect3 = this.P;
        if (edgeEffect3 != null && !edgeEffect3.isFinished()) {
            int iSave2 = canvas.save();
            if (this.r) {
                canvas.translate(getPaddingLeft(), getPaddingTop());
            }
            EdgeEffect edgeEffect4 = this.P;
            z |= edgeEffect4 != null && edgeEffect4.draw(canvas);
            canvas.restoreToCount(iSave2);
        }
        EdgeEffect edgeEffect5 = this.Q;
        if (edgeEffect5 != null && !edgeEffect5.isFinished()) {
            int iSave3 = canvas.save();
            int width = getWidth();
            int paddingTop = this.r ? getPaddingTop() : 0;
            canvas.rotate(90.0f);
            canvas.translate(-paddingTop, -width);
            EdgeEffect edgeEffect6 = this.Q;
            z |= edgeEffect6 != null && edgeEffect6.draw(canvas);
            canvas.restoreToCount(iSave3);
        }
        EdgeEffect edgeEffect7 = this.R;
        if (edgeEffect7 != null && !edgeEffect7.isFinished()) {
            int iSave4 = canvas.save();
            canvas.rotate(180.0f);
            if (this.r) {
                canvas.translate(getPaddingRight() + (-getWidth()), getPaddingBottom() + (-getHeight()));
            } else {
                canvas.translate(-getWidth(), -getHeight());
            }
            EdgeEffect edgeEffect8 = this.R;
            if (edgeEffect8 != null && edgeEffect8.draw(canvas)) {
                z2 = true;
            }
            z |= z2;
            canvas.restoreToCount(iSave4);
        }
        if ((z || this.S == null || arrayList.size() <= 0 || !this.S.f()) ? z : true) {
            WeakHashMap weakHashMap = Oj0.a;
            postInvalidateOnAnimation();
        }
    }

    @Override // android.view.ViewGroup
    public final boolean drawChild(Canvas canvas, View view, long j) {
        return super.drawChild(canvas, view, j);
    }

    public final void f(AbstractC2488t10 abstractC2488t10) {
        View view = abstractC2488t10.a;
        boolean z = view.getParent() == this;
        this.m.j(H(view));
        if (abstractC2488t10.j()) {
            this.p.l(view, -1, view.getLayoutParams(), true);
            return;
        }
        if (!z) {
            this.p.k(view, -1, true);
            return;
        }
        C3126zm0 c3126zm0 = this.p;
        int iIndexOfChild = ((W00) c3126zm0.m).a.indexOfChild(view);
        if (iIndexOfChild >= 0) {
            ((C0189Hh) c3126zm0.n).l(iIndexOfChild);
            c3126zm0.J(view);
        } else {
            throw new IllegalArgumentException("view is not a child, cannot hide " + view);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:117:0x0161  */
    /* JADX WARN: Removed duplicated region for block: B:136:0x0198 A[RETURN] */
    /* JADX WARN: Removed duplicated region for block: B:137:0x0199  */
    /* JADX WARN: Removed duplicated region for block: B:30:0x005f  */
    /* JADX WARN: Removed duplicated region for block: B:31:0x0061  */
    /* JADX WARN: Removed duplicated region for block: B:33:0x0064  */
    /* JADX WARN: Removed duplicated region for block: B:34:0x0066  */
    /* JADX WARN: Removed duplicated region for block: B:37:0x006a  */
    /* JADX WARN: Removed duplicated region for block: B:38:0x006d  */
    /* JADX WARN: Removed duplicated region for block: B:41:0x0074  */
    /* JADX WARN: Removed duplicated region for block: B:42:0x0076  */
    /* JADX WARN: Removed duplicated region for block: B:44:0x0079  */
    /* JADX WARN: Removed duplicated region for block: B:58:0x00b5  */
    /* JADX WARN: Removed duplicated region for block: B:67:0x00cc A[ADDED_TO_REGION] */
    @Override // android.view.ViewGroup, android.view.ViewParent
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final android.view.View focusSearch(android.view.View r17, int r18) {
        /*
            Method dump skipped, instructions count: 414
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.recyclerview.widget.RecyclerView.focusSearch(android.view.View, int):android.view.View");
    }

    public final void g(AbstractC0870c10 abstractC0870c10) {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null) {
            abstractC1157f10.c("Cannot add item decoration during a scroll  or layout");
        }
        ArrayList arrayList = this.x;
        if (arrayList.isEmpty()) {
            setWillNotDraw(false);
        }
        arrayList.add(abstractC0870c10);
        N();
        requestLayout();
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateDefaultLayoutParams() {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null) {
            return abstractC1157f10.r();
        }
        throw new IllegalStateException("RecyclerView has no LayoutManager" + y());
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null) {
            return abstractC1157f10.s(getContext(), attributeSet);
        }
        throw new IllegalStateException("RecyclerView has no LayoutManager" + y());
    }

    @Override // android.view.ViewGroup, android.view.View
    public CharSequence getAccessibilityClassName() {
        return "androidx.recyclerview.widget.RecyclerView";
    }

    public X00 getAdapter() {
        return this.v;
    }

    @Override // android.view.View
    public int getBaseline() {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 == null) {
            return super.getBaseline();
        }
        abstractC1157f10.getClass();
        return -1;
    }

    @Override // android.view.ViewGroup
    public final int getChildDrawingOrder(int i, int i2) {
        return super.getChildDrawingOrder(i, i2);
    }

    @Override // android.view.ViewGroup
    public boolean getClipToPadding() {
        return this.r;
    }

    public C2678v10 getCompatAccessibilityDelegate() {
        return this.u0;
    }

    public C0679a10 getEdgeEffectFactory() {
        return this.N;
    }

    public AbstractC0775b10 getItemAnimator() {
        return this.S;
    }

    public int getItemDecorationCount() {
        return this.x.size();
    }

    public AbstractC1157f10 getLayoutManager() {
        return this.w;
    }

    public int getMaxFlingVelocity() {
        return this.g0;
    }

    public int getMinFlingVelocity() {
        return this.f0;
    }

    public long getNanoTime() {
        return System.nanoTime();
    }

    public AbstractC1349h10 getOnFlingListener() {
        return this.e0;
    }

    public boolean getPreserveFocusAfterLayout() {
        return this.j0;
    }

    public C1634k10 getRecycledViewPool() {
        return this.m.c();
    }

    public int getScrollState() {
        return this.T;
    }

    public final void h(AbstractC1445i10 abstractC1445i10) {
        if (this.p0 == null) {
            this.p0 = new ArrayList();
        }
        this.p0.add(abstractC1445i10);
    }

    @Override // android.view.View
    public final boolean hasNestedScrollingParent() {
        return getScrollingChildHelper().f(0);
    }

    public final void i(String str) {
        if (L()) {
            if (str != null) {
                throw new IllegalStateException(str);
            }
            throw new IllegalStateException("Cannot call this method while RecyclerView is computing a layout or scrolling" + y());
        }
        if (this.M > 0) {
            new IllegalStateException("" + y());
        }
    }

    @Override // android.view.View
    public final boolean isAttachedToWindow() {
        return this.A;
    }

    @Override // android.view.ViewGroup
    public final boolean isLayoutSuppressed() {
        return this.F;
    }

    @Override // android.view.View
    public final boolean isNestedScrollingEnabled() {
        return getScrollingChildHelper().d;
    }

    public final void k() {
        int iF = this.p.F();
        for (int i = 0; i < iF; i++) {
            AbstractC2488t10 abstractC2488t10I = I(this.p.E(i));
            if (!abstractC2488t10I.o()) {
                abstractC2488t10I.d = -1;
                abstractC2488t10I.g = -1;
            }
        }
        C1729l10 c1729l10 = this.m;
        ArrayList arrayList = c1729l10.a;
        ArrayList arrayList2 = c1729l10.c;
        int size = arrayList2.size();
        for (int i2 = 0; i2 < size; i2++) {
            AbstractC2488t10 abstractC2488t10 = (AbstractC2488t10) arrayList2.get(i2);
            abstractC2488t10.d = -1;
            abstractC2488t10.g = -1;
        }
        int size2 = arrayList.size();
        for (int i3 = 0; i3 < size2; i3++) {
            AbstractC2488t10 abstractC2488t102 = (AbstractC2488t10) arrayList.get(i3);
            abstractC2488t102.d = -1;
            abstractC2488t102.g = -1;
        }
        ArrayList arrayList3 = c1729l10.b;
        if (arrayList3 != null) {
            int size3 = arrayList3.size();
            for (int i4 = 0; i4 < size3; i4++) {
                AbstractC2488t10 abstractC2488t103 = (AbstractC2488t10) c1729l10.b.get(i4);
                abstractC2488t103.d = -1;
                abstractC2488t103.g = -1;
            }
        }
    }

    public final void l(int i, int i2) {
        boolean zIsFinished;
        EdgeEffect edgeEffect = this.O;
        if (edgeEffect == null || edgeEffect.isFinished() || i <= 0) {
            zIsFinished = false;
        } else {
            this.O.onRelease();
            zIsFinished = this.O.isFinished();
        }
        EdgeEffect edgeEffect2 = this.Q;
        if (edgeEffect2 != null && !edgeEffect2.isFinished() && i < 0) {
            this.Q.onRelease();
            zIsFinished |= this.Q.isFinished();
        }
        EdgeEffect edgeEffect3 = this.P;
        if (edgeEffect3 != null && !edgeEffect3.isFinished() && i2 > 0) {
            this.P.onRelease();
            zIsFinished |= this.P.isFinished();
        }
        EdgeEffect edgeEffect4 = this.R;
        if (edgeEffect4 != null && !edgeEffect4.isFinished() && i2 < 0) {
            this.R.onRelease();
            zIsFinished |= this.R.isFinished();
        }
        if (zIsFinished) {
            WeakHashMap weakHashMap = Oj0.a;
            postInvalidateOnAnimation();
        }
    }

    public final void m() {
        if (!this.C || this.J) {
            int i = AbstractC1500ig0.a;
            Trace.beginSection("RV FullInvalidate");
            o();
            Trace.endSection();
            return;
        }
        Q1 q1 = this.f19o;
        if (q1.s()) {
            q1.getClass();
            if (q1.s()) {
                int i2 = AbstractC1500ig0.a;
                Trace.beginSection("RV FullInvalidate");
                o();
                Trace.endSection();
            }
        }
    }

    public final void n(int i, int i2) {
        int paddingRight = getPaddingRight() + getPaddingLeft();
        WeakHashMap weakHashMap = Oj0.a;
        setMeasuredDimension(AbstractC1157f10.g(i, paddingRight, getMinimumWidth()), AbstractC1157f10.g(i2, getPaddingBottom() + getPaddingTop(), getMinimumHeight()));
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:155:0x030d  */
    /* JADX WARN: Removed duplicated region for block: B:182:0x036d  */
    /* JADX WARN: Removed duplicated region for block: B:206:0x03b4  */
    /* JADX WARN: Type inference failed for: r16v0 */
    /* JADX WARN: Type inference failed for: r16v1 */
    /* JADX WARN: Type inference failed for: r16v3 */
    /* JADX WARN: Type inference failed for: r2v16 */
    /* JADX WARN: Type inference failed for: r2v23 */
    /* JADX WARN: Type inference failed for: r2v24, types: [int] */
    /* JADX WARN: Type inference failed for: r2v27 */
    /* JADX WARN: Type inference failed for: r2v33 */
    /* JADX WARN: Type inference failed for: r2v34 */
    /* JADX WARN: Type inference failed for: r2v35 */
    /* JADX WARN: Type inference failed for: r2v36 */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void o() {
        /*
            Method dump skipped, instructions count: 978
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.recyclerview.widget.RecyclerView.o():void");
    }

    /* JADX WARN: Removed duplicated region for block: B:19:0x005d  */
    @Override // android.view.ViewGroup, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void onAttachedToWindow() {
        /*
            r5 = this;
            super.onAttachedToWindow()
            r0 = 0
            r5.L = r0
            r1 = 1
            r5.A = r1
            boolean r2 = r5.C
            if (r2 == 0) goto L15
            boolean r2 = r5.isLayoutRequested()
            if (r2 != 0) goto L15
            r2 = r1
            goto L16
        L15:
            r2 = r0
        L16:
            r5.C = r2
            o.f10 r2 = r5.w
            if (r2 == 0) goto L21
            r2.g = r1
            r2.Q(r5)
        L21:
            r5.t0 = r0
            java.lang.ThreadLocal r0 = o.RunnableC2983yD.p
            java.lang.Object r1 = r0.get()
            o.yD r1 = (o.RunnableC2983yD) r1
            r5.l0 = r1
            if (r1 != 0) goto L6b
            o.yD r1 = new o.yD
            r1.<init>()
            java.util.ArrayList r2 = new java.util.ArrayList
            r2.<init>()
            r1.l = r2
            java.util.ArrayList r2 = new java.util.ArrayList
            r2.<init>()
            r1.f802o = r2
            r5.l0 = r1
            java.util.WeakHashMap r1 = o.Oj0.a
            android.view.Display r1 = r5.getDisplay()
            boolean r2 = r5.isInEditMode()
            if (r2 != 0) goto L5d
            if (r1 == 0) goto L5d
            float r1 = r1.getRefreshRate()
            r2 = 1106247680(0x41f00000, float:30.0)
            int r2 = (r1 > r2 ? 1 : (r1 == r2 ? 0 : -1))
            if (r2 < 0) goto L5d
            goto L5f
        L5d:
            r1 = 1114636288(0x42700000, float:60.0)
        L5f:
            o.yD r2 = r5.l0
            r3 = 1315859240(0x4e6e6b28, float:1.0E9)
            float r3 = r3 / r1
            long r3 = (long) r3
            r2.n = r3
            r0.set(r2)
        L6b:
            o.yD r0 = r5.l0
            java.util.ArrayList r0 = r0.l
            r0.add(r5)
            return
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.recyclerview.widget.RecyclerView.onAttachedToWindow():void");
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onDetachedFromWindow() {
        C2896xL c2896xL;
        super.onDetachedFromWindow();
        AbstractC0775b10 abstractC0775b10 = this.S;
        if (abstractC0775b10 != null) {
            abstractC0775b10.e();
        }
        setScrollState(0);
        RunnableC2393s10 runnableC2393s10 = this.k0;
        runnableC2393s10.r.removeCallbacks(runnableC2393s10);
        runnableC2393s10.n.abortAnimation();
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null && (c2896xL = abstractC1157f10.e) != null) {
            c2896xL.i();
        }
        this.A = false;
        AbstractC1157f10 abstractC1157f102 = this.w;
        if (abstractC1157f102 != null) {
            abstractC1157f102.g = false;
            abstractC1157f102.R(this);
        }
        this.A0.clear();
        removeCallbacks(this.B0);
        this.q.getClass();
        while (Xj0.d.a() != null) {
        }
        RunnableC2983yD runnableC2983yD = this.l0;
        if (runnableC2983yD != null) {
            runnableC2983yD.l.remove(this);
            this.l0 = null;
        }
    }

    @Override // android.view.View
    public final void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        ArrayList arrayList = this.x;
        int size = arrayList.size();
        for (int i = 0; i < size; i++) {
            ((AbstractC0870c10) arrayList.get(i)).a(this);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:28:0x0064  */
    /* JADX WARN: Removed duplicated region for block: B:31:0x006a  */
    /* JADX WARN: Removed duplicated region for block: B:33:0x006e  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean onGenericMotionEvent(android.view.MotionEvent r6) {
        /*
            r5 = this;
            o.f10 r0 = r5.w
            r1 = 0
            if (r0 != 0) goto L7
            goto L79
        L7:
            boolean r0 = r5.F
            if (r0 == 0) goto Ld
            goto L79
        Ld:
            int r0 = r6.getAction()
            r2 = 8
            if (r0 != r2) goto L79
            int r0 = r6.getSource()
            r0 = r0 & 2
            r2 = 0
            if (r0 == 0) goto L40
            o.f10 r0 = r5.w
            boolean r0 = r0.e()
            if (r0 == 0) goto L2e
            r0 = 9
            float r0 = r6.getAxisValue(r0)
            float r0 = -r0
            goto L2f
        L2e:
            r0 = r2
        L2f:
            o.f10 r3 = r5.w
            boolean r3 = r3.d()
            if (r3 == 0) goto L3e
            r3 = 10
            float r3 = r6.getAxisValue(r3)
            goto L66
        L3e:
            r3 = r2
            goto L66
        L40:
            int r0 = r6.getSource()
            r3 = 4194304(0x400000, float:5.877472E-39)
            r0 = r0 & r3
            if (r0 == 0) goto L64
            r0 = 26
            float r0 = r6.getAxisValue(r0)
            o.f10 r3 = r5.w
            boolean r3 = r3.e()
            if (r3 == 0) goto L59
            float r0 = -r0
            goto L3e
        L59:
            o.f10 r3 = r5.w
            boolean r3 = r3.d()
            if (r3 == 0) goto L64
            r3 = r0
            r0 = r2
            goto L66
        L64:
            r0 = r2
            r3 = r0
        L66:
            int r4 = (r0 > r2 ? 1 : (r0 == r2 ? 0 : -1))
            if (r4 != 0) goto L6e
            int r2 = (r3 > r2 ? 1 : (r3 == r2 ? 0 : -1))
            if (r2 == 0) goto L79
        L6e:
            float r2 = r5.h0
            float r3 = r3 * r2
            int r2 = (int) r3
            float r3 = r5.i0
            float r0 = r0 * r3
            int r0 = (int) r0
            r5.W(r2, r0, r6)
        L79:
            return r1
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.recyclerview.widget.RecyclerView.onGenericMotionEvent(android.view.MotionEvent):boolean");
    }

    /* JADX WARN: Multi-variable type inference failed */
    @Override // android.view.ViewGroup
    public final boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean z;
        if (!this.F) {
            this.z = null;
            if (B(motionEvent)) {
                V();
                setScrollState(0);
                return true;
            }
            AbstractC1157f10 abstractC1157f10 = this.w;
            if (abstractC1157f10 != null) {
                boolean zD = abstractC1157f10.d();
                boolean zE = this.w.e();
                if (this.V == null) {
                    this.V = VelocityTracker.obtain();
                }
                this.V.addMovement(motionEvent);
                int actionMasked = motionEvent.getActionMasked();
                int actionIndex = motionEvent.getActionIndex();
                if (actionMasked == 0) {
                    if (this.G) {
                        this.G = false;
                    }
                    this.U = motionEvent.getPointerId(0);
                    int x = (int) (motionEvent.getX() + 0.5f);
                    this.b0 = x;
                    this.W = x;
                    int y = (int) (motionEvent.getY() + 0.5f);
                    this.c0 = y;
                    this.a0 = y;
                    if (this.T == 2) {
                        getParent().requestDisallowInterceptTouchEvent(true);
                        setScrollState(1);
                        c0(1);
                    }
                    int[] iArr = this.y0;
                    iArr[1] = 0;
                    iArr[0] = 0;
                    int i = zD;
                    if (zE) {
                        i = (zD ? 1 : 0) | 2;
                    }
                    getScrollingChildHelper().g(i, 0);
                } else if (actionMasked == 1) {
                    this.V.clear();
                    c0(0);
                } else if (actionMasked == 2) {
                    int iFindPointerIndex = motionEvent.findPointerIndex(this.U);
                    if (iFindPointerIndex >= 0) {
                        int x2 = (int) (motionEvent.getX(iFindPointerIndex) + 0.5f);
                        int y2 = (int) (motionEvent.getY(iFindPointerIndex) + 0.5f);
                        if (this.T != 1) {
                            int i2 = x2 - this.W;
                            int i3 = y2 - this.a0;
                            if (zD == 0 || Math.abs(i2) <= this.d0) {
                                z = false;
                            } else {
                                this.b0 = x2;
                                z = true;
                            }
                            if (zE && Math.abs(i3) > this.d0) {
                                this.c0 = y2;
                                z = true;
                            }
                            if (z) {
                                setScrollState(1);
                            }
                        }
                    }
                } else if (actionMasked == 3) {
                    V();
                    setScrollState(0);
                } else if (actionMasked == 5) {
                    this.U = motionEvent.getPointerId(actionIndex);
                    int x3 = (int) (motionEvent.getX(actionIndex) + 0.5f);
                    this.b0 = x3;
                    this.W = x3;
                    int y3 = (int) (motionEvent.getY(actionIndex) + 0.5f);
                    this.c0 = y3;
                    this.a0 = y3;
                } else if (actionMasked == 6) {
                    R(motionEvent);
                }
                if (this.T == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5 = AbstractC1500ig0.a;
        Trace.beginSection("RV OnLayout");
        o();
        Trace.endSection();
        this.C = true;
    }

    @Override // android.view.View
    public final void onMeasure(int i, int i2) {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 == null) {
            n(i, i2);
            return;
        }
        boolean zL = abstractC1157f10.L();
        C2204q10 c2204q10 = this.n0;
        if (!zL) {
            if (this.B) {
                this.w.b.n(i, i2);
                return;
            }
            if (c2204q10.k) {
                setMeasuredDimension(getMeasuredWidth(), getMeasuredHeight());
                return;
            }
            X00 x00 = this.v;
            if (x00 != null) {
                c2204q10.e = x00.a();
            } else {
                c2204q10.e = 0;
            }
            a0();
            this.w.b.n(i, i2);
            b0(false);
            c2204q10.g = false;
            return;
        }
        int mode = View.MeasureSpec.getMode(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        this.w.b.n(i, i2);
        if ((mode == 1073741824 && mode2 == 1073741824) || this.v == null) {
            return;
        }
        if (c2204q10.d == 1) {
            p();
        }
        this.w.q0(i, i2);
        c2204q10.i = true;
        q();
        this.w.s0(i, i2);
        if (this.w.v0()) {
            this.w.q0(View.MeasureSpec.makeMeasureSpec(getMeasuredWidth(), 1073741824), View.MeasureSpec.makeMeasureSpec(getMeasuredHeight(), 1073741824));
            c2204q10.i = true;
            q();
            this.w.s0(i, i2);
        }
    }

    @Override // android.view.ViewGroup
    public final boolean onRequestFocusInDescendants(int i, Rect rect) {
        if (L()) {
            return false;
        }
        return super.onRequestFocusInDescendants(i, rect);
    }

    @Override // android.view.View
    public final void onRestoreInstanceState(Parcelable parcelable) {
        Parcelable parcelable2;
        if (!(parcelable instanceof C1919n10)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        C1919n10 c1919n10 = (C1919n10) parcelable;
        this.n = c1919n10;
        super.onRestoreInstanceState(c1919n10.l);
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 == null || (parcelable2 = this.n.n) == null) {
            return;
        }
        abstractC1157f10.d0(parcelable2);
    }

    @Override // android.view.View
    public final Parcelable onSaveInstanceState() {
        C1919n10 c1919n10 = new C1919n10(super.onSaveInstanceState());
        C1919n10 c1919n102 = this.n;
        if (c1919n102 != null) {
            c1919n10.n = c1919n102.n;
            return c1919n10;
        }
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null) {
            c1919n10.n = abstractC1157f10.e0();
            return c1919n10;
        }
        c1919n10.n = null;
        return c1919n10;
    }

    @Override // android.view.View
    public final void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        if (i == i3 && i2 == i4) {
            return;
        }
        this.R = null;
        this.P = null;
        this.Q = null;
        this.O = null;
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:102:0x01f8  */
    /* JADX WARN: Removed duplicated region for block: B:189:0x0331  */
    /* JADX WARN: Removed duplicated region for block: B:251:0x03ed  */
    /* JADX WARN: Removed duplicated region for block: B:252:0x03f3  */
    /* JADX WARN: Removed duplicated region for block: B:94:0x01df A[PHI: r1
      0x01df: PHI (r1v52 int) = (r1v37 int), (r1v56 int) binds: [B:88:0x01c8, B:92:0x01db] A[DONT_GENERATE, DONT_INLINE]] */
    /* JADX WARN: Removed duplicated region for block: B:96:0x01e2  */
    /* JADX WARN: Type inference failed for: r9v24, types: [boolean] */
    /* JADX WARN: Type inference failed for: r9v26 */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean onTouchEvent(android.view.MotionEvent r31) {
        /*
            Method dump skipped, instructions count: 1161
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.recyclerview.widget.RecyclerView.onTouchEvent(android.view.MotionEvent):boolean");
    }

    /* JADX WARN: Removed duplicated region for block: B:254:0x03c5  */
    /* JADX WARN: Removed duplicated region for block: B:347:0x0240 A[SYNTHETIC] */
    /* JADX WARN: Removed duplicated region for block: B:40:0x00e5  */
    /* JADX WARN: Removed duplicated region for block: B:42:0x00ec  */
    /* JADX WARN: Removed duplicated region for block: B:47:0x010c  */
    /* JADX WARN: Removed duplicated region for block: B:48:0x0110  */
    /* JADX WARN: Removed duplicated region for block: B:50:0x0118  */
    /* JADX WARN: Removed duplicated region for block: B:52:0x011d  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void p() {
        /*
            Method dump skipped, instructions count: 1378
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.recyclerview.widget.RecyclerView.p():void");
    }

    public final void q() {
        a0();
        P();
        C2204q10 c2204q10 = this.n0;
        c2204q10.a(6);
        this.f19o.j();
        c2204q10.e = this.v.a();
        c2204q10.c = 0;
        c2204q10.g = false;
        this.w.b0(this.m, c2204q10);
        c2204q10.f = false;
        this.n = null;
        c2204q10.j = c2204q10.j && this.S != null;
        c2204q10.d = 4;
        Q(true);
        b0(false);
    }

    public final boolean r(int i, int i2, int i3, int[] iArr, int[] iArr2) {
        return getScrollingChildHelper().c(i, i2, i3, iArr, iArr2);
    }

    @Override // android.view.ViewGroup
    public final void removeDetachedView(View view, boolean z) {
        AbstractC2488t10 abstractC2488t10I = I(view);
        if (abstractC2488t10I != null) {
            if (abstractC2488t10I.j()) {
                abstractC2488t10I.j &= -257;
            } else if (!abstractC2488t10I.o()) {
                throw new IllegalArgumentException("Called removeDetachedView with a view which is not flagged as tmp detached." + abstractC2488t10I + y());
            }
        }
        view.clearAnimation();
        I(view);
        super.removeDetachedView(view, z);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void requestChildFocus(View view, View view2) {
        C2896xL c2896xL = this.w.e;
        if ((c2896xL == null || !c2896xL.e) && !L() && view2 != null) {
            U(view, view2);
        }
        super.requestChildFocus(view, view2);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z) {
        return this.w.k0(this, view, rect, z, false);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void requestDisallowInterceptTouchEvent(boolean z) {
        ArrayList arrayList = this.y;
        int size = arrayList.size();
        for (int i = 0; i < size; i++) {
            ((C0205Hx) arrayList.get(i)).getClass();
        }
        super.requestDisallowInterceptTouchEvent(z);
    }

    @Override // android.view.View, android.view.ViewParent
    public final void requestLayout() {
        if (this.D != 0 || this.F) {
            this.E = true;
        } else {
            super.requestLayout();
        }
    }

    public final void s(int i, int i2, int i3, int i4, int[] iArr, int i5, int[] iArr2) {
        getScrollingChildHelper().d(i, i2, i3, i4, iArr, i5, iArr2);
    }

    @Override // android.view.View
    public final void scrollBy(int i, int i2) {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 == null || this.F) {
            return;
        }
        boolean zD = abstractC1157f10.d();
        boolean zE = this.w.e();
        if (zD || zE) {
            if (!zD) {
                i = 0;
            }
            if (!zE) {
                i2 = 0;
            }
            W(i, i2, null);
        }
    }

    @Override // android.view.View, android.view.accessibility.AccessibilityEventSource
    public final void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        if (!L()) {
            super.sendAccessibilityEventUnchecked(accessibilityEvent);
        } else {
            int contentChangeTypes = accessibilityEvent != null ? accessibilityEvent.getContentChangeTypes() : 0;
            this.H |= contentChangeTypes != 0 ? contentChangeTypes : 0;
        }
    }

    public void setAccessibilityDelegateCompat(C2678v10 c2678v10) {
        this.u0 = c2678v10;
        Oj0.m(this, c2678v10);
    }

    public void setAdapter(X00 x00) {
        setLayoutFrozen(false);
        X00 x002 = this.v;
        C2616uQ c2616uQ = this.l;
        if (x002 != null) {
            x002.a.unregisterObserver(c2616uQ);
            this.v.getClass();
        }
        AbstractC0775b10 abstractC0775b10 = this.S;
        if (abstractC0775b10 != null) {
            abstractC0775b10.e();
        }
        AbstractC1157f10 abstractC1157f10 = this.w;
        C1729l10 c1729l10 = this.m;
        if (abstractC1157f10 != null) {
            abstractC1157f10.g0(c1729l10);
            this.w.h0(c1729l10);
        }
        c1729l10.a.clear();
        c1729l10.d();
        Q1 q1 = this.f19o;
        q1.y((ArrayList) q1.m);
        q1.y((ArrayList) q1.n);
        X00 x003 = this.v;
        this.v = x00;
        if (x00 != null) {
            x00.a.registerObserver(c2616uQ);
        }
        X00 x004 = this.v;
        c1729l10.a.clear();
        c1729l10.d();
        C1634k10 c1634k10C = c1729l10.c();
        if (x003 != null) {
            c1634k10C.b--;
        }
        if (c1634k10C.b == 0) {
            SparseArray sparseArray = c1634k10C.a;
            for (int i = 0; i < sparseArray.size(); i++) {
                ((C1539j10) sparseArray.valueAt(i)).a.clear();
            }
        }
        if (x004 != null) {
            c1634k10C.b++;
        }
        this.n0.f = true;
        this.K |= false;
        this.J = true;
        int iF = this.p.F();
        for (int i2 = 0; i2 < iF; i2++) {
            AbstractC2488t10 abstractC2488t10I = I(this.p.E(i2));
            if (abstractC2488t10I != null && !abstractC2488t10I.o()) {
                abstractC2488t10I.a(6);
            }
        }
        N();
        C1729l10 c1729l102 = this.m;
        ArrayList arrayList = c1729l102.c;
        int size = arrayList.size();
        for (int i3 = 0; i3 < size; i3++) {
            AbstractC2488t10 abstractC2488t10 = (AbstractC2488t10) arrayList.get(i3);
            if (abstractC2488t10 != null) {
                abstractC2488t10.a(6);
                abstractC2488t10.a(1024);
            }
        }
        X00 x005 = c1729l102.h.v;
        if (x005 == null || !x005.b) {
            c1729l102.d();
        }
        requestLayout();
    }

    public void setChildDrawingOrderCallback(Z00 z00) {
        if (z00 == null) {
            return;
        }
        setChildrenDrawingOrderEnabled(false);
    }

    @Override // android.view.ViewGroup
    public void setClipToPadding(boolean z) {
        if (z != this.r) {
            this.R = null;
            this.P = null;
            this.Q = null;
            this.O = null;
        }
        this.r = z;
        super.setClipToPadding(z);
        if (this.C) {
            requestLayout();
        }
    }

    public void setEdgeEffectFactory(C0679a10 c0679a10) {
        c0679a10.getClass();
        this.N = c0679a10;
        this.R = null;
        this.P = null;
        this.Q = null;
        this.O = null;
    }

    public void setHasFixedSize(boolean z) {
        this.B = z;
    }

    public void setItemAnimator(AbstractC0775b10 abstractC0775b10) {
        AbstractC0775b10 abstractC0775b102 = this.S;
        if (abstractC0775b102 != null) {
            abstractC0775b102.e();
            this.S.a = null;
        }
        this.S = abstractC0775b10;
        if (abstractC0775b10 != null) {
            abstractC0775b10.a = this.s0;
        }
    }

    public void setItemViewCacheSize(int i) {
        C1729l10 c1729l10 = this.m;
        c1729l10.e = i;
        c1729l10.k();
    }

    @Deprecated
    public void setLayoutFrozen(boolean z) {
        suppressLayout(z);
    }

    public void setLayoutManager(AbstractC1157f10 abstractC1157f10) {
        C2896xL c2896xL;
        if (abstractC1157f10 == this.w) {
            return;
        }
        setScrollState(0);
        RunnableC2393s10 runnableC2393s10 = this.k0;
        runnableC2393s10.r.removeCallbacks(runnableC2393s10);
        runnableC2393s10.n.abortAnimation();
        AbstractC1157f10 abstractC1157f102 = this.w;
        if (abstractC1157f102 != null && (c2896xL = abstractC1157f102.e) != null) {
            c2896xL.i();
        }
        AbstractC1157f10 abstractC1157f103 = this.w;
        C1729l10 c1729l10 = this.m;
        if (abstractC1157f103 != null) {
            AbstractC0775b10 abstractC0775b10 = this.S;
            if (abstractC0775b10 != null) {
                abstractC0775b10.e();
            }
            this.w.g0(c1729l10);
            this.w.h0(c1729l10);
            c1729l10.a.clear();
            c1729l10.d();
            if (this.A) {
                AbstractC1157f10 abstractC1157f104 = this.w;
                abstractC1157f104.g = false;
                abstractC1157f104.R(this);
            }
            this.w.t0(null);
            this.w = null;
        } else {
            c1729l10.a.clear();
            c1729l10.d();
        }
        C3126zm0 c3126zm0 = this.p;
        RecyclerView recyclerView = ((W00) c3126zm0.m).a;
        ((C0189Hh) c3126zm0.n).k();
        ArrayList arrayList = (ArrayList) c3126zm0.f831o;
        for (int size = arrayList.size() - 1; size >= 0; size--) {
            AbstractC2488t10 abstractC2488t10I = I((View) arrayList.get(size));
            if (abstractC2488t10I != null) {
                int i = abstractC2488t10I.p;
                if (recyclerView.L()) {
                    abstractC2488t10I.q = i;
                    recyclerView.A0.add(abstractC2488t10I);
                } else {
                    View view = abstractC2488t10I.a;
                    WeakHashMap weakHashMap = Oj0.a;
                    view.setImportantForAccessibility(i);
                }
                abstractC2488t10I.p = 0;
            }
            arrayList.remove(size);
        }
        int childCount = recyclerView.getChildCount();
        for (int i2 = 0; i2 < childCount; i2++) {
            View childAt = recyclerView.getChildAt(i2);
            I(childAt);
            childAt.clearAnimation();
        }
        recyclerView.removeAllViews();
        this.w = abstractC1157f10;
        if (abstractC1157f10 != null) {
            if (abstractC1157f10.b != null) {
                throw new IllegalArgumentException("LayoutManager " + abstractC1157f10 + " is already attached to a RecyclerView:" + abstractC1157f10.b.y());
            }
            abstractC1157f10.t0(this);
            if (this.A) {
                AbstractC1157f10 abstractC1157f105 = this.w;
                abstractC1157f105.g = true;
                abstractC1157f105.Q(this);
            }
        }
        c1729l10.k();
        requestLayout();
    }

    @Override // android.view.ViewGroup
    @Deprecated
    public void setLayoutTransition(LayoutTransition layoutTransition) {
        if (layoutTransition != null) {
            throw new IllegalArgumentException("Providing a LayoutTransition into RecyclerView is not supported. Please use setItemAnimator() instead for animating changes to the items in this RecyclerView");
        }
        super.setLayoutTransition(null);
    }

    @Override // android.view.View
    public void setNestedScrollingEnabled(boolean z) {
        QR scrollingChildHelper = getScrollingChildHelper();
        if (scrollingChildHelper.d) {
            ViewGroup viewGroup = scrollingChildHelper.c;
            WeakHashMap weakHashMap = Oj0.a;
            Gj0.n(viewGroup);
        }
        scrollingChildHelper.d = z;
    }

    public void setOnFlingListener(AbstractC1349h10 abstractC1349h10) {
        this.e0 = abstractC1349h10;
    }

    @Deprecated
    public void setOnScrollListener(AbstractC1445i10 abstractC1445i10) {
        this.o0 = abstractC1445i10;
    }

    public void setPreserveFocusAfterLayout(boolean z) {
        this.j0 = z;
    }

    public void setRecycledViewPool(C1634k10 c1634k10) {
        C1729l10 c1729l10 = this.m;
        if (c1729l10.g != null) {
            r1.b--;
        }
        c1729l10.g = c1634k10;
        if (c1634k10 == null || c1729l10.h.getAdapter() == null) {
            return;
        }
        c1729l10.g.b++;
    }

    public void setScrollState(int i) {
        C2896xL c2896xL;
        if (i == this.T) {
            return;
        }
        this.T = i;
        if (i != 2) {
            RunnableC2393s10 runnableC2393s10 = this.k0;
            runnableC2393s10.r.removeCallbacks(runnableC2393s10);
            runnableC2393s10.n.abortAnimation();
            AbstractC1157f10 abstractC1157f10 = this.w;
            if (abstractC1157f10 != null && (c2896xL = abstractC1157f10.e) != null) {
                c2896xL.i();
            }
        }
        AbstractC1157f10 abstractC1157f102 = this.w;
        if (abstractC1157f102 != null) {
            abstractC1157f102.f0(i);
        }
        AbstractC1445i10 abstractC1445i10 = this.o0;
        if (abstractC1445i10 != null) {
            abstractC1445i10.a(this, i);
        }
        ArrayList arrayList = this.p0;
        if (arrayList != null) {
            for (int size = arrayList.size() - 1; size >= 0; size--) {
                ((AbstractC1445i10) this.p0.get(size)).a(this, i);
            }
        }
    }

    public void setScrollingTouchSlop(int i) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get(getContext());
        if (i != 1) {
            this.d0 = viewConfiguration.getScaledTouchSlop();
        } else {
            this.d0 = viewConfiguration.getScaledPagingTouchSlop();
        }
    }

    public void setViewCacheExtension(AbstractC2298r10 abstractC2298r10) {
        this.m.getClass();
    }

    @Override // android.view.View
    public final boolean startNestedScroll(int i) {
        return getScrollingChildHelper().g(i, 0);
    }

    @Override // android.view.View
    public final void stopNestedScroll() {
        getScrollingChildHelper().h(0);
    }

    @Override // android.view.ViewGroup
    public final void suppressLayout(boolean z) {
        C2896xL c2896xL;
        if (z != this.F) {
            i("Do not suppressLayout in layout or scroll");
            if (!z) {
                this.F = false;
                if (this.E && this.w != null && this.v != null) {
                    requestLayout();
                }
                this.E = false;
                return;
            }
            long jUptimeMillis = SystemClock.uptimeMillis();
            onTouchEvent(MotionEvent.obtain(jUptimeMillis, jUptimeMillis, 3, 0.0f, 0.0f, 0));
            this.F = true;
            this.G = true;
            setScrollState(0);
            RunnableC2393s10 runnableC2393s10 = this.k0;
            runnableC2393s10.r.removeCallbacks(runnableC2393s10);
            runnableC2393s10.n.abortAnimation();
            AbstractC1157f10 abstractC1157f10 = this.w;
            if (abstractC1157f10 == null || (c2896xL = abstractC1157f10.e) == null) {
                return;
            }
            c2896xL.i();
        }
    }

    public final void t(int i, int i2) {
        this.M++;
        int scrollX = getScrollX();
        int scrollY = getScrollY();
        onScrollChanged(scrollX, scrollY, scrollX - i, scrollY - i2);
        AbstractC1445i10 abstractC1445i10 = this.o0;
        if (abstractC1445i10 != null) {
            abstractC1445i10.b(this, i, i2);
        }
        ArrayList arrayList = this.p0;
        if (arrayList != null) {
            for (int size = arrayList.size() - 1; size >= 0; size--) {
                ((AbstractC1445i10) this.p0.get(size)).b(this, i, i2);
            }
        }
        this.M--;
    }

    public final void u() {
        if (this.R != null) {
            return;
        }
        this.N.getClass();
        EdgeEffect edgeEffect = new EdgeEffect(getContext());
        this.R = edgeEffect;
        if (this.r) {
            edgeEffect.setSize((getMeasuredWidth() - getPaddingLeft()) - getPaddingRight(), (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom());
        } else {
            edgeEffect.setSize(getMeasuredWidth(), getMeasuredHeight());
        }
    }

    public final void v() {
        if (this.O != null) {
            return;
        }
        this.N.getClass();
        EdgeEffect edgeEffect = new EdgeEffect(getContext());
        this.O = edgeEffect;
        if (this.r) {
            edgeEffect.setSize((getMeasuredHeight() - getPaddingTop()) - getPaddingBottom(), (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight());
        } else {
            edgeEffect.setSize(getMeasuredHeight(), getMeasuredWidth());
        }
    }

    public final void w() {
        if (this.Q != null) {
            return;
        }
        this.N.getClass();
        EdgeEffect edgeEffect = new EdgeEffect(getContext());
        this.Q = edgeEffect;
        if (this.r) {
            edgeEffect.setSize((getMeasuredHeight() - getPaddingTop()) - getPaddingBottom(), (getMeasuredWidth() - getPaddingLeft()) - getPaddingRight());
        } else {
            edgeEffect.setSize(getMeasuredHeight(), getMeasuredWidth());
        }
    }

    public final void x() {
        if (this.P != null) {
            return;
        }
        this.N.getClass();
        EdgeEffect edgeEffect = new EdgeEffect(getContext());
        this.P = edgeEffect;
        if (this.r) {
            edgeEffect.setSize((getMeasuredWidth() - getPaddingLeft()) - getPaddingRight(), (getMeasuredHeight() - getPaddingTop()) - getPaddingBottom());
        } else {
            edgeEffect.setSize(getMeasuredWidth(), getMeasuredHeight());
        }
    }

    public final String y() {
        return " " + super.toString() + ", adapter:" + this.v + ", layout:" + this.w + ", context:" + getContext();
    }

    public final void z(C2204q10 c2204q10) {
        if (getScrollState() != 2) {
            c2204q10.getClass();
            return;
        }
        OverScroller overScroller = this.k0.n;
        overScroller.getFinalX();
        overScroller.getCurrX();
        c2204q10.getClass();
        overScroller.getFinalY();
        overScroller.getCurrY();
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r17v0 */
    /* JADX WARN: Type inference failed for: r17v1 */
    /* JADX WARN: Type inference failed for: r17v2 */
    public RecyclerView(Context context, AttributeSet attributeSet, int i) throws NoSuchMethodException, SecurityException {
        float fA;
        int i2;
        char c;
        TypedArray typedArray;
        boolean z;
        char c2;
        AttributeSet attributeSet2;
        int i3;
        Constructor constructor;
        super(context, attributeSet, i);
        this.l = new C2616uQ(9, this);
        this.m = new C1729l10(this);
        this.q = new C1390hY(13);
        this.s = new Rect();
        this.t = new Rect();
        this.u = new RectF();
        this.x = new ArrayList();
        this.y = new ArrayList();
        this.D = 0;
        this.J = false;
        this.K = false;
        this.L = 0;
        this.M = 0;
        this.N = new C0679a10();
        C1899mq c1899mq = new C1899mq();
        Object[] objArr = null;
        c1899mq.a = null;
        c1899mq.b = new ArrayList();
        c1899mq.c = 120L;
        c1899mq.d = 120L;
        c1899mq.e = 250L;
        c1899mq.f = 250L;
        c1899mq.g = true;
        c1899mq.h = new ArrayList();
        c1899mq.i = new ArrayList();
        c1899mq.j = new ArrayList();
        c1899mq.k = new ArrayList();
        c1899mq.l = new ArrayList();
        c1899mq.m = new ArrayList();
        c1899mq.n = new ArrayList();
        c1899mq.f640o = new ArrayList();
        c1899mq.p = new ArrayList();
        c1899mq.q = new ArrayList();
        c1899mq.r = new ArrayList();
        this.S = c1899mq;
        this.T = 0;
        this.U = -1;
        this.h0 = Float.MIN_VALUE;
        this.i0 = Float.MIN_VALUE;
        this.j0 = true;
        this.k0 = new RunnableC2393s10(this);
        this.m0 = new C2642ui(2);
        C2204q10 c2204q10 = new C2204q10();
        c2204q10.a = -1;
        c2204q10.b = 0;
        c2204q10.c = 0;
        c2204q10.d = 1;
        c2204q10.e = 0;
        c2204q10.f = false;
        c2204q10.g = false;
        c2204q10.h = false;
        c2204q10.i = false;
        c2204q10.j = false;
        c2204q10.k = false;
        this.n0 = c2204q10;
        this.q0 = false;
        this.r0 = false;
        W00 w00 = new W00(this);
        this.s0 = w00;
        this.t0 = false;
        this.v0 = new int[2];
        this.x0 = new int[2];
        this.y0 = new int[2];
        this.z0 = new int[2];
        this.A0 = new ArrayList();
        this.B0 = new RunnableC2017o3(14, this);
        this.C0 = new W00(this);
        setScrollContainer(true);
        setFocusableInTouchMode(true);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        this.d0 = viewConfiguration.getScaledTouchSlop();
        int i4 = Build.VERSION.SDK_INT;
        if (i4 >= 26) {
            Method method = Rj0.a;
            fA = AbstractC1456i7.f(viewConfiguration);
        } else {
            fA = Rj0.a(viewConfiguration, context);
        }
        this.h0 = fA;
        this.i0 = i4 >= 26 ? AbstractC1456i7.g(viewConfiguration) : Rj0.a(viewConfiguration, context);
        this.f0 = viewConfiguration.getScaledMinimumFlingVelocity();
        this.g0 = viewConfiguration.getScaledMaximumFlingVelocity();
        setWillNotDraw(getOverScrollMode() == 2);
        this.S.a = w00;
        this.f19o = new Q1(new W00(this));
        this.p = new C3126zm0(new W00(this));
        WeakHashMap weakHashMap = Oj0.a;
        if ((i4 >= 26 ? Ij0.a(this) : 0) == 0 && i4 >= 26) {
            Ij0.b(this, 8);
        }
        if (getImportantForAccessibility() == 0) {
            setImportantForAccessibility(1);
        }
        this.I = (AccessibilityManager) getContext().getSystemService("accessibility");
        setAccessibilityDelegateCompat(new C2678v10(this));
        int[] iArr = VZ.a;
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, iArr, i, 0);
        if (i4 >= 29) {
            saveAttributeDataForStyleable(context, iArr, attributeSet, typedArrayObtainStyledAttributes, i, 0);
        }
        String string = typedArrayObtainStyledAttributes.getString(8);
        if (typedArrayObtainStyledAttributes.getInt(2, -1) == -1) {
            setDescendantFocusability(262144);
        }
        this.r = typedArrayObtainStyledAttributes.getBoolean(1, true);
        if (typedArrayObtainStyledAttributes.getBoolean(3, false)) {
            StateListDrawable stateListDrawable = (StateListDrawable) typedArrayObtainStyledAttributes.getDrawable(6);
            Drawable drawable = typedArrayObtainStyledAttributes.getDrawable(7);
            StateListDrawable stateListDrawable2 = (StateListDrawable) typedArrayObtainStyledAttributes.getDrawable(4);
            Drawable drawable2 = typedArrayObtainStyledAttributes.getDrawable(5);
            if (stateListDrawable == null || drawable == null || stateListDrawable2 == null || drawable2 == null) {
                throw new IllegalArgumentException("Trying to set fast scroller without both required drawables." + y());
            }
            Resources resources = getContext().getResources();
            c2 = 2;
            i2 = i;
            z = 1;
            c = 3;
            i3 = 4;
            typedArray = typedArrayObtainStyledAttributes;
            attributeSet2 = attributeSet;
            new C0205Hx(this, stateListDrawable, drawable, stateListDrawable2, drawable2, resources.getDimensionPixelSize(com.google.android.gms.common.R.dimen.fastscroll_default_thickness), resources.getDimensionPixelSize(com.google.android.gms.common.R.dimen.fastscroll_minimum_range), resources.getDimensionPixelOffset(com.google.android.gms.common.R.dimen.fastscroll_margin));
        } else {
            i2 = i;
            c = 3;
            typedArray = typedArrayObtainStyledAttributes;
            z = 1;
            c2 = 2;
            attributeSet2 = attributeSet;
            i3 = 4;
        }
        typedArray.recycle();
        if (string != null) {
            String strTrim = string.trim();
            if (!strTrim.isEmpty()) {
                if (strTrim.charAt(0) == '.') {
                    strTrim = context.getPackageName() + strTrim;
                } else if (!strTrim.contains(".")) {
                    strTrim = RecyclerView.class.getPackage().getName() + '.' + strTrim;
                }
                String str = strTrim;
                try {
                    Class clsAsSubclass = Class.forName(str, false, isInEditMode() ? getClass().getClassLoader() : context.getClassLoader()).asSubclass(AbstractC1157f10.class);
                    try {
                        constructor = clsAsSubclass.getConstructor(E0);
                        Object[] objArr2 = new Object[i3];
                        objArr2[0] = context;
                        objArr2[z] = attributeSet2;
                        objArr2[c2] = Integer.valueOf(i2);
                        objArr2[c] = 0;
                        objArr = objArr2;
                    } catch (NoSuchMethodException e) {
                        try {
                            constructor = clsAsSubclass.getConstructor(null);
                        } catch (NoSuchMethodException e2) {
                            e2.initCause(e);
                            throw new IllegalStateException(attributeSet2.getPositionDescription() + ": Error creating LayoutManager " + str, e2);
                        }
                    }
                    constructor.setAccessible(z);
                    setLayoutManager((AbstractC1157f10) constructor.newInstance(objArr));
                } catch (ClassCastException e3) {
                    throw new IllegalStateException(attributeSet2.getPositionDescription() + ": Class is not a LayoutManager " + str, e3);
                } catch (ClassNotFoundException e4) {
                    throw new IllegalStateException(attributeSet2.getPositionDescription() + ": Unable to find LayoutManager " + str, e4);
                } catch (IllegalAccessException e5) {
                    throw new IllegalStateException(attributeSet2.getPositionDescription() + ": Cannot access non-public constructor " + str, e5);
                } catch (InstantiationException e6) {
                    throw new IllegalStateException(attributeSet2.getPositionDescription() + ": Could not instantiate the LayoutManager: " + str, e6);
                } catch (InvocationTargetException e7) {
                    throw new IllegalStateException(attributeSet2.getPositionDescription() + ": Could not instantiate the LayoutManager: " + str, e7);
                }
            }
        }
        int i5 = Build.VERSION.SDK_INT;
        int[] iArr2 = D0;
        TypedArray typedArrayObtainStyledAttributes2 = context.obtainStyledAttributes(attributeSet2, iArr2, i2, 0);
        if (i5 >= 29) {
            saveAttributeDataForStyleable(context, iArr2, attributeSet2, typedArrayObtainStyledAttributes2, i2, 0);
        }
        boolean z2 = typedArrayObtainStyledAttributes2.getBoolean(0, true);
        typedArrayObtainStyledAttributes2.recycle();
        setNestedScrollingEnabled(z2);
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        AbstractC1157f10 abstractC1157f10 = this.w;
        if (abstractC1157f10 != null) {
            return abstractC1157f10.t(layoutParams);
        }
        throw new IllegalStateException("RecyclerView has no LayoutManager" + y());
    }

    public void setRecyclerListener(InterfaceC1824m10 interfaceC1824m10) {
    }

    @Override // android.view.View
    public final void scrollTo(int i, int i2) {
    }
}
