package androidx.fragment.app;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import o.AbstractC1843mC;
import o.AbstractC2462sn;
import o.C0794bC;
import o.C1653kC;
import o.C1748lC;
import o.UZ;
import o.WB;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public final class r implements LayoutInflater.Factory2 {
    public final s l;

    public r(s sVar) {
        this.l = sVar;
    }

    @Override // android.view.LayoutInflater.Factory
    public final View onCreateView(String str, Context context, AttributeSet attributeSet) {
        return onCreateView(null, str, context, attributeSet);
    }

    @Override // android.view.LayoutInflater.Factory2
    public final View onCreateView(View view, String str, Context context, AttributeSet attributeSet) {
        boolean zIsAssignableFrom;
        v vVarF;
        boolean zEquals = FragmentContainerView.class.getName().equals(str);
        s sVar = this.l;
        if (zEquals) {
            return new FragmentContainerView(context, attributeSet, sVar);
        }
        if ("fragment".equals(str)) {
            String attributeValue = attributeSet.getAttributeValue(null, "class");
            TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, UZ.a);
            if (attributeValue == null) {
                attributeValue = typedArrayObtainStyledAttributes.getString(0);
            }
            int resourceId = typedArrayObtainStyledAttributes.getResourceId(1, -1);
            String string = typedArrayObtainStyledAttributes.getString(2);
            typedArrayObtainStyledAttributes.recycle();
            if (attributeValue != null) {
                try {
                    zIsAssignableFrom = l.class.isAssignableFrom(C0794bC.a(context.getClassLoader(), attributeValue));
                } catch (ClassNotFoundException unused) {
                    zIsAssignableFrom = false;
                }
                if (zIsAssignableFrom) {
                    int id = view != null ? view.getId() : 0;
                    if (id == -1 && resourceId == -1 && string == null) {
                        throw new IllegalArgumentException(attributeSet.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with an id for " + attributeValue);
                    }
                    l lVarA = resourceId != -1 ? sVar.A(resourceId) : null;
                    if (lVarA == null && string != null) {
                        lVarA = sVar.B(string);
                    }
                    if (lVarA == null && id != -1) {
                        lVarA = sVar.A(id);
                    }
                    if (lVarA == null) {
                        C0794bC c0794bCD = sVar.D();
                        context.getClassLoader();
                        lVarA = l.instantiate(c0794bCD.a.t.m, attributeValue, null);
                        lVarA.mFromLayout = true;
                        lVarA.mFragmentId = resourceId != 0 ? resourceId : id;
                        lVarA.mContainerId = id;
                        lVarA.mTag = string;
                        lVarA.mInLayout = true;
                        lVarA.mFragmentManager = sVar;
                        WB wb = sVar.t;
                        lVarA.mHost = wb;
                        lVarA.onInflate((Context) wb.m, attributeSet, lVarA.mSavedFragmentState);
                        vVarF = sVar.a(lVarA);
                        if (s.F(2)) {
                            lVarA.toString();
                            Integer.toHexString(resourceId);
                        }
                    } else {
                        if (lVarA.mInLayout) {
                            throw new IllegalArgumentException(attributeSet.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(resourceId) + ", tag " + string + ", or parent id 0x" + Integer.toHexString(id) + " with another fragment for " + attributeValue);
                        }
                        lVarA.mInLayout = true;
                        lVarA.mFragmentManager = sVar;
                        WB wb2 = sVar.t;
                        lVarA.mHost = wb2;
                        lVarA.onInflate((Context) wb2.m, attributeSet, lVarA.mSavedFragmentState);
                        vVarF = sVar.f(lVarA);
                        if (s.F(2)) {
                            lVarA.toString();
                            Integer.toHexString(resourceId);
                        }
                    }
                    ViewGroup viewGroup = (ViewGroup) view;
                    C1748lC c1748lC = AbstractC1843mC.a;
                    AbstractC1843mC.b(new C1653kC(lVarA, "Attempting to use <fragment> tag to add fragment " + lVarA + " to container " + viewGroup));
                    AbstractC1843mC.a(lVarA).getClass();
                    lVarA.mContainer = viewGroup;
                    vVarF.i();
                    vVarF.h();
                    View view2 = lVarA.mView;
                    if (view2 == null) {
                        throw new IllegalStateException(AbstractC2462sn.j("Fragment ", attributeValue, " did not create a view."));
                    }
                    if (resourceId != 0) {
                        view2.setId(resourceId);
                    }
                    if (lVarA.mView.getTag() == null) {
                        lVarA.mView.setTag(string);
                    }
                    lVarA.mView.addOnAttachStateChangeListener(new q(this, vVarF));
                    return lVarA.mView;
                }
            }
        }
        return null;
    }
}
