package androidx.fragment.app;

import android.animation.Animator;
import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import o.AbstractC0118Eo;
import o.AbstractC0126Ew;
import o.AbstractC0940cn0;
import o.AbstractC1075e80;
import o.AbstractC1186fM;
import o.AbstractC1282gM;
import o.AbstractC1843mC;
import o.AbstractC2378rs0;
import o.AbstractC2461sm0;
import o.AbstractC2462sn;
import o.AbstractC2772w1;
import o.AbstractC2841wm0;
import o.AbstractC2962y1;
import o.C0247Jn;
import o.C0794bC;
import o.C0914ca0;
import o.C0985dC;
import o.C1089eL;
import o.C1125ek0;
import o.C1164f5;
import o.C1272gC;
import o.C1413hk0;
import o.C1640k40;
import o.C1653kC;
import o.C1659kI;
import o.C1735l40;
import o.C1748lC;
import o.C1830m40;
import o.C2020o40;
import o.C2170pj;
import o.C2629ub0;
import o.CC;
import o.E1;
import o.FQ;
import o.IE;
import o.InterfaceC0898cL;
import o.InterfaceC1221fk0;
import o.InterfaceC1508ik0;
import o.InterfaceC1558jC;
import o.InterfaceC1925n40;
import o.InterfaceC2677v1;
import o.LQ;
import o.MD;
import o.NB;
import o.ND;
import o.OB;
import o.PB;
import o.QB;
import o.RB;
import o.RunnableC2017o3;
import o.SB;
import o.UB;
import o.UK;
import o.VK;
import o.WB;
import o.WK;
import o.XC;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public abstract class l implements ComponentCallbacks, View.OnCreateContextMenuListener, InterfaceC0898cL, InterfaceC1508ik0, IE, InterfaceC1925n40 {
    static final int ACTIVITY_CREATED = 4;
    static final int ATTACHED = 0;
    static final int AWAITING_ENTER_EFFECTS = 6;
    static final int AWAITING_EXIT_EFFECTS = 3;
    static final int CREATED = 1;
    static final int INITIALIZING = -1;
    static final int RESUMED = 7;
    static final int STARTED = 5;
    static final Object USE_DEFAULT_TRANSITION = new Object();
    static final int VIEW_CREATED = 2;
    boolean mAdded;
    QB mAnimationInfo;
    Bundle mArguments;
    int mBackStackNesting;
    boolean mBeingSaved;
    private boolean mCalled;
    ViewGroup mContainer;
    int mContainerId;
    private int mContentLayoutId;
    InterfaceC1221fk0 mDefaultFactory;
    boolean mDeferStart;
    boolean mDetached;
    int mFragmentId;
    s mFragmentManager;
    boolean mFromLayout;
    boolean mHasMenu;
    boolean mHidden;
    boolean mHiddenChanged;
    WB mHost;
    boolean mInLayout;
    boolean mIsCreated;
    LayoutInflater mLayoutInflater;
    C1089eL mLifecycleRegistry;
    l mParentFragment;
    boolean mPerformedCreateView;
    public String mPreviousWho;
    boolean mRemoving;
    boolean mRestored;
    boolean mRetainInstance;
    boolean mRetainInstanceChangedWhileDetached;
    Bundle mSavedFragmentState;
    C1735l40 mSavedStateRegistryController;
    Boolean mSavedUserVisibleHint;
    Bundle mSavedViewRegistryState;
    SparseArray<Parcelable> mSavedViewState;
    String mTag;
    l mTarget;
    int mTargetRequestCode;
    View mView;
    CC mViewLifecycleOwner;
    int mState = -1;
    String mWho = UUID.randomUUID().toString();
    String mTargetWho = null;
    private Boolean mIsPrimaryNavigationFragment = null;
    s mChildFragmentManager = new C1272gC();
    boolean mMenuVisible = true;
    boolean mUserVisibleHint = true;
    Runnable mPostponedDurationRunnable = new OB(this, 0);
    VK mMaxState = VK.p;
    LQ mViewLifecycleOwnerLiveData = new LQ();
    private final AtomicInteger mNextLocalRequestCode = new AtomicInteger();
    private final ArrayList<RB> mOnPreAttachedListeners = new ArrayList<>();
    private final RB mSavedStateAttachListener = new h(this);

    public l() {
        d();
    }

    @Deprecated
    public static l instantiate(Context context, String str) {
        return instantiate(context, str, null);
    }

    public final QB a() {
        if (this.mAnimationInfo == null) {
            QB qb = new QB();
            qb.i = null;
            Object obj = USE_DEFAULT_TRANSITION;
            qb.j = obj;
            qb.k = null;
            qb.l = obj;
            qb.m = null;
            qb.n = obj;
            qb.q = 1.0f;
            qb.r = null;
            this.mAnimationInfo = qb;
        }
        return this.mAnimationInfo;
    }

    public final int b() {
        VK vk = this.mMaxState;
        return (vk == VK.m || this.mParentFragment == null) ? vk.ordinal() : Math.min(vk.ordinal(), this.mParentFragment.b());
    }

    public final l c(boolean z) {
        String str;
        if (z) {
            C1748lC c1748lC = AbstractC1843mC.a;
            AbstractC1843mC.b(new ND(this, "Attempting to get target fragment from fragment " + this));
            AbstractC1843mC.a(this).getClass();
        }
        l lVar = this.mTarget;
        if (lVar != null) {
            return lVar;
        }
        s sVar = this.mFragmentManager;
        if (sVar == null || (str = this.mTargetWho) == null) {
            return null;
        }
        return sVar.c.b(str);
    }

    public void callStartTransitionListener(boolean z) {
        ViewGroup viewGroup;
        s sVar;
        QB qb = this.mAnimationInfo;
        if (qb != null) {
            qb.s = false;
        }
        if (this.mView == null || (viewGroup = this.mContainer) == null || (sVar = this.mFragmentManager) == null) {
            return;
        }
        f fVarI = f.i(viewGroup, sVar.E());
        fVarI.j();
        if (z) {
            this.mHost.n.post(new RunnableC2017o3(9, fVarI));
        } else {
            fVarI.d();
        }
    }

    public UB createFragmentContainer() {
        return new i(this);
    }

    public final void d() {
        this.mLifecycleRegistry = new C1089eL(this);
        this.mSavedStateRegistryController = new C1735l40(new C1830m40(this, new C1164f5(16, this)));
        this.mDefaultFactory = null;
        if (this.mOnPreAttachedListeners.contains(this.mSavedStateAttachListener)) {
            return;
        }
        RB rb = this.mSavedStateAttachListener;
        if (this.mState >= 0) {
            rb.a();
        } else {
            this.mOnPreAttachedListeners.add(rb);
        }
    }

    public void dump(String str, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] strArr) {
        printWriter.print(str);
        printWriter.print("mFragmentId=#");
        printWriter.print(Integer.toHexString(this.mFragmentId));
        printWriter.print(" mContainerId=#");
        printWriter.print(Integer.toHexString(this.mContainerId));
        printWriter.print(" mTag=");
        printWriter.println(this.mTag);
        printWriter.print(str);
        printWriter.print("mState=");
        printWriter.print(this.mState);
        printWriter.print(" mWho=");
        printWriter.print(this.mWho);
        printWriter.print(" mBackStackNesting=");
        printWriter.println(this.mBackStackNesting);
        printWriter.print(str);
        printWriter.print("mAdded=");
        printWriter.print(this.mAdded);
        printWriter.print(" mRemoving=");
        printWriter.print(this.mRemoving);
        printWriter.print(" mFromLayout=");
        printWriter.print(this.mFromLayout);
        printWriter.print(" mInLayout=");
        printWriter.println(this.mInLayout);
        printWriter.print(str);
        printWriter.print("mHidden=");
        printWriter.print(this.mHidden);
        printWriter.print(" mDetached=");
        printWriter.print(this.mDetached);
        printWriter.print(" mMenuVisible=");
        printWriter.print(this.mMenuVisible);
        printWriter.print(" mHasMenu=");
        printWriter.println(this.mHasMenu);
        printWriter.print(str);
        printWriter.print("mRetainInstance=");
        printWriter.print(this.mRetainInstance);
        printWriter.print(" mUserVisibleHint=");
        printWriter.println(this.mUserVisibleHint);
        if (this.mFragmentManager != null) {
            printWriter.print(str);
            printWriter.print("mFragmentManager=");
            printWriter.println(this.mFragmentManager);
        }
        if (this.mHost != null) {
            printWriter.print(str);
            printWriter.print("mHost=");
            printWriter.println(this.mHost);
        }
        if (this.mParentFragment != null) {
            printWriter.print(str);
            printWriter.print("mParentFragment=");
            printWriter.println(this.mParentFragment);
        }
        if (this.mArguments != null) {
            printWriter.print(str);
            printWriter.print("mArguments=");
            printWriter.println(this.mArguments);
        }
        if (this.mSavedFragmentState != null) {
            printWriter.print(str);
            printWriter.print("mSavedFragmentState=");
            printWriter.println(this.mSavedFragmentState);
        }
        if (this.mSavedViewState != null) {
            printWriter.print(str);
            printWriter.print("mSavedViewState=");
            printWriter.println(this.mSavedViewState);
        }
        if (this.mSavedViewRegistryState != null) {
            printWriter.print(str);
            printWriter.print("mSavedViewRegistryState=");
            printWriter.println(this.mSavedViewRegistryState);
        }
        l lVarC = c(false);
        if (lVarC != null) {
            printWriter.print(str);
            printWriter.print("mTarget=");
            printWriter.print(lVarC);
            printWriter.print(" mTargetRequestCode=");
            printWriter.println(this.mTargetRequestCode);
        }
        printWriter.print(str);
        printWriter.print("mPopDirection=");
        printWriter.println(getPopDirection());
        if (getEnterAnim() != 0) {
            printWriter.print(str);
            printWriter.print("getEnterAnim=");
            printWriter.println(getEnterAnim());
        }
        if (getExitAnim() != 0) {
            printWriter.print(str);
            printWriter.print("getExitAnim=");
            printWriter.println(getExitAnim());
        }
        if (getPopEnterAnim() != 0) {
            printWriter.print(str);
            printWriter.print("getPopEnterAnim=");
            printWriter.println(getPopEnterAnim());
        }
        if (getPopExitAnim() != 0) {
            printWriter.print(str);
            printWriter.print("getPopExitAnim=");
            printWriter.println(getPopExitAnim());
        }
        if (this.mContainer != null) {
            printWriter.print(str);
            printWriter.print("mContainer=");
            printWriter.println(this.mContainer);
        }
        if (this.mView != null) {
            printWriter.print(str);
            printWriter.print("mView=");
            printWriter.println(this.mView);
        }
        if (getAnimatingAway() != null) {
            printWriter.print(str);
            printWriter.print("mAnimatingAway=");
            printWriter.println(getAnimatingAway());
        }
        if (getContext() != null) {
            AbstractC1282gM.a(this).b(str, printWriter);
        }
        printWriter.print(str);
        printWriter.println("Child " + this.mChildFragmentManager + ":");
        this.mChildFragmentManager.u(AbstractC2462sn.i(str, "  "), fileDescriptor, printWriter, strArr);
    }

    public final NB e(AbstractC2772w1 abstractC2772w1, XC xc, InterfaceC2677v1 interfaceC2677v1) {
        if (this.mState > 1) {
            throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " is attempting to registerForActivityResult after being created. Fragments must call registerForActivityResult() before they are created (i.e. initialization, onAttach(), or onCreate())."));
        }
        AtomicReference atomicReference = new AtomicReference();
        PB pb = new PB(this, xc, atomicReference, abstractC2772w1, interfaceC2677v1);
        if (this.mState >= 0) {
            pb.a();
        } else {
            this.mOnPreAttachedListeners.add(pb);
        }
        return new NB(atomicReference);
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public l findFragmentByWho(String str) {
        return str.equals(this.mWho) ? this : this.mChildFragmentManager.c.c(str);
    }

    public String generateActivityResultKey() {
        return "fragment_" + this.mWho + "_rq#" + this.mNextLocalRequestCode.getAndIncrement();
    }

    public final FragmentActivity getActivity() {
        WB wb = this.mHost;
        if (wb == null) {
            return null;
        }
        return wb.l;
    }

    public boolean getAllowEnterTransitionOverlap() {
        Boolean bool;
        QB qb = this.mAnimationInfo;
        if (qb == null || (bool = qb.p) == null) {
            return true;
        }
        return bool.booleanValue();
    }

    public boolean getAllowReturnTransitionOverlap() {
        Boolean bool;
        QB qb = this.mAnimationInfo;
        if (qb == null || (bool = qb.f295o) == null) {
            return true;
        }
        return bool.booleanValue();
    }

    public View getAnimatingAway() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        qb.getClass();
        return null;
    }

    public final Bundle getArguments() {
        return this.mArguments;
    }

    public final s getChildFragmentManager() {
        if (this.mHost != null) {
            return this.mChildFragmentManager;
        }
        throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " has not been attached yet."));
    }

    public Context getContext() {
        WB wb = this.mHost;
        if (wb == null) {
            return null;
        }
        return wb.m;
    }

    @Override // o.IE
    public AbstractC0118Eo getDefaultViewModelCreationExtras() {
        Application application;
        Context applicationContext = requireContext().getApplicationContext();
        while (true) {
            if (!(applicationContext instanceof ContextWrapper)) {
                application = null;
                break;
            }
            if (applicationContext instanceof Application) {
                application = (Application) applicationContext;
                break;
            }
            applicationContext = ((ContextWrapper) applicationContext).getBaseContext();
        }
        if (application == null && s.F(3)) {
            Objects.toString(requireContext().getApplicationContext());
        }
        FQ fq = new FQ(0);
        if (application != null) {
            fq.a(C1125ek0.d, application);
        }
        fq.a(AbstractC2378rs0.f, this);
        fq.a(AbstractC2378rs0.g, this);
        if (getArguments() != null) {
            fq.a(AbstractC2378rs0.h, getArguments());
        }
        return fq;
    }

    public InterfaceC1221fk0 getDefaultViewModelProviderFactory() {
        Application application;
        if (this.mFragmentManager == null) {
            throw new IllegalStateException("Can't access ViewModels from detached fragment");
        }
        if (this.mDefaultFactory == null) {
            Context applicationContext = requireContext().getApplicationContext();
            while (true) {
                if (!(applicationContext instanceof ContextWrapper)) {
                    application = null;
                    break;
                }
                if (applicationContext instanceof Application) {
                    application = (Application) applicationContext;
                    break;
                }
                applicationContext = ((ContextWrapper) applicationContext).getBaseContext();
            }
            if (application == null && s.F(3)) {
                Objects.toString(requireContext().getApplicationContext());
            }
            this.mDefaultFactory = new C2020o40(application, this, getArguments());
        }
        return this.mDefaultFactory;
    }

    public int getEnterAnim() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return 0;
        }
        return qb.b;
    }

    public Object getEnterTransition() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        return qb.i;
    }

    public AbstractC1075e80 getEnterTransitionCallback() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        qb.getClass();
        return null;
    }

    public int getExitAnim() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return 0;
        }
        return qb.c;
    }

    public Object getExitTransition() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        return qb.k;
    }

    public AbstractC1075e80 getExitTransitionCallback() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        qb.getClass();
        return null;
    }

    public View getFocusedView() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        return qb.r;
    }

    @Deprecated
    public final s getFragmentManager() {
        return this.mFragmentManager;
    }

    public final Object getHost() {
        WB wb = this.mHost;
        if (wb == null) {
            return null;
        }
        return ((p) wb).p;
    }

    public final int getId() {
        return this.mFragmentId;
    }

    public final LayoutInflater getLayoutInflater() {
        LayoutInflater layoutInflater = this.mLayoutInflater;
        return layoutInflater == null ? performGetLayoutInflater(null) : layoutInflater;
    }

    @Override // o.InterfaceC0898cL
    public WK getLifecycle() {
        return this.mLifecycleRegistry;
    }

    @Deprecated
    public AbstractC1282gM getLoaderManager() {
        return AbstractC1282gM.a(this);
    }

    public int getNextTransition() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return 0;
        }
        return qb.f;
    }

    public final l getParentFragment() {
        return this.mParentFragment;
    }

    public final s getParentFragmentManager() {
        s sVar = this.mFragmentManager;
        if (sVar != null) {
            return sVar;
        }
        throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " not associated with a fragment manager."));
    }

    public boolean getPopDirection() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return false;
        }
        return qb.a;
    }

    public int getPopEnterAnim() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return 0;
        }
        return qb.d;
    }

    public int getPopExitAnim() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return 0;
        }
        return qb.e;
    }

    public float getPostOnViewCreatedAlpha() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return 1.0f;
        }
        return qb.q;
    }

    public Object getReenterTransition() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        Object obj = qb.l;
        return obj == USE_DEFAULT_TRANSITION ? getExitTransition() : obj;
    }

    public final Resources getResources() {
        return requireContext().getResources();
    }

    @Deprecated
    public final boolean getRetainInstance() {
        C1748lC c1748lC = AbstractC1843mC.a;
        AbstractC1843mC.b(new MD(this, "Attempting to get retain instance for fragment " + this));
        AbstractC1843mC.a(this).getClass();
        return this.mRetainInstance;
    }

    public Object getReturnTransition() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        Object obj = qb.j;
        return obj == USE_DEFAULT_TRANSITION ? getEnterTransition() : obj;
    }

    @Override // o.InterfaceC1925n40
    public final C1640k40 getSavedStateRegistry() {
        return this.mSavedStateRegistryController.b;
    }

    public Object getSharedElementEnterTransition() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        return qb.m;
    }

    public Object getSharedElementReturnTransition() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return null;
        }
        Object obj = qb.n;
        return obj == USE_DEFAULT_TRANSITION ? getSharedElementEnterTransition() : obj;
    }

    public ArrayList<String> getSharedElementSourceNames() {
        ArrayList<String> arrayList;
        QB qb = this.mAnimationInfo;
        return (qb == null || (arrayList = qb.g) == null) ? new ArrayList<>() : arrayList;
    }

    public ArrayList<String> getSharedElementTargetNames() {
        ArrayList<String> arrayList;
        QB qb = this.mAnimationInfo;
        return (qb == null || (arrayList = qb.h) == null) ? new ArrayList<>() : arrayList;
    }

    public final String getString(int i) {
        return getResources().getString(i);
    }

    public final String getTag() {
        return this.mTag;
    }

    @Deprecated
    public final l getTargetFragment() {
        return c(true);
    }

    @Deprecated
    public final int getTargetRequestCode() {
        C1748lC c1748lC = AbstractC1843mC.a;
        AbstractC1843mC.b(new ND(this, "Attempting to get target request code from fragment " + this));
        AbstractC1843mC.a(this).getClass();
        return this.mTargetRequestCode;
    }

    public final CharSequence getText(int i) {
        return getResources().getText(i);
    }

    @Deprecated
    public boolean getUserVisibleHint() {
        return this.mUserVisibleHint;
    }

    public View getView() {
        return this.mView;
    }

    public InterfaceC0898cL getViewLifecycleOwner() {
        CC cc = this.mViewLifecycleOwner;
        if (cc != null) {
            return cc;
        }
        throw new IllegalStateException("Can't access the Fragment View's LifecycleOwner when getView() is null i.e., before onCreateView() or after onDestroyView()");
    }

    public AbstractC1186fM getViewLifecycleOwnerLiveData() {
        return this.mViewLifecycleOwnerLiveData;
    }

    @Override // o.InterfaceC1508ik0
    public C1413hk0 getViewModelStore() {
        if (this.mFragmentManager == null) {
            throw new IllegalStateException("Can't access ViewModels from detached fragment");
        }
        if (b() == 1) {
            throw new IllegalStateException("Calling getViewModelStore() before a Fragment reaches onCreate() when using setMaxLifecycle(INITIALIZED) is not supported");
        }
        HashMap map = this.mFragmentManager.L.d;
        C1413hk0 c1413hk0 = (C1413hk0) map.get(this.mWho);
        if (c1413hk0 != null) {
            return c1413hk0;
        }
        C1413hk0 c1413hk02 = new C1413hk0();
        map.put(this.mWho, c1413hk02);
        return c1413hk02;
    }

    public final boolean hasOptionsMenu() {
        return this.mHasMenu;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void initState() {
        d();
        this.mPreviousWho = this.mWho;
        this.mWho = UUID.randomUUID().toString();
        this.mAdded = false;
        this.mRemoving = false;
        this.mFromLayout = false;
        this.mInLayout = false;
        this.mRestored = false;
        this.mBackStackNesting = 0;
        this.mFragmentManager = null;
        this.mChildFragmentManager = new C1272gC();
        this.mHost = null;
        this.mFragmentId = 0;
        this.mContainerId = 0;
        this.mTag = null;
        this.mHidden = false;
        this.mDetached = false;
    }

    public final boolean isAdded() {
        return this.mHost != null && this.mAdded;
    }

    public final boolean isDetached() {
        return this.mDetached;
    }

    public final boolean isHidden() {
        if (this.mHidden) {
            return true;
        }
        s sVar = this.mFragmentManager;
        if (sVar != null) {
            l lVar = this.mParentFragment;
            sVar.getClass();
            if (lVar == null ? false : lVar.isHidden()) {
                return true;
            }
        }
        return false;
    }

    public final boolean isInBackStack() {
        return this.mBackStackNesting > 0;
    }

    public final boolean isInLayout() {
        return this.mInLayout;
    }

    public final boolean isMenuVisible() {
        if (!this.mMenuVisible) {
            return false;
        }
        if (this.mFragmentManager != null) {
            l lVar = this.mParentFragment;
            if (!(lVar == null ? true : lVar.isMenuVisible())) {
                return false;
            }
        }
        return true;
    }

    public boolean isPostponed() {
        QB qb = this.mAnimationInfo;
        if (qb == null) {
            return false;
        }
        return qb.s;
    }

    public final boolean isRemoving() {
        return this.mRemoving;
    }

    public final boolean isResumed() {
        return this.mState >= 7;
    }

    public final boolean isStateSaved() {
        s sVar = this.mFragmentManager;
        if (sVar == null) {
            return false;
        }
        return sVar.E || sVar.F;
    }

    public final boolean isVisible() {
        View view;
        return (!isAdded() || isHidden() || (view = this.mView) == null || view.getWindowToken() == null || this.mView.getVisibility() != 0) ? false : true;
    }

    public void noteStateNotSaved() {
        this.mChildFragmentManager.K();
    }

    @Deprecated
    public void onActivityCreated(Bundle bundle) {
        this.mCalled = true;
    }

    @Deprecated
    public void onActivityResult(int i, int i2, Intent intent) {
        if (s.F(2)) {
            toString();
            Objects.toString(intent);
        }
    }

    public void onAttach(Context context) {
        this.mCalled = true;
        WB wb = this.mHost;
        FragmentActivity fragmentActivity = wb == null ? null : wb.l;
        if (fragmentActivity != null) {
            this.mCalled = false;
            onAttach((Activity) fragmentActivity);
        }
    }

    @Override // android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration configuration) {
        this.mCalled = true;
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        return false;
    }

    public void onCreate(Bundle bundle) {
        this.mCalled = true;
        restoreChildFragmentState(bundle);
        s sVar = this.mChildFragmentManager;
        if (sVar.s >= 1) {
            return;
        }
        sVar.E = false;
        sVar.F = false;
        sVar.L.g = false;
        sVar.t(1);
    }

    public Animation onCreateAnimation(int i, boolean z, int i2) {
        return null;
    }

    public Animator onCreateAnimator(int i, boolean z, int i2) {
        return null;
    }

    @Override // android.view.View.OnCreateContextMenuListener
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        requireActivity().onCreateContextMenu(contextMenu, view, contextMenuInfo);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        int i = this.mContentLayoutId;
        if (i != 0) {
            return layoutInflater.inflate(i, viewGroup, false);
        }
        return null;
    }

    public void onDestroy() {
        this.mCalled = true;
    }

    public void onDestroyView() {
        this.mCalled = true;
    }

    public void onDetach() {
        this.mCalled = true;
    }

    public LayoutInflater onGetLayoutInflater(Bundle bundle) {
        return getLayoutInflater(bundle);
    }

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        this.mCalled = true;
        WB wb = this.mHost;
        FragmentActivity fragmentActivity = wb == null ? null : wb.l;
        if (fragmentActivity != null) {
            this.mCalled = false;
            onInflate((Activity) fragmentActivity, attributeSet, bundle);
        }
    }

    @Override // android.content.ComponentCallbacks
    public void onLowMemory() {
        this.mCalled = true;
    }

    @Deprecated
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return false;
    }

    public void onPause() {
        this.mCalled = true;
    }

    public void onResume() {
        this.mCalled = true;
    }

    public abstract void onSaveInstanceState(Bundle bundle);

    public void onStart() {
        this.mCalled = true;
    }

    public void onStop() {
        this.mCalled = true;
    }

    public void onViewStateRestored(Bundle bundle) {
        this.mCalled = true;
    }

    public void performActivityCreated(Bundle bundle) {
        this.mChildFragmentManager.K();
        this.mState = 3;
        this.mCalled = false;
        onActivityCreated(bundle);
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onActivityCreated()"));
        }
        if (s.F(3)) {
            toString();
        }
        if (this.mView != null) {
            restoreViewState(this.mSavedFragmentState);
        }
        this.mSavedFragmentState = null;
        s sVar = this.mChildFragmentManager;
        sVar.E = false;
        sVar.F = false;
        sVar.L.g = false;
        sVar.t(4);
    }

    public void performAttach() {
        ArrayList<RB> arrayList = this.mOnPreAttachedListeners;
        int size = arrayList.size();
        int i = 0;
        while (i < size) {
            RB rb = arrayList.get(i);
            i++;
            rb.a();
        }
        this.mOnPreAttachedListeners.clear();
        this.mChildFragmentManager.b(this.mHost, createFragmentContainer(), this);
        this.mState = 0;
        this.mCalled = false;
        onAttach((Context) this.mHost.m);
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onAttach()"));
        }
        Iterator it = this.mFragmentManager.m.iterator();
        while (it.hasNext()) {
            ((InterfaceC1558jC) it.next()).a(this);
        }
        s sVar = this.mChildFragmentManager;
        sVar.E = false;
        sVar.F = false;
        sVar.L.g = false;
        sVar.t(0);
    }

    public void performConfigurationChanged(Configuration configuration) {
        onConfigurationChanged(configuration);
    }

    public boolean performContextItemSelected(MenuItem menuItem) {
        if (this.mHidden) {
            return false;
        }
        if (onContextItemSelected(menuItem)) {
            return true;
        }
        return this.mChildFragmentManager.i(menuItem);
    }

    public void performCreate(Bundle bundle) {
        this.mChildFragmentManager.K();
        this.mState = 1;
        this.mCalled = false;
        this.mLifecycleRegistry.a(new j(this));
        this.mSavedStateRegistryController.a(bundle);
        onCreate(bundle);
        this.mIsCreated = true;
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onCreate()"));
        }
        this.mLifecycleRegistry.f(UK.ON_CREATE);
    }

    public boolean performCreateOptionsMenu(Menu menu, MenuInflater menuInflater) {
        boolean z = false;
        if (this.mHidden) {
            return false;
        }
        if (this.mHasMenu && this.mMenuVisible) {
            onCreateOptionsMenu(menu, menuInflater);
            z = true;
        }
        return this.mChildFragmentManager.j(menu, menuInflater) | z;
    }

    public void performCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.mChildFragmentManager.K();
        this.mPerformedCreateView = true;
        this.mViewLifecycleOwner = new CC(this, getViewModelStore());
        View viewOnCreateView = onCreateView(layoutInflater, viewGroup, bundle);
        this.mView = viewOnCreateView;
        if (viewOnCreateView == null) {
            if (this.mViewLifecycleOwner.n != null) {
                throw new IllegalStateException("Called getViewLifecycleOwner() but onCreateView() returned null");
            }
            this.mViewLifecycleOwner = null;
        } else {
            this.mViewLifecycleOwner.b();
            AbstractC2461sm0.D(this.mView, this.mViewLifecycleOwner);
            AbstractC0940cn0.G(this.mView, this.mViewLifecycleOwner);
            AbstractC2841wm0.C(this.mView, this.mViewLifecycleOwner);
            this.mViewLifecycleOwnerLiveData.d(this.mViewLifecycleOwner);
        }
    }

    public void performDestroy() {
        this.mChildFragmentManager.k();
        this.mLifecycleRegistry.f(UK.ON_DESTROY);
        this.mState = 0;
        this.mCalled = false;
        this.mIsCreated = false;
        onDestroy();
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onDestroy()"));
        }
    }

    public void performDestroyView() {
        this.mChildFragmentManager.t(1);
        if (this.mView != null) {
            CC cc = this.mViewLifecycleOwner;
            cc.b();
            if (cc.n.d.a(VK.n)) {
                this.mViewLifecycleOwner.a(UK.ON_DESTROY);
            }
        }
        this.mState = 1;
        this.mCalled = false;
        onDestroyView();
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onDestroyView()"));
        }
        C0914ca0 c0914ca0 = AbstractC1282gM.a(this).b.b;
        if (c0914ca0.n <= 0) {
            this.mPerformedCreateView = false;
        } else {
            c0914ca0.e(0).getClass();
            throw new ClassCastException();
        }
    }

    public void performDetach() {
        this.mState = -1;
        this.mCalled = false;
        onDetach();
        this.mLayoutInflater = null;
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onDetach()"));
        }
        s sVar = this.mChildFragmentManager;
        if (sVar.G) {
            return;
        }
        sVar.k();
        this.mChildFragmentManager = new C1272gC();
    }

    public LayoutInflater performGetLayoutInflater(Bundle bundle) {
        LayoutInflater layoutInflaterOnGetLayoutInflater = onGetLayoutInflater(bundle);
        this.mLayoutInflater = layoutInflaterOnGetLayoutInflater;
        return layoutInflaterOnGetLayoutInflater;
    }

    public void performLowMemory() {
        onLowMemory();
    }

    public void performMultiWindowModeChanged(boolean z) {
        onMultiWindowModeChanged(z);
    }

    public boolean performOptionsItemSelected(MenuItem menuItem) {
        if (this.mHidden) {
            return false;
        }
        if (this.mHasMenu && this.mMenuVisible && onOptionsItemSelected(menuItem)) {
            return true;
        }
        return this.mChildFragmentManager.o(menuItem);
    }

    public void performOptionsMenuClosed(Menu menu) {
        if (this.mHidden) {
            return;
        }
        if (this.mHasMenu && this.mMenuVisible) {
            onOptionsMenuClosed(menu);
        }
        this.mChildFragmentManager.p(menu);
    }

    public void performPause() {
        this.mChildFragmentManager.t(5);
        if (this.mView != null) {
            this.mViewLifecycleOwner.a(UK.ON_PAUSE);
        }
        this.mLifecycleRegistry.f(UK.ON_PAUSE);
        this.mState = 6;
        this.mCalled = false;
        onPause();
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onPause()"));
        }
    }

    public void performPictureInPictureModeChanged(boolean z) {
        onPictureInPictureModeChanged(z);
    }

    public boolean performPrepareOptionsMenu(Menu menu) {
        boolean z = false;
        if (this.mHidden) {
            return false;
        }
        if (this.mHasMenu && this.mMenuVisible) {
            onPrepareOptionsMenu(menu);
            z = true;
        }
        return this.mChildFragmentManager.s(menu) | z;
    }

    public void performPrimaryNavigationFragmentChanged() {
        this.mFragmentManager.getClass();
        boolean zI = s.I(this);
        Boolean bool = this.mIsPrimaryNavigationFragment;
        if (bool == null || bool.booleanValue() != zI) {
            this.mIsPrimaryNavigationFragment = Boolean.valueOf(zI);
            onPrimaryNavigationFragmentChanged(zI);
            s sVar = this.mChildFragmentManager;
            sVar.Y();
            sVar.q(sVar.w);
        }
    }

    public void performResume() {
        this.mChildFragmentManager.K();
        this.mChildFragmentManager.x(true);
        this.mState = 7;
        this.mCalled = false;
        onResume();
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onResume()"));
        }
        C1089eL c1089eL = this.mLifecycleRegistry;
        UK uk = UK.ON_RESUME;
        c1089eL.f(uk);
        if (this.mView != null) {
            this.mViewLifecycleOwner.a(uk);
        }
        s sVar = this.mChildFragmentManager;
        sVar.E = false;
        sVar.F = false;
        sVar.L.g = false;
        sVar.t(7);
    }

    public void performSaveInstanceState(Bundle bundle) {
        onSaveInstanceState(bundle);
        this.mSavedStateRegistryController.b(bundle);
        bundle.putParcelable("android:support:fragments", this.mChildFragmentManager.R());
    }

    public void performStart() {
        this.mChildFragmentManager.K();
        this.mChildFragmentManager.x(true);
        this.mState = 5;
        this.mCalled = false;
        onStart();
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onStart()"));
        }
        C1089eL c1089eL = this.mLifecycleRegistry;
        UK uk = UK.ON_START;
        c1089eL.f(uk);
        if (this.mView != null) {
            this.mViewLifecycleOwner.a(uk);
        }
        s sVar = this.mChildFragmentManager;
        sVar.E = false;
        sVar.F = false;
        sVar.L.g = false;
        sVar.t(5);
    }

    public void performStop() {
        s sVar = this.mChildFragmentManager;
        sVar.F = true;
        sVar.L.g = true;
        sVar.t(4);
        if (this.mView != null) {
            this.mViewLifecycleOwner.a(UK.ON_STOP);
        }
        this.mLifecycleRegistry.f(UK.ON_STOP);
        this.mState = 4;
        this.mCalled = false;
        onStop();
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onStop()"));
        }
    }

    public void performViewCreated() {
        onViewCreated(this.mView, this.mSavedFragmentState);
        this.mChildFragmentManager.t(2);
    }

    public void postponeEnterTransition() {
        a().s = true;
    }

    public final <I, O> AbstractC2962y1 registerForActivityResult(AbstractC2772w1 abstractC2772w1, InterfaceC2677v1 interfaceC2677v1) {
        return e(abstractC2772w1, new k(this), interfaceC2677v1);
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    @Deprecated
    public final void requestPermissions(String[] strArr, int i) {
        if (this.mHost == null) {
            throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " not attached to Activity"));
        }
        s parentFragmentManager = getParentFragmentManager();
        if (parentFragmentManager.B == null) {
            parentFragmentManager.t.getClass();
            return;
        }
        parentFragmentManager.C.addLast(new C0985dC(this.mWho, i));
        parentFragmentManager.B.a(strArr);
    }

    public final FragmentActivity requireActivity() {
        FragmentActivity activity = getActivity();
        if (activity != null) {
            return activity;
        }
        throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " not attached to an activity."));
    }

    public final Bundle requireArguments() {
        Bundle arguments = getArguments();
        if (arguments != null) {
            return arguments;
        }
        throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " does not have any arguments."));
    }

    public final Context requireContext() {
        Context context = getContext();
        if (context != null) {
            return context;
        }
        throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " not attached to a context."));
    }

    @Deprecated
    public final s requireFragmentManager() {
        return getParentFragmentManager();
    }

    public final Object requireHost() {
        Object host = getHost();
        if (host != null) {
            return host;
        }
        throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " not attached to a host."));
    }

    public final l requireParentFragment() {
        l parentFragment = getParentFragment();
        if (parentFragment != null) {
            return parentFragment;
        }
        if (getContext() == null) {
            throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " is not attached to any Fragment or host"));
        }
        throw new IllegalStateException("Fragment " + this + " is not a child Fragment, it is directly attached to " + getContext());
    }

    public final View requireView() {
        View view = getView();
        if (view != null) {
            return view;
        }
        throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " did not return a View from onCreateView() or this was called before onCreateView()."));
    }

    public void restoreChildFragmentState(Bundle bundle) {
        Parcelable parcelable;
        if (bundle == null || (parcelable = bundle.getParcelable("android:support:fragments")) == null) {
            return;
        }
        this.mChildFragmentManager.Q(parcelable);
        s sVar = this.mChildFragmentManager;
        sVar.E = false;
        sVar.F = false;
        sVar.L.g = false;
        sVar.t(1);
    }

    public final void restoreViewState(Bundle bundle) {
        SparseArray<Parcelable> sparseArray = this.mSavedViewState;
        if (sparseArray != null) {
            this.mView.restoreHierarchyState(sparseArray);
            this.mSavedViewState = null;
        }
        if (this.mView != null) {
            CC cc = this.mViewLifecycleOwner;
            cc.f66o.a(this.mSavedViewRegistryState);
            this.mSavedViewRegistryState = null;
        }
        this.mCalled = false;
        onViewStateRestored(bundle);
        if (!this.mCalled) {
            throw new C2629ub0(AbstractC0126Ew.m("Fragment ", this, " did not call through to super.onViewStateRestored()"));
        }
        if (this.mView != null) {
            this.mViewLifecycleOwner.a(UK.ON_CREATE);
        }
    }

    public void setAllowEnterTransitionOverlap(boolean z) {
        a().p = Boolean.valueOf(z);
    }

    public void setAllowReturnTransitionOverlap(boolean z) {
        a().f295o = Boolean.valueOf(z);
    }

    public void setAnimations(int i, int i2, int i3, int i4) {
        if (this.mAnimationInfo == null && i == 0 && i2 == 0 && i3 == 0 && i4 == 0) {
            return;
        }
        a().b = i;
        a().c = i2;
        a().d = i3;
        a().e = i4;
    }

    public void setArguments(Bundle bundle) {
        if (this.mFragmentManager != null && isStateSaved()) {
            throw new IllegalStateException("Fragment already added and state has been saved");
        }
        this.mArguments = bundle;
    }

    public void setEnterSharedElementCallback(AbstractC1075e80 abstractC1075e80) {
        a().getClass();
    }

    public void setEnterTransition(Object obj) {
        a().i = obj;
    }

    public void setExitSharedElementCallback(AbstractC1075e80 abstractC1075e80) {
        a().getClass();
    }

    public void setExitTransition(Object obj) {
        a().k = obj;
    }

    public void setFocusedView(View view) {
        a().r = view;
    }

    @Deprecated
    public void setHasOptionsMenu(boolean z) {
        if (this.mHasMenu != z) {
            this.mHasMenu = z;
            if (!isAdded() || isHidden()) {
                return;
            }
            ((p) this.mHost).p.invalidateOptionsMenu();
        }
    }

    public void setInitialSavedState(SB sb) {
        Bundle bundle;
        if (this.mFragmentManager != null) {
            throw new IllegalStateException("Fragment already added");
        }
        if (sb == null || (bundle = sb.l) == null) {
            bundle = null;
        }
        this.mSavedFragmentState = bundle;
    }

    public void setMenuVisibility(boolean z) {
        if (this.mMenuVisible != z) {
            this.mMenuVisible = z;
            if (this.mHasMenu && isAdded() && !isHidden()) {
                ((p) this.mHost).p.invalidateOptionsMenu();
            }
        }
    }

    public void setNextTransition(int i) {
        if (this.mAnimationInfo == null && i == 0) {
            return;
        }
        a();
        this.mAnimationInfo.f = i;
    }

    public void setPopDirection(boolean z) {
        if (this.mAnimationInfo == null) {
            return;
        }
        a().a = z;
    }

    public void setPostOnViewCreatedAlpha(float f) {
        a().q = f;
    }

    public void setReenterTransition(Object obj) {
        a().l = obj;
    }

    @Deprecated
    public void setRetainInstance(boolean z) {
        C1748lC c1748lC = AbstractC1843mC.a;
        AbstractC1843mC.b(new MD(this, "Attempting to set retain instance for fragment " + this));
        AbstractC1843mC.a(this).getClass();
        this.mRetainInstance = z;
        s sVar = this.mFragmentManager;
        if (sVar == null) {
            this.mRetainInstanceChangedWhileDetached = true;
        } else if (z) {
            sVar.L.c(this);
        } else {
            sVar.L.e(this);
        }
    }

    public void setReturnTransition(Object obj) {
        a().j = obj;
    }

    public void setSharedElementEnterTransition(Object obj) {
        a().m = obj;
    }

    public void setSharedElementNames(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        a();
        QB qb = this.mAnimationInfo;
        qb.g = arrayList;
        qb.h = arrayList2;
    }

    public void setSharedElementReturnTransition(Object obj) {
        a().n = obj;
    }

    @Deprecated
    public void setTargetFragment(l lVar, int i) {
        if (lVar != null) {
            C1748lC c1748lC = AbstractC1843mC.a;
            AbstractC1843mC.b(new ND(this, "Attempting to set target fragment " + lVar + " with request code " + i + " for fragment " + this));
            AbstractC1843mC.a(this).getClass();
        }
        s sVar = this.mFragmentManager;
        s sVar2 = lVar != null ? lVar.mFragmentManager : null;
        if (sVar != null && sVar2 != null && sVar != sVar2) {
            throw new IllegalArgumentException(AbstractC0126Ew.m("Fragment ", lVar, " must share the same FragmentManager to be set as a target fragment"));
        }
        for (l lVarC = lVar; lVarC != null; lVarC = lVarC.c(false)) {
            if (lVarC.equals(this)) {
                throw new IllegalArgumentException("Setting " + lVar + " as the target of " + this + " would create a target cycle");
            }
        }
        if (lVar == null) {
            this.mTargetWho = null;
            this.mTarget = null;
        } else if (this.mFragmentManager == null || lVar.mFragmentManager == null) {
            this.mTargetWho = null;
            this.mTarget = lVar;
        } else {
            this.mTargetWho = lVar.mWho;
            this.mTarget = null;
        }
        this.mTargetRequestCode = i;
    }

    @Deprecated
    public void setUserVisibleHint(boolean z) {
        C1748lC c1748lC = AbstractC1843mC.a;
        AbstractC1843mC.b(new C1653kC(this, "Attempting to set user visible hint to " + z + " for fragment " + this));
        AbstractC1843mC.a(this).getClass();
        boolean z2 = false;
        if (!this.mUserVisibleHint && z && this.mState < 5 && this.mFragmentManager != null && isAdded() && this.mIsCreated) {
            s sVar = this.mFragmentManager;
            v vVarF = sVar.f(this);
            l lVar = vVarF.c;
            if (lVar.mDeferStart) {
                if (sVar.b) {
                    sVar.H = true;
                } else {
                    lVar.mDeferStart = false;
                    vVarF.i();
                }
            }
        }
        this.mUserVisibleHint = z;
        if (this.mState < 5 && !z) {
            z2 = true;
        }
        this.mDeferStart = z2;
        if (this.mSavedFragmentState != null) {
            this.mSavedUserVisibleHint = Boolean.valueOf(z);
        }
    }

    public boolean shouldShowRequestPermissionRationale(String str) {
        WB wb = this.mHost;
        if (wb == null) {
            return false;
        }
        FragmentActivity fragmentActivity = ((p) wb).p;
        int i = Build.VERSION.SDK_INT;
        if (i < 33 && TextUtils.equals("android.permission.POST_NOTIFICATIONS", str)) {
            return false;
        }
        if (i >= 32) {
            return fragmentActivity.shouldShowRequestPermissionRationale(str);
        }
        if (i != 31) {
            return fragmentActivity.shouldShowRequestPermissionRationale(str);
        }
        try {
            return ((Boolean) PackageManager.class.getMethod("shouldShowRequestPermissionRationale", String.class).invoke(fragmentActivity.getApplication().getPackageManager(), str)).booleanValue();
        } catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException unused) {
            return fragmentActivity.shouldShowRequestPermissionRationale(str);
        }
    }

    public void startActivity(Intent intent) {
        startActivity(intent, null);
    }

    @Deprecated
    public void startActivityForResult(Intent intent, int i) {
        startActivityForResult(intent, i, null);
    }

    @Deprecated
    public void startIntentSenderForResult(IntentSender intentSender, int i, Intent intent, int i2, int i3, int i4, Bundle bundle) {
        Intent intent2;
        if (this.mHost == null) {
            throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " not attached to Activity"));
        }
        if (s.F(2)) {
            toString();
            Objects.toString(intentSender);
            Objects.toString(intent);
            Objects.toString(bundle);
        }
        s parentFragmentManager = getParentFragmentManager();
        if (parentFragmentManager.A == null) {
            WB wb = parentFragmentManager.t;
            if (i == -1) {
                wb.l.startIntentSenderForResult(intentSender, i, intent, i2, i3, i4, bundle);
                return;
            } else {
                wb.getClass();
                throw new IllegalStateException("Starting intent sender with a requestCode requires a FragmentActivity host");
            }
        }
        if (bundle != null) {
            if (intent == null) {
                intent2 = new Intent();
                intent2.putExtra("androidx.fragment.extra.ACTIVITY_OPTIONS_BUNDLE", true);
            } else {
                intent2 = intent;
            }
            if (s.F(2)) {
                bundle.toString();
                intent2.toString();
                Objects.toString(this);
            }
            intent2.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", bundle);
        } else {
            intent2 = intent;
        }
        C1659kI c1659kI = new C1659kI(intentSender, intent2, i2, i3);
        parentFragmentManager.C.addLast(new C0985dC(this.mWho, i));
        if (s.F(2)) {
            toString();
        }
        parentFragmentManager.A.a(c1659kI);
    }

    public void startPostponedEnterTransition() {
        if (this.mAnimationInfo == null || !a().s) {
            return;
        }
        if (this.mHost == null) {
            a().s = false;
        } else if (Looper.myLooper() != this.mHost.n.getLooper()) {
            this.mHost.n.postAtFrontOfQueue(new OB(this, 1));
        } else {
            callStartTransitionListener(true);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(getClass().getSimpleName());
        sb.append("{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("} (");
        sb.append(this.mWho);
        if (this.mFragmentId != 0) {
            sb.append(" id=0x");
            sb.append(Integer.toHexString(this.mFragmentId));
        }
        if (this.mTag != null) {
            sb.append(" tag=");
            sb.append(this.mTag);
        }
        sb.append(")");
        return sb.toString();
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    @Deprecated
    public static l instantiate(Context context, String str, Bundle bundle) {
        try {
            l lVar = (l) C0794bC.b(context.getClassLoader(), str).getConstructor(null).newInstance(null);
            if (bundle == null) {
                return lVar;
            }
            bundle.setClassLoader(lVar.getClass().getClassLoader());
            lVar.setArguments(bundle);
            return lVar;
        } catch (IllegalAccessException e) {
            throw new C2170pj(AbstractC2462sn.j("Unable to instantiate fragment ", str, ": make sure class name exists, is public, and has an empty constructor that is public"), e);
        } catch (InstantiationException e2) {
            throw new C2170pj(AbstractC2462sn.j("Unable to instantiate fragment ", str, ": make sure class name exists, is public, and has an empty constructor that is public"), e2);
        } catch (NoSuchMethodException e3) {
            throw new C2170pj(AbstractC2462sn.j("Unable to instantiate fragment ", str, ": could not find Fragment constructor"), e3);
        } catch (InvocationTargetException e4) {
            throw new C2170pj(AbstractC2462sn.j("Unable to instantiate fragment ", str, ": calling Fragment constructor caused an exception"), e4);
        }
    }

    public final String getString(int i, Object... objArr) {
        return getResources().getString(i, objArr);
    }

    public final void postponeEnterTransition(long j, TimeUnit timeUnit) {
        a().s = true;
        s sVar = this.mFragmentManager;
        Handler handler = sVar != null ? sVar.t.n : new Handler(Looper.getMainLooper());
        handler.removeCallbacks(this.mPostponedDurationRunnable);
        handler.postDelayed(this.mPostponedDurationRunnable, timeUnit.toMillis(j));
    }

    public final <I, O> AbstractC2962y1 registerForActivityResult(AbstractC2772w1 abstractC2772w1, E1 e1, InterfaceC2677v1 interfaceC2677v1) {
        return e(abstractC2772w1, new C0247Jn(17, e1), interfaceC2677v1);
    }

    public void startActivity(Intent intent, Bundle bundle) {
        WB wb = this.mHost;
        if (wb == null) {
            throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " not attached to Activity"));
        }
        wb.m.startActivity(intent, bundle);
    }

    @Deprecated
    public void startActivityForResult(Intent intent, int i, Bundle bundle) {
        if (this.mHost == null) {
            throw new IllegalStateException(AbstractC0126Ew.m("Fragment ", this, " not attached to Activity"));
        }
        s parentFragmentManager = getParentFragmentManager();
        if (parentFragmentManager.z == null) {
            WB wb = parentFragmentManager.t;
            if (i == -1) {
                wb.m.startActivity(intent, bundle);
                return;
            } else {
                wb.getClass();
                throw new IllegalStateException("Starting activity with a requestCode requires a FragmentActivity host");
            }
        }
        parentFragmentManager.C.addLast(new C0985dC(this.mWho, i));
        if (intent != null && bundle != null) {
            intent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", bundle);
        }
        parentFragmentManager.z.a(intent);
    }

    @Deprecated
    public LayoutInflater getLayoutInflater(Bundle bundle) {
        WB wb = this.mHost;
        if (wb != null) {
            FragmentActivity fragmentActivity = ((p) wb).p;
            LayoutInflater layoutInflaterCloneInContext = fragmentActivity.getLayoutInflater().cloneInContext(fragmentActivity);
            layoutInflaterCloneInContext.setFactory2(this.mChildFragmentManager.f);
            return layoutInflaterCloneInContext;
        }
        throw new IllegalStateException("onGetLayoutInflater() cannot be executed until the Fragment is attached to the FragmentManager.");
    }

    @Deprecated
    public void onAttach(Activity activity) {
        this.mCalled = true;
    }

    @Deprecated
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        this.mCalled = true;
    }

    @Deprecated
    public void onDestroyOptionsMenu() {
    }

    @Deprecated
    public void onAttachFragment(l lVar) {
    }

    public void onHiddenChanged(boolean z) {
    }

    public void onMultiWindowModeChanged(boolean z) {
    }

    @Deprecated
    public void onOptionsMenuClosed(Menu menu) {
    }

    public void onPictureInPictureModeChanged(boolean z) {
    }

    @Deprecated
    public void onPrepareOptionsMenu(Menu menu) {
    }

    public void onPrimaryNavigationFragmentChanged(boolean z) {
    }

    @Deprecated
    public void onCreateOptionsMenu(Menu menu, MenuInflater menuInflater) {
    }

    public void onViewCreated(View view, Bundle bundle) {
    }

    @Deprecated
    public void onRequestPermissionsResult(int i, String[] strArr, int[] iArr) {
    }
}
