package androidx.coordinatorlayout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import o.AbstractC0375Om;
import o.C0453Rm;
import o.C0505Tm;
import o.C1746lA;
import o.C2062oc0;
import o.Ej0;
import o.Gj0;
import o.I80;
import o.InterfaceC0401Pm;
import o.KZ;
import o.Kl0;
import o.OD;
import o.Oj0;
import o.RR;
import o.SR;
import o.SX;
import o.SZ;
import o.ViewGroupOnHierarchyChangeListenerC0427Qm;
import o.ViewTreeObserverOnPreDrawListenerC0479Sm;
import o.Wj0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class CoordinatorLayout extends ViewGroup implements RR, SR {
    public static final String E;
    public static final Class[] F;
    public static final ThreadLocal G;
    public static final C1746lA H;
    public static final SX I;
    public Drawable A;
    public ViewGroup.OnHierarchyChangeListener B;
    public OD C;
    public final KZ D;
    public final ArrayList l;
    public final C2062oc0 m;
    public final ArrayList n;

    /* renamed from: o, reason: collision with root package name */
    public final ArrayList f11o;
    public final int[] p;
    public final int[] q;
    public boolean r;
    public boolean s;
    public final int[] t;
    public View u;
    public View v;
    public ViewTreeObserverOnPreDrawListenerC0479Sm w;
    public boolean x;
    public Kl0 y;
    public boolean z;

    static {
        Package r0 = CoordinatorLayout.class.getPackage();
        E = r0 != null ? r0.getName() : null;
        H = new C1746lA(8);
        F = new Class[]{Context.class, AttributeSet.class};
        G = new ThreadLocal();
        I = new SX();
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet) throws Resources.NotFoundException {
        super(context, attributeSet, R.attr.coordinatorLayoutStyle);
        this.l = new ArrayList();
        this.m = new C2062oc0();
        this.n = new ArrayList();
        this.f11o = new ArrayList();
        this.p = new int[2];
        this.q = new int[2];
        this.D = new KZ(1);
        int[] iArr = SZ.a;
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, iArr, R.attr.coordinatorLayoutStyle, 0);
        if (Build.VERSION.SDK_INT >= 29) {
            saveAttributeDataForStyleable(context, iArr, attributeSet, typedArrayObtainStyledAttributes, R.attr.coordinatorLayoutStyle, 0);
        }
        int resourceId = typedArrayObtainStyledAttributes.getResourceId(0, 0);
        if (resourceId != 0) {
            Resources resources = context.getResources();
            int[] intArray = resources.getIntArray(resourceId);
            this.t = intArray;
            float f = resources.getDisplayMetrics().density;
            int length = intArray.length;
            for (int i = 0; i < length; i++) {
                this.t[i] = (int) (r1[i] * f);
            }
        }
        this.A = typedArrayObtainStyledAttributes.getDrawable(1);
        typedArrayObtainStyledAttributes.recycle();
        v();
        super.setOnHierarchyChangeListener(new ViewGroupOnHierarchyChangeListenerC0427Qm(this));
        WeakHashMap weakHashMap = Oj0.a;
        if (getImportantForAccessibility() == 0) {
            setImportantForAccessibility(1);
        }
    }

    public static Rect d() {
        Rect rect = (Rect) I.a();
        return rect == null ? new Rect() : rect;
    }

    public static void l(int i, Rect rect, Rect rect2, C0453Rm c0453Rm, int i2, int i3) {
        int i4 = c0453Rm.c;
        if (i4 == 0) {
            i4 = 17;
        }
        int absoluteGravity = Gravity.getAbsoluteGravity(i4, i);
        int i5 = c0453Rm.d;
        if ((i5 & 7) == 0) {
            i5 |= 8388611;
        }
        if ((i5 & 112) == 0) {
            i5 |= 48;
        }
        int absoluteGravity2 = Gravity.getAbsoluteGravity(i5, i);
        int i6 = absoluteGravity & 7;
        int i7 = absoluteGravity & 112;
        int i8 = absoluteGravity2 & 7;
        int i9 = absoluteGravity2 & 112;
        int iWidth = i8 != 1 ? i8 != 5 ? rect.left : rect.right : rect.left + (rect.width() / 2);
        int iHeight = i9 != 16 ? i9 != 80 ? rect.top : rect.bottom : rect.top + (rect.height() / 2);
        if (i6 == 1) {
            iWidth -= i2 / 2;
        } else if (i6 != 5) {
            iWidth -= i2;
        }
        if (i7 == 16) {
            iHeight -= i3 / 2;
        } else if (i7 != 80) {
            iHeight -= i3;
        }
        rect2.set(iWidth, iHeight, i2 + iWidth, i3 + iHeight);
    }

    public static C0453Rm m(View view) {
        C0453Rm c0453Rm = (C0453Rm) view.getLayoutParams();
        if (!c0453Rm.b) {
            InterfaceC0401Pm interfaceC0401Pm = null;
            for (Class<?> superclass = view.getClass(); superclass != null; superclass = superclass.getSuperclass()) {
                interfaceC0401Pm = (InterfaceC0401Pm) superclass.getAnnotation(InterfaceC0401Pm.class);
                if (interfaceC0401Pm != null) {
                    break;
                }
            }
            if (interfaceC0401Pm != null) {
                try {
                    AbstractC0375Om abstractC0375Om = (AbstractC0375Om) interfaceC0401Pm.value().getDeclaredConstructor(null).newInstance(null);
                    AbstractC0375Om abstractC0375Om2 = c0453Rm.a;
                    if (abstractC0375Om2 != abstractC0375Om) {
                        if (abstractC0375Om2 != null) {
                            abstractC0375Om2.e();
                        }
                        c0453Rm.a = abstractC0375Om;
                        c0453Rm.b = true;
                        if (abstractC0375Om != null) {
                            abstractC0375Om.c(c0453Rm);
                        }
                    }
                } catch (Exception unused) {
                    interfaceC0401Pm.value().getClass();
                }
            }
            c0453Rm.b = true;
        }
        return c0453Rm;
    }

    public static void t(View view, int i) {
        C0453Rm c0453Rm = (C0453Rm) view.getLayoutParams();
        int i2 = c0453Rm.i;
        if (i2 != i) {
            WeakHashMap weakHashMap = Oj0.a;
            view.offsetLeftAndRight(i - i2);
            c0453Rm.i = i;
        }
    }

    public static void u(View view, int i) {
        C0453Rm c0453Rm = (C0453Rm) view.getLayoutParams();
        int i2 = c0453Rm.j;
        if (i2 != i) {
            WeakHashMap weakHashMap = Oj0.a;
            view.offsetTopAndBottom(i - i2);
            c0453Rm.j = i;
        }
    }

    @Override // o.RR
    public final void a(View view, View view2, int i, int i2) {
        KZ kz = this.D;
        if (i2 == 1) {
            kz.c = i;
        } else {
            kz.b = i;
        }
        this.v = view2;
        int childCount = getChildCount();
        for (int i3 = 0; i3 < childCount; i3++) {
            ((C0453Rm) getChildAt(i3).getLayoutParams()).getClass();
        }
    }

    @Override // o.RR
    public final void b(View view, int i) {
        KZ kz = this.D;
        if (i == 1) {
            kz.c = 0;
        } else {
            kz.b = 0;
        }
        int childCount = getChildCount();
        for (int i2 = 0; i2 < childCount; i2++) {
            View childAt = getChildAt(i2);
            C0453Rm c0453Rm = (C0453Rm) childAt.getLayoutParams();
            if (c0453Rm.a(i)) {
                AbstractC0375Om abstractC0375Om = c0453Rm.a;
                if (abstractC0375Om != null) {
                    abstractC0375Om.p(childAt, view, i);
                }
                if (i == 0) {
                    c0453Rm.m = false;
                } else if (i == 1) {
                    c0453Rm.n = false;
                }
            }
        }
        this.v = null;
    }

    @Override // o.RR
    public final void c(View view, int i, int i2, int[] iArr, int i3) {
        AbstractC0375Om abstractC0375Om;
        int childCount = getChildCount();
        boolean z = false;
        int iMax = 0;
        int iMax2 = 0;
        for (int i4 = 0; i4 < childCount; i4++) {
            View childAt = getChildAt(i4);
            if (childAt.getVisibility() != 8) {
                C0453Rm c0453Rm = (C0453Rm) childAt.getLayoutParams();
                if (c0453Rm.a(i3) && (abstractC0375Om = c0453Rm.a) != null) {
                    int[] iArr2 = this.p;
                    iArr2[0] = 0;
                    iArr2[1] = 0;
                    abstractC0375Om.j(this, childAt, view, i, i2, iArr2, i3);
                    iMax = i > 0 ? Math.max(iMax, iArr2[0]) : Math.min(iMax, iArr2[0]);
                    iMax2 = i2 > 0 ? Math.max(iMax2, iArr2[1]) : Math.min(iMax2, iArr2[1]);
                    z = true;
                }
            }
        }
        iArr[0] = iMax;
        iArr[1] = iMax2;
        if (z) {
            o(1);
        }
    }

    @Override // android.view.ViewGroup
    public final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof C0453Rm) && super.checkLayoutParams(layoutParams);
    }

    @Override // android.view.ViewGroup
    public final boolean drawChild(Canvas canvas, View view, long j) {
        AbstractC0375Om abstractC0375Om = ((C0453Rm) view.getLayoutParams()).a;
        if (abstractC0375Om != null) {
            abstractC0375Om.getClass();
        }
        return super.drawChild(canvas, view, j);
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void drawableStateChanged() {
        super.drawableStateChanged();
        int[] drawableState = getDrawableState();
        Drawable drawable = this.A;
        if ((drawable == null || !drawable.isStateful()) ? false : drawable.setState(drawableState)) {
            invalidate();
        }
    }

    public final void e(C0453Rm c0453Rm, Rect rect, int i, int i2) {
        int width = getWidth();
        int height = getHeight();
        int iMax = Math.max(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) c0453Rm).leftMargin, Math.min(rect.left, ((width - getPaddingRight()) - i) - ((ViewGroup.MarginLayoutParams) c0453Rm).rightMargin));
        int iMax2 = Math.max(getPaddingTop() + ((ViewGroup.MarginLayoutParams) c0453Rm).topMargin, Math.min(rect.top, ((height - getPaddingBottom()) - i2) - ((ViewGroup.MarginLayoutParams) c0453Rm).bottomMargin));
        rect.set(iMax, iMax2, i + iMax, i2 + iMax2);
    }

    @Override // o.SR
    public final void f(View view, int i, int i2, int i3, int i4, int i5, int[] iArr) {
        AbstractC0375Om abstractC0375Om;
        int childCount = getChildCount();
        int iMax = 0;
        int iMax2 = 0;
        boolean z = false;
        for (int i6 = 0; i6 < childCount; i6++) {
            View childAt = getChildAt(i6);
            if (childAt.getVisibility() != 8) {
                C0453Rm c0453Rm = (C0453Rm) childAt.getLayoutParams();
                if (c0453Rm.a(i5) && (abstractC0375Om = c0453Rm.a) != null) {
                    int[] iArr2 = this.p;
                    iArr2[0] = 0;
                    iArr2[1] = 0;
                    abstractC0375Om.k(this, childAt, i2, i3, i4, iArr2);
                    iMax = i3 > 0 ? Math.max(iMax, iArr2[0]) : Math.min(iMax, iArr2[0]);
                    iMax2 = i4 > 0 ? Math.max(iMax2, iArr2[1]) : Math.min(iMax2, iArr2[1]);
                    z = true;
                }
            }
        }
        iArr[0] = iArr[0] + iMax;
        iArr[1] = iArr[1] + iMax2;
        if (z) {
            o(1);
        }
    }

    @Override // o.RR
    public final void g(View view, int i, int i2, int i3, int i4, int i5) {
        f(view, i, i2, i3, i4, 0, this.q);
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new C0453Rm();
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new C0453Rm(getContext(), attributeSet);
    }

    public final List<View> getDependencySortedChildren() {
        r();
        return Collections.unmodifiableList(this.l);
    }

    public final Kl0 getLastWindowInsets() {
        return this.y;
    }

    @Override // android.view.ViewGroup
    public int getNestedScrollAxes() {
        KZ kz = this.D;
        return kz.c | kz.b;
    }

    public Drawable getStatusBarBackground() {
        return this.A;
    }

    @Override // android.view.View
    public int getSuggestedMinimumHeight() {
        return Math.max(super.getSuggestedMinimumHeight(), getPaddingBottom() + getPaddingTop());
    }

    @Override // android.view.View
    public int getSuggestedMinimumWidth() {
        return Math.max(super.getSuggestedMinimumWidth(), getPaddingRight() + getPaddingLeft());
    }

    @Override // o.RR
    public final boolean h(View view, View view2, int i, int i2) {
        int childCount = getChildCount();
        boolean z = false;
        for (int i3 = 0; i3 < childCount; i3++) {
            View childAt = getChildAt(i3);
            if (childAt.getVisibility() != 8) {
                C0453Rm c0453Rm = (C0453Rm) childAt.getLayoutParams();
                AbstractC0375Om abstractC0375Om = c0453Rm.a;
                if (abstractC0375Om != null) {
                    boolean zO = abstractC0375Om.o(childAt, i, i2);
                    z |= zO;
                    if (i2 == 0) {
                        c0453Rm.m = zO;
                    } else if (i2 == 1) {
                        c0453Rm.n = zO;
                    }
                } else if (i2 == 0) {
                    c0453Rm.m = false;
                } else if (i2 == 1) {
                    c0453Rm.n = false;
                }
            }
        }
        return z;
    }

    public final void i(View view, Rect rect, boolean z) {
        if (view.isLayoutRequested() || view.getVisibility() == 8) {
            rect.setEmpty();
        } else if (z) {
            k(view, rect);
        } else {
            rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public final ArrayList j(View view) {
        I80 i80 = (I80) this.m.b;
        int i = i80.n;
        ArrayList arrayList = null;
        for (int i2 = 0; i2 < i; i2++) {
            ArrayList arrayList2 = (ArrayList) i80.i(i2);
            if (arrayList2 != null && arrayList2.contains(view)) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(i80.f(i2));
            }
        }
        ArrayList arrayList3 = this.f11o;
        arrayList3.clear();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        return arrayList3;
    }

    public final void k(View view, Rect rect) {
        ThreadLocal threadLocal = Wj0.a;
        rect.set(0, 0, view.getWidth(), view.getHeight());
        ThreadLocal threadLocal2 = Wj0.a;
        Matrix matrix = (Matrix) threadLocal2.get();
        if (matrix == null) {
            matrix = new Matrix();
            threadLocal2.set(matrix);
        } else {
            matrix.reset();
        }
        Wj0.a(this, view, matrix);
        ThreadLocal threadLocal3 = Wj0.b;
        RectF rectF = (RectF) threadLocal3.get();
        if (rectF == null) {
            rectF = new RectF();
            threadLocal3.set(rectF);
        }
        rectF.set(rect);
        matrix.mapRect(rectF);
        rect.set((int) (rectF.left + 0.5f), (int) (rectF.top + 0.5f), (int) (rectF.right + 0.5f), (int) (rectF.bottom + 0.5f));
    }

    public final boolean n(View view, int i, int i2) {
        SX sx = I;
        Rect rectD = d();
        k(view, rectD);
        try {
            return rectD.contains(i, i2);
        } finally {
            rectD.setEmpty();
            sx.c(rectD);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:104:0x026c  */
    /* JADX WARN: Removed duplicated region for block: B:107:0x0270  */
    /* JADX WARN: Removed duplicated region for block: B:111:0x0294  */
    /* JADX WARN: Removed duplicated region for block: B:115:0x029e  */
    /* JADX WARN: Removed duplicated region for block: B:33:0x00de  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void o(int r23) {
        /*
            Method dump skipped, instructions count: 721
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.coordinatorlayout.widget.CoordinatorLayout.o(int):void");
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onAttachedToWindow() {
        super.onAttachedToWindow();
        s(false);
        if (this.x) {
            if (this.w == null) {
                this.w = new ViewTreeObserverOnPreDrawListenerC0479Sm(this);
            }
            getViewTreeObserver().addOnPreDrawListener(this.w);
        }
        if (this.y == null) {
            WeakHashMap weakHashMap = Oj0.a;
            if (getFitsSystemWindows()) {
                Ej0.c(this);
            }
        }
        this.s = true;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        s(false);
        if (this.x && this.w != null) {
            getViewTreeObserver().removeOnPreDrawListener(this.w);
        }
        View view = this.v;
        if (view != null) {
            b(view, 0);
        }
        this.s = false;
    }

    @Override // android.view.View
    public final void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.z || this.A == null) {
            return;
        }
        Kl0 kl0 = this.y;
        int iD = kl0 != null ? kl0.d() : 0;
        if (iD > 0) {
            this.A.setBounds(0, 0, getWidth(), iD);
            this.A.draw(canvas);
        }
    }

    @Override // android.view.ViewGroup
    public final boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            s(true);
        }
        boolean zQ = q(motionEvent, 0);
        if (actionMasked != 1 && actionMasked != 3) {
            return zQ;
        }
        s(true);
        return zQ;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        AbstractC0375Om abstractC0375Om;
        WeakHashMap weakHashMap = Oj0.a;
        int layoutDirection = getLayoutDirection();
        ArrayList arrayList = this.l;
        int size = arrayList.size();
        for (int i5 = 0; i5 < size; i5++) {
            View view = (View) arrayList.get(i5);
            if (view.getVisibility() != 8 && ((abstractC0375Om = ((C0453Rm) view.getLayoutParams()).a) == null || !abstractC0375Om.g(this, view, layoutDirection))) {
                p(view, layoutDirection);
            }
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:62:0x0106  */
    /* JADX WARN: Removed duplicated region for block: B:71:0x0126 A[ADDED_TO_REGION] */
    /* JADX WARN: Removed duplicated region for block: B:72:0x0128  */
    /* JADX WARN: Removed duplicated region for block: B:83:0x016f  */
    /* JADX WARN: Removed duplicated region for block: B:86:0x0177  */
    /* JADX WARN: Removed duplicated region for block: B:90:0x01a1  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void onMeasure(int r26, int r27) {
        /*
            Method dump skipped, instructions count: 528
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.coordinatorlayout.widget.CoordinatorLayout.onMeasure(int, int):void");
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final boolean onNestedFling(View view, float f, float f2, boolean z) {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() != 8) {
                C0453Rm c0453Rm = (C0453Rm) childAt.getLayoutParams();
                if (c0453Rm.a(0)) {
                    AbstractC0375Om abstractC0375Om = c0453Rm.a;
                }
            }
        }
        return false;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final boolean onNestedPreFling(View view, float f, float f2) {
        AbstractC0375Om abstractC0375Om;
        int childCount = getChildCount();
        boolean zI = false;
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() != 8) {
                C0453Rm c0453Rm = (C0453Rm) childAt.getLayoutParams();
                if (c0453Rm.a(0) && (abstractC0375Om = c0453Rm.a) != null) {
                    zI |= abstractC0375Om.i(view);
                }
            }
        }
        return zI;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
        c(view, i, i2, iArr, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        g(view, i, i2, i3, i4, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void onNestedScrollAccepted(View view, View view2, int i) {
        a(view, view2, i, 0);
    }

    @Override // android.view.View
    public final void onRestoreInstanceState(Parcelable parcelable) {
        Parcelable parcelable2;
        if (!(parcelable instanceof C0505Tm)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        C0505Tm c0505Tm = (C0505Tm) parcelable;
        super.onRestoreInstanceState(c0505Tm.l);
        SparseArray sparseArray = c0505Tm.n;
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            int id = childAt.getId();
            AbstractC0375Om abstractC0375Om = m(childAt).a;
            if (id != -1 && abstractC0375Om != null && (parcelable2 = (Parcelable) sparseArray.get(id)) != null) {
                abstractC0375Om.m(childAt, parcelable2);
            }
        }
    }

    @Override // android.view.View
    public final Parcelable onSaveInstanceState() {
        Parcelable parcelableN;
        C0505Tm c0505Tm = new C0505Tm(super.onSaveInstanceState());
        SparseArray sparseArray = new SparseArray();
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            int id = childAt.getId();
            AbstractC0375Om abstractC0375Om = ((C0453Rm) childAt.getLayoutParams()).a;
            if (id != -1 && abstractC0375Om != null && (parcelableN = abstractC0375Om.n(childAt)) != null) {
                sparseArray.append(id, parcelableN);
            }
        }
        c0505Tm.n = sparseArray;
        return c0505Tm;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final boolean onStartNestedScroll(View view, View view2, int i) {
        return h(view, view2, i, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void onStopNestedScroll(View view) {
        b(view, 0);
    }

    /* JADX WARN: Removed duplicated region for block: B:14:0x002f  */
    /* JADX WARN: Removed duplicated region for block: B:15:0x0035  */
    /* JADX WARN: Removed duplicated region for block: B:18:0x004a  */
    /* JADX WARN: Removed duplicated region for block: B:7:0x0015 A[PHI: r3
      0x0015: PHI (r3v4 boolean) = (r3v2 boolean), (r3v5 boolean) binds: [B:10:0x0022, B:5:0x0012] A[DONT_GENERATE, DONT_INLINE]] */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final boolean onTouchEvent(android.view.MotionEvent r18) {
        /*
            r17 = this;
            r0 = r17
            r1 = r18
            int r2 = r1.getActionMasked()
            android.view.View r3 = r0.u
            r4 = 1
            r5 = 0
            if (r3 != 0) goto L17
            boolean r3 = r0.q(r1, r4)
            if (r3 == 0) goto L15
            goto L18
        L15:
            r6 = r5
            goto L2a
        L17:
            r3 = r5
        L18:
            android.view.View r6 = r0.u
            android.view.ViewGroup$LayoutParams r6 = r6.getLayoutParams()
            o.Rm r6 = (o.C0453Rm) r6
            o.Om r6 = r6.a
            if (r6 == 0) goto L15
            android.view.View r7 = r0.u
            boolean r6 = r6.q(r7, r1)
        L2a:
            android.view.View r7 = r0.u
            r8 = 0
            if (r7 != 0) goto L35
            boolean r1 = super.onTouchEvent(r18)
            r6 = r6 | r1
            goto L48
        L35:
            if (r3 == 0) goto L48
            long r9 = android.os.SystemClock.uptimeMillis()
            r15 = 0
            r16 = 0
            r13 = 3
            r14 = 0
            r11 = r9
            android.view.MotionEvent r8 = android.view.MotionEvent.obtain(r9, r11, r13, r14, r15, r16)
            super.onTouchEvent(r8)
        L48:
            if (r8 == 0) goto L4d
            r8.recycle()
        L4d:
            if (r2 == r4) goto L54
            r1 = 3
            if (r2 != r1) goto L53
            goto L54
        L53:
            return r6
        L54:
            r0.s(r5)
            return r6
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.coordinatorlayout.widget.CoordinatorLayout.onTouchEvent(android.view.MotionEvent):boolean");
    }

    /* JADX WARN: Removed duplicated region for block: B:38:0x00ad  */
    /* JADX WARN: Removed duplicated region for block: B:42:0x00b3  */
    /* JADX WARN: Removed duplicated region for block: B:45:0x00ba  */
    /* JADX WARN: Removed duplicated region for block: B:49:0x00c1  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void p(android.view.View r13, int r14) {
        /*
            Method dump skipped, instructions count: 419
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.coordinatorlayout.widget.CoordinatorLayout.p(android.view.View, int):void");
    }

    public final boolean q(MotionEvent motionEvent, int i) {
        int actionMasked = motionEvent.getActionMasked();
        ArrayList arrayList = this.n;
        arrayList.clear();
        boolean zIsChildrenDrawingOrderEnabled = isChildrenDrawingOrderEnabled();
        int childCount = getChildCount();
        for (int i2 = childCount - 1; i2 >= 0; i2--) {
            arrayList.add(getChildAt(zIsChildrenDrawingOrderEnabled ? getChildDrawingOrder(childCount, i2) : i2));
        }
        C1746lA c1746lA = H;
        if (c1746lA != null) {
            Collections.sort(arrayList, c1746lA);
        }
        int size = arrayList.size();
        MotionEvent motionEventObtain = null;
        boolean zF = false;
        for (int i3 = 0; i3 < size; i3++) {
            View view = (View) arrayList.get(i3);
            AbstractC0375Om abstractC0375Om = ((C0453Rm) view.getLayoutParams()).a;
            if (zF && actionMasked != 0) {
                if (abstractC0375Om != null) {
                    if (motionEventObtain == null) {
                        long jUptimeMillis = SystemClock.uptimeMillis();
                        motionEventObtain = MotionEvent.obtain(jUptimeMillis, jUptimeMillis, 3, 0.0f, 0.0f, 0);
                    }
                    if (i == 0) {
                        abstractC0375Om.f(this, view, motionEventObtain);
                    } else if (i == 1) {
                        abstractC0375Om.q(view, motionEventObtain);
                    }
                }
            } else if (!zF && abstractC0375Om != null) {
                if (i == 0) {
                    zF = abstractC0375Om.f(this, view, motionEvent);
                } else if (i == 1) {
                    zF = abstractC0375Om.q(view, motionEvent);
                }
                if (zF) {
                    this.u = view;
                }
            }
        }
        arrayList.clear();
        return zF;
    }

    /* JADX WARN: Removed duplicated region for block: B:31:0x007c  */
    /* JADX WARN: Removed duplicated region for block: B:51:0x00bd  */
    /* JADX WARN: Removed duplicated region for block: B:71:0x0104  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void r() {
        /*
            Method dump skipped, instructions count: 400
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.coordinatorlayout.widget.CoordinatorLayout.r():void");
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z) {
        AbstractC0375Om abstractC0375Om = ((C0453Rm) view.getLayoutParams()).a;
        if (abstractC0375Om != null) {
            abstractC0375Om.l(this, view);
        }
        return super.requestChildRectangleOnScreen(view, rect, z);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void requestDisallowInterceptTouchEvent(boolean z) {
        super.requestDisallowInterceptTouchEvent(z);
        if (!z || this.r) {
            return;
        }
        s(false);
        this.r = true;
    }

    public final void s(boolean z) {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            AbstractC0375Om abstractC0375Om = ((C0453Rm) childAt.getLayoutParams()).a;
            if (abstractC0375Om != null) {
                long jUptimeMillis = SystemClock.uptimeMillis();
                MotionEvent motionEventObtain = MotionEvent.obtain(jUptimeMillis, jUptimeMillis, 3, 0.0f, 0.0f, 0);
                if (z) {
                    abstractC0375Om.f(this, childAt, motionEventObtain);
                } else {
                    abstractC0375Om.q(childAt, motionEventObtain);
                }
                motionEventObtain.recycle();
            }
        }
        for (int i2 = 0; i2 < childCount; i2++) {
            ((C0453Rm) getChildAt(i2).getLayoutParams()).getClass();
        }
        this.u = null;
        this.r = false;
    }

    @Override // android.view.View
    public void setFitsSystemWindows(boolean z) {
        super.setFitsSystemWindows(z);
        v();
    }

    @Override // android.view.ViewGroup
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.B = onHierarchyChangeListener;
    }

    public void setStatusBarBackground(Drawable drawable) {
        Drawable drawable2 = this.A;
        if (drawable2 != drawable) {
            if (drawable2 != null) {
                drawable2.setCallback(null);
            }
            Drawable drawableMutate = drawable != null ? drawable.mutate() : null;
            this.A = drawableMutate;
            if (drawableMutate != null) {
                if (drawableMutate.isStateful()) {
                    this.A.setState(getDrawableState());
                }
                Drawable drawable3 = this.A;
                WeakHashMap weakHashMap = Oj0.a;
                drawable3.setLayoutDirection(getLayoutDirection());
                this.A.setVisible(getVisibility() == 0, false);
                this.A.setCallback(this);
            }
            WeakHashMap weakHashMap2 = Oj0.a;
            postInvalidateOnAnimation();
        }
    }

    public void setStatusBarBackgroundColor(int i) {
        setStatusBarBackground(new ColorDrawable(i));
    }

    public void setStatusBarBackgroundResource(int i) {
        setStatusBarBackground(i != 0 ? getContext().getDrawable(i) : null);
    }

    @Override // android.view.View
    public void setVisibility(int i) {
        super.setVisibility(i);
        boolean z = i == 0;
        Drawable drawable = this.A;
        if (drawable == null || drawable.isVisible() == z) {
            return;
        }
        this.A.setVisible(z, false);
    }

    public final void v() {
        WeakHashMap weakHashMap = Oj0.a;
        if (!getFitsSystemWindows()) {
            Gj0.l(this, null);
            return;
        }
        if (this.C == null) {
            this.C = new OD(28, this);
        }
        Gj0.l(this, this.C);
        setSystemUiVisibility(1280);
    }

    @Override // android.view.View
    public final boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.A;
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C0453Rm ? new C0453Rm((C0453Rm) layoutParams) : layoutParams instanceof ViewGroup.MarginLayoutParams ? new C0453Rm((ViewGroup.MarginLayoutParams) layoutParams) : new C0453Rm(layoutParams);
    }
}
