package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.CommonStatusCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import o.AbstractC0089Dl;
import o.AbstractC0115El;
import o.AbstractC0660Zl;
import o.C0141Fl;
import o.C0167Gl;
import o.C0193Hl;
import o.C0426Ql;
import o.C0530Ul;
import o.C0556Vl;
import o.C1390hY;
import o.C2509tE;
import o.C2604uE;
import o.C2787w80;
import o.C2991yL;
import o.C3111zf;
import o.RZ;
import org.xmlpull.v1.XmlPullParserException;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class ConstraintLayout extends ViewGroup {
    public static C2787w80 A;
    public final SparseArray l;
    public final ArrayList m;
    public final C0556Vl n;

    /* renamed from: o, reason: collision with root package name */
    public int f10o;
    public int p;
    public int q;
    public int r;
    public boolean s;
    public int t;
    public C0426Ql u;
    public C1390hY v;
    public int w;
    public HashMap x;
    public final SparseArray y;
    public final C0167Gl z;

    public ConstraintLayout(Context context, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        super(context, attributeSet);
        this.l = new SparseArray();
        this.m = new ArrayList(4);
        this.n = new C0556Vl();
        this.f10o = 0;
        this.p = 0;
        this.q = Api.BaseClientBuilder.API_PRIORITY_OTHER;
        this.r = Api.BaseClientBuilder.API_PRIORITY_OTHER;
        this.s = true;
        this.t = 257;
        this.u = null;
        this.v = null;
        this.w = -1;
        this.x = new HashMap();
        this.y = new SparseArray();
        this.z = new C0167Gl(this, this);
        i(attributeSet, 0);
    }

    public static C0141Fl d() {
        C0141Fl c0141Fl = new C0141Fl(-2, -2);
        c0141Fl.a = -1;
        c0141Fl.b = -1;
        c0141Fl.c = -1.0f;
        c0141Fl.d = true;
        c0141Fl.e = -1;
        c0141Fl.f = -1;
        c0141Fl.g = -1;
        c0141Fl.h = -1;
        c0141Fl.i = -1;
        c0141Fl.j = -1;
        c0141Fl.k = -1;
        c0141Fl.l = -1;
        c0141Fl.m = -1;
        c0141Fl.n = -1;
        c0141Fl.f125o = -1;
        c0141Fl.p = -1;
        c0141Fl.q = 0;
        c0141Fl.r = 0.0f;
        c0141Fl.s = -1;
        c0141Fl.t = -1;
        c0141Fl.u = -1;
        c0141Fl.v = -1;
        c0141Fl.w = Integer.MIN_VALUE;
        c0141Fl.x = Integer.MIN_VALUE;
        c0141Fl.y = Integer.MIN_VALUE;
        c0141Fl.z = Integer.MIN_VALUE;
        c0141Fl.A = Integer.MIN_VALUE;
        c0141Fl.B = Integer.MIN_VALUE;
        c0141Fl.C = Integer.MIN_VALUE;
        c0141Fl.D = 0;
        c0141Fl.E = 0.5f;
        c0141Fl.F = 0.5f;
        c0141Fl.G = null;
        c0141Fl.H = -1.0f;
        c0141Fl.I = -1.0f;
        c0141Fl.J = 0;
        c0141Fl.K = 0;
        c0141Fl.L = 0;
        c0141Fl.M = 0;
        c0141Fl.N = 0;
        c0141Fl.O = 0;
        c0141Fl.P = 0;
        c0141Fl.Q = 0;
        c0141Fl.R = 1.0f;
        c0141Fl.S = 1.0f;
        c0141Fl.T = -1;
        c0141Fl.U = -1;
        c0141Fl.V = -1;
        c0141Fl.W = false;
        c0141Fl.X = false;
        c0141Fl.Y = null;
        c0141Fl.Z = 0;
        c0141Fl.a0 = true;
        c0141Fl.b0 = true;
        c0141Fl.c0 = false;
        c0141Fl.d0 = false;
        c0141Fl.e0 = false;
        c0141Fl.f0 = -1;
        c0141Fl.g0 = -1;
        c0141Fl.h0 = -1;
        c0141Fl.i0 = -1;
        c0141Fl.j0 = Integer.MIN_VALUE;
        c0141Fl.k0 = Integer.MIN_VALUE;
        c0141Fl.l0 = 0.5f;
        c0141Fl.p0 = new C0530Ul();
        return c0141Fl;
    }

    private int getPaddingWidth() {
        int iMax = Math.max(0, getPaddingRight()) + Math.max(0, getPaddingLeft());
        int iMax2 = Math.max(0, getPaddingEnd()) + Math.max(0, getPaddingStart());
        return iMax2 > 0 ? iMax2 : iMax;
    }

    public static C2787w80 getSharedValues() {
        if (A == null) {
            C2787w80 c2787w80 = new C2787w80();
            new SparseIntArray();
            new HashMap();
            A = c2787w80;
        }
        return A;
    }

    @Override // android.view.ViewGroup
    public final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C0141Fl;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void dispatchDraw(Canvas canvas) throws NumberFormatException {
        Object tag;
        int size;
        ArrayList arrayList = this.m;
        if (arrayList != null && (size = arrayList.size()) > 0) {
            for (int i = 0; i < size; i++) {
                ((AbstractC0089Dl) arrayList.get(i)).getClass();
            }
        }
        super.dispatchDraw(canvas);
        if (isInEditMode()) {
            float width = getWidth();
            float height = getHeight();
            int childCount = getChildCount();
            for (int i2 = 0; i2 < childCount; i2++) {
                View childAt = getChildAt(i2);
                if (childAt.getVisibility() != 8 && (tag = childAt.getTag()) != null && (tag instanceof String)) {
                    String[] strArrSplit = ((String) tag).split(",");
                    if (strArrSplit.length == 4) {
                        int i3 = Integer.parseInt(strArrSplit[0]);
                        int i4 = Integer.parseInt(strArrSplit[1]);
                        int i5 = Integer.parseInt(strArrSplit[2]);
                        int i6 = (int) ((i3 / 1080.0f) * width);
                        int i7 = (int) ((i4 / 1920.0f) * height);
                        Paint paint = new Paint();
                        paint.setColor(-65536);
                        float f = i6;
                        float f2 = i7;
                        float f3 = i6 + ((int) ((i5 / 1080.0f) * width));
                        canvas.drawLine(f, f2, f3, f2, paint);
                        float f4 = i7 + ((int) ((Integer.parseInt(strArrSplit[3]) / 1920.0f) * height));
                        canvas.drawLine(f3, f2, f3, f4, paint);
                        canvas.drawLine(f3, f4, f, f4, paint);
                        canvas.drawLine(f, f4, f, f2, paint);
                        paint.setColor(-16711936);
                        canvas.drawLine(f, f2, f3, f4, paint);
                        canvas.drawLine(f, f4, f3, f2, paint);
                    }
                }
            }
        }
    }

    public final C0530Ul e(View view) {
        if (view == this) {
            return this.n;
        }
        if (view == null) {
            return null;
        }
        if (view.getLayoutParams() instanceof C0141Fl) {
            return ((C0141Fl) view.getLayoutParams()).p0;
        }
        view.setLayoutParams(generateLayoutParams(view.getLayoutParams()));
        if (view.getLayoutParams() instanceof C0141Fl) {
            return ((C0141Fl) view.getLayoutParams()).p0;
        }
        return null;
    }

    @Override // android.view.View
    public final void forceLayout() {
        this.s = true;
        super.forceLayout();
    }

    @Override // android.view.ViewGroup
    public final /* bridge */ /* synthetic */ ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return d();
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = getContext();
        C0141Fl c0141Fl = new C0141Fl(context, attributeSet);
        c0141Fl.a = -1;
        c0141Fl.b = -1;
        c0141Fl.c = -1.0f;
        c0141Fl.d = true;
        c0141Fl.e = -1;
        c0141Fl.f = -1;
        c0141Fl.g = -1;
        c0141Fl.h = -1;
        c0141Fl.i = -1;
        c0141Fl.j = -1;
        c0141Fl.k = -1;
        c0141Fl.l = -1;
        c0141Fl.m = -1;
        c0141Fl.n = -1;
        c0141Fl.f125o = -1;
        c0141Fl.p = -1;
        c0141Fl.q = 0;
        c0141Fl.r = 0.0f;
        c0141Fl.s = -1;
        c0141Fl.t = -1;
        c0141Fl.u = -1;
        c0141Fl.v = -1;
        c0141Fl.w = Integer.MIN_VALUE;
        c0141Fl.x = Integer.MIN_VALUE;
        c0141Fl.y = Integer.MIN_VALUE;
        c0141Fl.z = Integer.MIN_VALUE;
        c0141Fl.A = Integer.MIN_VALUE;
        c0141Fl.B = Integer.MIN_VALUE;
        c0141Fl.C = Integer.MIN_VALUE;
        c0141Fl.D = 0;
        c0141Fl.E = 0.5f;
        c0141Fl.F = 0.5f;
        c0141Fl.G = null;
        c0141Fl.H = -1.0f;
        c0141Fl.I = -1.0f;
        c0141Fl.J = 0;
        c0141Fl.K = 0;
        c0141Fl.L = 0;
        c0141Fl.M = 0;
        c0141Fl.N = 0;
        c0141Fl.O = 0;
        c0141Fl.P = 0;
        c0141Fl.Q = 0;
        c0141Fl.R = 1.0f;
        c0141Fl.S = 1.0f;
        c0141Fl.T = -1;
        c0141Fl.U = -1;
        c0141Fl.V = -1;
        c0141Fl.W = false;
        c0141Fl.X = false;
        c0141Fl.Y = null;
        c0141Fl.Z = 0;
        c0141Fl.a0 = true;
        c0141Fl.b0 = true;
        c0141Fl.c0 = false;
        c0141Fl.d0 = false;
        c0141Fl.e0 = false;
        c0141Fl.f0 = -1;
        c0141Fl.g0 = -1;
        c0141Fl.h0 = -1;
        c0141Fl.i0 = -1;
        c0141Fl.j0 = Integer.MIN_VALUE;
        c0141Fl.k0 = Integer.MIN_VALUE;
        c0141Fl.l0 = 0.5f;
        c0141Fl.p0 = new C0530Ul();
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, RZ.b);
        int indexCount = typedArrayObtainStyledAttributes.getIndexCount();
        for (int i = 0; i < indexCount; i++) {
            int index = typedArrayObtainStyledAttributes.getIndex(i);
            int i2 = AbstractC0115El.a.get(index);
            switch (i2) {
                case 1:
                    c0141Fl.V = typedArrayObtainStyledAttributes.getInt(index, c0141Fl.V);
                    break;
                case 2:
                    int resourceId = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.p);
                    c0141Fl.p = resourceId;
                    if (resourceId == -1) {
                        c0141Fl.p = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 3:
                    c0141Fl.q = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.q);
                    break;
                case 4:
                    float f = typedArrayObtainStyledAttributes.getFloat(index, c0141Fl.r) % 360.0f;
                    c0141Fl.r = f;
                    if (f < 0.0f) {
                        c0141Fl.r = (360.0f - f) % 360.0f;
                        break;
                    } else {
                        break;
                    }
                case 5:
                    c0141Fl.a = typedArrayObtainStyledAttributes.getDimensionPixelOffset(index, c0141Fl.a);
                    break;
                case 6:
                    c0141Fl.b = typedArrayObtainStyledAttributes.getDimensionPixelOffset(index, c0141Fl.b);
                    break;
                case 7:
                    c0141Fl.c = typedArrayObtainStyledAttributes.getFloat(index, c0141Fl.c);
                    break;
                case 8:
                    int resourceId2 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.e);
                    c0141Fl.e = resourceId2;
                    if (resourceId2 == -1) {
                        c0141Fl.e = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case ConnectionResult.SERVICE_INVALID /* 9 */:
                    int resourceId3 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.f);
                    c0141Fl.f = resourceId3;
                    if (resourceId3 == -1) {
                        c0141Fl.f = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 10:
                    int resourceId4 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.g);
                    c0141Fl.g = resourceId4;
                    if (resourceId4 == -1) {
                        c0141Fl.g = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case ConnectionResult.LICENSE_CHECK_FAILED /* 11 */:
                    int resourceId5 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.h);
                    c0141Fl.h = resourceId5;
                    if (resourceId5 == -1) {
                        c0141Fl.h = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 12:
                    int resourceId6 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.i);
                    c0141Fl.i = resourceId6;
                    if (resourceId6 == -1) {
                        c0141Fl.i = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 13:
                    int resourceId7 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.j);
                    c0141Fl.j = resourceId7;
                    if (resourceId7 == -1) {
                        c0141Fl.j = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 14:
                    int resourceId8 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.k);
                    c0141Fl.k = resourceId8;
                    if (resourceId8 == -1) {
                        c0141Fl.k = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 15:
                    int resourceId9 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.l);
                    c0141Fl.l = resourceId9;
                    if (resourceId9 == -1) {
                        c0141Fl.l = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 16:
                    int resourceId10 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.m);
                    c0141Fl.m = resourceId10;
                    if (resourceId10 == -1) {
                        c0141Fl.m = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 17:
                    int resourceId11 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.s);
                    c0141Fl.s = resourceId11;
                    if (resourceId11 == -1) {
                        c0141Fl.s = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case ConnectionResult.SERVICE_UPDATING /* 18 */:
                    int resourceId12 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.t);
                    c0141Fl.t = resourceId12;
                    if (resourceId12 == -1) {
                        c0141Fl.t = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 19:
                    int resourceId13 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.u);
                    c0141Fl.u = resourceId13;
                    if (resourceId13 == -1) {
                        c0141Fl.u = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case 20:
                    int resourceId14 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.v);
                    c0141Fl.v = resourceId14;
                    if (resourceId14 == -1) {
                        c0141Fl.v = typedArrayObtainStyledAttributes.getInt(index, -1);
                        break;
                    } else {
                        break;
                    }
                case CommonStatusCodes.RECONNECTION_TIMED_OUT_DURING_UPDATE /* 21 */:
                    c0141Fl.w = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.w);
                    break;
                case 22:
                    c0141Fl.x = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.x);
                    break;
                case ConnectionResult.API_DISABLED /* 23 */:
                    c0141Fl.y = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.y);
                    break;
                case ConnectionResult.API_DISABLED_FOR_CONNECTION /* 24 */:
                    c0141Fl.z = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.z);
                    break;
                case 25:
                    c0141Fl.A = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.A);
                    break;
                case 26:
                    c0141Fl.B = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.B);
                    break;
                case 27:
                    c0141Fl.W = typedArrayObtainStyledAttributes.getBoolean(index, c0141Fl.W);
                    break;
                case 28:
                    c0141Fl.X = typedArrayObtainStyledAttributes.getBoolean(index, c0141Fl.X);
                    break;
                case 29:
                    c0141Fl.E = typedArrayObtainStyledAttributes.getFloat(index, c0141Fl.E);
                    break;
                case 30:
                    c0141Fl.F = typedArrayObtainStyledAttributes.getFloat(index, c0141Fl.F);
                    break;
                case 31:
                    c0141Fl.L = typedArrayObtainStyledAttributes.getInt(index, 0);
                    break;
                case 32:
                    c0141Fl.M = typedArrayObtainStyledAttributes.getInt(index, 0);
                    break;
                case 33:
                    try {
                        c0141Fl.N = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.N);
                        break;
                    } catch (Exception unused) {
                        if (typedArrayObtainStyledAttributes.getInt(index, c0141Fl.N) == -2) {
                            c0141Fl.N = -2;
                            break;
                        } else {
                            break;
                        }
                    }
                case 34:
                    try {
                        c0141Fl.P = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.P);
                        break;
                    } catch (Exception unused2) {
                        if (typedArrayObtainStyledAttributes.getInt(index, c0141Fl.P) == -2) {
                            c0141Fl.P = -2;
                            break;
                        } else {
                            break;
                        }
                    }
                case 35:
                    c0141Fl.R = Math.max(0.0f, typedArrayObtainStyledAttributes.getFloat(index, c0141Fl.R));
                    c0141Fl.L = 2;
                    break;
                case 36:
                    try {
                        c0141Fl.O = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.O);
                        break;
                    } catch (Exception unused3) {
                        if (typedArrayObtainStyledAttributes.getInt(index, c0141Fl.O) == -2) {
                            c0141Fl.O = -2;
                            break;
                        } else {
                            break;
                        }
                    }
                case 37:
                    try {
                        c0141Fl.Q = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.Q);
                        break;
                    } catch (Exception unused4) {
                        if (typedArrayObtainStyledAttributes.getInt(index, c0141Fl.Q) == -2) {
                            c0141Fl.Q = -2;
                            break;
                        } else {
                            break;
                        }
                    }
                case 38:
                    c0141Fl.S = Math.max(0.0f, typedArrayObtainStyledAttributes.getFloat(index, c0141Fl.S));
                    c0141Fl.M = 2;
                    break;
                default:
                    switch (i2) {
                        case 44:
                            C0426Ql.h(c0141Fl, typedArrayObtainStyledAttributes.getString(index));
                            break;
                        case 45:
                            c0141Fl.H = typedArrayObtainStyledAttributes.getFloat(index, c0141Fl.H);
                            break;
                        case 46:
                            c0141Fl.I = typedArrayObtainStyledAttributes.getFloat(index, c0141Fl.I);
                            break;
                        case 47:
                            c0141Fl.J = typedArrayObtainStyledAttributes.getInt(index, 0);
                            break;
                        case 48:
                            c0141Fl.K = typedArrayObtainStyledAttributes.getInt(index, 0);
                            break;
                        case 49:
                            c0141Fl.T = typedArrayObtainStyledAttributes.getDimensionPixelOffset(index, c0141Fl.T);
                            break;
                        case 50:
                            c0141Fl.U = typedArrayObtainStyledAttributes.getDimensionPixelOffset(index, c0141Fl.U);
                            break;
                        case 51:
                            c0141Fl.Y = typedArrayObtainStyledAttributes.getString(index);
                            break;
                        case 52:
                            int resourceId15 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.n);
                            c0141Fl.n = resourceId15;
                            if (resourceId15 == -1) {
                                c0141Fl.n = typedArrayObtainStyledAttributes.getInt(index, -1);
                                break;
                            } else {
                                break;
                            }
                        case 53:
                            int resourceId16 = typedArrayObtainStyledAttributes.getResourceId(index, c0141Fl.f125o);
                            c0141Fl.f125o = resourceId16;
                            if (resourceId16 == -1) {
                                c0141Fl.f125o = typedArrayObtainStyledAttributes.getInt(index, -1);
                                break;
                            } else {
                                break;
                            }
                        case 54:
                            c0141Fl.D = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.D);
                            break;
                        case 55:
                            c0141Fl.C = typedArrayObtainStyledAttributes.getDimensionPixelSize(index, c0141Fl.C);
                            break;
                        default:
                            switch (i2) {
                                case 64:
                                    C0426Ql.g(c0141Fl, typedArrayObtainStyledAttributes, index, 0);
                                    break;
                                case 65:
                                    C0426Ql.g(c0141Fl, typedArrayObtainStyledAttributes, index, 1);
                                    break;
                                case 66:
                                    c0141Fl.Z = typedArrayObtainStyledAttributes.getInt(index, c0141Fl.Z);
                                    break;
                                case 67:
                                    c0141Fl.d = typedArrayObtainStyledAttributes.getBoolean(index, c0141Fl.d);
                                    break;
                            }
                    }
            }
        }
        typedArrayObtainStyledAttributes.recycle();
        c0141Fl.a();
        return c0141Fl;
    }

    public int getMaxHeight() {
        return this.r;
    }

    public int getMaxWidth() {
        return this.q;
    }

    public int getMinHeight() {
        return this.p;
    }

    public int getMinWidth() {
        return this.f10o;
    }

    public int getOptimizationLevel() {
        return this.n.D0;
    }

    public String getSceneString() {
        int id;
        StringBuilder sb = new StringBuilder();
        C0556Vl c0556Vl = this.n;
        if (c0556Vl.j == null) {
            int id2 = getId();
            if (id2 != -1) {
                c0556Vl.j = getContext().getResources().getResourceEntryName(id2);
            } else {
                c0556Vl.j = "parent";
            }
        }
        if (c0556Vl.h0 == null) {
            c0556Vl.h0 = c0556Vl.j;
        }
        ArrayList arrayList = c0556Vl.q0;
        int size = arrayList.size();
        int i = 0;
        while (i < size) {
            Object obj = arrayList.get(i);
            i++;
            C0530Ul c0530Ul = (C0530Ul) obj;
            View view = c0530Ul.f0;
            if (view != null) {
                if (c0530Ul.j == null && (id = view.getId()) != -1) {
                    c0530Ul.j = getContext().getResources().getResourceEntryName(id);
                }
                if (c0530Ul.h0 == null) {
                    c0530Ul.h0 = c0530Ul.j;
                }
            }
        }
        c0556Vl.n(sb);
        return sb.toString();
    }

    public final void i(AttributeSet attributeSet, int i) throws XmlPullParserException, IOException {
        C0556Vl c0556Vl = this.n;
        c0556Vl.f0 = this;
        C0167Gl c0167Gl = this.z;
        c0556Vl.u0 = c0167Gl;
        c0556Vl.s0.h = c0167Gl;
        this.l.put(getId(), this);
        this.u = null;
        if (attributeSet != null) {
            TypedArray typedArrayObtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, RZ.b, i, 0);
            int indexCount = typedArrayObtainStyledAttributes.getIndexCount();
            for (int i2 = 0; i2 < indexCount; i2++) {
                int index = typedArrayObtainStyledAttributes.getIndex(i2);
                if (index == 16) {
                    this.f10o = typedArrayObtainStyledAttributes.getDimensionPixelOffset(index, this.f10o);
                } else if (index == 17) {
                    this.p = typedArrayObtainStyledAttributes.getDimensionPixelOffset(index, this.p);
                } else if (index == 14) {
                    this.q = typedArrayObtainStyledAttributes.getDimensionPixelOffset(index, this.q);
                } else if (index == 15) {
                    this.r = typedArrayObtainStyledAttributes.getDimensionPixelOffset(index, this.r);
                } else if (index == 113) {
                    this.t = typedArrayObtainStyledAttributes.getInt(index, this.t);
                } else if (index == 56) {
                    int resourceId = typedArrayObtainStyledAttributes.getResourceId(index, 0);
                    if (resourceId != 0) {
                        try {
                            j(resourceId);
                        } catch (Resources.NotFoundException unused) {
                            this.v = null;
                        }
                    }
                } else if (index == 34) {
                    int resourceId2 = typedArrayObtainStyledAttributes.getResourceId(index, 0);
                    try {
                        C0426Ql c0426Ql = new C0426Ql();
                        this.u = c0426Ql;
                        c0426Ql.e(getContext(), resourceId2);
                    } catch (Resources.NotFoundException unused2) {
                        this.u = null;
                    }
                    this.w = resourceId2;
                }
            }
            typedArrayObtainStyledAttributes.recycle();
        }
        c0556Vl.D0 = this.t;
        C2991yL.q = c0556Vl.W(512);
    }

    public final void j(int i) throws XmlPullParserException, Resources.NotFoundException, IOException {
        String str;
        Context context = getContext();
        C1390hY c1390hY = new C1390hY(3, false);
        c1390hY.m = new SparseArray();
        c1390hY.n = new SparseArray();
        XmlResourceParser xml = context.getResources().getXml(i);
        try {
            C3111zf c3111zf = null;
            for (int eventType = xml.getEventType(); eventType != 1; eventType = xml.next()) {
                if (eventType == 2) {
                    String name = xml.getName();
                    switch (name.hashCode()) {
                        case -1349929691:
                            if (name.equals("ConstraintSet")) {
                                c1390hY.y(context, xml);
                                break;
                            } else {
                                break;
                            }
                        case 80204913:
                            if (name.equals("State")) {
                                C3111zf c3111zf2 = new C3111zf(context, xml);
                                ((SparseArray) c1390hY.m).put(c3111zf2.m, c3111zf2);
                                c3111zf = c3111zf2;
                                break;
                            } else {
                                break;
                            }
                        case 1382829617:
                            str = "StateSet";
                            name.equals(str);
                            break;
                        case 1657696882:
                            str = "layoutDescription";
                            name.equals(str);
                            break;
                        case 1901439077:
                            if (name.equals("Variant")) {
                                C0193Hl c0193Hl = new C0193Hl(context, xml);
                                if (c3111zf != null) {
                                    ((ArrayList) c3111zf.f826o).add(c0193Hl);
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                    }
                }
            }
        } catch (IOException | XmlPullParserException unused) {
        }
        this.v = c1390hY;
    }

    /* JADX WARN: Removed duplicated region for block: B:160:0x0312  */
    /* JADX WARN: Removed duplicated region for block: B:164:0x0333  */
    /* JADX WARN: Removed duplicated region for block: B:168:0x0352  */
    /* JADX WARN: Removed duplicated region for block: B:176:0x036e  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void k(o.C0556Vl r29, int r30, int r31, int r32) {
        /*
            Method dump skipped, instructions count: 1772
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.constraintlayout.widget.ConstraintLayout.k(o.Vl, int, int, int):void");
    }

    public final void l(C0530Ul c0530Ul, C0141Fl c0141Fl, SparseArray sparseArray, int i, int i2) {
        View view = (View) this.l.get(i);
        C0530Ul c0530Ul2 = (C0530Ul) sparseArray.get(i);
        if (c0530Ul2 == null || view == null || !(view.getLayoutParams() instanceof C0141Fl)) {
            return;
        }
        c0141Fl.c0 = true;
        if (i2 == 6) {
            C0141Fl c0141Fl2 = (C0141Fl) view.getLayoutParams();
            c0141Fl2.c0 = true;
            c0141Fl2.p0.E = true;
        }
        c0530Ul.i(6).b(c0530Ul2.i(i2), c0141Fl.D, c0141Fl.C, true);
        c0530Ul.E = true;
        c0530Ul.i(3).j();
        c0530Ul.i(5).j();
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int childCount = getChildCount();
        boolean zIsInEditMode = isInEditMode();
        for (int i5 = 0; i5 < childCount; i5++) {
            View childAt = getChildAt(i5);
            C0141Fl c0141Fl = (C0141Fl) childAt.getLayoutParams();
            C0530Ul c0530Ul = c0141Fl.p0;
            if (childAt.getVisibility() != 8 || c0141Fl.d0 || c0141Fl.e0 || zIsInEditMode) {
                int iR = c0530Ul.r();
                int iS = c0530Ul.s();
                childAt.layout(iR, iS, c0530Ul.q() + iR, c0530Ul.k() + iS);
            }
        }
        ArrayList arrayList = this.m;
        int size = arrayList.size();
        if (size > 0) {
            for (int i6 = 0; i6 < size; i6++) {
                ((AbstractC0089Dl) arrayList.get(i6)).getClass();
            }
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:111:0x01cf  */
    /* JADX WARN: Removed duplicated region for block: B:164:0x0334  */
    /* JADX WARN: Removed duplicated region for block: B:169:0x034c  */
    /* JADX WARN: Removed duplicated region for block: B:176:0x036a  */
    /* JADX WARN: Removed duplicated region for block: B:181:0x038c  */
    /* JADX WARN: Removed duplicated region for block: B:189:0x03b7  */
    /* JADX WARN: Removed duplicated region for block: B:194:0x03d4  */
    /* JADX WARN: Removed duplicated region for block: B:201:0x03f6  */
    /* JADX WARN: Removed duplicated region for block: B:203:0x0401  */
    /* JADX WARN: Removed duplicated region for block: B:211:0x041f  */
    /* JADX WARN: Removed duplicated region for block: B:214:0x0427  */
    /* JADX WARN: Removed duplicated region for block: B:287:0x054c  */
    /* JADX WARN: Removed duplicated region for block: B:290:0x0552  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public void onMeasure(int r35, int r36) throws android.content.res.Resources.NotFoundException, java.lang.NumberFormatException {
        /*
            Method dump skipped, instructions count: 1559
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.constraintlayout.widget.ConstraintLayout.onMeasure(int, int):void");
    }

    @Override // android.view.ViewGroup
    public final void onViewAdded(View view) {
        super.onViewAdded(view);
        C0530Ul c0530UlE = e(view);
        if ((view instanceof C2509tE) && !(c0530UlE instanceof C2604uE)) {
            C0141Fl c0141Fl = (C0141Fl) view.getLayoutParams();
            C2604uE c2604uE = new C2604uE();
            c0141Fl.p0 = c2604uE;
            c0141Fl.d0 = true;
            c2604uE.S(c0141Fl.V);
        }
        if (view instanceof AbstractC0089Dl) {
            AbstractC0089Dl abstractC0089Dl = (AbstractC0089Dl) view;
            abstractC0089Dl.i();
            ((C0141Fl) view.getLayoutParams()).e0 = true;
            ArrayList arrayList = this.m;
            if (!arrayList.contains(abstractC0089Dl)) {
                arrayList.add(abstractC0089Dl);
            }
        }
        this.l.put(view.getId(), view);
        this.s = true;
    }

    @Override // android.view.ViewGroup
    public void onViewRemoved(View view) {
        super.onViewRemoved(view);
        this.l.remove(view.getId());
        C0530Ul c0530UlE = e(view);
        this.n.q0.remove(c0530UlE);
        c0530UlE.C();
        this.m.remove(view);
        this.s = true;
    }

    @Override // android.view.View, android.view.ViewParent
    public final void requestLayout() {
        this.s = true;
        super.requestLayout();
    }

    public void setConstraintSet(C0426Ql c0426Ql) {
        this.u = c0426Ql;
    }

    @Override // android.view.View
    public void setId(int i) {
        int id = getId();
        SparseArray sparseArray = this.l;
        sparseArray.remove(id);
        super.setId(i);
        sparseArray.put(getId(), this);
    }

    public void setMaxHeight(int i) {
        if (i == this.r) {
            return;
        }
        this.r = i;
        requestLayout();
    }

    public void setMaxWidth(int i) {
        if (i == this.q) {
            return;
        }
        this.q = i;
        requestLayout();
    }

    public void setMinHeight(int i) {
        if (i == this.p) {
            return;
        }
        this.p = i;
        requestLayout();
    }

    public void setMinWidth(int i) {
        if (i == this.f10o) {
            return;
        }
        this.f10o = i;
        requestLayout();
    }

    public void setOnConstraintsChanged(AbstractC0660Zl abstractC0660Zl) {
        C1390hY c1390hY = this.v;
        if (c1390hY != null) {
            c1390hY.getClass();
        }
    }

    public void setOptimizationLevel(int i) {
        this.t = i;
        C0556Vl c0556Vl = this.n;
        c0556Vl.D0 = i;
        C2991yL.q = c0556Vl.W(512);
    }

    @Override // android.view.ViewGroup
    public final boolean shouldDelayChildPressedState() {
        return false;
    }

    public ConstraintLayout(Context context, AttributeSet attributeSet, int i) throws XmlPullParserException, IOException {
        super(context, attributeSet, i);
        this.l = new SparseArray();
        this.m = new ArrayList(4);
        this.n = new C0556Vl();
        this.f10o = 0;
        this.p = 0;
        this.q = Api.BaseClientBuilder.API_PRIORITY_OTHER;
        this.r = Api.BaseClientBuilder.API_PRIORITY_OTHER;
        this.s = true;
        this.t = 257;
        this.u = null;
        this.v = null;
        this.w = -1;
        this.x = new HashMap();
        this.y = new SparseArray();
        this.z = new C0167Gl(this, this);
        i(attributeSet, i);
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        C0141Fl c0141Fl = new C0141Fl(layoutParams);
        c0141Fl.a = -1;
        c0141Fl.b = -1;
        c0141Fl.c = -1.0f;
        c0141Fl.d = true;
        c0141Fl.e = -1;
        c0141Fl.f = -1;
        c0141Fl.g = -1;
        c0141Fl.h = -1;
        c0141Fl.i = -1;
        c0141Fl.j = -1;
        c0141Fl.k = -1;
        c0141Fl.l = -1;
        c0141Fl.m = -1;
        c0141Fl.n = -1;
        c0141Fl.f125o = -1;
        c0141Fl.p = -1;
        c0141Fl.q = 0;
        c0141Fl.r = 0.0f;
        c0141Fl.s = -1;
        c0141Fl.t = -1;
        c0141Fl.u = -1;
        c0141Fl.v = -1;
        c0141Fl.w = Integer.MIN_VALUE;
        c0141Fl.x = Integer.MIN_VALUE;
        c0141Fl.y = Integer.MIN_VALUE;
        c0141Fl.z = Integer.MIN_VALUE;
        c0141Fl.A = Integer.MIN_VALUE;
        c0141Fl.B = Integer.MIN_VALUE;
        c0141Fl.C = Integer.MIN_VALUE;
        c0141Fl.D = 0;
        c0141Fl.E = 0.5f;
        c0141Fl.F = 0.5f;
        c0141Fl.G = null;
        c0141Fl.H = -1.0f;
        c0141Fl.I = -1.0f;
        c0141Fl.J = 0;
        c0141Fl.K = 0;
        c0141Fl.L = 0;
        c0141Fl.M = 0;
        c0141Fl.N = 0;
        c0141Fl.O = 0;
        c0141Fl.P = 0;
        c0141Fl.Q = 0;
        c0141Fl.R = 1.0f;
        c0141Fl.S = 1.0f;
        c0141Fl.T = -1;
        c0141Fl.U = -1;
        c0141Fl.V = -1;
        c0141Fl.W = false;
        c0141Fl.X = false;
        c0141Fl.Y = null;
        c0141Fl.Z = 0;
        c0141Fl.a0 = true;
        c0141Fl.b0 = true;
        c0141Fl.c0 = false;
        c0141Fl.d0 = false;
        c0141Fl.e0 = false;
        c0141Fl.f0 = -1;
        c0141Fl.g0 = -1;
        c0141Fl.h0 = -1;
        c0141Fl.i0 = -1;
        c0141Fl.j0 = Integer.MIN_VALUE;
        c0141Fl.k0 = Integer.MIN_VALUE;
        c0141Fl.l0 = 0.5f;
        c0141Fl.p0 = new C0530Ul();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) layoutParams;
            ((ViewGroup.MarginLayoutParams) c0141Fl).leftMargin = marginLayoutParams.leftMargin;
            ((ViewGroup.MarginLayoutParams) c0141Fl).rightMargin = marginLayoutParams.rightMargin;
            ((ViewGroup.MarginLayoutParams) c0141Fl).topMargin = marginLayoutParams.topMargin;
            ((ViewGroup.MarginLayoutParams) c0141Fl).bottomMargin = marginLayoutParams.bottomMargin;
            c0141Fl.setMarginStart(marginLayoutParams.getMarginStart());
            c0141Fl.setMarginEnd(marginLayoutParams.getMarginEnd());
        }
        if (!(layoutParams instanceof C0141Fl)) {
            return c0141Fl;
        }
        C0141Fl c0141Fl2 = (C0141Fl) layoutParams;
        c0141Fl.a = c0141Fl2.a;
        c0141Fl.b = c0141Fl2.b;
        c0141Fl.c = c0141Fl2.c;
        c0141Fl.d = c0141Fl2.d;
        c0141Fl.e = c0141Fl2.e;
        c0141Fl.f = c0141Fl2.f;
        c0141Fl.g = c0141Fl2.g;
        c0141Fl.h = c0141Fl2.h;
        c0141Fl.i = c0141Fl2.i;
        c0141Fl.j = c0141Fl2.j;
        c0141Fl.k = c0141Fl2.k;
        c0141Fl.l = c0141Fl2.l;
        c0141Fl.m = c0141Fl2.m;
        c0141Fl.n = c0141Fl2.n;
        c0141Fl.f125o = c0141Fl2.f125o;
        c0141Fl.p = c0141Fl2.p;
        c0141Fl.q = c0141Fl2.q;
        c0141Fl.r = c0141Fl2.r;
        c0141Fl.s = c0141Fl2.s;
        c0141Fl.t = c0141Fl2.t;
        c0141Fl.u = c0141Fl2.u;
        c0141Fl.v = c0141Fl2.v;
        c0141Fl.w = c0141Fl2.w;
        c0141Fl.x = c0141Fl2.x;
        c0141Fl.y = c0141Fl2.y;
        c0141Fl.z = c0141Fl2.z;
        c0141Fl.A = c0141Fl2.A;
        c0141Fl.B = c0141Fl2.B;
        c0141Fl.C = c0141Fl2.C;
        c0141Fl.D = c0141Fl2.D;
        c0141Fl.E = c0141Fl2.E;
        c0141Fl.F = c0141Fl2.F;
        c0141Fl.G = c0141Fl2.G;
        c0141Fl.H = c0141Fl2.H;
        c0141Fl.I = c0141Fl2.I;
        c0141Fl.J = c0141Fl2.J;
        c0141Fl.K = c0141Fl2.K;
        c0141Fl.W = c0141Fl2.W;
        c0141Fl.X = c0141Fl2.X;
        c0141Fl.L = c0141Fl2.L;
        c0141Fl.M = c0141Fl2.M;
        c0141Fl.N = c0141Fl2.N;
        c0141Fl.P = c0141Fl2.P;
        c0141Fl.O = c0141Fl2.O;
        c0141Fl.Q = c0141Fl2.Q;
        c0141Fl.R = c0141Fl2.R;
        c0141Fl.S = c0141Fl2.S;
        c0141Fl.T = c0141Fl2.T;
        c0141Fl.U = c0141Fl2.U;
        c0141Fl.V = c0141Fl2.V;
        c0141Fl.a0 = c0141Fl2.a0;
        c0141Fl.b0 = c0141Fl2.b0;
        c0141Fl.c0 = c0141Fl2.c0;
        c0141Fl.d0 = c0141Fl2.d0;
        c0141Fl.f0 = c0141Fl2.f0;
        c0141Fl.g0 = c0141Fl2.g0;
        c0141Fl.h0 = c0141Fl2.h0;
        c0141Fl.i0 = c0141Fl2.i0;
        c0141Fl.j0 = c0141Fl2.j0;
        c0141Fl.k0 = c0141Fl2.k0;
        c0141Fl.l0 = c0141Fl2.l0;
        c0141Fl.Y = c0141Fl2.Y;
        c0141Fl.Z = c0141Fl2.Z;
        c0141Fl.p0 = c0141Fl2.p0;
        return c0141Fl;
    }
}
