package androidx.cardview.widget;

import android.R;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import o.C0688a6;
import o.C2113p30;
import o.DH;
import o.QZ;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class CardView extends FrameLayout {
    public static final int[] q = {R.attr.colorBackground};
    public static final C0688a6 r = new C0688a6(8);
    public boolean l;
    public boolean m;
    public final Rect n;

    /* renamed from: o, reason: collision with root package name */
    public final Rect f7o;
    public final DH p;

    public CardView(Context context, AttributeSet attributeSet) {
        ColorStateList colorStateListValueOf;
        super(context, attributeSet, com.google.android.gms.common.R.attr.cardViewStyle);
        Rect rect = new Rect();
        this.n = rect;
        this.f7o = new Rect();
        DH dh = new DH((Object) this);
        this.p = dh;
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, QZ.a, com.google.android.gms.common.R.attr.cardViewStyle, com.google.android.gms.common.R.style.CardView);
        if (typedArrayObtainStyledAttributes.hasValue(2)) {
            colorStateListValueOf = typedArrayObtainStyledAttributes.getColorStateList(2);
        } else {
            TypedArray typedArrayObtainStyledAttributes2 = getContext().obtainStyledAttributes(q);
            int color = typedArrayObtainStyledAttributes2.getColor(0, 0);
            typedArrayObtainStyledAttributes2.recycle();
            float[] fArr = new float[3];
            Color.colorToHSV(color, fArr);
            colorStateListValueOf = ColorStateList.valueOf(fArr[2] > 0.5f ? getResources().getColor(com.google.android.gms.common.R.color.cardview_light_background) : getResources().getColor(com.google.android.gms.common.R.color.cardview_dark_background));
        }
        float dimension = typedArrayObtainStyledAttributes.getDimension(3, 0.0f);
        float dimension2 = typedArrayObtainStyledAttributes.getDimension(4, 0.0f);
        float dimension3 = typedArrayObtainStyledAttributes.getDimension(5, 0.0f);
        this.l = typedArrayObtainStyledAttributes.getBoolean(7, false);
        this.m = typedArrayObtainStyledAttributes.getBoolean(6, true);
        int dimensionPixelSize = typedArrayObtainStyledAttributes.getDimensionPixelSize(8, 0);
        rect.left = typedArrayObtainStyledAttributes.getDimensionPixelSize(10, dimensionPixelSize);
        rect.top = typedArrayObtainStyledAttributes.getDimensionPixelSize(12, dimensionPixelSize);
        rect.right = typedArrayObtainStyledAttributes.getDimensionPixelSize(11, dimensionPixelSize);
        rect.bottom = typedArrayObtainStyledAttributes.getDimensionPixelSize(9, dimensionPixelSize);
        dimension3 = dimension2 > dimension3 ? dimension2 : dimension3;
        typedArrayObtainStyledAttributes.getDimensionPixelSize(0, 0);
        typedArrayObtainStyledAttributes.getDimensionPixelSize(1, 0);
        typedArrayObtainStyledAttributes.recycle();
        C2113p30 c2113p30 = new C2113p30(colorStateListValueOf, dimension);
        dh.l = c2113p30;
        setBackgroundDrawable(c2113p30);
        setClipToOutline(true);
        setElevation(dimension2);
        r.n(dh, dimension3);
    }

    public ColorStateList getCardBackgroundColor() {
        return ((C2113p30) ((Drawable) this.p.l)).h;
    }

    public float getCardElevation() {
        return ((CardView) this.p.m).getElevation();
    }

    public int getContentPaddingBottom() {
        return this.n.bottom;
    }

    public int getContentPaddingLeft() {
        return this.n.left;
    }

    public int getContentPaddingRight() {
        return this.n.right;
    }

    public int getContentPaddingTop() {
        return this.n.top;
    }

    public float getMaxCardElevation() {
        return ((C2113p30) ((Drawable) this.p.l)).e;
    }

    public boolean getPreventCornerOverlap() {
        return this.m;
    }

    public float getRadius() {
        return ((C2113p30) ((Drawable) this.p.l)).a;
    }

    public boolean getUseCompatPadding() {
        return this.l;
    }

    @Override // android.widget.FrameLayout, android.view.View
    public final void onMeasure(int i, int i2) {
        super.onMeasure(i, i2);
    }

    public void setCardBackgroundColor(int i) {
        ColorStateList colorStateListValueOf = ColorStateList.valueOf(i);
        C2113p30 c2113p30 = (C2113p30) ((Drawable) this.p.l);
        if (colorStateListValueOf == null) {
            c2113p30.getClass();
            colorStateListValueOf = ColorStateList.valueOf(0);
        }
        c2113p30.h = colorStateListValueOf;
        c2113p30.b.setColor(colorStateListValueOf.getColorForState(c2113p30.getState(), c2113p30.h.getDefaultColor()));
        c2113p30.invalidateSelf();
    }

    public void setCardElevation(float f) {
        ((CardView) this.p.m).setElevation(f);
    }

    public void setMaxCardElevation(float f) {
        r.n(this.p, f);
    }

    @Override // android.view.View
    public void setMinimumHeight(int i) {
        super.setMinimumHeight(i);
    }

    @Override // android.view.View
    public void setMinimumWidth(int i) {
        super.setMinimumWidth(i);
    }

    public void setPreventCornerOverlap(boolean z) {
        if (z != this.m) {
            this.m = z;
            DH dh = this.p;
            r.n(dh, ((C2113p30) ((Drawable) dh.l)).e);
        }
    }

    public void setRadius(float f) {
        C2113p30 c2113p30 = (C2113p30) ((Drawable) this.p.l);
        if (f == c2113p30.a) {
            return;
        }
        c2113p30.a = f;
        c2113p30.b(null);
        c2113p30.invalidateSelf();
    }

    public void setUseCompatPadding(boolean z) {
        if (this.l != z) {
            this.l = z;
            DH dh = this.p;
            r.n(dh, ((C2113p30) ((Drawable) dh.l)).e);
        }
    }

    public void setCardBackgroundColor(ColorStateList colorStateList) {
        C2113p30 c2113p30 = (C2113p30) ((Drawable) this.p.l);
        if (colorStateList == null) {
            c2113p30.getClass();
            colorStateList = ColorStateList.valueOf(0);
        }
        c2113p30.h = colorStateList;
        c2113p30.b.setColor(colorStateList.getColorForState(c2113p30.getState(), c2113p30.h.getDefaultColor()));
        c2113p30.invalidateSelf();
    }

    @Override // android.view.View
    public final void setPadding(int i, int i2, int i3, int i4) {
    }

    @Override // android.view.View
    public final void setPaddingRelative(int i, int i2, int i3, int i4) {
    }
}
