package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import com.google.android.gms.common.R;
import java.util.ArrayList;
import java.util.Iterator;
import o.AbstractC0249Jp;
import o.AbstractC2457sk0;
import o.C0698aC;
import o.C0788b8;
import o.C1444i1;
import o.C2160pe;
import o.C30;
import o.C70;
import o.C80;
import o.CO;
import o.Db0;
import o.E8;
import o.FO;
import o.IO;
import o.InterfaceC0378Op;
import o.InterfaceC1189fP;
import o.LO;
import o.Lf0;
import o.Mf0;
import o.Nf0;
import o.Of0;
import o.Oj0;
import o.Pf0;
import o.Qf0;
import o.Rf0;
import o.RunnableC2017o3;
import o.Sf0;
import o.V0;
import o.Vf0;
import o.YZ;
import o.Z7;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class Toolbar extends ViewGroup implements FO {
    public int A;
    public int B;
    public int C;
    public int D;
    public C30 E;
    public int F;
    public int G;
    public final int H;
    public CharSequence I;
    public CharSequence J;
    public ColorStateList K;
    public ColorStateList L;
    public boolean M;
    public boolean N;
    public final ArrayList O;
    public final ArrayList P;
    public final int[] Q;
    public final IO R;
    public ArrayList S;
    public Qf0 T;
    public final Mf0 U;
    public Vf0 V;
    public C1444i1 W;
    public Of0 a0;
    public C2160pe b0;
    public Sf0 c0;
    public boolean d0;
    public OnBackInvokedCallback e0;
    public OnBackInvokedDispatcher f0;
    public boolean g0;
    public final RunnableC2017o3 h0;
    public ActionMenuView l;
    public E8 m;
    public E8 n;

    /* renamed from: o, reason: collision with root package name */
    public Z7 f5o;
    public C0788b8 p;
    public final Drawable q;
    public final CharSequence r;
    public Z7 s;
    public View t;
    public Context u;
    public int v;
    public int w;
    public int x;
    public final int y;
    public final int z;

    public Toolbar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    private ArrayList<MenuItem> getCurrentMenuItems() {
        ArrayList<MenuItem> arrayList = new ArrayList<>();
        Menu menu = getMenu();
        for (int i = 0; i < menu.size(); i++) {
            arrayList.add(menu.getItem(i));
        }
        return arrayList;
    }

    private MenuInflater getMenuInflater() {
        return new Db0(getContext());
    }

    public static Pf0 h() {
        Pf0 pf0 = new Pf0(-2, -2);
        pf0.b = 0;
        pf0.a = 8388627;
        return pf0;
    }

    public static Pf0 i(ViewGroup.LayoutParams layoutParams) {
        boolean z = layoutParams instanceof Pf0;
        if (z) {
            Pf0 pf0 = (Pf0) layoutParams;
            Pf0 pf02 = new Pf0(pf0);
            pf02.b = 0;
            pf02.b = pf0.b;
            return pf02;
        }
        if (z) {
            Pf0 pf03 = new Pf0((Pf0) layoutParams);
            pf03.b = 0;
            return pf03;
        }
        if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) {
            Pf0 pf04 = new Pf0(layoutParams);
            pf04.b = 0;
            return pf04;
        }
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) layoutParams;
        Pf0 pf05 = new Pf0(marginLayoutParams);
        pf05.b = 0;
        ((ViewGroup.MarginLayoutParams) pf05).leftMargin = marginLayoutParams.leftMargin;
        ((ViewGroup.MarginLayoutParams) pf05).topMargin = marginLayoutParams.topMargin;
        ((ViewGroup.MarginLayoutParams) pf05).rightMargin = marginLayoutParams.rightMargin;
        ((ViewGroup.MarginLayoutParams) pf05).bottomMargin = marginLayoutParams.bottomMargin;
        return pf05;
    }

    public static int k(View view) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        return marginLayoutParams.getMarginEnd() + marginLayoutParams.getMarginStart();
    }

    public static int l(View view) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        return marginLayoutParams.topMargin + marginLayoutParams.bottomMargin;
    }

    public final void a(int i, ArrayList arrayList) {
        boolean z = getLayoutDirection() == 1;
        int childCount = getChildCount();
        int absoluteGravity = Gravity.getAbsoluteGravity(i, getLayoutDirection());
        arrayList.clear();
        if (!z) {
            for (int i2 = 0; i2 < childCount; i2++) {
                View childAt = getChildAt(i2);
                Pf0 pf0 = (Pf0) childAt.getLayoutParams();
                if (pf0.b == 0 && u(childAt)) {
                    int i3 = pf0.a;
                    int layoutDirection = getLayoutDirection();
                    int absoluteGravity2 = Gravity.getAbsoluteGravity(i3, layoutDirection) & 7;
                    if (absoluteGravity2 != 1 && absoluteGravity2 != 3 && absoluteGravity2 != 5) {
                        absoluteGravity2 = layoutDirection == 1 ? 5 : 3;
                    }
                    if (absoluteGravity2 == absoluteGravity) {
                        arrayList.add(childAt);
                    }
                }
            }
            return;
        }
        for (int i4 = childCount - 1; i4 >= 0; i4--) {
            View childAt2 = getChildAt(i4);
            Pf0 pf02 = (Pf0) childAt2.getLayoutParams();
            if (pf02.b == 0 && u(childAt2)) {
                int i5 = pf02.a;
                int layoutDirection2 = getLayoutDirection();
                int absoluteGravity3 = Gravity.getAbsoluteGravity(i5, layoutDirection2) & 7;
                if (absoluteGravity3 != 1 && absoluteGravity3 != 3 && absoluteGravity3 != 5) {
                    absoluteGravity3 = layoutDirection2 == 1 ? 5 : 3;
                }
                if (absoluteGravity3 == absoluteGravity) {
                    arrayList.add(childAt2);
                }
            }
        }
    }

    @Override // o.FO
    public final void addMenuProvider(InterfaceC1189fP interfaceC1189fP) {
        IO io = this.R;
        io.b.add(interfaceC1189fP);
        io.a.run();
    }

    public final void b(View view, boolean z) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        Pf0 pf0H = layoutParams == null ? h() : !checkLayoutParams(layoutParams) ? i(layoutParams) : (Pf0) layoutParams;
        pf0H.b = 1;
        if (!z || this.t == null) {
            addView(view, pf0H);
        } else {
            view.setLayoutParams(pf0H);
            this.P.add(view);
        }
    }

    public final void c() {
        if (this.s == null) {
            Z7 z7 = new Z7(getContext(), null, R.attr.toolbarNavigationButtonStyle);
            this.s = z7;
            z7.setImageDrawable(this.q);
            this.s.setContentDescription(this.r);
            Pf0 pf0H = h();
            pf0H.a = (this.y & 112) | 8388611;
            pf0H.b = 2;
            this.s.setLayoutParams(pf0H);
            this.s.setOnClickListener(new V0(3, this));
        }
    }

    @Override // android.view.ViewGroup
    public final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return super.checkLayoutParams(layoutParams) && (layoutParams instanceof Pf0);
    }

    public final void d() {
        if (this.E == null) {
            C30 c30 = new C30();
            c30.a = 0;
            c30.b = 0;
            c30.c = Integer.MIN_VALUE;
            c30.d = Integer.MIN_VALUE;
            c30.e = 0;
            c30.f = 0;
            c30.g = false;
            c30.h = false;
            this.E = c30;
        }
    }

    public final void e() {
        f();
        ActionMenuView actionMenuView = this.l;
        if (actionMenuView.A == null) {
            CO co = (CO) actionMenuView.getMenu();
            if (this.a0 == null) {
                this.a0 = new Of0(this);
            }
            this.l.setExpandedActionViewsExclusive(true);
            co.b(this.a0, this.u);
            w();
        }
    }

    public final void f() {
        if (this.l == null) {
            ActionMenuView actionMenuView = new ActionMenuView(getContext(), null);
            this.l = actionMenuView;
            actionMenuView.setPopupTheme(this.v);
            this.l.setOnMenuItemClickListener(this.U);
            ActionMenuView actionMenuView2 = this.l;
            C2160pe c2160pe = this.b0;
            Mf0 mf0 = new Mf0(this);
            actionMenuView2.F = c2160pe;
            actionMenuView2.G = mf0;
            Pf0 pf0H = h();
            pf0H.a = (this.y & 112) | 8388613;
            this.l.setLayoutParams(pf0H);
            b(this.l, false);
        }
    }

    public final void g() {
        if (this.f5o == null) {
            this.f5o = new Z7(getContext(), null, R.attr.toolbarNavigationButtonStyle);
            Pf0 pf0H = h();
            pf0H.a = (this.y & 112) | 8388611;
            this.f5o.setLayoutParams(pf0H);
        }
    }

    @Override // android.view.ViewGroup
    public final /* bridge */ /* synthetic */ ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return h();
    }

    @Override // android.view.ViewGroup
    public final /* bridge */ /* synthetic */ ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return i(layoutParams);
    }

    public CharSequence getCollapseContentDescription() {
        Z7 z7 = this.s;
        if (z7 != null) {
            return z7.getContentDescription();
        }
        return null;
    }

    public Drawable getCollapseIcon() {
        Z7 z7 = this.s;
        if (z7 != null) {
            return z7.getDrawable();
        }
        return null;
    }

    public int getContentInsetEnd() {
        C30 c30 = this.E;
        if (c30 != null) {
            return c30.g ? c30.a : c30.b;
        }
        return 0;
    }

    public int getContentInsetEndWithActions() {
        int i = this.G;
        return i != Integer.MIN_VALUE ? i : getContentInsetEnd();
    }

    public int getContentInsetLeft() {
        C30 c30 = this.E;
        if (c30 != null) {
            return c30.a;
        }
        return 0;
    }

    public int getContentInsetRight() {
        C30 c30 = this.E;
        if (c30 != null) {
            return c30.b;
        }
        return 0;
    }

    public int getContentInsetStart() {
        C30 c30 = this.E;
        if (c30 != null) {
            return c30.g ? c30.b : c30.a;
        }
        return 0;
    }

    public int getContentInsetStartWithNavigation() {
        int i = this.F;
        return i != Integer.MIN_VALUE ? i : getContentInsetStart();
    }

    public int getCurrentContentInsetEnd() {
        CO co;
        ActionMenuView actionMenuView = this.l;
        return (actionMenuView == null || (co = actionMenuView.A) == null || !co.hasVisibleItems()) ? getContentInsetEnd() : Math.max(getContentInsetEnd(), Math.max(this.G, 0));
    }

    public int getCurrentContentInsetLeft() {
        return getLayoutDirection() == 1 ? getCurrentContentInsetEnd() : getCurrentContentInsetStart();
    }

    public int getCurrentContentInsetRight() {
        return getLayoutDirection() == 1 ? getCurrentContentInsetStart() : getCurrentContentInsetEnd();
    }

    public int getCurrentContentInsetStart() {
        return getNavigationIcon() != null ? Math.max(getContentInsetStart(), Math.max(this.F, 0)) : getContentInsetStart();
    }

    public Drawable getLogo() {
        C0788b8 c0788b8 = this.p;
        if (c0788b8 != null) {
            return c0788b8.getDrawable();
        }
        return null;
    }

    public CharSequence getLogoDescription() {
        C0788b8 c0788b8 = this.p;
        if (c0788b8 != null) {
            return c0788b8.getContentDescription();
        }
        return null;
    }

    public Menu getMenu() {
        e();
        return this.l.getMenu();
    }

    public View getNavButtonView() {
        return this.f5o;
    }

    public CharSequence getNavigationContentDescription() {
        Z7 z7 = this.f5o;
        if (z7 != null) {
            return z7.getContentDescription();
        }
        return null;
    }

    public Drawable getNavigationIcon() {
        Z7 z7 = this.f5o;
        if (z7 != null) {
            return z7.getDrawable();
        }
        return null;
    }

    public C1444i1 getOuterActionMenuPresenter() {
        return this.W;
    }

    public Drawable getOverflowIcon() {
        e();
        return this.l.getOverflowIcon();
    }

    public Context getPopupContext() {
        return this.u;
    }

    public int getPopupTheme() {
        return this.v;
    }

    public CharSequence getSubtitle() {
        return this.J;
    }

    public final TextView getSubtitleTextView() {
        return this.n;
    }

    public CharSequence getTitle() {
        return this.I;
    }

    public int getTitleMarginBottom() {
        return this.D;
    }

    public int getTitleMarginEnd() {
        return this.B;
    }

    public int getTitleMarginStart() {
        return this.A;
    }

    public int getTitleMarginTop() {
        return this.C;
    }

    public final TextView getTitleTextView() {
        return this.m;
    }

    public InterfaceC0378Op getWrapper() {
        if (this.V == null) {
            this.V = new Vf0(this, true);
        }
        return this.V;
    }

    public final int j(View view, int i) {
        Pf0 pf0 = (Pf0) view.getLayoutParams();
        int measuredHeight = view.getMeasuredHeight();
        int i2 = i > 0 ? (measuredHeight - i) / 2 : 0;
        int i3 = pf0.a & 112;
        if (i3 != 16 && i3 != 48 && i3 != 80) {
            i3 = this.H & 112;
        }
        if (i3 == 48) {
            return getPaddingTop() - i2;
        }
        if (i3 == 80) {
            return (((getHeight() - getPaddingBottom()) - measuredHeight) - ((ViewGroup.MarginLayoutParams) pf0).bottomMargin) - i2;
        }
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        int height = getHeight();
        int iMax = (((height - paddingTop) - paddingBottom) - measuredHeight) / 2;
        int i4 = ((ViewGroup.MarginLayoutParams) pf0).topMargin;
        if (iMax < i4) {
            iMax = i4;
        } else {
            int i5 = (((height - paddingBottom) - measuredHeight) - iMax) - paddingTop;
            int i6 = ((ViewGroup.MarginLayoutParams) pf0).bottomMargin;
            if (i5 < i6) {
                iMax = Math.max(0, iMax - (i6 - i5));
            }
        }
        return paddingTop + iMax;
    }

    public void m(int i) {
        getMenuInflater().inflate(i, getMenu());
    }

    public final void n() {
        ArrayList arrayList = this.S;
        int size = arrayList.size();
        int i = 0;
        while (i < size) {
            Object obj = arrayList.get(i);
            i++;
            getMenu().removeItem(((MenuItem) obj).getItemId());
        }
        Menu menu = getMenu();
        ArrayList<MenuItem> currentMenuItems = getCurrentMenuItems();
        MenuInflater menuInflater = getMenuInflater();
        Iterator it = this.R.b.iterator();
        while (it.hasNext()) {
            ((C0698aC) ((InterfaceC1189fP) it.next())).a.j(menu, menuInflater);
        }
        ArrayList<MenuItem> currentMenuItems2 = getCurrentMenuItems();
        currentMenuItems2.removeAll(currentMenuItems);
        this.S = currentMenuItems2;
    }

    public final boolean o(View view) {
        return view.getParent() == this || this.P.contains(view);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        w();
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        removeCallbacks(this.h0);
        w();
    }

    @Override // android.view.View
    public final boolean onHoverEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 9) {
            this.N = false;
        }
        if (!this.N) {
            boolean zOnHoverEvent = super.onHoverEvent(motionEvent);
            if (actionMasked == 9 && !zOnHoverEvent) {
                this.N = true;
            }
        }
        if (actionMasked != 10 && actionMasked != 3) {
            return true;
        }
        this.N = false;
        return true;
    }

    /* JADX WARN: Removed duplicated region for block: B:103:0x028f A[LOOP:0: B:102:0x028d->B:103:0x028f, LOOP_END] */
    /* JADX WARN: Removed duplicated region for block: B:106:0x02a7 A[LOOP:1: B:105:0x02a5->B:106:0x02a7, LOOP_END] */
    /* JADX WARN: Removed duplicated region for block: B:109:0x02c7 A[LOOP:2: B:108:0x02c5->B:109:0x02c7, LOOP_END] */
    /* JADX WARN: Removed duplicated region for block: B:113:0x030d  */
    /* JADX WARN: Removed duplicated region for block: B:118:0x031a A[LOOP:3: B:117:0x0318->B:118:0x031a, LOOP_END] */
    /* JADX WARN: Removed duplicated region for block: B:19:0x0062  */
    /* JADX WARN: Removed duplicated region for block: B:24:0x0079  */
    /* JADX WARN: Removed duplicated region for block: B:29:0x00b6  */
    /* JADX WARN: Removed duplicated region for block: B:34:0x00cd  */
    /* JADX WARN: Removed duplicated region for block: B:39:0x00ea  */
    /* JADX WARN: Removed duplicated region for block: B:40:0x0101  */
    /* JADX WARN: Removed duplicated region for block: B:42:0x0106  */
    /* JADX WARN: Removed duplicated region for block: B:43:0x011f  */
    /* JADX WARN: Removed duplicated region for block: B:46:0x0125  */
    /* JADX WARN: Removed duplicated region for block: B:47:0x0127  */
    /* JADX WARN: Removed duplicated region for block: B:48:0x012a  */
    /* JADX WARN: Removed duplicated region for block: B:50:0x012e  */
    /* JADX WARN: Removed duplicated region for block: B:51:0x0131  */
    /* JADX WARN: Removed duplicated region for block: B:63:0x0164  */
    /* JADX WARN: Removed duplicated region for block: B:73:0x019d  */
    /* JADX WARN: Removed duplicated region for block: B:75:0x01aa  */
    /* JADX WARN: Removed duplicated region for block: B:88:0x0218  */
    @Override // android.view.ViewGroup, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public void onLayout(boolean r20, int r21, int r22, int r23, int r24) {
        /*
            Method dump skipped, instructions count: 811
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.appcompat.widget.Toolbar.onLayout(boolean, int, int, int, int):void");
    }

    /* JADX WARN: Multi-variable type inference failed */
    @Override // android.view.View
    public final void onMeasure(int i, int i2) {
        char c;
        Object[] objArr;
        int iK;
        int iMax;
        int iCombineMeasuredStates;
        int iK2;
        int iL;
        int iCombineMeasuredStates2;
        int iMax2;
        boolean z = AbstractC2457sk0.a;
        int i3 = 0;
        if (getLayoutDirection() == 1) {
            objArr = true;
            c = 0;
        } else {
            c = 1;
            objArr = false;
        }
        if (u(this.f5o)) {
            t(this.f5o, i, 0, i2, this.z);
            iK = k(this.f5o) + this.f5o.getMeasuredWidth();
            iMax = Math.max(0, l(this.f5o) + this.f5o.getMeasuredHeight());
            iCombineMeasuredStates = View.combineMeasuredStates(0, this.f5o.getMeasuredState());
        } else {
            iK = 0;
            iMax = 0;
            iCombineMeasuredStates = 0;
        }
        if (u(this.s)) {
            t(this.s, i, 0, i2, this.z);
            iK = k(this.s) + this.s.getMeasuredWidth();
            iMax = Math.max(iMax, l(this.s) + this.s.getMeasuredHeight());
            iCombineMeasuredStates = View.combineMeasuredStates(iCombineMeasuredStates, this.s.getMeasuredState());
        }
        int currentContentInsetStart = getCurrentContentInsetStart();
        int iMax3 = Math.max(currentContentInsetStart, iK);
        int iMax4 = Math.max(0, currentContentInsetStart - iK);
        Object[] objArr2 = objArr;
        int[] iArr = this.Q;
        iArr[objArr2 == true ? 1 : 0] = iMax4;
        if (u(this.l)) {
            t(this.l, i, iMax3, i2, this.z);
            iK2 = k(this.l) + this.l.getMeasuredWidth();
            iMax = Math.max(iMax, l(this.l) + this.l.getMeasuredHeight());
            iCombineMeasuredStates = View.combineMeasuredStates(iCombineMeasuredStates, this.l.getMeasuredState());
        } else {
            iK2 = 0;
        }
        int currentContentInsetEnd = getCurrentContentInsetEnd();
        int iMax5 = iMax3 + Math.max(currentContentInsetEnd, iK2);
        iArr[c] = Math.max(0, currentContentInsetEnd - iK2);
        if (u(this.t)) {
            iMax5 += s(this.t, i, iMax5, i2, 0, iArr);
            iMax = Math.max(iMax, l(this.t) + this.t.getMeasuredHeight());
            iCombineMeasuredStates = View.combineMeasuredStates(iCombineMeasuredStates, this.t.getMeasuredState());
        }
        if (u(this.p)) {
            iMax5 += s(this.p, i, iMax5, i2, 0, iArr);
            iMax = Math.max(iMax, l(this.p) + this.p.getMeasuredHeight());
            iCombineMeasuredStates = View.combineMeasuredStates(iCombineMeasuredStates, this.p.getMeasuredState());
        }
        int childCount = getChildCount();
        for (int i4 = 0; i4 < childCount; i4++) {
            View childAt = getChildAt(i4);
            if (((Pf0) childAt.getLayoutParams()).b == 0 && u(childAt)) {
                iMax5 += s(childAt, i, iMax5, i2, 0, iArr);
                int iMax6 = Math.max(iMax, l(childAt) + childAt.getMeasuredHeight());
                iCombineMeasuredStates = View.combineMeasuredStates(iCombineMeasuredStates, childAt.getMeasuredState());
                iMax = iMax6;
            } else {
                iMax5 = iMax5;
            }
        }
        int i5 = iMax5;
        int i6 = this.C + this.D;
        int i7 = this.A + this.B;
        if (u(this.m)) {
            s(this.m, i, i5 + i7, i2, i6, iArr);
            int iK3 = k(this.m) + this.m.getMeasuredWidth();
            iL = l(this.m) + this.m.getMeasuredHeight();
            iCombineMeasuredStates2 = View.combineMeasuredStates(iCombineMeasuredStates, this.m.getMeasuredState());
            iMax2 = iK3;
        } else {
            iL = 0;
            iCombineMeasuredStates2 = iCombineMeasuredStates;
            iMax2 = 0;
        }
        if (u(this.n)) {
            iMax2 = Math.max(iMax2, s(this.n, i, i5 + i7, i2, i6 + iL, iArr));
            iL += l(this.n) + this.n.getMeasuredHeight();
            iCombineMeasuredStates2 = View.combineMeasuredStates(iCombineMeasuredStates2, this.n.getMeasuredState());
        }
        int iMax7 = Math.max(iMax, iL);
        int paddingRight = getPaddingRight() + getPaddingLeft() + i5 + iMax2;
        int paddingBottom = getPaddingBottom() + getPaddingTop() + iMax7;
        int iResolveSizeAndState = View.resolveSizeAndState(Math.max(paddingRight, getSuggestedMinimumWidth()), i, (-16777216) & iCombineMeasuredStates2);
        int iResolveSizeAndState2 = View.resolveSizeAndState(Math.max(paddingBottom, getSuggestedMinimumHeight()), i2, iCombineMeasuredStates2 << 16);
        if (!this.d0) {
            i3 = iResolveSizeAndState2;
            break;
        }
        int childCount2 = getChildCount();
        for (int i8 = 0; i8 < childCount2; i8++) {
            View childAt2 = getChildAt(i8);
            if (u(childAt2) && childAt2.getMeasuredWidth() > 0 && childAt2.getMeasuredHeight() > 0) {
                i3 = iResolveSizeAndState2;
                break;
            }
        }
        setMeasuredDimension(iResolveSizeAndState, i3);
    }

    @Override // android.view.View
    public final void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem menuItemFindItem;
        if (!(parcelable instanceof Rf0)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        Rf0 rf0 = (Rf0) parcelable;
        super.onRestoreInstanceState(rf0.l);
        ActionMenuView actionMenuView = this.l;
        CO co = actionMenuView != null ? actionMenuView.A : null;
        int i = rf0.n;
        if (i != 0 && this.a0 != null && co != null && (menuItemFindItem = co.findItem(i)) != null) {
            menuItemFindItem.expandActionView();
        }
        if (rf0.f316o) {
            RunnableC2017o3 runnableC2017o3 = this.h0;
            removeCallbacks(runnableC2017o3);
            post(runnableC2017o3);
        }
    }

    @Override // android.view.View
    public final void onRtlPropertiesChanged(int i) {
        super.onRtlPropertiesChanged(i);
        d();
        C30 c30 = this.E;
        boolean z = i == 1;
        if (z == c30.g) {
            return;
        }
        c30.g = z;
        if (!c30.h) {
            c30.a = c30.e;
            c30.b = c30.f;
            return;
        }
        if (z) {
            int i2 = c30.d;
            if (i2 == Integer.MIN_VALUE) {
                i2 = c30.e;
            }
            c30.a = i2;
            int i3 = c30.c;
            if (i3 == Integer.MIN_VALUE) {
                i3 = c30.f;
            }
            c30.b = i3;
            return;
        }
        int i4 = c30.c;
        if (i4 == Integer.MIN_VALUE) {
            i4 = c30.e;
        }
        c30.a = i4;
        int i5 = c30.d;
        if (i5 == Integer.MIN_VALUE) {
            i5 = c30.f;
        }
        c30.b = i5;
    }

    @Override // android.view.View
    public final Parcelable onSaveInstanceState() {
        LO lo;
        Rf0 rf0 = new Rf0(super.onSaveInstanceState());
        Of0 of0 = this.a0;
        if (of0 != null && (lo = of0.m) != null) {
            rf0.n = lo.a;
        }
        rf0.f316o = p();
        return rf0;
    }

    @Override // android.view.View
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.M = false;
        }
        if (!this.M) {
            boolean zOnTouchEvent = super.onTouchEvent(motionEvent);
            if (actionMasked == 0 && !zOnTouchEvent) {
                this.M = true;
            }
        }
        if (actionMasked != 1 && actionMasked != 3) {
            return true;
        }
        this.M = false;
        return true;
    }

    public final boolean p() {
        C1444i1 c1444i1;
        ActionMenuView actionMenuView = this.l;
        return (actionMenuView == null || (c1444i1 = actionMenuView.E) == null || !c1444i1.h()) ? false : true;
    }

    public final int q(View view, int i, int i2, int[] iArr) {
        Pf0 pf0 = (Pf0) view.getLayoutParams();
        int i3 = ((ViewGroup.MarginLayoutParams) pf0).leftMargin - iArr[0];
        int iMax = Math.max(0, i3) + i;
        iArr[0] = Math.max(0, -i3);
        int iJ = j(view, i2);
        int measuredWidth = view.getMeasuredWidth();
        view.layout(iMax, iJ, iMax + measuredWidth, view.getMeasuredHeight() + iJ);
        return measuredWidth + ((ViewGroup.MarginLayoutParams) pf0).rightMargin + iMax;
    }

    public final int r(View view, int i, int i2, int[] iArr) {
        Pf0 pf0 = (Pf0) view.getLayoutParams();
        int i3 = ((ViewGroup.MarginLayoutParams) pf0).rightMargin - iArr[1];
        int iMax = i - Math.max(0, i3);
        iArr[1] = Math.max(0, -i3);
        int iJ = j(view, i2);
        int measuredWidth = view.getMeasuredWidth();
        view.layout(iMax - measuredWidth, iJ, iMax, view.getMeasuredHeight() + iJ);
        return iMax - (measuredWidth + ((ViewGroup.MarginLayoutParams) pf0).leftMargin);
    }

    @Override // o.FO
    public final void removeMenuProvider(InterfaceC1189fP interfaceC1189fP) {
        this.R.b(interfaceC1189fP);
    }

    public final int s(View view, int i, int i2, int i3, int i4, int[] iArr) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        int i5 = marginLayoutParams.leftMargin - iArr[0];
        int i6 = marginLayoutParams.rightMargin - iArr[1];
        int iMax = Math.max(0, i6) + Math.max(0, i5);
        iArr[0] = Math.max(0, -i5);
        iArr[1] = Math.max(0, -i6);
        view.measure(ViewGroup.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft() + iMax + i2, marginLayoutParams.width), ViewGroup.getChildMeasureSpec(i3, getPaddingBottom() + getPaddingTop() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin + i4, marginLayoutParams.height));
        return view.getMeasuredWidth() + iMax;
    }

    public void setBackInvokedCallbackEnabled(boolean z) {
        if (this.g0 != z) {
            this.g0 = z;
            w();
        }
    }

    public void setCollapseContentDescription(int i) {
        setCollapseContentDescription(i != 0 ? getContext().getText(i) : null);
    }

    public void setCollapseIcon(int i) {
        setCollapseIcon(C80.x(getContext(), i));
    }

    public void setCollapsible(boolean z) {
        this.d0 = z;
        requestLayout();
    }

    public void setContentInsetEndWithActions(int i) {
        if (i < 0) {
            i = Integer.MIN_VALUE;
        }
        if (i != this.G) {
            this.G = i;
            if (getNavigationIcon() != null) {
                requestLayout();
            }
        }
    }

    public void setContentInsetStartWithNavigation(int i) {
        if (i < 0) {
            i = Integer.MIN_VALUE;
        }
        if (i != this.F) {
            this.F = i;
            if (getNavigationIcon() != null) {
                requestLayout();
            }
        }
    }

    public void setLogo(int i) {
        setLogo(C80.x(getContext(), i));
    }

    public void setLogoDescription(int i) {
        setLogoDescription(getContext().getText(i));
    }

    public void setNavigationContentDescription(int i) {
        setNavigationContentDescription(i != 0 ? getContext().getText(i) : null);
    }

    public void setNavigationIcon(int i) {
        setNavigationIcon(C80.x(getContext(), i));
    }

    public void setNavigationOnClickListener(View.OnClickListener onClickListener) {
        g();
        this.f5o.setOnClickListener(onClickListener);
    }

    public void setOnMenuItemClickListener(Qf0 qf0) {
        this.T = qf0;
    }

    public void setOverflowIcon(Drawable drawable) {
        e();
        this.l.setOverflowIcon(drawable);
    }

    public void setPopupTheme(int i) {
        if (this.v != i) {
            this.v = i;
            if (i == 0) {
                this.u = getContext();
            } else {
                this.u = new ContextThemeWrapper(getContext(), i);
            }
        }
    }

    public void setSubtitle(int i) {
        setSubtitle(getContext().getText(i));
    }

    public void setSubtitleTextColor(int i) {
        setSubtitleTextColor(ColorStateList.valueOf(i));
    }

    public void setTitle(int i) {
        setTitle(getContext().getText(i));
    }

    public void setTitleMarginBottom(int i) {
        this.D = i;
        requestLayout();
    }

    public void setTitleMarginEnd(int i) {
        this.B = i;
        requestLayout();
    }

    public void setTitleMarginStart(int i) {
        this.A = i;
        requestLayout();
    }

    public void setTitleMarginTop(int i) {
        this.C = i;
        requestLayout();
    }

    public void setTitleTextColor(int i) {
        setTitleTextColor(ColorStateList.valueOf(i));
    }

    public final void t(View view, int i, int i2, int i3, int i4) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        int childMeasureSpec = ViewGroup.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + i2, marginLayoutParams.width);
        int childMeasureSpec2 = ViewGroup.getChildMeasureSpec(i3, getPaddingBottom() + getPaddingTop() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin, marginLayoutParams.height);
        int mode = View.MeasureSpec.getMode(childMeasureSpec2);
        if (mode != 1073741824 && i4 >= 0) {
            if (mode != 0) {
                i4 = Math.min(View.MeasureSpec.getSize(childMeasureSpec2), i4);
            }
            childMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(i4, 1073741824);
        }
        view.measure(childMeasureSpec, childMeasureSpec2);
    }

    public final boolean u(View view) {
        return (view == null || view.getParent() != this || view.getVisibility() == 8) ? false : true;
    }

    public final boolean v() {
        C1444i1 c1444i1;
        ActionMenuView actionMenuView = this.l;
        return (actionMenuView == null || (c1444i1 = actionMenuView.E) == null || !c1444i1.l()) ? false : true;
    }

    public final void w() {
        OnBackInvokedDispatcher onBackInvokedDispatcher;
        if (Build.VERSION.SDK_INT >= 33) {
            OnBackInvokedDispatcher onBackInvokedDispatcherA = Nf0.a(this);
            Of0 of0 = this.a0;
            boolean z = (of0 == null || of0.m == null || onBackInvokedDispatcherA == null || !isAttachedToWindow() || !this.g0) ? false : true;
            if (z && this.f0 == null) {
                if (this.e0 == null) {
                    this.e0 = Nf0.b(new Lf0(this, 0));
                }
                Nf0.c(onBackInvokedDispatcherA, this.e0);
                this.f0 = onBackInvokedDispatcherA;
                return;
            }
            if (z || (onBackInvokedDispatcher = this.f0) == null) {
                return;
            }
            Nf0.d(onBackInvokedDispatcher, this.e0);
            this.f0 = null;
        }
    }

    public Toolbar(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, R.attr.toolbarStyle);
        this.H = 8388627;
        this.O = new ArrayList();
        this.P = new ArrayList();
        this.Q = new int[2];
        this.R = new IO(new Lf0(this, 1));
        this.S = new ArrayList();
        this.U = new Mf0(this);
        this.h0 = new RunnableC2017o3(19, this);
        Context context2 = getContext();
        int[] iArr = YZ.w;
        C70 c70R = C70.r(context2, attributeSet, iArr, R.attr.toolbarStyle);
        Oj0.l(this, context, iArr, attributeSet, (TypedArray) c70R.n, R.attr.toolbarStyle);
        TypedArray typedArray = (TypedArray) c70R.n;
        this.w = typedArray.getResourceId(28, 0);
        this.x = typedArray.getResourceId(19, 0);
        this.H = typedArray.getInteger(0, 8388627);
        this.y = typedArray.getInteger(2, 48);
        int dimensionPixelOffset = typedArray.getDimensionPixelOffset(22, 0);
        dimensionPixelOffset = typedArray.hasValue(27) ? typedArray.getDimensionPixelOffset(27, dimensionPixelOffset) : dimensionPixelOffset;
        this.D = dimensionPixelOffset;
        this.C = dimensionPixelOffset;
        this.B = dimensionPixelOffset;
        this.A = dimensionPixelOffset;
        int dimensionPixelOffset2 = typedArray.getDimensionPixelOffset(25, -1);
        if (dimensionPixelOffset2 >= 0) {
            this.A = dimensionPixelOffset2;
        }
        int dimensionPixelOffset3 = typedArray.getDimensionPixelOffset(24, -1);
        if (dimensionPixelOffset3 >= 0) {
            this.B = dimensionPixelOffset3;
        }
        int dimensionPixelOffset4 = typedArray.getDimensionPixelOffset(26, -1);
        if (dimensionPixelOffset4 >= 0) {
            this.C = dimensionPixelOffset4;
        }
        int dimensionPixelOffset5 = typedArray.getDimensionPixelOffset(23, -1);
        if (dimensionPixelOffset5 >= 0) {
            this.D = dimensionPixelOffset5;
        }
        this.z = typedArray.getDimensionPixelSize(13, -1);
        int dimensionPixelOffset6 = typedArray.getDimensionPixelOffset(9, Integer.MIN_VALUE);
        int dimensionPixelOffset7 = typedArray.getDimensionPixelOffset(5, Integer.MIN_VALUE);
        int dimensionPixelSize = typedArray.getDimensionPixelSize(7, 0);
        int dimensionPixelSize2 = typedArray.getDimensionPixelSize(8, 0);
        d();
        C30 c30 = this.E;
        c30.h = false;
        if (dimensionPixelSize != Integer.MIN_VALUE) {
            c30.e = dimensionPixelSize;
            c30.a = dimensionPixelSize;
        }
        if (dimensionPixelSize2 != Integer.MIN_VALUE) {
            c30.f = dimensionPixelSize2;
            c30.b = dimensionPixelSize2;
        }
        if (dimensionPixelOffset6 != Integer.MIN_VALUE || dimensionPixelOffset7 != Integer.MIN_VALUE) {
            c30.a(dimensionPixelOffset6, dimensionPixelOffset7);
        }
        this.F = typedArray.getDimensionPixelOffset(10, Integer.MIN_VALUE);
        this.G = typedArray.getDimensionPixelOffset(6, Integer.MIN_VALUE);
        this.q = c70R.m(4);
        this.r = typedArray.getText(3);
        CharSequence text = typedArray.getText(21);
        if (!TextUtils.isEmpty(text)) {
            setTitle(text);
        }
        CharSequence text2 = typedArray.getText(18);
        if (!TextUtils.isEmpty(text2)) {
            setSubtitle(text2);
        }
        this.u = getContext();
        setPopupTheme(typedArray.getResourceId(17, 0));
        Drawable drawableM = c70R.m(16);
        if (drawableM != null) {
            setNavigationIcon(drawableM);
        }
        CharSequence text3 = typedArray.getText(15);
        if (!TextUtils.isEmpty(text3)) {
            setNavigationContentDescription(text3);
        }
        Drawable drawableM2 = c70R.m(11);
        if (drawableM2 != null) {
            setLogo(drawableM2);
        }
        CharSequence text4 = typedArray.getText(12);
        if (!TextUtils.isEmpty(text4)) {
            setLogoDescription(text4);
        }
        if (typedArray.hasValue(29)) {
            setTitleTextColor(c70R.l(29));
        }
        if (typedArray.hasValue(20)) {
            setSubtitleTextColor(c70R.l(20));
        }
        if (typedArray.hasValue(14)) {
            m(typedArray.getResourceId(14, 0));
        }
        c70R.t();
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context = getContext();
        Pf0 pf0 = new Pf0(context, attributeSet);
        pf0.a = 0;
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, YZ.b);
        pf0.a = typedArrayObtainStyledAttributes.getInt(0, 0);
        typedArrayObtainStyledAttributes.recycle();
        pf0.b = 0;
        return pf0;
    }

    public void setCollapseContentDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            c();
        }
        Z7 z7 = this.s;
        if (z7 != null) {
            z7.setContentDescription(charSequence);
        }
    }

    public void setCollapseIcon(Drawable drawable) {
        if (drawable != null) {
            c();
            this.s.setImageDrawable(drawable);
        } else {
            Z7 z7 = this.s;
            if (z7 != null) {
                z7.setImageDrawable(this.q);
            }
        }
    }

    public void setLogo(Drawable drawable) {
        if (drawable != null) {
            if (this.p == null) {
                this.p = new C0788b8(getContext(), null, 0);
            }
            if (!o(this.p)) {
                b(this.p, true);
            }
        } else {
            C0788b8 c0788b8 = this.p;
            if (c0788b8 != null && o(c0788b8)) {
                removeView(this.p);
                this.P.remove(this.p);
            }
        }
        C0788b8 c0788b82 = this.p;
        if (c0788b82 != null) {
            c0788b82.setImageDrawable(drawable);
        }
    }

    public void setLogoDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence) && this.p == null) {
            this.p = new C0788b8(getContext(), null, 0);
        }
        C0788b8 c0788b8 = this.p;
        if (c0788b8 != null) {
            c0788b8.setContentDescription(charSequence);
        }
    }

    public void setNavigationContentDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            g();
        }
        Z7 z7 = this.f5o;
        if (z7 != null) {
            z7.setContentDescription(charSequence);
            AbstractC0249Jp.e0(this.f5o, charSequence);
        }
    }

    public void setNavigationIcon(Drawable drawable) {
        if (drawable != null) {
            g();
            if (!o(this.f5o)) {
                b(this.f5o, true);
            }
        } else {
            Z7 z7 = this.f5o;
            if (z7 != null && o(z7)) {
                removeView(this.f5o);
                this.P.remove(this.f5o);
            }
        }
        Z7 z72 = this.f5o;
        if (z72 != null) {
            z72.setImageDrawable(drawable);
        }
    }

    public void setSubtitle(CharSequence charSequence) {
        if (TextUtils.isEmpty(charSequence)) {
            E8 e8 = this.n;
            if (e8 != null && o(e8)) {
                removeView(this.n);
                this.P.remove(this.n);
            }
        } else {
            if (this.n == null) {
                Context context = getContext();
                E8 e82 = new E8(context, null);
                this.n = e82;
                e82.setSingleLine();
                this.n.setEllipsize(TextUtils.TruncateAt.END);
                int i = this.x;
                if (i != 0) {
                    this.n.setTextAppearance(context, i);
                }
                ColorStateList colorStateList = this.L;
                if (colorStateList != null) {
                    this.n.setTextColor(colorStateList);
                }
            }
            if (!o(this.n)) {
                b(this.n, true);
            }
        }
        E8 e83 = this.n;
        if (e83 != null) {
            e83.setText(charSequence);
        }
        this.J = charSequence;
    }

    public void setSubtitleTextColor(ColorStateList colorStateList) {
        this.L = colorStateList;
        E8 e8 = this.n;
        if (e8 != null) {
            e8.setTextColor(colorStateList);
        }
    }

    public void setTitle(CharSequence charSequence) {
        if (TextUtils.isEmpty(charSequence)) {
            E8 e8 = this.m;
            if (e8 != null && o(e8)) {
                removeView(this.m);
                this.P.remove(this.m);
            }
        } else {
            if (this.m == null) {
                Context context = getContext();
                E8 e82 = new E8(context, null);
                this.m = e82;
                e82.setSingleLine();
                this.m.setEllipsize(TextUtils.TruncateAt.END);
                int i = this.w;
                if (i != 0) {
                    this.m.setTextAppearance(context, i);
                }
                ColorStateList colorStateList = this.K;
                if (colorStateList != null) {
                    this.m.setTextColor(colorStateList);
                }
            }
            if (!o(this.m)) {
                b(this.m, true);
            }
        }
        E8 e83 = this.m;
        if (e83 != null) {
            e83.setText(charSequence);
        }
        this.I = charSequence;
    }

    public void setTitleTextColor(ColorStateList colorStateList) {
        this.K = colorStateList;
        E8 e8 = this.m;
        if (e8 != null) {
            e8.setTextColor(colorStateList);
        }
    }
}
