package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.LinearLayout;
import androidx.appcompat.view.menu.ActionMenuItemView;
import com.google.android.gms.common.api.Api;
import o.AO;
import o.AbstractC2421sL;
import o.AbstractC2457sk0;
import o.BO;
import o.C1156f1;
import o.C1348h1;
import o.C1444i1;
import o.C1633k1;
import o.C2160pe;
import o.C2326rL;
import o.CO;
import o.InterfaceC0998dP;
import o.InterfaceC1477iP;
import o.InterfaceC1538j1;
import o.InterfaceC1728l1;
import o.LO;
import o.ME;
import o.OD;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class ActionMenuView extends AbstractC2421sL implements BO, InterfaceC1477iP {
    public CO A;
    public Context B;
    public int C;
    public boolean D;
    public C1444i1 E;
    public C2160pe F;
    public AO G;
    public boolean H;
    public int I;
    public final int J;
    public final int K;
    public InterfaceC1728l1 L;

    public ActionMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 0);
        setBaselineAligned(false);
        float f = context.getResources().getDisplayMetrics().density;
        this.J = (int) (56.0f * f);
        this.K = (int) (f * 4.0f);
        this.B = context;
        this.C = 0;
    }

    public static C1633k1 j() {
        C1633k1 c1633k1 = new C1633k1(-2, -2);
        c1633k1.a = false;
        ((LinearLayout.LayoutParams) c1633k1).gravity = 16;
        return c1633k1;
    }

    public static C1633k1 k(ViewGroup.LayoutParams layoutParams) {
        C1633k1 c1633k1;
        if (layoutParams == null) {
            return j();
        }
        if (layoutParams instanceof C1633k1) {
            C1633k1 c1633k12 = (C1633k1) layoutParams;
            c1633k1 = new C1633k1(c1633k12);
            c1633k1.a = c1633k12.a;
        } else {
            c1633k1 = new C1633k1(layoutParams);
        }
        if (((LinearLayout.LayoutParams) c1633k1).gravity <= 0) {
            ((LinearLayout.LayoutParams) c1633k1).gravity = 16;
        }
        return c1633k1;
    }

    @Override // o.InterfaceC1477iP
    public final void b(CO co) {
        this.A = co;
    }

    @Override // o.BO
    public final boolean c(LO lo) {
        return this.A.q(lo, null, 0);
    }

    @Override // o.AbstractC2421sL, android.view.ViewGroup
    public final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C1633k1;
    }

    @Override // android.view.View
    public final boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return false;
    }

    @Override // o.AbstractC2421sL
    /* renamed from: f */
    public final /* bridge */ /* synthetic */ C2326rL generateDefaultLayoutParams() {
        return j();
    }

    @Override // o.AbstractC2421sL
    /* renamed from: g */
    public final C2326rL generateLayoutParams(AttributeSet attributeSet) {
        return new C1633k1(getContext(), attributeSet);
    }

    @Override // o.AbstractC2421sL, android.view.ViewGroup
    public final /* bridge */ /* synthetic */ ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return j();
    }

    @Override // o.AbstractC2421sL, android.view.ViewGroup
    public final /* bridge */ /* synthetic */ ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return k(layoutParams);
    }

    public Menu getMenu() {
        if (this.A == null) {
            Context context = getContext();
            CO co = new CO(context);
            this.A = co;
            co.e = new OD(6, this);
            C1444i1 c1444i1 = new C1444i1(context);
            this.E = c1444i1;
            c1444i1.w = true;
            c1444i1.x = true;
            InterfaceC0998dP me = this.F;
            if (me == null) {
                me = new ME(27);
            }
            c1444i1.p = me;
            this.A.b(c1444i1, this.B);
            C1444i1 c1444i12 = this.E;
            c1444i12.s = this;
            this.A = c1444i12.n;
        }
        return this.A;
    }

    public Drawable getOverflowIcon() {
        getMenu();
        C1444i1 c1444i1 = this.E;
        C1348h1 c1348h1 = c1444i1.t;
        if (c1348h1 != null) {
            return c1348h1.getDrawable();
        }
        if (c1444i1.v) {
            return c1444i1.u;
        }
        return null;
    }

    public int getPopupTheme() {
        return this.C;
    }

    public int getWindowAnimations() {
        return 0;
    }

    @Override // o.AbstractC2421sL
    /* renamed from: h */
    public final /* bridge */ /* synthetic */ C2326rL generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return k(layoutParams);
    }

    public final boolean l(int i) {
        boolean zB = false;
        if (i == 0) {
            return false;
        }
        KeyEvent.Callback childAt = getChildAt(i - 1);
        KeyEvent.Callback childAt2 = getChildAt(i);
        if (i < getChildCount() && (childAt instanceof InterfaceC1538j1)) {
            zB = ((InterfaceC1538j1) childAt).b();
        }
        return (i <= 0 || !(childAt2 instanceof InterfaceC1538j1)) ? zB : ((InterfaceC1538j1) childAt2).c() | zB;
    }

    @Override // android.view.View
    public final void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        C1444i1 c1444i1 = this.E;
        if (c1444i1 != null) {
            c1444i1.c();
            if (this.E.h()) {
                this.E.e();
                this.E.l();
            }
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        C1444i1 c1444i1 = this.E;
        if (c1444i1 != null) {
            c1444i1.e();
            C1156f1 c1156f1 = c1444i1.E;
            if (c1156f1 == null || !c1156f1.b()) {
                return;
            }
            c1156f1.i.dismiss();
        }
    }

    @Override // o.AbstractC2421sL, android.view.ViewGroup, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int width;
        int paddingLeft;
        if (!this.H) {
            super.onLayout(z, i, i2, i3, i4);
            return;
        }
        int childCount = getChildCount();
        int i5 = (i4 - i2) / 2;
        int dividerWidth = getDividerWidth();
        int i6 = i3 - i;
        int paddingRight = (i6 - getPaddingRight()) - getPaddingLeft();
        boolean z2 = AbstractC2457sk0.a;
        boolean z3 = getLayoutDirection() == 1;
        int i7 = 0;
        int i8 = 0;
        for (int i9 = 0; i9 < childCount; i9++) {
            View childAt = getChildAt(i9);
            if (childAt.getVisibility() != 8) {
                C1633k1 c1633k1 = (C1633k1) childAt.getLayoutParams();
                if (c1633k1.a) {
                    int measuredWidth = childAt.getMeasuredWidth();
                    if (l(i9)) {
                        measuredWidth += dividerWidth;
                    }
                    int measuredHeight = childAt.getMeasuredHeight();
                    if (z3) {
                        paddingLeft = getPaddingLeft() + ((LinearLayout.LayoutParams) c1633k1).leftMargin;
                        width = paddingLeft + measuredWidth;
                    } else {
                        width = (getWidth() - getPaddingRight()) - ((LinearLayout.LayoutParams) c1633k1).rightMargin;
                        paddingLeft = width - measuredWidth;
                    }
                    int i10 = i5 - (measuredHeight / 2);
                    childAt.layout(paddingLeft, i10, width, measuredHeight + i10);
                    paddingRight -= measuredWidth;
                    i7 = 1;
                } else {
                    paddingRight -= (childAt.getMeasuredWidth() + ((LinearLayout.LayoutParams) c1633k1).leftMargin) + ((LinearLayout.LayoutParams) c1633k1).rightMargin;
                    l(i9);
                    i8++;
                }
            }
        }
        if (childCount == 1 && i7 == 0) {
            View childAt2 = getChildAt(0);
            int measuredWidth2 = childAt2.getMeasuredWidth();
            int measuredHeight2 = childAt2.getMeasuredHeight();
            int i11 = (i6 / 2) - (measuredWidth2 / 2);
            int i12 = i5 - (measuredHeight2 / 2);
            childAt2.layout(i11, i12, measuredWidth2 + i11, measuredHeight2 + i12);
            return;
        }
        int i13 = i8 - (i7 ^ 1);
        int iMax = Math.max(0, i13 > 0 ? paddingRight / i13 : 0);
        if (z3) {
            int width2 = getWidth() - getPaddingRight();
            for (int i14 = 0; i14 < childCount; i14++) {
                View childAt3 = getChildAt(i14);
                C1633k1 c1633k12 = (C1633k1) childAt3.getLayoutParams();
                if (childAt3.getVisibility() != 8 && !c1633k12.a) {
                    int i15 = width2 - ((LinearLayout.LayoutParams) c1633k12).rightMargin;
                    int measuredWidth3 = childAt3.getMeasuredWidth();
                    int measuredHeight3 = childAt3.getMeasuredHeight();
                    int i16 = i5 - (measuredHeight3 / 2);
                    childAt3.layout(i15 - measuredWidth3, i16, i15, measuredHeight3 + i16);
                    width2 = i15 - ((measuredWidth3 + ((LinearLayout.LayoutParams) c1633k12).leftMargin) + iMax);
                }
            }
            return;
        }
        int paddingLeft2 = getPaddingLeft();
        for (int i17 = 0; i17 < childCount; i17++) {
            View childAt4 = getChildAt(i17);
            C1633k1 c1633k13 = (C1633k1) childAt4.getLayoutParams();
            if (childAt4.getVisibility() != 8 && !c1633k13.a) {
                int i18 = paddingLeft2 + ((LinearLayout.LayoutParams) c1633k13).leftMargin;
                int measuredWidth4 = childAt4.getMeasuredWidth();
                int measuredHeight4 = childAt4.getMeasuredHeight();
                int i19 = i5 - (measuredHeight4 / 2);
                childAt4.layout(i18, i19, i18 + measuredWidth4, measuredHeight4 + i19);
                paddingLeft2 = measuredWidth4 + ((LinearLayout.LayoutParams) c1633k13).rightMargin + iMax + i18;
            }
        }
    }

    /* JADX WARN: Type inference failed for: r11v15 */
    /* JADX WARN: Type inference failed for: r11v16, types: [boolean, int] */
    /* JADX WARN: Type inference failed for: r11v18 */
    /* JADX WARN: Type inference failed for: r11v41 */
    @Override // o.AbstractC2421sL, android.view.View
    public final void onMeasure(int i, int i2) {
        int i3;
        int i4;
        ?? r11;
        int i5;
        int i6;
        CO co;
        boolean z = this.H;
        boolean z2 = View.MeasureSpec.getMode(i) == 1073741824;
        this.H = z2;
        if (z != z2) {
            this.I = 0;
        }
        int size = View.MeasureSpec.getSize(i);
        if (this.H && (co = this.A) != null && size != this.I) {
            this.I = size;
            co.p(true);
        }
        int childCount = getChildCount();
        if (!this.H || childCount <= 0) {
            for (int i7 = 0; i7 < childCount; i7++) {
                C1633k1 c1633k1 = (C1633k1) getChildAt(i7).getLayoutParams();
                ((LinearLayout.LayoutParams) c1633k1).rightMargin = 0;
                ((LinearLayout.LayoutParams) c1633k1).leftMargin = 0;
            }
            super.onMeasure(i, i2);
            return;
        }
        int mode = View.MeasureSpec.getMode(i2);
        int size2 = View.MeasureSpec.getSize(i);
        int size3 = View.MeasureSpec.getSize(i2);
        int paddingRight = getPaddingRight() + getPaddingLeft();
        int paddingBottom = getPaddingBottom() + getPaddingTop();
        int childMeasureSpec = ViewGroup.getChildMeasureSpec(i2, paddingBottom, -2);
        int i8 = size2 - paddingRight;
        int i9 = this.J;
        int i10 = i8 / i9;
        int i11 = i8 % i9;
        if (i10 == 0) {
            setMeasuredDimension(i8, 0);
            return;
        }
        int i12 = (i11 / i10) + i9;
        int childCount2 = getChildCount();
        int iMax = 0;
        int i13 = 0;
        int iMax2 = 0;
        int i14 = 0;
        boolean z3 = false;
        int i15 = 0;
        long j = 0;
        while (true) {
            i3 = this.K;
            if (i14 >= childCount2) {
                break;
            }
            View childAt = getChildAt(i14);
            int i16 = size3;
            int i17 = paddingBottom;
            if (childAt.getVisibility() == 8) {
                i5 = i12;
            } else {
                boolean z4 = childAt instanceof ActionMenuItemView;
                i13++;
                if (z4) {
                    childAt.setPadding(i3, 0, i3, 0);
                }
                C1633k1 c1633k12 = (C1633k1) childAt.getLayoutParams();
                c1633k12.f = false;
                c1633k12.c = 0;
                c1633k12.b = 0;
                c1633k12.d = false;
                ((LinearLayout.LayoutParams) c1633k12).leftMargin = 0;
                ((LinearLayout.LayoutParams) c1633k12).rightMargin = 0;
                c1633k12.e = z4 && !TextUtils.isEmpty(((ActionMenuItemView) childAt).getText());
                int i18 = c1633k12.a ? 1 : i10;
                C1633k1 c1633k13 = (C1633k1) childAt.getLayoutParams();
                int i19 = i10;
                i5 = i12;
                int iMakeMeasureSpec = View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(childMeasureSpec) - i17, View.MeasureSpec.getMode(childMeasureSpec));
                ActionMenuItemView actionMenuItemView = z4 ? (ActionMenuItemView) childAt : null;
                boolean z5 = (actionMenuItemView == null || TextUtils.isEmpty(actionMenuItemView.getText())) ? false : true;
                boolean z6 = z5;
                if (i18 <= 0 || (z5 && i18 < 2)) {
                    i6 = 0;
                } else {
                    childAt.measure(View.MeasureSpec.makeMeasureSpec(i5 * i18, Integer.MIN_VALUE), iMakeMeasureSpec);
                    int measuredWidth = childAt.getMeasuredWidth();
                    i6 = measuredWidth / i5;
                    if (measuredWidth % i5 != 0) {
                        i6++;
                    }
                    if (z6 && i6 < 2) {
                        i6 = 2;
                    }
                }
                c1633k13.d = !c1633k13.a && z6;
                c1633k13.b = i6;
                childAt.measure(View.MeasureSpec.makeMeasureSpec(i6 * i5, 1073741824), iMakeMeasureSpec);
                iMax2 = Math.max(iMax2, i6);
                if (c1633k12.d) {
                    i15++;
                }
                if (c1633k12.a) {
                    z3 = true;
                }
                i10 = i19 - i6;
                iMax = Math.max(iMax, childAt.getMeasuredHeight());
                if (i6 == 1) {
                    j |= 1 << i14;
                }
            }
            i14++;
            size3 = i16;
            paddingBottom = i17;
            i12 = i5;
        }
        int i20 = size3;
        int i21 = i10;
        int i22 = i12;
        boolean z7 = z3 && i13 == 2;
        int i23 = i21;
        boolean z8 = false;
        while (i15 > 0 && i23 > 0) {
            int i24 = Api.BaseClientBuilder.API_PRIORITY_OTHER;
            long j2 = 0;
            int i25 = 0;
            int i26 = 0;
            while (i26 < childCount2) {
                int i27 = iMax;
                C1633k1 c1633k14 = (C1633k1) getChildAt(i26).getLayoutParams();
                boolean z9 = z7;
                if (c1633k14.d) {
                    int i28 = c1633k14.b;
                    if (i28 < i24) {
                        j2 = 1 << i26;
                        i24 = i28;
                        i25 = 1;
                    } else if (i28 == i24) {
                        j2 |= 1 << i26;
                        i25++;
                    }
                }
                i26++;
                z7 = z9;
                iMax = i27;
            }
            i4 = iMax;
            boolean z10 = z7;
            j |= j2;
            if (i25 > i23) {
                break;
            }
            int i29 = i24 + 1;
            int i30 = 0;
            while (i30 < childCount2) {
                View childAt2 = getChildAt(i30);
                C1633k1 c1633k15 = (C1633k1) childAt2.getLayoutParams();
                boolean z11 = z3;
                long j3 = 1 << i30;
                if ((j2 & j3) != 0) {
                    if (z10 && c1633k15.e) {
                        r11 = 1;
                        r11 = 1;
                        if (i23 == 1) {
                            childAt2.setPadding(i3 + i22, 0, i3, 0);
                        }
                    } else {
                        r11 = 1;
                    }
                    c1633k15.b += r11;
                    c1633k15.f = r11;
                    i23--;
                } else if (c1633k15.b == i29) {
                    j |= j3;
                }
                i30++;
                z3 = z11;
            }
            z7 = z10;
            iMax = i4;
            z8 = true;
        }
        i4 = iMax;
        boolean z12 = !z3 && i13 == 1;
        if (i23 > 0 && j != 0 && (i23 < i13 - 1 || z12 || iMax2 > 1)) {
            float fBitCount = Long.bitCount(j);
            if (!z12) {
                if ((j & 1) != 0 && !((C1633k1) getChildAt(0).getLayoutParams()).e) {
                    fBitCount -= 0.5f;
                }
                int i31 = childCount2 - 1;
                if ((j & (1 << i31)) != 0 && !((C1633k1) getChildAt(i31).getLayoutParams()).e) {
                    fBitCount -= 0.5f;
                }
            }
            int i32 = fBitCount > 0.0f ? (int) ((i23 * i22) / fBitCount) : 0;
            boolean z13 = z8;
            for (int i33 = 0; i33 < childCount2; i33++) {
                if ((j & (1 << i33)) != 0) {
                    View childAt3 = getChildAt(i33);
                    C1633k1 c1633k16 = (C1633k1) childAt3.getLayoutParams();
                    if (childAt3 instanceof ActionMenuItemView) {
                        c1633k16.c = i32;
                        c1633k16.f = true;
                        if (i33 == 0 && !c1633k16.e) {
                            ((LinearLayout.LayoutParams) c1633k16).leftMargin = (-i32) / 2;
                        }
                        z13 = true;
                    } else if (c1633k16.a) {
                        c1633k16.c = i32;
                        c1633k16.f = true;
                        ((LinearLayout.LayoutParams) c1633k16).rightMargin = (-i32) / 2;
                        z13 = true;
                    } else {
                        if (i33 != 0) {
                            ((LinearLayout.LayoutParams) c1633k16).leftMargin = i32 / 2;
                        }
                        if (i33 != childCount2 - 1) {
                            ((LinearLayout.LayoutParams) c1633k16).rightMargin = i32 / 2;
                        }
                    }
                }
            }
            z8 = z13;
        }
        if (z8) {
            for (int i34 = 0; i34 < childCount2; i34++) {
                View childAt4 = getChildAt(i34);
                C1633k1 c1633k17 = (C1633k1) childAt4.getLayoutParams();
                if (c1633k17.f) {
                    childAt4.measure(View.MeasureSpec.makeMeasureSpec((c1633k17.b * i22) + c1633k17.c, 1073741824), childMeasureSpec);
                }
            }
        }
        setMeasuredDimension(i8, mode != 1073741824 ? i4 : i20);
    }

    public void setExpandedActionViewsExclusive(boolean z) {
        this.E.B = z;
    }

    public void setOnMenuItemClickListener(InterfaceC1728l1 interfaceC1728l1) {
        this.L = interfaceC1728l1;
    }

    public void setOverflowIcon(Drawable drawable) {
        getMenu();
        C1444i1 c1444i1 = this.E;
        C1348h1 c1348h1 = c1444i1.t;
        if (c1348h1 != null) {
            c1348h1.setImageDrawable(drawable);
        } else {
            c1444i1.v = true;
            c1444i1.u = drawable;
        }
    }

    public void setOverflowReserved(boolean z) {
        this.D = z;
    }

    public void setPopupTheme(int i) {
        if (this.C != i) {
            this.C = i;
            if (i == 0) {
                this.B = getContext();
            } else {
                this.B = new ContextThemeWrapper(getContext(), i);
            }
        }
    }

    public void setPresenter(C1444i1 c1444i1) {
        this.E = c1444i1;
        c1444i1.s = this;
        this.A = c1444i1.n;
    }

    @Override // o.AbstractC2421sL, android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new C1633k1(getContext(), attributeSet);
    }
}
