package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.OverScroller;
import com.google.android.gms.common.R;
import com.google.android.gms.common.api.Api;
import java.util.WeakHashMap;
import o.AbstractC3124zl0;
import o.C0678a1;
import o.C0774b1;
import o.C1444i1;
import o.C1510il0;
import o.C1793lk0;
import o.C2649ul0;
import o.C2744vl0;
import o.C2839wl0;
import o.C2934xl0;
import o.C3029yl0;
import o.C80;
import o.CO;
import o.Ej0;
import o.Gj0;
import o.Hl0;
import o.InterfaceC0352Np;
import o.InterfaceC0378Op;
import o.InterfaceC0998dP;
import o.KZ;
import o.Kl0;
import o.LH;
import o.Of0;
import o.Oj0;
import o.RR;
import o.SR;
import o.Vf0;
import o.X0;
import o.Y0;
import o.Z0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class ActionBarOverlayLayout extends ViewGroup implements InterfaceC0352Np, RR, SR {
    public static final int[] N = {R.attr.actionBarSize, android.R.attr.windowContentOverlay};
    public static final Kl0 O;
    public static final Rect P;
    public final Rect A;
    public Kl0 B;
    public Kl0 C;
    public Kl0 D;
    public Kl0 E;
    public Z0 F;
    public OverScroller G;
    public ViewPropertyAnimator H;
    public final X0 I;
    public final Y0 J;
    public final Y0 K;
    public final KZ L;
    public final C0774b1 M;
    public int l;
    public int m;
    public ContentFrameLayout n;

    /* renamed from: o, reason: collision with root package name */
    public ActionBarContainer f3o;
    public InterfaceC0378Op p;
    public Drawable q;
    public boolean r;
    public boolean s;
    public boolean t;
    public boolean u;
    public int v;
    public int w;
    public final Rect x;
    public final Rect y;
    public final Rect z;

    static {
        int i = Build.VERSION.SDK_INT;
        AbstractC3124zl0 c3029yl0 = i >= 34 ? new C3029yl0() : i >= 31 ? new C2934xl0() : i >= 30 ? new C2839wl0() : i >= 29 ? new C2744vl0() : new C2649ul0();
        c3029yl0.g(LH.b(0, 1, 0, 1));
        O = c3029yl0.b();
        P = new Rect();
    }

    public ActionBarOverlayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.m = 0;
        this.x = new Rect();
        this.y = new Rect();
        this.z = new Rect();
        this.A = new Rect();
        new Rect();
        new Rect();
        new Rect();
        new Rect();
        Kl0 kl0 = Kl0.b;
        this.B = kl0;
        this.C = kl0;
        this.D = kl0;
        this.E = kl0;
        this.I = new X0(0, this);
        this.J = new Y0(this, 0);
        this.K = new Y0(this, 1);
        i(context);
        this.L = new KZ(1);
        C0774b1 c0774b1 = new C0774b1(context);
        c0774b1.setWillNotDraw(true);
        this.M = c0774b1;
        addView(c0774b1);
    }

    public static boolean d(View view, Rect rect, boolean z) {
        boolean z2;
        C0678a1 c0678a1 = (C0678a1) view.getLayoutParams();
        int i = ((ViewGroup.MarginLayoutParams) c0678a1).leftMargin;
        int i2 = rect.left;
        if (i != i2) {
            ((ViewGroup.MarginLayoutParams) c0678a1).leftMargin = i2;
            z2 = true;
        } else {
            z2 = false;
        }
        int i3 = ((ViewGroup.MarginLayoutParams) c0678a1).topMargin;
        int i4 = rect.top;
        if (i3 != i4) {
            ((ViewGroup.MarginLayoutParams) c0678a1).topMargin = i4;
            z2 = true;
        }
        int i5 = ((ViewGroup.MarginLayoutParams) c0678a1).rightMargin;
        int i6 = rect.right;
        if (i5 != i6) {
            ((ViewGroup.MarginLayoutParams) c0678a1).rightMargin = i6;
            z2 = true;
        }
        if (z) {
            int i7 = ((ViewGroup.MarginLayoutParams) c0678a1).bottomMargin;
            int i8 = rect.bottom;
            if (i7 != i8) {
                ((ViewGroup.MarginLayoutParams) c0678a1).bottomMargin = i8;
                return true;
            }
        }
        return z2;
    }

    @Override // o.RR
    public final void a(View view, View view2, int i, int i2) {
        if (i2 == 0) {
            onNestedScrollAccepted(view, view2, i);
        }
    }

    @Override // o.RR
    public final void b(View view, int i) {
        if (i == 0) {
            onStopNestedScroll(view);
        }
    }

    @Override // android.view.ViewGroup
    public final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C0678a1;
    }

    @Override // android.view.View
    public final void draw(Canvas canvas) {
        int translationY;
        super.draw(canvas);
        if (this.q != null) {
            if (this.f3o.getVisibility() == 0) {
                translationY = (int) (this.f3o.getTranslationY() + this.f3o.getBottom() + 0.5f);
            } else {
                translationY = 0;
            }
            this.q.setBounds(0, translationY, getWidth(), this.q.getIntrinsicHeight() + translationY);
            this.q.draw(canvas);
        }
    }

    public final void e() {
        removeCallbacks(this.J);
        removeCallbacks(this.K);
        ViewPropertyAnimator viewPropertyAnimator = this.H;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
        }
    }

    @Override // o.SR
    public final void f(View view, int i, int i2, int i3, int i4, int i5, int[] iArr) {
        g(view, i, i2, i3, i4, i5);
    }

    @Override // android.view.View
    public final boolean fitSystemWindows(Rect rect) {
        return super.fitSystemWindows(rect);
    }

    @Override // o.RR
    public final void g(View view, int i, int i2, int i3, int i4, int i5) {
        if (i5 == 0) {
            onNestedScroll(view, i, i2, i3, i4);
        }
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new C0678a1(-1, -1);
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new C0678a1(getContext(), attributeSet);
    }

    public int getActionBarHideOffset() {
        ActionBarContainer actionBarContainer = this.f3o;
        if (actionBarContainer != null) {
            return -((int) actionBarContainer.getTranslationY());
        }
        return 0;
    }

    @Override // android.view.ViewGroup
    public int getNestedScrollAxes() {
        KZ kz = this.L;
        return kz.c | kz.b;
    }

    public CharSequence getTitle() {
        k();
        return ((Vf0) this.p).a.getTitle();
    }

    @Override // o.RR
    public final boolean h(View view, View view2, int i, int i2) {
        return i2 == 0 && onStartNestedScroll(view, view2, i);
    }

    public final void i(Context context) {
        TypedArray typedArrayObtainStyledAttributes = getContext().getTheme().obtainStyledAttributes(N);
        this.l = typedArrayObtainStyledAttributes.getDimensionPixelSize(0, 0);
        Drawable drawable = typedArrayObtainStyledAttributes.getDrawable(1);
        this.q = drawable;
        setWillNotDraw(drawable == null);
        typedArrayObtainStyledAttributes.recycle();
        this.G = new OverScroller(context);
    }

    public final void j(int i) {
        k();
        if (i == 2) {
            this.p.getClass();
        } else if (i == 5) {
            this.p.getClass();
        } else {
            if (i != 109) {
                return;
            }
            setOverlayMode(true);
        }
    }

    public final void k() {
        InterfaceC0378Op wrapper;
        if (this.n == null) {
            this.n = (ContentFrameLayout) findViewById(R.id.action_bar_activity_content);
            this.f3o = (ActionBarContainer) findViewById(R.id.action_bar_container);
            KeyEvent.Callback callbackFindViewById = findViewById(R.id.action_bar);
            if (callbackFindViewById instanceof InterfaceC0378Op) {
                wrapper = (InterfaceC0378Op) callbackFindViewById;
            } else {
                if (!(callbackFindViewById instanceof Toolbar)) {
                    throw new IllegalStateException("Can't make a decor toolbar out of ".concat(callbackFindViewById.getClass().getSimpleName()));
                }
                wrapper = ((Toolbar) callbackFindViewById).getWrapper();
            }
            this.p = wrapper;
        }
    }

    public final void l(Menu menu, InterfaceC0998dP interfaceC0998dP) {
        k();
        Vf0 vf0 = (Vf0) this.p;
        Toolbar toolbar = vf0.a;
        if (vf0.m == null) {
            vf0.m = new C1444i1(toolbar.getContext());
        }
        C1444i1 c1444i1 = vf0.m;
        c1444i1.p = interfaceC0998dP;
        CO co = (CO) menu;
        if (co == null && toolbar.l == null) {
            return;
        }
        toolbar.f();
        CO co2 = toolbar.l.A;
        if (co2 == co) {
            return;
        }
        if (co2 != null) {
            co2.r(toolbar.W);
            co2.r(toolbar.a0);
        }
        if (toolbar.a0 == null) {
            toolbar.a0 = new Of0(toolbar);
        }
        c1444i1.B = true;
        if (co != null) {
            co.b(c1444i1, toolbar.u);
            co.b(toolbar.a0, toolbar.u);
        } else {
            c1444i1.g(toolbar.u, null);
            toolbar.a0.g(toolbar.u, null);
            c1444i1.c();
            toolbar.a0.c();
        }
        toolbar.l.setPopupTheme(toolbar.v);
        toolbar.l.setPresenter(c1444i1);
        toolbar.W = c1444i1;
        toolbar.w();
    }

    @Override // android.view.View
    public final WindowInsets onApplyWindowInsets(WindowInsets windowInsets) {
        k();
        Kl0 kl0G = Kl0.g(this, windowInsets);
        boolean zD = d(this.f3o, new Rect(kl0G.b(), kl0G.d(), kl0G.c(), kl0G.a()), false);
        WeakHashMap weakHashMap = Oj0.a;
        Rect rect = this.x;
        Gj0.b(this, kl0G, rect);
        int i = rect.left;
        int i2 = rect.top;
        int i3 = rect.right;
        int i4 = rect.bottom;
        Hl0 hl0 = kl0G.a;
        Kl0 kl0N = hl0.n(i, i2, i3, i4);
        this.B = kl0N;
        boolean z = true;
        if (!this.C.equals(kl0N)) {
            this.C = this.B;
            zD = true;
        }
        Rect rect2 = this.y;
        if (rect2.equals(rect)) {
            z = zD;
        } else {
            rect2.set(rect);
        }
        if (z) {
            requestLayout();
        }
        return hl0.a().a.c().a.b().f();
    }

    @Override // android.view.View
    public final void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        i(getContext());
        WeakHashMap weakHashMap = Oj0.a;
        Ej0.c(this);
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        e();
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int childCount = getChildCount();
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        for (int i5 = 0; i5 < childCount; i5++) {
            View childAt = getChildAt(i5);
            if (childAt.getVisibility() != 8) {
                C0678a1 c0678a1 = (C0678a1) childAt.getLayoutParams();
                int measuredWidth = childAt.getMeasuredWidth();
                int measuredHeight = childAt.getMeasuredHeight();
                int i6 = ((ViewGroup.MarginLayoutParams) c0678a1).leftMargin + paddingLeft;
                int i7 = ((ViewGroup.MarginLayoutParams) c0678a1).topMargin + paddingTop;
                childAt.layout(i6, i7, measuredWidth + i6, measuredHeight + i7);
            }
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:22:0x00aa  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void onMeasure(int r13, int r14) {
        /*
            Method dump skipped, instructions count: 391
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.appcompat.widget.ActionBarOverlayLayout.onMeasure(int, int):void");
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final boolean onNestedFling(View view, float f, float f2, boolean z) {
        if (!this.t || !z) {
            return false;
        }
        this.G.fling(0, 0, 0, (int) f2, 0, 0, Integer.MIN_VALUE, Api.BaseClientBuilder.API_PRIORITY_OTHER);
        if (this.G.getFinalY() > this.f3o.getHeight()) {
            e();
            this.K.run();
        } else {
            e();
            this.J.run();
        }
        this.u = true;
        return true;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final boolean onNestedPreFling(View view, float f, float f2) {
        return false;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        int i5 = this.v + i2;
        this.v = i5;
        setActionBarHideOffset(i5);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void onNestedScrollAccepted(View view, View view2, int i) {
        C1510il0 c1510il0;
        C1793lk0 c1793lk0;
        this.L.b = i;
        this.v = getActionBarHideOffset();
        e();
        Z0 z0 = this.F;
        if (z0 == null || (c1793lk0 = (c1510il0 = (C1510il0) z0).s) == null) {
            return;
        }
        c1793lk0.a();
        c1510il0.s = null;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final boolean onStartNestedScroll(View view, View view2, int i) {
        if ((i & 2) == 0 || this.f3o.getVisibility() != 0) {
            return false;
        }
        return this.t;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void onStopNestedScroll(View view) {
        if (!this.t || this.u) {
            return;
        }
        if (this.v <= this.f3o.getHeight()) {
            e();
            postDelayed(this.J, 600L);
        } else {
            e();
            postDelayed(this.K, 600L);
        }
    }

    @Override // android.view.View
    public final void onWindowSystemUiVisibilityChanged(int i) {
        super.onWindowSystemUiVisibilityChanged(i);
        k();
        int i2 = this.w ^ i;
        this.w = i;
        boolean z = (i & 4) == 0;
        boolean z2 = (i & 256) != 0;
        Z0 z0 = this.F;
        if (z0 != null) {
            C1510il0 c1510il0 = (C1510il0) z0;
            c1510il0.f585o = !z2;
            if (z || !z2) {
                if (c1510il0.p) {
                    c1510il0.p = false;
                    c1510il0.s(true);
                }
            } else if (!c1510il0.p) {
                c1510il0.p = true;
                c1510il0.s(true);
            }
        }
        if ((i2 & 256) == 0 || this.F == null) {
            return;
        }
        WeakHashMap weakHashMap = Oj0.a;
        Ej0.c(this);
    }

    @Override // android.view.View
    public final void onWindowVisibilityChanged(int i) {
        super.onWindowVisibilityChanged(i);
        this.m = i;
        Z0 z0 = this.F;
        if (z0 != null) {
            ((C1510il0) z0).n = i;
        }
    }

    public void setActionBarHideOffset(int i) {
        e();
        this.f3o.setTranslationY(-Math.max(0, Math.min(i, this.f3o.getHeight())));
    }

    public void setActionBarVisibilityCallback(Z0 z0) {
        this.F = z0;
        if (getWindowToken() != null) {
            ((C1510il0) this.F).n = this.m;
            int i = this.w;
            if (i != 0) {
                onWindowSystemUiVisibilityChanged(i);
                WeakHashMap weakHashMap = Oj0.a;
                Ej0.c(this);
            }
        }
    }

    public void setHasNonEmbeddedTabs(boolean z) {
        this.s = z;
    }

    public void setHideOnContentScrollEnabled(boolean z) {
        if (z != this.t) {
            this.t = z;
            if (z) {
                return;
            }
            e();
            setActionBarHideOffset(0);
        }
    }

    public void setIcon(int i) {
        k();
        Vf0 vf0 = (Vf0) this.p;
        vf0.d = i != 0 ? C80.x(vf0.a.getContext(), i) : null;
        vf0.c();
    }

    public void setLogo(int i) {
        k();
        Vf0 vf0 = (Vf0) this.p;
        vf0.e = i != 0 ? C80.x(vf0.a.getContext(), i) : null;
        vf0.c();
    }

    public void setOverlayMode(boolean z) {
        this.r = z;
    }

    @Override // o.InterfaceC0352Np
    public void setWindowCallback(Window.Callback callback) {
        k();
        ((Vf0) this.p).k = callback;
    }

    @Override // o.InterfaceC0352Np
    public void setWindowTitle(CharSequence charSequence) {
        k();
        Vf0 vf0 = (Vf0) this.p;
        if (vf0.g) {
            return;
        }
        Toolbar toolbar = vf0.a;
        vf0.h = charSequence;
        if ((vf0.b & 8) != 0) {
            toolbar.setTitle(charSequence);
            if (vf0.g) {
                Oj0.n(toolbar.getRootView(), charSequence);
            }
        }
    }

    @Override // android.view.ViewGroup
    public final boolean shouldDelayChildPressedState() {
        return false;
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new C0678a1(layoutParams);
    }

    public void setIcon(Drawable drawable) {
        k();
        Vf0 vf0 = (Vf0) this.p;
        vf0.d = drawable;
        vf0.c();
    }

    public void setShowingForActionMode(boolean z) {
    }

    public void setUiOptions(int i) {
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public final void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
    }

    @Override // o.RR
    public final void c(View view, int i, int i2, int[] iArr, int i3) {
    }
}
