package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.R;
import o.AbstractC1918n1;
import o.AbstractC2457sk0;
import o.C1156f1;
import o.C1444i1;
import o.C1535j;
import o.C1698kk0;
import o.C80;
import o.CO;
import o.InterfaceC1477iP;
import o.Oj0;
import o.V0;
import o.YZ;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class ActionBarContextView extends ViewGroup {
    public TextView A;
    public final int B;
    public final int C;
    public boolean D;
    public final int E;
    public final C1535j l;
    public final Context m;
    public ActionMenuView n;

    /* renamed from: o, reason: collision with root package name */
    public C1444i1 f2o;
    public int p;
    public C1698kk0 q;
    public boolean r;
    public boolean s;
    public CharSequence t;
    public CharSequence u;
    public View v;
    public View w;
    public View x;
    public LinearLayout y;
    public TextView z;

    public ActionBarContextView(Context context, AttributeSet attributeSet) {
        int resourceId;
        super(context, attributeSet, R.attr.actionModeStyle);
        C1535j c1535j = new C1535j();
        c1535j.c = this;
        c1535j.b = false;
        this.l = c1535j;
        TypedValue typedValue = new TypedValue();
        if (!context.getTheme().resolveAttribute(R.attr.actionBarPopupTheme, typedValue, true) || typedValue.resourceId == 0) {
            this.m = context;
        } else {
            this.m = new ContextThemeWrapper(context, typedValue.resourceId);
        }
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, YZ.d, R.attr.actionModeStyle, 0);
        setBackground((!typedArrayObtainStyledAttributes.hasValue(0) || (resourceId = typedArrayObtainStyledAttributes.getResourceId(0, 0)) == 0) ? typedArrayObtainStyledAttributes.getDrawable(0) : C80.x(context, resourceId));
        this.B = typedArrayObtainStyledAttributes.getResourceId(5, 0);
        this.C = typedArrayObtainStyledAttributes.getResourceId(4, 0);
        this.p = typedArrayObtainStyledAttributes.getLayoutDimension(3, 0);
        this.E = typedArrayObtainStyledAttributes.getResourceId(2, R.layout.abc_action_mode_close_item_material);
        typedArrayObtainStyledAttributes.recycle();
    }

    public static int f(View view, int i, int i2) {
        view.measure(View.MeasureSpec.makeMeasureSpec(i, Integer.MIN_VALUE), i2);
        return Math.max(0, i - view.getMeasuredWidth());
    }

    public static int g(View view, int i, int i2, int i3, boolean z) {
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        int i4 = ((i3 - measuredHeight) / 2) + i2;
        if (z) {
            view.layout(i - measuredWidth, i4, i, measuredHeight + i4);
        } else {
            view.layout(i, i4, i + measuredWidth, measuredHeight + i4);
        }
        return z ? -measuredWidth : measuredWidth;
    }

    public final void c(AbstractC1918n1 abstractC1918n1) {
        View view = this.v;
        if (view == null) {
            View viewInflate = LayoutInflater.from(getContext()).inflate(this.E, (ViewGroup) this, false);
            this.v = viewInflate;
            addView(viewInflate);
        } else if (view.getParent() == null) {
            addView(this.v);
        }
        View viewFindViewById = this.v.findViewById(R.id.action_mode_close_button);
        this.w = viewFindViewById;
        viewFindViewById.setOnClickListener(new V0(0, abstractC1918n1));
        CO coC = abstractC1918n1.c();
        C1444i1 c1444i1 = this.f2o;
        if (c1444i1 != null) {
            c1444i1.e();
            C1156f1 c1156f1 = c1444i1.E;
            if (c1156f1 != null && c1156f1.b()) {
                c1156f1.i.dismiss();
            }
        }
        C1444i1 c1444i12 = new C1444i1(getContext());
        this.f2o = c1444i12;
        c1444i12.w = true;
        c1444i12.x = true;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        coC.b(this.f2o, this.m);
        C1444i1 c1444i13 = this.f2o;
        InterfaceC1477iP interfaceC1477iP = c1444i13.s;
        if (interfaceC1477iP == null) {
            InterfaceC1477iP interfaceC1477iP2 = (InterfaceC1477iP) c1444i13.f573o.inflate(c1444i13.q, (ViewGroup) this, false);
            c1444i13.s = interfaceC1477iP2;
            interfaceC1477iP2.b(c1444i13.n);
            c1444i13.c();
        }
        InterfaceC1477iP interfaceC1477iP3 = c1444i13.s;
        if (interfaceC1477iP != interfaceC1477iP3) {
            ((ActionMenuView) interfaceC1477iP3).setPresenter(c1444i13);
        }
        ActionMenuView actionMenuView = (ActionMenuView) interfaceC1477iP3;
        this.n = actionMenuView;
        actionMenuView.setBackground(null);
        addView(this.n, layoutParams);
    }

    public final void d() {
        if (this.y == null) {
            LayoutInflater.from(getContext()).inflate(R.layout.abc_action_bar_title_item, this);
            LinearLayout linearLayout = (LinearLayout) getChildAt(getChildCount() - 1);
            this.y = linearLayout;
            this.z = (TextView) linearLayout.findViewById(R.id.action_bar_title);
            this.A = (TextView) this.y.findViewById(R.id.action_bar_subtitle);
            int i = this.B;
            if (i != 0) {
                this.z.setTextAppearance(getContext(), i);
            }
            int i2 = this.C;
            if (i2 != 0) {
                this.A.setTextAppearance(getContext(), i2);
            }
        }
        this.z.setText(this.t);
        this.A.setText(this.u);
        boolean zIsEmpty = TextUtils.isEmpty(this.t);
        boolean zIsEmpty2 = TextUtils.isEmpty(this.u);
        this.A.setVisibility(!zIsEmpty2 ? 0 : 8);
        this.y.setVisibility((zIsEmpty && zIsEmpty2) ? 8 : 0);
        if (this.y.getParent() == null) {
            addView(this.y);
        }
    }

    public final void e() {
        removeAllViews();
        this.x = null;
        this.n = null;
        this.f2o = null;
        View view = this.w;
        if (view != null) {
            view.setOnClickListener(null);
        }
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -2);
    }

    @Override // android.view.ViewGroup
    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(getContext(), attributeSet);
    }

    public int getAnimatedVisibility() {
        return this.q != null ? this.l.a : getVisibility();
    }

    public int getContentHeight() {
        return this.p;
    }

    public CharSequence getSubtitle() {
        return this.u;
    }

    public CharSequence getTitle() {
        return this.t;
    }

    @Override // android.view.View
    /* renamed from: h, reason: merged with bridge method [inline-methods] */
    public final void setVisibility(int i) {
        if (i != getVisibility()) {
            C1698kk0 c1698kk0 = this.q;
            if (c1698kk0 != null) {
                c1698kk0.b();
            }
            super.setVisibility(i);
        }
    }

    public final C1698kk0 i(int i, long j) {
        C1698kk0 c1698kk0 = this.q;
        if (c1698kk0 != null) {
            c1698kk0.b();
        }
        C1535j c1535j = this.l;
        if (i != 0) {
            C1698kk0 c1698kk0A = Oj0.a(this);
            c1698kk0A.a(0.0f);
            c1698kk0A.c(j);
            ((ActionBarContextView) c1535j.c).q = c1698kk0A;
            c1535j.a = i;
            c1698kk0A.d(c1535j);
            return c1698kk0A;
        }
        if (getVisibility() != 0) {
            setAlpha(0.0f);
        }
        C1698kk0 c1698kk0A2 = Oj0.a(this);
        c1698kk0A2.a(1.0f);
        c1698kk0A2.c(j);
        ((ActionBarContextView) c1535j.c).q = c1698kk0A2;
        c1535j.a = i;
        c1698kk0A2.d(c1535j);
        return c1698kk0A2;
    }

    @Override // android.view.View
    public final void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        TypedArray typedArrayObtainStyledAttributes = getContext().obtainStyledAttributes(null, YZ.a, R.attr.actionBarStyle, 0);
        setContentHeight(typedArrayObtainStyledAttributes.getLayoutDimension(13, 0));
        typedArrayObtainStyledAttributes.recycle();
        C1444i1 c1444i1 = this.f2o;
        if (c1444i1 != null) {
            Configuration configuration2 = c1444i1.m.getResources().getConfiguration();
            int i = configuration2.screenWidthDp;
            int i2 = configuration2.screenHeightDp;
            c1444i1.A = (configuration2.smallestScreenWidthDp > 600 || i > 600 || (i > 960 && i2 > 720) || (i > 720 && i2 > 960)) ? 5 : (i >= 500 || (i > 640 && i2 > 480) || (i > 480 && i2 > 640)) ? 4 : i >= 360 ? 3 : 2;
            CO co = c1444i1.n;
            if (co != null) {
                co.p(true);
            }
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        C1444i1 c1444i1 = this.f2o;
        if (c1444i1 != null) {
            c1444i1.e();
            C1156f1 c1156f1 = this.f2o.E;
            if (c1156f1 == null || !c1156f1.b()) {
                return;
            }
            c1156f1.i.dismiss();
        }
    }

    @Override // android.view.View
    public final boolean onHoverEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 9) {
            this.s = false;
        }
        if (!this.s) {
            boolean zOnHoverEvent = super.onHoverEvent(motionEvent);
            if (actionMasked == 9 && !zOnHoverEvent) {
                this.s = true;
            }
        }
        if (actionMasked != 10 && actionMasked != 3) {
            return true;
        }
        this.s = false;
        return true;
    }

    @Override // android.view.ViewGroup, android.view.View
    public final void onLayout(boolean z, int i, int i2, int i3, int i4) {
        boolean z2 = AbstractC2457sk0.a;
        boolean z3 = getLayoutDirection() == 1;
        int paddingRight = z3 ? (i3 - i) - getPaddingRight() : getPaddingLeft();
        int paddingTop = getPaddingTop();
        int paddingTop2 = ((i4 - i2) - getPaddingTop()) - getPaddingBottom();
        View view = this.v;
        if (view != null && view.getVisibility() != 8) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.v.getLayoutParams();
            int i5 = z3 ? marginLayoutParams.rightMargin : marginLayoutParams.leftMargin;
            int i6 = z3 ? marginLayoutParams.leftMargin : marginLayoutParams.rightMargin;
            int i7 = z3 ? paddingRight - i5 : paddingRight + i5;
            int iG = g(this.v, i7, paddingTop, paddingTop2, z3) + i7;
            paddingRight = z3 ? iG - i6 : iG + i6;
        }
        LinearLayout linearLayout = this.y;
        if (linearLayout != null && this.x == null && linearLayout.getVisibility() != 8) {
            paddingRight += g(this.y, paddingRight, paddingTop, paddingTop2, z3);
        }
        View view2 = this.x;
        if (view2 != null) {
            g(view2, paddingRight, paddingTop, paddingTop2, z3);
        }
        int paddingLeft = z3 ? getPaddingLeft() : (i3 - i) - getPaddingRight();
        ActionMenuView actionMenuView = this.n;
        if (actionMenuView != null) {
            g(actionMenuView, paddingLeft, paddingTop, paddingTop2, !z3);
        }
    }

    @Override // android.view.View
    public final void onMeasure(int i, int i2) {
        if (View.MeasureSpec.getMode(i) != 1073741824) {
            throw new IllegalStateException(getClass().getSimpleName().concat(" can only be used with android:layout_width=\"match_parent\" (or fill_parent)"));
        }
        if (View.MeasureSpec.getMode(i2) == 0) {
            throw new IllegalStateException(getClass().getSimpleName().concat(" can only be used with android:layout_height=\"wrap_content\""));
        }
        int size = View.MeasureSpec.getSize(i);
        int size2 = this.p;
        if (size2 <= 0) {
            size2 = View.MeasureSpec.getSize(i2);
        }
        int paddingBottom = getPaddingBottom() + getPaddingTop();
        int paddingLeft = (size - getPaddingLeft()) - getPaddingRight();
        int iMin = size2 - paddingBottom;
        int iMakeMeasureSpec = View.MeasureSpec.makeMeasureSpec(iMin, Integer.MIN_VALUE);
        View view = this.v;
        if (view != null) {
            int iF = f(view, paddingLeft, iMakeMeasureSpec);
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.v.getLayoutParams();
            paddingLeft = iF - (marginLayoutParams.leftMargin + marginLayoutParams.rightMargin);
        }
        ActionMenuView actionMenuView = this.n;
        if (actionMenuView != null && actionMenuView.getParent() == this) {
            paddingLeft = f(this.n, paddingLeft, iMakeMeasureSpec);
        }
        LinearLayout linearLayout = this.y;
        if (linearLayout != null && this.x == null) {
            if (this.D) {
                this.y.measure(View.MeasureSpec.makeMeasureSpec(0, 0), iMakeMeasureSpec);
                int measuredWidth = this.y.getMeasuredWidth();
                boolean z = measuredWidth <= paddingLeft;
                if (z) {
                    paddingLeft -= measuredWidth;
                }
                this.y.setVisibility(z ? 0 : 8);
            } else {
                paddingLeft = f(linearLayout, paddingLeft, iMakeMeasureSpec);
            }
        }
        View view2 = this.x;
        if (view2 != null) {
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            int i3 = layoutParams.width;
            int i4 = i3 != -2 ? 1073741824 : Integer.MIN_VALUE;
            if (i3 >= 0) {
                paddingLeft = Math.min(i3, paddingLeft);
            }
            int i5 = layoutParams.height;
            int i6 = i5 == -2 ? Integer.MIN_VALUE : 1073741824;
            if (i5 >= 0) {
                iMin = Math.min(i5, iMin);
            }
            this.x.measure(View.MeasureSpec.makeMeasureSpec(paddingLeft, i4), View.MeasureSpec.makeMeasureSpec(iMin, i6));
        }
        if (this.p > 0) {
            setMeasuredDimension(size, size2);
            return;
        }
        int childCount = getChildCount();
        int i7 = 0;
        for (int i8 = 0; i8 < childCount; i8++) {
            int measuredHeight = getChildAt(i8).getMeasuredHeight() + paddingBottom;
            if (measuredHeight > i7) {
                i7 = measuredHeight;
            }
        }
        setMeasuredDimension(size, i7);
    }

    @Override // android.view.View
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.r = false;
        }
        if (!this.r) {
            boolean zOnTouchEvent = super.onTouchEvent(motionEvent);
            if (actionMasked == 0 && !zOnTouchEvent) {
                this.r = true;
            }
        }
        if (actionMasked != 1 && actionMasked != 3) {
            return true;
        }
        this.r = false;
        return true;
    }

    public void setContentHeight(int i) {
        this.p = i;
    }

    public void setCustomView(View view) {
        LinearLayout linearLayout;
        View view2 = this.x;
        if (view2 != null) {
            removeView(view2);
        }
        this.x = view;
        if (view != null && (linearLayout = this.y) != null) {
            removeView(linearLayout);
            this.y = null;
        }
        if (view != null) {
            addView(view);
        }
        requestLayout();
    }

    public void setSubtitle(CharSequence charSequence) {
        this.u = charSequence;
        d();
    }

    public void setTitle(CharSequence charSequence) {
        this.t = charSequence;
        d();
        Oj0.n(this, charSequence);
    }

    public void setTitleOptional(boolean z) {
        if (z != this.D) {
            requestLayout();
        }
        this.D = z;
    }

    @Override // android.view.ViewGroup
    public final boolean shouldDelayChildPressedState() {
        return false;
    }
}
