package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.google.android.gms.common.R;
import o.C70;
import o.CO;
import o.InterfaceC1381hP;
import o.LO;
import o.YZ;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class ListMenuItemView extends LinearLayout implements InterfaceC1381hP, AbsListView.SelectionBoundsAdjuster {
    public LayoutInflater A;
    public boolean B;
    public LO l;
    public ImageView m;
    public RadioButton n;

    /* renamed from: o, reason: collision with root package name */
    public TextView f0o;
    public CheckBox p;
    public TextView q;
    public ImageView r;
    public ImageView s;
    public LinearLayout t;
    public final Drawable u;
    public final int v;
    public final Context w;
    public boolean x;
    public final Drawable y;
    public final boolean z;

    public ListMenuItemView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        C70 c70R = C70.r(getContext(), attributeSet, YZ.r, R.attr.listMenuViewStyle);
        this.u = c70R.m(5);
        TypedArray typedArray = (TypedArray) c70R.n;
        this.v = typedArray.getResourceId(1, -1);
        this.x = typedArray.getBoolean(7, false);
        this.w = context;
        this.y = c70R.m(8);
        TypedArray typedArrayObtainStyledAttributes = context.getTheme().obtainStyledAttributes(null, new int[]{android.R.attr.divider}, R.attr.dropDownListViewStyle, 0);
        this.z = typedArrayObtainStyledAttributes.hasValue(0);
        c70R.t();
        typedArrayObtainStyledAttributes.recycle();
    }

    private LayoutInflater getInflater() {
        if (this.A == null) {
            this.A = LayoutInflater.from(getContext());
        }
        return this.A;
    }

    private void setSubMenuArrowVisible(boolean z) {
        ImageView imageView = this.r;
        if (imageView != null) {
            imageView.setVisibility(z ? 0 : 8);
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:14:0x0035  */
    /* JADX WARN: Removed duplicated region for block: B:25:0x0054  */
    /* JADX WARN: Removed duplicated region for block: B:28:0x0058  */
    @Override // o.InterfaceC1381hP
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct add '--show-bad-code' argument
    */
    public final void a(o.LO r11) {
        /*
            Method dump skipped, instructions count: 315
            To view this dump add '--comments-level debug' option
        */
        throw new UnsupportedOperationException("Method not decompiled: androidx.appcompat.view.menu.ListMenuItemView.a(o.LO):void");
    }

    @Override // android.widget.AbsListView.SelectionBoundsAdjuster
    public final void adjustListItemSelectionBounds(Rect rect) {
        ImageView imageView = this.s;
        if (imageView == null || imageView.getVisibility() != 0) {
            return;
        }
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) this.s.getLayoutParams();
        rect.top = this.s.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin + rect.top;
    }

    @Override // o.InterfaceC1381hP
    public LO getItemData() {
        return this.l;
    }

    @Override // android.view.View
    public final void onFinishInflate() {
        super.onFinishInflate();
        setBackground(this.u);
        TextView textView = (TextView) findViewById(R.id.title);
        this.f0o = textView;
        int i = this.v;
        if (i != -1) {
            textView.setTextAppearance(this.w, i);
        }
        this.q = (TextView) findViewById(R.id.shortcut);
        ImageView imageView = (ImageView) findViewById(R.id.submenuarrow);
        this.r = imageView;
        if (imageView != null) {
            imageView.setImageDrawable(this.y);
        }
        this.s = (ImageView) findViewById(R.id.group_divider);
        this.t = (LinearLayout) findViewById(R.id.content);
    }

    @Override // android.widget.LinearLayout, android.view.View
    public final void onMeasure(int i, int i2) {
        if (this.m != null && this.x) {
            ViewGroup.LayoutParams layoutParams = getLayoutParams();
            LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams) this.m.getLayoutParams();
            int i3 = layoutParams.height;
            if (i3 > 0 && layoutParams2.width <= 0) {
                layoutParams2.width = i3;
            }
        }
        super.onMeasure(i, i2);
    }

    public void setCheckable(boolean z) {
        CompoundButton compoundButton;
        View view;
        if (!z && this.n == null && this.p == null) {
            return;
        }
        if ((this.l.x & 4) != 0) {
            if (this.n == null) {
                RadioButton radioButton = (RadioButton) getInflater().inflate(R.layout.abc_list_menu_item_radio, (ViewGroup) this, false);
                this.n = radioButton;
                LinearLayout linearLayout = this.t;
                if (linearLayout != null) {
                    linearLayout.addView(radioButton, -1);
                } else {
                    addView(radioButton, -1);
                }
            }
            compoundButton = this.n;
            view = this.p;
        } else {
            if (this.p == null) {
                CheckBox checkBox = (CheckBox) getInflater().inflate(R.layout.abc_list_menu_item_checkbox, (ViewGroup) this, false);
                this.p = checkBox;
                LinearLayout linearLayout2 = this.t;
                if (linearLayout2 != null) {
                    linearLayout2.addView(checkBox, -1);
                } else {
                    addView(checkBox, -1);
                }
            }
            compoundButton = this.p;
            view = this.n;
        }
        if (z) {
            compoundButton.setChecked(this.l.isChecked());
            if (compoundButton.getVisibility() != 0) {
                compoundButton.setVisibility(0);
            }
            if (view == null || view.getVisibility() == 8) {
                return;
            }
            view.setVisibility(8);
            return;
        }
        CheckBox checkBox2 = this.p;
        if (checkBox2 != null) {
            checkBox2.setVisibility(8);
        }
        RadioButton radioButton2 = this.n;
        if (radioButton2 != null) {
            radioButton2.setVisibility(8);
        }
    }

    public void setChecked(boolean z) {
        CompoundButton compoundButton;
        if ((this.l.x & 4) != 0) {
            if (this.n == null) {
                RadioButton radioButton = (RadioButton) getInflater().inflate(R.layout.abc_list_menu_item_radio, (ViewGroup) this, false);
                this.n = radioButton;
                LinearLayout linearLayout = this.t;
                if (linearLayout != null) {
                    linearLayout.addView(radioButton, -1);
                } else {
                    addView(radioButton, -1);
                }
            }
            compoundButton = this.n;
        } else {
            if (this.p == null) {
                CheckBox checkBox = (CheckBox) getInflater().inflate(R.layout.abc_list_menu_item_checkbox, (ViewGroup) this, false);
                this.p = checkBox;
                LinearLayout linearLayout2 = this.t;
                if (linearLayout2 != null) {
                    linearLayout2.addView(checkBox, -1);
                } else {
                    addView(checkBox, -1);
                }
            }
            compoundButton = this.p;
        }
        compoundButton.setChecked(z);
    }

    public void setForceShowIcon(boolean z) {
        this.B = z;
        this.x = z;
    }

    public void setGroupDividerEnabled(boolean z) {
        ImageView imageView = this.s;
        if (imageView != null) {
            imageView.setVisibility((this.z || !z) ? 8 : 0);
        }
    }

    public void setIcon(Drawable drawable) {
        CO co = this.l.n;
        boolean z = this.B;
        if (z || this.x) {
            ImageView imageView = this.m;
            if (imageView == null && drawable == null && !this.x) {
                return;
            }
            if (imageView == null) {
                ImageView imageView2 = (ImageView) getInflater().inflate(R.layout.abc_list_menu_item_icon, (ViewGroup) this, false);
                this.m = imageView2;
                LinearLayout linearLayout = this.t;
                if (linearLayout != null) {
                    linearLayout.addView(imageView2, 0);
                } else {
                    addView(imageView2, 0);
                }
            }
            if (drawable == null && !this.x) {
                this.m.setVisibility(8);
                return;
            }
            ImageView imageView3 = this.m;
            if (!z) {
                drawable = null;
            }
            imageView3.setImageDrawable(drawable);
            if (this.m.getVisibility() != 0) {
                this.m.setVisibility(0);
            }
        }
    }

    public void setTitle(CharSequence charSequence) {
        if (charSequence == null) {
            if (this.f0o.getVisibility() != 8) {
                this.f0o.setVisibility(8);
            }
        } else {
            this.f0o.setText(charSequence);
            if (this.f0o.getVisibility() != 0) {
                this.f0o.setVisibility(0);
            }
        }
    }
}
