package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import o.AbstractC0249Jp;
import o.AbstractC1060e1;
import o.BO;
import o.C0965d1;
import o.CO;
import o.E8;
import o.InterfaceC1381hP;
import o.InterfaceC1538j1;
import o.LO;
import o.YZ;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class ActionMenuItemView extends E8 implements InterfaceC1381hP, View.OnClickListener, InterfaceC1538j1 {
    public final int A;
    public int B;
    public final int C;
    public LO s;
    public CharSequence t;
    public Drawable u;
    public BO v;
    public C0965d1 w;
    public AbstractC1060e1 x;
    public boolean y;
    public boolean z;

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 0);
        Resources resources = context.getResources();
        this.y = g();
        TypedArray typedArrayObtainStyledAttributes = context.obtainStyledAttributes(attributeSet, YZ.c, 0, 0);
        this.A = typedArrayObtainStyledAttributes.getDimensionPixelSize(0, 0);
        typedArrayObtainStyledAttributes.recycle();
        this.C = (int) ((resources.getDisplayMetrics().density * 32.0f) + 0.5f);
        setOnClickListener(this);
        this.B = -1;
        setSaveEnabled(false);
    }

    @Override // o.InterfaceC1381hP
    public final void a(LO lo) {
        this.s = lo;
        setIcon(lo.getIcon());
        setTitle(lo.getTitleCondensed());
        setId(lo.a);
        setVisibility(lo.isVisible() ? 0 : 8);
        setEnabled(lo.isEnabled());
        if (lo.hasSubMenu() && this.w == null) {
            this.w = new C0965d1(this);
        }
    }

    @Override // o.InterfaceC1538j1
    public final boolean b() {
        return !TextUtils.isEmpty(getText());
    }

    @Override // o.InterfaceC1538j1
    public final boolean c() {
        return !TextUtils.isEmpty(getText()) && this.s.getIcon() == null;
    }

    public final boolean g() {
        Configuration configuration = getContext().getResources().getConfiguration();
        int i = configuration.screenWidthDp;
        int i2 = configuration.screenHeightDp;
        if (i < 480) {
            return (i >= 640 && i2 >= 480) || configuration.orientation == 2;
        }
        return true;
    }

    @Override // android.widget.TextView, android.view.View
    public CharSequence getAccessibilityClassName() {
        return Button.class.getName();
    }

    @Override // o.InterfaceC1381hP
    public LO getItemData() {
        return this.s;
    }

    public final void h() {
        boolean z = true;
        boolean z2 = !TextUtils.isEmpty(this.t);
        if (this.u != null && ((this.s.y & 4) != 4 || (!this.y && !this.z))) {
            z = false;
        }
        boolean z3 = z2 & z;
        setText(z3 ? this.t : null);
        CharSequence charSequence = this.s.q;
        if (TextUtils.isEmpty(charSequence)) {
            setContentDescription(z3 ? null : this.s.e);
        } else {
            setContentDescription(charSequence);
        }
        CharSequence charSequence2 = this.s.r;
        if (TextUtils.isEmpty(charSequence2)) {
            AbstractC0249Jp.e0(this, z3 ? null : this.s.e);
        } else {
            AbstractC0249Jp.e0(this, charSequence2);
        }
    }

    @Override // android.view.View.OnClickListener
    public final void onClick(View view) {
        BO bo = this.v;
        if (bo != null) {
            bo.c(this.s);
        }
    }

    @Override // android.widget.TextView, android.view.View
    public final void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.y = g();
        h();
    }

    @Override // o.E8, android.widget.TextView, android.view.View
    public final void onMeasure(int i, int i2) {
        int i3;
        boolean zIsEmpty = TextUtils.isEmpty(getText());
        if (!zIsEmpty && (i3 = this.B) >= 0) {
            super.setPadding(i3, getPaddingTop(), getPaddingRight(), getPaddingBottom());
        }
        super.onMeasure(i, i2);
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        int measuredWidth = getMeasuredWidth();
        int i4 = this.A;
        int iMin = mode == Integer.MIN_VALUE ? Math.min(size, i4) : i4;
        if (mode != 1073741824 && i4 > 0 && measuredWidth < iMin) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(iMin, 1073741824), i2);
        }
        if (!zIsEmpty || this.u == null) {
            return;
        }
        super.setPadding((getMeasuredWidth() - this.u.getBounds().width()) / 2, getPaddingTop(), getPaddingRight(), getPaddingBottom());
    }

    @Override // android.widget.TextView, android.view.View
    public final void onRestoreInstanceState(Parcelable parcelable) {
        super.onRestoreInstanceState(null);
    }

    @Override // android.widget.TextView, android.view.View
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        C0965d1 c0965d1;
        if (this.s.hasSubMenu() && (c0965d1 = this.w) != null && c0965d1.onTouch(this, motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setExpandedFormat(boolean z) {
        if (this.z != z) {
            this.z = z;
            LO lo = this.s;
            if (lo != null) {
                CO co = lo.n;
                co.k = true;
                co.p(true);
            }
        }
    }

    public void setIcon(Drawable drawable) {
        this.u = drawable;
        if (drawable != null) {
            int intrinsicWidth = drawable.getIntrinsicWidth();
            int intrinsicHeight = drawable.getIntrinsicHeight();
            int i = this.C;
            if (intrinsicWidth > i) {
                intrinsicHeight = (int) (intrinsicHeight * (i / intrinsicWidth));
                intrinsicWidth = i;
            }
            if (intrinsicHeight > i) {
                intrinsicWidth = (int) (intrinsicWidth * (i / intrinsicHeight));
            } else {
                i = intrinsicHeight;
            }
            drawable.setBounds(0, 0, intrinsicWidth, i);
        }
        setCompoundDrawables(drawable, null, null, null);
        h();
    }

    public void setItemInvoker(BO bo) {
        this.v = bo;
    }

    @Override // android.widget.TextView, android.view.View
    public final void setPadding(int i, int i2, int i3, int i4) {
        this.B = i;
        super.setPadding(i, i2, i3, i4);
    }

    public void setPopupCallback(AbstractC1060e1 abstractC1060e1) {
        this.x = abstractC1060e1;
    }

    public void setTitle(CharSequence charSequence) {
        this.t = charSequence;
        h();
    }

    public void setCheckable(boolean z) {
    }

    public void setChecked(boolean z) {
    }
}
