package androidx.appcompat.app;

import android.R;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import o.AbstractC0940cn0;
import o.AbstractC1918n1;
import o.B7;
import o.C0194Hm;
import o.C1510il0;
import o.C2327rM;
import o.C2404s7;
import o.C2499t7;
import o.C2680v20;
import o.C2887xC;
import o.Db0;
import o.E7;
import o.F7;
import o.IJ;
import o.InterfaceC1823m1;
import o.InterfaceC2879x7;
import o.J7;
import o.L7;
import o.R8;
import o.S7;
import o.T0;
import o.Tf0;
import o.UM;
import o.V7;
import o.Vc0;
import o.W0;
import o.Wc0;
import o.Xi0;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class AppCompatActivity extends FragmentActivity implements InterfaceC2879x7, Vc0 {
    private static final String DELEGATE_TAG = "androidx:appcompat";
    private F7 mDelegate;
    private Resources mResources;

    public AppCompatActivity() {
        getSavedStateRegistry().c(DELEGATE_TAG, new C2404s7(this));
        addOnContextAvailableListener(new C2499t7(this));
    }

    @Override // androidx.activity.ComponentActivity, android.app.Activity
    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        initializeViewTreeOwners();
        S7 s7 = (S7) getDelegate();
        s7.w();
        ((ViewGroup) s7.L.findViewById(R.id.content)).addView(view, layoutParams);
        s7.x.a(s7.w.getCallback());
    }

    @Override // android.app.Activity, android.view.ContextThemeWrapper, android.content.ContextWrapper
    public void attachBaseContext(Context context) {
        Configuration configuration;
        S7 s7 = (S7) getDelegate();
        s7.Z = true;
        int i = s7.d0;
        if (i == -100) {
            i = F7.m;
        }
        int iC = s7.C(context, i);
        int i2 = 0;
        if (F7.b(context) && F7.b(context)) {
            if (Build.VERSION.SDK_INT < 33) {
                synchronized (F7.t) {
                    try {
                        C2327rM c2327rM = F7.n;
                        if (c2327rM == null) {
                            if (F7.f114o == null) {
                                F7.f114o = C2327rM.a(IJ.A(context));
                            }
                            if (!F7.f114o.a.a.isEmpty()) {
                                F7.n = F7.f114o;
                            }
                        } else if (!c2327rM.equals(F7.f114o)) {
                            C2327rM c2327rM2 = F7.n;
                            F7.f114o = c2327rM2;
                            IJ.z(context, c2327rM2.a.a.toLanguageTags());
                        }
                    } finally {
                    }
                }
            } else if (!F7.q) {
                F7.l.execute(new B7(context, i2));
            }
        }
        C2327rM c2327rMO = S7.o(context);
        if (context instanceof ContextThemeWrapper) {
            try {
                ((ContextThemeWrapper) context).applyOverrideConfiguration(S7.t(context, iC, c2327rMO, null, false));
            } catch (IllegalStateException unused) {
            }
        } else if (context instanceof C0194Hm) {
            try {
                ((C0194Hm) context).a(S7.t(context, iC, c2327rMO, null, false));
            } catch (IllegalStateException unused2) {
            }
        } else if (S7.u0) {
            Configuration configuration2 = new Configuration();
            configuration2.uiMode = -1;
            configuration2.fontScale = 0.0f;
            Configuration configuration3 = context.createConfigurationContext(configuration2).getResources().getConfiguration();
            Configuration configuration4 = context.getResources().getConfiguration();
            configuration3.uiMode = configuration4.uiMode;
            if (configuration3.equals(configuration4)) {
                configuration = null;
            } else {
                configuration = new Configuration();
                configuration.fontScale = 0.0f;
                if (configuration3.diff(configuration4) != 0) {
                    float f = configuration3.fontScale;
                    float f2 = configuration4.fontScale;
                    if (f != f2) {
                        configuration.fontScale = f2;
                    }
                    int i3 = configuration3.mcc;
                    int i4 = configuration4.mcc;
                    if (i3 != i4) {
                        configuration.mcc = i4;
                    }
                    int i5 = configuration3.mnc;
                    int i6 = configuration4.mnc;
                    if (i5 != i6) {
                        configuration.mnc = i6;
                    }
                    int i7 = Build.VERSION.SDK_INT;
                    L7.a(configuration3, configuration4, configuration);
                    int i8 = configuration3.touchscreen;
                    int i9 = configuration4.touchscreen;
                    if (i8 != i9) {
                        configuration.touchscreen = i9;
                    }
                    int i10 = configuration3.keyboard;
                    int i11 = configuration4.keyboard;
                    if (i10 != i11) {
                        configuration.keyboard = i11;
                    }
                    int i12 = configuration3.keyboardHidden;
                    int i13 = configuration4.keyboardHidden;
                    if (i12 != i13) {
                        configuration.keyboardHidden = i13;
                    }
                    int i14 = configuration3.navigation;
                    int i15 = configuration4.navigation;
                    if (i14 != i15) {
                        configuration.navigation = i15;
                    }
                    int i16 = configuration3.navigationHidden;
                    int i17 = configuration4.navigationHidden;
                    if (i16 != i17) {
                        configuration.navigationHidden = i17;
                    }
                    int i18 = configuration3.orientation;
                    int i19 = configuration4.orientation;
                    if (i18 != i19) {
                        configuration.orientation = i19;
                    }
                    int i20 = configuration3.screenLayout & 15;
                    int i21 = configuration4.screenLayout & 15;
                    if (i20 != i21) {
                        configuration.screenLayout |= i21;
                    }
                    int i22 = configuration3.screenLayout & 192;
                    int i23 = configuration4.screenLayout & 192;
                    if (i22 != i23) {
                        configuration.screenLayout |= i23;
                    }
                    int i24 = configuration3.screenLayout & 48;
                    int i25 = configuration4.screenLayout & 48;
                    if (i24 != i25) {
                        configuration.screenLayout |= i25;
                    }
                    int i26 = configuration3.screenLayout & 768;
                    int i27 = configuration4.screenLayout & 768;
                    if (i26 != i27) {
                        configuration.screenLayout |= i27;
                    }
                    if (i7 >= 26) {
                        if ((configuration3.colorMode & 3) != (configuration4.colorMode & 3)) {
                            configuration.colorMode |= configuration4.colorMode & 3;
                        }
                        if ((configuration3.colorMode & 12) != (configuration4.colorMode & 12)) {
                            configuration.colorMode |= configuration4.colorMode & 12;
                        }
                    }
                    int i28 = configuration3.uiMode & 15;
                    int i29 = configuration4.uiMode & 15;
                    if (i28 != i29) {
                        configuration.uiMode |= i29;
                    }
                    int i30 = configuration3.uiMode & 48;
                    int i31 = configuration4.uiMode & 48;
                    if (i30 != i31) {
                        configuration.uiMode |= i31;
                    }
                    int i32 = configuration3.screenWidthDp;
                    int i33 = configuration4.screenWidthDp;
                    if (i32 != i33) {
                        configuration.screenWidthDp = i33;
                    }
                    int i34 = configuration3.screenHeightDp;
                    int i35 = configuration4.screenHeightDp;
                    if (i34 != i35) {
                        configuration.screenHeightDp = i35;
                    }
                    int i36 = configuration3.smallestScreenWidthDp;
                    int i37 = configuration4.smallestScreenWidthDp;
                    if (i36 != i37) {
                        configuration.smallestScreenWidthDp = i37;
                    }
                    int i38 = configuration3.densityDpi;
                    int i39 = configuration4.densityDpi;
                    if (i38 != i39) {
                        configuration.densityDpi = i39;
                    }
                }
            }
            Configuration configurationT = S7.t(context, iC, c2327rMO, configuration, true);
            C0194Hm c0194Hm = new C0194Hm(context, com.google.android.gms.common.R.style.Theme_AppCompat_Empty);
            c0194Hm.a(configurationT);
            try {
                if (context.getTheme() != null) {
                    Resources.Theme theme = c0194Hm.getTheme();
                    if (Build.VERSION.SDK_INT >= 29) {
                        R8.k(theme);
                    } else {
                        synchronized (AbstractC0940cn0.e) {
                            if (!AbstractC0940cn0.g) {
                                try {
                                    Method declaredMethod = Resources.Theme.class.getDeclaredMethod("rebase", null);
                                    AbstractC0940cn0.f = declaredMethod;
                                    declaredMethod.setAccessible(true);
                                } catch (NoSuchMethodException unused3) {
                                }
                                AbstractC0940cn0.g = true;
                            }
                            Method method = AbstractC0940cn0.f;
                            if (method != null) {
                                try {
                                    method.invoke(theme, null);
                                } catch (IllegalAccessException | InvocationTargetException unused4) {
                                    AbstractC0940cn0.f = null;
                                }
                            }
                        }
                    }
                }
            } catch (NullPointerException unused5) {
            }
            context = c0194Hm;
        }
        super.attachBaseContext(context);
    }

    @Override // android.app.Activity
    public void closeOptionsMenu() throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        T0 supportActionBar = getSupportActionBar();
        if (getWindow().hasFeature(0)) {
            if (supportActionBar == null || !supportActionBar.a()) {
                super.closeOptionsMenu();
            }
        }
    }

    @Override // androidx.core.app.ComponentActivity, android.app.Activity, android.view.Window.Callback
    public boolean dispatchKeyEvent(KeyEvent keyEvent) throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        int keyCode = keyEvent.getKeyCode();
        T0 supportActionBar = getSupportActionBar();
        if (keyCode == 82 && supportActionBar != null && supportActionBar.j(keyEvent)) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    @Override // android.app.Activity
    public <T extends View> T findViewById(int i) throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        S7 s7 = (S7) getDelegate();
        s7.w();
        return (T) s7.w.findViewById(i);
    }

    public F7 getDelegate() {
        if (this.mDelegate == null) {
            E7 e7 = F7.l;
            this.mDelegate = new S7(this, null, this, this);
        }
        return this.mDelegate;
    }

    public W0 getDrawerToggleDelegate() {
        ((S7) getDelegate()).getClass();
        return new J7(0);
    }

    @Override // android.app.Activity
    public MenuInflater getMenuInflater() throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        S7 s7 = (S7) getDelegate();
        if (s7.A == null) {
            s7.A();
            T0 t0 = s7.z;
            s7.A = new Db0(t0 != null ? t0.e() : s7.v);
        }
        return s7.A;
    }

    @Override // android.view.ContextThemeWrapper, android.content.ContextWrapper, android.content.Context
    public Resources getResources() {
        Resources resources = this.mResources;
        if (resources == null) {
            int i = Xi0.a;
        }
        return resources == null ? super.getResources() : resources;
    }

    public T0 getSupportActionBar() throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        S7 s7 = (S7) getDelegate();
        s7.A();
        return s7.z;
    }

    @Override // o.Vc0
    public Intent getSupportParentActivityIntent() {
        return C2887xC.p(this);
    }

    @Override // android.app.Activity
    public void invalidateOptionsMenu() {
        getDelegate().a();
    }

    @Override // androidx.activity.ComponentActivity, android.app.Activity, android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration configuration) throws IllegalAccessException, NoSuchFieldException, NoSuchMethodException, PackageManager.NameNotFoundException, SecurityException, IllegalArgumentException, InvocationTargetException {
        super.onConfigurationChanged(configuration);
        S7 s7 = (S7) getDelegate();
        if (s7.Q && s7.K) {
            s7.A();
            T0 t0 = s7.z;
            if (t0 != null) {
                t0.g();
            }
        }
        V7 v7A = V7.a();
        Context context = s7.v;
        synchronized (v7A) {
            C2680v20 c2680v20 = v7A.a;
            synchronized (c2680v20) {
                UM um = (UM) c2680v20.b.get(context);
                if (um != null) {
                    um.a();
                }
            }
        }
        s7.c0 = new Configuration(s7.v.getResources().getConfiguration());
        s7.m(false, false);
        if (this.mResources != null) {
            this.mResources.updateConfiguration(super.getResources().getConfiguration(), super.getResources().getDisplayMetrics());
        }
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public void onContentChanged() {
        onSupportContentChanged();
    }

    public void onCreateSupportNavigateUpTaskStack(Wc0 wc0) {
        ArrayList arrayList = wc0.l;
        AppCompatActivity appCompatActivity = wc0.m;
        Intent supportParentActivityIntent = getSupportParentActivityIntent();
        if (supportParentActivityIntent == null) {
            supportParentActivityIntent = C2887xC.p(this);
        }
        if (supportParentActivityIntent != null) {
            ComponentName component = supportParentActivityIntent.getComponent();
            if (component == null) {
                component = supportParentActivityIntent.resolveActivity(appCompatActivity.getPackageManager());
            }
            int size = arrayList.size();
            try {
                for (Intent intentQ = C2887xC.q(appCompatActivity, component); intentQ != null; intentQ = C2887xC.q(appCompatActivity, intentQ.getComponent())) {
                    arrayList.add(size, intentQ);
                }
                arrayList.add(supportParentActivityIntent);
            } catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Override // androidx.fragment.app.FragmentActivity, android.app.Activity
    public void onDestroy() {
        super.onDestroy();
        getDelegate().d();
    }

    @Override // android.app.Activity, android.view.KeyEvent.Callback
    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        Window window;
        if (Build.VERSION.SDK_INT >= 26 || keyEvent.isCtrlPressed() || KeyEvent.metaStateHasNoModifiers(keyEvent.getMetaState()) || keyEvent.getRepeatCount() != 0 || KeyEvent.isModifierKey(keyEvent.getKeyCode()) || (window = getWindow()) == null || window.getDecorView() == null || !window.getDecorView().dispatchKeyShortcutEvent(keyEvent)) {
            return super.onKeyDown(i, keyEvent);
        }
        return true;
    }

    @Override // androidx.fragment.app.FragmentActivity, androidx.activity.ComponentActivity, android.app.Activity, android.view.Window.Callback
    public final boolean onMenuItemSelected(int i, MenuItem menuItem) throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        if (super.onMenuItemSelected(i, menuItem)) {
            return true;
        }
        T0 supportActionBar = getSupportActionBar();
        if (menuItem.getItemId() != 16908332 || supportActionBar == null || (supportActionBar.d() & 4) == 0) {
            return false;
        }
        return onSupportNavigateUp();
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public boolean onMenuOpened(int i, Menu menu) {
        return super.onMenuOpened(i, menu);
    }

    @Override // androidx.activity.ComponentActivity, android.app.Activity, android.view.Window.Callback
    public void onPanelClosed(int i, Menu menu) {
        super.onPanelClosed(i, menu);
    }

    @Override // android.app.Activity
    public void onPostCreate(Bundle bundle) throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        super.onPostCreate(bundle);
        ((S7) getDelegate()).w();
    }

    @Override // androidx.fragment.app.FragmentActivity, android.app.Activity
    public void onPostResume() throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        super.onPostResume();
        S7 s7 = (S7) getDelegate();
        s7.A();
        T0 t0 = s7.z;
        if (t0 != null) {
            t0.m(true);
        }
    }

    @Override // androidx.fragment.app.FragmentActivity, android.app.Activity
    public void onStart() throws IllegalAccessException, NoSuchFieldException, PackageManager.NameNotFoundException, SecurityException, IllegalArgumentException {
        super.onStart();
        ((S7) getDelegate()).m(true, false);
    }

    @Override // androidx.fragment.app.FragmentActivity, android.app.Activity
    public void onStop() throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        super.onStop();
        S7 s7 = (S7) getDelegate();
        s7.A();
        T0 t0 = s7.z;
        if (t0 != null) {
            t0.m(false);
        }
    }

    public boolean onSupportNavigateUp() {
        Intent supportParentActivityIntent = getSupportParentActivityIntent();
        if (supportParentActivityIntent == null) {
            return false;
        }
        if (!supportShouldUpRecreateTask(supportParentActivityIntent)) {
            supportNavigateUpTo(supportParentActivityIntent);
            return true;
        }
        Wc0 wc0 = new Wc0(this);
        onCreateSupportNavigateUpTaskStack(wc0);
        onPrepareSupportNavigateUpTaskStack(wc0);
        ArrayList arrayList = wc0.l;
        if (arrayList.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot startActivities");
        }
        Intent[] intentArr = (Intent[]) arrayList.toArray(new Intent[0]);
        intentArr[0] = new Intent(intentArr[0]).addFlags(268484608);
        wc0.m.startActivities(intentArr, null);
        try {
            finishAffinity();
            return true;
        } catch (IllegalStateException unused) {
            finish();
            return true;
        }
    }

    @Override // android.app.Activity
    public void onTitleChanged(CharSequence charSequence, int i) {
        super.onTitleChanged(charSequence, i);
        getDelegate().j(charSequence);
    }

    @Override // o.InterfaceC2879x7
    public AbstractC1918n1 onWindowStartingSupportActionMode(InterfaceC1823m1 interfaceC1823m1) {
        return null;
    }

    @Override // android.app.Activity
    public void openOptionsMenu() throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        T0 supportActionBar = getSupportActionBar();
        if (getWindow().hasFeature(0)) {
            if (supportActionBar == null || !supportActionBar.k()) {
                super.openOptionsMenu();
            }
        }
    }

    @Override // androidx.activity.ComponentActivity, android.app.Activity
    public void setContentView(int i) {
        initializeViewTreeOwners();
        getDelegate().g(i);
    }

    public void setSupportActionBar(Toolbar toolbar) throws IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        S7 s7 = (S7) getDelegate();
        if (s7.u instanceof Activity) {
            s7.A();
            T0 t0 = s7.z;
            if (t0 instanceof C1510il0) {
                throw new IllegalStateException("This Activity already has an action bar supplied by the window decor. Do not request Window.FEATURE_SUPPORT_ACTION_BAR and set windowActionBar to false in your theme to use a Toolbar instead.");
            }
            s7.A = null;
            if (t0 != null) {
                t0.h();
            }
            s7.z = null;
            if (toolbar != null) {
                Object obj = s7.u;
                Tf0 tf0 = new Tf0(toolbar, obj instanceof Activity ? ((Activity) obj).getTitle() : s7.B, s7.x);
                s7.z = tf0;
                s7.x.m = tf0.c;
                toolbar.setBackInvokedCallbackEnabled(true);
            } else {
                s7.x.m = null;
            }
            s7.a();
        }
    }

    @Override // android.app.Activity, android.view.ContextThemeWrapper, android.content.ContextWrapper, android.content.Context
    public void setTheme(int i) {
        super.setTheme(i);
        ((S7) getDelegate()).e0 = i;
    }

    public AbstractC1918n1 startSupportActionMode(InterfaceC1823m1 interfaceC1823m1) {
        return getDelegate().k(interfaceC1823m1);
    }

    public void supportInvalidateOptionsMenu() {
        getDelegate().a();
    }

    public void supportNavigateUpTo(Intent intent) {
        navigateUpTo(intent);
    }

    public boolean supportRequestWindowFeature(int i) {
        return getDelegate().f(i);
    }

    public boolean supportShouldUpRecreateTask(Intent intent) {
        return shouldUpRecreateTask(intent);
    }

    @Override // androidx.activity.ComponentActivity, android.app.Activity
    public void setContentView(View view) {
        initializeViewTreeOwners();
        getDelegate().h(view);
    }

    @Override // androidx.activity.ComponentActivity, android.app.Activity
    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        initializeViewTreeOwners();
        getDelegate().i(view, layoutParams);
    }

    @Deprecated
    public void onSupportContentChanged() {
    }

    public void onLocalesChanged(C2327rM c2327rM) {
    }

    public void onNightModeChanged(int i) {
    }

    public void onPrepareSupportNavigateUpTaskStack(Wc0 wc0) {
    }

    @Override // o.InterfaceC2879x7
    public void onSupportActionModeFinished(AbstractC1918n1 abstractC1918n1) {
    }

    @Override // o.InterfaceC2879x7
    public void onSupportActionModeStarted(AbstractC1918n1 abstractC1918n1) {
    }

    @Deprecated
    public void setSupportProgress(int i) {
    }

    @Deprecated
    public void setSupportProgressBarIndeterminate(boolean z) {
    }

    @Deprecated
    public void setSupportProgressBarIndeterminateVisibility(boolean z) {
    }

    @Deprecated
    public void setSupportProgressBarVisibility(boolean z) {
    }
}
