package androidx.activity;

import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Trace;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.activity.ComponentActivity;
import com.google.android.gms.common.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import o.AbstractC0118Eo;
import o.AbstractC0940cn0;
import o.AbstractC1159f20;
import o.AbstractC1692kh0;
import o.AbstractC2378rs0;
import o.AbstractC2461sm0;
import o.AbstractC2772w1;
import o.AbstractC2798wI;
import o.AbstractC2841wm0;
import o.AbstractC2962y1;
import o.BQ;
import o.C0009Aj;
import o.C0061Cj;
import o.C0165Gj;
import o.C0666Zr;
import o.C0698aC;
import o.C1014dc0;
import o.C1089eL;
import o.C1125ek0;
import o.C1164f5;
import o.C1413hk0;
import o.C1640k40;
import o.C1735l40;
import o.C1830m40;
import o.C2739vj;
import o.C2807wR;
import o.C2834wj;
import o.C2935xm;
import o.C3024yj;
import o.E1;
import o.ET;
import o.F3;
import o.FO;
import o.FQ;
import o.FT;
import o.FragmentC1351h20;
import o.HO;
import o.I1;
import o.IE;
import o.IO;
import o.IT;
import o.InterfaceC0043Br;
import o.InterfaceC0707aL;
import o.InterfaceC0898cL;
import o.InterfaceC1189fP;
import o.InterfaceC1221fk0;
import o.InterfaceC1416hm;
import o.InterfaceC1508ik0;
import o.InterfaceC1925n40;
import o.InterfaceC2677v1;
import o.InterfaceC3085zK;
import o.InterfaceExecutorC0087Dj;
import o.KT;
import o.MC;
import o.NC;
import o.OT;
import o.PT;
import o.RunnableC2644uj;
import o.S00;
import o.SW;
import o.TT;
import o.UK;
import o.VK;
import o.ViewTreeObserverOnDrawListenerC0113Ej;
import o.WK;

/* compiled from: r8-map-id-3b7cc9102578c509342fa2f0fabed2bfc72239cd258d579fc679bfcbc198b048 */
/* loaded from: classes.dex */
public class ComponentActivity extends androidx.core.app.ComponentActivity implements InterfaceC1508ik0, IE, InterfaceC1925n40, FT, I1, IT, TT, OT, PT, FO {
    private static final String ACTIVITY_RESULT_TAG = "android:support:activity-result";
    private static final C0009Aj Companion = new C0009Aj();
    public static final /* synthetic */ int l = 0;
    private C1413hk0 _viewModelStore;
    private final E1 activityResultRegistry;
    private int contentLayoutId;
    private final InterfaceC3085zK defaultViewModelProviderFactory$delegate;
    private boolean dispatchingOnMultiWindowModeChanged;
    private boolean dispatchingOnPictureInPictureModeChanged;
    private final InterfaceC3085zK fullyDrawnReporter$delegate;
    private final AtomicInteger nextLocalRequestCode;
    private final InterfaceC3085zK onBackPressedDispatcher$delegate;
    private final InterfaceC3085zK onBackPressedInput$delegate;
    private final CopyOnWriteArrayList<InterfaceC1416hm> onConfigurationChangedListeners;
    private final CopyOnWriteArrayList<InterfaceC1416hm> onMultiWindowModeChangedListeners;
    private final CopyOnWriteArrayList<InterfaceC1416hm> onNewIntentListeners;
    private final CopyOnWriteArrayList<InterfaceC1416hm> onPictureInPictureModeChangedListeners;
    private final CopyOnWriteArrayList<InterfaceC1416hm> onTrimMemoryListeners;
    private final CopyOnWriteArrayList<Runnable> onUserLeaveHintListeners;
    private final InterfaceExecutorC0087Dj reportFullyDrawnExecutor;
    private final C1735l40 savedStateRegistryController;
    private final C2935xm contextAwareHelper = new C2935xm();
    private final IO menuHostHelper = new IO(new RunnableC2644uj(this, 1));

    public ComponentActivity() {
        C1830m40 c1830m40 = new C1830m40(this, new C1164f5(16, this));
        this.savedStateRegistryController = new C1735l40(c1830m40);
        this.reportFullyDrawnExecutor = new ViewTreeObserverOnDrawListenerC0113Ej(this);
        this.fullyDrawnReporter$delegate = new C1014dc0(new C2739vj(this, 1));
        this.nextLocalRequestCode = new AtomicInteger();
        this.activityResultRegistry = new C0165Gj(this);
        this.onConfigurationChangedListeners = new CopyOnWriteArrayList<>();
        this.onTrimMemoryListeners = new CopyOnWriteArrayList<>();
        this.onNewIntentListeners = new CopyOnWriteArrayList<>();
        this.onMultiWindowModeChangedListeners = new CopyOnWriteArrayList<>();
        this.onPictureInPictureModeChangedListeners = new CopyOnWriteArrayList<>();
        this.onUserLeaveHintListeners = new CopyOnWriteArrayList<>();
        this.onBackPressedInput$delegate = new C1014dc0(new C2739vj(this, 2));
        if (getLifecycle() == null) {
            throw new IllegalStateException("getLifecycle() returned null in ComponentActivity's constructor. Please make sure you are lazily constructing your Lifecycle in the first call to getLifecycle() rather than relying on field initialization.");
        }
        final int i = 0;
        getLifecycle().a(new InterfaceC0707aL(this) { // from class: o.xj
            public final /* synthetic */ ComponentActivity m;

            {
                this.m = this;
            }

            @Override // o.InterfaceC0707aL
            public final void f(InterfaceC0898cL interfaceC0898cL, UK uk) {
                Window window;
                View viewPeekDecorView;
                int i2 = i;
                ComponentActivity componentActivity = this.m;
                switch (i2) {
                    case 0:
                        int i3 = ComponentActivity.l;
                        if (uk == UK.ON_STOP && (window = componentActivity.getWindow()) != null && (viewPeekDecorView = window.peekDecorView()) != null) {
                            viewPeekDecorView.cancelPendingInputEvents();
                            break;
                        }
                        break;
                    default:
                        ComponentActivity.b(componentActivity, uk);
                        break;
                }
            }
        });
        final int i2 = 1;
        getLifecycle().a(new InterfaceC0707aL(this) { // from class: o.xj
            public final /* synthetic */ ComponentActivity m;

            {
                this.m = this;
            }

            @Override // o.InterfaceC0707aL
            public final void f(InterfaceC0898cL interfaceC0898cL, UK uk) {
                Window window;
                View viewPeekDecorView;
                int i22 = i2;
                ComponentActivity componentActivity = this.m;
                switch (i22) {
                    case 0:
                        int i3 = ComponentActivity.l;
                        if (uk == UK.ON_STOP && (window = componentActivity.getWindow()) != null && (viewPeekDecorView = window.peekDecorView()) != null) {
                            viewPeekDecorView.cancelPendingInputEvents();
                            break;
                        }
                        break;
                    default:
                        ComponentActivity.b(componentActivity, uk);
                        break;
                }
            }
        });
        getLifecycle().a(new S00(i2, this));
        c1830m40.a();
        AbstractC2378rs0.K(this);
        getSavedStateRegistry().c(ACTIVITY_RESULT_TAG, new C3024yj(0, this));
        addOnContextAvailableListener(new KT() { // from class: o.zj
            @Override // o.KT
            public final void a(ComponentActivity componentActivity) {
                ComponentActivity.d(this.a);
            }
        });
        this.defaultViewModelProviderFactory$delegate = new C1014dc0(new C2739vj(this, 3));
        this.onBackPressedDispatcher$delegate = new C1014dc0(new C2739vj(this, 4));
    }

    public static Bundle a(ComponentActivity componentActivity) {
        Bundle bundle = new Bundle();
        E1 e1 = componentActivity.activityResultRegistry;
        e1.getClass();
        LinkedHashMap linkedHashMap = e1.b;
        bundle.putIntegerArrayList("KEY_COMPONENT_ACTIVITY_REGISTERED_RCS", new ArrayList<>(linkedHashMap.values()));
        bundle.putStringArrayList("KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS", new ArrayList<>(linkedHashMap.keySet()));
        bundle.putStringArrayList("KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS", new ArrayList<>(e1.d));
        bundle.putBundle("KEY_COMPONENT_ACTIVITY_PENDING_RESULT", new Bundle(e1.g));
        return bundle;
    }

    public static final void access$ensureViewModelStore(ComponentActivity componentActivity) {
        if (componentActivity._viewModelStore == null) {
            C0061Cj c0061Cj = (C0061Cj) componentActivity.getLastNonConfigurationInstance();
            if (c0061Cj != null) {
                componentActivity._viewModelStore = c0061Cj.b;
            }
            if (componentActivity._viewModelStore == null) {
                componentActivity._viewModelStore = new C1413hk0();
            }
        }
    }

    public static void b(ComponentActivity componentActivity, UK uk) {
        if (uk == UK.ON_DESTROY) {
            componentActivity.contextAwareHelper.b = null;
            if (!componentActivity.isChangingConfigurations()) {
                componentActivity.getViewModelStore().a();
            }
            ViewTreeObserverOnDrawListenerC0113Ej viewTreeObserverOnDrawListenerC0113Ej = (ViewTreeObserverOnDrawListenerC0113Ej) componentActivity.reportFullyDrawnExecutor;
            ComponentActivity componentActivity2 = viewTreeObserverOnDrawListenerC0113Ej.f108o;
            componentActivity2.getWindow().getDecorView().removeCallbacks(viewTreeObserverOnDrawListenerC0113Ej);
            componentActivity2.getWindow().getDecorView().getViewTreeObserver().removeOnDrawListener(viewTreeObserverOnDrawListenerC0113Ej);
        }
    }

    public static void c(ComponentActivity componentActivity) {
        try {
            super.onBackPressed();
        } catch (IllegalStateException e) {
            if (!F3.c(e.getMessage(), "Can not perform this action after onSaveInstanceState")) {
                throw e;
            }
        } catch (NullPointerException e2) {
            if (!F3.c(e2.getMessage(), "Attempt to invoke virtual method 'android.os.Handler android.app.FragmentHostCallback.getHandler()' on a null object reference")) {
                throw e2;
            }
        }
    }

    public static void d(ComponentActivity componentActivity) {
        Bundle bundleA = componentActivity.getSavedStateRegistry().a(ACTIVITY_RESULT_TAG);
        if (bundleA != null) {
            E1 e1 = componentActivity.activityResultRegistry;
            LinkedHashMap linkedHashMap = e1.b;
            LinkedHashMap linkedHashMap2 = e1.a;
            Bundle bundle = e1.g;
            ArrayList<Integer> integerArrayList = bundleA.getIntegerArrayList("KEY_COMPONENT_ACTIVITY_REGISTERED_RCS");
            ArrayList<String> stringArrayList = bundleA.getStringArrayList("KEY_COMPONENT_ACTIVITY_REGISTERED_KEYS");
            if (stringArrayList == null || integerArrayList == null) {
                return;
            }
            ArrayList<String> stringArrayList2 = bundleA.getStringArrayList("KEY_COMPONENT_ACTIVITY_LAUNCHED_KEYS");
            if (stringArrayList2 != null) {
                e1.d.addAll(stringArrayList2);
            }
            Bundle bundle2 = bundleA.getBundle("KEY_COMPONENT_ACTIVITY_PENDING_RESULT");
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
            int size = stringArrayList.size();
            for (int i = 0; i < size; i++) {
                String str = stringArrayList.get(i);
                if (linkedHashMap.containsKey(str)) {
                    Integer num = (Integer) linkedHashMap.remove(str);
                    if (!bundle.containsKey(str)) {
                        AbstractC1692kh0.j(linkedHashMap2).remove(num);
                    }
                }
                int iIntValue = integerArrayList.get(i).intValue();
                String str2 = stringArrayList.get(i);
                linkedHashMap2.put(Integer.valueOf(iIntValue), str2);
                e1.b.put(str2, Integer.valueOf(iIntValue));
            }
        }
    }

    @Override // android.app.Activity
    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        initializeViewTreeOwners();
        ((ViewTreeObserverOnDrawListenerC0113Ej) this.reportFullyDrawnExecutor).a(getWindow().getDecorView());
        super.addContentView(view, layoutParams);
    }

    @Override // o.FO
    public void addMenuProvider(InterfaceC1189fP interfaceC1189fP) {
        IO io = this.menuHostHelper;
        io.b.add(interfaceC1189fP);
        io.a.run();
    }

    @Override // o.IT
    public final void addOnConfigurationChangedListener(InterfaceC1416hm interfaceC1416hm) {
        this.onConfigurationChangedListeners.add(interfaceC1416hm);
    }

    public final void addOnContextAvailableListener(KT kt) {
        C2935xm c2935xm = this.contextAwareHelper;
        ComponentActivity componentActivity = c2935xm.b;
        if (componentActivity != null) {
            kt.a(componentActivity);
        }
        c2935xm.a.add(kt);
    }

    @Override // o.OT
    public final void addOnMultiWindowModeChangedListener(InterfaceC1416hm interfaceC1416hm) {
        this.onMultiWindowModeChangedListeners.add(interfaceC1416hm);
    }

    public final void addOnNewIntentListener(InterfaceC1416hm interfaceC1416hm) {
        this.onNewIntentListeners.add(interfaceC1416hm);
    }

    @Override // o.PT
    public final void addOnPictureInPictureModeChangedListener(InterfaceC1416hm interfaceC1416hm) {
        this.onPictureInPictureModeChangedListeners.add(interfaceC1416hm);
    }

    @Override // o.TT
    public final void addOnTrimMemoryListener(InterfaceC1416hm interfaceC1416hm) {
        this.onTrimMemoryListeners.add(interfaceC1416hm);
    }

    public final void addOnUserLeaveHintListener(Runnable runnable) {
        this.onUserLeaveHintListeners.add(runnable);
    }

    @Override // o.I1
    public final E1 getActivityResultRegistry() {
        return this.activityResultRegistry;
    }

    @Override // o.IE
    public AbstractC0118Eo getDefaultViewModelCreationExtras() {
        FQ fq = new FQ(0);
        if (getApplication() != null) {
            fq.a(C1125ek0.d, getApplication());
        }
        fq.a(AbstractC2378rs0.f, this);
        fq.a(AbstractC2378rs0.g, this);
        Intent intent = getIntent();
        Bundle extras = intent != null ? intent.getExtras() : null;
        if (extras != null) {
            fq.a(AbstractC2378rs0.h, extras);
        }
        return fq;
    }

    public InterfaceC1221fk0 getDefaultViewModelProviderFactory() {
        return (InterfaceC1221fk0) this.defaultViewModelProviderFactory$delegate.getValue();
    }

    public MC getFullyDrawnReporter() {
        return (MC) this.fullyDrawnReporter$delegate.getValue();
    }

    @InterfaceC0043Br
    public Object getLastCustomNonConfigurationInstance() {
        C0061Cj c0061Cj = (C0061Cj) getLastNonConfigurationInstance();
        if (c0061Cj != null) {
            return c0061Cj.a;
        }
        return null;
    }

    @Override // androidx.core.app.ComponentActivity, o.InterfaceC0898cL
    public WK getLifecycle() {
        return super.getLifecycle();
    }

    public C2807wR getNavigationEventDispatcher() {
        return getOnBackPressedDispatcher().b;
    }

    @Override // o.FT
    public final ET getOnBackPressedDispatcher() {
        return (ET) this.onBackPressedDispatcher$delegate.getValue();
    }

    @Override // o.InterfaceC1925n40
    public final C1640k40 getSavedStateRegistry() {
        return this.savedStateRegistryController.b;
    }

    @Override // o.InterfaceC1508ik0
    public C1413hk0 getViewModelStore() {
        if (getApplication() == null) {
            throw new IllegalStateException("Your activity is not yet attached to the Application instance. You can't request ViewModel before onCreate call.");
        }
        if (this._viewModelStore == null) {
            C0061Cj c0061Cj = (C0061Cj) getLastNonConfigurationInstance();
            if (c0061Cj != null) {
                this._viewModelStore = c0061Cj.b;
            }
            if (this._viewModelStore == null) {
                this._viewModelStore = new C1413hk0();
            }
        }
        return this._viewModelStore;
    }

    public void initializeViewTreeOwners() {
        AbstractC2461sm0.D(getWindow().getDecorView(), this);
        AbstractC0940cn0.G(getWindow().getDecorView(), this);
        AbstractC2841wm0.C(getWindow().getDecorView(), this);
        getWindow().getDecorView().setTag(R.id.view_tree_on_back_pressed_dispatcher_owner, this);
        getWindow().getDecorView().setTag(R.id.report_drawn, this);
        getWindow().getDecorView().setTag(R.id.view_tree_navigation_event_dispatcher_owner, this);
    }

    public void invalidateMenu() {
        invalidateOptionsMenu();
    }

    @Override // android.app.Activity
    public void onActivityResult(int i, int i2, Intent intent) {
        if (this.activityResultRegistry.a(i, i2, intent)) {
            return;
        }
        super.onActivityResult(i, i2, intent);
    }

    @Override // android.app.Activity
    @InterfaceC0043Br
    public void onBackPressed() {
        ((C0666Zr) this.onBackPressedInput$delegate.getValue()).a();
    }

    @Override // android.app.Activity, android.content.ComponentCallbacks
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        Iterator<InterfaceC1416hm> it = this.onConfigurationChangedListeners.iterator();
        while (it.hasNext()) {
            it.next().accept(configuration);
        }
    }

    @Override // androidx.core.app.ComponentActivity, android.app.Activity
    public void onCreate(Bundle bundle) {
        this.savedStateRegistryController.a(bundle);
        C2935xm c2935xm = this.contextAwareHelper;
        c2935xm.b = this;
        Iterator it = c2935xm.a.iterator();
        while (it.hasNext()) {
            ((KT) it.next()).a(this);
        }
        super.onCreate(bundle);
        int i = FragmentC1351h20.m;
        AbstractC1159f20.b(this);
        int i2 = this.contentLayoutId;
        if (i2 != 0) {
            setContentView(i2);
        }
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public boolean onCreatePanelMenu(int i, Menu menu) {
        if (i != 0) {
            return true;
        }
        super.onCreatePanelMenu(i, menu);
        IO io = this.menuHostHelper;
        MenuInflater menuInflater = getMenuInflater();
        Iterator it = io.b.iterator();
        while (it.hasNext()) {
            ((C0698aC) ((InterfaceC1189fP) it.next())).a.j(menu, menuInflater);
        }
        return true;
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public boolean onMenuItemSelected(int i, MenuItem menuItem) {
        if (super.onMenuItemSelected(i, menuItem)) {
            return true;
        }
        if (i == 0) {
            return this.menuHostHelper.a(menuItem);
        }
        return false;
    }

    @Override // android.app.Activity
    @InterfaceC0043Br
    public void onMultiWindowModeChanged(boolean z) {
        if (this.dispatchingOnMultiWindowModeChanged) {
            return;
        }
        Iterator<InterfaceC1416hm> it = this.onMultiWindowModeChangedListeners.iterator();
        while (it.hasNext()) {
            it.next().accept(new BQ(z));
        }
    }

    @Override // android.app.Activity
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Iterator<InterfaceC1416hm> it = this.onNewIntentListeners.iterator();
        while (it.hasNext()) {
            it.next().accept(intent);
        }
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public void onPanelClosed(int i, Menu menu) {
        Iterator it = this.menuHostHelper.b.iterator();
        while (it.hasNext()) {
            ((C0698aC) ((InterfaceC1189fP) it.next())).a.p(menu);
        }
        super.onPanelClosed(i, menu);
    }

    @Override // android.app.Activity
    @InterfaceC0043Br
    public void onPictureInPictureModeChanged(boolean z) {
        if (this.dispatchingOnPictureInPictureModeChanged) {
            return;
        }
        Iterator<InterfaceC1416hm> it = this.onPictureInPictureModeChangedListeners.iterator();
        while (it.hasNext()) {
            it.next().accept(new SW(z));
        }
    }

    @Override // android.app.Activity, android.view.Window.Callback
    public boolean onPreparePanel(int i, View view, Menu menu) {
        if (i != 0) {
            return true;
        }
        super.onPreparePanel(i, view, menu);
        Iterator it = this.menuHostHelper.b.iterator();
        while (it.hasNext()) {
            ((C0698aC) ((InterfaceC1189fP) it.next())).a.s(menu);
        }
        return true;
    }

    @Override // android.app.Activity
    public void onRequestPermissionsResult(int i, String[] strArr, int[] iArr) {
        if (this.activityResultRegistry.a(i, -1, new Intent().putExtra("androidx.activity.result.contract.extra.PERMISSIONS", strArr).putExtra("androidx.activity.result.contract.extra.PERMISSION_GRANT_RESULTS", iArr))) {
            return;
        }
        super.onRequestPermissionsResult(i, strArr, iArr);
    }

    @InterfaceC0043Br
    public Object onRetainCustomNonConfigurationInstance() {
        return null;
    }

    @Override // android.app.Activity
    public final Object onRetainNonConfigurationInstance() {
        C0061Cj c0061Cj;
        Object objOnRetainCustomNonConfigurationInstance = onRetainCustomNonConfigurationInstance();
        C1413hk0 c1413hk0 = this._viewModelStore;
        if (c1413hk0 == null && (c0061Cj = (C0061Cj) getLastNonConfigurationInstance()) != null) {
            c1413hk0 = c0061Cj.b;
        }
        if (c1413hk0 == null && objOnRetainCustomNonConfigurationInstance == null) {
            return null;
        }
        C0061Cj c0061Cj2 = new C0061Cj();
        c0061Cj2.a = objOnRetainCustomNonConfigurationInstance;
        c0061Cj2.b = c1413hk0;
        return c0061Cj2;
    }

    @Override // androidx.core.app.ComponentActivity, android.app.Activity
    public void onSaveInstanceState(Bundle bundle) {
        if (getLifecycle() instanceof C1089eL) {
            C1089eL c1089eL = (C1089eL) getLifecycle();
            c1089eL.e("setCurrentState");
            c1089eL.g(VK.n);
        }
        super.onSaveInstanceState(bundle);
        this.savedStateRegistryController.b(bundle);
    }

    @Override // android.app.Activity, android.content.ComponentCallbacks2
    public void onTrimMemory(int i) {
        super.onTrimMemory(i);
        Iterator<InterfaceC1416hm> it = this.onTrimMemoryListeners.iterator();
        while (it.hasNext()) {
            it.next().accept(Integer.valueOf(i));
        }
    }

    @Override // android.app.Activity
    public void onUserLeaveHint() {
        super.onUserLeaveHint();
        Iterator<Runnable> it = this.onUserLeaveHintListeners.iterator();
        while (it.hasNext()) {
            it.next().run();
        }
    }

    public Context peekAvailableContext() {
        return this.contextAwareHelper.b;
    }

    public final <I, O> AbstractC2962y1 registerForActivityResult(AbstractC2772w1 abstractC2772w1, E1 e1, InterfaceC2677v1 interfaceC2677v1) {
        return e1.d("activity_rq#" + this.nextLocalRequestCode.getAndIncrement(), this, abstractC2772w1, interfaceC2677v1);
    }

    @Override // o.FO
    public void removeMenuProvider(InterfaceC1189fP interfaceC1189fP) {
        this.menuHostHelper.b(interfaceC1189fP);
    }

    @Override // o.IT
    public final void removeOnConfigurationChangedListener(InterfaceC1416hm interfaceC1416hm) {
        this.onConfigurationChangedListeners.remove(interfaceC1416hm);
    }

    public final void removeOnContextAvailableListener(KT kt) {
        this.contextAwareHelper.a.remove(kt);
    }

    @Override // o.OT
    public final void removeOnMultiWindowModeChangedListener(InterfaceC1416hm interfaceC1416hm) {
        this.onMultiWindowModeChangedListeners.remove(interfaceC1416hm);
    }

    public final void removeOnNewIntentListener(InterfaceC1416hm interfaceC1416hm) {
        this.onNewIntentListeners.remove(interfaceC1416hm);
    }

    @Override // o.PT
    public final void removeOnPictureInPictureModeChangedListener(InterfaceC1416hm interfaceC1416hm) {
        this.onPictureInPictureModeChangedListeners.remove(interfaceC1416hm);
    }

    @Override // o.TT
    public final void removeOnTrimMemoryListener(InterfaceC1416hm interfaceC1416hm) {
        this.onTrimMemoryListeners.remove(interfaceC1416hm);
    }

    public final void removeOnUserLeaveHintListener(Runnable runnable) {
        this.onUserLeaveHintListeners.remove(runnable);
    }

    @Override // android.app.Activity
    public void reportFullyDrawn() {
        try {
            if (AbstractC2798wI.p()) {
                AbstractC2798wI.f("reportFullyDrawn() for ComponentActivity");
            }
            super.reportFullyDrawn();
            MC fullyDrawnReporter = getFullyDrawnReporter();
            synchronized (fullyDrawnReporter.a) {
                try {
                    fullyDrawnReporter.b = true;
                    ArrayList arrayList = fullyDrawnReporter.c;
                    int size = arrayList.size();
                    int i = 0;
                    while (i < size) {
                        Object obj = arrayList.get(i);
                        i++;
                        ((NC) obj).a();
                    }
                    fullyDrawnReporter.c.clear();
                } finally {
                }
            }
            Trace.endSection();
        } catch (Throwable th) {
            Trace.endSection();
            throw th;
        }
    }

    @Override // android.app.Activity
    public void setContentView(int i) {
        initializeViewTreeOwners();
        ((ViewTreeObserverOnDrawListenerC0113Ej) this.reportFullyDrawnExecutor).a(getWindow().getDecorView());
        super.setContentView(i);
    }

    @Override // android.app.Activity
    @InterfaceC0043Br
    public void startActivityForResult(Intent intent, int i) {
        super.startActivityForResult(intent, i);
    }

    @Override // android.app.Activity
    @InterfaceC0043Br
    public void startIntentSenderForResult(IntentSender intentSender, int i, Intent intent, int i2, int i3, int i4) throws IntentSender.SendIntentException {
        super.startIntentSenderForResult(intentSender, i, intent, i2, i3, i4);
    }

    @Override // android.app.Activity
    @InterfaceC0043Br
    public void startActivityForResult(Intent intent, int i, Bundle bundle) {
        super.startActivityForResult(intent, i, bundle);
    }

    @Override // android.app.Activity
    @InterfaceC0043Br
    public void startIntentSenderForResult(IntentSender intentSender, int i, Intent intent, int i2, int i3, int i4, Bundle bundle) {
        super.startIntentSenderForResult(intentSender, i, intent, i2, i3, i4, bundle);
    }

    public final <I, O> AbstractC2962y1 registerForActivityResult(AbstractC2772w1 abstractC2772w1, InterfaceC2677v1 interfaceC2677v1) {
        return registerForActivityResult(abstractC2772w1, this.activityResultRegistry, interfaceC2677v1);
    }

    @Override // android.app.Activity
    public void onMultiWindowModeChanged(boolean z, Configuration configuration) {
        this.dispatchingOnMultiWindowModeChanged = true;
        try {
            super.onMultiWindowModeChanged(z, configuration);
            this.dispatchingOnMultiWindowModeChanged = false;
            Iterator<InterfaceC1416hm> it = this.onMultiWindowModeChangedListeners.iterator();
            while (it.hasNext()) {
                it.next().accept(new BQ(z));
            }
        } catch (Throwable th) {
            this.dispatchingOnMultiWindowModeChanged = false;
            throw th;
        }
    }

    @Override // android.app.Activity
    public void onPictureInPictureModeChanged(boolean z, Configuration configuration) {
        this.dispatchingOnPictureInPictureModeChanged = true;
        try {
            super.onPictureInPictureModeChanged(z, configuration);
            this.dispatchingOnPictureInPictureModeChanged = false;
            Iterator<InterfaceC1416hm> it = this.onPictureInPictureModeChangedListeners.iterator();
            while (it.hasNext()) {
                it.next().accept(new SW(z));
            }
        } catch (Throwable th) {
            this.dispatchingOnPictureInPictureModeChanged = false;
            throw th;
        }
    }

    @Override // android.app.Activity
    public void setContentView(View view) {
        initializeViewTreeOwners();
        ((ViewTreeObserverOnDrawListenerC0113Ej) this.reportFullyDrawnExecutor).a(getWindow().getDecorView());
        super.setContentView(view);
    }

    public void addMenuProvider(InterfaceC1189fP interfaceC1189fP, InterfaceC0898cL interfaceC0898cL) {
        IO io = this.menuHostHelper;
        io.b.add(interfaceC1189fP);
        io.a.run();
        WK lifecycle = interfaceC0898cL.getLifecycle();
        HashMap map = io.c;
        HO ho = (HO) map.remove(interfaceC1189fP);
        if (ho != null) {
            ho.a.c(ho.b);
            ho.b = null;
        }
        map.put(interfaceC1189fP, new HO(lifecycle, new C2834wj(1, io, interfaceC1189fP)));
    }

    @Override // android.app.Activity
    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        initializeViewTreeOwners();
        ((ViewTreeObserverOnDrawListenerC0113Ej) this.reportFullyDrawnExecutor).a(getWindow().getDecorView());
        super.setContentView(view, layoutParams);
    }

    public void addMenuProvider(final InterfaceC1189fP interfaceC1189fP, InterfaceC0898cL interfaceC0898cL, final VK vk) {
        final IO io = this.menuHostHelper;
        io.getClass();
        WK lifecycle = interfaceC0898cL.getLifecycle();
        HashMap map = io.c;
        HO ho = (HO) map.remove(interfaceC1189fP);
        if (ho != null) {
            ho.a.c(ho.b);
            ho.b = null;
        }
        map.put(interfaceC1189fP, new HO(lifecycle, new InterfaceC0707aL() { // from class: o.GO
            @Override // o.InterfaceC0707aL
            public final void f(InterfaceC0898cL interfaceC0898cL2, UK uk) {
                IO io2 = io;
                io2.getClass();
                Runnable runnable = io2.a;
                CopyOnWriteArrayList copyOnWriteArrayList = io2.b;
                UK.Companion.getClass();
                VK vk2 = vk;
                int iOrdinal = vk2.ordinal();
                UK uk2 = null;
                UK uk3 = iOrdinal != 2 ? iOrdinal != 3 ? iOrdinal != 4 ? null : UK.ON_RESUME : UK.ON_START : UK.ON_CREATE;
                InterfaceC1189fP interfaceC1189fP2 = interfaceC1189fP;
                if (uk == uk3) {
                    copyOnWriteArrayList.add(interfaceC1189fP2);
                    runnable.run();
                    return;
                }
                UK uk4 = UK.ON_DESTROY;
                if (uk == uk4) {
                    io2.b(interfaceC1189fP2);
                    return;
                }
                int iOrdinal2 = vk2.ordinal();
                if (iOrdinal2 == 2) {
                    uk2 = uk4;
                } else if (iOrdinal2 == 3) {
                    uk2 = UK.ON_STOP;
                } else if (iOrdinal2 == 4) {
                    uk2 = UK.ON_PAUSE;
                }
                if (uk == uk2) {
                    copyOnWriteArrayList.remove(interfaceC1189fP2);
                    runnable.run();
                }
            }
        }));
    }
}
